# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, AsyncIterator, Callable, Dict, List, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ...operations._operations import (
    build_render_get_copyright_caption_request,
    build_render_get_copyright_for_tile_request,
    build_render_get_copyright_for_world_request,
    build_render_get_copyright_from_bounding_box_request,
    build_render_get_map_attribution_request,
    build_render_get_map_state_tile_request,
    build_render_get_map_static_image_request,
    build_render_get_map_tile_request,
    build_render_get_map_tileset_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RenderOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.render.aio.MapsRenderClient`'s
        :attr:`render` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_map_tile(
        self,
        *,
        tileset_id: Union[str, _models.TilesetID],
        z: int,
        x: int,
        y: int,
        time_stamp: Optional[datetime.datetime] = None,
        tile_size: Optional[Union[str, _models.MapTileSize]] = None,
        language: Optional[str] = None,
        localized_map_view: Optional[Union[str, _models.LocalizedMapView]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Get Map Tiles API allows users to request map tiles in vector or raster formats typically
        to be integrated  into a map control or SDK. Some example tiles that can be requested are Azure
        Maps road tiles, real-time  Weather Radar tiles or the map tiles created using `Azure Maps
        Creator <https://aka.ms/amcreator>`_. By default,  Azure Maps uses vector tiles for its web map
        control (Web SDK) and Android SDK.

        :keyword tileset_id: A tileset is a collection of raster or vector data broken up into a
         uniform grid of square tiles at preset  zoom levels. Every tileset has a **tilesetId** to use
         when making requests. The **tilesetId** for tilesets created using `Azure Maps Creator
         <https://aka.ms/amcreator>`_ are generated through the  `Tileset Create API
         <https://docs.microsoft.com/en-us/rest/api/maps/tileset>`_. The ready-to-use tilesets supplied
         by Azure Maps are listed below. For example, microsoft.base. Known values are:
         "microsoft.base", "microsoft.base.labels", "microsoft.base.hybrid", "microsoft.terra.main",
         "microsoft.base.road", "microsoft.base.darkgrey", "microsoft.base.labels.road",
         "microsoft.base.labels.darkgrey", "microsoft.base.hybrid.road",
         "microsoft.base.hybrid.darkgrey", "microsoft.imagery", "microsoft.weather.radar.main",
         "microsoft.weather.infrared.main", "microsoft.traffic.absolute",
         "microsoft.traffic.absolute.main", "microsoft.traffic.relative",
         "microsoft.traffic.relative.main", "microsoft.traffic.relative.dark",
         "microsoft.traffic.delay", "microsoft.traffic.delay.main", "microsoft.traffic.reduced.main",
         and "microsoft.traffic.incident". Required.
        :paramtype tileset_id: str or ~azure.maps.render.models.TilesetID
        :keyword z: Zoom level for the desired tile.

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/en-us/azure/location-based-services/zoom-levels-and-tile-grid>`_
         for details. Required.
        :paramtype z: int
        :keyword x: X coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype x: int
        :keyword y: Y coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype y: int
        :keyword time_stamp: The desired date and time of the requested tile. This parameter must be
         specified in the standard date-time format (e.g. 2019-11-14T16:03:00-08:00), as defined by `ISO
         8601 <https://en.wikipedia.org/wiki/ISO_8601>`_. This parameter is only supported when
         tilesetId parameter is set to one of the values below.


         * microsoft.weather.infrared.main: We provide tiles up to 3 hours in the past. Tiles are
         available in 10-minute intervals. We round the timeStamp value to the nearest 10-minute time
         frame.
         * microsoft.weather.radar.main: We provide tiles up to 1.5 hours in the past and up to 2 hours
         in the future. Tiles are available in 5-minute intervals. We round the timeStamp value to the
         nearest 5-minute time frame. Default value is None.
        :paramtype time_stamp: ~datetime.datetime
        :keyword tile_size: The size of the returned map tile in pixels. Known values are: "256" and
         "512". Default value is None.
        :paramtype tile_size: str or ~azure.maps.render.models.MapTileSize
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for details. Default value
         is None.
        :paramtype language: str
        :keyword localized_map_view: The View parameter (also called the "user region" parameter)
         allows you to show the correct maps for a certain country/region for geopolitically disputed
         regions. Different countries/regions have different views of such regions, and the View
         parameter allows your application to comply with the view required by the country/region your
         application will be serving. By default, the View parameter is set to “Unified” even if you
         haven’t defined it in  the request. It is your responsibility to determine the location of your
         users, and then set the View parameter correctly for that location. Alternatively, you have the
         option to set ‘View=Auto’, which will return the map data based on the IP  address of the
         request. The View parameter in Azure Maps must be used in compliance with applicable laws,
         including those  regarding mapping, of the country/region where maps, images and other data and
         third party content that you are authorized to  access via Azure Maps is made available.
         Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views. Known values are: "AE", "AR", "BH", "IN", "IQ", "JO", "KW", "LB",
         "MA", "OM", "PK", "PS", "QA", "SA", "SY", "YE", "Auto", and "Unified". Default value is None.
        :paramtype localized_map_view: str or ~azure.maps.render.models.LocalizedMapView
        :return: Async iterator of the response bytes
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        request = build_render_get_map_tile_request(
            tileset_id=tileset_id,
            z=z,
            x=x,
            y=y,
            time_stamp=time_stamp,
            tile_size=tile_size,
            language=language,
            localized_map_view=localized_map_view,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_map_tileset(self, *, tileset_id: Union[str, _models.TilesetID], **kwargs: Any) -> _models.MapTileset:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Get Map Tileset API allows users to request metadata for a tileset.

        :keyword tileset_id: A tileset is a collection of raster or vector data broken up into a
         uniform grid of square tiles at preset  zoom levels. Every tileset has a **tilesetId** to use
         when making requests. The **tilesetId** for tilesets created using `Azure Maps Creator
         <https://aka.ms/amcreator>`_ are generated through the  `Tileset Create API
         <https://docs.microsoft.com/en-us/rest/api/maps/tileset>`_. The ready-to-use tilesets supplied
         by Azure Maps are listed below. For example, microsoft.base. Known values are:
         "microsoft.base", "microsoft.base.labels", "microsoft.base.hybrid", "microsoft.terra.main",
         "microsoft.base.road", "microsoft.base.darkgrey", "microsoft.base.labels.road",
         "microsoft.base.labels.darkgrey", "microsoft.base.hybrid.road",
         "microsoft.base.hybrid.darkgrey", "microsoft.imagery", "microsoft.weather.radar.main",
         "microsoft.weather.infrared.main", "microsoft.traffic.absolute",
         "microsoft.traffic.absolute.main", "microsoft.traffic.relative",
         "microsoft.traffic.relative.main", "microsoft.traffic.relative.dark",
         "microsoft.traffic.delay", "microsoft.traffic.delay.main", "microsoft.traffic.reduced.main",
         and "microsoft.traffic.incident". Required.
        :paramtype tileset_id: str or ~azure.maps.render.models.TilesetID
        :return: MapTileset
        :rtype: ~azure.maps.render.models.MapTileset
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.MapTileset] = kwargs.pop("cls", None)

        request = build_render_get_map_tileset_request(
            tileset_id=tileset_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("MapTileset", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_map_attribution(
        self, *, tileset_id: Union[str, _models.TilesetID], zoom: int, bounds: List[float], **kwargs: Any
    ) -> _models.MapAttribution:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The Get Map Attribution API allows users to request map copyright attribution information for a
        section of a tileset.

        :keyword tileset_id: A tileset is a collection of raster or vector data broken up into a
         uniform grid of square tiles at preset  zoom levels. Every tileset has a **tilesetId** to use
         when making requests. The **tilesetId** for tilesets created using `Azure Maps Creator
         <https://aka.ms/amcreator>`_ are generated through the  `Tileset Create API
         <https://docs.microsoft.com/en-us/rest/api/maps/tileset>`_. The ready-to-use tilesets supplied
         by Azure Maps are listed below. For example, microsoft.base. Known values are:
         "microsoft.base", "microsoft.base.labels", "microsoft.base.hybrid", "microsoft.terra.main",
         "microsoft.base.road", "microsoft.base.darkgrey", "microsoft.base.labels.road",
         "microsoft.base.labels.darkgrey", "microsoft.base.hybrid.road",
         "microsoft.base.hybrid.darkgrey", "microsoft.imagery", "microsoft.weather.radar.main",
         "microsoft.weather.infrared.main", "microsoft.traffic.absolute",
         "microsoft.traffic.absolute.main", "microsoft.traffic.relative",
         "microsoft.traffic.relative.main", "microsoft.traffic.relative.dark",
         "microsoft.traffic.delay", "microsoft.traffic.delay.main", "microsoft.traffic.reduced.main",
         and "microsoft.traffic.incident". Required.
        :paramtype tileset_id: str or ~azure.maps.render.models.TilesetID
        :keyword zoom: Zoom level for the desired map attribution. Required.
        :paramtype zoom: int
        :keyword bounds: The string that represents the rectangular area of a bounding box. The bounds
         parameter is defined by the 4 bounding box coordinates, with WGS84 longitude and latitude of
         the southwest corner followed by  WGS84 longitude and latitude of the northeast corner. The
         string is presented in the following  format: ``[SouthwestCorner_Longitude,
         SouthwestCorner_Latitude, NortheastCorner_Longitude,  NortheastCorner_Latitude]``. Required.
        :paramtype bounds: list[float]
        :return: MapAttribution
        :rtype: ~azure.maps.render.models.MapAttribution
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.MapAttribution] = kwargs.pop("cls", None)

        request = build_render_get_map_attribution_request(
            tileset_id=tileset_id,
            zoom=zoom,
            bounds=bounds,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("MapAttribution", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_map_state_tile(
        self, *, z: int, x: int, y: int, stateset_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Fetches state tiles in vector format typically to be integrated into indoor maps module of map
        control or SDK. The map control will call this API after user turns on dynamic styling (see
        `Zoom Levels and Tile Grid
        <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_\ ).

        :keyword z: Zoom level for the desired tile.

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/en-us/azure/location-based-services/zoom-levels-and-tile-grid>`_
         for details. Required.
        :paramtype z: int
        :keyword x: X coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype x: int
        :keyword y: Y coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype y: int
        :keyword stateset_id: The stateset id. Required.
        :paramtype stateset_id: str
        :return: Async iterator of the response bytes
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        request = build_render_get_map_state_tile_request(
            z=z,
            x=x,
            y=y,
            stateset_id=stateset_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_copyright_caption(
        self, format: Union[str, _models.ResponseFormat] = "json", **kwargs: Any
    ) -> _models.CopyrightCaption:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Copyrights API is designed to serve copyright information for Render Tile
        service. In addition to basic copyright for the whole map, API is serving
        specific groups of copyrights for some countries/regions.

        As an alternative to copyrights for map request, one can receive captions
        for displaying the map provider information on the map.

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.render.models.ResponseFormat
        :return: CopyrightCaption
        :rtype: ~azure.maps.render.models.CopyrightCaption
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CopyrightCaption] = kwargs.pop("cls", None)

        request = build_render_get_copyright_caption_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CopyrightCaption", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_map_static_image(
        self,
        format: Union[str, _models.RasterTileFormat] = "png",
        *,
        layer: Optional[Union[str, _models.StaticMapLayer]] = None,
        style: Optional[Union[str, _models.MapImageStyle]] = None,
        zoom: Optional[int] = None,
        center: Optional[List[float]] = None,
        bounding_box_private: Optional[List[float]] = None,
        height: Optional[int] = None,
        width: Optional[int] = None,
        language: Optional[str] = None,
        localized_map_view: Optional[Union[str, _models.LocalizedMapView]] = None,
        pins: Optional[List[str]] = None,
        path: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        The static image service renders a user-defined, rectangular image containing a map section
        using a zoom level from 0 to 20. The supported resolution range for the map image is from 1x1
        to 8192x8192. If you are deciding when to use the static image service over the map tile
        service, you may want to consider how you would like to interact with the rendered map. If the
        map contents will be relatively unchanging, a static map is a good choice. If you want to
        support a lot of zooming, panning and changing of the map content, the map tile service would
        be a better choice.

        Service also provides Image Composition functionality to get a static image back with
        additional data like; pushpins and geometry overlays with following capabilities.


        * Specify multiple pushpin styles
        * Render circle, polyline and polygon geometry types.

        Please see `How-to-Guide <https://aka.ms/AzureMapsHowToGuideImageCompositor>`_ for detailed
        examples.

        *Note* : Either **center** or **bbox** parameter must be supplied to the
        API.
        :code:`<br>`:code:`<br>`
        The supported Lat and Lon ranges when using the **bbox** parameter, are as follows:
        :code:`<br>`:code:`<br>`

        .. list-table::
           :header-rows: 1

           * - Zoom Level
             - Max Lon Range
             - Max Lat Range
           * - 0
             - 360.0
             - 170.0
           * - 1
             - 360.0
             - 170.0
           * - 2
             - 360.0
             - 170.0
           * - 3
             - 360.0
             - 170.0
           * - 4
             - 360.0
             - 170.0
           * - 5
             - 180.0
             - 85.0
           * - 6
             - 90.0
             - 42.5
           * - 7
             - 45.0
             - 21.25
           * - 8
             - 22.5
             - 10.625
           * - 9
             - 11.25
             - 5.3125
           * - 10
             - 5.625
             - 2.62625
           * - 11
             - 2.8125
             - 1.328125
           * - 12
             - 1.40625
             - 0.6640625
           * - 13
             - 0.703125
             - 0.33203125
           * - 14
             - 0.3515625
             - 0.166015625
           * - 15
             - 0.17578125
             - 0.0830078125
           * - 16
             - 0.087890625
             - 0.0415039063
           * - 17
             - 0.0439453125
             - 0.0207519531
           * - 18
             - 0.0219726563
             - 0.0103759766
           * - 19
             - 0.0109863281
             - 0.0051879883
           * - 20
             - 0.0054931641
             - 0.0025939941.

        :param format: Desired format of the response. Possible value: png. "png" Default value is
         "png".
        :type format: str or ~azure.maps.render.models.RasterTileFormat
        :keyword layer: Map layer requested. If layer is set to labels or hybrid, the format should be
         png. Known values are: "basic", "hybrid", and "labels". Default value is None.
        :paramtype layer: str or ~azure.maps.render.models.StaticMapLayer
        :keyword style: Map style to be returned. Possible values are main and dark. Known values are:
         "main" and "dark". Default value is None.
        :paramtype style: str or ~azure.maps.render.models.MapImageStyle
        :keyword zoom: Desired zoom level of the map. Zoom value must be in the range: 0-20
         (inclusive). Default value is 12.:code:`<br>`:code:`<br>`Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Default value is None.
        :paramtype zoom: int
        :keyword center: Coordinates of the center point. Format: 'lon,lat'. Projection used


         * EPSG:3857. Longitude range: -180 to 180. Latitude range: -85 to 85.

         Note: Either center or bbox are required parameters. They are
         mutually exclusive. Default value is None.
        :paramtype center: list[float]
        :keyword bounding_box_private: Bounding box. Projection used - EPSG:3857. Format : 'minLon,
         minLat,
         maxLon, maxLat'.

         Note: Either bbox or center are required
         parameters. They are mutually exclusive. It shouldn’t be used with
         height or width.

         The maximum allowed ranges for Lat and Lon are defined for each zoom level
         in the table at the top of this page. Default value is None.
        :paramtype bounding_box_private: list[float]
        :keyword height: Height of the resulting image in pixels. Range is 1 to 8192. Default
         is 512. It shouldn’t be used with bbox. Default value is None.
        :paramtype height: int
        :keyword width: Width of the resulting image in pixels. Range is 1 to 8192. Default is 512. It
         shouldn’t be used with bbox. Default value is None.
        :paramtype width: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for details. Default value
         is None.
        :paramtype language: str
        :keyword localized_map_view: The View parameter (also called the "user region" parameter)
         allows you to show the correct maps for a certain country/region for geopolitically disputed
         regions. Different countries/regions have different views of such regions, and the View
         parameter allows your application to comply with the view required by the country/region your
         application will be serving. By default, the View parameter is set to “Unified” even if you
         haven’t defined it in  the request. It is your responsibility to determine the location of your
         users, and then set the View parameter correctly for that location. Alternatively, you have the
         option to set ‘View=Auto’, which will return the map data based on the IP  address of the
         request. The View parameter in Azure Maps must be used in compliance with applicable laws,
         including those  regarding mapping, of the country/region where maps, images and other data and
         third party content that you are authorized to  access via Azure Maps is made available.
         Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views. Known values are: "AE", "AR", "BH", "IN", "IQ", "JO", "KW", "LB",
         "MA", "OM", "PK", "PS", "QA", "SA", "SY", "YE", "Auto", and "Unified". Default value is None.
        :paramtype localized_map_view: str or ~azure.maps.render.models.LocalizedMapView
        :keyword pins: Pushpin style and instances. Use this parameter to optionally add pushpins to
         the image.
         The pushpin style describes the appearance of the pushpins, and the instances specify
         the coordinates of the pushpins and optional labels for each pin. (Be sure to properly
         URL-encode values of this
         parameter since it will contain reserved characters such as pipes and punctuation.)

         The Azure Maps account S0 SKU only supports a single instance of the pins parameter. Other
         SKUs
         allow multiple instances of the pins parameter to specify multiple pin styles.

         To render a pushpin at latitude 45°N and longitude 122°W using the default built-in pushpin
         style, add the
         querystring parameter

         ``pins=default||-122 45``

         Note that the longitude comes before the latitude.
         After URL encoding this will look like

         ``pins=default%7C%7C-122+45``

         All of the examples here show the pins
         parameter without URL encoding, for clarity.

         To render a pin at multiple locations, separate each location with a pipe character. For
         example, use

         ``pins=default||-122 45|-119.5 43.2|-121.67 47.12``

         The S0 Azure Maps account SKU only allows five pushpins. Other account SKUs do not have this
         limitation.

         Style Modifiers
         ^^^^^^^^^^^^^^^

         You can modify the appearance of the pins by adding style modifiers. These are added after the
         style but before
         the locations and labels. Style modifiers each have a two-letter name. These abbreviated names
         are used to help
         reduce the length of the URL.

         To change the color of the pushpin, use the 'co' style modifier and specify the color using
         the HTML/CSS RGB color
         format which is a six-digit hexadecimal number (the three-digit form is not supported). For
         example, to use
         a deep pink color which you would specify as #FF1493 in CSS, use

         ``pins=default|coFF1493||-122 45``

         Pushpin Labels
         ^^^^^^^^^^^^^^

         To add a label to the pins, put the label in single quotes just before the coordinates. For
         example, to label
         three pins with the values '1', '2', and '3', use

         ``pins=default||'1'-122 45|'2'-119.5 43.2|'3'-121.67 47.12``

         There is a built in pushpin style called 'none' that does not display a pushpin image. You can
         use this if
         you want to display labels without any pin image. For example,

         ``pins=none||'A'-122 45|'B'-119.5 43.2``

         To change the color of the pushpin labels, use the 'lc' label color style modifier. For
         example, to use pink
         pushpins with black labels, use

         ``pins=default|coFF1493|lc000000||-122 45``

         To change the size of the labels, use the 'ls' label size style modifier. The label size
         represents the approximate
         height of the label text in pixels. For example, to increase the label size to 12, use

         ``pins=default|ls12||'A'-122 45|'B'-119 43``

         The labels are centered at the pushpin 'label anchor.' The anchor location is predefined for
         built-in pushpins and
         is at the top center of custom pushpins (see below). To override the label anchor, using the
         'la' style modifier
         and provide X and Y pixel coordinates for the anchor. These coordinates are relative to the
         top left corner of the
         pushpin image. Positive X values move the anchor to the right, and positive Y values move the
         anchor down. For example,
         to position the label anchor 10 pixels right and 4 pixels above the top left corner of the
         pushpin image,
         use

         ``pins=default|la10 -4||'A'-122 45|'B'-119 43``

         Custom Pushpins
         ^^^^^^^^^^^^^^^

         To use a custom pushpin image, use the word 'custom' as the pin style name, and then specify a
         URL after the
         location and label information. Use two pipe characters to indicate that you're done
         specifying locations and are
         starting the URL. For example,

         ``pins=custom||-122 45||http://contoso.com/pushpins/red.png``

         After URL encoding, this would look like

         ``pins=custom%7C%7C-122+45%7C%7Chttp%3A%2F%2Fcontoso.com%2Fpushpins%2Fred.png``

         By default, custom pushpin images are drawn centered at the pin coordinates. This usually
         isn't ideal as it obscures
         the location that you're trying to highlight. To override the anchor location of the pin
         image, use the 'an'
         style modifier. This uses the same format as the 'la' label anchor style modifier. For
         example, if your custom
         pin image has the tip of the pin at the top left corner of the image, you can set the anchor
         to that spot by
         using

         ``pins=custom|an0 0||-122 45||http://contoso.com/pushpins/red.png``

         Note: If you use the 'co' color modifier with a custom pushpin image, the specified color will
         replace the RGB
         channels of the pixels in the image but will leave the alpha (opacity) channel unchanged. This
         would usually
         only be done with a solid-color custom image.

         Scale, Rotation, and Opacity
         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^

         You can make pushpins and their labels larger or smaller by using the 'sc' scale style
         modifier. This is a
         value greater than zero. A value of 1 is the standard scale. Values larger than 1 will make
         the pins larger, and
         values smaller than 1 will make them smaller. For example, to draw the pushpins 50% larger
         than normal, use

         ``pins=default|sc1.5||-122 45``

         You can rotate pushpins and their labels by using the 'ro' rotation style modifier. This is a
         number of degrees
         of clockwise rotation. Use a negative number to rotate counter-clockwise. For example, to
         rotate the pushpins
         90 degrees clockwise and double their size, use

         ``pins=default|ro90|sc2||-122 45``

         You can make pushpins and their labels partially transparent by specifying the 'al' alpha
         style modifier.
         This is a number between 0 and 1 indicating the opacity of the pushpins. Zero makes them
         completely transparent
         (and not visible) and 1 makes them completely opaque (which is the default). For example, to
         make pushpins
         and their labels only 67% opaque, use

         ``pins=default|al.67||-122 45``

         Style Modifier Summary
         ^^^^^^^^^^^^^^^^^^^^^^

         .. list-table::
            :header-rows: 1

            * - Modifier
              - Description
              - Range
            * - al
              - Alpha (opacity)
              - 0 to 1
            * - an
              - Pin anchor
              - *
            * - co
              - Pin color
              - 000000 to FFFFFF
            * - la
              - Label anchor
              - *
            * - lc
              - Label color
              - 000000 to FFFFFF
            * - ls
              - Label size
              - Greater than 0
            * - ro
              - Rotation
              - -360 to 360
            * - sc
              - Scale
              - Greater than 0



         * X and Y coordinates can be anywhere within pin image or a margin around it.
           The margin size is the minimum of the pin width and height. Default value is None.
        :paramtype pins: list[str]
        :keyword path: Path style and locations. Use this parameter to optionally add lines, polygons
         or circles to the image.
         The path style describes the appearance of the line and fill. (Be sure to properly URL-encode
         values of this
         parameter since it will contain reserved characters such as pipes and punctuation.)

         Path parameter is supported in Azure Maps account SKU starting with S1. Multiple instances of
         the path parameter
         allow to specify multiple geometries with their styles. Number of parameters per request is
         limited to 10 and
         number of locations is limited to 100 per path.

         To render a circle with radius 100 meters and center point at latitude 45°N and longitude
         122°W using the default style, add the
         querystring parameter

         ``path=ra100||-122 45``

         Note that the longitude comes before the latitude.
         After URL encoding this will look like

         ``path=ra100%7C%7C-122+45``

         All of the examples here show the path parameter without URL encoding, for clarity.

         To render a line, separate each location with a pipe character. For example, use

         ``path=||-122 45|-119.5 43.2|-121.67 47.12``

         To render a polygon, last location must be equal to the start location. For example, use

         ``path=||-122 45|-119.5 43.2|-121.67 47.12|-122 45``

         Longitude and latitude values for locations of lines and polygons can be in the range from
         -360 to 360 to allow for rendering of geometries crossing the anti-meridian.

         Style Modifiers
         ^^^^^^^^^^^^^^^

         You can modify the appearance of the path by adding style modifiers. These are added before
         the locations.
         Style modifiers each have a two-letter name. These abbreviated names are used to help reduce
         the length
         of the URL.

         To change the color of the outline, use the 'lc' style modifier and specify the color using
         the HTML/CSS RGB color
         format which is a six-digit hexadecimal number (the three-digit form is not supported). For
         example, to use
         a deep pink color which you would specify as #FF1493 in CSS, use

         ``path=lcFF1493||-122 45|-119.5 43.2``

         Multiple style modifiers may be combined together to create a more complex visual style.

         ``lc0000FF|lw3|la0.60|fa0.50||-122.2 47.6|-122.2 47.7|-122.3 47.7|-122.3 47.6|-122.2 47.6``

         Style Modifier Summary
         ^^^^^^^^^^^^^^^^^^^^^^

         .. list-table::
            :header-rows: 1

            * - Modifier
              - Description
              - Range
            * - lc
              - Line color
              - 000000 to FFFFFF
            * - fc
              - Fill color
              - 000000 to FFFFFF
            * - la
              - Line alpha (opacity)
              - 0 to 1
            * - fa
              - Fill alpha (opacity)
              - 0 to 1
            * - lw
              - Line width
              - Greater than 0
            * - ra
              - Circle radius (meters)
              - Greater than 0. Default value is None.
        :paramtype path: list[str]
        :return: Async iterator of the response bytes
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        request = build_render_get_map_static_image_request(
            format=format,
            layer=layer,
            style=style,
            zoom=zoom,
            center=center,
            bounding_box_private=bounding_box_private,
            height=height,
            width=width,
            language=language,
            localized_map_view=localized_map_view,
            pins=pins,
            path=path,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_copyright_from_bounding_box(
        self,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        south_west: List[float],
        north_east: List[float],
        include_text: Optional[Union[str, _models.IncludeText]] = None,
        **kwargs: Any
    ) -> _models.Copyright:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Returns copyright information for a given bounding box. Bounding-box requests should specify
        the minimum and maximum longitude and latitude (EPSG-3857) coordinates.

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.render.models.ResponseFormat
        :keyword south_west: Minimum coordinates (south-west point) of bounding box in latitude
         longitude coordinate system. E.g. 52.41064,4.84228. Required.
        :paramtype south_west: list[float]
        :keyword north_east: Maximum coordinates (north-east point) of bounding box in latitude
         longitude coordinate system. E.g. 52.41064,4.84228. Required.
        :paramtype north_east: list[float]
        :keyword include_text: Yes/no value to exclude textual data from response. Only images and
         country/region names will be in response. Known values are: "yes" and "no". Default value is
         None.
        :paramtype include_text: str or ~azure.maps.render.models.IncludeText
        :return: Copyright
        :rtype: ~azure.maps.render.models.Copyright
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Copyright] = kwargs.pop("cls", None)

        request = build_render_get_copyright_from_bounding_box_request(
            format=format,
            south_west=south_west,
            north_east=north_east,
            include_text=include_text,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Copyright", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_copyright_for_tile(
        self,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        z: int,
        x: int,
        y: int,
        include_text: Optional[Union[str, _models.IncludeText]] = None,
        **kwargs: Any
    ) -> _models.Copyright:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Copyrights API is designed to serve copyright information for Render Tile  service. In addition
        to basic copyright for the whole map, API is serving  specific groups of copyrights for some
        countries/regions.
        Returns the copyright information for a given tile. To obtain the copyright information for a
        particular tile, the request should specify the tile's zoom level and x and y coordinates (see:
        Zoom Levels and Tile Grid).

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.render.models.ResponseFormat
        :keyword z: Zoom level for the desired tile.

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/en-us/azure/location-based-services/zoom-levels-and-tile-grid>`_
         for details. Required.
        :paramtype z: int
        :keyword x: X coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype x: int
        :keyword y: Y coordinate of the tile on zoom grid. Value must be in the range [0,
         2:code:`<sup>`zoom`</sup>` -1].

         Please see `Zoom Levels and Tile Grid
         <https://docs.microsoft.com/azure/location-based-services/zoom-levels-and-tile-grid>`_ for
         details. Required.
        :paramtype y: int
        :keyword include_text: Yes/no value to exclude textual data from response. Only images and
         country/region names will be in response. Known values are: "yes" and "no". Default value is
         None.
        :paramtype include_text: str or ~azure.maps.render.models.IncludeText
        :return: Copyright
        :rtype: ~azure.maps.render.models.Copyright
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Copyright] = kwargs.pop("cls", None)

        request = build_render_get_copyright_for_tile_request(
            format=format,
            z=z,
            x=x,
            y=y,
            include_text=include_text,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Copyright", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_copyright_for_world(
        self,
        format: Union[str, _models.ResponseFormat] = "json",
        *,
        include_text: Optional[Union[str, _models.IncludeText]] = None,
        **kwargs: Any
    ) -> _models.Copyright:
        """**Applies to:** see pricing `tiers <https://aka.ms/AzureMapsPricingTier>`_.

        Copyrights API is designed to serve copyright information for Render Tile  service. In addition
        to basic copyright for the whole map, API is serving  specific groups of copyrights for some
        countries/regions.
        Returns the copyright information for the world. To obtain the default copyright information
        for the whole world, do not specify a tile or bounding box.

        :param format: Desired format of the response. Value can be either *json* or *xml*. Known
         values are: "json" and "xml". Default value is "json".
        :type format: str or ~azure.maps.render.models.ResponseFormat
        :keyword include_text: Yes/no value to exclude textual data from response. Only images and
         country/region names will be in response. Known values are: "yes" and "no". Default value is
         None.
        :paramtype include_text: str or ~azure.maps.render.models.IncludeText
        :return: Copyright
        :rtype: ~azure.maps.render.models.Copyright
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Copyright] = kwargs.pop("cls", None)

        request = build_render_get_copyright_for_world_request(
            format=format,
            include_text=include_text,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Copyright", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
