; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=IC1 %s
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=2 -S %s | FileCheck --check-prefixes=IC2 %s

define void @switch4_default_common_dest_with_case(ptr %start, ptr %end) {
; IC1-LABEL: define void @switch4_default_common_dest_with_case(
; IC1-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) {
; IC1-NEXT:  [[ENTRY:.*]]:
; IC1-NEXT:    [[START2:%.*]] = ptrtoint ptr [[START]] to i64
; IC1-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; IC1-NEXT:    [[TMP0:%.*]] = sub i64 [[END1]], [[START2]]
; IC1-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 2
; IC1-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; IC1:       [[VECTOR_PH]]:
; IC1-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 2
; IC1-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; IC1-NEXT:    [[IND_END:%.*]] = getelementptr i8, ptr [[START]], i64 [[N_VEC]]
; IC1-NEXT:    br label %[[VECTOR_BODY:.*]]
; IC1:       [[VECTOR_BODY]]:
; IC1-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE13:.*]] ]
; IC1-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 0
; IC1-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 1
; IC1-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP1]]
; IC1-NEXT:    [[NEXT_GEP3:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP2]]
; IC1-NEXT:    [[TMP3:%.*]] = getelementptr i8, ptr [[NEXT_GEP]], i32 0
; IC1-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i8>, ptr [[TMP3]], align 1
; IC1-NEXT:    [[TMP7:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD]], splat (i8 -12)
; IC1-NEXT:    [[TMP4:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD]], splat (i8 13)
; IC1-NEXT:    [[TMP11:%.*]] = or <2 x i1> [[TMP7]], [[TMP4]]
; IC1-NEXT:    [[TMP10:%.*]] = xor <2 x i1> [[TMP11]], splat (i1 true)
; IC1-NEXT:    [[TMP5:%.*]] = extractelement <2 x i1> [[TMP4]], i32 0
; IC1-NEXT:    br i1 [[TMP5]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; IC1:       [[PRED_STORE_IF]]:
; IC1-NEXT:    store i8 0, ptr [[NEXT_GEP]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; IC1:       [[PRED_STORE_CONTINUE]]:
; IC1-NEXT:    [[TMP6:%.*]] = extractelement <2 x i1> [[TMP4]], i32 1
; IC1-NEXT:    br i1 [[TMP6]], label %[[PRED_STORE_IF4:.*]], label %[[PRED_STORE_CONTINUE5:.*]]
; IC1:       [[PRED_STORE_IF4]]:
; IC1-NEXT:    store i8 0, ptr [[NEXT_GEP3]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE5]]
; IC1:       [[PRED_STORE_CONTINUE5]]:
; IC1-NEXT:    [[TMP8:%.*]] = extractelement <2 x i1> [[TMP7]], i32 0
; IC1-NEXT:    br i1 [[TMP8]], label %[[PRED_STORE_IF6:.*]], label %[[PRED_STORE_CONTINUE7:.*]]
; IC1:       [[PRED_STORE_IF6]]:
; IC1-NEXT:    store i8 42, ptr [[NEXT_GEP]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE7]]
; IC1:       [[PRED_STORE_CONTINUE7]]:
; IC1-NEXT:    [[TMP9:%.*]] = extractelement <2 x i1> [[TMP7]], i32 1
; IC1-NEXT:    br i1 [[TMP9]], label %[[PRED_STORE_IF8:.*]], label %[[PRED_STORE_CONTINUE9:.*]]
; IC1:       [[PRED_STORE_IF8]]:
; IC1-NEXT:    store i8 42, ptr [[NEXT_GEP3]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE9]]
; IC1:       [[PRED_STORE_CONTINUE9]]:
; IC1-NEXT:    [[TMP13:%.*]] = extractelement <2 x i1> [[TMP10]], i32 0
; IC1-NEXT:    br i1 [[TMP13]], label %[[PRED_STORE_IF10:.*]], label %[[PRED_STORE_CONTINUE11:.*]]
; IC1:       [[PRED_STORE_IF10]]:
; IC1-NEXT:    store i8 2, ptr [[NEXT_GEP]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE11]]
; IC1:       [[PRED_STORE_CONTINUE11]]:
; IC1-NEXT:    [[TMP14:%.*]] = extractelement <2 x i1> [[TMP10]], i32 1
; IC1-NEXT:    br i1 [[TMP14]], label %[[PRED_STORE_IF12:.*]], label %[[PRED_STORE_CONTINUE13]]
; IC1:       [[PRED_STORE_IF12]]:
; IC1-NEXT:    store i8 2, ptr [[NEXT_GEP3]], align 1
; IC1-NEXT:    br label %[[PRED_STORE_CONTINUE13]]
; IC1:       [[PRED_STORE_CONTINUE13]]:
; IC1-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; IC1-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; IC1-NEXT:    br i1 [[TMP15]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; IC1:       [[MIDDLE_BLOCK]]:
; IC1-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; IC1-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; IC1:       [[SCALAR_PH]]:
; IC1-NEXT:    [[BC_RESUME_VAL:%.*]] = phi ptr [ [[IND_END]], %[[MIDDLE_BLOCK]] ], [ [[START]], %[[ENTRY]] ]
; IC1-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC1:       [[LOOP_HEADER]]:
; IC1-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC1-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 1
; IC1-NEXT:    switch i8 [[L]], label %[[DEFAULT:.*]] [
; IC1-NEXT:      i8 -12, label %[[IF_THEN_1:.*]]
; IC1-NEXT:      i8 13, label %[[IF_THEN_2:.*]]
; IC1-NEXT:      i8 0, label %[[DEFAULT]]
; IC1-NEXT:    ]
; IC1:       [[IF_THEN_1]]:
; IC1-NEXT:    store i8 42, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[IF_THEN_2]]:
; IC1-NEXT:    store i8 0, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[DEFAULT]]:
; IC1-NEXT:    store i8 2, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[LOOP_LATCH]]:
; IC1-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i64 1
; IC1-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; IC1-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP3:![0-9]+]]
; IC1:       [[EXIT]]:
; IC1-NEXT:    ret void
;
; IC2-LABEL: define void @switch4_default_common_dest_with_case(
; IC2-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) {
; IC2-NEXT:  [[ENTRY:.*]]:
; IC2-NEXT:    [[START2:%.*]] = ptrtoint ptr [[START]] to i64
; IC2-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; IC2-NEXT:    [[TMP0:%.*]] = sub i64 [[END1]], [[START2]]
; IC2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 4
; IC2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; IC2:       [[VECTOR_PH]]:
; IC2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 4
; IC2-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; IC2-NEXT:    [[IND_END:%.*]] = getelementptr i8, ptr [[START]], i64 [[N_VEC]]
; IC2-NEXT:    br label %[[VECTOR_BODY:.*]]
; IC2:       [[VECTOR_BODY]]:
; IC2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE28:.*]] ]
; IC2-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 0
; IC2-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 1
; IC2-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 2
; IC2-NEXT:    [[TMP4:%.*]] = add i64 [[INDEX]], 3
; IC2-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP1]]
; IC2-NEXT:    [[NEXT_GEP3:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP2]]
; IC2-NEXT:    [[NEXT_GEP4:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP3]]
; IC2-NEXT:    [[NEXT_GEP5:%.*]] = getelementptr i8, ptr [[START]], i64 [[TMP4]]
; IC2-NEXT:    [[TMP5:%.*]] = getelementptr i8, ptr [[NEXT_GEP]], i32 0
; IC2-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[NEXT_GEP]], i32 2
; IC2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i8>, ptr [[TMP5]], align 1
; IC2-NEXT:    [[WIDE_LOAD6:%.*]] = load <2 x i8>, ptr [[TMP6]], align 1
; IC2-NEXT:    [[TMP13:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD]], splat (i8 -12)
; IC2-NEXT:    [[TMP14:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD6]], splat (i8 -12)
; IC2-NEXT:    [[TMP7:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD]], splat (i8 13)
; IC2-NEXT:    [[TMP8:%.*]] = icmp eq <2 x i8> [[WIDE_LOAD6]], splat (i8 13)
; IC2-NEXT:    [[TMP21:%.*]] = or <2 x i1> [[TMP13]], [[TMP7]]
; IC2-NEXT:    [[TMP22:%.*]] = or <2 x i1> [[TMP14]], [[TMP8]]
; IC2-NEXT:    [[TMP19:%.*]] = xor <2 x i1> [[TMP21]], splat (i1 true)
; IC2-NEXT:    [[TMP20:%.*]] = xor <2 x i1> [[TMP22]], splat (i1 true)
; IC2-NEXT:    [[TMP9:%.*]] = extractelement <2 x i1> [[TMP7]], i32 0
; IC2-NEXT:    br i1 [[TMP9]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; IC2:       [[PRED_STORE_IF]]:
; IC2-NEXT:    store i8 0, ptr [[NEXT_GEP]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; IC2:       [[PRED_STORE_CONTINUE]]:
; IC2-NEXT:    [[TMP10:%.*]] = extractelement <2 x i1> [[TMP7]], i32 1
; IC2-NEXT:    br i1 [[TMP10]], label %[[PRED_STORE_IF7:.*]], label %[[PRED_STORE_CONTINUE8:.*]]
; IC2:       [[PRED_STORE_IF7]]:
; IC2-NEXT:    store i8 0, ptr [[NEXT_GEP3]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE8]]
; IC2:       [[PRED_STORE_CONTINUE8]]:
; IC2-NEXT:    [[TMP11:%.*]] = extractelement <2 x i1> [[TMP8]], i32 0
; IC2-NEXT:    br i1 [[TMP11]], label %[[PRED_STORE_IF9:.*]], label %[[PRED_STORE_CONTINUE10:.*]]
; IC2:       [[PRED_STORE_IF9]]:
; IC2-NEXT:    store i8 0, ptr [[NEXT_GEP4]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE10]]
; IC2:       [[PRED_STORE_CONTINUE10]]:
; IC2-NEXT:    [[TMP12:%.*]] = extractelement <2 x i1> [[TMP8]], i32 1
; IC2-NEXT:    br i1 [[TMP12]], label %[[PRED_STORE_IF11:.*]], label %[[PRED_STORE_CONTINUE12:.*]]
; IC2:       [[PRED_STORE_IF11]]:
; IC2-NEXT:    store i8 0, ptr [[NEXT_GEP5]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE12]]
; IC2:       [[PRED_STORE_CONTINUE12]]:
; IC2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i1> [[TMP13]], i32 0
; IC2-NEXT:    br i1 [[TMP15]], label %[[PRED_STORE_IF13:.*]], label %[[PRED_STORE_CONTINUE14:.*]]
; IC2:       [[PRED_STORE_IF13]]:
; IC2-NEXT:    store i8 42, ptr [[NEXT_GEP]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE14]]
; IC2:       [[PRED_STORE_CONTINUE14]]:
; IC2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i1> [[TMP13]], i32 1
; IC2-NEXT:    br i1 [[TMP16]], label %[[PRED_STORE_IF15:.*]], label %[[PRED_STORE_CONTINUE16:.*]]
; IC2:       [[PRED_STORE_IF15]]:
; IC2-NEXT:    store i8 42, ptr [[NEXT_GEP3]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE16]]
; IC2:       [[PRED_STORE_CONTINUE16]]:
; IC2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i1> [[TMP14]], i32 0
; IC2-NEXT:    br i1 [[TMP17]], label %[[PRED_STORE_IF17:.*]], label %[[PRED_STORE_CONTINUE18:.*]]
; IC2:       [[PRED_STORE_IF17]]:
; IC2-NEXT:    store i8 42, ptr [[NEXT_GEP4]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE18]]
; IC2:       [[PRED_STORE_CONTINUE18]]:
; IC2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i1> [[TMP14]], i32 1
; IC2-NEXT:    br i1 [[TMP18]], label %[[PRED_STORE_IF19:.*]], label %[[PRED_STORE_CONTINUE20:.*]]
; IC2:       [[PRED_STORE_IF19]]:
; IC2-NEXT:    store i8 42, ptr [[NEXT_GEP5]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE20]]
; IC2:       [[PRED_STORE_CONTINUE20]]:
; IC2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i1> [[TMP19]], i32 0
; IC2-NEXT:    br i1 [[TMP25]], label %[[PRED_STORE_IF21:.*]], label %[[PRED_STORE_CONTINUE22:.*]]
; IC2:       [[PRED_STORE_IF21]]:
; IC2-NEXT:    store i8 2, ptr [[NEXT_GEP]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE22]]
; IC2:       [[PRED_STORE_CONTINUE22]]:
; IC2-NEXT:    [[TMP26:%.*]] = extractelement <2 x i1> [[TMP19]], i32 1
; IC2-NEXT:    br i1 [[TMP26]], label %[[PRED_STORE_IF23:.*]], label %[[PRED_STORE_CONTINUE24:.*]]
; IC2:       [[PRED_STORE_IF23]]:
; IC2-NEXT:    store i8 2, ptr [[NEXT_GEP3]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE24]]
; IC2:       [[PRED_STORE_CONTINUE24]]:
; IC2-NEXT:    [[TMP27:%.*]] = extractelement <2 x i1> [[TMP20]], i32 0
; IC2-NEXT:    br i1 [[TMP27]], label %[[PRED_STORE_IF25:.*]], label %[[PRED_STORE_CONTINUE26:.*]]
; IC2:       [[PRED_STORE_IF25]]:
; IC2-NEXT:    store i8 2, ptr [[NEXT_GEP4]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE26]]
; IC2:       [[PRED_STORE_CONTINUE26]]:
; IC2-NEXT:    [[TMP28:%.*]] = extractelement <2 x i1> [[TMP20]], i32 1
; IC2-NEXT:    br i1 [[TMP28]], label %[[PRED_STORE_IF27:.*]], label %[[PRED_STORE_CONTINUE28]]
; IC2:       [[PRED_STORE_IF27]]:
; IC2-NEXT:    store i8 2, ptr [[NEXT_GEP5]], align 1
; IC2-NEXT:    br label %[[PRED_STORE_CONTINUE28]]
; IC2:       [[PRED_STORE_CONTINUE28]]:
; IC2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; IC2-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; IC2-NEXT:    br i1 [[TMP29]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; IC2:       [[MIDDLE_BLOCK]]:
; IC2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; IC2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; IC2:       [[SCALAR_PH]]:
; IC2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi ptr [ [[IND_END]], %[[MIDDLE_BLOCK]] ], [ [[START]], %[[ENTRY]] ]
; IC2-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC2:       [[LOOP_HEADER]]:
; IC2-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC2-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 1
; IC2-NEXT:    switch i8 [[L]], label %[[DEFAULT:.*]] [
; IC2-NEXT:      i8 -12, label %[[IF_THEN_1:.*]]
; IC2-NEXT:      i8 13, label %[[IF_THEN_2:.*]]
; IC2-NEXT:      i8 0, label %[[DEFAULT]]
; IC2-NEXT:    ]
; IC2:       [[IF_THEN_1]]:
; IC2-NEXT:    store i8 42, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[IF_THEN_2]]:
; IC2-NEXT:    store i8 0, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[DEFAULT]]:
; IC2-NEXT:    store i8 2, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[LOOP_LATCH]]:
; IC2-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i64 1
; IC2-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; IC2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP3:![0-9]+]]
; IC2:       [[EXIT]]:
; IC2-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %entry ], [ %ptr.iv.next, %loop.latch ]
  %l = load i8, ptr %ptr.iv, align 1
  switch i8 %l, label %default [
  i8 -12, label %if.then.1
  i8 13, label %if.then.2
  i8 0, label %default
  ]

if.then.1:
  store i8 42, ptr %ptr.iv, align 1
  br label %loop.latch

if.then.2:
  store i8 0, ptr %ptr.iv, align 1
  br label %loop.latch

default:
  store i8 2, ptr %ptr.iv, align 1
  br label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

define void @switch_exiting(ptr %start) {
; IC1-LABEL: define void @switch_exiting(
; IC1-SAME: ptr [[START:%.*]]) {
; IC1-NEXT:  [[ENTRY:.*]]:
; IC1-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC1:       [[LOOP_HEADER]]:
; IC1-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC1-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH]] [
; IC1-NEXT:      i64 -12, label %[[IF_THEN:.*]]
; IC1-NEXT:      i64 100, label %[[EXIT:.*]]
; IC1-NEXT:    ]
; IC1:       [[IF_THEN]]:
; IC1-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[IV]]
; IC1-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[LOOP_LATCH]]:
; IC1-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC1-NEXT:    br label %[[LOOP_HEADER]]
; IC1:       [[EXIT]]:
; IC1-NEXT:    ret void
;
; IC2-LABEL: define void @switch_exiting(
; IC2-SAME: ptr [[START:%.*]]) {
; IC2-NEXT:  [[ENTRY:.*]]:
; IC2-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC2:       [[LOOP_HEADER]]:
; IC2-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC2-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH]] [
; IC2-NEXT:      i64 -12, label %[[IF_THEN:.*]]
; IC2-NEXT:      i64 100, label %[[EXIT:.*]]
; IC2-NEXT:    ]
; IC2:       [[IF_THEN]]:
; IC2-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[IV]]
; IC2-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[LOOP_LATCH]]:
; IC2-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC2-NEXT:    br label %[[LOOP_HEADER]]
; IC2:       [[EXIT]]:
; IC2-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  switch i64 %iv, label %loop.latch [
  i64 -12, label %if.then
  i64 100, label %exit
  ]

if.then:
  %gep = getelementptr inbounds i64, ptr %start, i64 %iv
  store i64 42, ptr %gep, align 1
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @switch_to_header(ptr %start) {
; IC1-LABEL: define void @switch_to_header(
; IC1-SAME: ptr [[START:%.*]]) {
; IC1-NEXT:  [[ENTRY:.*]]:
; IC1-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC1:       [[LOOP_HEADER]]:
; IC1-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[IF_THEN:.*]] ]
; IC1-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC1-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH:.*]] [
; IC1-NEXT:      i64 120, label %[[IF_THEN]]
; IC1-NEXT:      i64 100, label %[[LOOP_LATCH]]
; IC1-NEXT:    ]
; IC1:       [[IF_THEN]]:
; IC1-NEXT:    br label %[[LOOP_HEADER]]
; IC1:       [[IF_THEN1:.*:]]
; IC1-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 poison
; IC1-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC1-NEXT:    unreachable
; IC1:       [[LOOP_LATCH]]:
; IC1-NEXT:    [[CMP:%.*]] = icmp eq i64 [[IV_NEXT]], 100
; IC1-NEXT:    br i1 [[CMP]], label %[[EXIT:.*]], label %[[IF_THEN]]
; IC1:       [[EXIT]]:
; IC1-NEXT:    ret void
;
; IC2-LABEL: define void @switch_to_header(
; IC2-SAME: ptr [[START:%.*]]) {
; IC2-NEXT:  [[ENTRY:.*]]:
; IC2-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC2:       [[LOOP_HEADER]]:
; IC2-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[IF_THEN:.*]] ]
; IC2-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC2-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH:.*]] [
; IC2-NEXT:      i64 120, label %[[IF_THEN]]
; IC2-NEXT:      i64 100, label %[[LOOP_LATCH]]
; IC2-NEXT:    ]
; IC2:       [[IF_THEN]]:
; IC2-NEXT:    br label %[[LOOP_HEADER]]
; IC2:       [[IF_THEN1:.*:]]
; IC2-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 poison
; IC2-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC2-NEXT:    unreachable
; IC2:       [[LOOP_LATCH]]:
; IC2-NEXT:    [[CMP:%.*]] = icmp eq i64 [[IV_NEXT]], 100
; IC2-NEXT:    br i1 [[CMP]], label %[[EXIT:.*]], label %[[IF_THEN]]
; IC2:       [[EXIT]]:
; IC2-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ], [ %iv.next, %loop.header ]
  %iv.next = add i64 %iv, 1
  switch i64 %iv, label %loop.latch [
  i64 120, label %loop.header
  i64 100, label %loop.latch
  ]

if.then:
  %gep = getelementptr inbounds i64, ptr %start, i64 %iv
  store i64 42, ptr %gep, align 1
  br label %loop.latch

loop.latch:
  %cmp = icmp eq i64 %iv.next, 100
  br i1 %cmp, label %exit, label %loop.header

exit:
  ret void
}

define void @switch_all_to_default(ptr %start) {
; IC1-LABEL: define void @switch_all_to_default(
; IC1-SAME: ptr [[START:%.*]]) {
; IC1-NEXT:  [[ENTRY:.*]]:
; IC1-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; IC1:       [[VECTOR_PH]]:
; IC1-NEXT:    br label %[[VECTOR_BODY:.*]]
; IC1:       [[VECTOR_BODY]]:
; IC1-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; IC1-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[INDEX]]
; IC1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; IC1-NEXT:    store <2 x i64> splat (i64 42), ptr [[TMP2]], align 1
; IC1-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; IC1-NEXT:    [[TMP3:%.*]] = icmp eq i64 [[INDEX_NEXT]], 100
; IC1-NEXT:    br i1 [[TMP3]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; IC1:       [[MIDDLE_BLOCK]]:
; IC1-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; IC1:       [[SCALAR_PH]]:
; IC1-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 100, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; IC1-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC1:       [[LOOP_HEADER]]:
; IC1-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC1-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC1-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH]] [
; IC1-NEXT:      i64 120, label %[[LOOP_LATCH]]
; IC1-NEXT:      i64 100, label %[[LOOP_LATCH]]
; IC1-NEXT:    ]
; IC1:       [[LOOP_LATCH]]:
; IC1-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[IV]]
; IC1-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC1-NEXT:    [[CMP:%.*]] = icmp eq i64 [[IV_NEXT]], 100
; IC1-NEXT:    br i1 [[CMP]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP5:![0-9]+]]
; IC1:       [[EXIT]]:
; IC1-NEXT:    ret void
;
; IC2-LABEL: define void @switch_all_to_default(
; IC2-SAME: ptr [[START:%.*]]) {
; IC2-NEXT:  [[ENTRY:.*]]:
; IC2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; IC2:       [[VECTOR_PH]]:
; IC2-NEXT:    br label %[[VECTOR_BODY:.*]]
; IC2:       [[VECTOR_BODY]]:
; IC2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; IC2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[INDEX]]
; IC2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[TMP2]], i32 0
; IC2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP2]], i32 2
; IC2-NEXT:    store <2 x i64> splat (i64 42), ptr [[TMP4]], align 1
; IC2-NEXT:    store <2 x i64> splat (i64 42), ptr [[TMP5]], align 1
; IC2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; IC2-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 100
; IC2-NEXT:    br i1 [[TMP6]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; IC2:       [[MIDDLE_BLOCK]]:
; IC2-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; IC2:       [[SCALAR_PH]]:
; IC2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 100, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; IC2-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC2:       [[LOOP_HEADER]]:
; IC2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC2-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; IC2-NEXT:    switch i64 [[IV]], label %[[LOOP_LATCH]] [
; IC2-NEXT:      i64 120, label %[[LOOP_LATCH]]
; IC2-NEXT:      i64 100, label %[[LOOP_LATCH]]
; IC2-NEXT:    ]
; IC2:       [[LOOP_LATCH]]:
; IC2-NEXT:    [[GEP:%.*]] = getelementptr inbounds i64, ptr [[START]], i64 [[IV]]
; IC2-NEXT:    store i64 42, ptr [[GEP]], align 1
; IC2-NEXT:    [[CMP:%.*]] = icmp eq i64 [[IV_NEXT]], 100
; IC2-NEXT:    br i1 [[CMP]], label %[[EXIT]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP5:![0-9]+]]
; IC2:       [[EXIT]]:
; IC2-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %iv.next = add i64 %iv, 1
  switch i64 %iv, label %loop.latch [
  i64 120, label %loop.latch
  i64 100, label %loop.latch
  ]

loop.latch:
  %gep = getelementptr inbounds i64, ptr %start, i64 %iv
  store i64 42, ptr %gep, align 1
  %cmp = icmp eq i64 %iv.next, 100
  br i1 %cmp, label %exit, label %loop.header

exit:
  ret void
}
;.
; IC1: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; IC1: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; IC1: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
; IC1: [[LOOP3]] = distinct !{[[LOOP3]], [[META2]], [[META1]]}
; IC1: [[LOOP4]] = distinct !{[[LOOP4]], [[META1]], [[META2]]}
; IC1: [[LOOP5]] = distinct !{[[LOOP5]], [[META2]], [[META1]]}
;.
; IC2: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; IC2: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; IC2: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
; IC2: [[LOOP3]] = distinct !{[[LOOP3]], [[META2]], [[META1]]}
; IC2: [[LOOP4]] = distinct !{[[LOOP4]], [[META1]], [[META2]]}
; IC2: [[LOOP5]] = distinct !{[[LOOP5]], [[META2]], [[META1]]}
;.
