/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_NANO;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_NANO.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_NANO, sbdtobf16_k_NANO, sbf16tos_k_NANO, dbf16tod_k_NANO,

  samax_k_NANO,  samin_k_NANO,  smax_k_NANO,  smin_k_NANO,
  isamax_k_NANO, isamin_k_NANO, ismax_k_NANO, ismin_k_NANO,
  snrm2_k_NANO,  sasum_k_NANO, ssum_k_NANO, scopy_k_NANO, sbdot_k_NANO,
  dsdot_k_NANO,
  srot_k_NANO,   saxpy_k_NANO,  sscal_k_NANO, sswap_k_NANO,
  sbgemv_n_NANO, sbgemv_t_NANO, sger_k_NANO,
  ssymv_L_NANO, ssymv_U_NANO,

  sbgemm_kernel_NANO, sbgemm_beta_NANO,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_NANO, sbgemm_itcopy_NANO,
#else
  sbgemm_oncopy_NANO, sbgemm_otcopy_NANO,
#endif
  sbgemm_oncopy_NANO, sbgemm_otcopy_NANO,

  strsm_kernel_LN_NANO, strsm_kernel_LT_NANO, strsm_kernel_RN_NANO, strsm_kernel_RT_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_NANO, strsm_iunncopy_NANO, strsm_iutucopy_NANO, strsm_iutncopy_NANO,
  strsm_ilnucopy_NANO, strsm_ilnncopy_NANO, strsm_iltucopy_NANO, strsm_iltncopy_NANO,
#else
  strsm_ounucopy_NANO, strsm_ounncopy_NANO, strsm_outucopy_NANO, strsm_outncopy_NANO,
  strsm_olnucopy_NANO, strsm_olnncopy_NANO, strsm_oltucopy_NANO, strsm_oltncopy_NANO,
#endif
  strsm_ounucopy_NANO, strsm_ounncopy_NANO, strsm_outucopy_NANO, strsm_outncopy_NANO,
  strsm_olnucopy_NANO, strsm_olnncopy_NANO, strsm_oltucopy_NANO, strsm_oltncopy_NANO,
  strmm_kernel_RN_NANO, strmm_kernel_RT_NANO, strmm_kernel_LN_NANO, strmm_kernel_LT_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_NANO, strmm_iunncopy_NANO, strmm_iutucopy_NANO, strmm_iutncopy_NANO,
  strmm_ilnucopy_NANO, strmm_ilnncopy_NANO, strmm_iltucopy_NANO, strmm_iltncopy_NANO,
#else
  strmm_ounucopy_NANO, strmm_ounncopy_NANO, strmm_outucopy_NANO, strmm_outncopy_NANO,
  strmm_olnucopy_NANO, strmm_olnncopy_NANO, strmm_oltucopy_NANO, strmm_oltncopy_NANO,
#endif
  strmm_ounucopy_NANO, strmm_ounncopy_NANO, strmm_outucopy_NANO, strmm_outncopy_NANO,
  strmm_olnucopy_NANO, strmm_olnncopy_NANO, strmm_oltucopy_NANO, strmm_oltncopy_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_NANO, ssymm_iltcopy_NANO,
#else
  ssymm_outcopy_NANO, ssymm_oltcopy_NANO,
#endif
  ssymm_outcopy_NANO, ssymm_oltcopy_NANO,

#ifndef NO_LAPACK
  sneg_tcopy_NANO, slaswp_ncopy_NANO,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_NANO,
  sbgemm_small_kernel_nn_NANO, sbgemm_small_kernel_nt_NANO, sbgemm_small_kernel_tn_NANO, sbgemm_small_kernel_tt_NANO,
  sbgemm_small_kernel_b0_nn_NANO, sbgemm_small_kernel_b0_nt_NANO, sbgemm_small_kernel_b0_tn_NANO, sbgemm_small_kernel_b0_tt_NANO,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_NANO,  samin_k_NANO,  smax_k_NANO,  smin_k_NANO,
  isamax_k_NANO, isamin_k_NANO, ismax_k_NANO, ismin_k_NANO,
  snrm2_k_NANO,  sasum_k_NANO,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_NANO,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_NANO, sdot_k_NANO,
//  dsdot_k_NANO,
  srot_k_NANO,   saxpy_k_NANO,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_NANO,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_NANO,
  sgemv_n_NANO,  sgemv_t_NANO,
#endif
#if BUILD_SINGLE == 1  
  sger_k_NANO,
  ssymv_L_NANO, ssymv_U_NANO,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_NANO,
  sgemm_direct_performant_NANO,	
#endif

  sgemm_kernel_NANO, sgemm_beta_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_NANO, sgemm_itcopy_NANO,
#else
  sgemm_oncopy_NANO, sgemm_otcopy_NANO,
#endif
  sgemm_oncopy_NANO, sgemm_otcopy_NANO,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_NANO,
  sgemm_small_kernel_nn_NANO, sgemm_small_kernel_nt_NANO, sgemm_small_kernel_tn_NANO, sgemm_small_kernel_tt_NANO,
  sgemm_small_kernel_b0_nn_NANO, sgemm_small_kernel_b0_nt_NANO, sgemm_small_kernel_b0_tn_NANO, sgemm_small_kernel_b0_tt_NANO,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_NANO, strsm_kernel_LT_NANO, strsm_kernel_RN_NANO, strsm_kernel_RT_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_NANO, strsm_iunncopy_NANO, strsm_iutucopy_NANO, strsm_iutncopy_NANO,
  strsm_ilnucopy_NANO, strsm_ilnncopy_NANO, strsm_iltucopy_NANO, strsm_iltncopy_NANO,
#else
  strsm_ounucopy_NANO, strsm_ounncopy_NANO, strsm_outucopy_NANO, strsm_outncopy_NANO,
  strsm_olnucopy_NANO, strsm_olnncopy_NANO, strsm_oltucopy_NANO, strsm_oltncopy_NANO,
#endif
  strsm_ounucopy_NANO, strsm_ounncopy_NANO, strsm_outucopy_NANO, strsm_outncopy_NANO,
  strsm_olnucopy_NANO, strsm_olnncopy_NANO, strsm_oltucopy_NANO, strsm_oltncopy_NANO,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_NANO, strmm_kernel_RT_NANO, strmm_kernel_LN_NANO, strmm_kernel_LT_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_NANO, strmm_iunncopy_NANO, strmm_iutucopy_NANO, strmm_iutncopy_NANO,
  strmm_ilnucopy_NANO, strmm_ilnncopy_NANO, strmm_iltucopy_NANO, strmm_iltncopy_NANO,
#else
  strmm_ounucopy_NANO, strmm_ounncopy_NANO, strmm_outucopy_NANO, strmm_outncopy_NANO,
  strmm_olnucopy_NANO, strmm_olnncopy_NANO, strmm_oltucopy_NANO, strmm_oltncopy_NANO,
#endif
  strmm_ounucopy_NANO, strmm_ounncopy_NANO, strmm_outucopy_NANO, strmm_outncopy_NANO,
  strmm_olnucopy_NANO, strmm_olnncopy_NANO, strmm_oltucopy_NANO, strmm_oltncopy_NANO,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_NANO, ssymm_iltcopy_NANO,
#else
  ssymm_outcopy_NANO, ssymm_oltcopy_NANO,
#endif
  ssymm_outcopy_NANO, ssymm_oltcopy_NANO,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_NANO, slaswp_ncopy_NANO,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_NANO,  damin_k_NANO,  dmax_k_NANO,  dmin_k_NANO,
  idamax_k_NANO, idamin_k_NANO, idmax_k_NANO, idmin_k_NANO,
  dnrm2_k_NANO, dasum_k_NANO,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_NANO,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_NANO, ddot_k_NANO,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_NANO,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_NANO,
  daxpy_k_NANO,
  dscal_k_NANO, 
  dswap_k_NANO,
  dgemv_n_NANO,  dgemv_t_NANO,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_NANO,
  dsymv_L_NANO,  dsymv_U_NANO,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_NANO, dgemm_beta_NANO,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_NANO, dgemm_itcopy_NANO,
#else
  dgemm_oncopy_NANO, dgemm_otcopy_NANO,
#endif
  dgemm_oncopy_NANO, dgemm_otcopy_NANO,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_NANO,
  dgemm_small_kernel_nn_NANO, dgemm_small_kernel_nt_NANO, dgemm_small_kernel_tn_NANO, dgemm_small_kernel_tt_NANO,
  dgemm_small_kernel_b0_nn_NANO, dgemm_small_kernel_b0_nt_NANO, dgemm_small_kernel_b0_tn_NANO, dgemm_small_kernel_b0_tt_NANO,
#endif
  dtrsm_kernel_LN_NANO, dtrsm_kernel_LT_NANO, dtrsm_kernel_RN_NANO, dtrsm_kernel_RT_NANO,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_NANO, dtrsm_iunncopy_NANO, dtrsm_iutucopy_NANO, dtrsm_iutncopy_NANO,
  dtrsm_ilnucopy_NANO, dtrsm_ilnncopy_NANO, dtrsm_iltucopy_NANO, dtrsm_iltncopy_NANO,
#else
  dtrsm_ounucopy_NANO, dtrsm_ounncopy_NANO, dtrsm_outucopy_NANO, dtrsm_outncopy_NANO,
  dtrsm_olnucopy_NANO, dtrsm_olnncopy_NANO, dtrsm_oltucopy_NANO, dtrsm_oltncopy_NANO,
#endif
  dtrsm_ounucopy_NANO, dtrsm_ounncopy_NANO, dtrsm_outucopy_NANO, dtrsm_outncopy_NANO,
  dtrsm_olnucopy_NANO, dtrsm_olnncopy_NANO, dtrsm_oltucopy_NANO, dtrsm_oltncopy_NANO,
  dtrmm_kernel_RN_NANO, dtrmm_kernel_RT_NANO, dtrmm_kernel_LN_NANO, dtrmm_kernel_LT_NANO,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_NANO, dtrmm_iunncopy_NANO, dtrmm_iutucopy_NANO, dtrmm_iutncopy_NANO,
  dtrmm_ilnucopy_NANO, dtrmm_ilnncopy_NANO, dtrmm_iltucopy_NANO, dtrmm_iltncopy_NANO,
#else
  dtrmm_ounucopy_NANO, dtrmm_ounncopy_NANO, dtrmm_outucopy_NANO, dtrmm_outncopy_NANO,
  dtrmm_olnucopy_NANO, dtrmm_olnncopy_NANO, dtrmm_oltucopy_NANO, dtrmm_oltncopy_NANO,
#endif
  dtrmm_ounucopy_NANO, dtrmm_ounncopy_NANO, dtrmm_outucopy_NANO, dtrmm_outncopy_NANO,
  dtrmm_olnucopy_NANO, dtrmm_olnncopy_NANO, dtrmm_oltucopy_NANO, dtrmm_oltncopy_NANO,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_NANO, dsymm_iltcopy_NANO,
#else
  dsymm_outcopy_NANO, dsymm_oltcopy_NANO,
#endif
  dsymm_outcopy_NANO, dsymm_oltcopy_NANO,

#ifndef NO_LAPACK
  dneg_tcopy_NANO, dlaswp_ncopy_NANO,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_NANO,  qamin_k_NANO,  qmax_k_NANO,  qmin_k_NANO,
  iqamax_k_NANO, iqamin_k_NANO, iqmax_k_NANO, iqmin_k_NANO,
  qnrm2_k_NANO,  qasum_k_NANO,  qsum_k_NANO, qcopy_k_NANO, qdot_k_NANO,
  qrot_k_NANO,   qaxpy_k_NANO,  qscal_k_NANO, qswap_k_NANO,
  qgemv_n_NANO,  qgemv_t_NANO,  qger_k_NANO,
  qsymv_L_NANO,  qsymv_U_NANO,

  qgemm_kernel_NANO, qgemm_beta_NANO,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_NANO, qgemm_itcopy_NANO,
#else
  qgemm_oncopy_NANO, qgemm_otcopy_NANO,
#endif
  qgemm_oncopy_NANO, qgemm_otcopy_NANO,
  qtrsm_kernel_LN_NANO, qtrsm_kernel_LT_NANO, qtrsm_kernel_RN_NANO, qtrsm_kernel_RT_NANO,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_NANO, qtrsm_iunncopy_NANO, qtrsm_iutucopy_NANO, qtrsm_iutncopy_NANO,
  qtrsm_ilnucopy_NANO, qtrsm_ilnncopy_NANO, qtrsm_iltucopy_NANO, qtrsm_iltncopy_NANO,
#else
  qtrsm_ounucopy_NANO, qtrsm_ounncopy_NANO, qtrsm_outucopy_NANO, qtrsm_outncopy_NANO,
  qtrsm_olnucopy_NANO, qtrsm_olnncopy_NANO, qtrsm_oltucopy_NANO, qtrsm_oltncopy_NANO,
#endif
  qtrsm_ounucopy_NANO, qtrsm_ounncopy_NANO, qtrsm_outucopy_NANO, qtrsm_outncopy_NANO,
  qtrsm_olnucopy_NANO, qtrsm_olnncopy_NANO, qtrsm_oltucopy_NANO, qtrsm_oltncopy_NANO,
  qtrmm_kernel_RN_NANO, qtrmm_kernel_RT_NANO, qtrmm_kernel_LN_NANO, qtrmm_kernel_LT_NANO,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_NANO, qtrmm_iunncopy_NANO, qtrmm_iutucopy_NANO, qtrmm_iutncopy_NANO,
  qtrmm_ilnucopy_NANO, qtrmm_ilnncopy_NANO, qtrmm_iltucopy_NANO, qtrmm_iltncopy_NANO,
#else
  qtrmm_ounucopy_NANO, qtrmm_ounncopy_NANO, qtrmm_outucopy_NANO, qtrmm_outncopy_NANO,
  qtrmm_olnucopy_NANO, qtrmm_olnncopy_NANO, qtrmm_oltucopy_NANO, qtrmm_oltncopy_NANO,
#endif
  qtrmm_ounucopy_NANO, qtrmm_ounncopy_NANO, qtrmm_outucopy_NANO, qtrmm_outncopy_NANO,
  qtrmm_olnucopy_NANO, qtrmm_olnncopy_NANO, qtrmm_oltucopy_NANO, qtrmm_oltncopy_NANO,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_NANO, qsymm_iltcopy_NANO,
#else
  qsymm_outcopy_NANO, qsymm_oltcopy_NANO,
#endif
  qsymm_outcopy_NANO, qsymm_oltcopy_NANO,

#ifndef NO_LAPACK
  qneg_tcopy_NANO, qlaswp_ncopy_NANO,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_NANO, camin_k_NANO, icamax_k_NANO, icamin_k_NANO,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_NANO, casum_k_NANO, csum_k_NANO,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_NANO,  cdotu_k_NANO, cdotc_k_NANO,
#endif
#if (BUILD_COMPLEX)
 csrot_k_NANO,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_NANO,
  caxpyc_k_NANO, 
  cscal_k_NANO, 
  cswap_k_NANO,

  cgemv_n_NANO, cgemv_t_NANO, cgemv_r_NANO, cgemv_c_NANO,
  cgemv_o_NANO, cgemv_u_NANO, cgemv_s_NANO, cgemv_d_NANO,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_NANO, cgerc_k_NANO, cgerv_k_NANO, cgerd_k_NANO,
  csymv_L_NANO, csymv_U_NANO,
  chemv_L_NANO, chemv_U_NANO, chemv_M_NANO, chemv_V_NANO,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_NANO, cgemm_kernel_l_NANO, cgemm_kernel_r_NANO, cgemm_kernel_b_NANO,
  cgemm_beta_NANO,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_NANO, cgemm_itcopy_NANO,
#else
  cgemm_oncopy_NANO, cgemm_otcopy_NANO,
#endif
  cgemm_oncopy_NANO, cgemm_otcopy_NANO,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_NANO,
  cgemm_small_kernel_nn_NANO, cgemm_small_kernel_nt_NANO, cgemm_small_kernel_nr_NANO, cgemm_small_kernel_nc_NANO,
  cgemm_small_kernel_tn_NANO, cgemm_small_kernel_tt_NANO, cgemm_small_kernel_tr_NANO, cgemm_small_kernel_tc_NANO,
  cgemm_small_kernel_rn_NANO, cgemm_small_kernel_rt_NANO, cgemm_small_kernel_rr_NANO, cgemm_small_kernel_rc_NANO,
  cgemm_small_kernel_cn_NANO, cgemm_small_kernel_ct_NANO, cgemm_small_kernel_cr_NANO, cgemm_small_kernel_cc_NANO,
  cgemm_small_kernel_b0_nn_NANO, cgemm_small_kernel_b0_nt_NANO, cgemm_small_kernel_b0_nr_NANO, cgemm_small_kernel_b0_nc_NANO,
  cgemm_small_kernel_b0_tn_NANO, cgemm_small_kernel_b0_tt_NANO, cgemm_small_kernel_b0_tr_NANO, cgemm_small_kernel_b0_tc_NANO,
  cgemm_small_kernel_b0_rn_NANO, cgemm_small_kernel_b0_rt_NANO, cgemm_small_kernel_b0_rr_NANO, cgemm_small_kernel_b0_rc_NANO,
  cgemm_small_kernel_b0_cn_NANO, cgemm_small_kernel_b0_ct_NANO, cgemm_small_kernel_b0_cr_NANO, cgemm_small_kernel_b0_cc_NANO,
#endif

  ctrsm_kernel_LN_NANO, ctrsm_kernel_LT_NANO, ctrsm_kernel_LR_NANO, ctrsm_kernel_LC_NANO,
  ctrsm_kernel_RN_NANO, ctrsm_kernel_RT_NANO, ctrsm_kernel_RR_NANO, ctrsm_kernel_RC_NANO,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_NANO,  ctrsm_iunncopy_NANO,  ctrsm_iutucopy_NANO,  ctrsm_iutncopy_NANO,
  ctrsm_ilnucopy_NANO,  ctrsm_ilnncopy_NANO,  ctrsm_iltucopy_NANO,  ctrsm_iltncopy_NANO,
#else
  ctrsm_ounucopy_NANO,  ctrsm_ounncopy_NANO,  ctrsm_outucopy_NANO,  ctrsm_outncopy_NANO,
  ctrsm_olnucopy_NANO,  ctrsm_olnncopy_NANO,  ctrsm_oltucopy_NANO,  ctrsm_oltncopy_NANO,
#endif
  ctrsm_ounucopy_NANO,  ctrsm_ounncopy_NANO,  ctrsm_outucopy_NANO,  ctrsm_outncopy_NANO,
  ctrsm_olnucopy_NANO,  ctrsm_olnncopy_NANO,  ctrsm_oltucopy_NANO,  ctrsm_oltncopy_NANO,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_NANO,  ctrmm_kernel_RT_NANO,  ctrmm_kernel_RR_NANO,  ctrmm_kernel_RC_NANO,
  ctrmm_kernel_LN_NANO,  ctrmm_kernel_LT_NANO,  ctrmm_kernel_LR_NANO,  ctrmm_kernel_LC_NANO,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_NANO,  ctrmm_iunncopy_NANO,  ctrmm_iutucopy_NANO,  ctrmm_iutncopy_NANO,
  ctrmm_ilnucopy_NANO,  ctrmm_ilnncopy_NANO,  ctrmm_iltucopy_NANO,  ctrmm_iltncopy_NANO,
#else
  ctrmm_ounucopy_NANO,  ctrmm_ounncopy_NANO,  ctrmm_outucopy_NANO,  ctrmm_outncopy_NANO,
  ctrmm_olnucopy_NANO,  ctrmm_olnncopy_NANO,  ctrmm_oltucopy_NANO,  ctrmm_oltncopy_NANO,
#endif
  ctrmm_ounucopy_NANO,  ctrmm_ounncopy_NANO,  ctrmm_outucopy_NANO,  ctrmm_outncopy_NANO,
  ctrmm_olnucopy_NANO,  ctrmm_olnncopy_NANO,  ctrmm_oltucopy_NANO,  ctrmm_oltncopy_NANO,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_NANO,  csymm_iltcopy_NANO,
#else
  csymm_outcopy_NANO,  csymm_oltcopy_NANO,
#endif
  csymm_outcopy_NANO,  csymm_oltcopy_NANO,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_NANO,  chemm_iltcopy_NANO,
#else
  chemm_outcopy_NANO,  chemm_oltcopy_NANO,
#endif
  chemm_outcopy_NANO,  chemm_oltcopy_NANO,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_NANO,

  cgemm3m_incopyb_NANO,  cgemm3m_incopyr_NANO,
  cgemm3m_incopyi_NANO,  cgemm3m_itcopyb_NANO,
  cgemm3m_itcopyr_NANO,  cgemm3m_itcopyi_NANO,
  cgemm3m_oncopyb_NANO,  cgemm3m_oncopyr_NANO,
  cgemm3m_oncopyi_NANO,  cgemm3m_otcopyb_NANO,
  cgemm3m_otcopyr_NANO,  cgemm3m_otcopyi_NANO,

  csymm3m_iucopyb_NANO,  csymm3m_ilcopyb_NANO,
  csymm3m_iucopyr_NANO,  csymm3m_ilcopyr_NANO,
  csymm3m_iucopyi_NANO,  csymm3m_ilcopyi_NANO,
  csymm3m_oucopyb_NANO,  csymm3m_olcopyb_NANO,
  csymm3m_oucopyr_NANO,  csymm3m_olcopyr_NANO,
  csymm3m_oucopyi_NANO,  csymm3m_olcopyi_NANO,

  chemm3m_iucopyb_NANO,  chemm3m_ilcopyb_NANO,
  chemm3m_iucopyr_NANO,  chemm3m_ilcopyr_NANO,
  chemm3m_iucopyi_NANO,  chemm3m_ilcopyi_NANO,

  chemm3m_oucopyb_NANO,  chemm3m_olcopyb_NANO,
  chemm3m_oucopyr_NANO,  chemm3m_olcopyr_NANO,
  chemm3m_oucopyi_NANO,  chemm3m_olcopyi_NANO,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_NANO,
  
   claswp_ncopy_NANO,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_NANO, zamin_k_NANO, izamax_k_NANO, izamin_k_NANO,
  znrm2_k_NANO, zasum_k_NANO, zsum_k_NANO, zcopy_k_NANO,
  zdotu_k_NANO, zdotc_k_NANO, zdrot_k_NANO,
  zaxpy_k_NANO, zaxpyc_k_NANO, zscal_k_NANO, zswap_k_NANO,

  zgemv_n_NANO, zgemv_t_NANO, zgemv_r_NANO, zgemv_c_NANO,
  zgemv_o_NANO, zgemv_u_NANO, zgemv_s_NANO, zgemv_d_NANO,
  zgeru_k_NANO, zgerc_k_NANO, zgerv_k_NANO, zgerd_k_NANO,
  zsymv_L_NANO, zsymv_U_NANO,
  zhemv_L_NANO, zhemv_U_NANO, zhemv_M_NANO, zhemv_V_NANO,

  zgemm_kernel_n_NANO, zgemm_kernel_l_NANO, zgemm_kernel_r_NANO, zgemm_kernel_b_NANO,
  zgemm_beta_NANO,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_NANO, zgemm_itcopy_NANO,
#else
  zgemm_oncopy_NANO, zgemm_otcopy_NANO,
#endif
  zgemm_oncopy_NANO, zgemm_otcopy_NANO,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_NANO,
  zgemm_small_kernel_nn_NANO, zgemm_small_kernel_nt_NANO, zgemm_small_kernel_nr_NANO, zgemm_small_kernel_nc_NANO,
  zgemm_small_kernel_tn_NANO, zgemm_small_kernel_tt_NANO, zgemm_small_kernel_tr_NANO, zgemm_small_kernel_tc_NANO,
  zgemm_small_kernel_rn_NANO, zgemm_small_kernel_rt_NANO, zgemm_small_kernel_rr_NANO, zgemm_small_kernel_rc_NANO,
  zgemm_small_kernel_cn_NANO, zgemm_small_kernel_ct_NANO, zgemm_small_kernel_cr_NANO, zgemm_small_kernel_cc_NANO,
  zgemm_small_kernel_b0_nn_NANO, zgemm_small_kernel_b0_nt_NANO, zgemm_small_kernel_b0_nr_NANO, zgemm_small_kernel_b0_nc_NANO,
  zgemm_small_kernel_b0_tn_NANO, zgemm_small_kernel_b0_tt_NANO, zgemm_small_kernel_b0_tr_NANO, zgemm_small_kernel_b0_tc_NANO,
  zgemm_small_kernel_b0_rn_NANO, zgemm_small_kernel_b0_rt_NANO, zgemm_small_kernel_b0_rr_NANO, zgemm_small_kernel_b0_rc_NANO,
  zgemm_small_kernel_b0_cn_NANO, zgemm_small_kernel_b0_ct_NANO, zgemm_small_kernel_b0_cr_NANO, zgemm_small_kernel_b0_cc_NANO,
#endif

  ztrsm_kernel_LN_NANO, ztrsm_kernel_LT_NANO, ztrsm_kernel_LR_NANO, ztrsm_kernel_LC_NANO,
  ztrsm_kernel_RN_NANO, ztrsm_kernel_RT_NANO, ztrsm_kernel_RR_NANO, ztrsm_kernel_RC_NANO,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_NANO,  ztrsm_iunncopy_NANO,  ztrsm_iutucopy_NANO,  ztrsm_iutncopy_NANO,
  ztrsm_ilnucopy_NANO,  ztrsm_ilnncopy_NANO,  ztrsm_iltucopy_NANO,  ztrsm_iltncopy_NANO,
#else
  ztrsm_ounucopy_NANO,  ztrsm_ounncopy_NANO,  ztrsm_outucopy_NANO,  ztrsm_outncopy_NANO,
  ztrsm_olnucopy_NANO,  ztrsm_olnncopy_NANO,  ztrsm_oltucopy_NANO,  ztrsm_oltncopy_NANO,
#endif
  ztrsm_ounucopy_NANO,  ztrsm_ounncopy_NANO,  ztrsm_outucopy_NANO,  ztrsm_outncopy_NANO,
  ztrsm_olnucopy_NANO,  ztrsm_olnncopy_NANO,  ztrsm_oltucopy_NANO,  ztrsm_oltncopy_NANO,

  ztrmm_kernel_RN_NANO,  ztrmm_kernel_RT_NANO,  ztrmm_kernel_RR_NANO,  ztrmm_kernel_RC_NANO,
  ztrmm_kernel_LN_NANO,  ztrmm_kernel_LT_NANO,  ztrmm_kernel_LR_NANO,  ztrmm_kernel_LC_NANO,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_NANO,  ztrmm_iunncopy_NANO,  ztrmm_iutucopy_NANO,  ztrmm_iutncopy_NANO,
  ztrmm_ilnucopy_NANO,  ztrmm_ilnncopy_NANO,  ztrmm_iltucopy_NANO,  ztrmm_iltncopy_NANO,
#else
  ztrmm_ounucopy_NANO,  ztrmm_ounncopy_NANO,  ztrmm_outucopy_NANO,  ztrmm_outncopy_NANO,
  ztrmm_olnucopy_NANO,  ztrmm_olnncopy_NANO,  ztrmm_oltucopy_NANO,  ztrmm_oltncopy_NANO,
#endif
  ztrmm_ounucopy_NANO,  ztrmm_ounncopy_NANO,  ztrmm_outucopy_NANO,  ztrmm_outncopy_NANO,
  ztrmm_olnucopy_NANO,  ztrmm_olnncopy_NANO,  ztrmm_oltucopy_NANO,  ztrmm_oltncopy_NANO,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_NANO,  zsymm_iltcopy_NANO,
#else
  zsymm_outcopy_NANO,  zsymm_oltcopy_NANO,
#endif
  zsymm_outcopy_NANO,  zsymm_oltcopy_NANO,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_NANO,  zhemm_iltcopy_NANO,
#else
  zhemm_outcopy_NANO,  zhemm_oltcopy_NANO,
#endif
  zhemm_outcopy_NANO,  zhemm_oltcopy_NANO,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_NANO,

  zgemm3m_incopyb_NANO,  zgemm3m_incopyr_NANO,
  zgemm3m_incopyi_NANO,  zgemm3m_itcopyb_NANO,
  zgemm3m_itcopyr_NANO,  zgemm3m_itcopyi_NANO,
  zgemm3m_oncopyb_NANO,  zgemm3m_oncopyr_NANO,
  zgemm3m_oncopyi_NANO,  zgemm3m_otcopyb_NANO,
  zgemm3m_otcopyr_NANO,  zgemm3m_otcopyi_NANO,

  zsymm3m_iucopyb_NANO,  zsymm3m_ilcopyb_NANO,
  zsymm3m_iucopyr_NANO,  zsymm3m_ilcopyr_NANO,
  zsymm3m_iucopyi_NANO,  zsymm3m_ilcopyi_NANO,
  zsymm3m_oucopyb_NANO,  zsymm3m_olcopyb_NANO,
  zsymm3m_oucopyr_NANO,  zsymm3m_olcopyr_NANO,
  zsymm3m_oucopyi_NANO,  zsymm3m_olcopyi_NANO,

  zhemm3m_iucopyb_NANO,  zhemm3m_ilcopyb_NANO,
  zhemm3m_iucopyr_NANO,  zhemm3m_ilcopyr_NANO,
  zhemm3m_iucopyi_NANO,  zhemm3m_ilcopyi_NANO,

  zhemm3m_oucopyb_NANO,  zhemm3m_olcopyb_NANO,
  zhemm3m_oucopyr_NANO,  zhemm3m_olcopyr_NANO,
  zhemm3m_oucopyi_NANO,  zhemm3m_olcopyi_NANO,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_NANO, zlaswp_ncopy_NANO,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_NANO, xamin_k_NANO, ixamax_k_NANO, ixamin_k_NANO,
  xnrm2_k_NANO, xasum_k_NANO, xsum_k_NANO, xcopy_k_NANO,
  xdotu_k_NANO, xdotc_k_NANO, xqrot_k_NANO,
  xaxpy_k_NANO, xaxpyc_k_NANO, xscal_k_NANO, xswap_k_NANO,

  xgemv_n_NANO, xgemv_t_NANO, xgemv_r_NANO, xgemv_c_NANO,
  xgemv_o_NANO, xgemv_u_NANO, xgemv_s_NANO, xgemv_d_NANO,
  xgeru_k_NANO, xgerc_k_NANO, xgerv_k_NANO, xgerd_k_NANO,
  xsymv_L_NANO, xsymv_U_NANO,
  xhemv_L_NANO, xhemv_U_NANO, xhemv_M_NANO, xhemv_V_NANO,

  xgemm_kernel_n_NANO, xgemm_kernel_l_NANO, xgemm_kernel_r_NANO, xgemm_kernel_b_NANO,
  xgemm_beta_NANO,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_NANO, xgemm_itcopy_NANO,
#else
  xgemm_oncopy_NANO, xgemm_otcopy_NANO,
#endif
  xgemm_oncopy_NANO, xgemm_otcopy_NANO,

  xtrsm_kernel_LN_NANO, xtrsm_kernel_LT_NANO, xtrsm_kernel_LR_NANO, xtrsm_kernel_LC_NANO,
  xtrsm_kernel_RN_NANO, xtrsm_kernel_RT_NANO, xtrsm_kernel_RR_NANO, xtrsm_kernel_RC_NANO,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_NANO,  xtrsm_iunncopy_NANO,  xtrsm_iutucopy_NANO,  xtrsm_iutncopy_NANO,
  xtrsm_ilnucopy_NANO,  xtrsm_ilnncopy_NANO,  xtrsm_iltucopy_NANO,  xtrsm_iltncopy_NANO,
#else
  xtrsm_ounucopy_NANO,  xtrsm_ounncopy_NANO,  xtrsm_outucopy_NANO,  xtrsm_outncopy_NANO,
  xtrsm_olnucopy_NANO,  xtrsm_olnncopy_NANO,  xtrsm_oltucopy_NANO,  xtrsm_oltncopy_NANO,
#endif
  xtrsm_ounucopy_NANO,  xtrsm_ounncopy_NANO,  xtrsm_outucopy_NANO,  xtrsm_outncopy_NANO,
  xtrsm_olnucopy_NANO,  xtrsm_olnncopy_NANO,  xtrsm_oltucopy_NANO,  xtrsm_oltncopy_NANO,

  xtrmm_kernel_RN_NANO,  xtrmm_kernel_RT_NANO,  xtrmm_kernel_RR_NANO,  xtrmm_kernel_RC_NANO,
  xtrmm_kernel_LN_NANO,  xtrmm_kernel_LT_NANO,  xtrmm_kernel_LR_NANO,  xtrmm_kernel_LC_NANO,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_NANO,  xtrmm_iunncopy_NANO,  xtrmm_iutucopy_NANO,  xtrmm_iutncopy_NANO,
  xtrmm_ilnucopy_NANO,  xtrmm_ilnncopy_NANO,  xtrmm_iltucopy_NANO,  xtrmm_iltncopy_NANO,
#else
  xtrmm_ounucopy_NANO,  xtrmm_ounncopy_NANO,  xtrmm_outucopy_NANO,  xtrmm_outncopy_NANO,
  xtrmm_olnucopy_NANO,  xtrmm_olnncopy_NANO,  xtrmm_oltucopy_NANO,  xtrmm_oltncopy_NANO,
#endif
  xtrmm_ounucopy_NANO,  xtrmm_ounncopy_NANO,  xtrmm_outucopy_NANO,  xtrmm_outncopy_NANO,
  xtrmm_olnucopy_NANO,  xtrmm_olnncopy_NANO,  xtrmm_oltucopy_NANO,  xtrmm_oltncopy_NANO,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_NANO,  xsymm_iltcopy_NANO,
#else
  xsymm_outcopy_NANO,  xsymm_oltcopy_NANO,
#endif
  xsymm_outcopy_NANO,  xsymm_oltcopy_NANO,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_NANO,  xhemm_iltcopy_NANO,
#else
  xhemm_outcopy_NANO,  xhemm_oltcopy_NANO,
#endif
  xhemm_outcopy_NANO,  xhemm_oltcopy_NANO,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_NANO,

  xgemm3m_incopyb_NANO,  xgemm3m_incopyr_NANO,
  xgemm3m_incopyi_NANO,  xgemm3m_itcopyb_NANO,
  xgemm3m_itcopyr_NANO,  xgemm3m_itcopyi_NANO,
  xgemm3m_oncopyb_NANO,  xgemm3m_oncopyr_NANO,
  xgemm3m_oncopyi_NANO,  xgemm3m_otcopyb_NANO,
  xgemm3m_otcopyr_NANO,  xgemm3m_otcopyi_NANO,

  xsymm3m_iucopyb_NANO,  xsymm3m_ilcopyb_NANO,
  xsymm3m_iucopyr_NANO,  xsymm3m_ilcopyr_NANO,
  xsymm3m_iucopyi_NANO,  xsymm3m_ilcopyi_NANO,
  xsymm3m_oucopyb_NANO,  xsymm3m_olcopyb_NANO,
  xsymm3m_oucopyr_NANO,  xsymm3m_olcopyr_NANO,
  xsymm3m_oucopyi_NANO,  xsymm3m_olcopyi_NANO,

  xhemm3m_iucopyb_NANO,  xhemm3m_ilcopyb_NANO,
  xhemm3m_iucopyr_NANO,  xhemm3m_ilcopyr_NANO,
  xhemm3m_iucopyi_NANO,  xhemm3m_ilcopyi_NANO,

  xhemm3m_oucopyb_NANO,  xhemm3m_olcopyb_NANO,
  xhemm3m_oucopyr_NANO,  xhemm3m_olcopyr_NANO,
  xhemm3m_oucopyi_NANO,  xhemm3m_olcopyi_NANO,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_NANO, xlaswp_ncopy_NANO,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_NANO,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_NANO,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_NANO,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_NANO,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_NANO, somatcopy_k_ct_NANO, somatcopy_k_rn_NANO, somatcopy_k_rt_NANO,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_NANO, domatcopy_k_ct_NANO, domatcopy_k_rn_NANO, domatcopy_k_rt_NANO,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_NANO, comatcopy_k_ct_NANO, comatcopy_k_rn_NANO, comatcopy_k_rt_NANO,
  comatcopy_k_cnc_NANO, comatcopy_k_ctc_NANO, comatcopy_k_rnc_NANO, comatcopy_k_rtc_NANO,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_NANO, zomatcopy_k_ct_NANO, zomatcopy_k_rn_NANO, zomatcopy_k_rt_NANO,
  zomatcopy_k_cnc_NANO, zomatcopy_k_ctc_NANO, zomatcopy_k_rnc_NANO, zomatcopy_k_rtc_NANO,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_NANO, simatcopy_k_ct_NANO, simatcopy_k_rn_NANO, simatcopy_k_rt_NANO,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_NANO, dimatcopy_k_ct_NANO, dimatcopy_k_rn_NANO, dimatcopy_k_rt_NANO,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_NANO, cimatcopy_k_ct_NANO, cimatcopy_k_rn_NANO, cimatcopy_k_rt_NANO,
  cimatcopy_k_cnc_NANO, cimatcopy_k_ctc_NANO, cimatcopy_k_rnc_NANO, cimatcopy_k_rtc_NANO,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_NANO, zimatcopy_k_ct_NANO, zimatcopy_k_rn_NANO, zimatcopy_k_rt_NANO,
  zimatcopy_k_cnc_NANO, zimatcopy_k_ctc_NANO, zimatcopy_k_rnc_NANO, zimatcopy_k_rtc_NANO,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_NANO,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_NANO,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_NANO,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_NANO
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
