/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_OPTERON_SSE3;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_OPTERON_SSE3.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_OPTERON_SSE3, sbdtobf16_k_OPTERON_SSE3, sbf16tos_k_OPTERON_SSE3, dbf16tod_k_OPTERON_SSE3,

  samax_k_OPTERON_SSE3,  samin_k_OPTERON_SSE3,  smax_k_OPTERON_SSE3,  smin_k_OPTERON_SSE3,
  isamax_k_OPTERON_SSE3, isamin_k_OPTERON_SSE3, ismax_k_OPTERON_SSE3, ismin_k_OPTERON_SSE3,
  snrm2_k_OPTERON_SSE3,  sasum_k_OPTERON_SSE3, ssum_k_OPTERON_SSE3, scopy_k_OPTERON_SSE3, sbdot_k_OPTERON_SSE3,
  dsdot_k_OPTERON_SSE3,
  srot_k_OPTERON_SSE3,   saxpy_k_OPTERON_SSE3,  sscal_k_OPTERON_SSE3, sswap_k_OPTERON_SSE3,
  sbgemv_n_OPTERON_SSE3, sbgemv_t_OPTERON_SSE3, sger_k_OPTERON_SSE3,
  ssymv_L_OPTERON_SSE3, ssymv_U_OPTERON_SSE3,

  sbgemm_kernel_OPTERON_SSE3, sbgemm_beta_OPTERON_SSE3,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_OPTERON_SSE3, sbgemm_itcopy_OPTERON_SSE3,
#else
  sbgemm_oncopy_OPTERON_SSE3, sbgemm_otcopy_OPTERON_SSE3,
#endif
  sbgemm_oncopy_OPTERON_SSE3, sbgemm_otcopy_OPTERON_SSE3,

  strsm_kernel_LN_OPTERON_SSE3, strsm_kernel_LT_OPTERON_SSE3, strsm_kernel_RN_OPTERON_SSE3, strsm_kernel_RT_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_OPTERON_SSE3, strsm_iunncopy_OPTERON_SSE3, strsm_iutucopy_OPTERON_SSE3, strsm_iutncopy_OPTERON_SSE3,
  strsm_ilnucopy_OPTERON_SSE3, strsm_ilnncopy_OPTERON_SSE3, strsm_iltucopy_OPTERON_SSE3, strsm_iltncopy_OPTERON_SSE3,
#else
  strsm_ounucopy_OPTERON_SSE3, strsm_ounncopy_OPTERON_SSE3, strsm_outucopy_OPTERON_SSE3, strsm_outncopy_OPTERON_SSE3,
  strsm_olnucopy_OPTERON_SSE3, strsm_olnncopy_OPTERON_SSE3, strsm_oltucopy_OPTERON_SSE3, strsm_oltncopy_OPTERON_SSE3,
#endif
  strsm_ounucopy_OPTERON_SSE3, strsm_ounncopy_OPTERON_SSE3, strsm_outucopy_OPTERON_SSE3, strsm_outncopy_OPTERON_SSE3,
  strsm_olnucopy_OPTERON_SSE3, strsm_olnncopy_OPTERON_SSE3, strsm_oltucopy_OPTERON_SSE3, strsm_oltncopy_OPTERON_SSE3,
  strmm_kernel_RN_OPTERON_SSE3, strmm_kernel_RT_OPTERON_SSE3, strmm_kernel_LN_OPTERON_SSE3, strmm_kernel_LT_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_OPTERON_SSE3, strmm_iunncopy_OPTERON_SSE3, strmm_iutucopy_OPTERON_SSE3, strmm_iutncopy_OPTERON_SSE3,
  strmm_ilnucopy_OPTERON_SSE3, strmm_ilnncopy_OPTERON_SSE3, strmm_iltucopy_OPTERON_SSE3, strmm_iltncopy_OPTERON_SSE3,
#else
  strmm_ounucopy_OPTERON_SSE3, strmm_ounncopy_OPTERON_SSE3, strmm_outucopy_OPTERON_SSE3, strmm_outncopy_OPTERON_SSE3,
  strmm_olnucopy_OPTERON_SSE3, strmm_olnncopy_OPTERON_SSE3, strmm_oltucopy_OPTERON_SSE3, strmm_oltncopy_OPTERON_SSE3,
#endif
  strmm_ounucopy_OPTERON_SSE3, strmm_ounncopy_OPTERON_SSE3, strmm_outucopy_OPTERON_SSE3, strmm_outncopy_OPTERON_SSE3,
  strmm_olnucopy_OPTERON_SSE3, strmm_olnncopy_OPTERON_SSE3, strmm_oltucopy_OPTERON_SSE3, strmm_oltncopy_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_OPTERON_SSE3, ssymm_iltcopy_OPTERON_SSE3,
#else
  ssymm_outcopy_OPTERON_SSE3, ssymm_oltcopy_OPTERON_SSE3,
#endif
  ssymm_outcopy_OPTERON_SSE3, ssymm_oltcopy_OPTERON_SSE3,

#ifndef NO_LAPACK
  sneg_tcopy_OPTERON_SSE3, slaswp_ncopy_OPTERON_SSE3,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_OPTERON_SSE3,
  sbgemm_small_kernel_nn_OPTERON_SSE3, sbgemm_small_kernel_nt_OPTERON_SSE3, sbgemm_small_kernel_tn_OPTERON_SSE3, sbgemm_small_kernel_tt_OPTERON_SSE3,
  sbgemm_small_kernel_b0_nn_OPTERON_SSE3, sbgemm_small_kernel_b0_nt_OPTERON_SSE3, sbgemm_small_kernel_b0_tn_OPTERON_SSE3, sbgemm_small_kernel_b0_tt_OPTERON_SSE3,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_OPTERON_SSE3,  samin_k_OPTERON_SSE3,  smax_k_OPTERON_SSE3,  smin_k_OPTERON_SSE3,
  isamax_k_OPTERON_SSE3, isamin_k_OPTERON_SSE3, ismax_k_OPTERON_SSE3, ismin_k_OPTERON_SSE3,
  snrm2_k_OPTERON_SSE3,  sasum_k_OPTERON_SSE3,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_OPTERON_SSE3,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_OPTERON_SSE3, sdot_k_OPTERON_SSE3,
//  dsdot_k_OPTERON_SSE3,
  srot_k_OPTERON_SSE3,   saxpy_k_OPTERON_SSE3,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_OPTERON_SSE3,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_OPTERON_SSE3,
  sgemv_n_OPTERON_SSE3,  sgemv_t_OPTERON_SSE3,
#endif
#if BUILD_SINGLE == 1  
  sger_k_OPTERON_SSE3,
  ssymv_L_OPTERON_SSE3, ssymv_U_OPTERON_SSE3,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_OPTERON_SSE3,
  sgemm_direct_performant_OPTERON_SSE3,	
#endif

  sgemm_kernel_OPTERON_SSE3, sgemm_beta_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_OPTERON_SSE3, sgemm_itcopy_OPTERON_SSE3,
#else
  sgemm_oncopy_OPTERON_SSE3, sgemm_otcopy_OPTERON_SSE3,
#endif
  sgemm_oncopy_OPTERON_SSE3, sgemm_otcopy_OPTERON_SSE3,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_OPTERON_SSE3,
  sgemm_small_kernel_nn_OPTERON_SSE3, sgemm_small_kernel_nt_OPTERON_SSE3, sgemm_small_kernel_tn_OPTERON_SSE3, sgemm_small_kernel_tt_OPTERON_SSE3,
  sgemm_small_kernel_b0_nn_OPTERON_SSE3, sgemm_small_kernel_b0_nt_OPTERON_SSE3, sgemm_small_kernel_b0_tn_OPTERON_SSE3, sgemm_small_kernel_b0_tt_OPTERON_SSE3,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_OPTERON_SSE3, strsm_kernel_LT_OPTERON_SSE3, strsm_kernel_RN_OPTERON_SSE3, strsm_kernel_RT_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_OPTERON_SSE3, strsm_iunncopy_OPTERON_SSE3, strsm_iutucopy_OPTERON_SSE3, strsm_iutncopy_OPTERON_SSE3,
  strsm_ilnucopy_OPTERON_SSE3, strsm_ilnncopy_OPTERON_SSE3, strsm_iltucopy_OPTERON_SSE3, strsm_iltncopy_OPTERON_SSE3,
#else
  strsm_ounucopy_OPTERON_SSE3, strsm_ounncopy_OPTERON_SSE3, strsm_outucopy_OPTERON_SSE3, strsm_outncopy_OPTERON_SSE3,
  strsm_olnucopy_OPTERON_SSE3, strsm_olnncopy_OPTERON_SSE3, strsm_oltucopy_OPTERON_SSE3, strsm_oltncopy_OPTERON_SSE3,
#endif
  strsm_ounucopy_OPTERON_SSE3, strsm_ounncopy_OPTERON_SSE3, strsm_outucopy_OPTERON_SSE3, strsm_outncopy_OPTERON_SSE3,
  strsm_olnucopy_OPTERON_SSE3, strsm_olnncopy_OPTERON_SSE3, strsm_oltucopy_OPTERON_SSE3, strsm_oltncopy_OPTERON_SSE3,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_OPTERON_SSE3, strmm_kernel_RT_OPTERON_SSE3, strmm_kernel_LN_OPTERON_SSE3, strmm_kernel_LT_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_OPTERON_SSE3, strmm_iunncopy_OPTERON_SSE3, strmm_iutucopy_OPTERON_SSE3, strmm_iutncopy_OPTERON_SSE3,
  strmm_ilnucopy_OPTERON_SSE3, strmm_ilnncopy_OPTERON_SSE3, strmm_iltucopy_OPTERON_SSE3, strmm_iltncopy_OPTERON_SSE3,
#else
  strmm_ounucopy_OPTERON_SSE3, strmm_ounncopy_OPTERON_SSE3, strmm_outucopy_OPTERON_SSE3, strmm_outncopy_OPTERON_SSE3,
  strmm_olnucopy_OPTERON_SSE3, strmm_olnncopy_OPTERON_SSE3, strmm_oltucopy_OPTERON_SSE3, strmm_oltncopy_OPTERON_SSE3,
#endif
  strmm_ounucopy_OPTERON_SSE3, strmm_ounncopy_OPTERON_SSE3, strmm_outucopy_OPTERON_SSE3, strmm_outncopy_OPTERON_SSE3,
  strmm_olnucopy_OPTERON_SSE3, strmm_olnncopy_OPTERON_SSE3, strmm_oltucopy_OPTERON_SSE3, strmm_oltncopy_OPTERON_SSE3,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_OPTERON_SSE3, ssymm_iltcopy_OPTERON_SSE3,
#else
  ssymm_outcopy_OPTERON_SSE3, ssymm_oltcopy_OPTERON_SSE3,
#endif
  ssymm_outcopy_OPTERON_SSE3, ssymm_oltcopy_OPTERON_SSE3,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_OPTERON_SSE3, slaswp_ncopy_OPTERON_SSE3,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_OPTERON_SSE3,  damin_k_OPTERON_SSE3,  dmax_k_OPTERON_SSE3,  dmin_k_OPTERON_SSE3,
  idamax_k_OPTERON_SSE3, idamin_k_OPTERON_SSE3, idmax_k_OPTERON_SSE3, idmin_k_OPTERON_SSE3,
  dnrm2_k_OPTERON_SSE3, dasum_k_OPTERON_SSE3,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_OPTERON_SSE3,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_OPTERON_SSE3, ddot_k_OPTERON_SSE3,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_OPTERON_SSE3,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_OPTERON_SSE3,
  daxpy_k_OPTERON_SSE3,
  dscal_k_OPTERON_SSE3, 
  dswap_k_OPTERON_SSE3,
  dgemv_n_OPTERON_SSE3,  dgemv_t_OPTERON_SSE3,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_OPTERON_SSE3,
  dsymv_L_OPTERON_SSE3,  dsymv_U_OPTERON_SSE3,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_OPTERON_SSE3, dgemm_beta_OPTERON_SSE3,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_OPTERON_SSE3, dgemm_itcopy_OPTERON_SSE3,
#else
  dgemm_oncopy_OPTERON_SSE3, dgemm_otcopy_OPTERON_SSE3,
#endif
  dgemm_oncopy_OPTERON_SSE3, dgemm_otcopy_OPTERON_SSE3,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_OPTERON_SSE3,
  dgemm_small_kernel_nn_OPTERON_SSE3, dgemm_small_kernel_nt_OPTERON_SSE3, dgemm_small_kernel_tn_OPTERON_SSE3, dgemm_small_kernel_tt_OPTERON_SSE3,
  dgemm_small_kernel_b0_nn_OPTERON_SSE3, dgemm_small_kernel_b0_nt_OPTERON_SSE3, dgemm_small_kernel_b0_tn_OPTERON_SSE3, dgemm_small_kernel_b0_tt_OPTERON_SSE3,
#endif
  dtrsm_kernel_LN_OPTERON_SSE3, dtrsm_kernel_LT_OPTERON_SSE3, dtrsm_kernel_RN_OPTERON_SSE3, dtrsm_kernel_RT_OPTERON_SSE3,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_OPTERON_SSE3, dtrsm_iunncopy_OPTERON_SSE3, dtrsm_iutucopy_OPTERON_SSE3, dtrsm_iutncopy_OPTERON_SSE3,
  dtrsm_ilnucopy_OPTERON_SSE3, dtrsm_ilnncopy_OPTERON_SSE3, dtrsm_iltucopy_OPTERON_SSE3, dtrsm_iltncopy_OPTERON_SSE3,
#else
  dtrsm_ounucopy_OPTERON_SSE3, dtrsm_ounncopy_OPTERON_SSE3, dtrsm_outucopy_OPTERON_SSE3, dtrsm_outncopy_OPTERON_SSE3,
  dtrsm_olnucopy_OPTERON_SSE3, dtrsm_olnncopy_OPTERON_SSE3, dtrsm_oltucopy_OPTERON_SSE3, dtrsm_oltncopy_OPTERON_SSE3,
#endif
  dtrsm_ounucopy_OPTERON_SSE3, dtrsm_ounncopy_OPTERON_SSE3, dtrsm_outucopy_OPTERON_SSE3, dtrsm_outncopy_OPTERON_SSE3,
  dtrsm_olnucopy_OPTERON_SSE3, dtrsm_olnncopy_OPTERON_SSE3, dtrsm_oltucopy_OPTERON_SSE3, dtrsm_oltncopy_OPTERON_SSE3,
  dtrmm_kernel_RN_OPTERON_SSE3, dtrmm_kernel_RT_OPTERON_SSE3, dtrmm_kernel_LN_OPTERON_SSE3, dtrmm_kernel_LT_OPTERON_SSE3,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_OPTERON_SSE3, dtrmm_iunncopy_OPTERON_SSE3, dtrmm_iutucopy_OPTERON_SSE3, dtrmm_iutncopy_OPTERON_SSE3,
  dtrmm_ilnucopy_OPTERON_SSE3, dtrmm_ilnncopy_OPTERON_SSE3, dtrmm_iltucopy_OPTERON_SSE3, dtrmm_iltncopy_OPTERON_SSE3,
#else
  dtrmm_ounucopy_OPTERON_SSE3, dtrmm_ounncopy_OPTERON_SSE3, dtrmm_outucopy_OPTERON_SSE3, dtrmm_outncopy_OPTERON_SSE3,
  dtrmm_olnucopy_OPTERON_SSE3, dtrmm_olnncopy_OPTERON_SSE3, dtrmm_oltucopy_OPTERON_SSE3, dtrmm_oltncopy_OPTERON_SSE3,
#endif
  dtrmm_ounucopy_OPTERON_SSE3, dtrmm_ounncopy_OPTERON_SSE3, dtrmm_outucopy_OPTERON_SSE3, dtrmm_outncopy_OPTERON_SSE3,
  dtrmm_olnucopy_OPTERON_SSE3, dtrmm_olnncopy_OPTERON_SSE3, dtrmm_oltucopy_OPTERON_SSE3, dtrmm_oltncopy_OPTERON_SSE3,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_OPTERON_SSE3, dsymm_iltcopy_OPTERON_SSE3,
#else
  dsymm_outcopy_OPTERON_SSE3, dsymm_oltcopy_OPTERON_SSE3,
#endif
  dsymm_outcopy_OPTERON_SSE3, dsymm_oltcopy_OPTERON_SSE3,

#ifndef NO_LAPACK
  dneg_tcopy_OPTERON_SSE3, dlaswp_ncopy_OPTERON_SSE3,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_OPTERON_SSE3,  qamin_k_OPTERON_SSE3,  qmax_k_OPTERON_SSE3,  qmin_k_OPTERON_SSE3,
  iqamax_k_OPTERON_SSE3, iqamin_k_OPTERON_SSE3, iqmax_k_OPTERON_SSE3, iqmin_k_OPTERON_SSE3,
  qnrm2_k_OPTERON_SSE3,  qasum_k_OPTERON_SSE3,  qsum_k_OPTERON_SSE3, qcopy_k_OPTERON_SSE3, qdot_k_OPTERON_SSE3,
  qrot_k_OPTERON_SSE3,   qaxpy_k_OPTERON_SSE3,  qscal_k_OPTERON_SSE3, qswap_k_OPTERON_SSE3,
  qgemv_n_OPTERON_SSE3,  qgemv_t_OPTERON_SSE3,  qger_k_OPTERON_SSE3,
  qsymv_L_OPTERON_SSE3,  qsymv_U_OPTERON_SSE3,

  qgemm_kernel_OPTERON_SSE3, qgemm_beta_OPTERON_SSE3,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_OPTERON_SSE3, qgemm_itcopy_OPTERON_SSE3,
#else
  qgemm_oncopy_OPTERON_SSE3, qgemm_otcopy_OPTERON_SSE3,
#endif
  qgemm_oncopy_OPTERON_SSE3, qgemm_otcopy_OPTERON_SSE3,
  qtrsm_kernel_LN_OPTERON_SSE3, qtrsm_kernel_LT_OPTERON_SSE3, qtrsm_kernel_RN_OPTERON_SSE3, qtrsm_kernel_RT_OPTERON_SSE3,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_OPTERON_SSE3, qtrsm_iunncopy_OPTERON_SSE3, qtrsm_iutucopy_OPTERON_SSE3, qtrsm_iutncopy_OPTERON_SSE3,
  qtrsm_ilnucopy_OPTERON_SSE3, qtrsm_ilnncopy_OPTERON_SSE3, qtrsm_iltucopy_OPTERON_SSE3, qtrsm_iltncopy_OPTERON_SSE3,
#else
  qtrsm_ounucopy_OPTERON_SSE3, qtrsm_ounncopy_OPTERON_SSE3, qtrsm_outucopy_OPTERON_SSE3, qtrsm_outncopy_OPTERON_SSE3,
  qtrsm_olnucopy_OPTERON_SSE3, qtrsm_olnncopy_OPTERON_SSE3, qtrsm_oltucopy_OPTERON_SSE3, qtrsm_oltncopy_OPTERON_SSE3,
#endif
  qtrsm_ounucopy_OPTERON_SSE3, qtrsm_ounncopy_OPTERON_SSE3, qtrsm_outucopy_OPTERON_SSE3, qtrsm_outncopy_OPTERON_SSE3,
  qtrsm_olnucopy_OPTERON_SSE3, qtrsm_olnncopy_OPTERON_SSE3, qtrsm_oltucopy_OPTERON_SSE3, qtrsm_oltncopy_OPTERON_SSE3,
  qtrmm_kernel_RN_OPTERON_SSE3, qtrmm_kernel_RT_OPTERON_SSE3, qtrmm_kernel_LN_OPTERON_SSE3, qtrmm_kernel_LT_OPTERON_SSE3,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_OPTERON_SSE3, qtrmm_iunncopy_OPTERON_SSE3, qtrmm_iutucopy_OPTERON_SSE3, qtrmm_iutncopy_OPTERON_SSE3,
  qtrmm_ilnucopy_OPTERON_SSE3, qtrmm_ilnncopy_OPTERON_SSE3, qtrmm_iltucopy_OPTERON_SSE3, qtrmm_iltncopy_OPTERON_SSE3,
#else
  qtrmm_ounucopy_OPTERON_SSE3, qtrmm_ounncopy_OPTERON_SSE3, qtrmm_outucopy_OPTERON_SSE3, qtrmm_outncopy_OPTERON_SSE3,
  qtrmm_olnucopy_OPTERON_SSE3, qtrmm_olnncopy_OPTERON_SSE3, qtrmm_oltucopy_OPTERON_SSE3, qtrmm_oltncopy_OPTERON_SSE3,
#endif
  qtrmm_ounucopy_OPTERON_SSE3, qtrmm_ounncopy_OPTERON_SSE3, qtrmm_outucopy_OPTERON_SSE3, qtrmm_outncopy_OPTERON_SSE3,
  qtrmm_olnucopy_OPTERON_SSE3, qtrmm_olnncopy_OPTERON_SSE3, qtrmm_oltucopy_OPTERON_SSE3, qtrmm_oltncopy_OPTERON_SSE3,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_OPTERON_SSE3, qsymm_iltcopy_OPTERON_SSE3,
#else
  qsymm_outcopy_OPTERON_SSE3, qsymm_oltcopy_OPTERON_SSE3,
#endif
  qsymm_outcopy_OPTERON_SSE3, qsymm_oltcopy_OPTERON_SSE3,

#ifndef NO_LAPACK
  qneg_tcopy_OPTERON_SSE3, qlaswp_ncopy_OPTERON_SSE3,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_OPTERON_SSE3, camin_k_OPTERON_SSE3, icamax_k_OPTERON_SSE3, icamin_k_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_OPTERON_SSE3, casum_k_OPTERON_SSE3, csum_k_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_OPTERON_SSE3,  cdotu_k_OPTERON_SSE3, cdotc_k_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX)
 csrot_k_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_OPTERON_SSE3,
  caxpyc_k_OPTERON_SSE3, 
  cscal_k_OPTERON_SSE3, 
  cswap_k_OPTERON_SSE3,

  cgemv_n_OPTERON_SSE3, cgemv_t_OPTERON_SSE3, cgemv_r_OPTERON_SSE3, cgemv_c_OPTERON_SSE3,
  cgemv_o_OPTERON_SSE3, cgemv_u_OPTERON_SSE3, cgemv_s_OPTERON_SSE3, cgemv_d_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_OPTERON_SSE3, cgerc_k_OPTERON_SSE3, cgerv_k_OPTERON_SSE3, cgerd_k_OPTERON_SSE3,
  csymv_L_OPTERON_SSE3, csymv_U_OPTERON_SSE3,
  chemv_L_OPTERON_SSE3, chemv_U_OPTERON_SSE3, chemv_M_OPTERON_SSE3, chemv_V_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_OPTERON_SSE3, cgemm_kernel_l_OPTERON_SSE3, cgemm_kernel_r_OPTERON_SSE3, cgemm_kernel_b_OPTERON_SSE3,
  cgemm_beta_OPTERON_SSE3,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_OPTERON_SSE3, cgemm_itcopy_OPTERON_SSE3,
#else
  cgemm_oncopy_OPTERON_SSE3, cgemm_otcopy_OPTERON_SSE3,
#endif
  cgemm_oncopy_OPTERON_SSE3, cgemm_otcopy_OPTERON_SSE3,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_OPTERON_SSE3,
  cgemm_small_kernel_nn_OPTERON_SSE3, cgemm_small_kernel_nt_OPTERON_SSE3, cgemm_small_kernel_nr_OPTERON_SSE3, cgemm_small_kernel_nc_OPTERON_SSE3,
  cgemm_small_kernel_tn_OPTERON_SSE3, cgemm_small_kernel_tt_OPTERON_SSE3, cgemm_small_kernel_tr_OPTERON_SSE3, cgemm_small_kernel_tc_OPTERON_SSE3,
  cgemm_small_kernel_rn_OPTERON_SSE3, cgemm_small_kernel_rt_OPTERON_SSE3, cgemm_small_kernel_rr_OPTERON_SSE3, cgemm_small_kernel_rc_OPTERON_SSE3,
  cgemm_small_kernel_cn_OPTERON_SSE3, cgemm_small_kernel_ct_OPTERON_SSE3, cgemm_small_kernel_cr_OPTERON_SSE3, cgemm_small_kernel_cc_OPTERON_SSE3,
  cgemm_small_kernel_b0_nn_OPTERON_SSE3, cgemm_small_kernel_b0_nt_OPTERON_SSE3, cgemm_small_kernel_b0_nr_OPTERON_SSE3, cgemm_small_kernel_b0_nc_OPTERON_SSE3,
  cgemm_small_kernel_b0_tn_OPTERON_SSE3, cgemm_small_kernel_b0_tt_OPTERON_SSE3, cgemm_small_kernel_b0_tr_OPTERON_SSE3, cgemm_small_kernel_b0_tc_OPTERON_SSE3,
  cgemm_small_kernel_b0_rn_OPTERON_SSE3, cgemm_small_kernel_b0_rt_OPTERON_SSE3, cgemm_small_kernel_b0_rr_OPTERON_SSE3, cgemm_small_kernel_b0_rc_OPTERON_SSE3,
  cgemm_small_kernel_b0_cn_OPTERON_SSE3, cgemm_small_kernel_b0_ct_OPTERON_SSE3, cgemm_small_kernel_b0_cr_OPTERON_SSE3, cgemm_small_kernel_b0_cc_OPTERON_SSE3,
#endif

  ctrsm_kernel_LN_OPTERON_SSE3, ctrsm_kernel_LT_OPTERON_SSE3, ctrsm_kernel_LR_OPTERON_SSE3, ctrsm_kernel_LC_OPTERON_SSE3,
  ctrsm_kernel_RN_OPTERON_SSE3, ctrsm_kernel_RT_OPTERON_SSE3, ctrsm_kernel_RR_OPTERON_SSE3, ctrsm_kernel_RC_OPTERON_SSE3,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_OPTERON_SSE3,  ctrsm_iunncopy_OPTERON_SSE3,  ctrsm_iutucopy_OPTERON_SSE3,  ctrsm_iutncopy_OPTERON_SSE3,
  ctrsm_ilnucopy_OPTERON_SSE3,  ctrsm_ilnncopy_OPTERON_SSE3,  ctrsm_iltucopy_OPTERON_SSE3,  ctrsm_iltncopy_OPTERON_SSE3,
#else
  ctrsm_ounucopy_OPTERON_SSE3,  ctrsm_ounncopy_OPTERON_SSE3,  ctrsm_outucopy_OPTERON_SSE3,  ctrsm_outncopy_OPTERON_SSE3,
  ctrsm_olnucopy_OPTERON_SSE3,  ctrsm_olnncopy_OPTERON_SSE3,  ctrsm_oltucopy_OPTERON_SSE3,  ctrsm_oltncopy_OPTERON_SSE3,
#endif
  ctrsm_ounucopy_OPTERON_SSE3,  ctrsm_ounncopy_OPTERON_SSE3,  ctrsm_outucopy_OPTERON_SSE3,  ctrsm_outncopy_OPTERON_SSE3,
  ctrsm_olnucopy_OPTERON_SSE3,  ctrsm_olnncopy_OPTERON_SSE3,  ctrsm_oltucopy_OPTERON_SSE3,  ctrsm_oltncopy_OPTERON_SSE3,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_OPTERON_SSE3,  ctrmm_kernel_RT_OPTERON_SSE3,  ctrmm_kernel_RR_OPTERON_SSE3,  ctrmm_kernel_RC_OPTERON_SSE3,
  ctrmm_kernel_LN_OPTERON_SSE3,  ctrmm_kernel_LT_OPTERON_SSE3,  ctrmm_kernel_LR_OPTERON_SSE3,  ctrmm_kernel_LC_OPTERON_SSE3,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_OPTERON_SSE3,  ctrmm_iunncopy_OPTERON_SSE3,  ctrmm_iutucopy_OPTERON_SSE3,  ctrmm_iutncopy_OPTERON_SSE3,
  ctrmm_ilnucopy_OPTERON_SSE3,  ctrmm_ilnncopy_OPTERON_SSE3,  ctrmm_iltucopy_OPTERON_SSE3,  ctrmm_iltncopy_OPTERON_SSE3,
#else
  ctrmm_ounucopy_OPTERON_SSE3,  ctrmm_ounncopy_OPTERON_SSE3,  ctrmm_outucopy_OPTERON_SSE3,  ctrmm_outncopy_OPTERON_SSE3,
  ctrmm_olnucopy_OPTERON_SSE3,  ctrmm_olnncopy_OPTERON_SSE3,  ctrmm_oltucopy_OPTERON_SSE3,  ctrmm_oltncopy_OPTERON_SSE3,
#endif
  ctrmm_ounucopy_OPTERON_SSE3,  ctrmm_ounncopy_OPTERON_SSE3,  ctrmm_outucopy_OPTERON_SSE3,  ctrmm_outncopy_OPTERON_SSE3,
  ctrmm_olnucopy_OPTERON_SSE3,  ctrmm_olnncopy_OPTERON_SSE3,  ctrmm_oltucopy_OPTERON_SSE3,  ctrmm_oltncopy_OPTERON_SSE3,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_OPTERON_SSE3,  csymm_iltcopy_OPTERON_SSE3,
#else
  csymm_outcopy_OPTERON_SSE3,  csymm_oltcopy_OPTERON_SSE3,
#endif
  csymm_outcopy_OPTERON_SSE3,  csymm_oltcopy_OPTERON_SSE3,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_OPTERON_SSE3,  chemm_iltcopy_OPTERON_SSE3,
#else
  chemm_outcopy_OPTERON_SSE3,  chemm_oltcopy_OPTERON_SSE3,
#endif
  chemm_outcopy_OPTERON_SSE3,  chemm_oltcopy_OPTERON_SSE3,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_OPTERON_SSE3,

  cgemm3m_incopyb_OPTERON_SSE3,  cgemm3m_incopyr_OPTERON_SSE3,
  cgemm3m_incopyi_OPTERON_SSE3,  cgemm3m_itcopyb_OPTERON_SSE3,
  cgemm3m_itcopyr_OPTERON_SSE3,  cgemm3m_itcopyi_OPTERON_SSE3,
  cgemm3m_oncopyb_OPTERON_SSE3,  cgemm3m_oncopyr_OPTERON_SSE3,
  cgemm3m_oncopyi_OPTERON_SSE3,  cgemm3m_otcopyb_OPTERON_SSE3,
  cgemm3m_otcopyr_OPTERON_SSE3,  cgemm3m_otcopyi_OPTERON_SSE3,

  csymm3m_iucopyb_OPTERON_SSE3,  csymm3m_ilcopyb_OPTERON_SSE3,
  csymm3m_iucopyr_OPTERON_SSE3,  csymm3m_ilcopyr_OPTERON_SSE3,
  csymm3m_iucopyi_OPTERON_SSE3,  csymm3m_ilcopyi_OPTERON_SSE3,
  csymm3m_oucopyb_OPTERON_SSE3,  csymm3m_olcopyb_OPTERON_SSE3,
  csymm3m_oucopyr_OPTERON_SSE3,  csymm3m_olcopyr_OPTERON_SSE3,
  csymm3m_oucopyi_OPTERON_SSE3,  csymm3m_olcopyi_OPTERON_SSE3,

  chemm3m_iucopyb_OPTERON_SSE3,  chemm3m_ilcopyb_OPTERON_SSE3,
  chemm3m_iucopyr_OPTERON_SSE3,  chemm3m_ilcopyr_OPTERON_SSE3,
  chemm3m_iucopyi_OPTERON_SSE3,  chemm3m_ilcopyi_OPTERON_SSE3,

  chemm3m_oucopyb_OPTERON_SSE3,  chemm3m_olcopyb_OPTERON_SSE3,
  chemm3m_oucopyr_OPTERON_SSE3,  chemm3m_olcopyr_OPTERON_SSE3,
  chemm3m_oucopyi_OPTERON_SSE3,  chemm3m_olcopyi_OPTERON_SSE3,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_OPTERON_SSE3,
  
   claswp_ncopy_OPTERON_SSE3,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_OPTERON_SSE3, zamin_k_OPTERON_SSE3, izamax_k_OPTERON_SSE3, izamin_k_OPTERON_SSE3,
  znrm2_k_OPTERON_SSE3, zasum_k_OPTERON_SSE3, zsum_k_OPTERON_SSE3, zcopy_k_OPTERON_SSE3,
  zdotu_k_OPTERON_SSE3, zdotc_k_OPTERON_SSE3, zdrot_k_OPTERON_SSE3,
  zaxpy_k_OPTERON_SSE3, zaxpyc_k_OPTERON_SSE3, zscal_k_OPTERON_SSE3, zswap_k_OPTERON_SSE3,

  zgemv_n_OPTERON_SSE3, zgemv_t_OPTERON_SSE3, zgemv_r_OPTERON_SSE3, zgemv_c_OPTERON_SSE3,
  zgemv_o_OPTERON_SSE3, zgemv_u_OPTERON_SSE3, zgemv_s_OPTERON_SSE3, zgemv_d_OPTERON_SSE3,
  zgeru_k_OPTERON_SSE3, zgerc_k_OPTERON_SSE3, zgerv_k_OPTERON_SSE3, zgerd_k_OPTERON_SSE3,
  zsymv_L_OPTERON_SSE3, zsymv_U_OPTERON_SSE3,
  zhemv_L_OPTERON_SSE3, zhemv_U_OPTERON_SSE3, zhemv_M_OPTERON_SSE3, zhemv_V_OPTERON_SSE3,

  zgemm_kernel_n_OPTERON_SSE3, zgemm_kernel_l_OPTERON_SSE3, zgemm_kernel_r_OPTERON_SSE3, zgemm_kernel_b_OPTERON_SSE3,
  zgemm_beta_OPTERON_SSE3,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_OPTERON_SSE3, zgemm_itcopy_OPTERON_SSE3,
#else
  zgemm_oncopy_OPTERON_SSE3, zgemm_otcopy_OPTERON_SSE3,
#endif
  zgemm_oncopy_OPTERON_SSE3, zgemm_otcopy_OPTERON_SSE3,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_OPTERON_SSE3,
  zgemm_small_kernel_nn_OPTERON_SSE3, zgemm_small_kernel_nt_OPTERON_SSE3, zgemm_small_kernel_nr_OPTERON_SSE3, zgemm_small_kernel_nc_OPTERON_SSE3,
  zgemm_small_kernel_tn_OPTERON_SSE3, zgemm_small_kernel_tt_OPTERON_SSE3, zgemm_small_kernel_tr_OPTERON_SSE3, zgemm_small_kernel_tc_OPTERON_SSE3,
  zgemm_small_kernel_rn_OPTERON_SSE3, zgemm_small_kernel_rt_OPTERON_SSE3, zgemm_small_kernel_rr_OPTERON_SSE3, zgemm_small_kernel_rc_OPTERON_SSE3,
  zgemm_small_kernel_cn_OPTERON_SSE3, zgemm_small_kernel_ct_OPTERON_SSE3, zgemm_small_kernel_cr_OPTERON_SSE3, zgemm_small_kernel_cc_OPTERON_SSE3,
  zgemm_small_kernel_b0_nn_OPTERON_SSE3, zgemm_small_kernel_b0_nt_OPTERON_SSE3, zgemm_small_kernel_b0_nr_OPTERON_SSE3, zgemm_small_kernel_b0_nc_OPTERON_SSE3,
  zgemm_small_kernel_b0_tn_OPTERON_SSE3, zgemm_small_kernel_b0_tt_OPTERON_SSE3, zgemm_small_kernel_b0_tr_OPTERON_SSE3, zgemm_small_kernel_b0_tc_OPTERON_SSE3,
  zgemm_small_kernel_b0_rn_OPTERON_SSE3, zgemm_small_kernel_b0_rt_OPTERON_SSE3, zgemm_small_kernel_b0_rr_OPTERON_SSE3, zgemm_small_kernel_b0_rc_OPTERON_SSE3,
  zgemm_small_kernel_b0_cn_OPTERON_SSE3, zgemm_small_kernel_b0_ct_OPTERON_SSE3, zgemm_small_kernel_b0_cr_OPTERON_SSE3, zgemm_small_kernel_b0_cc_OPTERON_SSE3,
#endif

  ztrsm_kernel_LN_OPTERON_SSE3, ztrsm_kernel_LT_OPTERON_SSE3, ztrsm_kernel_LR_OPTERON_SSE3, ztrsm_kernel_LC_OPTERON_SSE3,
  ztrsm_kernel_RN_OPTERON_SSE3, ztrsm_kernel_RT_OPTERON_SSE3, ztrsm_kernel_RR_OPTERON_SSE3, ztrsm_kernel_RC_OPTERON_SSE3,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_OPTERON_SSE3,  ztrsm_iunncopy_OPTERON_SSE3,  ztrsm_iutucopy_OPTERON_SSE3,  ztrsm_iutncopy_OPTERON_SSE3,
  ztrsm_ilnucopy_OPTERON_SSE3,  ztrsm_ilnncopy_OPTERON_SSE3,  ztrsm_iltucopy_OPTERON_SSE3,  ztrsm_iltncopy_OPTERON_SSE3,
#else
  ztrsm_ounucopy_OPTERON_SSE3,  ztrsm_ounncopy_OPTERON_SSE3,  ztrsm_outucopy_OPTERON_SSE3,  ztrsm_outncopy_OPTERON_SSE3,
  ztrsm_olnucopy_OPTERON_SSE3,  ztrsm_olnncopy_OPTERON_SSE3,  ztrsm_oltucopy_OPTERON_SSE3,  ztrsm_oltncopy_OPTERON_SSE3,
#endif
  ztrsm_ounucopy_OPTERON_SSE3,  ztrsm_ounncopy_OPTERON_SSE3,  ztrsm_outucopy_OPTERON_SSE3,  ztrsm_outncopy_OPTERON_SSE3,
  ztrsm_olnucopy_OPTERON_SSE3,  ztrsm_olnncopy_OPTERON_SSE3,  ztrsm_oltucopy_OPTERON_SSE3,  ztrsm_oltncopy_OPTERON_SSE3,

  ztrmm_kernel_RN_OPTERON_SSE3,  ztrmm_kernel_RT_OPTERON_SSE3,  ztrmm_kernel_RR_OPTERON_SSE3,  ztrmm_kernel_RC_OPTERON_SSE3,
  ztrmm_kernel_LN_OPTERON_SSE3,  ztrmm_kernel_LT_OPTERON_SSE3,  ztrmm_kernel_LR_OPTERON_SSE3,  ztrmm_kernel_LC_OPTERON_SSE3,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_OPTERON_SSE3,  ztrmm_iunncopy_OPTERON_SSE3,  ztrmm_iutucopy_OPTERON_SSE3,  ztrmm_iutncopy_OPTERON_SSE3,
  ztrmm_ilnucopy_OPTERON_SSE3,  ztrmm_ilnncopy_OPTERON_SSE3,  ztrmm_iltucopy_OPTERON_SSE3,  ztrmm_iltncopy_OPTERON_SSE3,
#else
  ztrmm_ounucopy_OPTERON_SSE3,  ztrmm_ounncopy_OPTERON_SSE3,  ztrmm_outucopy_OPTERON_SSE3,  ztrmm_outncopy_OPTERON_SSE3,
  ztrmm_olnucopy_OPTERON_SSE3,  ztrmm_olnncopy_OPTERON_SSE3,  ztrmm_oltucopy_OPTERON_SSE3,  ztrmm_oltncopy_OPTERON_SSE3,
#endif
  ztrmm_ounucopy_OPTERON_SSE3,  ztrmm_ounncopy_OPTERON_SSE3,  ztrmm_outucopy_OPTERON_SSE3,  ztrmm_outncopy_OPTERON_SSE3,
  ztrmm_olnucopy_OPTERON_SSE3,  ztrmm_olnncopy_OPTERON_SSE3,  ztrmm_oltucopy_OPTERON_SSE3,  ztrmm_oltncopy_OPTERON_SSE3,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_OPTERON_SSE3,  zsymm_iltcopy_OPTERON_SSE3,
#else
  zsymm_outcopy_OPTERON_SSE3,  zsymm_oltcopy_OPTERON_SSE3,
#endif
  zsymm_outcopy_OPTERON_SSE3,  zsymm_oltcopy_OPTERON_SSE3,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_OPTERON_SSE3,  zhemm_iltcopy_OPTERON_SSE3,
#else
  zhemm_outcopy_OPTERON_SSE3,  zhemm_oltcopy_OPTERON_SSE3,
#endif
  zhemm_outcopy_OPTERON_SSE3,  zhemm_oltcopy_OPTERON_SSE3,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_OPTERON_SSE3,

  zgemm3m_incopyb_OPTERON_SSE3,  zgemm3m_incopyr_OPTERON_SSE3,
  zgemm3m_incopyi_OPTERON_SSE3,  zgemm3m_itcopyb_OPTERON_SSE3,
  zgemm3m_itcopyr_OPTERON_SSE3,  zgemm3m_itcopyi_OPTERON_SSE3,
  zgemm3m_oncopyb_OPTERON_SSE3,  zgemm3m_oncopyr_OPTERON_SSE3,
  zgemm3m_oncopyi_OPTERON_SSE3,  zgemm3m_otcopyb_OPTERON_SSE3,
  zgemm3m_otcopyr_OPTERON_SSE3,  zgemm3m_otcopyi_OPTERON_SSE3,

  zsymm3m_iucopyb_OPTERON_SSE3,  zsymm3m_ilcopyb_OPTERON_SSE3,
  zsymm3m_iucopyr_OPTERON_SSE3,  zsymm3m_ilcopyr_OPTERON_SSE3,
  zsymm3m_iucopyi_OPTERON_SSE3,  zsymm3m_ilcopyi_OPTERON_SSE3,
  zsymm3m_oucopyb_OPTERON_SSE3,  zsymm3m_olcopyb_OPTERON_SSE3,
  zsymm3m_oucopyr_OPTERON_SSE3,  zsymm3m_olcopyr_OPTERON_SSE3,
  zsymm3m_oucopyi_OPTERON_SSE3,  zsymm3m_olcopyi_OPTERON_SSE3,

  zhemm3m_iucopyb_OPTERON_SSE3,  zhemm3m_ilcopyb_OPTERON_SSE3,
  zhemm3m_iucopyr_OPTERON_SSE3,  zhemm3m_ilcopyr_OPTERON_SSE3,
  zhemm3m_iucopyi_OPTERON_SSE3,  zhemm3m_ilcopyi_OPTERON_SSE3,

  zhemm3m_oucopyb_OPTERON_SSE3,  zhemm3m_olcopyb_OPTERON_SSE3,
  zhemm3m_oucopyr_OPTERON_SSE3,  zhemm3m_olcopyr_OPTERON_SSE3,
  zhemm3m_oucopyi_OPTERON_SSE3,  zhemm3m_olcopyi_OPTERON_SSE3,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_OPTERON_SSE3, zlaswp_ncopy_OPTERON_SSE3,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_OPTERON_SSE3, xamin_k_OPTERON_SSE3, ixamax_k_OPTERON_SSE3, ixamin_k_OPTERON_SSE3,
  xnrm2_k_OPTERON_SSE3, xasum_k_OPTERON_SSE3, xsum_k_OPTERON_SSE3, xcopy_k_OPTERON_SSE3,
  xdotu_k_OPTERON_SSE3, xdotc_k_OPTERON_SSE3, xqrot_k_OPTERON_SSE3,
  xaxpy_k_OPTERON_SSE3, xaxpyc_k_OPTERON_SSE3, xscal_k_OPTERON_SSE3, xswap_k_OPTERON_SSE3,

  xgemv_n_OPTERON_SSE3, xgemv_t_OPTERON_SSE3, xgemv_r_OPTERON_SSE3, xgemv_c_OPTERON_SSE3,
  xgemv_o_OPTERON_SSE3, xgemv_u_OPTERON_SSE3, xgemv_s_OPTERON_SSE3, xgemv_d_OPTERON_SSE3,
  xgeru_k_OPTERON_SSE3, xgerc_k_OPTERON_SSE3, xgerv_k_OPTERON_SSE3, xgerd_k_OPTERON_SSE3,
  xsymv_L_OPTERON_SSE3, xsymv_U_OPTERON_SSE3,
  xhemv_L_OPTERON_SSE3, xhemv_U_OPTERON_SSE3, xhemv_M_OPTERON_SSE3, xhemv_V_OPTERON_SSE3,

  xgemm_kernel_n_OPTERON_SSE3, xgemm_kernel_l_OPTERON_SSE3, xgemm_kernel_r_OPTERON_SSE3, xgemm_kernel_b_OPTERON_SSE3,
  xgemm_beta_OPTERON_SSE3,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_OPTERON_SSE3, xgemm_itcopy_OPTERON_SSE3,
#else
  xgemm_oncopy_OPTERON_SSE3, xgemm_otcopy_OPTERON_SSE3,
#endif
  xgemm_oncopy_OPTERON_SSE3, xgemm_otcopy_OPTERON_SSE3,

  xtrsm_kernel_LN_OPTERON_SSE3, xtrsm_kernel_LT_OPTERON_SSE3, xtrsm_kernel_LR_OPTERON_SSE3, xtrsm_kernel_LC_OPTERON_SSE3,
  xtrsm_kernel_RN_OPTERON_SSE3, xtrsm_kernel_RT_OPTERON_SSE3, xtrsm_kernel_RR_OPTERON_SSE3, xtrsm_kernel_RC_OPTERON_SSE3,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_OPTERON_SSE3,  xtrsm_iunncopy_OPTERON_SSE3,  xtrsm_iutucopy_OPTERON_SSE3,  xtrsm_iutncopy_OPTERON_SSE3,
  xtrsm_ilnucopy_OPTERON_SSE3,  xtrsm_ilnncopy_OPTERON_SSE3,  xtrsm_iltucopy_OPTERON_SSE3,  xtrsm_iltncopy_OPTERON_SSE3,
#else
  xtrsm_ounucopy_OPTERON_SSE3,  xtrsm_ounncopy_OPTERON_SSE3,  xtrsm_outucopy_OPTERON_SSE3,  xtrsm_outncopy_OPTERON_SSE3,
  xtrsm_olnucopy_OPTERON_SSE3,  xtrsm_olnncopy_OPTERON_SSE3,  xtrsm_oltucopy_OPTERON_SSE3,  xtrsm_oltncopy_OPTERON_SSE3,
#endif
  xtrsm_ounucopy_OPTERON_SSE3,  xtrsm_ounncopy_OPTERON_SSE3,  xtrsm_outucopy_OPTERON_SSE3,  xtrsm_outncopy_OPTERON_SSE3,
  xtrsm_olnucopy_OPTERON_SSE3,  xtrsm_olnncopy_OPTERON_SSE3,  xtrsm_oltucopy_OPTERON_SSE3,  xtrsm_oltncopy_OPTERON_SSE3,

  xtrmm_kernel_RN_OPTERON_SSE3,  xtrmm_kernel_RT_OPTERON_SSE3,  xtrmm_kernel_RR_OPTERON_SSE3,  xtrmm_kernel_RC_OPTERON_SSE3,
  xtrmm_kernel_LN_OPTERON_SSE3,  xtrmm_kernel_LT_OPTERON_SSE3,  xtrmm_kernel_LR_OPTERON_SSE3,  xtrmm_kernel_LC_OPTERON_SSE3,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_OPTERON_SSE3,  xtrmm_iunncopy_OPTERON_SSE3,  xtrmm_iutucopy_OPTERON_SSE3,  xtrmm_iutncopy_OPTERON_SSE3,
  xtrmm_ilnucopy_OPTERON_SSE3,  xtrmm_ilnncopy_OPTERON_SSE3,  xtrmm_iltucopy_OPTERON_SSE3,  xtrmm_iltncopy_OPTERON_SSE3,
#else
  xtrmm_ounucopy_OPTERON_SSE3,  xtrmm_ounncopy_OPTERON_SSE3,  xtrmm_outucopy_OPTERON_SSE3,  xtrmm_outncopy_OPTERON_SSE3,
  xtrmm_olnucopy_OPTERON_SSE3,  xtrmm_olnncopy_OPTERON_SSE3,  xtrmm_oltucopy_OPTERON_SSE3,  xtrmm_oltncopy_OPTERON_SSE3,
#endif
  xtrmm_ounucopy_OPTERON_SSE3,  xtrmm_ounncopy_OPTERON_SSE3,  xtrmm_outucopy_OPTERON_SSE3,  xtrmm_outncopy_OPTERON_SSE3,
  xtrmm_olnucopy_OPTERON_SSE3,  xtrmm_olnncopy_OPTERON_SSE3,  xtrmm_oltucopy_OPTERON_SSE3,  xtrmm_oltncopy_OPTERON_SSE3,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_OPTERON_SSE3,  xsymm_iltcopy_OPTERON_SSE3,
#else
  xsymm_outcopy_OPTERON_SSE3,  xsymm_oltcopy_OPTERON_SSE3,
#endif
  xsymm_outcopy_OPTERON_SSE3,  xsymm_oltcopy_OPTERON_SSE3,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_OPTERON_SSE3,  xhemm_iltcopy_OPTERON_SSE3,
#else
  xhemm_outcopy_OPTERON_SSE3,  xhemm_oltcopy_OPTERON_SSE3,
#endif
  xhemm_outcopy_OPTERON_SSE3,  xhemm_oltcopy_OPTERON_SSE3,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_OPTERON_SSE3,

  xgemm3m_incopyb_OPTERON_SSE3,  xgemm3m_incopyr_OPTERON_SSE3,
  xgemm3m_incopyi_OPTERON_SSE3,  xgemm3m_itcopyb_OPTERON_SSE3,
  xgemm3m_itcopyr_OPTERON_SSE3,  xgemm3m_itcopyi_OPTERON_SSE3,
  xgemm3m_oncopyb_OPTERON_SSE3,  xgemm3m_oncopyr_OPTERON_SSE3,
  xgemm3m_oncopyi_OPTERON_SSE3,  xgemm3m_otcopyb_OPTERON_SSE3,
  xgemm3m_otcopyr_OPTERON_SSE3,  xgemm3m_otcopyi_OPTERON_SSE3,

  xsymm3m_iucopyb_OPTERON_SSE3,  xsymm3m_ilcopyb_OPTERON_SSE3,
  xsymm3m_iucopyr_OPTERON_SSE3,  xsymm3m_ilcopyr_OPTERON_SSE3,
  xsymm3m_iucopyi_OPTERON_SSE3,  xsymm3m_ilcopyi_OPTERON_SSE3,
  xsymm3m_oucopyb_OPTERON_SSE3,  xsymm3m_olcopyb_OPTERON_SSE3,
  xsymm3m_oucopyr_OPTERON_SSE3,  xsymm3m_olcopyr_OPTERON_SSE3,
  xsymm3m_oucopyi_OPTERON_SSE3,  xsymm3m_olcopyi_OPTERON_SSE3,

  xhemm3m_iucopyb_OPTERON_SSE3,  xhemm3m_ilcopyb_OPTERON_SSE3,
  xhemm3m_iucopyr_OPTERON_SSE3,  xhemm3m_ilcopyr_OPTERON_SSE3,
  xhemm3m_iucopyi_OPTERON_SSE3,  xhemm3m_ilcopyi_OPTERON_SSE3,

  xhemm3m_oucopyb_OPTERON_SSE3,  xhemm3m_olcopyb_OPTERON_SSE3,
  xhemm3m_oucopyr_OPTERON_SSE3,  xhemm3m_olcopyr_OPTERON_SSE3,
  xhemm3m_oucopyi_OPTERON_SSE3,  xhemm3m_olcopyi_OPTERON_SSE3,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_OPTERON_SSE3, xlaswp_ncopy_OPTERON_SSE3,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_OPTERON_SSE3,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_OPTERON_SSE3,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_OPTERON_SSE3, somatcopy_k_ct_OPTERON_SSE3, somatcopy_k_rn_OPTERON_SSE3, somatcopy_k_rt_OPTERON_SSE3,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_OPTERON_SSE3, domatcopy_k_ct_OPTERON_SSE3, domatcopy_k_rn_OPTERON_SSE3, domatcopy_k_rt_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_OPTERON_SSE3, comatcopy_k_ct_OPTERON_SSE3, comatcopy_k_rn_OPTERON_SSE3, comatcopy_k_rt_OPTERON_SSE3,
  comatcopy_k_cnc_OPTERON_SSE3, comatcopy_k_ctc_OPTERON_SSE3, comatcopy_k_rnc_OPTERON_SSE3, comatcopy_k_rtc_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_OPTERON_SSE3, zomatcopy_k_ct_OPTERON_SSE3, zomatcopy_k_rn_OPTERON_SSE3, zomatcopy_k_rt_OPTERON_SSE3,
  zomatcopy_k_cnc_OPTERON_SSE3, zomatcopy_k_ctc_OPTERON_SSE3, zomatcopy_k_rnc_OPTERON_SSE3, zomatcopy_k_rtc_OPTERON_SSE3,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_OPTERON_SSE3, simatcopy_k_ct_OPTERON_SSE3, simatcopy_k_rn_OPTERON_SSE3, simatcopy_k_rt_OPTERON_SSE3,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_OPTERON_SSE3, dimatcopy_k_ct_OPTERON_SSE3, dimatcopy_k_rn_OPTERON_SSE3, dimatcopy_k_rt_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_OPTERON_SSE3, cimatcopy_k_ct_OPTERON_SSE3, cimatcopy_k_rn_OPTERON_SSE3, cimatcopy_k_rt_OPTERON_SSE3,
  cimatcopy_k_cnc_OPTERON_SSE3, cimatcopy_k_ctc_OPTERON_SSE3, cimatcopy_k_rnc_OPTERON_SSE3, cimatcopy_k_rtc_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_OPTERON_SSE3, zimatcopy_k_ct_OPTERON_SSE3, zimatcopy_k_rn_OPTERON_SSE3, zimatcopy_k_rt_OPTERON_SSE3,
  zimatcopy_k_cnc_OPTERON_SSE3, zimatcopy_k_ctc_OPTERON_SSE3, zimatcopy_k_rnc_OPTERON_SSE3, zimatcopy_k_rtc_OPTERON_SSE3,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_OPTERON_SSE3,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_OPTERON_SSE3,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_OPTERON_SSE3
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
