/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_NORTHWOOD;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_NORTHWOOD.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_NORTHWOOD, sbdtobf16_k_NORTHWOOD, sbf16tos_k_NORTHWOOD, dbf16tod_k_NORTHWOOD,

  samax_k_NORTHWOOD,  samin_k_NORTHWOOD,  smax_k_NORTHWOOD,  smin_k_NORTHWOOD,
  isamax_k_NORTHWOOD, isamin_k_NORTHWOOD, ismax_k_NORTHWOOD, ismin_k_NORTHWOOD,
  snrm2_k_NORTHWOOD,  sasum_k_NORTHWOOD, ssum_k_NORTHWOOD, scopy_k_NORTHWOOD, sbdot_k_NORTHWOOD,
  dsdot_k_NORTHWOOD,
  srot_k_NORTHWOOD,   saxpy_k_NORTHWOOD,  sscal_k_NORTHWOOD, sswap_k_NORTHWOOD,
  sbgemv_n_NORTHWOOD, sbgemv_t_NORTHWOOD, sger_k_NORTHWOOD,
  ssymv_L_NORTHWOOD, ssymv_U_NORTHWOOD,

  sbgemm_kernel_NORTHWOOD, sbgemm_beta_NORTHWOOD,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_NORTHWOOD, sbgemm_itcopy_NORTHWOOD,
#else
  sbgemm_oncopy_NORTHWOOD, sbgemm_otcopy_NORTHWOOD,
#endif
  sbgemm_oncopy_NORTHWOOD, sbgemm_otcopy_NORTHWOOD,

  strsm_kernel_LN_NORTHWOOD, strsm_kernel_LT_NORTHWOOD, strsm_kernel_RN_NORTHWOOD, strsm_kernel_RT_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_NORTHWOOD, strsm_iunncopy_NORTHWOOD, strsm_iutucopy_NORTHWOOD, strsm_iutncopy_NORTHWOOD,
  strsm_ilnucopy_NORTHWOOD, strsm_ilnncopy_NORTHWOOD, strsm_iltucopy_NORTHWOOD, strsm_iltncopy_NORTHWOOD,
#else
  strsm_ounucopy_NORTHWOOD, strsm_ounncopy_NORTHWOOD, strsm_outucopy_NORTHWOOD, strsm_outncopy_NORTHWOOD,
  strsm_olnucopy_NORTHWOOD, strsm_olnncopy_NORTHWOOD, strsm_oltucopy_NORTHWOOD, strsm_oltncopy_NORTHWOOD,
#endif
  strsm_ounucopy_NORTHWOOD, strsm_ounncopy_NORTHWOOD, strsm_outucopy_NORTHWOOD, strsm_outncopy_NORTHWOOD,
  strsm_olnucopy_NORTHWOOD, strsm_olnncopy_NORTHWOOD, strsm_oltucopy_NORTHWOOD, strsm_oltncopy_NORTHWOOD,
  strmm_kernel_RN_NORTHWOOD, strmm_kernel_RT_NORTHWOOD, strmm_kernel_LN_NORTHWOOD, strmm_kernel_LT_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_NORTHWOOD, strmm_iunncopy_NORTHWOOD, strmm_iutucopy_NORTHWOOD, strmm_iutncopy_NORTHWOOD,
  strmm_ilnucopy_NORTHWOOD, strmm_ilnncopy_NORTHWOOD, strmm_iltucopy_NORTHWOOD, strmm_iltncopy_NORTHWOOD,
#else
  strmm_ounucopy_NORTHWOOD, strmm_ounncopy_NORTHWOOD, strmm_outucopy_NORTHWOOD, strmm_outncopy_NORTHWOOD,
  strmm_olnucopy_NORTHWOOD, strmm_olnncopy_NORTHWOOD, strmm_oltucopy_NORTHWOOD, strmm_oltncopy_NORTHWOOD,
#endif
  strmm_ounucopy_NORTHWOOD, strmm_ounncopy_NORTHWOOD, strmm_outucopy_NORTHWOOD, strmm_outncopy_NORTHWOOD,
  strmm_olnucopy_NORTHWOOD, strmm_olnncopy_NORTHWOOD, strmm_oltucopy_NORTHWOOD, strmm_oltncopy_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_NORTHWOOD, ssymm_iltcopy_NORTHWOOD,
#else
  ssymm_outcopy_NORTHWOOD, ssymm_oltcopy_NORTHWOOD,
#endif
  ssymm_outcopy_NORTHWOOD, ssymm_oltcopy_NORTHWOOD,

#ifndef NO_LAPACK
  sneg_tcopy_NORTHWOOD, slaswp_ncopy_NORTHWOOD,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_NORTHWOOD,
  sbgemm_small_kernel_nn_NORTHWOOD, sbgemm_small_kernel_nt_NORTHWOOD, sbgemm_small_kernel_tn_NORTHWOOD, sbgemm_small_kernel_tt_NORTHWOOD,
  sbgemm_small_kernel_b0_nn_NORTHWOOD, sbgemm_small_kernel_b0_nt_NORTHWOOD, sbgemm_small_kernel_b0_tn_NORTHWOOD, sbgemm_small_kernel_b0_tt_NORTHWOOD,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_NORTHWOOD,  samin_k_NORTHWOOD,  smax_k_NORTHWOOD,  smin_k_NORTHWOOD,
  isamax_k_NORTHWOOD, isamin_k_NORTHWOOD, ismax_k_NORTHWOOD, ismin_k_NORTHWOOD,
  snrm2_k_NORTHWOOD,  sasum_k_NORTHWOOD,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_NORTHWOOD,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_NORTHWOOD, sdot_k_NORTHWOOD,
//  dsdot_k_NORTHWOOD,
  srot_k_NORTHWOOD,   saxpy_k_NORTHWOOD,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_NORTHWOOD,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_NORTHWOOD,
  sgemv_n_NORTHWOOD,  sgemv_t_NORTHWOOD,
#endif
#if BUILD_SINGLE == 1  
  sger_k_NORTHWOOD,
  ssymv_L_NORTHWOOD, ssymv_U_NORTHWOOD,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_NORTHWOOD,
  sgemm_direct_performant_NORTHWOOD,	
#endif

  sgemm_kernel_NORTHWOOD, sgemm_beta_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_NORTHWOOD, sgemm_itcopy_NORTHWOOD,
#else
  sgemm_oncopy_NORTHWOOD, sgemm_otcopy_NORTHWOOD,
#endif
  sgemm_oncopy_NORTHWOOD, sgemm_otcopy_NORTHWOOD,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_NORTHWOOD,
  sgemm_small_kernel_nn_NORTHWOOD, sgemm_small_kernel_nt_NORTHWOOD, sgemm_small_kernel_tn_NORTHWOOD, sgemm_small_kernel_tt_NORTHWOOD,
  sgemm_small_kernel_b0_nn_NORTHWOOD, sgemm_small_kernel_b0_nt_NORTHWOOD, sgemm_small_kernel_b0_tn_NORTHWOOD, sgemm_small_kernel_b0_tt_NORTHWOOD,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_NORTHWOOD, strsm_kernel_LT_NORTHWOOD, strsm_kernel_RN_NORTHWOOD, strsm_kernel_RT_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_NORTHWOOD, strsm_iunncopy_NORTHWOOD, strsm_iutucopy_NORTHWOOD, strsm_iutncopy_NORTHWOOD,
  strsm_ilnucopy_NORTHWOOD, strsm_ilnncopy_NORTHWOOD, strsm_iltucopy_NORTHWOOD, strsm_iltncopy_NORTHWOOD,
#else
  strsm_ounucopy_NORTHWOOD, strsm_ounncopy_NORTHWOOD, strsm_outucopy_NORTHWOOD, strsm_outncopy_NORTHWOOD,
  strsm_olnucopy_NORTHWOOD, strsm_olnncopy_NORTHWOOD, strsm_oltucopy_NORTHWOOD, strsm_oltncopy_NORTHWOOD,
#endif
  strsm_ounucopy_NORTHWOOD, strsm_ounncopy_NORTHWOOD, strsm_outucopy_NORTHWOOD, strsm_outncopy_NORTHWOOD,
  strsm_olnucopy_NORTHWOOD, strsm_olnncopy_NORTHWOOD, strsm_oltucopy_NORTHWOOD, strsm_oltncopy_NORTHWOOD,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_NORTHWOOD, strmm_kernel_RT_NORTHWOOD, strmm_kernel_LN_NORTHWOOD, strmm_kernel_LT_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_NORTHWOOD, strmm_iunncopy_NORTHWOOD, strmm_iutucopy_NORTHWOOD, strmm_iutncopy_NORTHWOOD,
  strmm_ilnucopy_NORTHWOOD, strmm_ilnncopy_NORTHWOOD, strmm_iltucopy_NORTHWOOD, strmm_iltncopy_NORTHWOOD,
#else
  strmm_ounucopy_NORTHWOOD, strmm_ounncopy_NORTHWOOD, strmm_outucopy_NORTHWOOD, strmm_outncopy_NORTHWOOD,
  strmm_olnucopy_NORTHWOOD, strmm_olnncopy_NORTHWOOD, strmm_oltucopy_NORTHWOOD, strmm_oltncopy_NORTHWOOD,
#endif
  strmm_ounucopy_NORTHWOOD, strmm_ounncopy_NORTHWOOD, strmm_outucopy_NORTHWOOD, strmm_outncopy_NORTHWOOD,
  strmm_olnucopy_NORTHWOOD, strmm_olnncopy_NORTHWOOD, strmm_oltucopy_NORTHWOOD, strmm_oltncopy_NORTHWOOD,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_NORTHWOOD, ssymm_iltcopy_NORTHWOOD,
#else
  ssymm_outcopy_NORTHWOOD, ssymm_oltcopy_NORTHWOOD,
#endif
  ssymm_outcopy_NORTHWOOD, ssymm_oltcopy_NORTHWOOD,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_NORTHWOOD, slaswp_ncopy_NORTHWOOD,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_NORTHWOOD,  damin_k_NORTHWOOD,  dmax_k_NORTHWOOD,  dmin_k_NORTHWOOD,
  idamax_k_NORTHWOOD, idamin_k_NORTHWOOD, idmax_k_NORTHWOOD, idmin_k_NORTHWOOD,
  dnrm2_k_NORTHWOOD, dasum_k_NORTHWOOD,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_NORTHWOOD,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_NORTHWOOD, ddot_k_NORTHWOOD,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_NORTHWOOD,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_NORTHWOOD,
  daxpy_k_NORTHWOOD,
  dscal_k_NORTHWOOD, 
  dswap_k_NORTHWOOD,
  dgemv_n_NORTHWOOD,  dgemv_t_NORTHWOOD,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_NORTHWOOD,
  dsymv_L_NORTHWOOD,  dsymv_U_NORTHWOOD,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_NORTHWOOD, dgemm_beta_NORTHWOOD,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_NORTHWOOD, dgemm_itcopy_NORTHWOOD,
#else
  dgemm_oncopy_NORTHWOOD, dgemm_otcopy_NORTHWOOD,
#endif
  dgemm_oncopy_NORTHWOOD, dgemm_otcopy_NORTHWOOD,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_NORTHWOOD,
  dgemm_small_kernel_nn_NORTHWOOD, dgemm_small_kernel_nt_NORTHWOOD, dgemm_small_kernel_tn_NORTHWOOD, dgemm_small_kernel_tt_NORTHWOOD,
  dgemm_small_kernel_b0_nn_NORTHWOOD, dgemm_small_kernel_b0_nt_NORTHWOOD, dgemm_small_kernel_b0_tn_NORTHWOOD, dgemm_small_kernel_b0_tt_NORTHWOOD,
#endif
  dtrsm_kernel_LN_NORTHWOOD, dtrsm_kernel_LT_NORTHWOOD, dtrsm_kernel_RN_NORTHWOOD, dtrsm_kernel_RT_NORTHWOOD,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_NORTHWOOD, dtrsm_iunncopy_NORTHWOOD, dtrsm_iutucopy_NORTHWOOD, dtrsm_iutncopy_NORTHWOOD,
  dtrsm_ilnucopy_NORTHWOOD, dtrsm_ilnncopy_NORTHWOOD, dtrsm_iltucopy_NORTHWOOD, dtrsm_iltncopy_NORTHWOOD,
#else
  dtrsm_ounucopy_NORTHWOOD, dtrsm_ounncopy_NORTHWOOD, dtrsm_outucopy_NORTHWOOD, dtrsm_outncopy_NORTHWOOD,
  dtrsm_olnucopy_NORTHWOOD, dtrsm_olnncopy_NORTHWOOD, dtrsm_oltucopy_NORTHWOOD, dtrsm_oltncopy_NORTHWOOD,
#endif
  dtrsm_ounucopy_NORTHWOOD, dtrsm_ounncopy_NORTHWOOD, dtrsm_outucopy_NORTHWOOD, dtrsm_outncopy_NORTHWOOD,
  dtrsm_olnucopy_NORTHWOOD, dtrsm_olnncopy_NORTHWOOD, dtrsm_oltucopy_NORTHWOOD, dtrsm_oltncopy_NORTHWOOD,
  dtrmm_kernel_RN_NORTHWOOD, dtrmm_kernel_RT_NORTHWOOD, dtrmm_kernel_LN_NORTHWOOD, dtrmm_kernel_LT_NORTHWOOD,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_NORTHWOOD, dtrmm_iunncopy_NORTHWOOD, dtrmm_iutucopy_NORTHWOOD, dtrmm_iutncopy_NORTHWOOD,
  dtrmm_ilnucopy_NORTHWOOD, dtrmm_ilnncopy_NORTHWOOD, dtrmm_iltucopy_NORTHWOOD, dtrmm_iltncopy_NORTHWOOD,
#else
  dtrmm_ounucopy_NORTHWOOD, dtrmm_ounncopy_NORTHWOOD, dtrmm_outucopy_NORTHWOOD, dtrmm_outncopy_NORTHWOOD,
  dtrmm_olnucopy_NORTHWOOD, dtrmm_olnncopy_NORTHWOOD, dtrmm_oltucopy_NORTHWOOD, dtrmm_oltncopy_NORTHWOOD,
#endif
  dtrmm_ounucopy_NORTHWOOD, dtrmm_ounncopy_NORTHWOOD, dtrmm_outucopy_NORTHWOOD, dtrmm_outncopy_NORTHWOOD,
  dtrmm_olnucopy_NORTHWOOD, dtrmm_olnncopy_NORTHWOOD, dtrmm_oltucopy_NORTHWOOD, dtrmm_oltncopy_NORTHWOOD,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_NORTHWOOD, dsymm_iltcopy_NORTHWOOD,
#else
  dsymm_outcopy_NORTHWOOD, dsymm_oltcopy_NORTHWOOD,
#endif
  dsymm_outcopy_NORTHWOOD, dsymm_oltcopy_NORTHWOOD,

#ifndef NO_LAPACK
  dneg_tcopy_NORTHWOOD, dlaswp_ncopy_NORTHWOOD,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_NORTHWOOD,  qamin_k_NORTHWOOD,  qmax_k_NORTHWOOD,  qmin_k_NORTHWOOD,
  iqamax_k_NORTHWOOD, iqamin_k_NORTHWOOD, iqmax_k_NORTHWOOD, iqmin_k_NORTHWOOD,
  qnrm2_k_NORTHWOOD,  qasum_k_NORTHWOOD,  qsum_k_NORTHWOOD, qcopy_k_NORTHWOOD, qdot_k_NORTHWOOD,
  qrot_k_NORTHWOOD,   qaxpy_k_NORTHWOOD,  qscal_k_NORTHWOOD, qswap_k_NORTHWOOD,
  qgemv_n_NORTHWOOD,  qgemv_t_NORTHWOOD,  qger_k_NORTHWOOD,
  qsymv_L_NORTHWOOD,  qsymv_U_NORTHWOOD,

  qgemm_kernel_NORTHWOOD, qgemm_beta_NORTHWOOD,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_NORTHWOOD, qgemm_itcopy_NORTHWOOD,
#else
  qgemm_oncopy_NORTHWOOD, qgemm_otcopy_NORTHWOOD,
#endif
  qgemm_oncopy_NORTHWOOD, qgemm_otcopy_NORTHWOOD,
  qtrsm_kernel_LN_NORTHWOOD, qtrsm_kernel_LT_NORTHWOOD, qtrsm_kernel_RN_NORTHWOOD, qtrsm_kernel_RT_NORTHWOOD,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_NORTHWOOD, qtrsm_iunncopy_NORTHWOOD, qtrsm_iutucopy_NORTHWOOD, qtrsm_iutncopy_NORTHWOOD,
  qtrsm_ilnucopy_NORTHWOOD, qtrsm_ilnncopy_NORTHWOOD, qtrsm_iltucopy_NORTHWOOD, qtrsm_iltncopy_NORTHWOOD,
#else
  qtrsm_ounucopy_NORTHWOOD, qtrsm_ounncopy_NORTHWOOD, qtrsm_outucopy_NORTHWOOD, qtrsm_outncopy_NORTHWOOD,
  qtrsm_olnucopy_NORTHWOOD, qtrsm_olnncopy_NORTHWOOD, qtrsm_oltucopy_NORTHWOOD, qtrsm_oltncopy_NORTHWOOD,
#endif
  qtrsm_ounucopy_NORTHWOOD, qtrsm_ounncopy_NORTHWOOD, qtrsm_outucopy_NORTHWOOD, qtrsm_outncopy_NORTHWOOD,
  qtrsm_olnucopy_NORTHWOOD, qtrsm_olnncopy_NORTHWOOD, qtrsm_oltucopy_NORTHWOOD, qtrsm_oltncopy_NORTHWOOD,
  qtrmm_kernel_RN_NORTHWOOD, qtrmm_kernel_RT_NORTHWOOD, qtrmm_kernel_LN_NORTHWOOD, qtrmm_kernel_LT_NORTHWOOD,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_NORTHWOOD, qtrmm_iunncopy_NORTHWOOD, qtrmm_iutucopy_NORTHWOOD, qtrmm_iutncopy_NORTHWOOD,
  qtrmm_ilnucopy_NORTHWOOD, qtrmm_ilnncopy_NORTHWOOD, qtrmm_iltucopy_NORTHWOOD, qtrmm_iltncopy_NORTHWOOD,
#else
  qtrmm_ounucopy_NORTHWOOD, qtrmm_ounncopy_NORTHWOOD, qtrmm_outucopy_NORTHWOOD, qtrmm_outncopy_NORTHWOOD,
  qtrmm_olnucopy_NORTHWOOD, qtrmm_olnncopy_NORTHWOOD, qtrmm_oltucopy_NORTHWOOD, qtrmm_oltncopy_NORTHWOOD,
#endif
  qtrmm_ounucopy_NORTHWOOD, qtrmm_ounncopy_NORTHWOOD, qtrmm_outucopy_NORTHWOOD, qtrmm_outncopy_NORTHWOOD,
  qtrmm_olnucopy_NORTHWOOD, qtrmm_olnncopy_NORTHWOOD, qtrmm_oltucopy_NORTHWOOD, qtrmm_oltncopy_NORTHWOOD,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_NORTHWOOD, qsymm_iltcopy_NORTHWOOD,
#else
  qsymm_outcopy_NORTHWOOD, qsymm_oltcopy_NORTHWOOD,
#endif
  qsymm_outcopy_NORTHWOOD, qsymm_oltcopy_NORTHWOOD,

#ifndef NO_LAPACK
  qneg_tcopy_NORTHWOOD, qlaswp_ncopy_NORTHWOOD,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_NORTHWOOD, camin_k_NORTHWOOD, icamax_k_NORTHWOOD, icamin_k_NORTHWOOD,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_NORTHWOOD, casum_k_NORTHWOOD, csum_k_NORTHWOOD,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_NORTHWOOD,  cdotu_k_NORTHWOOD, cdotc_k_NORTHWOOD,
#endif
#if (BUILD_COMPLEX)
 csrot_k_NORTHWOOD,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_NORTHWOOD,
  caxpyc_k_NORTHWOOD, 
  cscal_k_NORTHWOOD, 
  cswap_k_NORTHWOOD,

  cgemv_n_NORTHWOOD, cgemv_t_NORTHWOOD, cgemv_r_NORTHWOOD, cgemv_c_NORTHWOOD,
  cgemv_o_NORTHWOOD, cgemv_u_NORTHWOOD, cgemv_s_NORTHWOOD, cgemv_d_NORTHWOOD,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_NORTHWOOD, cgerc_k_NORTHWOOD, cgerv_k_NORTHWOOD, cgerd_k_NORTHWOOD,
  csymv_L_NORTHWOOD, csymv_U_NORTHWOOD,
  chemv_L_NORTHWOOD, chemv_U_NORTHWOOD, chemv_M_NORTHWOOD, chemv_V_NORTHWOOD,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_NORTHWOOD, cgemm_kernel_l_NORTHWOOD, cgemm_kernel_r_NORTHWOOD, cgemm_kernel_b_NORTHWOOD,
  cgemm_beta_NORTHWOOD,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_NORTHWOOD, cgemm_itcopy_NORTHWOOD,
#else
  cgemm_oncopy_NORTHWOOD, cgemm_otcopy_NORTHWOOD,
#endif
  cgemm_oncopy_NORTHWOOD, cgemm_otcopy_NORTHWOOD,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_NORTHWOOD,
  cgemm_small_kernel_nn_NORTHWOOD, cgemm_small_kernel_nt_NORTHWOOD, cgemm_small_kernel_nr_NORTHWOOD, cgemm_small_kernel_nc_NORTHWOOD,
  cgemm_small_kernel_tn_NORTHWOOD, cgemm_small_kernel_tt_NORTHWOOD, cgemm_small_kernel_tr_NORTHWOOD, cgemm_small_kernel_tc_NORTHWOOD,
  cgemm_small_kernel_rn_NORTHWOOD, cgemm_small_kernel_rt_NORTHWOOD, cgemm_small_kernel_rr_NORTHWOOD, cgemm_small_kernel_rc_NORTHWOOD,
  cgemm_small_kernel_cn_NORTHWOOD, cgemm_small_kernel_ct_NORTHWOOD, cgemm_small_kernel_cr_NORTHWOOD, cgemm_small_kernel_cc_NORTHWOOD,
  cgemm_small_kernel_b0_nn_NORTHWOOD, cgemm_small_kernel_b0_nt_NORTHWOOD, cgemm_small_kernel_b0_nr_NORTHWOOD, cgemm_small_kernel_b0_nc_NORTHWOOD,
  cgemm_small_kernel_b0_tn_NORTHWOOD, cgemm_small_kernel_b0_tt_NORTHWOOD, cgemm_small_kernel_b0_tr_NORTHWOOD, cgemm_small_kernel_b0_tc_NORTHWOOD,
  cgemm_small_kernel_b0_rn_NORTHWOOD, cgemm_small_kernel_b0_rt_NORTHWOOD, cgemm_small_kernel_b0_rr_NORTHWOOD, cgemm_small_kernel_b0_rc_NORTHWOOD,
  cgemm_small_kernel_b0_cn_NORTHWOOD, cgemm_small_kernel_b0_ct_NORTHWOOD, cgemm_small_kernel_b0_cr_NORTHWOOD, cgemm_small_kernel_b0_cc_NORTHWOOD,
#endif

  ctrsm_kernel_LN_NORTHWOOD, ctrsm_kernel_LT_NORTHWOOD, ctrsm_kernel_LR_NORTHWOOD, ctrsm_kernel_LC_NORTHWOOD,
  ctrsm_kernel_RN_NORTHWOOD, ctrsm_kernel_RT_NORTHWOOD, ctrsm_kernel_RR_NORTHWOOD, ctrsm_kernel_RC_NORTHWOOD,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_NORTHWOOD,  ctrsm_iunncopy_NORTHWOOD,  ctrsm_iutucopy_NORTHWOOD,  ctrsm_iutncopy_NORTHWOOD,
  ctrsm_ilnucopy_NORTHWOOD,  ctrsm_ilnncopy_NORTHWOOD,  ctrsm_iltucopy_NORTHWOOD,  ctrsm_iltncopy_NORTHWOOD,
#else
  ctrsm_ounucopy_NORTHWOOD,  ctrsm_ounncopy_NORTHWOOD,  ctrsm_outucopy_NORTHWOOD,  ctrsm_outncopy_NORTHWOOD,
  ctrsm_olnucopy_NORTHWOOD,  ctrsm_olnncopy_NORTHWOOD,  ctrsm_oltucopy_NORTHWOOD,  ctrsm_oltncopy_NORTHWOOD,
#endif
  ctrsm_ounucopy_NORTHWOOD,  ctrsm_ounncopy_NORTHWOOD,  ctrsm_outucopy_NORTHWOOD,  ctrsm_outncopy_NORTHWOOD,
  ctrsm_olnucopy_NORTHWOOD,  ctrsm_olnncopy_NORTHWOOD,  ctrsm_oltucopy_NORTHWOOD,  ctrsm_oltncopy_NORTHWOOD,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_NORTHWOOD,  ctrmm_kernel_RT_NORTHWOOD,  ctrmm_kernel_RR_NORTHWOOD,  ctrmm_kernel_RC_NORTHWOOD,
  ctrmm_kernel_LN_NORTHWOOD,  ctrmm_kernel_LT_NORTHWOOD,  ctrmm_kernel_LR_NORTHWOOD,  ctrmm_kernel_LC_NORTHWOOD,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_NORTHWOOD,  ctrmm_iunncopy_NORTHWOOD,  ctrmm_iutucopy_NORTHWOOD,  ctrmm_iutncopy_NORTHWOOD,
  ctrmm_ilnucopy_NORTHWOOD,  ctrmm_ilnncopy_NORTHWOOD,  ctrmm_iltucopy_NORTHWOOD,  ctrmm_iltncopy_NORTHWOOD,
#else
  ctrmm_ounucopy_NORTHWOOD,  ctrmm_ounncopy_NORTHWOOD,  ctrmm_outucopy_NORTHWOOD,  ctrmm_outncopy_NORTHWOOD,
  ctrmm_olnucopy_NORTHWOOD,  ctrmm_olnncopy_NORTHWOOD,  ctrmm_oltucopy_NORTHWOOD,  ctrmm_oltncopy_NORTHWOOD,
#endif
  ctrmm_ounucopy_NORTHWOOD,  ctrmm_ounncopy_NORTHWOOD,  ctrmm_outucopy_NORTHWOOD,  ctrmm_outncopy_NORTHWOOD,
  ctrmm_olnucopy_NORTHWOOD,  ctrmm_olnncopy_NORTHWOOD,  ctrmm_oltucopy_NORTHWOOD,  ctrmm_oltncopy_NORTHWOOD,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_NORTHWOOD,  csymm_iltcopy_NORTHWOOD,
#else
  csymm_outcopy_NORTHWOOD,  csymm_oltcopy_NORTHWOOD,
#endif
  csymm_outcopy_NORTHWOOD,  csymm_oltcopy_NORTHWOOD,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_NORTHWOOD,  chemm_iltcopy_NORTHWOOD,
#else
  chemm_outcopy_NORTHWOOD,  chemm_oltcopy_NORTHWOOD,
#endif
  chemm_outcopy_NORTHWOOD,  chemm_oltcopy_NORTHWOOD,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_NORTHWOOD,

  cgemm3m_incopyb_NORTHWOOD,  cgemm3m_incopyr_NORTHWOOD,
  cgemm3m_incopyi_NORTHWOOD,  cgemm3m_itcopyb_NORTHWOOD,
  cgemm3m_itcopyr_NORTHWOOD,  cgemm3m_itcopyi_NORTHWOOD,
  cgemm3m_oncopyb_NORTHWOOD,  cgemm3m_oncopyr_NORTHWOOD,
  cgemm3m_oncopyi_NORTHWOOD,  cgemm3m_otcopyb_NORTHWOOD,
  cgemm3m_otcopyr_NORTHWOOD,  cgemm3m_otcopyi_NORTHWOOD,

  csymm3m_iucopyb_NORTHWOOD,  csymm3m_ilcopyb_NORTHWOOD,
  csymm3m_iucopyr_NORTHWOOD,  csymm3m_ilcopyr_NORTHWOOD,
  csymm3m_iucopyi_NORTHWOOD,  csymm3m_ilcopyi_NORTHWOOD,
  csymm3m_oucopyb_NORTHWOOD,  csymm3m_olcopyb_NORTHWOOD,
  csymm3m_oucopyr_NORTHWOOD,  csymm3m_olcopyr_NORTHWOOD,
  csymm3m_oucopyi_NORTHWOOD,  csymm3m_olcopyi_NORTHWOOD,

  chemm3m_iucopyb_NORTHWOOD,  chemm3m_ilcopyb_NORTHWOOD,
  chemm3m_iucopyr_NORTHWOOD,  chemm3m_ilcopyr_NORTHWOOD,
  chemm3m_iucopyi_NORTHWOOD,  chemm3m_ilcopyi_NORTHWOOD,

  chemm3m_oucopyb_NORTHWOOD,  chemm3m_olcopyb_NORTHWOOD,
  chemm3m_oucopyr_NORTHWOOD,  chemm3m_olcopyr_NORTHWOOD,
  chemm3m_oucopyi_NORTHWOOD,  chemm3m_olcopyi_NORTHWOOD,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_NORTHWOOD,
  
   claswp_ncopy_NORTHWOOD,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_NORTHWOOD, zamin_k_NORTHWOOD, izamax_k_NORTHWOOD, izamin_k_NORTHWOOD,
  znrm2_k_NORTHWOOD, zasum_k_NORTHWOOD, zsum_k_NORTHWOOD, zcopy_k_NORTHWOOD,
  zdotu_k_NORTHWOOD, zdotc_k_NORTHWOOD, zdrot_k_NORTHWOOD,
  zaxpy_k_NORTHWOOD, zaxpyc_k_NORTHWOOD, zscal_k_NORTHWOOD, zswap_k_NORTHWOOD,

  zgemv_n_NORTHWOOD, zgemv_t_NORTHWOOD, zgemv_r_NORTHWOOD, zgemv_c_NORTHWOOD,
  zgemv_o_NORTHWOOD, zgemv_u_NORTHWOOD, zgemv_s_NORTHWOOD, zgemv_d_NORTHWOOD,
  zgeru_k_NORTHWOOD, zgerc_k_NORTHWOOD, zgerv_k_NORTHWOOD, zgerd_k_NORTHWOOD,
  zsymv_L_NORTHWOOD, zsymv_U_NORTHWOOD,
  zhemv_L_NORTHWOOD, zhemv_U_NORTHWOOD, zhemv_M_NORTHWOOD, zhemv_V_NORTHWOOD,

  zgemm_kernel_n_NORTHWOOD, zgemm_kernel_l_NORTHWOOD, zgemm_kernel_r_NORTHWOOD, zgemm_kernel_b_NORTHWOOD,
  zgemm_beta_NORTHWOOD,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_NORTHWOOD, zgemm_itcopy_NORTHWOOD,
#else
  zgemm_oncopy_NORTHWOOD, zgemm_otcopy_NORTHWOOD,
#endif
  zgemm_oncopy_NORTHWOOD, zgemm_otcopy_NORTHWOOD,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_NORTHWOOD,
  zgemm_small_kernel_nn_NORTHWOOD, zgemm_small_kernel_nt_NORTHWOOD, zgemm_small_kernel_nr_NORTHWOOD, zgemm_small_kernel_nc_NORTHWOOD,
  zgemm_small_kernel_tn_NORTHWOOD, zgemm_small_kernel_tt_NORTHWOOD, zgemm_small_kernel_tr_NORTHWOOD, zgemm_small_kernel_tc_NORTHWOOD,
  zgemm_small_kernel_rn_NORTHWOOD, zgemm_small_kernel_rt_NORTHWOOD, zgemm_small_kernel_rr_NORTHWOOD, zgemm_small_kernel_rc_NORTHWOOD,
  zgemm_small_kernel_cn_NORTHWOOD, zgemm_small_kernel_ct_NORTHWOOD, zgemm_small_kernel_cr_NORTHWOOD, zgemm_small_kernel_cc_NORTHWOOD,
  zgemm_small_kernel_b0_nn_NORTHWOOD, zgemm_small_kernel_b0_nt_NORTHWOOD, zgemm_small_kernel_b0_nr_NORTHWOOD, zgemm_small_kernel_b0_nc_NORTHWOOD,
  zgemm_small_kernel_b0_tn_NORTHWOOD, zgemm_small_kernel_b0_tt_NORTHWOOD, zgemm_small_kernel_b0_tr_NORTHWOOD, zgemm_small_kernel_b0_tc_NORTHWOOD,
  zgemm_small_kernel_b0_rn_NORTHWOOD, zgemm_small_kernel_b0_rt_NORTHWOOD, zgemm_small_kernel_b0_rr_NORTHWOOD, zgemm_small_kernel_b0_rc_NORTHWOOD,
  zgemm_small_kernel_b0_cn_NORTHWOOD, zgemm_small_kernel_b0_ct_NORTHWOOD, zgemm_small_kernel_b0_cr_NORTHWOOD, zgemm_small_kernel_b0_cc_NORTHWOOD,
#endif

  ztrsm_kernel_LN_NORTHWOOD, ztrsm_kernel_LT_NORTHWOOD, ztrsm_kernel_LR_NORTHWOOD, ztrsm_kernel_LC_NORTHWOOD,
  ztrsm_kernel_RN_NORTHWOOD, ztrsm_kernel_RT_NORTHWOOD, ztrsm_kernel_RR_NORTHWOOD, ztrsm_kernel_RC_NORTHWOOD,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_NORTHWOOD,  ztrsm_iunncopy_NORTHWOOD,  ztrsm_iutucopy_NORTHWOOD,  ztrsm_iutncopy_NORTHWOOD,
  ztrsm_ilnucopy_NORTHWOOD,  ztrsm_ilnncopy_NORTHWOOD,  ztrsm_iltucopy_NORTHWOOD,  ztrsm_iltncopy_NORTHWOOD,
#else
  ztrsm_ounucopy_NORTHWOOD,  ztrsm_ounncopy_NORTHWOOD,  ztrsm_outucopy_NORTHWOOD,  ztrsm_outncopy_NORTHWOOD,
  ztrsm_olnucopy_NORTHWOOD,  ztrsm_olnncopy_NORTHWOOD,  ztrsm_oltucopy_NORTHWOOD,  ztrsm_oltncopy_NORTHWOOD,
#endif
  ztrsm_ounucopy_NORTHWOOD,  ztrsm_ounncopy_NORTHWOOD,  ztrsm_outucopy_NORTHWOOD,  ztrsm_outncopy_NORTHWOOD,
  ztrsm_olnucopy_NORTHWOOD,  ztrsm_olnncopy_NORTHWOOD,  ztrsm_oltucopy_NORTHWOOD,  ztrsm_oltncopy_NORTHWOOD,

  ztrmm_kernel_RN_NORTHWOOD,  ztrmm_kernel_RT_NORTHWOOD,  ztrmm_kernel_RR_NORTHWOOD,  ztrmm_kernel_RC_NORTHWOOD,
  ztrmm_kernel_LN_NORTHWOOD,  ztrmm_kernel_LT_NORTHWOOD,  ztrmm_kernel_LR_NORTHWOOD,  ztrmm_kernel_LC_NORTHWOOD,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_NORTHWOOD,  ztrmm_iunncopy_NORTHWOOD,  ztrmm_iutucopy_NORTHWOOD,  ztrmm_iutncopy_NORTHWOOD,
  ztrmm_ilnucopy_NORTHWOOD,  ztrmm_ilnncopy_NORTHWOOD,  ztrmm_iltucopy_NORTHWOOD,  ztrmm_iltncopy_NORTHWOOD,
#else
  ztrmm_ounucopy_NORTHWOOD,  ztrmm_ounncopy_NORTHWOOD,  ztrmm_outucopy_NORTHWOOD,  ztrmm_outncopy_NORTHWOOD,
  ztrmm_olnucopy_NORTHWOOD,  ztrmm_olnncopy_NORTHWOOD,  ztrmm_oltucopy_NORTHWOOD,  ztrmm_oltncopy_NORTHWOOD,
#endif
  ztrmm_ounucopy_NORTHWOOD,  ztrmm_ounncopy_NORTHWOOD,  ztrmm_outucopy_NORTHWOOD,  ztrmm_outncopy_NORTHWOOD,
  ztrmm_olnucopy_NORTHWOOD,  ztrmm_olnncopy_NORTHWOOD,  ztrmm_oltucopy_NORTHWOOD,  ztrmm_oltncopy_NORTHWOOD,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_NORTHWOOD,  zsymm_iltcopy_NORTHWOOD,
#else
  zsymm_outcopy_NORTHWOOD,  zsymm_oltcopy_NORTHWOOD,
#endif
  zsymm_outcopy_NORTHWOOD,  zsymm_oltcopy_NORTHWOOD,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_NORTHWOOD,  zhemm_iltcopy_NORTHWOOD,
#else
  zhemm_outcopy_NORTHWOOD,  zhemm_oltcopy_NORTHWOOD,
#endif
  zhemm_outcopy_NORTHWOOD,  zhemm_oltcopy_NORTHWOOD,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_NORTHWOOD,

  zgemm3m_incopyb_NORTHWOOD,  zgemm3m_incopyr_NORTHWOOD,
  zgemm3m_incopyi_NORTHWOOD,  zgemm3m_itcopyb_NORTHWOOD,
  zgemm3m_itcopyr_NORTHWOOD,  zgemm3m_itcopyi_NORTHWOOD,
  zgemm3m_oncopyb_NORTHWOOD,  zgemm3m_oncopyr_NORTHWOOD,
  zgemm3m_oncopyi_NORTHWOOD,  zgemm3m_otcopyb_NORTHWOOD,
  zgemm3m_otcopyr_NORTHWOOD,  zgemm3m_otcopyi_NORTHWOOD,

  zsymm3m_iucopyb_NORTHWOOD,  zsymm3m_ilcopyb_NORTHWOOD,
  zsymm3m_iucopyr_NORTHWOOD,  zsymm3m_ilcopyr_NORTHWOOD,
  zsymm3m_iucopyi_NORTHWOOD,  zsymm3m_ilcopyi_NORTHWOOD,
  zsymm3m_oucopyb_NORTHWOOD,  zsymm3m_olcopyb_NORTHWOOD,
  zsymm3m_oucopyr_NORTHWOOD,  zsymm3m_olcopyr_NORTHWOOD,
  zsymm3m_oucopyi_NORTHWOOD,  zsymm3m_olcopyi_NORTHWOOD,

  zhemm3m_iucopyb_NORTHWOOD,  zhemm3m_ilcopyb_NORTHWOOD,
  zhemm3m_iucopyr_NORTHWOOD,  zhemm3m_ilcopyr_NORTHWOOD,
  zhemm3m_iucopyi_NORTHWOOD,  zhemm3m_ilcopyi_NORTHWOOD,

  zhemm3m_oucopyb_NORTHWOOD,  zhemm3m_olcopyb_NORTHWOOD,
  zhemm3m_oucopyr_NORTHWOOD,  zhemm3m_olcopyr_NORTHWOOD,
  zhemm3m_oucopyi_NORTHWOOD,  zhemm3m_olcopyi_NORTHWOOD,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_NORTHWOOD, zlaswp_ncopy_NORTHWOOD,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_NORTHWOOD, xamin_k_NORTHWOOD, ixamax_k_NORTHWOOD, ixamin_k_NORTHWOOD,
  xnrm2_k_NORTHWOOD, xasum_k_NORTHWOOD, xsum_k_NORTHWOOD, xcopy_k_NORTHWOOD,
  xdotu_k_NORTHWOOD, xdotc_k_NORTHWOOD, xqrot_k_NORTHWOOD,
  xaxpy_k_NORTHWOOD, xaxpyc_k_NORTHWOOD, xscal_k_NORTHWOOD, xswap_k_NORTHWOOD,

  xgemv_n_NORTHWOOD, xgemv_t_NORTHWOOD, xgemv_r_NORTHWOOD, xgemv_c_NORTHWOOD,
  xgemv_o_NORTHWOOD, xgemv_u_NORTHWOOD, xgemv_s_NORTHWOOD, xgemv_d_NORTHWOOD,
  xgeru_k_NORTHWOOD, xgerc_k_NORTHWOOD, xgerv_k_NORTHWOOD, xgerd_k_NORTHWOOD,
  xsymv_L_NORTHWOOD, xsymv_U_NORTHWOOD,
  xhemv_L_NORTHWOOD, xhemv_U_NORTHWOOD, xhemv_M_NORTHWOOD, xhemv_V_NORTHWOOD,

  xgemm_kernel_n_NORTHWOOD, xgemm_kernel_l_NORTHWOOD, xgemm_kernel_r_NORTHWOOD, xgemm_kernel_b_NORTHWOOD,
  xgemm_beta_NORTHWOOD,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_NORTHWOOD, xgemm_itcopy_NORTHWOOD,
#else
  xgemm_oncopy_NORTHWOOD, xgemm_otcopy_NORTHWOOD,
#endif
  xgemm_oncopy_NORTHWOOD, xgemm_otcopy_NORTHWOOD,

  xtrsm_kernel_LN_NORTHWOOD, xtrsm_kernel_LT_NORTHWOOD, xtrsm_kernel_LR_NORTHWOOD, xtrsm_kernel_LC_NORTHWOOD,
  xtrsm_kernel_RN_NORTHWOOD, xtrsm_kernel_RT_NORTHWOOD, xtrsm_kernel_RR_NORTHWOOD, xtrsm_kernel_RC_NORTHWOOD,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_NORTHWOOD,  xtrsm_iunncopy_NORTHWOOD,  xtrsm_iutucopy_NORTHWOOD,  xtrsm_iutncopy_NORTHWOOD,
  xtrsm_ilnucopy_NORTHWOOD,  xtrsm_ilnncopy_NORTHWOOD,  xtrsm_iltucopy_NORTHWOOD,  xtrsm_iltncopy_NORTHWOOD,
#else
  xtrsm_ounucopy_NORTHWOOD,  xtrsm_ounncopy_NORTHWOOD,  xtrsm_outucopy_NORTHWOOD,  xtrsm_outncopy_NORTHWOOD,
  xtrsm_olnucopy_NORTHWOOD,  xtrsm_olnncopy_NORTHWOOD,  xtrsm_oltucopy_NORTHWOOD,  xtrsm_oltncopy_NORTHWOOD,
#endif
  xtrsm_ounucopy_NORTHWOOD,  xtrsm_ounncopy_NORTHWOOD,  xtrsm_outucopy_NORTHWOOD,  xtrsm_outncopy_NORTHWOOD,
  xtrsm_olnucopy_NORTHWOOD,  xtrsm_olnncopy_NORTHWOOD,  xtrsm_oltucopy_NORTHWOOD,  xtrsm_oltncopy_NORTHWOOD,

  xtrmm_kernel_RN_NORTHWOOD,  xtrmm_kernel_RT_NORTHWOOD,  xtrmm_kernel_RR_NORTHWOOD,  xtrmm_kernel_RC_NORTHWOOD,
  xtrmm_kernel_LN_NORTHWOOD,  xtrmm_kernel_LT_NORTHWOOD,  xtrmm_kernel_LR_NORTHWOOD,  xtrmm_kernel_LC_NORTHWOOD,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_NORTHWOOD,  xtrmm_iunncopy_NORTHWOOD,  xtrmm_iutucopy_NORTHWOOD,  xtrmm_iutncopy_NORTHWOOD,
  xtrmm_ilnucopy_NORTHWOOD,  xtrmm_ilnncopy_NORTHWOOD,  xtrmm_iltucopy_NORTHWOOD,  xtrmm_iltncopy_NORTHWOOD,
#else
  xtrmm_ounucopy_NORTHWOOD,  xtrmm_ounncopy_NORTHWOOD,  xtrmm_outucopy_NORTHWOOD,  xtrmm_outncopy_NORTHWOOD,
  xtrmm_olnucopy_NORTHWOOD,  xtrmm_olnncopy_NORTHWOOD,  xtrmm_oltucopy_NORTHWOOD,  xtrmm_oltncopy_NORTHWOOD,
#endif
  xtrmm_ounucopy_NORTHWOOD,  xtrmm_ounncopy_NORTHWOOD,  xtrmm_outucopy_NORTHWOOD,  xtrmm_outncopy_NORTHWOOD,
  xtrmm_olnucopy_NORTHWOOD,  xtrmm_olnncopy_NORTHWOOD,  xtrmm_oltucopy_NORTHWOOD,  xtrmm_oltncopy_NORTHWOOD,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_NORTHWOOD,  xsymm_iltcopy_NORTHWOOD,
#else
  xsymm_outcopy_NORTHWOOD,  xsymm_oltcopy_NORTHWOOD,
#endif
  xsymm_outcopy_NORTHWOOD,  xsymm_oltcopy_NORTHWOOD,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_NORTHWOOD,  xhemm_iltcopy_NORTHWOOD,
#else
  xhemm_outcopy_NORTHWOOD,  xhemm_oltcopy_NORTHWOOD,
#endif
  xhemm_outcopy_NORTHWOOD,  xhemm_oltcopy_NORTHWOOD,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_NORTHWOOD,

  xgemm3m_incopyb_NORTHWOOD,  xgemm3m_incopyr_NORTHWOOD,
  xgemm3m_incopyi_NORTHWOOD,  xgemm3m_itcopyb_NORTHWOOD,
  xgemm3m_itcopyr_NORTHWOOD,  xgemm3m_itcopyi_NORTHWOOD,
  xgemm3m_oncopyb_NORTHWOOD,  xgemm3m_oncopyr_NORTHWOOD,
  xgemm3m_oncopyi_NORTHWOOD,  xgemm3m_otcopyb_NORTHWOOD,
  xgemm3m_otcopyr_NORTHWOOD,  xgemm3m_otcopyi_NORTHWOOD,

  xsymm3m_iucopyb_NORTHWOOD,  xsymm3m_ilcopyb_NORTHWOOD,
  xsymm3m_iucopyr_NORTHWOOD,  xsymm3m_ilcopyr_NORTHWOOD,
  xsymm3m_iucopyi_NORTHWOOD,  xsymm3m_ilcopyi_NORTHWOOD,
  xsymm3m_oucopyb_NORTHWOOD,  xsymm3m_olcopyb_NORTHWOOD,
  xsymm3m_oucopyr_NORTHWOOD,  xsymm3m_olcopyr_NORTHWOOD,
  xsymm3m_oucopyi_NORTHWOOD,  xsymm3m_olcopyi_NORTHWOOD,

  xhemm3m_iucopyb_NORTHWOOD,  xhemm3m_ilcopyb_NORTHWOOD,
  xhemm3m_iucopyr_NORTHWOOD,  xhemm3m_ilcopyr_NORTHWOOD,
  xhemm3m_iucopyi_NORTHWOOD,  xhemm3m_ilcopyi_NORTHWOOD,

  xhemm3m_oucopyb_NORTHWOOD,  xhemm3m_olcopyb_NORTHWOOD,
  xhemm3m_oucopyr_NORTHWOOD,  xhemm3m_olcopyr_NORTHWOOD,
  xhemm3m_oucopyi_NORTHWOOD,  xhemm3m_olcopyi_NORTHWOOD,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_NORTHWOOD, xlaswp_ncopy_NORTHWOOD,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_NORTHWOOD,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_NORTHWOOD,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_NORTHWOOD,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_NORTHWOOD,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_NORTHWOOD, somatcopy_k_ct_NORTHWOOD, somatcopy_k_rn_NORTHWOOD, somatcopy_k_rt_NORTHWOOD,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_NORTHWOOD, domatcopy_k_ct_NORTHWOOD, domatcopy_k_rn_NORTHWOOD, domatcopy_k_rt_NORTHWOOD,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_NORTHWOOD, comatcopy_k_ct_NORTHWOOD, comatcopy_k_rn_NORTHWOOD, comatcopy_k_rt_NORTHWOOD,
  comatcopy_k_cnc_NORTHWOOD, comatcopy_k_ctc_NORTHWOOD, comatcopy_k_rnc_NORTHWOOD, comatcopy_k_rtc_NORTHWOOD,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_NORTHWOOD, zomatcopy_k_ct_NORTHWOOD, zomatcopy_k_rn_NORTHWOOD, zomatcopy_k_rt_NORTHWOOD,
  zomatcopy_k_cnc_NORTHWOOD, zomatcopy_k_ctc_NORTHWOOD, zomatcopy_k_rnc_NORTHWOOD, zomatcopy_k_rtc_NORTHWOOD,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_NORTHWOOD, simatcopy_k_ct_NORTHWOOD, simatcopy_k_rn_NORTHWOOD, simatcopy_k_rt_NORTHWOOD,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_NORTHWOOD, dimatcopy_k_ct_NORTHWOOD, dimatcopy_k_rn_NORTHWOOD, dimatcopy_k_rt_NORTHWOOD,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_NORTHWOOD, cimatcopy_k_ct_NORTHWOOD, cimatcopy_k_rn_NORTHWOOD, cimatcopy_k_rt_NORTHWOOD,
  cimatcopy_k_cnc_NORTHWOOD, cimatcopy_k_ctc_NORTHWOOD, cimatcopy_k_rnc_NORTHWOOD, cimatcopy_k_rtc_NORTHWOOD,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_NORTHWOOD, zimatcopy_k_ct_NORTHWOOD, zimatcopy_k_rn_NORTHWOOD, zimatcopy_k_rt_NORTHWOOD,
  zimatcopy_k_cnc_NORTHWOOD, zimatcopy_k_ctc_NORTHWOOD, zimatcopy_k_rnc_NORTHWOOD, zimatcopy_k_rtc_NORTHWOOD,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_NORTHWOOD,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_NORTHWOOD,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_NORTHWOOD,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_NORTHWOOD
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
