/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_KATMAI;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_KATMAI.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_KATMAI, sbdtobf16_k_KATMAI, sbf16tos_k_KATMAI, dbf16tod_k_KATMAI,

  samax_k_KATMAI,  samin_k_KATMAI,  smax_k_KATMAI,  smin_k_KATMAI,
  isamax_k_KATMAI, isamin_k_KATMAI, ismax_k_KATMAI, ismin_k_KATMAI,
  snrm2_k_KATMAI,  sasum_k_KATMAI, ssum_k_KATMAI, scopy_k_KATMAI, sbdot_k_KATMAI,
  dsdot_k_KATMAI,
  srot_k_KATMAI,   saxpy_k_KATMAI,  sscal_k_KATMAI, sswap_k_KATMAI,
  sbgemv_n_KATMAI, sbgemv_t_KATMAI, sger_k_KATMAI,
  ssymv_L_KATMAI, ssymv_U_KATMAI,

  sbgemm_kernel_KATMAI, sbgemm_beta_KATMAI,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_KATMAI, sbgemm_itcopy_KATMAI,
#else
  sbgemm_oncopy_KATMAI, sbgemm_otcopy_KATMAI,
#endif
  sbgemm_oncopy_KATMAI, sbgemm_otcopy_KATMAI,

  strsm_kernel_LN_KATMAI, strsm_kernel_LT_KATMAI, strsm_kernel_RN_KATMAI, strsm_kernel_RT_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_KATMAI, strsm_iunncopy_KATMAI, strsm_iutucopy_KATMAI, strsm_iutncopy_KATMAI,
  strsm_ilnucopy_KATMAI, strsm_ilnncopy_KATMAI, strsm_iltucopy_KATMAI, strsm_iltncopy_KATMAI,
#else
  strsm_ounucopy_KATMAI, strsm_ounncopy_KATMAI, strsm_outucopy_KATMAI, strsm_outncopy_KATMAI,
  strsm_olnucopy_KATMAI, strsm_olnncopy_KATMAI, strsm_oltucopy_KATMAI, strsm_oltncopy_KATMAI,
#endif
  strsm_ounucopy_KATMAI, strsm_ounncopy_KATMAI, strsm_outucopy_KATMAI, strsm_outncopy_KATMAI,
  strsm_olnucopy_KATMAI, strsm_olnncopy_KATMAI, strsm_oltucopy_KATMAI, strsm_oltncopy_KATMAI,
  strmm_kernel_RN_KATMAI, strmm_kernel_RT_KATMAI, strmm_kernel_LN_KATMAI, strmm_kernel_LT_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_KATMAI, strmm_iunncopy_KATMAI, strmm_iutucopy_KATMAI, strmm_iutncopy_KATMAI,
  strmm_ilnucopy_KATMAI, strmm_ilnncopy_KATMAI, strmm_iltucopy_KATMAI, strmm_iltncopy_KATMAI,
#else
  strmm_ounucopy_KATMAI, strmm_ounncopy_KATMAI, strmm_outucopy_KATMAI, strmm_outncopy_KATMAI,
  strmm_olnucopy_KATMAI, strmm_olnncopy_KATMAI, strmm_oltucopy_KATMAI, strmm_oltncopy_KATMAI,
#endif
  strmm_ounucopy_KATMAI, strmm_ounncopy_KATMAI, strmm_outucopy_KATMAI, strmm_outncopy_KATMAI,
  strmm_olnucopy_KATMAI, strmm_olnncopy_KATMAI, strmm_oltucopy_KATMAI, strmm_oltncopy_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_KATMAI, ssymm_iltcopy_KATMAI,
#else
  ssymm_outcopy_KATMAI, ssymm_oltcopy_KATMAI,
#endif
  ssymm_outcopy_KATMAI, ssymm_oltcopy_KATMAI,

#ifndef NO_LAPACK
  sneg_tcopy_KATMAI, slaswp_ncopy_KATMAI,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_KATMAI,
  sbgemm_small_kernel_nn_KATMAI, sbgemm_small_kernel_nt_KATMAI, sbgemm_small_kernel_tn_KATMAI, sbgemm_small_kernel_tt_KATMAI,
  sbgemm_small_kernel_b0_nn_KATMAI, sbgemm_small_kernel_b0_nt_KATMAI, sbgemm_small_kernel_b0_tn_KATMAI, sbgemm_small_kernel_b0_tt_KATMAI,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_KATMAI,  samin_k_KATMAI,  smax_k_KATMAI,  smin_k_KATMAI,
  isamax_k_KATMAI, isamin_k_KATMAI, ismax_k_KATMAI, ismin_k_KATMAI,
  snrm2_k_KATMAI,  sasum_k_KATMAI,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_KATMAI,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_KATMAI, sdot_k_KATMAI,
//  dsdot_k_KATMAI,
  srot_k_KATMAI,   saxpy_k_KATMAI,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_KATMAI,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_KATMAI,
  sgemv_n_KATMAI,  sgemv_t_KATMAI,
#endif
#if BUILD_SINGLE == 1  
  sger_k_KATMAI,
  ssymv_L_KATMAI, ssymv_U_KATMAI,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_KATMAI,
  sgemm_direct_performant_KATMAI,	
#endif

  sgemm_kernel_KATMAI, sgemm_beta_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_KATMAI, sgemm_itcopy_KATMAI,
#else
  sgemm_oncopy_KATMAI, sgemm_otcopy_KATMAI,
#endif
  sgemm_oncopy_KATMAI, sgemm_otcopy_KATMAI,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_KATMAI,
  sgemm_small_kernel_nn_KATMAI, sgemm_small_kernel_nt_KATMAI, sgemm_small_kernel_tn_KATMAI, sgemm_small_kernel_tt_KATMAI,
  sgemm_small_kernel_b0_nn_KATMAI, sgemm_small_kernel_b0_nt_KATMAI, sgemm_small_kernel_b0_tn_KATMAI, sgemm_small_kernel_b0_tt_KATMAI,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_KATMAI, strsm_kernel_LT_KATMAI, strsm_kernel_RN_KATMAI, strsm_kernel_RT_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_KATMAI, strsm_iunncopy_KATMAI, strsm_iutucopy_KATMAI, strsm_iutncopy_KATMAI,
  strsm_ilnucopy_KATMAI, strsm_ilnncopy_KATMAI, strsm_iltucopy_KATMAI, strsm_iltncopy_KATMAI,
#else
  strsm_ounucopy_KATMAI, strsm_ounncopy_KATMAI, strsm_outucopy_KATMAI, strsm_outncopy_KATMAI,
  strsm_olnucopy_KATMAI, strsm_olnncopy_KATMAI, strsm_oltucopy_KATMAI, strsm_oltncopy_KATMAI,
#endif
  strsm_ounucopy_KATMAI, strsm_ounncopy_KATMAI, strsm_outucopy_KATMAI, strsm_outncopy_KATMAI,
  strsm_olnucopy_KATMAI, strsm_olnncopy_KATMAI, strsm_oltucopy_KATMAI, strsm_oltncopy_KATMAI,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_KATMAI, strmm_kernel_RT_KATMAI, strmm_kernel_LN_KATMAI, strmm_kernel_LT_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_KATMAI, strmm_iunncopy_KATMAI, strmm_iutucopy_KATMAI, strmm_iutncopy_KATMAI,
  strmm_ilnucopy_KATMAI, strmm_ilnncopy_KATMAI, strmm_iltucopy_KATMAI, strmm_iltncopy_KATMAI,
#else
  strmm_ounucopy_KATMAI, strmm_ounncopy_KATMAI, strmm_outucopy_KATMAI, strmm_outncopy_KATMAI,
  strmm_olnucopy_KATMAI, strmm_olnncopy_KATMAI, strmm_oltucopy_KATMAI, strmm_oltncopy_KATMAI,
#endif
  strmm_ounucopy_KATMAI, strmm_ounncopy_KATMAI, strmm_outucopy_KATMAI, strmm_outncopy_KATMAI,
  strmm_olnucopy_KATMAI, strmm_olnncopy_KATMAI, strmm_oltucopy_KATMAI, strmm_oltncopy_KATMAI,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_KATMAI, ssymm_iltcopy_KATMAI,
#else
  ssymm_outcopy_KATMAI, ssymm_oltcopy_KATMAI,
#endif
  ssymm_outcopy_KATMAI, ssymm_oltcopy_KATMAI,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_KATMAI, slaswp_ncopy_KATMAI,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_KATMAI,  damin_k_KATMAI,  dmax_k_KATMAI,  dmin_k_KATMAI,
  idamax_k_KATMAI, idamin_k_KATMAI, idmax_k_KATMAI, idmin_k_KATMAI,
  dnrm2_k_KATMAI, dasum_k_KATMAI,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_KATMAI,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_KATMAI, ddot_k_KATMAI,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_KATMAI,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_KATMAI,
  daxpy_k_KATMAI,
  dscal_k_KATMAI, 
  dswap_k_KATMAI,
  dgemv_n_KATMAI,  dgemv_t_KATMAI,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_KATMAI,
  dsymv_L_KATMAI,  dsymv_U_KATMAI,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_KATMAI, dgemm_beta_KATMAI,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_KATMAI, dgemm_itcopy_KATMAI,
#else
  dgemm_oncopy_KATMAI, dgemm_otcopy_KATMAI,
#endif
  dgemm_oncopy_KATMAI, dgemm_otcopy_KATMAI,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_KATMAI,
  dgemm_small_kernel_nn_KATMAI, dgemm_small_kernel_nt_KATMAI, dgemm_small_kernel_tn_KATMAI, dgemm_small_kernel_tt_KATMAI,
  dgemm_small_kernel_b0_nn_KATMAI, dgemm_small_kernel_b0_nt_KATMAI, dgemm_small_kernel_b0_tn_KATMAI, dgemm_small_kernel_b0_tt_KATMAI,
#endif
  dtrsm_kernel_LN_KATMAI, dtrsm_kernel_LT_KATMAI, dtrsm_kernel_RN_KATMAI, dtrsm_kernel_RT_KATMAI,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_KATMAI, dtrsm_iunncopy_KATMAI, dtrsm_iutucopy_KATMAI, dtrsm_iutncopy_KATMAI,
  dtrsm_ilnucopy_KATMAI, dtrsm_ilnncopy_KATMAI, dtrsm_iltucopy_KATMAI, dtrsm_iltncopy_KATMAI,
#else
  dtrsm_ounucopy_KATMAI, dtrsm_ounncopy_KATMAI, dtrsm_outucopy_KATMAI, dtrsm_outncopy_KATMAI,
  dtrsm_olnucopy_KATMAI, dtrsm_olnncopy_KATMAI, dtrsm_oltucopy_KATMAI, dtrsm_oltncopy_KATMAI,
#endif
  dtrsm_ounucopy_KATMAI, dtrsm_ounncopy_KATMAI, dtrsm_outucopy_KATMAI, dtrsm_outncopy_KATMAI,
  dtrsm_olnucopy_KATMAI, dtrsm_olnncopy_KATMAI, dtrsm_oltucopy_KATMAI, dtrsm_oltncopy_KATMAI,
  dtrmm_kernel_RN_KATMAI, dtrmm_kernel_RT_KATMAI, dtrmm_kernel_LN_KATMAI, dtrmm_kernel_LT_KATMAI,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_KATMAI, dtrmm_iunncopy_KATMAI, dtrmm_iutucopy_KATMAI, dtrmm_iutncopy_KATMAI,
  dtrmm_ilnucopy_KATMAI, dtrmm_ilnncopy_KATMAI, dtrmm_iltucopy_KATMAI, dtrmm_iltncopy_KATMAI,
#else
  dtrmm_ounucopy_KATMAI, dtrmm_ounncopy_KATMAI, dtrmm_outucopy_KATMAI, dtrmm_outncopy_KATMAI,
  dtrmm_olnucopy_KATMAI, dtrmm_olnncopy_KATMAI, dtrmm_oltucopy_KATMAI, dtrmm_oltncopy_KATMAI,
#endif
  dtrmm_ounucopy_KATMAI, dtrmm_ounncopy_KATMAI, dtrmm_outucopy_KATMAI, dtrmm_outncopy_KATMAI,
  dtrmm_olnucopy_KATMAI, dtrmm_olnncopy_KATMAI, dtrmm_oltucopy_KATMAI, dtrmm_oltncopy_KATMAI,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_KATMAI, dsymm_iltcopy_KATMAI,
#else
  dsymm_outcopy_KATMAI, dsymm_oltcopy_KATMAI,
#endif
  dsymm_outcopy_KATMAI, dsymm_oltcopy_KATMAI,

#ifndef NO_LAPACK
  dneg_tcopy_KATMAI, dlaswp_ncopy_KATMAI,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_KATMAI,  qamin_k_KATMAI,  qmax_k_KATMAI,  qmin_k_KATMAI,
  iqamax_k_KATMAI, iqamin_k_KATMAI, iqmax_k_KATMAI, iqmin_k_KATMAI,
  qnrm2_k_KATMAI,  qasum_k_KATMAI,  qsum_k_KATMAI, qcopy_k_KATMAI, qdot_k_KATMAI,
  qrot_k_KATMAI,   qaxpy_k_KATMAI,  qscal_k_KATMAI, qswap_k_KATMAI,
  qgemv_n_KATMAI,  qgemv_t_KATMAI,  qger_k_KATMAI,
  qsymv_L_KATMAI,  qsymv_U_KATMAI,

  qgemm_kernel_KATMAI, qgemm_beta_KATMAI,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_KATMAI, qgemm_itcopy_KATMAI,
#else
  qgemm_oncopy_KATMAI, qgemm_otcopy_KATMAI,
#endif
  qgemm_oncopy_KATMAI, qgemm_otcopy_KATMAI,
  qtrsm_kernel_LN_KATMAI, qtrsm_kernel_LT_KATMAI, qtrsm_kernel_RN_KATMAI, qtrsm_kernel_RT_KATMAI,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_KATMAI, qtrsm_iunncopy_KATMAI, qtrsm_iutucopy_KATMAI, qtrsm_iutncopy_KATMAI,
  qtrsm_ilnucopy_KATMAI, qtrsm_ilnncopy_KATMAI, qtrsm_iltucopy_KATMAI, qtrsm_iltncopy_KATMAI,
#else
  qtrsm_ounucopy_KATMAI, qtrsm_ounncopy_KATMAI, qtrsm_outucopy_KATMAI, qtrsm_outncopy_KATMAI,
  qtrsm_olnucopy_KATMAI, qtrsm_olnncopy_KATMAI, qtrsm_oltucopy_KATMAI, qtrsm_oltncopy_KATMAI,
#endif
  qtrsm_ounucopy_KATMAI, qtrsm_ounncopy_KATMAI, qtrsm_outucopy_KATMAI, qtrsm_outncopy_KATMAI,
  qtrsm_olnucopy_KATMAI, qtrsm_olnncopy_KATMAI, qtrsm_oltucopy_KATMAI, qtrsm_oltncopy_KATMAI,
  qtrmm_kernel_RN_KATMAI, qtrmm_kernel_RT_KATMAI, qtrmm_kernel_LN_KATMAI, qtrmm_kernel_LT_KATMAI,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_KATMAI, qtrmm_iunncopy_KATMAI, qtrmm_iutucopy_KATMAI, qtrmm_iutncopy_KATMAI,
  qtrmm_ilnucopy_KATMAI, qtrmm_ilnncopy_KATMAI, qtrmm_iltucopy_KATMAI, qtrmm_iltncopy_KATMAI,
#else
  qtrmm_ounucopy_KATMAI, qtrmm_ounncopy_KATMAI, qtrmm_outucopy_KATMAI, qtrmm_outncopy_KATMAI,
  qtrmm_olnucopy_KATMAI, qtrmm_olnncopy_KATMAI, qtrmm_oltucopy_KATMAI, qtrmm_oltncopy_KATMAI,
#endif
  qtrmm_ounucopy_KATMAI, qtrmm_ounncopy_KATMAI, qtrmm_outucopy_KATMAI, qtrmm_outncopy_KATMAI,
  qtrmm_olnucopy_KATMAI, qtrmm_olnncopy_KATMAI, qtrmm_oltucopy_KATMAI, qtrmm_oltncopy_KATMAI,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_KATMAI, qsymm_iltcopy_KATMAI,
#else
  qsymm_outcopy_KATMAI, qsymm_oltcopy_KATMAI,
#endif
  qsymm_outcopy_KATMAI, qsymm_oltcopy_KATMAI,

#ifndef NO_LAPACK
  qneg_tcopy_KATMAI, qlaswp_ncopy_KATMAI,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_KATMAI, camin_k_KATMAI, icamax_k_KATMAI, icamin_k_KATMAI,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_KATMAI, casum_k_KATMAI, csum_k_KATMAI,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_KATMAI,  cdotu_k_KATMAI, cdotc_k_KATMAI,
#endif
#if (BUILD_COMPLEX)
 csrot_k_KATMAI,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_KATMAI,
  caxpyc_k_KATMAI, 
  cscal_k_KATMAI, 
  cswap_k_KATMAI,

  cgemv_n_KATMAI, cgemv_t_KATMAI, cgemv_r_KATMAI, cgemv_c_KATMAI,
  cgemv_o_KATMAI, cgemv_u_KATMAI, cgemv_s_KATMAI, cgemv_d_KATMAI,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_KATMAI, cgerc_k_KATMAI, cgerv_k_KATMAI, cgerd_k_KATMAI,
  csymv_L_KATMAI, csymv_U_KATMAI,
  chemv_L_KATMAI, chemv_U_KATMAI, chemv_M_KATMAI, chemv_V_KATMAI,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_KATMAI, cgemm_kernel_l_KATMAI, cgemm_kernel_r_KATMAI, cgemm_kernel_b_KATMAI,
  cgemm_beta_KATMAI,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_KATMAI, cgemm_itcopy_KATMAI,
#else
  cgemm_oncopy_KATMAI, cgemm_otcopy_KATMAI,
#endif
  cgemm_oncopy_KATMAI, cgemm_otcopy_KATMAI,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_KATMAI,
  cgemm_small_kernel_nn_KATMAI, cgemm_small_kernel_nt_KATMAI, cgemm_small_kernel_nr_KATMAI, cgemm_small_kernel_nc_KATMAI,
  cgemm_small_kernel_tn_KATMAI, cgemm_small_kernel_tt_KATMAI, cgemm_small_kernel_tr_KATMAI, cgemm_small_kernel_tc_KATMAI,
  cgemm_small_kernel_rn_KATMAI, cgemm_small_kernel_rt_KATMAI, cgemm_small_kernel_rr_KATMAI, cgemm_small_kernel_rc_KATMAI,
  cgemm_small_kernel_cn_KATMAI, cgemm_small_kernel_ct_KATMAI, cgemm_small_kernel_cr_KATMAI, cgemm_small_kernel_cc_KATMAI,
  cgemm_small_kernel_b0_nn_KATMAI, cgemm_small_kernel_b0_nt_KATMAI, cgemm_small_kernel_b0_nr_KATMAI, cgemm_small_kernel_b0_nc_KATMAI,
  cgemm_small_kernel_b0_tn_KATMAI, cgemm_small_kernel_b0_tt_KATMAI, cgemm_small_kernel_b0_tr_KATMAI, cgemm_small_kernel_b0_tc_KATMAI,
  cgemm_small_kernel_b0_rn_KATMAI, cgemm_small_kernel_b0_rt_KATMAI, cgemm_small_kernel_b0_rr_KATMAI, cgemm_small_kernel_b0_rc_KATMAI,
  cgemm_small_kernel_b0_cn_KATMAI, cgemm_small_kernel_b0_ct_KATMAI, cgemm_small_kernel_b0_cr_KATMAI, cgemm_small_kernel_b0_cc_KATMAI,
#endif

  ctrsm_kernel_LN_KATMAI, ctrsm_kernel_LT_KATMAI, ctrsm_kernel_LR_KATMAI, ctrsm_kernel_LC_KATMAI,
  ctrsm_kernel_RN_KATMAI, ctrsm_kernel_RT_KATMAI, ctrsm_kernel_RR_KATMAI, ctrsm_kernel_RC_KATMAI,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_KATMAI,  ctrsm_iunncopy_KATMAI,  ctrsm_iutucopy_KATMAI,  ctrsm_iutncopy_KATMAI,
  ctrsm_ilnucopy_KATMAI,  ctrsm_ilnncopy_KATMAI,  ctrsm_iltucopy_KATMAI,  ctrsm_iltncopy_KATMAI,
#else
  ctrsm_ounucopy_KATMAI,  ctrsm_ounncopy_KATMAI,  ctrsm_outucopy_KATMAI,  ctrsm_outncopy_KATMAI,
  ctrsm_olnucopy_KATMAI,  ctrsm_olnncopy_KATMAI,  ctrsm_oltucopy_KATMAI,  ctrsm_oltncopy_KATMAI,
#endif
  ctrsm_ounucopy_KATMAI,  ctrsm_ounncopy_KATMAI,  ctrsm_outucopy_KATMAI,  ctrsm_outncopy_KATMAI,
  ctrsm_olnucopy_KATMAI,  ctrsm_olnncopy_KATMAI,  ctrsm_oltucopy_KATMAI,  ctrsm_oltncopy_KATMAI,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_KATMAI,  ctrmm_kernel_RT_KATMAI,  ctrmm_kernel_RR_KATMAI,  ctrmm_kernel_RC_KATMAI,
  ctrmm_kernel_LN_KATMAI,  ctrmm_kernel_LT_KATMAI,  ctrmm_kernel_LR_KATMAI,  ctrmm_kernel_LC_KATMAI,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_KATMAI,  ctrmm_iunncopy_KATMAI,  ctrmm_iutucopy_KATMAI,  ctrmm_iutncopy_KATMAI,
  ctrmm_ilnucopy_KATMAI,  ctrmm_ilnncopy_KATMAI,  ctrmm_iltucopy_KATMAI,  ctrmm_iltncopy_KATMAI,
#else
  ctrmm_ounucopy_KATMAI,  ctrmm_ounncopy_KATMAI,  ctrmm_outucopy_KATMAI,  ctrmm_outncopy_KATMAI,
  ctrmm_olnucopy_KATMAI,  ctrmm_olnncopy_KATMAI,  ctrmm_oltucopy_KATMAI,  ctrmm_oltncopy_KATMAI,
#endif
  ctrmm_ounucopy_KATMAI,  ctrmm_ounncopy_KATMAI,  ctrmm_outucopy_KATMAI,  ctrmm_outncopy_KATMAI,
  ctrmm_olnucopy_KATMAI,  ctrmm_olnncopy_KATMAI,  ctrmm_oltucopy_KATMAI,  ctrmm_oltncopy_KATMAI,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_KATMAI,  csymm_iltcopy_KATMAI,
#else
  csymm_outcopy_KATMAI,  csymm_oltcopy_KATMAI,
#endif
  csymm_outcopy_KATMAI,  csymm_oltcopy_KATMAI,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_KATMAI,  chemm_iltcopy_KATMAI,
#else
  chemm_outcopy_KATMAI,  chemm_oltcopy_KATMAI,
#endif
  chemm_outcopy_KATMAI,  chemm_oltcopy_KATMAI,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_KATMAI,

  cgemm3m_incopyb_KATMAI,  cgemm3m_incopyr_KATMAI,
  cgemm3m_incopyi_KATMAI,  cgemm3m_itcopyb_KATMAI,
  cgemm3m_itcopyr_KATMAI,  cgemm3m_itcopyi_KATMAI,
  cgemm3m_oncopyb_KATMAI,  cgemm3m_oncopyr_KATMAI,
  cgemm3m_oncopyi_KATMAI,  cgemm3m_otcopyb_KATMAI,
  cgemm3m_otcopyr_KATMAI,  cgemm3m_otcopyi_KATMAI,

  csymm3m_iucopyb_KATMAI,  csymm3m_ilcopyb_KATMAI,
  csymm3m_iucopyr_KATMAI,  csymm3m_ilcopyr_KATMAI,
  csymm3m_iucopyi_KATMAI,  csymm3m_ilcopyi_KATMAI,
  csymm3m_oucopyb_KATMAI,  csymm3m_olcopyb_KATMAI,
  csymm3m_oucopyr_KATMAI,  csymm3m_olcopyr_KATMAI,
  csymm3m_oucopyi_KATMAI,  csymm3m_olcopyi_KATMAI,

  chemm3m_iucopyb_KATMAI,  chemm3m_ilcopyb_KATMAI,
  chemm3m_iucopyr_KATMAI,  chemm3m_ilcopyr_KATMAI,
  chemm3m_iucopyi_KATMAI,  chemm3m_ilcopyi_KATMAI,

  chemm3m_oucopyb_KATMAI,  chemm3m_olcopyb_KATMAI,
  chemm3m_oucopyr_KATMAI,  chemm3m_olcopyr_KATMAI,
  chemm3m_oucopyi_KATMAI,  chemm3m_olcopyi_KATMAI,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_KATMAI,
  
   claswp_ncopy_KATMAI,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_KATMAI, zamin_k_KATMAI, izamax_k_KATMAI, izamin_k_KATMAI,
  znrm2_k_KATMAI, zasum_k_KATMAI, zsum_k_KATMAI, zcopy_k_KATMAI,
  zdotu_k_KATMAI, zdotc_k_KATMAI, zdrot_k_KATMAI,
  zaxpy_k_KATMAI, zaxpyc_k_KATMAI, zscal_k_KATMAI, zswap_k_KATMAI,

  zgemv_n_KATMAI, zgemv_t_KATMAI, zgemv_r_KATMAI, zgemv_c_KATMAI,
  zgemv_o_KATMAI, zgemv_u_KATMAI, zgemv_s_KATMAI, zgemv_d_KATMAI,
  zgeru_k_KATMAI, zgerc_k_KATMAI, zgerv_k_KATMAI, zgerd_k_KATMAI,
  zsymv_L_KATMAI, zsymv_U_KATMAI,
  zhemv_L_KATMAI, zhemv_U_KATMAI, zhemv_M_KATMAI, zhemv_V_KATMAI,

  zgemm_kernel_n_KATMAI, zgemm_kernel_l_KATMAI, zgemm_kernel_r_KATMAI, zgemm_kernel_b_KATMAI,
  zgemm_beta_KATMAI,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_KATMAI, zgemm_itcopy_KATMAI,
#else
  zgemm_oncopy_KATMAI, zgemm_otcopy_KATMAI,
#endif
  zgemm_oncopy_KATMAI, zgemm_otcopy_KATMAI,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_KATMAI,
  zgemm_small_kernel_nn_KATMAI, zgemm_small_kernel_nt_KATMAI, zgemm_small_kernel_nr_KATMAI, zgemm_small_kernel_nc_KATMAI,
  zgemm_small_kernel_tn_KATMAI, zgemm_small_kernel_tt_KATMAI, zgemm_small_kernel_tr_KATMAI, zgemm_small_kernel_tc_KATMAI,
  zgemm_small_kernel_rn_KATMAI, zgemm_small_kernel_rt_KATMAI, zgemm_small_kernel_rr_KATMAI, zgemm_small_kernel_rc_KATMAI,
  zgemm_small_kernel_cn_KATMAI, zgemm_small_kernel_ct_KATMAI, zgemm_small_kernel_cr_KATMAI, zgemm_small_kernel_cc_KATMAI,
  zgemm_small_kernel_b0_nn_KATMAI, zgemm_small_kernel_b0_nt_KATMAI, zgemm_small_kernel_b0_nr_KATMAI, zgemm_small_kernel_b0_nc_KATMAI,
  zgemm_small_kernel_b0_tn_KATMAI, zgemm_small_kernel_b0_tt_KATMAI, zgemm_small_kernel_b0_tr_KATMAI, zgemm_small_kernel_b0_tc_KATMAI,
  zgemm_small_kernel_b0_rn_KATMAI, zgemm_small_kernel_b0_rt_KATMAI, zgemm_small_kernel_b0_rr_KATMAI, zgemm_small_kernel_b0_rc_KATMAI,
  zgemm_small_kernel_b0_cn_KATMAI, zgemm_small_kernel_b0_ct_KATMAI, zgemm_small_kernel_b0_cr_KATMAI, zgemm_small_kernel_b0_cc_KATMAI,
#endif

  ztrsm_kernel_LN_KATMAI, ztrsm_kernel_LT_KATMAI, ztrsm_kernel_LR_KATMAI, ztrsm_kernel_LC_KATMAI,
  ztrsm_kernel_RN_KATMAI, ztrsm_kernel_RT_KATMAI, ztrsm_kernel_RR_KATMAI, ztrsm_kernel_RC_KATMAI,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_KATMAI,  ztrsm_iunncopy_KATMAI,  ztrsm_iutucopy_KATMAI,  ztrsm_iutncopy_KATMAI,
  ztrsm_ilnucopy_KATMAI,  ztrsm_ilnncopy_KATMAI,  ztrsm_iltucopy_KATMAI,  ztrsm_iltncopy_KATMAI,
#else
  ztrsm_ounucopy_KATMAI,  ztrsm_ounncopy_KATMAI,  ztrsm_outucopy_KATMAI,  ztrsm_outncopy_KATMAI,
  ztrsm_olnucopy_KATMAI,  ztrsm_olnncopy_KATMAI,  ztrsm_oltucopy_KATMAI,  ztrsm_oltncopy_KATMAI,
#endif
  ztrsm_ounucopy_KATMAI,  ztrsm_ounncopy_KATMAI,  ztrsm_outucopy_KATMAI,  ztrsm_outncopy_KATMAI,
  ztrsm_olnucopy_KATMAI,  ztrsm_olnncopy_KATMAI,  ztrsm_oltucopy_KATMAI,  ztrsm_oltncopy_KATMAI,

  ztrmm_kernel_RN_KATMAI,  ztrmm_kernel_RT_KATMAI,  ztrmm_kernel_RR_KATMAI,  ztrmm_kernel_RC_KATMAI,
  ztrmm_kernel_LN_KATMAI,  ztrmm_kernel_LT_KATMAI,  ztrmm_kernel_LR_KATMAI,  ztrmm_kernel_LC_KATMAI,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_KATMAI,  ztrmm_iunncopy_KATMAI,  ztrmm_iutucopy_KATMAI,  ztrmm_iutncopy_KATMAI,
  ztrmm_ilnucopy_KATMAI,  ztrmm_ilnncopy_KATMAI,  ztrmm_iltucopy_KATMAI,  ztrmm_iltncopy_KATMAI,
#else
  ztrmm_ounucopy_KATMAI,  ztrmm_ounncopy_KATMAI,  ztrmm_outucopy_KATMAI,  ztrmm_outncopy_KATMAI,
  ztrmm_olnucopy_KATMAI,  ztrmm_olnncopy_KATMAI,  ztrmm_oltucopy_KATMAI,  ztrmm_oltncopy_KATMAI,
#endif
  ztrmm_ounucopy_KATMAI,  ztrmm_ounncopy_KATMAI,  ztrmm_outucopy_KATMAI,  ztrmm_outncopy_KATMAI,
  ztrmm_olnucopy_KATMAI,  ztrmm_olnncopy_KATMAI,  ztrmm_oltucopy_KATMAI,  ztrmm_oltncopy_KATMAI,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_KATMAI,  zsymm_iltcopy_KATMAI,
#else
  zsymm_outcopy_KATMAI,  zsymm_oltcopy_KATMAI,
#endif
  zsymm_outcopy_KATMAI,  zsymm_oltcopy_KATMAI,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_KATMAI,  zhemm_iltcopy_KATMAI,
#else
  zhemm_outcopy_KATMAI,  zhemm_oltcopy_KATMAI,
#endif
  zhemm_outcopy_KATMAI,  zhemm_oltcopy_KATMAI,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_KATMAI,

  zgemm3m_incopyb_KATMAI,  zgemm3m_incopyr_KATMAI,
  zgemm3m_incopyi_KATMAI,  zgemm3m_itcopyb_KATMAI,
  zgemm3m_itcopyr_KATMAI,  zgemm3m_itcopyi_KATMAI,
  zgemm3m_oncopyb_KATMAI,  zgemm3m_oncopyr_KATMAI,
  zgemm3m_oncopyi_KATMAI,  zgemm3m_otcopyb_KATMAI,
  zgemm3m_otcopyr_KATMAI,  zgemm3m_otcopyi_KATMAI,

  zsymm3m_iucopyb_KATMAI,  zsymm3m_ilcopyb_KATMAI,
  zsymm3m_iucopyr_KATMAI,  zsymm3m_ilcopyr_KATMAI,
  zsymm3m_iucopyi_KATMAI,  zsymm3m_ilcopyi_KATMAI,
  zsymm3m_oucopyb_KATMAI,  zsymm3m_olcopyb_KATMAI,
  zsymm3m_oucopyr_KATMAI,  zsymm3m_olcopyr_KATMAI,
  zsymm3m_oucopyi_KATMAI,  zsymm3m_olcopyi_KATMAI,

  zhemm3m_iucopyb_KATMAI,  zhemm3m_ilcopyb_KATMAI,
  zhemm3m_iucopyr_KATMAI,  zhemm3m_ilcopyr_KATMAI,
  zhemm3m_iucopyi_KATMAI,  zhemm3m_ilcopyi_KATMAI,

  zhemm3m_oucopyb_KATMAI,  zhemm3m_olcopyb_KATMAI,
  zhemm3m_oucopyr_KATMAI,  zhemm3m_olcopyr_KATMAI,
  zhemm3m_oucopyi_KATMAI,  zhemm3m_olcopyi_KATMAI,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_KATMAI, zlaswp_ncopy_KATMAI,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_KATMAI, xamin_k_KATMAI, ixamax_k_KATMAI, ixamin_k_KATMAI,
  xnrm2_k_KATMAI, xasum_k_KATMAI, xsum_k_KATMAI, xcopy_k_KATMAI,
  xdotu_k_KATMAI, xdotc_k_KATMAI, xqrot_k_KATMAI,
  xaxpy_k_KATMAI, xaxpyc_k_KATMAI, xscal_k_KATMAI, xswap_k_KATMAI,

  xgemv_n_KATMAI, xgemv_t_KATMAI, xgemv_r_KATMAI, xgemv_c_KATMAI,
  xgemv_o_KATMAI, xgemv_u_KATMAI, xgemv_s_KATMAI, xgemv_d_KATMAI,
  xgeru_k_KATMAI, xgerc_k_KATMAI, xgerv_k_KATMAI, xgerd_k_KATMAI,
  xsymv_L_KATMAI, xsymv_U_KATMAI,
  xhemv_L_KATMAI, xhemv_U_KATMAI, xhemv_M_KATMAI, xhemv_V_KATMAI,

  xgemm_kernel_n_KATMAI, xgemm_kernel_l_KATMAI, xgemm_kernel_r_KATMAI, xgemm_kernel_b_KATMAI,
  xgemm_beta_KATMAI,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_KATMAI, xgemm_itcopy_KATMAI,
#else
  xgemm_oncopy_KATMAI, xgemm_otcopy_KATMAI,
#endif
  xgemm_oncopy_KATMAI, xgemm_otcopy_KATMAI,

  xtrsm_kernel_LN_KATMAI, xtrsm_kernel_LT_KATMAI, xtrsm_kernel_LR_KATMAI, xtrsm_kernel_LC_KATMAI,
  xtrsm_kernel_RN_KATMAI, xtrsm_kernel_RT_KATMAI, xtrsm_kernel_RR_KATMAI, xtrsm_kernel_RC_KATMAI,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_KATMAI,  xtrsm_iunncopy_KATMAI,  xtrsm_iutucopy_KATMAI,  xtrsm_iutncopy_KATMAI,
  xtrsm_ilnucopy_KATMAI,  xtrsm_ilnncopy_KATMAI,  xtrsm_iltucopy_KATMAI,  xtrsm_iltncopy_KATMAI,
#else
  xtrsm_ounucopy_KATMAI,  xtrsm_ounncopy_KATMAI,  xtrsm_outucopy_KATMAI,  xtrsm_outncopy_KATMAI,
  xtrsm_olnucopy_KATMAI,  xtrsm_olnncopy_KATMAI,  xtrsm_oltucopy_KATMAI,  xtrsm_oltncopy_KATMAI,
#endif
  xtrsm_ounucopy_KATMAI,  xtrsm_ounncopy_KATMAI,  xtrsm_outucopy_KATMAI,  xtrsm_outncopy_KATMAI,
  xtrsm_olnucopy_KATMAI,  xtrsm_olnncopy_KATMAI,  xtrsm_oltucopy_KATMAI,  xtrsm_oltncopy_KATMAI,

  xtrmm_kernel_RN_KATMAI,  xtrmm_kernel_RT_KATMAI,  xtrmm_kernel_RR_KATMAI,  xtrmm_kernel_RC_KATMAI,
  xtrmm_kernel_LN_KATMAI,  xtrmm_kernel_LT_KATMAI,  xtrmm_kernel_LR_KATMAI,  xtrmm_kernel_LC_KATMAI,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_KATMAI,  xtrmm_iunncopy_KATMAI,  xtrmm_iutucopy_KATMAI,  xtrmm_iutncopy_KATMAI,
  xtrmm_ilnucopy_KATMAI,  xtrmm_ilnncopy_KATMAI,  xtrmm_iltucopy_KATMAI,  xtrmm_iltncopy_KATMAI,
#else
  xtrmm_ounucopy_KATMAI,  xtrmm_ounncopy_KATMAI,  xtrmm_outucopy_KATMAI,  xtrmm_outncopy_KATMAI,
  xtrmm_olnucopy_KATMAI,  xtrmm_olnncopy_KATMAI,  xtrmm_oltucopy_KATMAI,  xtrmm_oltncopy_KATMAI,
#endif
  xtrmm_ounucopy_KATMAI,  xtrmm_ounncopy_KATMAI,  xtrmm_outucopy_KATMAI,  xtrmm_outncopy_KATMAI,
  xtrmm_olnucopy_KATMAI,  xtrmm_olnncopy_KATMAI,  xtrmm_oltucopy_KATMAI,  xtrmm_oltncopy_KATMAI,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_KATMAI,  xsymm_iltcopy_KATMAI,
#else
  xsymm_outcopy_KATMAI,  xsymm_oltcopy_KATMAI,
#endif
  xsymm_outcopy_KATMAI,  xsymm_oltcopy_KATMAI,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_KATMAI,  xhemm_iltcopy_KATMAI,
#else
  xhemm_outcopy_KATMAI,  xhemm_oltcopy_KATMAI,
#endif
  xhemm_outcopy_KATMAI,  xhemm_oltcopy_KATMAI,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_KATMAI,

  xgemm3m_incopyb_KATMAI,  xgemm3m_incopyr_KATMAI,
  xgemm3m_incopyi_KATMAI,  xgemm3m_itcopyb_KATMAI,
  xgemm3m_itcopyr_KATMAI,  xgemm3m_itcopyi_KATMAI,
  xgemm3m_oncopyb_KATMAI,  xgemm3m_oncopyr_KATMAI,
  xgemm3m_oncopyi_KATMAI,  xgemm3m_otcopyb_KATMAI,
  xgemm3m_otcopyr_KATMAI,  xgemm3m_otcopyi_KATMAI,

  xsymm3m_iucopyb_KATMAI,  xsymm3m_ilcopyb_KATMAI,
  xsymm3m_iucopyr_KATMAI,  xsymm3m_ilcopyr_KATMAI,
  xsymm3m_iucopyi_KATMAI,  xsymm3m_ilcopyi_KATMAI,
  xsymm3m_oucopyb_KATMAI,  xsymm3m_olcopyb_KATMAI,
  xsymm3m_oucopyr_KATMAI,  xsymm3m_olcopyr_KATMAI,
  xsymm3m_oucopyi_KATMAI,  xsymm3m_olcopyi_KATMAI,

  xhemm3m_iucopyb_KATMAI,  xhemm3m_ilcopyb_KATMAI,
  xhemm3m_iucopyr_KATMAI,  xhemm3m_ilcopyr_KATMAI,
  xhemm3m_iucopyi_KATMAI,  xhemm3m_ilcopyi_KATMAI,

  xhemm3m_oucopyb_KATMAI,  xhemm3m_olcopyb_KATMAI,
  xhemm3m_oucopyr_KATMAI,  xhemm3m_olcopyr_KATMAI,
  xhemm3m_oucopyi_KATMAI,  xhemm3m_olcopyi_KATMAI,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_KATMAI, xlaswp_ncopy_KATMAI,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_KATMAI,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_KATMAI,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_KATMAI,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_KATMAI,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_KATMAI, somatcopy_k_ct_KATMAI, somatcopy_k_rn_KATMAI, somatcopy_k_rt_KATMAI,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_KATMAI, domatcopy_k_ct_KATMAI, domatcopy_k_rn_KATMAI, domatcopy_k_rt_KATMAI,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_KATMAI, comatcopy_k_ct_KATMAI, comatcopy_k_rn_KATMAI, comatcopy_k_rt_KATMAI,
  comatcopy_k_cnc_KATMAI, comatcopy_k_ctc_KATMAI, comatcopy_k_rnc_KATMAI, comatcopy_k_rtc_KATMAI,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_KATMAI, zomatcopy_k_ct_KATMAI, zomatcopy_k_rn_KATMAI, zomatcopy_k_rt_KATMAI,
  zomatcopy_k_cnc_KATMAI, zomatcopy_k_ctc_KATMAI, zomatcopy_k_rnc_KATMAI, zomatcopy_k_rtc_KATMAI,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_KATMAI, simatcopy_k_ct_KATMAI, simatcopy_k_rn_KATMAI, simatcopy_k_rt_KATMAI,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_KATMAI, dimatcopy_k_ct_KATMAI, dimatcopy_k_rn_KATMAI, dimatcopy_k_rt_KATMAI,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_KATMAI, cimatcopy_k_ct_KATMAI, cimatcopy_k_rn_KATMAI, cimatcopy_k_rt_KATMAI,
  cimatcopy_k_cnc_KATMAI, cimatcopy_k_ctc_KATMAI, cimatcopy_k_rnc_KATMAI, cimatcopy_k_rtc_KATMAI,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_KATMAI, zimatcopy_k_ct_KATMAI, zimatcopy_k_rn_KATMAI, zimatcopy_k_rt_KATMAI,
  zimatcopy_k_cnc_KATMAI, zimatcopy_k_ctc_KATMAI, zimatcopy_k_rnc_KATMAI, zimatcopy_k_rtc_KATMAI,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_KATMAI,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_KATMAI,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_KATMAI,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_KATMAI
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
