/* UserCompletion.c generated by valac 0.38.7, the Vala compiler
 * generated from UserCompletion.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "CbUserCounter.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbFilter.h"
#include <sqlite3.h>


#define TYPE_USER_COMPLETION (user_completion_get_type ())
#define USER_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COMPLETION, UserCompletion))
#define USER_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COMPLETION, UserCompletionClass))
#define IS_USER_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COMPLETION))
#define IS_USER_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COMPLETION))
#define USER_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COMPLETION, UserCompletionClass))

typedef struct _UserCompletion UserCompletion;
typedef struct _UserCompletionClass UserCompletionClass;
typedef struct _UserCompletionPrivate UserCompletionPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
enum  {
	USER_COMPLETION_0_PROPERTY,
	USER_COMPLETION_NUM_PROPERTIES
};
static GParamSpec* user_completion_properties[USER_COMPLETION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
enum  {
	USER_COMPLETION_START_COMPLETION_SIGNAL,
	USER_COMPLETION_POPULATE_COMPLETION_SIGNAL,
	USER_COMPLETION_NUM_SIGNALS
};
static guint user_completion_signals[USER_COMPLETION_NUM_SIGNALS] = {0};

struct _UserCompletion {
	GObject parent_instance;
	UserCompletionPrivate * priv;
};

struct _UserCompletionClass {
	GObjectClass parent_class;
};

struct _UserCompletionPrivate {
	GObject* obj;
	Account* account;
	gchar* name_property_name;
	gint num_results;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer user_completion_parent_class = NULL;

GType user_completion_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_COMPLETION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_COMPLETION, UserCompletionPrivate))
UserCompletion* user_completion_new (Account* account, gint num_results);
UserCompletion* user_completion_construct (GType object_type, Account* account, gint num_results);
void user_completion_connect_to (UserCompletion* self, GObject* obj, const gchar* name_property_name);
static void user_completion_prop_changed (UserCompletion* self);
static void _user_completion_prop_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_completion_finalize (GObject * obj);


UserCompletion* user_completion_construct (GType object_type, Account* account, gint num_results) {
	UserCompletion * self = NULL;
	Account* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserCompletion*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = num_results;
	self->priv->num_results = _tmp1_;
	return self;
}


UserCompletion* user_completion_new (Account* account, gint num_results) {
	return user_completion_construct (TYPE_USER_COMPLETION, account, num_results);
}


static void _user_completion_prop_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	user_completion_prop_changed ((UserCompletion*) self);
}


void user_completion_connect_to (UserCompletion* self, GObject* obj, const gchar* name_property_name) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GObject* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (IS_USER_COMPLETION (self));
	g_return_if_fail (G_IS_OBJECT (obj));
	g_return_if_fail (name_property_name != NULL);
	_tmp0_ = obj;
	self->priv->obj = _tmp0_;
	_tmp1_ = name_property_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->name_property_name);
	self->priv->name_property_name = _tmp2_;
	_tmp3_ = obj;
	_tmp4_ = name_property_name;
	_tmp5_ = g_strconcat ("notify::", _tmp4_, NULL);
	g_signal_connect_object (_tmp3_, _tmp5_, (GCallback) _user_completion_prop_changed_g_object_notify, self, 0);
	_g_free0 (_tmp5_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void user_completion_prop_changed (UserCompletion* self) {
	gchar* name = NULL;
	GObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	CbUserInfo* names = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	Account* _tmp6_;
	CbUserCounter* _tmp7_;
	Account* _tmp8_;
	SqlDatabase* _tmp9_;
	sqlite3* _tmp10_;
	const gchar* _tmp11_;
	CbUserInfo* _tmp12_ = NULL;
	gint _tmp13_;
	g_return_if_fail (IS_USER_COMPLETION (self));
	_tmp0_ = self->priv->obj;
	_tmp1_ = self->priv->name_property_name;
	g_object_get (_tmp0_, _tmp1_, &name, NULL);
	_tmp2_ = name;
	_tmp3_ = g_str_has_prefix (_tmp2_, "@");
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = name;
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
		_g_free0 (name);
		name = _tmp5_;
	}
	g_signal_emit (self, user_completion_signals[USER_COMPLETION_START_COMPLETION_SIGNAL], 0);
	_tmp6_ = self->priv->account;
	_tmp7_ = _tmp6_->user_counter;
	_tmp8_ = self->priv->account;
	_tmp9_ = _tmp8_->db;
	_tmp10_ = sql_database_get_sqlite_db (_tmp9_);
	_tmp11_ = name;
	cb_user_counter_query_by_prefix (_tmp7_, _tmp10_, _tmp11_, 10, &_tmp12_, &_tmp13_);
	names = (_vala_CbUserInfo_array_free (names, names_length1), NULL);
	names = _tmp12_;
	names_length1 = _tmp13_;
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				CbUserInfo* _tmp17_;
				gint _tmp17__length1;
				CbUserInfo* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				CbUserInfo _tmp20_;
				const gchar* _tmp21_;
				CbUserInfo* _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				CbUserInfo _tmp24_;
				const gchar* _tmp25_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = names;
				_tmp17__length1 = names_length1;
				if (!(_tmp16_ < _tmp17__length1)) {
					break;
				}
				_tmp18_ = names;
				_tmp18__length1 = names_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = _tmp20_.screen_name;
				_tmp22_ = names;
				_tmp22__length1 = names_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				_tmp25_ = _tmp24_.user_name;
				g_signal_emit (self, user_completion_signals[USER_COMPLETION_POPULATE_COMPLETION_SIGNAL], 0, _tmp21_, _tmp25_);
			}
		}
	}
	names = (_vala_CbUserInfo_array_free (names, names_length1), NULL);
	_g_free0 (name);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void user_completion_class_init (UserCompletionClass * klass) {
	user_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserCompletionPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_completion_finalize;
	user_completion_signals[USER_COMPLETION_START_COMPLETION_SIGNAL] = g_signal_new ("start-completion", TYPE_USER_COMPLETION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	user_completion_signals[USER_COMPLETION_POPULATE_COMPLETION_SIGNAL] = g_signal_new ("populate-completion", TYPE_USER_COMPLETION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void user_completion_instance_init (UserCompletion * self) {
	self->priv = USER_COMPLETION_GET_PRIVATE (self);
}


static void user_completion_finalize (GObject * obj) {
	UserCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_COMPLETION, UserCompletion);
	_g_free0 (self->priv->name_property_name);
	G_OBJECT_CLASS (user_completion_parent_class)->finalize (obj);
}


GType user_completion_get_type (void) {
	static volatile gsize user_completion_type_id__volatile = 0;
	if (g_once_init_enter (&user_completion_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserCompletion), 0, (GInstanceInitFunc) user_completion_instance_init, NULL };
		GType user_completion_type_id;
		user_completion_type_id = g_type_register_static (G_TYPE_OBJECT, "UserCompletion", &g_define_type_info, 0);
		g_once_init_leave (&user_completion_type_id__volatile, user_completion_type_id);
	}
	return user_completion_type_id__volatile;
}



