/* CropWidget.c generated by valac 0.34.6, the Vala compiler
 * generated from CropWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <string.h>


#define TYPE_CROP_WIDGET (crop_widget_get_type ())
#define CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CROP_WIDGET, CropWidget))
#define CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CROP_WIDGET, CropWidgetClass))
#define IS_CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CROP_WIDGET))
#define IS_CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CROP_WIDGET))
#define CROP_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CROP_WIDGET, CropWidgetClass))

typedef struct _CropWidget CropWidget;
typedef struct _CropWidgetClass CropWidgetClass;
typedef struct _CropWidgetPrivate CropWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CropWidget {
	GtkDrawingArea parent_instance;
	CropWidgetPrivate * priv;
};

struct _CropWidgetClass {
	GtkDrawingAreaClass parent_class;
};

struct _CropWidgetPrivate {
	GdkPixbuf* image;
	GdkRectangle selection_rect;
	GdkRectangle image_rect;
	GdkCursor* drag_cursor;
	GdkCursor* default_cursor;
	GdkCursor* resize_cursor;
	gboolean selection_grabbed;
	gboolean resize_area_grabbed;
	gint drag_diff_x;
	gint drag_diff_y;
	gint resize_diff_x;
	gint resize_diff_y;
	gboolean resize_area_hovered;
	gdouble current_scale;
	gint min_width;
	gdouble _desired_aspect_ratio;
};


static gpointer crop_widget_parent_class = NULL;

GType crop_widget_get_type (void) G_GNUC_CONST;
#define CROP_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CROP_WIDGET, CropWidgetPrivate))
enum  {
	CROP_WIDGET_DUMMY_PROPERTY,
	CROP_WIDGET_DESIRED_ASPECT_RATIO
};
#define CROP_WIDGET_MIN_SIZE 48
static gboolean crop_widget_mouse_motion_cb (CropWidget* self, GdkEventMotion* evt);
static void crop_widget_resize_selection_rect (CropWidget* self, gdouble x, gdouble y);
static gboolean crop_widget_over_resize_area (CropWidget* self, gdouble x, gdouble y);
static inline void crop_widget_set_cursor (CropWidget* self, GdkCursor* cursor);
static gboolean crop_widget_cursor_in_selection (CropWidget* self, gdouble x, gdouble y);
static gboolean crop_widget_button_press_cb (CropWidget* self, GdkEventButton* evt);
static gboolean crop_widget_button_release_cb (CropWidget* self, GdkEventButton* evt);
static inline void crop_widget_restrict_selection_size (CropWidget* self);
gdouble crop_widget_get_desired_aspect_ratio (CropWidget* self);
void crop_widget_set_image (CropWidget* self, GdkPixbuf* image);
static void crop_widget_calculate_image_rect (CropWidget* self);
static gboolean crop_widget_real_draw (GtkWidget* base, cairo_t* ct);
static void crop_widget_real_size_allocate (GtkWidget* base, GtkAllocation* alloc);
GdkPixbuf* crop_widget_get_cropped_image (CropWidget* self);
void crop_widget_set_min_size (CropWidget* self, gint min_width);
CropWidget* crop_widget_new (void);
CropWidget* crop_widget_construct (GType object_type);
void crop_widget_set_desired_aspect_ratio (CropWidget* self, gdouble value);
static GObject * crop_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _crop_widget_mouse_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean _crop_widget_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _crop_widget_button_release_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void crop_widget_finalize (GObject* obj);
static void _vala_crop_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_crop_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean crop_widget_mouse_motion_cb (CropWidget* self, GdkEventMotion* evt) {
	gboolean result = FALSE;
	gdouble x = 0.0;
	GdkEventMotion* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble y = 0.0;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	gboolean _tmp57_ = FALSE;
	gdouble _tmp61_ = 0.0;
	gdouble _tmp62_ = 0.0;
	gboolean _tmp63_ = FALSE;
	g_return_val_if_fail (IS_CROP_WIDGET (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->x;
	x = _tmp1_;
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->y;
	y = _tmp3_;
	_tmp4_ = self->priv->resize_area_grabbed;
	if (_tmp4_) {
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp5_ = x;
		_tmp6_ = y;
		crop_widget_resize_selection_rect (self, _tmp5_, _tmp6_);
	}
	_tmp7_ = self->priv->selection_grabbed;
	if (_tmp7_) {
		GdkEventMotion* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		GdkEventMotion* _tmp11_ = NULL;
		gdouble _tmp12_ = 0.0;
		gint _tmp13_ = 0;
		GdkRectangle _tmp14_ = {0};
		gint _tmp15_ = 0;
		GdkRectangle _tmp16_ = {0};
		gint _tmp17_ = 0;
		GdkRectangle _tmp20_ = {0};
		gint _tmp21_ = 0;
		GdkRectangle _tmp22_ = {0};
		gint _tmp23_ = 0;
		GdkRectangle _tmp26_ = {0};
		gint _tmp27_ = 0;
		GdkRectangle _tmp28_ = {0};
		gint _tmp29_ = 0;
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		GdkRectangle _tmp32_ = {0};
		gint _tmp33_ = 0;
		GdkRectangle _tmp40_ = {0};
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		GdkRectangle _tmp44_ = {0};
		gint _tmp45_ = 0;
		GdkRectangle _tmp46_ = {0};
		gint _tmp47_ = 0;
		_tmp8_ = evt;
		_tmp9_ = _tmp8_->x;
		_tmp10_ = self->priv->drag_diff_x;
		self->priv->selection_rect.x = ((gint) _tmp9_) - _tmp10_;
		_tmp11_ = evt;
		_tmp12_ = _tmp11_->y;
		_tmp13_ = self->priv->drag_diff_y;
		self->priv->selection_rect.y = ((gint) _tmp12_) - _tmp13_;
		_tmp14_ = self->priv->selection_rect;
		_tmp15_ = _tmp14_.x;
		_tmp16_ = self->priv->image_rect;
		_tmp17_ = _tmp16_.x;
		if (_tmp15_ < _tmp17_) {
			GdkRectangle _tmp18_ = {0};
			gint _tmp19_ = 0;
			_tmp18_ = self->priv->image_rect;
			_tmp19_ = _tmp18_.x;
			self->priv->selection_rect.x = _tmp19_;
		}
		_tmp20_ = self->priv->selection_rect;
		_tmp21_ = _tmp20_.y;
		_tmp22_ = self->priv->image_rect;
		_tmp23_ = _tmp22_.y;
		if (_tmp21_ < _tmp23_) {
			GdkRectangle _tmp24_ = {0};
			gint _tmp25_ = 0;
			_tmp24_ = self->priv->image_rect;
			_tmp25_ = _tmp24_.y;
			self->priv->selection_rect.y = _tmp25_;
		}
		_tmp26_ = self->priv->selection_rect;
		_tmp27_ = _tmp26_.x;
		_tmp28_ = self->priv->selection_rect;
		_tmp29_ = _tmp28_.width;
		_tmp30_ = self->priv->image_rect;
		_tmp31_ = _tmp30_.x;
		_tmp32_ = self->priv->image_rect;
		_tmp33_ = _tmp32_.width;
		if ((_tmp27_ + _tmp29_) > (_tmp31_ + _tmp33_)) {
			GdkRectangle _tmp34_ = {0};
			gint _tmp35_ = 0;
			GdkRectangle _tmp36_ = {0};
			gint _tmp37_ = 0;
			GdkRectangle _tmp38_ = {0};
			gint _tmp39_ = 0;
			_tmp34_ = self->priv->image_rect;
			_tmp35_ = _tmp34_.x;
			_tmp36_ = self->priv->image_rect;
			_tmp37_ = _tmp36_.width;
			_tmp38_ = self->priv->selection_rect;
			_tmp39_ = _tmp38_.width;
			self->priv->selection_rect.x = (_tmp35_ + _tmp37_) - _tmp39_;
		}
		_tmp40_ = self->priv->selection_rect;
		_tmp41_ = _tmp40_.y;
		_tmp42_ = self->priv->selection_rect;
		_tmp43_ = _tmp42_.height;
		_tmp44_ = self->priv->image_rect;
		_tmp45_ = _tmp44_.y;
		_tmp46_ = self->priv->image_rect;
		_tmp47_ = _tmp46_.height;
		if ((_tmp41_ + _tmp43_) > (_tmp45_ + _tmp47_)) {
			GdkRectangle _tmp48_ = {0};
			gint _tmp49_ = 0;
			GdkRectangle _tmp50_ = {0};
			gint _tmp51_ = 0;
			GdkRectangle _tmp52_ = {0};
			gint _tmp53_ = 0;
			_tmp48_ = self->priv->image_rect;
			_tmp49_ = _tmp48_.y;
			_tmp50_ = self->priv->image_rect;
			_tmp51_ = _tmp50_.height;
			_tmp52_ = self->priv->selection_rect;
			_tmp53_ = _tmp52_.height;
			self->priv->selection_rect.y = (_tmp49_ + _tmp51_) - _tmp53_;
		}
		gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		result = TRUE;
		return result;
	}
	_tmp55_ = x;
	_tmp56_ = y;
	_tmp57_ = crop_widget_over_resize_area (self, _tmp55_, _tmp56_);
	if (_tmp57_) {
		_tmp54_ = TRUE;
	} else {
		gboolean _tmp58_ = FALSE;
		_tmp58_ = self->priv->resize_area_grabbed;
		_tmp54_ = _tmp58_;
	}
	if (_tmp54_) {
		GdkCursor* _tmp59_ = NULL;
		self->priv->resize_area_hovered = TRUE;
		_tmp59_ = self->priv->resize_cursor;
		crop_widget_set_cursor (self, _tmp59_);
		gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		result = TRUE;
		return result;
	} else {
		GdkCursor* _tmp60_ = NULL;
		_tmp60_ = self->priv->default_cursor;
		crop_widget_set_cursor (self, _tmp60_);
		self->priv->resize_area_hovered = FALSE;
		gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	_tmp61_ = x;
	_tmp62_ = y;
	_tmp63_ = crop_widget_cursor_in_selection (self, _tmp61_, _tmp62_);
	if (_tmp63_) {
		GdkCursor* _tmp64_ = NULL;
		_tmp64_ = self->priv->drag_cursor;
		crop_widget_set_cursor (self, _tmp64_);
	} else {
		GdkCursor* _tmp65_ = NULL;
		_tmp65_ = self->priv->default_cursor;
		crop_widget_set_cursor (self, _tmp65_);
	}
	result = FALSE;
	return result;
}


static gboolean crop_widget_button_press_cb (CropWidget* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventButton* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
	GdkEventButton* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	GdkEventButton* _tmp21_ = NULL;
	gdouble _tmp22_ = 0.0;
	gboolean _tmp23_ = FALSE;
	g_return_val_if_fail (IS_CROP_WIDGET (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) GDK_BUTTON_PRIMARY)) {
		self->priv->selection_grabbed = FALSE;
		self->priv->resize_area_grabbed = FALSE;
		result = FALSE;
		return result;
	}
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->x;
	_tmp4_ = evt;
	_tmp5_ = _tmp4_->y;
	_tmp6_ = crop_widget_over_resize_area (self, _tmp3_, _tmp5_);
	if (_tmp6_) {
		GdkEventButton* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		GdkEventButton* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		self->priv->resize_area_grabbed = TRUE;
		_tmp7_ = evt;
		_tmp8_ = _tmp7_->x;
		_tmp9_ = self->priv->selection_rect;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = self->priv->selection_rect;
		_tmp12_ = _tmp11_.width;
		self->priv->resize_diff_x = ((gint) _tmp8_) - (_tmp10_ + _tmp12_);
		_tmp13_ = evt;
		_tmp14_ = _tmp13_->y;
		_tmp15_ = self->priv->selection_rect;
		_tmp16_ = _tmp15_.y;
		_tmp17_ = self->priv->selection_rect;
		_tmp18_ = _tmp17_.height;
		self->priv->resize_diff_y = ((gint) _tmp14_) - (_tmp16_ + _tmp18_);
		result = TRUE;
		return result;
	}
	_tmp19_ = evt;
	_tmp20_ = _tmp19_->x;
	_tmp21_ = evt;
	_tmp22_ = _tmp21_->y;
	_tmp23_ = crop_widget_cursor_in_selection (self, _tmp20_, _tmp22_);
	if (_tmp23_) {
		GdkEventButton* _tmp24_ = NULL;
		gdouble _tmp25_ = 0.0;
		GdkRectangle _tmp26_ = {0};
		gint _tmp27_ = 0;
		GdkEventButton* _tmp28_ = NULL;
		gdouble _tmp29_ = 0.0;
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		self->priv->selection_grabbed = TRUE;
		_tmp24_ = evt;
		_tmp25_ = _tmp24_->x;
		_tmp26_ = self->priv->selection_rect;
		_tmp27_ = _tmp26_.x;
		self->priv->drag_diff_x = (gint) (_tmp25_ - _tmp27_);
		_tmp28_ = evt;
		_tmp29_ = _tmp28_->y;
		_tmp30_ = self->priv->selection_rect;
		_tmp31_ = _tmp30_.y;
		self->priv->drag_diff_y = (gint) (_tmp29_ - _tmp31_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean crop_widget_button_release_cb (CropWidget* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_CROP_WIDGET (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = self->priv->selection_grabbed;
	if (_tmp0_) {
		GdkCursor* _tmp1_ = NULL;
		self->priv->selection_grabbed = FALSE;
		_tmp1_ = self->priv->default_cursor;
		crop_widget_set_cursor (self, _tmp1_);
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->resize_area_grabbed;
	if (_tmp2_) {
		GdkCursor* _tmp3_ = NULL;
		self->priv->resize_area_grabbed = FALSE;
		_tmp3_ = self->priv->default_cursor;
		crop_widget_set_cursor (self, _tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static inline void crop_widget_restrict_selection_size (CropWidget* self) {
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	GdkRectangle _tmp21_ = {0};
	gint _tmp22_ = 0;
	GdkRectangle _tmp23_ = {0};
	gint _tmp24_ = 0;
	GdkRectangle _tmp27_ = {0};
	gint _tmp28_ = 0;
	GdkRectangle _tmp29_ = {0};
	gint _tmp30_ = 0;
	GdkRectangle _tmp33_ = {0};
	gint _tmp34_ = 0;
	GdkRectangle _tmp35_ = {0};
	gint _tmp36_ = 0;
	GdkRectangle _tmp37_ = {0};
	gint _tmp38_ = 0;
	GdkRectangle _tmp39_ = {0};
	gint _tmp40_ = 0;
	GdkRectangle _tmp47_ = {0};
	gint _tmp48_ = 0;
	GdkRectangle _tmp49_ = {0};
	gint _tmp50_ = 0;
	GdkRectangle _tmp51_ = {0};
	gint _tmp52_ = 0;
	GdkRectangle _tmp53_ = {0};
	gint _tmp54_ = 0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	_tmp0_ = self->priv->selection_rect;
	_tmp1_ = _tmp0_.width;
	_tmp2_ = self->priv->image_rect;
	_tmp3_ = _tmp2_.width;
	if (_tmp1_ > _tmp3_) {
		GdkRectangle _tmp4_ = {0};
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->image_rect;
		_tmp5_ = _tmp4_.width;
		self->priv->selection_rect.width = _tmp5_;
	}
	_tmp6_ = self->priv->selection_rect;
	_tmp7_ = _tmp6_.height;
	_tmp8_ = self->priv->image_rect;
	_tmp9_ = _tmp8_.height;
	if (_tmp7_ > _tmp9_) {
		GdkRectangle _tmp10_ = {0};
		gint _tmp11_ = 0;
		_tmp10_ = self->priv->image_rect;
		_tmp11_ = _tmp10_.height;
		self->priv->selection_rect.height = _tmp11_;
	}
	_tmp12_ = self->priv->selection_rect;
	_tmp13_ = _tmp12_.width;
	_tmp14_ = self->priv->min_width;
	_tmp15_ = self->priv->current_scale;
	if (((gdouble) _tmp13_) < (_tmp14_ * _tmp15_)) {
		gint _tmp16_ = 0;
		gdouble _tmp17_ = 0.0;
		gint _tmp18_ = 0;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		_tmp16_ = self->priv->min_width;
		_tmp17_ = self->priv->current_scale;
		self->priv->selection_rect.width = (gint) (_tmp16_ * _tmp17_);
		_tmp18_ = self->priv->min_width;
		_tmp19_ = self->priv->current_scale;
		_tmp20_ = self->priv->_desired_aspect_ratio;
		self->priv->selection_rect.height = (gint) ((_tmp18_ * _tmp19_) / _tmp20_);
	}
	_tmp21_ = self->priv->selection_rect;
	_tmp22_ = _tmp21_.x;
	_tmp23_ = self->priv->image_rect;
	_tmp24_ = _tmp23_.x;
	if (_tmp22_ < _tmp24_) {
		GdkRectangle _tmp25_ = {0};
		gint _tmp26_ = 0;
		_tmp25_ = self->priv->image_rect;
		_tmp26_ = _tmp25_.x;
		self->priv->selection_rect.x = _tmp26_;
	}
	_tmp27_ = self->priv->selection_rect;
	_tmp28_ = _tmp27_.y;
	_tmp29_ = self->priv->image_rect;
	_tmp30_ = _tmp29_.y;
	if (_tmp28_ < _tmp30_) {
		GdkRectangle _tmp31_ = {0};
		gint _tmp32_ = 0;
		_tmp31_ = self->priv->image_rect;
		_tmp32_ = _tmp31_.y;
		self->priv->selection_rect.y = _tmp32_;
	}
	_tmp33_ = self->priv->selection_rect;
	_tmp34_ = _tmp33_.x;
	_tmp35_ = self->priv->selection_rect;
	_tmp36_ = _tmp35_.width;
	_tmp37_ = self->priv->image_rect;
	_tmp38_ = _tmp37_.x;
	_tmp39_ = self->priv->image_rect;
	_tmp40_ = _tmp39_.width;
	if ((_tmp34_ + _tmp36_) > (_tmp38_ + _tmp40_)) {
		GdkRectangle _tmp41_ = {0};
		gint _tmp42_ = 0;
		GdkRectangle _tmp43_ = {0};
		gint _tmp44_ = 0;
		GdkRectangle _tmp45_ = {0};
		gint _tmp46_ = 0;
		_tmp41_ = self->priv->image_rect;
		_tmp42_ = _tmp41_.x;
		_tmp43_ = self->priv->image_rect;
		_tmp44_ = _tmp43_.width;
		_tmp45_ = self->priv->selection_rect;
		_tmp46_ = _tmp45_.width;
		self->priv->selection_rect.x = (_tmp42_ + _tmp44_) - _tmp46_;
	}
	_tmp47_ = self->priv->selection_rect;
	_tmp48_ = _tmp47_.y;
	_tmp49_ = self->priv->selection_rect;
	_tmp50_ = _tmp49_.height;
	_tmp51_ = self->priv->image_rect;
	_tmp52_ = _tmp51_.y;
	_tmp53_ = self->priv->image_rect;
	_tmp54_ = _tmp53_.height;
	if ((_tmp48_ + _tmp50_) > (_tmp52_ + _tmp54_)) {
		GdkRectangle _tmp55_ = {0};
		gint _tmp56_ = 0;
		GdkRectangle _tmp57_ = {0};
		gint _tmp58_ = 0;
		GdkRectangle _tmp59_ = {0};
		gint _tmp60_ = 0;
		_tmp55_ = self->priv->image_rect;
		_tmp56_ = _tmp55_.y;
		_tmp57_ = self->priv->image_rect;
		_tmp58_ = _tmp57_.height;
		_tmp59_ = self->priv->selection_rect;
		_tmp60_ = _tmp59_.height;
		self->priv->selection_rect.y = (_tmp56_ + _tmp58_) - _tmp60_;
	}
}


static void crop_widget_resize_selection_rect (CropWidget* self, gdouble x, gdouble y) {
	gboolean _tmp0_ = FALSE;
	gint max_width = 0;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint new_width = 0;
	gdouble _tmp10_ = 0.0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint new_height = 0;
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	_tmp0_ = self->priv->resize_area_grabbed;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->image_rect;
	_tmp2_ = _tmp1_.width;
	_tmp3_ = self->priv->image_rect;
	_tmp4_ = _tmp3_.width;
	_tmp5_ = self->priv->image_rect;
	_tmp6_ = _tmp5_.height;
	_tmp7_ = self->priv->_desired_aspect_ratio;
	_tmp8_ = MIN ((gint) _tmp4_, (gint) (_tmp6_ * _tmp7_));
	_tmp9_ = MIN (_tmp2_, _tmp8_);
	max_width = _tmp9_;
	_tmp10_ = x;
	_tmp11_ = self->priv->selection_rect;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = self->priv->resize_diff_x;
	new_width = (((gint) _tmp10_) - _tmp12_) - _tmp13_;
	_tmp14_ = new_width;
	_tmp15_ = self->priv->_desired_aspect_ratio;
	new_height = (gint) (_tmp14_ / _tmp15_);
	_tmp16_ = new_width;
	_tmp17_ = max_width;
	if (_tmp16_ <= _tmp17_) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp18_ = new_width;
		self->priv->selection_rect.width = _tmp18_;
		_tmp19_ = new_height;
		self->priv->selection_rect.height = _tmp19_;
	} else {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gdouble _tmp22_ = 0.0;
		_tmp20_ = max_width;
		self->priv->selection_rect.width = _tmp20_;
		_tmp21_ = max_width;
		_tmp22_ = self->priv->_desired_aspect_ratio;
		self->priv->selection_rect.height = (gint) (_tmp21_ / _tmp22_);
	}
	crop_widget_restrict_selection_size (self);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void crop_widget_set_image (CropWidget* self, GdkPixbuf* image) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	GdkRectangle _tmp7_ = {0};
	gint _tmp8_ = 0;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	GdkRectangle _tmp16_ = {0};
	gint _tmp17_ = 0;
	GdkRectangle _tmp18_ = {0};
	gint _tmp19_ = 0;
	GdkRectangle _tmp20_ = {0};
	gint _tmp21_ = 0;
	GdkRectangle _tmp22_ = {0};
	gint _tmp23_ = 0;
	GdkRectangle _tmp24_ = {0};
	gint _tmp25_ = 0;
	GdkRectangle _tmp26_ = {0};
	gint _tmp27_ = 0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	g_return_if_fail ((image == NULL) || GDK_IS_PIXBUF (image));
	_tmp0_ = image;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp1_;
	crop_widget_calculate_image_rect (self);
	_tmp2_ = self->priv->image_rect;
	_tmp3_ = _tmp2_.width;
	self->priv->selection_rect.width = _tmp3_;
	_tmp4_ = self->priv->selection_rect;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = self->priv->_desired_aspect_ratio;
	self->priv->selection_rect.height = (gint) (_tmp5_ / _tmp6_);
	_tmp7_ = self->priv->selection_rect;
	_tmp8_ = _tmp7_.height;
	_tmp9_ = self->priv->image_rect;
	_tmp10_ = _tmp9_.height;
	if (_tmp8_ > _tmp10_) {
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		GdkRectangle _tmp13_ = {0};
		gint _tmp14_ = 0;
		gdouble _tmp15_ = 0.0;
		_tmp11_ = self->priv->image_rect;
		_tmp12_ = _tmp11_.height;
		self->priv->selection_rect.height = _tmp12_;
		_tmp13_ = self->priv->selection_rect;
		_tmp14_ = _tmp13_.height;
		_tmp15_ = self->priv->_desired_aspect_ratio;
		self->priv->selection_rect.width = (gint) (_tmp14_ * _tmp15_);
	}
	_tmp16_ = self->priv->image_rect;
	_tmp17_ = _tmp16_.x;
	_tmp18_ = self->priv->image_rect;
	_tmp19_ = _tmp18_.width;
	_tmp20_ = self->priv->selection_rect;
	_tmp21_ = _tmp20_.width;
	self->priv->selection_rect.x = _tmp17_ + ((_tmp19_ - _tmp21_) / 2);
	_tmp22_ = self->priv->image_rect;
	_tmp23_ = _tmp22_.y;
	_tmp24_ = self->priv->image_rect;
	_tmp25_ = _tmp24_.height;
	_tmp26_ = self->priv->selection_rect;
	_tmp27_ = _tmp26_.height;
	self->priv->selection_rect.y = _tmp23_ + ((_tmp25_ - _tmp27_) / 2);
	crop_widget_restrict_selection_size (self);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static gboolean crop_widget_real_draw (GtkWidget* base, cairo_t* ct) {
	CropWidget * self;
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
	gint widget_width = 0;
	gint _tmp1_ = 0;
	gint widget_height = 0;
	gint _tmp2_ = 0;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkRectangle _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_t* _tmp22_ = NULL;
	GdkPixbuf* _tmp23_ = NULL;
	GdkRectangle _tmp24_ = {0};
	gint _tmp25_ = 0;
	gdouble _tmp26_ = 0.0;
	GdkRectangle _tmp27_ = {0};
	gint _tmp28_ = 0;
	gdouble _tmp29_ = 0.0;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	GdkRectangle _tmp33_ = {0};
	gint _tmp34_ = 0;
	GdkRectangle _tmp35_ = {0};
	gint _tmp36_ = 0;
	GdkRectangle _tmp37_ = {0};
	gint _tmp38_ = 0;
	GdkRectangle _tmp39_ = {0};
	gint _tmp40_ = 0;
	cairo_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	GdkRectangle _tmp44_ = {0};
	gint _tmp45_ = 0;
	GdkRectangle _tmp46_ = {0};
	gint _tmp47_ = 0;
	GdkRectangle _tmp48_ = {0};
	gint _tmp49_ = 0;
	GdkRectangle _tmp50_ = {0};
	gint _tmp51_ = 0;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	cairo_t* _tmp57_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CROP_WIDGET, CropWidget);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = self->priv->image;
	if (_tmp0_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp1_;
	_tmp2_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp2_;
	_tmp3_ = ct;
	cairo_set_line_width (_tmp3_, 1.0);
	_tmp4_ = ct;
	_tmp5_ = widget_width;
	_tmp6_ = widget_height;
	cairo_rectangle (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp6_);
	_tmp7_ = ct;
	cairo_set_source_rgba (_tmp7_, 0.3, 0.3, 0.3, 1.0);
	_tmp8_ = ct;
	cairo_fill (_tmp8_);
	_tmp9_ = ct;
	cairo_save (_tmp9_);
	_tmp10_ = ct;
	_tmp11_ = self->priv->image_rect;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = self->priv->image_rect;
	_tmp14_ = _tmp13_.y;
	_tmp15_ = self->priv->image_rect;
	_tmp16_ = _tmp15_.width;
	_tmp17_ = self->priv->image_rect;
	_tmp18_ = _tmp17_.height;
	cairo_rectangle (_tmp10_, (gdouble) _tmp12_, (gdouble) _tmp14_, (gdouble) _tmp16_, (gdouble) _tmp18_);
	_tmp19_ = ct;
	_tmp20_ = self->priv->current_scale;
	_tmp21_ = self->priv->current_scale;
	cairo_scale (_tmp19_, _tmp20_, _tmp21_);
	_tmp22_ = ct;
	_tmp23_ = self->priv->image;
	_tmp24_ = self->priv->image_rect;
	_tmp25_ = _tmp24_.x;
	_tmp26_ = self->priv->current_scale;
	_tmp27_ = self->priv->image_rect;
	_tmp28_ = _tmp27_.y;
	_tmp29_ = self->priv->current_scale;
	gdk_cairo_set_source_pixbuf (_tmp22_, _tmp23_, _tmp25_ / _tmp26_, _tmp28_ / _tmp29_);
	_tmp30_ = ct;
	cairo_fill (_tmp30_);
	_tmp31_ = ct;
	cairo_restore (_tmp31_);
	_tmp32_ = ct;
	_tmp33_ = self->priv->selection_rect;
	_tmp34_ = _tmp33_.x;
	_tmp35_ = self->priv->selection_rect;
	_tmp36_ = _tmp35_.y;
	_tmp37_ = self->priv->selection_rect;
	_tmp38_ = _tmp37_.width;
	_tmp39_ = self->priv->selection_rect;
	_tmp40_ = _tmp39_.height;
	cairo_rectangle (_tmp32_, (gdouble) _tmp34_, (gdouble) _tmp36_, (gdouble) _tmp38_, (gdouble) _tmp40_);
	_tmp41_ = ct;
	cairo_set_source_rgba (_tmp41_, 1.0, 1.0, 1.0, 1.0);
	_tmp42_ = ct;
	cairo_stroke (_tmp42_);
	_tmp43_ = ct;
	_tmp44_ = self->priv->selection_rect;
	_tmp45_ = _tmp44_.x;
	_tmp46_ = self->priv->selection_rect;
	_tmp47_ = _tmp46_.width;
	_tmp48_ = self->priv->selection_rect;
	_tmp49_ = _tmp48_.y;
	_tmp50_ = self->priv->selection_rect;
	_tmp51_ = _tmp50_.height;
	cairo_rectangle (_tmp43_, (gdouble) ((_tmp45_ + _tmp47_) - 15), (gdouble) ((_tmp49_ + _tmp51_) - 15), 14.5, 14.5);
	_tmp53_ = self->priv->resize_area_hovered;
	if (_tmp53_) {
		_tmp52_ = TRUE;
	} else {
		gboolean _tmp54_ = FALSE;
		_tmp54_ = self->priv->resize_area_grabbed;
		_tmp52_ = _tmp54_;
	}
	if (_tmp52_) {
		cairo_t* _tmp55_ = NULL;
		_tmp55_ = ct;
		cairo_set_source_rgba (_tmp55_, 0.0, 0.0, 0.6, 0.7);
	} else {
		cairo_t* _tmp56_ = NULL;
		_tmp56_ = ct;
		cairo_set_source_rgba (_tmp56_, 1.0, 1.0, 1.0, 0.7);
	}
	_tmp57_ = ct;
	cairo_fill (_tmp57_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static inline void crop_widget_set_cursor (CropWidget* self, GdkCursor* cursor) {
	GdkWindow* _tmp0_ = NULL;
	GdkCursor* _tmp1_ = NULL;
	g_return_if_fail (IS_CROP_WIDGET (self));
	g_return_if_fail (GDK_IS_CURSOR (cursor));
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = cursor;
	gdk_window_set_cursor (_tmp0_, _tmp1_);
}


static gboolean crop_widget_cursor_in_selection (CropWidget* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_ = 0.0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	g_return_val_if_fail (IS_CROP_WIDGET (self), FALSE);
	_tmp3_ = x;
	_tmp4_ = self->priv->selection_rect;
	_tmp5_ = _tmp4_.x;
	if (_tmp3_ >= ((gdouble) _tmp5_)) {
		gdouble _tmp6_ = 0.0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		_tmp6_ = x;
		_tmp7_ = self->priv->selection_rect;
		_tmp8_ = _tmp7_.x;
		_tmp9_ = self->priv->selection_rect;
		_tmp10_ = _tmp9_.width;
		_tmp2_ = _tmp6_ <= ((gdouble) (_tmp8_ + _tmp10_));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gdouble _tmp11_ = 0.0;
		GdkRectangle _tmp12_ = {0};
		gint _tmp13_ = 0;
		_tmp11_ = y;
		_tmp12_ = self->priv->selection_rect;
		_tmp13_ = _tmp12_.y;
		_tmp1_ = _tmp11_ >= ((gdouble) _tmp13_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gdouble _tmp14_ = 0.0;
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		_tmp14_ = y;
		_tmp15_ = self->priv->selection_rect;
		_tmp16_ = _tmp15_.y;
		_tmp17_ = self->priv->selection_rect;
		_tmp18_ = _tmp17_.height;
		_tmp0_ = _tmp14_ <= ((gdouble) (_tmp16_ + _tmp18_));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void crop_widget_real_size_allocate (GtkWidget* base, GtkAllocation* alloc) {
	CropWidget * self;
	GtkAllocation _tmp0_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CROP_WIDGET, CropWidget);
	g_return_if_fail (alloc != NULL);
	_tmp0_ = *alloc;
	GTK_WIDGET_CLASS (crop_widget_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	crop_widget_calculate_image_rect (self);
	crop_widget_restrict_selection_size (self);
}


static void crop_widget_calculate_image_rect (CropWidget* self) {
	gint widget_width = 0;
	gint _tmp0_ = 0;
	gint widget_height = 0;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GdkPixbuf* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GdkPixbuf* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	GdkPixbuf* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gdouble _tmp22_ = 0.0;
	gint _tmp23_ = 0;
	gdouble _tmp27_ = 0.0;
	GdkPixbuf* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gdouble _tmp30_ = 0.0;
	GdkPixbuf* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gdouble _tmp33_ = 0.0;
	gint _tmp34_ = 0;
	GdkRectangle _tmp35_ = {0};
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	GdkRectangle _tmp38_ = {0};
	gint _tmp39_ = 0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp1_;
	_tmp2_ = self->priv->image;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->image;
	_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
	_tmp5_ = self->priv->image;
	_tmp6_ = gdk_pixbuf_get_height (_tmp5_);
	if (_tmp4_ > _tmp6_) {
		gint _tmp7_ = 0;
		GdkPixbuf* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp7_ = widget_width;
		_tmp8_ = self->priv->image;
		_tmp9_ = gdk_pixbuf_get_width (_tmp8_);
		self->priv->current_scale = ((gdouble) _tmp7_) / _tmp9_;
	} else {
		gint _tmp10_ = 0;
		GdkPixbuf* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp10_ = widget_height;
		_tmp11_ = self->priv->image;
		_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
		self->priv->current_scale = ((gdouble) _tmp10_) / _tmp12_;
	}
	_tmp13_ = self->priv->image;
	_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
	_tmp15_ = self->priv->current_scale;
	_tmp16_ = widget_width;
	if ((_tmp14_ * _tmp15_) > ((gdouble) _tmp16_)) {
		gint _tmp17_ = 0;
		GdkPixbuf* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp17_ = widget_width;
		_tmp18_ = self->priv->image;
		_tmp19_ = gdk_pixbuf_get_width (_tmp18_);
		self->priv->current_scale = ((gdouble) _tmp17_) / _tmp19_;
	}
	_tmp20_ = self->priv->image;
	_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
	_tmp22_ = self->priv->current_scale;
	_tmp23_ = widget_height;
	if ((_tmp21_ * _tmp22_) > ((gdouble) _tmp23_)) {
		gint _tmp24_ = 0;
		GdkPixbuf* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		_tmp24_ = widget_height;
		_tmp25_ = self->priv->image;
		_tmp26_ = gdk_pixbuf_get_height (_tmp25_);
		self->priv->current_scale = ((gdouble) _tmp24_) / _tmp26_;
	}
	_tmp27_ = self->priv->current_scale;
	if (_tmp27_ > 1.0) {
		self->priv->current_scale = 1.0;
	}
	_tmp28_ = self->priv->image;
	_tmp29_ = gdk_pixbuf_get_width (_tmp28_);
	_tmp30_ = self->priv->current_scale;
	self->priv->image_rect.width = (gint) (_tmp29_ * _tmp30_);
	_tmp31_ = self->priv->image;
	_tmp32_ = gdk_pixbuf_get_height (_tmp31_);
	_tmp33_ = self->priv->current_scale;
	self->priv->image_rect.height = (gint) (_tmp32_ * _tmp33_);
	_tmp34_ = widget_width;
	_tmp35_ = self->priv->image_rect;
	_tmp36_ = _tmp35_.width;
	self->priv->image_rect.x = (_tmp34_ - _tmp36_) / 2;
	_tmp37_ = widget_height;
	_tmp38_ = self->priv->image_rect;
	_tmp39_ = _tmp38_.height;
	self->priv->image_rect.y = (_tmp37_ - _tmp39_) / 2;
}


static gboolean crop_widget_over_resize_area (CropWidget* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_ = 0.0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	g_return_val_if_fail (IS_CROP_WIDGET (self), FALSE);
	_tmp3_ = x;
	_tmp4_ = self->priv->selection_rect;
	_tmp5_ = _tmp4_.x;
	_tmp6_ = self->priv->selection_rect;
	_tmp7_ = _tmp6_.width;
	if (_tmp3_ > ((gdouble) ((_tmp5_ + _tmp7_) - 15))) {
		gdouble _tmp8_ = 0.0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		_tmp8_ = x;
		_tmp9_ = self->priv->selection_rect;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = self->priv->selection_rect;
		_tmp12_ = _tmp11_.width;
		_tmp2_ = _tmp8_ < ((gdouble) ((_tmp10_ + _tmp12_) + 5));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gdouble _tmp13_ = 0.0;
		GdkRectangle _tmp14_ = {0};
		gint _tmp15_ = 0;
		GdkRectangle _tmp16_ = {0};
		gint _tmp17_ = 0;
		_tmp13_ = y;
		_tmp14_ = self->priv->selection_rect;
		_tmp15_ = _tmp14_.y;
		_tmp16_ = self->priv->selection_rect;
		_tmp17_ = _tmp16_.height;
		_tmp1_ = _tmp13_ > ((gdouble) ((_tmp15_ + _tmp17_) - 15));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gdouble _tmp18_ = 0.0;
		GdkRectangle _tmp19_ = {0};
		gint _tmp20_ = 0;
		GdkRectangle _tmp21_ = {0};
		gint _tmp22_ = 0;
		_tmp18_ = y;
		_tmp19_ = self->priv->selection_rect;
		_tmp20_ = _tmp19_.y;
		_tmp21_ = self->priv->selection_rect;
		_tmp22_ = _tmp21_.height;
		_tmp0_ = _tmp18_ < ((gdouble) ((_tmp20_ + _tmp22_) + 5));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


GdkPixbuf* crop_widget_get_cropped_image (CropWidget* self) {
	GdkPixbuf* result = NULL;
	gint absolute_x = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gint absolute_y = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkRectangle _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gint absolute_w = 0;
	GdkRectangle _tmp10_ = {0};
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gint absolute_h = 0;
	GdkRectangle _tmp13_ = {0};
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	GdkPixbuf* final_image = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	GdkPixbuf* _tmp18_ = NULL;
	GdkPixbuf* _tmp19_ = NULL;
	g_return_val_if_fail (IS_CROP_WIDGET (self), NULL);
	_tmp0_ = self->priv->selection_rect;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = self->priv->image_rect;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = self->priv->current_scale;
	absolute_x = (gint) ((_tmp1_ - _tmp3_) / _tmp4_);
	_tmp5_ = self->priv->selection_rect;
	_tmp6_ = _tmp5_.y;
	_tmp7_ = self->priv->image_rect;
	_tmp8_ = _tmp7_.y;
	_tmp9_ = self->priv->current_scale;
	absolute_y = (gint) ((_tmp6_ - _tmp8_) / _tmp9_);
	_tmp10_ = self->priv->selection_rect;
	_tmp11_ = _tmp10_.width;
	_tmp12_ = self->priv->current_scale;
	absolute_w = (gint) (_tmp11_ / _tmp12_);
	_tmp13_ = self->priv->selection_rect;
	_tmp14_ = _tmp13_.height;
	_tmp15_ = self->priv->current_scale;
	absolute_h = (gint) (_tmp14_ / _tmp15_);
	_tmp16_ = self->priv->image;
	_tmp17_ = gdk_pixbuf_get_has_alpha (_tmp16_);
	_tmp18_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, _tmp17_, 8, absolute_w, absolute_h);
	final_image = _tmp18_;
	_tmp19_ = self->priv->image;
	gdk_pixbuf_copy_area (_tmp19_, absolute_x, absolute_y, absolute_w, absolute_h, final_image, 0, 0);
	result = final_image;
	return result;
}


void crop_widget_set_min_size (CropWidget* self, gint min_width) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	_tmp0_ = min_width;
	self->priv->min_width = _tmp0_;
}


CropWidget* crop_widget_construct (GType object_type) {
	CropWidget * self = NULL;
	self = (CropWidget*) g_object_new (object_type, NULL);
	return self;
}


CropWidget* crop_widget_new (void) {
	return crop_widget_construct (TYPE_CROP_WIDGET);
}


gdouble crop_widget_get_desired_aspect_ratio (CropWidget* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_CROP_WIDGET (self), 0.0);
	_tmp0_ = self->priv->_desired_aspect_ratio;
	result = _tmp0_;
	return result;
}


void crop_widget_set_desired_aspect_ratio (CropWidget* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (IS_CROP_WIDGET (self));
	_tmp0_ = value;
	self->priv->_desired_aspect_ratio = _tmp0_;
	g_object_notify ((GObject *) self, "desired-aspect-ratio");
}


static gboolean _crop_widget_mouse_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = crop_widget_mouse_motion_cb ((CropWidget*) self, event);
	return result;
}


static gboolean _crop_widget_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = crop_widget_button_press_cb ((CropWidget*) self, event);
	return result;
}


static gboolean _crop_widget_button_release_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = crop_widget_button_release_cb ((CropWidget*) self, event);
	return result;
}


static GObject * crop_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CropWidget * self;
	gint _tmp0_ = 0;
	GdkDisplay* _tmp1_ = NULL;
	GdkCursor* _tmp2_ = NULL;
	GdkDisplay* _tmp3_ = NULL;
	GdkCursor* _tmp4_ = NULL;
	GdkDisplay* _tmp5_ = NULL;
	GdkCursor* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (crop_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CROP_WIDGET, CropWidget);
	_tmp0_ = gtk_widget_get_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_widget_set_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (((_tmp0_ | GDK_POINTER_MOTION_MASK) | GDK_BUTTON1_MOTION_MASK) | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "motion-notify-event", (GCallback) _crop_widget_mouse_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _crop_widget_button_press_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-release-event", (GCallback) _crop_widget_button_release_cb_gtk_widget_button_release_event, self, 0);
	_tmp1_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, GDK_FLEUR);
	_g_object_unref0 (self->priv->drag_cursor);
	self->priv->drag_cursor = _tmp2_;
	_tmp3_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = gdk_cursor_new_for_display (_tmp3_, GDK_ARROW);
	_g_object_unref0 (self->priv->default_cursor);
	self->priv->default_cursor = _tmp4_;
	_tmp5_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = gdk_cursor_new_for_display (_tmp5_, GDK_BOTTOM_RIGHT_CORNER);
	_g_object_unref0 (self->priv->resize_cursor);
	self->priv->resize_cursor = _tmp6_;
	memset (&self->priv->image_rect, 0, sizeof (GdkRectangle));
	memset (&self->priv->selection_rect, 0, sizeof (GdkRectangle));
	return obj;
}


static void crop_widget_class_init (CropWidgetClass * klass) {
	crop_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CropWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*)(GtkWidget*, cairo_t*)) crop_widget_real_draw;
	((GtkWidgetClass *) klass)->size_allocate = (void (*)(GtkWidget*, GtkAllocation*)) crop_widget_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_crop_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_crop_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = crop_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = crop_widget_finalize;
	/**
	   * Ratio of the width to the height, i.e. (width/height)
	   * => values >1.0 for landscape pictures
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CROP_WIDGET_DESIRED_ASPECT_RATIO, g_param_spec_double ("desired-aspect-ratio", "desired-aspect-ratio", "desired-aspect-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void crop_widget_instance_init (CropWidget * self) {
	self->priv = CROP_WIDGET_GET_PRIVATE (self);
	self->priv->selection_grabbed = FALSE;
	self->priv->resize_area_grabbed = FALSE;
	self->priv->drag_diff_x = 0;
	self->priv->drag_diff_y = 0;
	self->priv->resize_diff_x = 0;
	self->priv->resize_diff_y = 0;
	self->priv->resize_area_hovered = FALSE;
	self->priv->current_scale = 1.0;
	self->priv->min_width = CROP_WIDGET_MIN_SIZE;
	self->priv->_desired_aspect_ratio = 0.8;
}


static void crop_widget_finalize (GObject* obj) {
	CropWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CROP_WIDGET, CropWidget);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->drag_cursor);
	_g_object_unref0 (self->priv->default_cursor);
	_g_object_unref0 (self->priv->resize_cursor);
	G_OBJECT_CLASS (crop_widget_parent_class)->finalize (obj);
}


GType crop_widget_get_type (void) {
	static volatile gsize crop_widget_type_id__volatile = 0;
	if (g_once_init_enter (&crop_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CropWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crop_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CropWidget), 0, (GInstanceInitFunc) crop_widget_instance_init, NULL };
		GType crop_widget_type_id;
		crop_widget_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CropWidget", &g_define_type_info, 0);
		g_once_init_leave (&crop_widget_type_id__volatile, crop_widget_type_id);
	}
	return crop_widget_type_id__volatile;
}


static void _vala_crop_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CropWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CROP_WIDGET, CropWidget);
	switch (property_id) {
		case CROP_WIDGET_DESIRED_ASPECT_RATIO:
		g_value_set_double (value, crop_widget_get_desired_aspect_ratio (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_crop_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CropWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CROP_WIDGET, CropWidget);
	switch (property_id) {
		case CROP_WIDGET_DESIRED_ASPECT_RATIO:
		crop_widget_set_desired_aspect_ratio (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



