/* ProfilePage.c generated by valac 0.34.6, the Vala compiler
 * generated from ProfilePage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "CbTypes.h"
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "CbTextTransform.h"


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_PROFILE_PAGE (profile_page_get_type ())
#define PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_PAGE, ProfilePage))
#define PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_PAGE, ProfilePageClass))
#define IS_PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_PAGE))
#define IS_PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_PAGE))
#define PROFILE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_PAGE, ProfilePageClass))

typedef struct _ProfilePage ProfilePage;
typedef struct _ProfilePageClass ProfilePageClass;
typedef struct _ProfilePagePrivate ProfilePagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ASPECT_IMAGE (aspect_image_get_type ())
#define ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASPECT_IMAGE, AspectImage))
#define ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASPECT_IMAGE, AspectImageClass))
#define IS_ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASPECT_IMAGE))
#define IS_ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASPECT_IMAGE))
#define ASPECT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASPECT_IMAGE, AspectImageClass))

typedef struct _AspectImage AspectImage;
typedef struct _AspectImageClass AspectImageClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_FOLLOW_BUTTON (follow_button_get_type ())
#define FOLLOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOLLOW_BUTTON, FollowButton))
#define FOLLOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOLLOW_BUTTON, FollowButtonClass))
#define IS_FOLLOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOLLOW_BUTTON))
#define IS_FOLLOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOLLOW_BUTTON))
#define FOLLOW_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOLLOW_BUTTON, FollowButtonClass))

typedef struct _FollowButton FollowButton;
typedef struct _FollowButtonClass FollowButtonClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;

#define TYPE_CURSOR (cursor_get_type ())
typedef struct _Cursor Cursor;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cursor_free0(var) ((var == NULL) ? NULL : (var = (cursor_free (var), NULL)))

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _ProfilePageLoadFriendshipData ProfilePageLoadFriendshipData;
typedef struct _Block23Data Block23Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _ProfilePageLoadProfileDataData ProfilePageLoadProfileDataData;
typedef struct _ProfilePageLoadTweetsData ProfilePageLoadTweetsData;
typedef struct _ProfilePageLoadOlderTweetsData ProfilePageLoadOlderTweetsData;
typedef struct _ProfilePageLoadFollowersData ProfilePageLoadFollowersData;
typedef struct _ProfilePageLoadFollowingData ProfilePageLoadFollowingData;
typedef struct _Block24Data Block24Data;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_USER_LIST_DIALOG (user_list_dialog_get_type ())
#define USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_DIALOG, UserListDialog))
#define USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_DIALOG, UserListDialogClass))
#define IS_USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_DIALOG))
#define IS_USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_DIALOG))
#define USER_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_DIALOG, UserListDialogClass))

typedef struct _UserListDialog UserListDialog;
typedef struct _UserListDialogClass UserListDialogClass;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _ProfilePage {
	ScrollWidget parent_instance;
	ProfilePagePrivate * priv;
	Account* account;
};

struct _ProfilePageClass {
	ScrollWidgetClass parent_class;
};

struct _Cursor {
	gint64 next_cursor;
	gboolean full;
	JsonNode* json_object;
};

struct _ProfilePagePrivate {
	MainWindow* main_window;
	gint _id;
	AspectImage* banner_image;
	AvatarWidget* avatar_image;
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
	GtkLabel* description_label;
	GtkLabel* url_label;
	GtkLabel* tweets_label;
	GtkLabel* following_label;
	GtkLabel* followers_label;
	GtkLabel* location_label;
	FollowButton* follow_button;
	TweetListBox* tweet_list;
	TweetListBox* followers_list;
	TweetListBox* following_list;
	GtkSpinner* progress_spinner;
	GtkLabel* follows_you_label;
	UserListsWidget* user_lists;
	GtkStack* user_stack;
	GtkMenuButton* more_button;
	GtkStack* loading_stack;
	GtkRadioButton* tweets_button;
	gint64 user_id;
	gchar* name;
	gchar* screen_name;
	gchar* avatar_url;
	gint follower_count;
	GCancellable* data_cancellable;
	gboolean lists_page_inited;
	gboolean block_item_blocked;
	gboolean retweet_item_blocked;
	gboolean mute_item_blocked;
	gboolean tweets_loading;
	gboolean followers_loading;
	Cursor* followers_cursor;
	gboolean following_loading;
	Cursor* following_cursor;
	GSimpleActionGroup* actions;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ProfilePageLoadFriendshipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	Account* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	gboolean _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GAction* _tmp7_;
	GSimpleActionGroup* _tmp8_;
	GAction* _tmp9_;
	gint64 _tmp10_;
	Account* _tmp11_;
	gint64 _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GAction* _tmp14_;
	gint64 _tmp15_;
	Account* _tmp16_;
	gint64 _tmp17_;
	GSimpleActionGroup* _tmp18_;
	GAction* _tmp19_;
	gint64 _tmp20_;
	Account* _tmp21_;
	gint64 _tmp22_;
	GSimpleActionGroup* _tmp23_;
	GAction* _tmp24_;
	gint64 _tmp25_;
	Account* _tmp26_;
	gint64 _tmp27_;
	guint fr;
	Account* _tmp28_;
	gint64 _tmp29_;
	guint _tmp30_;
	GtkLabel* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GSimpleActionGroup* _tmp38_;
	GAction* _tmp39_;
	GSimpleActionGroup* _tmp40_;
	GAction* _tmp41_;
	guint _tmp42_;
};

struct _Block23Data {
	int _ref_count_;
	ProfilePage* self;
	gint scale;
	CbTextEntity* text_urls;
	gint text_urls_length1;
	gint _text_urls_size_;
	gpointer _async_data_;
};

struct _ProfilePageLoadProfileDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gint64 user_id;
	Block23Data* _data23_;
	GtkStack* _tmp0_;
	GtkSpinner* _tmp1_;
	FollowButton* _tmp2_;
	RestProxyCall* call;
	Account* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	JsonNode* root_node;
	JsonNode* _tmp13_;
	RestProxyCall* _tmp14_;
	GCancellable* _tmp15_;
	JsonNode* _tmp16_;
	JsonNode* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	JsonNode* _tmp20_;
	JsonObject* root;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	gint64 id;
	JsonObject* _tmp24_;
	gint64 _tmp25_;
	gchar* avatar_url;
	JsonObject* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gint _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gchar* name;
	JsonObject* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* screen_name;
	JsonObject* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* description;
	JsonObject* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gint followers;
	JsonObject* _tmp46_;
	gint64 _tmp47_;
	gint following;
	JsonObject* _tmp48_;
	gint64 _tmp49_;
	gint tweets;
	JsonObject* _tmp50_;
	gint64 _tmp51_;
	gboolean is_following;
	JsonObject* _tmp52_;
	gboolean _tmp53_;
	JsonObject* _tmp54_;
	gboolean _tmp55_;
	gboolean has_url;
	JsonObject* _tmp56_;
	JsonObject* _tmp57_;
	gboolean _tmp58_;
	gboolean verified;
	JsonObject* _tmp59_;
	gboolean _tmp60_;
	gboolean protected_user;
	JsonObject* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	TweetListBox* _tmp64_;
	const gchar* _tmp65_;
	JsonObject* _tmp66_;
	gboolean _tmp67_;
	gchar* banner_base_url;
	JsonObject* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	const gchar* _tmp71_;
	gint64 _tmp72_;
	gchar* display_url;
	gchar* _tmp73_;
	JsonObject* entities;
	JsonObject* _tmp74_;
	JsonObject* _tmp75_;
	JsonObject* _tmp76_;
	gboolean _tmp77_;
	JsonObject* urls_object;
	JsonObject* _tmp78_;
	JsonObject* _tmp79_;
	JsonArray* _tmp80_;
	JsonNode* _tmp81_;
	JsonObject* _tmp82_;
	JsonObject* _tmp83_;
	gchar* url;
	JsonObject* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	JsonObject* _tmp87_;
	gboolean _tmp88_;
	JsonObject* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	JsonObject* _tmp92_;
	const gchar* _tmp93_;
	gchar* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* location;
	JsonObject* _tmp97_;
	gboolean _tmp98_;
	JsonObject* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	JsonObject* _tmp102_;
	gboolean _tmp103_;
	JsonArray* urls;
	JsonObject* _tmp104_;
	JsonObject* _tmp105_;
	JsonArray* _tmp106_;
	JsonArray* _tmp107_;
	JsonArray* _tmp108_;
	guint _tmp109_;
	CbTextEntity* _tmp110_;
	JsonArray* _tmp111_;
	Account* _tmp112_;
	CbUserCounter* _tmp113_;
	gint64 _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	FollowButton* _tmp117_;
	gboolean _tmp118_;
	FollowButton* _tmp119_;
	gint64 _tmp120_;
	Account* _tmp121_;
	gint64 _tmp122_;
	GMenu* section;
	GtkMenuButton* _tmp123_;
	GMenuModel* _tmp124_;
	GMenuModel* _tmp125_;
	GMenuModel* _tmp126_;
	GMenuItem* user_item;
	const gchar* _tmp127_;
	const gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	GMenuItem* _tmp133_;
	GMenuItem* _tmp134_;
	GMenu* _tmp135_;
	GMenu* _tmp136_;
	GMenuItem* _tmp137_;
	GtkLabel* _tmp138_;
	const gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	GtkLabel* _tmp142_;
	const gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* desc;
	const gchar* _tmp146_;
	gchar* _tmp147_;
	CbTextEntity* _tmp148_;
	gint _tmp148__length1;
	const gchar* _tmp149_;
	CbTextEntity* _tmp150_;
	gint _tmp150__length1;
	gchar* _tmp151_;
	gint _tmp152_;
	GtkLabel* _tmp153_;
	const gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	GtkLabel* _tmp159_;
	gint _tmp160_;
	gchar* _tmp161_;
	gchar* _tmp162_;
	GtkLabel* _tmp163_;
	gint _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	gboolean _tmp167_;
	const gchar* _tmp168_;
	const gchar* _tmp169_;
	GtkLabel* _tmp170_;
	GtkLabel* _tmp171_;
	const gchar* _tmp172_;
	GtkLabel* _tmp173_;
	AvatarWidget* _tmp174_;
	gboolean _tmp175_;
	const gchar* _tmp176_;
	gint _tmp177_;
	gint _tmp178_;
	GtkLabel* _tmp179_;
	GtkLabel* _tmp180_;
	const gchar* _tmp181_;
	const gchar* _tmp182_;
	gchar* _tmp183_;
	gchar* _tmp184_;
	GtkLabel* _tmp185_;
	GtkLabel* _tmp186_;
	GtkLabel* _tmp187_;
	const gchar* _tmp188_;
	gchar* _tmp189_;
	const gchar* _tmp190_;
	gchar* _tmp191_;
	const gchar* _tmp192_;
	gchar* _tmp193_;
	GError * _inner_error_;
};

struct _ProfilePageLoadTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	TweetListBox* _tmp0_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	RestProxyCall* _tmp16_;
	JsonNode* root;
	JsonNode* _tmp17_;
	RestProxyCall* _tmp18_;
	GCancellable* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	TweetListBox* _tmp24_;
	JsonNode* _tmp25_;
	JsonArray* root_array;
	JsonNode* _tmp26_;
	JsonArray* _tmp27_;
	JsonArray* _tmp28_;
	JsonArray* _tmp29_;
	guint _tmp30_;
	TweetListBox* _tmp31_;
	JsonArray* _tmp32_;
	TweetListBox* _tmp33_;
	Account* _tmp34_;
	GError * _inner_error_;
};

struct _ProfilePageLoadOlderTweetsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	TweetListBox* _tmp4_;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp5_;
	OAuthProxy* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	RestProxyCall* _tmp18_;
	RestProxyCall* _tmp19_;
	RestProxyCall* _tmp20_;
	TweetListBox* _tmp21_;
	TweetModel* _tmp22_;
	gint64 _tmp23_;
	gint64 _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	JsonNode* root;
	JsonNode* _tmp27_;
	RestProxyCall* _tmp28_;
	GCancellable* _tmp29_;
	JsonNode* _tmp30_;
	JsonNode* _tmp31_;
	GError* e;
	GError* _tmp32_;
	const gchar* _tmp33_;
	JsonNode* _tmp34_;
	JsonArray* root_arr;
	JsonNode* _tmp35_;
	JsonArray* _tmp36_;
	JsonArray* _tmp37_;
	JsonArray* _tmp38_;
	TweetListBox* _tmp39_;
	Account* _tmp40_;
	GError * _inner_error_;
};

struct _ProfilePageLoadFollowersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	Cursor* _tmp1_;
	Cursor* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Account* _tmp5_;
	gint64 _tmp6_;
	Cursor* _tmp7_;
	Cursor* _tmp8_;
	Cursor* _tmp9_;
	JsonArray* users_array;
	Cursor* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
};

struct _ProfilePageLoadFollowingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ProfilePage* self;
	gboolean _tmp0_;
	Cursor* _tmp1_;
	Cursor* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Account* _tmp5_;
	gint64 _tmp6_;
	Cursor* _tmp7_;
	Cursor* _tmp8_;
	Cursor* _tmp9_;
	JsonArray* users_array;
	Cursor* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
};

struct _Block24Data {
	int _ref_count_;
	ProfilePage* self;
	RestProxyCall* call;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block25Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};

struct _Block26Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean setting;
};

struct _Block27Data {
	int _ref_count_;
	ProfilePage* self;
	gboolean current_state;
	RestProxyCall* call;
	GSimpleAction* a;
};


static gpointer profile_page_parent_class = NULL;
extern cairo_surface_t* twitter_no_avatar;
extern GdkPixbuf* twitter_no_banner;
static IPageIface* profile_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* profile_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType profile_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType aspect_image_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType follow_button_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType user_lists_widget_get_type (void) G_GNUC_CONST;
GType cursor_get_type (void) G_GNUC_CONST;
Cursor* cursor_dup (const Cursor* self);
void cursor_free (Cursor* self);
void cursor_copy (const Cursor* self, Cursor* dest);
void cursor_destroy (Cursor* self);
#define PROFILE_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROFILE_PAGE, ProfilePagePrivate))
enum  {
	PROFILE_PAGE_DUMMY_PROPERTY,
	PROFILE_PAGE_UNREAD_COUNT,
	PROFILE_PAGE_WINDOW,
	PROFILE_PAGE_ID
};
static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType delta_updater_get_type (void) G_GNUC_CONST;
ProfilePage* profile_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
ProfilePage* profile_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
GType tweet_model_get_type (void) G_GNUC_CONST;
static void __lambda166_ (ProfilePage* self);
static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_followers (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_followers_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_following (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_following_finish (ProfilePage* self, GAsyncResult* _res_);
static void ___lambda166__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
static void __lambda169_ (ProfilePage* self, GtkListBoxRow* row);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda169__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda170_ (ProfilePage* self, GtkListBoxRow* row);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType user_list_entry_get_type (void) G_GNUC_CONST;
gint64 user_list_entry_get_user_id (UserListEntry* self);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
static void ___lambda170__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda171_ (ProfilePage* self, GtkListBoxRow* row);
static void ___lambda171__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void user_lists_widget_hide_user_list_entry (UserListsWidget* self);
static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_toggle_muted_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_toggle_muted_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v);
static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void profile_page_set_user_id (ProfilePage* self, gint64 user_id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static inline void profile_page_set_banner (ProfilePage* self, GdkPixbuf* banner);
static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_);
static void profile_page_load_friendship_data_free (gpointer _data);
static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_);
static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked);
gboolean account_is_blocked (Account* self, gint64 user_id);
static void profile_page_set_user_muted (ProfilePage* self, gboolean muted);
gboolean account_is_muted (Account* self, gint64 user_id);
void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint user_utils_load_friendship_finish (GAsyncResult* _res_);
static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define FRIENDSHIP_FOLLOWED_BY ((guint) (1 << 0))
#define FRIENDSHIP_BLOCKING ((guint) (1 << 3))
#define FRIENDSHIP_FOLLOWING ((guint) (1 << 1))
#define FRIENDSHIP_WANT_RETWEETS ((guint) (1 << 2))
static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled);
#define FRIENDSHIP_CAN_DM ((guint) (1 << 4))
static void profile_page_load_profile_data_data_free (gpointer _data);
static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length);
static void block23_data_unref (void * _userdata_);
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void __lambda175_ (Block23Data* _data23_, GObject* obj, GAsyncResult* res);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda175__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url, gint64 user_id);
static void ___lambda177_ (Block23Data* _data23_, JsonArray* arr, guint i, JsonNode* node);
static void ____lambda177__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void follow_button_set_following (FollowButton* self, gboolean value);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
static void profile_page_update_follower_label (ProfilePage* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void profile_page_load_tweets_data_free (gpointer _data);
static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_);
static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
static void profile_page_load_older_tweets_data_free (gpointer _data);
static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_);
gint64 tweet_model_get_lowest_id (TweetModel* self);
static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void profile_page_load_followers_data_free (gpointer _data);
static gboolean profile_page_load_followers_co (ProfilePageLoadFollowersData* _data_);
void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_followers_finish (GAsyncResult* _res_);
static void profile_page_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda167_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* sn);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_avatar_url (UserListEntry* self, const gchar* value);
static void ___lambda167__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void profile_page_load_following_data_free (gpointer _data);
static gboolean profile_page_load_following_co (ProfilePageLoadFollowingData* _data_);
void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_following_finish (GAsyncResult* _res_);
static void profile_page_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda168_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node);
static void ___lambda168__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static void __lambda176_ (ProfilePage* self, GObject* obj, GAsyncResult* res);
static void ___lambda176__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void profile_page_follow_button_clicked_cb (ProfilePage* self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
GType default_timeline_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
gboolean follow_button_get_following (FollowButton* self);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void account_unfollow_id (Account* self, gint64 user_id);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void account_follow_id (Account* self, gint64 user_id);
static void __lambda178_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res);
static void ___lambda178__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
void aspect_image_set_pixbuf (AspectImage* self, GdkPixbuf* value);
static void profile_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void profile_page_reset_data (ProfilePage* self);
void tweet_list_box_remove_all (TweetListBox* self);
gboolean account_follows_id (Account* self, gint64 user_id);
void tweet_model_clear (TweetModel* self);
void user_lists_widget_clear_lists (UserListsWidget* self);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
static void profile_page_real_on_leave (IPage* base);
static void profile_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static gchar* profile_page_real_get_title (IPage* base);
static GtkRadioButton* profile_page_real_get_radio_button (IPage* base);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
GType user_list_dialog_get_type (void) G_GNUC_CONST;
UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id);
UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id);
void user_list_dialog_load_lists (UserListDialog* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gboolean profile_page_get_user_blocked (ProfilePage* self);
static void __lambda172_ (Block25Data* _data25_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda172__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean profile_page_get_user_muted (ProfilePage* self);
static GVariant* _variant_new5 (gboolean value);
void user_utils_mute_user (Account* account, gint64 to_block, gboolean setting, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_utils_mute_user_finish (GAsyncResult* _res_);
static void __lambda173_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res);
static void ___lambda173__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
static void __lambda174_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res);
static void ___lambda174__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void profile_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node);
void tweet_model_add (TweetModel* self, CbTweet* tweet);
static void profile_page_tweets_button_toggled_cb (ProfilePage* self, GObject* source);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define BOTTOM 2
static void _profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_followers_button_toggled_cb (ProfilePage* self, GObject* source);
static void _profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_following_button_toggled_cb (ProfilePage* self, GObject* source);
static void _profile_page_following_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void profile_page_lists_button_toggled_cb (ProfilePage* self, GObject* source);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static void _profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gint profile_page_get_unread_count (ProfilePage* self);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
static void profile_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry PROFILE_PAGE_action_entries[3] = {{"write-dm", _profile_page_write_dm_activated_gsimple_action_activate_callback}, {"tweet-to", _profile_page_tweet_to_activated_gsimple_action_activate_callback}, {"add-remove-list", _profile_page_add_remove_list_activated_gsimple_action_activate_callback}};

static void _profile_page_write_dm_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_write_dm_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_tweet_to_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_tweet_to_activated ((ProfilePage*) self, action, parameter);
}


static void _profile_page_add_remove_list_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	profile_page_add_remove_list_activated ((ProfilePage*) self, action, parameter);
}


static void __lambda166_ (ProfilePage* self) {
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	_tmp0_ = self->priv->user_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->tweet_list;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		profile_page_load_older_tweets (self, NULL, NULL);
	} else {
		GtkStack* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		TweetListBox* _tmp7_ = NULL;
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = gtk_stack_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->followers_list;
		if (_tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
			profile_page_load_followers (self, NULL, NULL);
		} else {
			GtkStack* _tmp8_ = NULL;
			GtkWidget* _tmp9_ = NULL;
			GtkWidget* _tmp10_ = NULL;
			TweetListBox* _tmp11_ = NULL;
			_tmp8_ = self->priv->user_stack;
			_tmp9_ = gtk_stack_get_visible_child (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->following_list;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget)) {
				profile_page_load_following (self, NULL, NULL);
			}
		}
	}
}


static void ___lambda166__scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	__lambda166_ ((ProfilePage*) self);
}


static void __lambda169_ (ProfilePage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWidget* _tmp4_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda169__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda169_ ((ProfilePage*) self, row);
}


static void __lambda170_ (ProfilePage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	GtkListBoxRow* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	MainWindow* _tmp8_ = NULL;
	MainWidget* _tmp9_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	bundle_put_int64 (bundle, "user_id", _tmp3_);
	_tmp4_ = row;
	_tmp5_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	bundle_put_string (bundle, "screen_name", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda170__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda170_ ((ProfilePage*) self, row);
}


static void __lambda171_ (ProfilePage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	GtkListBoxRow* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	MainWindow* _tmp8_ = NULL;
	MainWidget* _tmp9_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	bundle_put_int64 (bundle, "user_id", _tmp3_);
	_tmp4_ = row;
	_tmp5_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	bundle_put_string (bundle, "screen_name", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda171__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda171_ ((ProfilePage*) self, row);
}


static void _profile_page_toggle_blocked_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_toggle_blocked_activated ((ProfilePage*) self, _sender, parameter);
}


static void _profile_page_toggle_muted_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_toggle_muted_activated ((ProfilePage*) self, _sender, parameter);
}


static void _profile_page_retweet_action_activated_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	profile_page_retweet_action_activated ((ProfilePage*) self, _sender, parameter);
}


ProfilePage* profile_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater) {
	ProfilePage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	UserListsWidget* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	DeltaUpdater* _tmp7_ = NULL;
	TweetListBox* _tmp8_ = NULL;
	TweetListBox* _tmp9_ = NULL;
	TweetListBox* _tmp10_ = NULL;
	UserListsWidget* _tmp11_ = NULL;
	GSimpleActionGroup* _tmp12_ = NULL;
	GSimpleActionGroup* _tmp13_ = NULL;
	GSimpleAction* block_action = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GSimpleAction* _tmp16_ = NULL;
	GSimpleAction* _tmp17_ = NULL;
	GSimpleActionGroup* _tmp18_ = NULL;
	GSimpleAction* mute_action = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GSimpleAction* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	GSimpleActionGroup* _tmp23_ = NULL;
	GSimpleAction* rt_action = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	GSimpleAction* _tmp26_ = NULL;
	GSimpleAction* _tmp27_ = NULL;
	GSimpleActionGroup* _tmp28_ = NULL;
	GSimpleActionGroup* _tmp29_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_DELTA_UPDATER (delta_updater), NULL);
	self = (ProfilePage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->user_lists;
	_tmp3_ = account;
	user_lists_widget_set_account (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = account;
	_tmp4_->account = _tmp5_;
	_tmp6_ = self->priv->tweet_list;
	_tmp7_ = delta_updater;
	_tmp6_->delta_updater = _tmp7_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) ___lambda166__scroll_widget_scrolled_to_end, self, 0);
	_tmp8_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda169__gtk_list_box_row_activated, self, 0);
	_tmp9_ = self->priv->followers_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda170__gtk_list_box_row_activated, self, 0);
	_tmp10_ = self->priv->following_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda171__gtk_list_box_row_activated, self, 0);
	_tmp11_ = self->priv->user_lists;
	user_lists_widget_hide_user_list_entry (_tmp11_);
	_tmp12_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp12_;
	_tmp13_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_action_map_get_type (), GActionMap), PROFILE_PAGE_action_entries, G_N_ELEMENTS (PROFILE_PAGE_action_entries), self);
	_tmp14_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_simple_action_new_stateful ("toggle-blocked", NULL, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	block_action = _tmp17_;
	g_signal_connect_object (block_action, "activate", (GCallback) _profile_page_toggle_blocked_activated_g_simple_action_activate, self, 0);
	_tmp18_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (block_action, g_action_get_type (), GAction));
	_tmp19_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_simple_action_new_stateful ("toggle-muted", NULL, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_variant_unref0 (_tmp20_);
	mute_action = _tmp22_;
	g_signal_connect_object (mute_action, "activate", (GCallback) _profile_page_toggle_muted_activated_g_simple_action_activate, self, 0);
	_tmp23_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (mute_action, g_action_get_type (), GAction));
	_tmp24_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_simple_action_new_stateful ("toggle-retweets", NULL, _tmp25_);
	_tmp27_ = _tmp26_;
	_g_variant_unref0 (_tmp25_);
	rt_action = _tmp27_;
	g_signal_connect_object (rt_action, "activate", (GCallback) _profile_page_retweet_action_activated_g_simple_action_activate, self, 0);
	_tmp28_ = self->priv->actions;
	g_action_map_add_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_action_map_get_type (), GActionMap), G_TYPE_CHECK_INSTANCE_CAST (rt_action, g_action_get_type (), GAction));
	_tmp29_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "user", G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_action_group_get_type (), GActionGroup));
	_g_object_unref0 (rt_action);
	_g_object_unref0 (mute_action);
	_g_object_unref0 (block_action);
	return self;
}


ProfilePage* profile_page_new (gint id, Account* account, DeltaUpdater* delta_updater) {
	return profile_page_construct (TYPE_PROFILE_PAGE, id, account, delta_updater);
}


static void profile_page_set_user_id (ProfilePage* self, gint64 user_id) {
	gint64 _tmp0_ = 0LL;
	FollowButton* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = user_id;
	self->priv->user_id = _tmp0_;
	_tmp1_ = self->priv->follow_button;
	_tmp2_ = user_id;
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->id;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_ != _tmp4_);
	profile_page_set_banner (self, NULL);
	profile_page_load_friendship (self, NULL, NULL);
	_tmp5_ = user_id;
	profile_page_load_profile_data (self, _tmp5_, NULL, NULL);
}


static void profile_page_load_friendship_data_free (gpointer _data) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFriendshipData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void profile_page_load_friendship (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadFriendshipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_friendship);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_friendship_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_friendship_co (_data_);
}


static void profile_page_load_friendship_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFriendshipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_friendship_co (_data_);
}


static gboolean profile_page_load_friendship_co (ProfilePageLoadFriendshipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = 0LL;
	_data_->_tmp1_ = _data_->self->priv->user_id;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = account_is_blocked (_data_->_tmp0_, _data_->_tmp1_);
	profile_page_set_user_blocked (_data_->self, _data_->_tmp2_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->account;
	_data_->_tmp4_ = 0LL;
	_data_->_tmp4_ = _data_->self->priv->user_id;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = account_is_muted (_data_->_tmp3_, _data_->_tmp4_);
	profile_page_set_user_muted (_data_->self, _data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->actions;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, g_simple_action_get_type (), GSimpleAction), FALSE);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->actions;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_action_map_get_type (), GActionMap), "add-remove-list");
	_data_->_tmp10_ = 0LL;
	_data_->_tmp10_ = _data_->self->priv->user_id;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->self->account;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp10_ != _data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->self->priv->actions;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, g_action_map_get_type (), GActionMap), "write-dm");
	_data_->_tmp15_ = 0LL;
	_data_->_tmp15_ = _data_->self->priv->user_id;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->self->account;
	_data_->_tmp17_ = 0LL;
	_data_->_tmp17_ = _data_->_tmp16_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp15_ != _data_->_tmp17_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->self->priv->actions;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_data_->_tmp20_ = 0LL;
	_data_->_tmp20_ = _data_->self->priv->user_id;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->self->account;
	_data_->_tmp22_ = 0LL;
	_data_->_tmp22_ = _data_->_tmp21_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp20_ != _data_->_tmp22_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->self->priv->actions;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_data_->_tmp25_ = 0LL;
	_data_->_tmp25_ = _data_->self->priv->user_id;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->self->account;
	_data_->_tmp27_ = 0LL;
	_data_->_tmp27_ = _data_->_tmp26_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, g_simple_action_get_type (), GSimpleAction), _data_->_tmp25_ != _data_->_tmp27_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->self->account;
	_data_->_tmp29_ = 0LL;
	_data_->_tmp29_ = _data_->self->priv->user_id;
	_data_->_state_ = 1;
	user_utils_load_friendship (_data_->_tmp28_, _data_->_tmp29_, profile_page_load_friendship_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp30_ = 0U;
	_data_->_tmp30_ = user_utils_load_friendship_finish (_data_->_res_);
	_data_->fr = _data_->_tmp30_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->self->priv->follows_you_label;
	_data_->_tmp32_ = 0U;
	_data_->_tmp32_ = _data_->fr;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, gtk_widget_get_type (), GtkWidget), (_data_->_tmp32_ & FRIENDSHIP_FOLLOWED_BY) > ((guint) 0));
	_data_->_tmp33_ = 0U;
	_data_->_tmp33_ = _data_->fr;
	profile_page_set_user_blocked (_data_->self, (_data_->_tmp33_ & FRIENDSHIP_BLOCKING) > ((guint) 0));
	_data_->_tmp35_ = 0U;
	_data_->_tmp35_ = _data_->fr;
	if ((_data_->_tmp35_ & FRIENDSHIP_FOLLOWING) > ((guint) 0)) {
		_data_->_tmp36_ = 0U;
		_data_->_tmp36_ = _data_->fr;
		_data_->_tmp34_ = (_data_->_tmp36_ & FRIENDSHIP_WANT_RETWEETS) == ((guint) 0);
	} else {
		_data_->_tmp34_ = FALSE;
	}
	profile_page_set_retweets_disabled (_data_->self, _data_->_tmp34_);
	_data_->_tmp37_ = 0U;
	_data_->_tmp37_ = _data_->fr;
	if ((_data_->_tmp37_ & FRIENDSHIP_CAN_DM) == ((guint) 0)) {
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->self->priv->actions;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp38_, g_action_map_get_type (), GActionMap), "write-dm");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->self->priv->actions;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_data_->_tmp42_ = 0U;
	_data_->_tmp42_ = _data_->fr;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp41_, g_simple_action_get_type (), GSimpleAction), (_data_->_tmp42_ & FRIENDSHIP_FOLLOWING) > ((guint) 0));
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_profile_data_data_free (gpointer _data) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadProfileDataData, _data_);
}


static void profile_page_load_profile_data (ProfilePage* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	ProfilePage* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	_data_ = g_slice_new0 (ProfilePageLoadProfileDataData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_profile_data);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_profile_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	profile_page_load_profile_data_co (_data_);
}


static void profile_page_load_profile_data_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ProfilePage* self;
		self = _data23_->self;
		_data23_->text_urls = (_vala_CbTextEntity_array_free (_data23_->text_urls, _data23_->text_urls_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}


static void profile_page_load_profile_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadProfileDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_profile_data_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch20_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch20_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally20;
	__catch20_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void __lambda175_ (Block23Data* _data23_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	cairo_surface_t* surface = NULL;
	AvatarWidget* _tmp8_ = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	GtkSpinner* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data23_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GdkPixbuf* pixbuf = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		cairo_surface_t* _tmp3_ = NULL;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_download_avatar_finish (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_tmp2_ = _data23_->scale;
		_tmp3_ = gdk_cairo_surface_create_from_pixbuf (pixbuf, _tmp2_, NULL);
		_cairo_surface_destroy0 (surface);
		surface = _tmp3_;
		_g_object_unref0 (pixbuf);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		cairo_surface_t* _tmp6_ = NULL;
		cairo_surface_t* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ProfilePage.vala:232: %s", _tmp5_);
		_tmp6_ = twitter_no_avatar;
		_tmp7_ = _cairo_surface_reference0 (_tmp6_);
		_cairo_surface_destroy0 (surface);
		surface = _tmp7_;
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->avatar_image;
	_tmp9_ = surface;
	avatar_widget_set_surface (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->progress_spinner;
	gtk_spinner_stop (_tmp10_);
	_tmp11_ = self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "data");
	_cairo_surface_destroy0 (surface);
}


static void ___lambda175__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda175_ (self, source_object, res);
	block23_data_unref (self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda177_ (Block23Data* _data23_, JsonArray* arr, guint i, JsonNode* node) {
	ProfilePage* self;
	JsonObject* ent = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	CbTextEntity* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	guint _tmp8_ = 0U;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	CbTextEntity _tmp14_ = {0};
	CbTextEntity _tmp15_ = {0};
	self = _data23_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	ent = _tmp2_;
	_tmp3_ = json_object_get_string_member (ent, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (ent, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data23_->text_urls;
	_tmp7__length1 = _data23_->text_urls_length1;
	_tmp8_ = i;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = g_strdup (expanded_url);
	_tmp12_ = json_object_get_string_member (ent, "display_url");
	_tmp13_ = g_strdup (_tmp12_);
	memset (&_tmp14_, 0, sizeof (CbTextEntity));
	_tmp14_.from = (guint) _tmp9_;
	_tmp14_.to = (guint) _tmp10_;
	_g_free0 (_tmp14_.target);
	_tmp14_.target = _tmp11_;
	_g_free0 (_tmp14_.display_text);
	_tmp14_.display_text = _tmp13_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp14_;
	_tmp15_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (ent);
}


static void ____lambda177__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda177_ (self, array, index_, element_node);
}


static gboolean profile_page_load_profile_data_co (ProfilePageLoadProfileDataData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data23_ = g_slice_new0 (Block23Data);
	_data_->_data23_->_ref_count_ = 1;
	_data_->_data23_->self = g_object_ref (_data_->self);
	_data_->_data23_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->loading_stack;
	gtk_stack_set_visible_child_name (_data_->_tmp0_, "progress");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->progress_spinner;
	gtk_spinner_start (_data_->_tmp1_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->account;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_->proxy;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp7_, "1.1/users/show.json");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->user_id;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp8_, "user_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp12_, "include_entities", "false");
	_data_->root_node = NULL;
	{
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->call;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp14_, _data_->_tmp15_, profile_page_load_profile_data_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp13_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp13_;
		_data_->_tmp13_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp17_;
		__vala_JsonNode_free0 (_data_->_tmp13_);
	}
	goto __finally19;
	__catch19_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("ProfilePage.vala:209: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally19:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root_node;
	if (_data_->_tmp20_ == NULL) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->root_node;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _json_object_ref0 (_data_->_tmp22_);
	_data_->root = _data_->_tmp23_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->root;
	_data_->_tmp25_ = 0LL;
	_data_->_tmp25_ = json_object_get_int_member (_data_->_tmp24_, "id");
	_data_->id = _data_->_tmp25_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_object_get_string_member (_data_->_tmp26_, "profile_image_url");
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
	_data_->avatar_url = _data_->_tmp28_;
	_data_->_tmp29_ = 0;
	_data_->_tmp29_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	_data_->_data23_->scale = _data_->_tmp29_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->avatar_url;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = string_replace (_data_->_tmp30_, "_normal", "_200x200");
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _data_->_tmp31_;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->avatar_url;
	_data_->_tmp33_ = 0;
	_data_->_tmp33_ = _data_->_data23_->scale;
	tweet_utils_download_avatar (_data_->_tmp32_, 100 * _data_->_tmp33_, ___lambda175__gasync_ready_callback, block23_data_ref (_data_->_data23_));
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->root;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = json_object_get_string_member (_data_->_tmp34_, "name");
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = string_replace (_data_->_tmp35_, "&", "&amp;");
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = string_strip (_data_->_tmp37_);
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_tmp38_;
	_g_free0 (_data_->_tmp37_);
	_data_->name = _data_->_tmp39_;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->root;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = json_object_get_string_member (_data_->_tmp40_, "screen_name");
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
	_data_->screen_name = _data_->_tmp42_;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _data_->root;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = json_object_get_string_member (_data_->_tmp43_, "description");
	_data_->_tmp45_ = NULL;
	_data_->_tmp45_ = g_strdup (_data_->_tmp44_);
	_data_->description = _data_->_tmp45_;
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = _data_->root;
	_data_->_tmp47_ = 0LL;
	_data_->_tmp47_ = json_object_get_int_member (_data_->_tmp46_, "followers_count");
	_data_->followers = (gint) _data_->_tmp47_;
	_data_->_tmp48_ = NULL;
	_data_->_tmp48_ = _data_->root;
	_data_->_tmp49_ = 0LL;
	_data_->_tmp49_ = json_object_get_int_member (_data_->_tmp48_, "friends_count");
	_data_->following = (gint) _data_->_tmp49_;
	_data_->_tmp50_ = NULL;
	_data_->_tmp50_ = _data_->root;
	_data_->_tmp51_ = 0LL;
	_data_->_tmp51_ = json_object_get_int_member (_data_->_tmp50_, "statuses_count");
	_data_->tweets = (gint) _data_->_tmp51_;
	_data_->is_following = FALSE;
	_data_->_tmp52_ = NULL;
	_data_->_tmp52_ = _data_->root;
	_data_->_tmp53_ = FALSE;
	_data_->_tmp53_ = utils_usable_json_value (_data_->_tmp52_, "following");
	if (_data_->_tmp53_) {
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->root;
		_data_->_tmp55_ = FALSE;
		_data_->_tmp55_ = json_object_get_boolean_member (_data_->_tmp54_, "following");
		_data_->is_following = _data_->_tmp55_;
	}
	_data_->_tmp56_ = NULL;
	_data_->_tmp56_ = _data_->root;
	_data_->_tmp57_ = NULL;
	_data_->_tmp57_ = json_object_get_object_member (_data_->_tmp56_, "entities");
	_data_->_tmp58_ = FALSE;
	_data_->_tmp58_ = json_object_has_member (_data_->_tmp57_, "url");
	_data_->has_url = _data_->_tmp58_;
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = _data_->root;
	_data_->_tmp60_ = FALSE;
	_data_->_tmp60_ = json_object_get_boolean_member (_data_->_tmp59_, "verified");
	_data_->verified = _data_->_tmp60_;
	_data_->_tmp61_ = NULL;
	_data_->_tmp61_ = _data_->root;
	_data_->_tmp62_ = FALSE;
	_data_->_tmp62_ = json_object_get_boolean_member (_data_->_tmp61_, "protected");
	_data_->protected_user = _data_->_tmp62_;
	_data_->_tmp63_ = FALSE;
	_data_->_tmp63_ = _data_->protected_user;
	if (_data_->_tmp63_) {
		_data_->_tmp64_ = NULL;
		_data_->_tmp64_ = _data_->self->priv->tweet_list;
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = _ ("Protected profile");
		tweet_list_box_set_placeholder_text (_data_->_tmp64_, _data_->_tmp65_);
	}
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = _data_->root;
	_data_->_tmp67_ = FALSE;
	_data_->_tmp67_ = json_object_has_member (_data_->_tmp66_, "profile_banner_url");
	if (_data_->_tmp67_) {
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = _data_->root;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = json_object_get_string_member (_data_->_tmp68_, "profile_banner_url");
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = g_strdup (_data_->_tmp69_);
		_data_->banner_base_url = _data_->_tmp70_;
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = _data_->banner_base_url;
		_data_->_tmp72_ = 0LL;
		_data_->_tmp72_ = _data_->user_id;
		profile_page_load_profile_banner (_data_->self, _data_->_tmp71_, _data_->_tmp72_);
		_g_free0 (_data_->banner_base_url);
	}
	_data_->_tmp73_ = NULL;
	_data_->_tmp73_ = g_strdup ("");
	_data_->display_url = _data_->_tmp73_;
	_data_->_tmp74_ = NULL;
	_data_->_tmp74_ = _data_->root;
	_data_->_tmp75_ = NULL;
	_data_->_tmp75_ = json_object_get_object_member (_data_->_tmp74_, "entities");
	_data_->_tmp76_ = NULL;
	_data_->_tmp76_ = _json_object_ref0 (_data_->_tmp75_);
	_data_->entities = _data_->_tmp76_;
	_data_->_tmp77_ = FALSE;
	_data_->_tmp77_ = _data_->has_url;
	if (_data_->_tmp77_) {
		_data_->_tmp78_ = NULL;
		_data_->_tmp78_ = _data_->entities;
		_data_->_tmp79_ = NULL;
		_data_->_tmp79_ = json_object_get_object_member (_data_->_tmp78_, "url");
		_data_->_tmp80_ = NULL;
		_data_->_tmp80_ = json_object_get_array_member (_data_->_tmp79_, "urls");
		_data_->_tmp81_ = NULL;
		_data_->_tmp81_ = json_array_get_element (_data_->_tmp80_, (guint) 0);
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = json_node_get_object (_data_->_tmp81_);
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _json_object_ref0 (_data_->_tmp82_);
		_data_->urls_object = _data_->_tmp83_;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = _data_->urls_object;
		_data_->_tmp85_ = NULL;
		_data_->_tmp85_ = json_object_get_string_member (_data_->_tmp84_, "expanded_url");
		_data_->_tmp86_ = NULL;
		_data_->_tmp86_ = g_strdup (_data_->_tmp85_);
		_data_->url = _data_->_tmp86_;
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = _data_->urls_object;
		_data_->_tmp88_ = FALSE;
		_data_->_tmp88_ = json_object_has_member (_data_->_tmp87_, "display_url");
		if (_data_->_tmp88_) {
			_data_->_tmp89_ = NULL;
			_data_->_tmp89_ = _data_->urls_object;
			_data_->_tmp90_ = NULL;
			_data_->_tmp90_ = json_object_get_string_member (_data_->_tmp89_, "expanded_url");
			_data_->_tmp91_ = NULL;
			_data_->_tmp91_ = g_strdup (_data_->_tmp90_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp91_;
		} else {
			_data_->_tmp92_ = NULL;
			_data_->_tmp92_ = _data_->urls_object;
			_data_->_tmp93_ = NULL;
			_data_->_tmp93_ = json_object_get_string_member (_data_->_tmp92_, "url");
			_data_->_tmp94_ = NULL;
			_data_->_tmp94_ = g_strdup (_data_->_tmp93_);
			_g_free0 (_data_->url);
			_data_->url = _data_->_tmp94_;
			_data_->_tmp95_ = NULL;
			_data_->_tmp95_ = _data_->url;
			_data_->_tmp96_ = NULL;
			_data_->_tmp96_ = g_strdup (_data_->_tmp95_);
			_g_free0 (_data_->display_url);
			_data_->display_url = _data_->_tmp96_;
		}
		_g_free0 (_data_->url);
		_json_object_unref0 (_data_->urls_object);
	}
	_data_->location = NULL;
	_data_->_tmp97_ = NULL;
	_data_->_tmp97_ = _data_->root;
	_data_->_tmp98_ = FALSE;
	_data_->_tmp98_ = json_object_has_member (_data_->_tmp97_, "location");
	if (_data_->_tmp98_) {
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = _data_->root;
		_data_->_tmp100_ = NULL;
		_data_->_tmp100_ = json_object_get_string_member (_data_->_tmp99_, "location");
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = g_strdup (_data_->_tmp100_);
		_g_free0 (_data_->location);
		_data_->location = _data_->_tmp101_;
	}
	_data_->_data23_->text_urls = NULL;
	_data_->_data23_->text_urls_length1 = 0;
	_data_->_data23_->_text_urls_size_ = _data_->_data23_->text_urls_length1;
	_data_->_tmp102_ = NULL;
	_data_->_tmp102_ = _data_->root;
	_data_->_tmp103_ = FALSE;
	_data_->_tmp103_ = json_object_has_member (_data_->_tmp102_, "description");
	if (_data_->_tmp103_) {
		_data_->_tmp104_ = NULL;
		_data_->_tmp104_ = _data_->entities;
		_data_->_tmp105_ = NULL;
		_data_->_tmp105_ = json_object_get_object_member (_data_->_tmp104_, "description");
		_data_->_tmp106_ = NULL;
		_data_->_tmp106_ = json_object_get_array_member (_data_->_tmp105_, "urls");
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = _json_array_ref0 (_data_->_tmp106_);
		_data_->urls = _data_->_tmp107_;
		_data_->_tmp108_ = NULL;
		_data_->_tmp108_ = _data_->urls;
		_data_->_tmp109_ = 0U;
		_data_->_tmp109_ = json_array_get_length (_data_->_tmp108_);
		_data_->_tmp110_ = NULL;
		_data_->_tmp110_ = g_new0 (CbTextEntity, _data_->_tmp109_);
		_data_->_data23_->text_urls = (_vala_CbTextEntity_array_free (_data_->_data23_->text_urls, _data_->_data23_->text_urls_length1), NULL);
		_data_->_data23_->text_urls = _data_->_tmp110_;
		_data_->_data23_->text_urls_length1 = _data_->_tmp109_;
		_data_->_data23_->_text_urls_size_ = _data_->_data23_->text_urls_length1;
		_data_->_tmp111_ = NULL;
		_data_->_tmp111_ = _data_->urls;
		json_array_foreach_element (_data_->_tmp111_, ____lambda177__json_array_foreach, _data_->_data23_);
		_json_array_unref0 (_data_->urls);
	}
	_data_->_tmp112_ = NULL;
	_data_->_tmp112_ = _data_->self->account;
	_data_->_tmp113_ = NULL;
	_data_->_tmp113_ = _data_->_tmp112_->user_counter;
	_data_->_tmp114_ = 0LL;
	_data_->_tmp114_ = _data_->id;
	_data_->_tmp115_ = NULL;
	_data_->_tmp115_ = _data_->screen_name;
	_data_->_tmp116_ = NULL;
	_data_->_tmp116_ = _data_->name;
	cb_user_counter_user_seen (_data_->_tmp113_, _data_->_tmp114_, _data_->_tmp115_, _data_->_tmp116_);
	_data_->_tmp117_ = NULL;
	_data_->_tmp117_ = _data_->self->priv->follow_button;
	_data_->_tmp118_ = FALSE;
	_data_->_tmp118_ = _data_->is_following;
	follow_button_set_following (_data_->_tmp117_, _data_->_tmp118_);
	_data_->_tmp119_ = NULL;
	_data_->_tmp119_ = _data_->self->priv->follow_button;
	_data_->_tmp120_ = 0LL;
	_data_->_tmp120_ = _data_->self->priv->user_id;
	_data_->_tmp121_ = NULL;
	_data_->_tmp121_ = _data_->self->account;
	_data_->_tmp122_ = 0LL;
	_data_->_tmp122_ = _data_->_tmp121_->id;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp119_, gtk_widget_get_type (), GtkWidget), _data_->_tmp120_ != _data_->_tmp122_);
	_data_->_tmp123_ = NULL;
	_data_->_tmp123_ = _data_->self->priv->more_button;
	_data_->_tmp124_ = NULL;
	_data_->_tmp124_ = gtk_menu_button_get_menu_model (_data_->_tmp123_);
	_data_->_tmp125_ = NULL;
	_data_->_tmp125_ = _data_->_tmp124_;
	_data_->_tmp126_ = NULL;
	_data_->_tmp126_ = g_menu_model_get_item_link (_data_->_tmp125_, 0, G_MENU_LINK_SECTION);
	_data_->section = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp126_, g_menu_get_type (), GMenu);
	_data_->_tmp127_ = NULL;
	_data_->_tmp127_ = _ ("Tweet to @%s");
	_data_->_tmp128_ = NULL;
	_data_->_tmp128_ = _data_->screen_name;
	_data_->_tmp129_ = NULL;
	_data_->_tmp129_ = string_replace (_data_->_tmp128_, "_", "__");
	_data_->_tmp130_ = NULL;
	_data_->_tmp130_ = _data_->_tmp129_;
	_data_->_tmp131_ = NULL;
	_data_->_tmp131_ = g_strdup_printf (_data_->_tmp127_, _data_->_tmp130_);
	_data_->_tmp132_ = NULL;
	_data_->_tmp132_ = _data_->_tmp131_;
	_data_->_tmp133_ = NULL;
	_data_->_tmp133_ = g_menu_item_new (_data_->_tmp132_, "user.tweet-to");
	_data_->_tmp134_ = NULL;
	_data_->_tmp134_ = _data_->_tmp133_;
	_g_free0 (_data_->_tmp132_);
	_g_free0 (_data_->_tmp130_);
	_data_->user_item = _data_->_tmp134_;
	_data_->_tmp135_ = NULL;
	_data_->_tmp135_ = _data_->section;
	g_menu_remove (_data_->_tmp135_, 1);
	_data_->_tmp136_ = NULL;
	_data_->_tmp136_ = _data_->section;
	_data_->_tmp137_ = NULL;
	_data_->_tmp137_ = _data_->user_item;
	g_menu_insert_item (_data_->_tmp136_, 1, _data_->_tmp137_);
	_data_->_tmp138_ = NULL;
	_data_->_tmp138_ = _data_->self->priv->name_label;
	_data_->_tmp139_ = NULL;
	_data_->_tmp139_ = _data_->name;
	_data_->_tmp140_ = NULL;
	_data_->_tmp140_ = string_strip (_data_->_tmp139_);
	_data_->_tmp141_ = NULL;
	_data_->_tmp141_ = _data_->_tmp140_;
	gtk_label_set_markup (_data_->_tmp138_, _data_->_tmp141_);
	_g_free0 (_data_->_tmp141_);
	_data_->_tmp142_ = NULL;
	_data_->_tmp142_ = _data_->self->priv->screen_name_label;
	_data_->_tmp143_ = NULL;
	_data_->_tmp143_ = _data_->screen_name;
	_data_->_tmp144_ = NULL;
	_data_->_tmp144_ = g_strconcat ("@", _data_->_tmp143_, NULL);
	_data_->_tmp145_ = NULL;
	_data_->_tmp145_ = _data_->_tmp144_;
	gtk_label_set_label (_data_->_tmp142_, _data_->_tmp145_);
	_g_free0 (_data_->_tmp145_);
	_data_->_tmp146_ = NULL;
	_data_->_tmp146_ = _data_->description;
	_data_->_tmp147_ = NULL;
	_data_->_tmp147_ = g_strdup (_data_->_tmp146_);
	_data_->desc = _data_->_tmp147_;
	_data_->_tmp148_ = NULL;
	_data_->_tmp148__length1 = 0;
	_data_->_tmp148_ = _data_->_data23_->text_urls;
	_data_->_tmp148__length1 = _data_->_data23_->text_urls_length1;
	if (_data_->_tmp148_ != NULL) {
		tweet_utils_sort_entities (&_data_->_data23_->text_urls, &_data_->_data23_->text_urls_length1);
		_data_->_tmp149_ = NULL;
		_data_->_tmp149_ = _data_->description;
		_data_->_tmp150_ = NULL;
		_data_->_tmp150__length1 = 0;
		_data_->_tmp150_ = _data_->_data23_->text_urls;
		_data_->_tmp150__length1 = _data_->_data23_->text_urls_length1;
		_data_->_tmp151_ = NULL;
		_data_->_tmp151_ = cb_text_transform_text (_data_->_tmp149_, _data_->_tmp150_, _data_->_tmp150__length1, (guint) 0, (gsize) 0, (gint64) 0);
		_g_free0 (_data_->desc);
		_data_->desc = _data_->_tmp151_;
	}
	_data_->_tmp152_ = 0;
	_data_->_tmp152_ = _data_->followers;
	_data_->self->priv->follower_count = _data_->_tmp152_;
	_data_->_tmp153_ = NULL;
	_data_->_tmp153_ = _data_->self->priv->description_label;
	_data_->_tmp154_ = NULL;
	_data_->_tmp154_ = _data_->desc;
	_data_->_tmp155_ = NULL;
	_data_->_tmp155_ = string_replace (_data_->_tmp154_, "&", "&amp;");
	_data_->_tmp156_ = NULL;
	_data_->_tmp156_ = _data_->_tmp155_;
	_data_->_tmp157_ = NULL;
	_data_->_tmp157_ = g_strdup_printf ("<big>%s</big>", _data_->_tmp156_);
	_data_->_tmp158_ = NULL;
	_data_->_tmp158_ = _data_->_tmp157_;
	gtk_label_set_label (_data_->_tmp153_, _data_->_tmp158_);
	_g_free0 (_data_->_tmp158_);
	_g_free0 (_data_->_tmp156_);
	_data_->_tmp159_ = NULL;
	_data_->_tmp159_ = _data_->self->priv->tweets_label;
	_data_->_tmp160_ = 0;
	_data_->_tmp160_ = _data_->tweets;
	_data_->_tmp161_ = NULL;
	_data_->_tmp161_ = g_strdup_printf ("%'d", _data_->_tmp160_);
	_data_->_tmp162_ = NULL;
	_data_->_tmp162_ = _data_->_tmp161_;
	gtk_label_set_label (_data_->_tmp159_, _data_->_tmp162_);
	_g_free0 (_data_->_tmp162_);
	_data_->_tmp163_ = NULL;
	_data_->_tmp163_ = _data_->self->priv->following_label;
	_data_->_tmp164_ = 0;
	_data_->_tmp164_ = _data_->following;
	_data_->_tmp165_ = NULL;
	_data_->_tmp165_ = g_strdup_printf ("%'d", _data_->_tmp164_);
	_data_->_tmp166_ = NULL;
	_data_->_tmp166_ = _data_->_tmp165_;
	gtk_label_set_label (_data_->_tmp163_, _data_->_tmp166_);
	_g_free0 (_data_->_tmp166_);
	profile_page_update_follower_label (_data_->self);
	_data_->_tmp168_ = NULL;
	_data_->_tmp168_ = _data_->location;
	if (_data_->_tmp168_ != NULL) {
		_data_->_tmp169_ = NULL;
		_data_->_tmp169_ = _data_->location;
		_data_->_tmp167_ = g_strcmp0 (_data_->_tmp169_, "") != 0;
	} else {
		_data_->_tmp167_ = FALSE;
	}
	if (_data_->_tmp167_) {
		_data_->_tmp170_ = NULL;
		_data_->_tmp170_ = _data_->self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp170_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp171_ = NULL;
		_data_->_tmp171_ = _data_->self->priv->location_label;
		_data_->_tmp172_ = NULL;
		_data_->_tmp172_ = _data_->location;
		gtk_label_set_label (_data_->_tmp171_, _data_->_tmp172_);
	} else {
		_data_->_tmp173_ = NULL;
		_data_->_tmp173_ = _data_->self->priv->location_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp173_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_data_->_tmp174_ = NULL;
	_data_->_tmp174_ = _data_->self->priv->avatar_image;
	_data_->_tmp175_ = FALSE;
	_data_->_tmp175_ = _data_->verified;
	avatar_widget_set_verified (_data_->_tmp174_, _data_->_tmp175_);
	_data_->_tmp176_ = NULL;
	_data_->_tmp176_ = _data_->display_url;
	_data_->_tmp177_ = 0;
	_data_->_tmp177_ = strlen (_data_->_tmp176_);
	_data_->_tmp178_ = 0;
	_data_->_tmp178_ = _data_->_tmp177_;
	if (_data_->_tmp178_ > 0) {
		_data_->_tmp179_ = NULL;
		_data_->_tmp179_ = _data_->self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp179_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp180_ = NULL;
		_data_->_tmp180_ = _data_->self->priv->url_label;
		_data_->_tmp181_ = NULL;
		_data_->_tmp181_ = _data_->display_url;
		_data_->_tmp182_ = NULL;
		_data_->_tmp182_ = _data_->display_url;
		_data_->_tmp183_ = NULL;
		_data_->_tmp183_ = g_strdup_printf ("<span underline='none'><a href='%s'>%s</a></span>", _data_->_tmp181_, _data_->_tmp182_);
		_data_->_tmp184_ = NULL;
		_data_->_tmp184_ = _data_->_tmp183_;
		gtk_label_set_markup (_data_->_tmp180_, _data_->_tmp184_);
		_g_free0 (_data_->_tmp184_);
		_data_->_tmp185_ = NULL;
		_data_->_tmp185_ = _data_->self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp185_, gtk_widget_get_type (), GtkWidget), 6);
	} else {
		_data_->_tmp186_ = NULL;
		_data_->_tmp186_ = _data_->self->priv->url_label;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp186_, gtk_widget_get_type (), GtkWidget), FALSE);
		_data_->_tmp187_ = NULL;
		_data_->_tmp187_ = _data_->self->priv->description_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp187_, gtk_widget_get_type (), GtkWidget), 12);
	}
	_data_->_tmp188_ = NULL;
	_data_->_tmp188_ = _data_->name;
	_data_->_tmp189_ = NULL;
	_data_->_tmp189_ = g_strdup (_data_->_tmp188_);
	_g_free0 (_data_->self->priv->name);
	_data_->self->priv->name = _data_->_tmp189_;
	_data_->_tmp190_ = NULL;
	_data_->_tmp190_ = _data_->screen_name;
	_data_->_tmp191_ = NULL;
	_data_->_tmp191_ = g_strdup (_data_->_tmp190_);
	_g_free0 (_data_->self->priv->screen_name);
	_data_->self->priv->screen_name = _data_->_tmp191_;
	_data_->_tmp192_ = NULL;
	_data_->_tmp192_ = _data_->avatar_url;
	_data_->_tmp193_ = NULL;
	_data_->_tmp193_ = g_strdup (_data_->_tmp192_);
	_g_free0 (_data_->self->priv->avatar_url);
	_data_->self->priv->avatar_url = _data_->_tmp193_;
	_g_free0 (_data_->desc);
	_g_object_unref0 (_data_->user_item);
	_g_object_unref0 (_data_->section);
	_g_free0 (_data_->location);
	_json_object_unref0 (_data_->entities);
	_g_free0 (_data_->display_url);
	_g_free0 (_data_->description);
	_g_free0 (_data_->screen_name);
	_g_free0 (_data_->name);
	_g_free0 (_data_->avatar_url);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	block23_data_unref (_data_->_data23_);
	_data_->_data23_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_tweets_data_free (gpointer _data) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadTweetsData, _data_);
}


static void profile_page_load_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadTweetsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_tweets);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_tweets_co (_data_);
}


static void profile_page_load_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_tweets_co (_data_);
}


static gboolean profile_page_load_tweets_co (ProfilePageLoadTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 10;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/statuses/user_timeline.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "GET");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->self->priv->user_id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp6_, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = 0;
	_data_->_tmp11_ = _data_->requested_tweet_count;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%i", _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "count", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "contributor_details", "true");
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp15_, "tweet_mode", "extended");
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp16_, "include_my_retweet", "true");
	_data_->root = NULL;
	{
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->call;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp18_, _data_->_tmp19_, profile_page_load_tweets_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp17_ = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp17_;
		_data_->_tmp17_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp21_;
		__vala_JsonNode_free0 (_data_->_tmp17_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		g_warning ("ProfilePage.vala:374: %s", _data_->_tmp23_);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp24_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally22:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->root;
	if (_data_->_tmp25_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_node_get_array (_data_->_tmp26_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _json_array_ref0 (_data_->_tmp27_);
	_data_->root_array = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->root_array;
	_data_->_tmp30_ = 0U;
	_data_->_tmp30_ = json_array_get_length (_data_->_tmp29_);
	if (_data_->_tmp30_ == ((guint) 0)) {
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp31_);
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->root_array;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->self->priv->tweet_list;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_);
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_older_tweets_data_free (gpointer _data) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadOlderTweetsData, _data_);
}


static void profile_page_load_older_tweets (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadOlderTweetsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_older_tweets);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_older_tweets_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_older_tweets_co (_data_);
}


static void profile_page_load_older_tweets_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_older_tweets_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadOlderTweetsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_older_tweets_co (_data_);
}


static gboolean profile_page_load_older_tweets_co (ProfilePageLoadOlderTweetsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->tweets_loading;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->user_stack;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = gtk_stack_get_visible_child (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->tweet_list;
	if (_data_->_tmp3_ != G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->tweets_loading = TRUE;
	_data_->requested_tweet_count = 15;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_->proxy;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp8_, "1.1/statuses/user_timeline.json");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp9_, "GET");
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = 0LL;
	_data_->_tmp11_ = _data_->self->priv->user_id;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "user_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = 0;
	_data_->_tmp15_ = _data_->requested_tweet_count;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup_printf ("%i", _data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "count", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp18_, "contributor_details", "true");
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp19_, "include_my_retweet", "true");
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->call;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->self->priv->tweet_list;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_tmp21_->model;
	_data_->_tmp23_ = 0LL;
	_data_->_tmp23_ = tweet_model_get_lowest_id (_data_->_tmp22_);
	_data_->_tmp24_ = 0LL;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp24_ - 1);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->_tmp25_;
	rest_proxy_call_add_param (_data_->_tmp20_, "max_id", _data_->_tmp26_);
	_g_free0 (_data_->_tmp26_);
	_data_->root = NULL;
	{
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->call;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->self->priv->data_cancellable;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp28_, _data_->_tmp29_, profile_page_load_older_tweets_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp27_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_tmp27_;
		_data_->_tmp27_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp31_;
		__vala_JsonNode_free0 (_data_->_tmp27_);
	}
	goto __finally23;
	__catch23_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->e;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->_tmp32_->message;
		g_warning ("ProfilePage.vala:414: %s", _data_->_tmp33_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally23:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->root;
	if (_data_->_tmp34_ == NULL) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->root;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = json_node_get_array (_data_->_tmp35_);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _json_array_ref0 (_data_->_tmp36_);
	_data_->root_arr = _data_->_tmp37_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->root_arr;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->self->priv->tweet_list;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_);
	_data_->self->priv->tweets_loading = FALSE;
	_json_array_unref0 (_data_->root_arr);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_followers_data_free (gpointer _data) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFollowersData, _data_);
}


static void profile_page_load_followers (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFollowersData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadFollowersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_followers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_followers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_followers_co (_data_);
}


static void profile_page_load_followers_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFollowersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_followers_co (_data_);
}


static void __lambda167_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node) {
	JsonObject* user_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp9_ = NULL;
	JsonObject* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	JsonObject* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonObject* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_ = NULL;
	TweetListBox* _tmp20_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	user_obj = _tmp2_;
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "profile_image_url");
	_tmp5_ = g_strdup (_tmp4_);
	avatar_url = _tmp5_;
	_tmp6_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp6_ == 2) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = avatar_url;
		_tmp8_ = string_replace (_tmp7_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp8_;
	}
	_tmp9_ = user_list_entry_new ();
	g_object_ref_sink (_tmp9_);
	entry = _tmp9_;
	user_list_entry_set_show_settings (entry, FALSE);
	_tmp10_ = user_obj;
	_tmp11_ = json_object_get_int_member (_tmp10_, "id");
	user_list_entry_set_user_id (entry, _tmp11_);
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_string_member (_tmp12_, "screen_name");
	_tmp14_ = g_strconcat ("@", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	user_list_entry_set_screen_name (entry, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "name");
	user_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = avatar_url;
	user_list_entry_set_avatar_url (entry, _tmp18_);
	_tmp19_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp19_, "tweet");
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->followers_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_free0 (avatar_url);
	_json_object_unref0 (user_obj);
}


static void ___lambda167__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda167_ ((ProfilePage*) self, array, index_, element_node);
}


static gboolean profile_page_load_followers_co (ProfilePageLoadFollowersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->followers_cursor;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->followers_cursor;
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = (*_data_->_tmp2_).full;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->self->priv->followers_loading;
	if (_data_->_tmp4_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->followers_loading = TRUE;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->self->priv->user_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->followers_cursor;
	_data_->_state_ = 1;
	user_utils_load_followers (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, profile_page_load_followers_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = user_utils_load_followers_finish (_data_->_res_);
	_cursor_free0 (_data_->self->priv->followers_cursor);
	_data_->self->priv->followers_cursor = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->self->priv->followers_cursor;
	if (_data_->_tmp9_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->followers_cursor;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = (*_data_->_tmp10_).json_object;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = json_node_get_array (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _json_array_ref0 (_data_->_tmp12_);
	_data_->users_array = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->users_array;
	json_array_foreach_element (_data_->_tmp14_, ___lambda167__json_array_foreach, _data_->self);
	_data_->self->priv->followers_loading = FALSE;
	_json_array_unref0 (_data_->users_array);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void profile_page_load_following_data_free (gpointer _data) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ProfilePageLoadFollowingData, _data_);
}


static void profile_page_load_following (ProfilePage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ProfilePageLoadFollowingData* _data_;
	ProfilePage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ProfilePageLoadFollowingData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, profile_page_load_following);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, profile_page_load_following_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	profile_page_load_following_co (_data_);
}


static void profile_page_load_following_finish (ProfilePage* self, GAsyncResult* _res_) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void profile_page_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ProfilePageLoadFollowingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	profile_page_load_following_co (_data_);
}


static void __lambda168_ (ProfilePage* self, JsonArray* array, guint index, JsonNode* node) {
	JsonObject* user_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp9_ = NULL;
	JsonObject* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	JsonObject* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonObject* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_ = NULL;
	TweetListBox* _tmp20_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	user_obj = _tmp2_;
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "profile_image_url");
	_tmp5_ = g_strdup (_tmp4_);
	avatar_url = _tmp5_;
	_tmp6_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp6_ == 2) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = avatar_url;
		_tmp8_ = string_replace (_tmp7_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp8_;
	}
	_tmp9_ = user_list_entry_new ();
	g_object_ref_sink (_tmp9_);
	entry = _tmp9_;
	user_list_entry_set_show_settings (entry, FALSE);
	_tmp10_ = user_obj;
	_tmp11_ = json_object_get_int_member (_tmp10_, "id");
	user_list_entry_set_user_id (entry, _tmp11_);
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_string_member (_tmp12_, "screen_name");
	_tmp14_ = g_strconcat ("@", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	user_list_entry_set_screen_name (entry, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "name");
	user_list_entry_set_name (entry, _tmp17_);
	_tmp18_ = avatar_url;
	user_list_entry_set_avatar_url (entry, _tmp18_);
	_tmp19_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp19_, "tweet");
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->following_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_free0 (avatar_url);
	_json_object_unref0 (user_obj);
}


static void ___lambda168__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda168_ ((ProfilePage*) self, array, index_, element_node);
}


static gboolean profile_page_load_following_co (ProfilePageLoadFollowingData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->following_cursor;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->following_cursor;
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = (*_data_->_tmp2_).full;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->self->priv->following_loading;
	if (_data_->_tmp4_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->following_loading = TRUE;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->account;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->self->priv->user_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->following_cursor;
	_data_->_state_ = 1;
	user_utils_load_following (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, profile_page_load_following_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = user_utils_load_following_finish (_data_->_res_);
	_cursor_free0 (_data_->self->priv->following_cursor);
	_data_->self->priv->following_cursor = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->self->priv->following_cursor;
	if (_data_->_tmp9_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->following_cursor;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = (*_data_->_tmp10_).json_object;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = json_node_get_array (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _json_array_ref0 (_data_->_tmp12_);
	_data_->users_array = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->users_array;
	json_array_foreach_element (_data_->_tmp14_, ___lambda168__json_array_foreach, _data_->self);
	_data_->self->priv->following_loading = FALSE;
	_json_array_unref0 (_data_->users_array);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __lambda176_ (ProfilePage* self, GObject* obj, GAsyncResult* res) {
	GdkPixbuf* banner = NULL;
	GAsyncResult* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = utils_download_pixbuf_finish (_tmp0_);
	banner = _tmp1_;
	profile_page_set_banner (self, banner);
	_g_object_unref0 (banner);
}


static void ___lambda176__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda176_ ((ProfilePage*) self, source_object, res);
	g_object_unref (self);
}


static void profile_page_load_profile_banner (ProfilePage* self, const gchar* base_url, gint64 user_id) {
	gchar* banner_url = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (base_url != NULL);
	_tmp0_ = base_url;
	_tmp1_ = g_strconcat (_tmp0_, "/mobile_retina", NULL);
	banner_url = _tmp1_;
	utils_download_pixbuf (banner_url, NULL, ___lambda176__gasync_ready_callback, g_object_ref (self));
	_g_free0 (banner_url);
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ProfilePage* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->call);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static void __lambda178_ (Block24Data* _data24_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	FollowButton* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data24_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		FollowButton* _tmp0_ = NULL;
		FollowButton* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		FollowButton* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		Account* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		RestProxyCall* _tmp8_ = NULL;
		GAsyncResult* _tmp9_ = NULL;
		_tmp0_ = self->priv->follow_button;
		_tmp1_ = self->priv->follow_button;
		_tmp2_ = follow_button_get_following (_tmp1_);
		_tmp3_ = _tmp2_;
		follow_button_set_following (_tmp0_, !_tmp3_);
		_tmp4_ = self->priv->follow_button;
		_tmp5_ = self->priv->user_id;
		_tmp6_ = self->account;
		_tmp7_ = _tmp6_->id;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_ != _tmp7_);
		_tmp8_ = _data24_->call;
		_tmp9_ = res;
		rest_proxy_call_invoke_finish (_tmp8_, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		RestProxyCall* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("ProfilePage.vala:549: %s", _tmp11_);
		_tmp12_ = _data24_->call;
		_tmp13_ = rest_proxy_call_get_payload (_tmp12_);
		g_critical ("ProfilePage.vala:550: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda178__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda178_ (self, source_object, res);
	block24_data_unref (self);
}


static void profile_page_follow_button_clicked_cb (ProfilePage* self) {
	Block24Data* _data24_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp3_ = NULL;
	IPage* _tmp4_ = NULL;
	FollowButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	FollowButton* _tmp35_ = NULL;
	RestProxyCall* _tmp36_ = NULL;
	RestProxyCall* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	RestProxyCall* _tmp41_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data24_->call = _tmp2_;
	_tmp3_ = self->priv->main_window;
	_tmp4_ = main_window_get_page (_tmp3_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp5_ = self->priv->follow_button;
	_tmp6_ = follow_button_get_following (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		RestProxyCall* _tmp8_ = NULL;
		HomeTimeline* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		HomeTimeline* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		gint _tmp13_ = 0;
		Account* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		GSimpleActionGroup* _tmp16_ = NULL;
		GAction* _tmp17_ = NULL;
		_tmp8_ = _data24_->call;
		rest_proxy_call_set_function (_tmp8_, "1.1/friendships/destroy.json");
		_tmp9_ = ht;
		_tmp10_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp9_, _tmp10_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp11_ = ht;
		_tmp12_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp11_, _tmp12_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp13_ = self->priv->follower_count;
		self->priv->follower_count = _tmp13_ - 1;
		_tmp14_ = self->account;
		_tmp15_ = self->priv->user_id;
		account_unfollow_id (_tmp14_, _tmp15_);
		_tmp16_ = self->priv->actions;
		_tmp17_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_simple_action_get_type (), GSimpleAction), FALSE);
		profile_page_set_retweets_disabled (self, FALSE);
	} else {
		RestProxyCall* _tmp18_ = NULL;
		RestProxyCall* _tmp19_ = NULL;
		HomeTimeline* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		GSimpleActionGroup* _tmp22_ = NULL;
		GAction* _tmp23_ = NULL;
		GVariant* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gint _tmp30_ = 0;
		Account* _tmp31_ = NULL;
		gint64 _tmp32_ = 0LL;
		GSimpleActionGroup* _tmp33_ = NULL;
		GAction* _tmp34_ = NULL;
		_tmp18_ = _data24_->call;
		rest_proxy_call_set_function (_tmp18_, "1.1/friendships/create.json");
		_tmp19_ = _data24_->call;
		rest_proxy_call_add_param (_tmp19_, "follow", "false");
		_tmp20_ = ht;
		_tmp21_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp20_, _tmp21_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		_tmp22_ = self->priv->actions;
		_tmp23_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		_tmp24_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
		_tmp25_ = _tmp24_;
		_tmp26_ = g_variant_get_boolean (_tmp25_);
		_tmp27_ = !_tmp26_;
		_g_variant_unref0 (_tmp25_);
		if (_tmp27_) {
			HomeTimeline* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			_tmp28_ = ht;
			_tmp29_ = self->priv->user_id;
			home_timeline_show_retweets_from (_tmp28_, _tmp29_, CB_TWEET_STATE_HIDDEN_UNFOLLOWED);
		}
		profile_page_set_user_blocked (self, FALSE);
		_tmp30_ = self->priv->follower_count;
		self->priv->follower_count = _tmp30_ + 1;
		_tmp31_ = self->account;
		_tmp32_ = self->priv->user_id;
		account_follow_id (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->actions;
		_tmp34_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_action_map_get_type (), GActionMap), "toggle-retweets");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction), TRUE);
	}
	profile_page_update_follower_label (self);
	_tmp35_ = self->priv->follow_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp36_ = _data24_->call;
	rest_proxy_call_set_method (_tmp36_, "POST");
	_tmp37_ = _data24_->call;
	_tmp38_ = self->priv->user_id;
	_tmp39_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp38_);
	_tmp40_ = _tmp39_;
	rest_proxy_call_add_param (_tmp37_, "id", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = _data24_->call;
	rest_proxy_call_invoke_async (_tmp41_, NULL, ___lambda178__gasync_ready_callback, block24_data_ref (_data24_));
	_g_object_unref0 (ht);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}


static void _profile_page_follow_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	profile_page_follow_button_clicked_cb ((ProfilePage*) self);
}


static gboolean profile_page_activate_link (ProfilePage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = tweet_utils_activate_link (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean _profile_page_activate_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = profile_page_activate_link ((ProfilePage*) self, uri);
	return result;
}


static inline void profile_page_set_banner (ProfilePage* self, GdkPixbuf* banner) {
	GdkPixbuf* _tmp0_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail ((banner == NULL) || GDK_IS_PIXBUF (banner));
	_tmp0_ = banner;
	if (_tmp0_ == NULL) {
		AspectImage* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		_tmp1_ = self->priv->banner_image;
		_tmp2_ = twitter_no_banner;
		aspect_image_set_pixbuf (_tmp1_, _tmp2_);
	} else {
		AspectImage* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		_tmp3_ = self->priv->banner_image;
		_tmp4_ = banner;
		aspect_image_set_pixbuf (_tmp3_, _tmp4_);
	}
}


/**
   * see IPage#onJoin
   */
static void profile_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	ProfilePage * self;
	gint64 user_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gchar* screen_name = NULL;
	Bundle* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GCancellable* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	TweetListBox* _tmp22_ = NULL;
	TweetListBox* _tmp23_ = NULL;
	TweetListBox* _tmp24_ = NULL;
	GtkRadioButton* _tmp25_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "user_id");
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) -1)) {
		return;
	}
	_tmp3_ = args;
	_tmp4_ = bundle_get_string (_tmp3_, "screen_name");
	screen_name = _tmp4_;
	_tmp5_ = screen_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = screen_name;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp7_;
	}
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->data_cancellable);
	self->priv->data_cancellable = _tmp8_;
	_tmp9_ = user_id;
	_tmp10_ = self->priv->user_id;
	if (_tmp9_ != _tmp10_) {
		TweetListBox* _tmp11_ = NULL;
		TweetListBox* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		Account* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		gboolean _tmp16_ = FALSE;
		TweetListBox* _tmp19_ = NULL;
		TweetModel* _tmp20_ = NULL;
		UserListsWidget* _tmp21_ = NULL;
		profile_page_reset_data (self);
		_cursor_free0 (self->priv->followers_cursor);
		self->priv->followers_cursor = NULL;
		_tmp11_ = self->priv->followers_list;
		tweet_list_box_remove_all (_tmp11_);
		_cursor_free0 (self->priv->following_cursor);
		self->priv->following_cursor = NULL;
		_tmp12_ = self->priv->following_list;
		tweet_list_box_remove_all (_tmp12_);
		_tmp13_ = user_id;
		profile_page_set_user_id (self, _tmp13_);
		_tmp14_ = self->account;
		_tmp15_ = user_id;
		_tmp16_ = account_follows_id (_tmp14_, _tmp15_);
		if (_tmp16_) {
			FollowButton* _tmp17_ = NULL;
			FollowButton* _tmp18_ = NULL;
			_tmp17_ = self->priv->follow_button;
			follow_button_set_following (_tmp17_, TRUE);
			_tmp18_ = self->priv->follow_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), TRUE);
		}
		_tmp19_ = self->priv->tweet_list;
		_tmp20_ = _tmp19_->model;
		tweet_model_clear (_tmp20_);
		_tmp21_ = self->priv->user_lists;
		user_lists_widget_clear_lists (_tmp21_);
		self->priv->lists_page_inited = FALSE;
		profile_page_load_tweets (self, NULL, NULL);
	} else {
		profile_page_load_friendship (self, NULL, NULL);
	}
	_tmp22_ = self->priv->tweet_list;
	tweet_list_box_reset_placeholder_text (_tmp22_);
	_tmp23_ = self->priv->followers_list;
	tweet_list_box_reset_placeholder_text (_tmp23_);
	_tmp24_ = self->priv->following_list;
	tweet_list_box_reset_placeholder_text (_tmp24_);
	_tmp25_ = self->priv->tweets_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_g_free0 (screen_name);
}


static void profile_page_real_on_leave (IPage* base) {
	ProfilePage * self;
	GCancellable* _tmp0_ = NULL;
	GtkMenuButton* _tmp1_ = NULL;
	GtkPopover* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->data_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->more_button;
	_tmp2_ = gtk_menu_button_get_popover (_tmp1_);
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
}


static void profile_page_reset_data (ProfilePage* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	AvatarWidget* _tmp8_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->name_label;
	gtk_label_set_label (_tmp0_, " ");
	_tmp1_ = self->priv->screen_name_label;
	gtk_label_set_label (_tmp1_, " ");
	_tmp2_ = self->priv->description_label;
	gtk_label_set_label (_tmp2_, " ");
	_tmp3_ = self->priv->url_label;
	gtk_label_set_label (_tmp3_, " ");
	_tmp4_ = self->priv->location_label;
	gtk_label_set_label (_tmp4_, " ");
	_tmp5_ = self->priv->tweets_label;
	gtk_label_set_label (_tmp5_, " ");
	_tmp6_ = self->priv->following_label;
	gtk_label_set_label (_tmp6_, " ");
	_tmp7_ = self->priv->followers_label;
	gtk_label_set_label (_tmp7_, " ");
	_tmp8_ = self->priv->avatar_image;
	avatar_widget_set_surface (_tmp8_, NULL);
}


static void profile_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static gchar* profile_page_real_get_title (IPage* base) {
	ProfilePage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->screen_name;
	_tmp1_ = g_strconcat ("@", _tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static GtkRadioButton* profile_page_real_get_radio_button (IPage* base) {
	ProfilePage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	result = NULL;
	return result;
}


static void profile_page_write_dm_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	MainWindow* _tmp7_ = NULL;
	MainWidget* _tmp8_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->priv->user_id;
	bundle_put_int64 (bundle, "sender_id", _tmp1_);
	_tmp2_ = self->priv->screen_name;
	bundle_put_string (bundle, "screen_name", _tmp2_);
	_tmp3_ = self->priv->name;
	bundle_put_string (bundle, "name", _tmp3_);
	_tmp4_ = self->priv->avatar_url;
	_tmp5_ = string_replace (_tmp4_, "_bigger", "_normal");
	_tmp6_ = _tmp5_;
	bundle_put_string (bundle, "avatar_url", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->main_window;
	_tmp8_ = _tmp7_->main_widget;
	main_widget_switch_page (_tmp8_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
}


static void profile_page_tweet_to_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	ComposeTweetWindow* cw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	ComposeTweetWindow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = compose_tweet_window_new (_tmp0_, _tmp1_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
	g_object_ref_sink (_tmp2_);
	cw = _tmp2_;
	_tmp3_ = self->priv->screen_name;
	_tmp4_ = g_strconcat ("@", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, " ", NULL);
	_tmp7_ = _tmp6_;
	compose_tweet_window_set_text (cw, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (cw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (cw);
}


static void profile_page_add_remove_list_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	UserListDialog* uld = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	UserListDialog* _tmp3_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->user_id;
	_tmp3_ = user_list_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	uld = _tmp3_;
	user_list_dialog_load_lists (uld);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (uld, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (uld);
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ProfilePage* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->call);
		_g_object_unref0 (_data25_->a);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void __lambda172_ (Block25Data* _data25_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data25_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data25_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		GSimpleAction* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		GVariant* _tmp9_ = NULL;
		GVariant* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data25_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 688, "ProfilePage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_tmp7_ = _data25_->a;
		_tmp8_ = _data25_->current_state;
		_tmp9_ = g_variant_new_boolean (_tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_simple_action_set_state (_tmp7_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->block_item_blocked = FALSE;
}


static void ___lambda172__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda172_ (self, source_object, res);
	block25_data_unref (self);
}


static void profile_page_toggle_blocked_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block25Data* _data25_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp4_ = NULL;
	IPage* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	OAuthProxy* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp22_ = FALSE;
	RestProxyCall* _tmp23_ = NULL;
	gint64 _tmp24_ = 0LL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RestProxyCall* _tmp27_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data25_->a);
	_data25_->a = _tmp1_;
	_tmp2_ = self->priv->block_item_blocked;
	if (_tmp2_) {
		block25_data_unref (_data25_);
		_data25_ = NULL;
		return;
	}
	self->priv->block_item_blocked = TRUE;
	_tmp3_ = profile_page_get_user_blocked (self);
	_data25_->current_state = _tmp3_;
	_tmp4_ = self->priv->main_window;
	_tmp5_ = main_window_get_page (_tmp4_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp6_ = self->account;
	_tmp7_ = _tmp6_->proxy;
	_tmp8_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, rest_proxy_get_type (), RestProxy));
	_data25_->call = _tmp8_;
	_tmp9_ = _data25_->call;
	rest_proxy_call_set_method (_tmp9_, "POST");
	_tmp10_ = _data25_->current_state;
	if (_tmp10_) {
		RestProxyCall* _tmp11_ = NULL;
		HomeTimeline* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp11_ = _data25_->call;
		rest_proxy_call_set_function (_tmp11_, "1.1/blocks/destroy.json");
		_tmp12_ = ht;
		_tmp13_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp12_, _tmp13_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
	} else {
		RestProxyCall* _tmp14_ = NULL;
		FollowButton* _tmp15_ = NULL;
		FollowButton* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		Account* _tmp18_ = NULL;
		gint64 _tmp19_ = 0LL;
		HomeTimeline* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		_tmp14_ = _data25_->call;
		rest_proxy_call_set_function (_tmp14_, "1.1/blocks/create.json");
		_tmp15_ = self->priv->follow_button;
		follow_button_set_following (_tmp15_, FALSE);
		_tmp16_ = self->priv->follow_button;
		_tmp17_ = self->priv->user_id;
		_tmp18_ = self->account;
		_tmp19_ = _tmp18_->id;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), _tmp17_ != _tmp19_);
		_tmp20_ = ht;
		_tmp21_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp20_, _tmp21_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
	}
	_tmp22_ = _data25_->current_state;
	profile_page_set_user_blocked (self, !_tmp22_);
	_tmp23_ = _data25_->call;
	_tmp24_ = self->priv->user_id;
	_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
	_tmp26_ = _tmp25_;
	rest_proxy_call_add_param (_tmp23_, "user_id", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = _data25_->call;
	rest_proxy_call_invoke_async (_tmp27_, NULL, ___lambda172__gasync_ready_callback, block25_data_ref (_data25_));
	_g_object_unref0 (ht);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ProfilePage* self;
		self = _data26_->self;
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}


static GVariant* _variant_new5 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda173_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GAsyncResult* _tmp0_ = NULL;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp1_ = NULL;
	IPage* _tmp2_ = NULL;
	self = _data26_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	user_utils_mute_user_finish (_tmp0_);
	self->priv->mute_item_blocked = FALSE;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = main_window_get_page (_tmp1_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_HOME_TIMELINE, HomeTimeline);
	if (_data26_->setting) {
		HomeTimeline* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		HomeTimeline* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		_tmp3_ = ht;
		_tmp4_ = self->priv->user_id;
		home_timeline_show_tweets_from (_tmp3_, _tmp4_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		_tmp5_ = ht;
		_tmp6_ = self->priv->user_id;
		home_timeline_show_retweets_from (_tmp5_, _tmp6_, CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
	} else {
		HomeTimeline* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		HomeTimeline* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp7_ = ht;
		_tmp8_ = self->priv->user_id;
		home_timeline_hide_tweets_from (_tmp7_, _tmp8_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		_tmp9_ = ht;
		_tmp10_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp9_, _tmp10_, CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
	}
	_g_object_unref0 (ht);
}


static void ___lambda173__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda173_ (self, source_object, res);
	block26_data_unref (self);
}


static void profile_page_toggle_muted_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block26Data* _data26_;
	gboolean _tmp0_ = FALSE;
	GSimpleAction* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = profile_page_get_user_muted (self);
	_data26_->setting = _tmp0_;
	self->priv->mute_item_blocked = TRUE;
	_tmp1_ = a;
	_tmp2_ = _variant_new5 (!_data26_->setting);
	g_simple_action_set_state (_tmp1_, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	_tmp3_ = self->account;
	_tmp4_ = self->priv->user_id;
	user_utils_mute_user (_tmp3_, _tmp4_, !_data26_->setting, ___lambda173__gasync_ready_callback, block26_data_ref (_data26_));
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ProfilePage* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->call);
		_g_object_unref0 (_data27_->a);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void __lambda174_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res) {
	ProfilePage* self;
	GError * _inner_error_ = NULL;
	self = _data27_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data27_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		GSimpleAction* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		GVariant* _tmp9_ = NULL;
		GVariant* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data27_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 740, "ProfilePage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_tmp7_ = _data27_->a;
		_tmp8_ = _data27_->current_state;
		_tmp9_ = g_variant_new_boolean (_tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_simple_action_set_state (_tmp7_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->retweet_item_blocked = FALSE;
}


static void ___lambda174__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda174_ (self, source_object, res);
	block27_data_unref (self);
}


static void profile_page_retweet_action_activated (ProfilePage* self, GSimpleAction* a, GVariant* v) {
	Block27Data* _data27_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GSimpleAction* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	Account* _tmp12_ = NULL;
	OAuthProxy* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	RestProxyCall* _tmp15_ = NULL;
	RestProxyCall* _tmp16_ = NULL;
	RestProxyCall* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	RestProxyCall* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	HomeTimeline* ht = NULL;
	MainWindow* _tmp25_ = NULL;
	IPage* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	RestProxyCall* _tmp36_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data27_->a);
	_data27_->a = _tmp1_;
	_tmp2_ = self->priv->retweet_item_blocked;
	if (_tmp2_) {
		block27_data_unref (_data27_);
		_data27_ = NULL;
		return;
	}
	self->priv->retweet_item_blocked = TRUE;
	_tmp3_ = _data27_->a;
	_tmp4_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_get_type (), GAction));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_boolean (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	_data27_->current_state = _tmp7_;
	_tmp8_ = _data27_->a;
	_tmp9_ = _data27_->current_state;
	_tmp10_ = g_variant_new_boolean (!_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_simple_action_set_state (_tmp8_, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = self->account;
	_tmp13_ = _tmp12_->proxy;
	_tmp14_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, rest_proxy_get_type (), RestProxy));
	_data27_->call = _tmp14_;
	_tmp15_ = _data27_->call;
	rest_proxy_call_set_function (_tmp15_, "1.1/friendships/update.json");
	_tmp16_ = _data27_->call;
	rest_proxy_call_set_method (_tmp16_, "POST");
	_tmp17_ = _data27_->call;
	_tmp18_ = self->priv->user_id;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
	_tmp20_ = _tmp19_;
	rest_proxy_call_add_param (_tmp17_, "user_id", _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = _data27_->call;
	_tmp22_ = _data27_->current_state;
	_tmp23_ = bool_to_string (_tmp22_);
	_tmp24_ = _tmp23_;
	rest_proxy_call_add_param (_tmp21_, "retweets", _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->main_window;
	_tmp26_ = main_window_get_page (_tmp25_, (gint) PAGE_STREAM);
	ht = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp27_ = _data27_->current_state;
	if (_tmp27_) {
		HomeTimeline* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		Account* _tmp30_ = NULL;
		gint64 _tmp31_ = 0LL;
		_tmp28_ = ht;
		_tmp29_ = self->priv->user_id;
		home_timeline_show_retweets_from (_tmp28_, _tmp29_, CB_TWEET_STATE_HIDDEN_RTS_DISABLED);
		_tmp30_ = self->account;
		_tmp31_ = self->priv->user_id;
		account_remove_disabled_rts_id (_tmp30_, _tmp31_);
	} else {
		HomeTimeline* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		Account* _tmp34_ = NULL;
		gint64 _tmp35_ = 0LL;
		_tmp32_ = ht;
		_tmp33_ = self->priv->user_id;
		home_timeline_hide_retweets_from (_tmp32_, _tmp33_, CB_TWEET_STATE_HIDDEN_RTS_DISABLED);
		_tmp34_ = self->account;
		_tmp35_ = self->priv->user_id;
		account_add_disabled_rts_id (_tmp34_, _tmp35_);
	}
	_tmp36_ = _data27_->call;
	rest_proxy_call_invoke_async (_tmp36_, NULL, ___lambda174__gasync_ready_callback, block27_data_ref (_data27_));
	_g_object_unref0 (ht);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


static void profile_page_set_user_blocked (ProfilePage* self, gboolean blocked) {
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = blocked;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static gboolean profile_page_get_user_blocked (ProfilePage* self) {
	gboolean result = FALSE;
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-blocked");
	_tmp2_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_boolean (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void profile_page_set_user_muted (ProfilePage* self, gboolean muted) {
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_tmp2_ = muted;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static gboolean profile_page_get_user_muted (ProfilePage* self) {
	gboolean result = FALSE;
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), FALSE);
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-muted");
	_tmp2_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), g_action_get_type (), GAction));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_boolean (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void profile_page_set_retweets_disabled (ProfilePage* self, gboolean disabled) {
	GSimpleActionGroup* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), "toggle-retweets");
	_tmp2_ = disabled;
	_tmp3_ = g_variant_new_boolean (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction), _tmp4_);
	_g_variant_unref0 (_tmp4_);
}


static void profile_page_update_follower_label (ProfilePage* self) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	_tmp0_ = self->priv->followers_label;
	_tmp1_ = self->priv->follower_count;
	_tmp2_ = g_strdup_printf ("%'d", _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


static void profile_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node) {
	ProfilePage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* user = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		JsonObject* _tmp6_ = NULL;
		JsonObject* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		CbTweet* tweet = NULL;
		CbTweet* _tmp10_ = NULL;
		CbTweet* _tmp11_ = NULL;
		JsonNode* _tmp12_ = NULL;
		Account* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		GDateTime* _tmp15_ = NULL;
		GDateTime* _tmp16_ = NULL;
		TweetListBox* _tmp17_ = NULL;
		TweetModel* _tmp18_ = NULL;
		CbTweet* _tmp19_ = NULL;
		_tmp1_ = root_node;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = _json_object_ref0 (_tmp2_);
		obj = _tmp3_;
		_tmp4_ = obj;
		_tmp5_ = json_object_get_object_member (_tmp4_, "user");
		_tmp6_ = _json_object_ref0 (_tmp5_);
		user = _tmp6_;
		_tmp7_ = user;
		_tmp8_ = json_object_get_int_member (_tmp7_, "id");
		_tmp9_ = self->priv->user_id;
		if (_tmp8_ != _tmp9_) {
			_json_object_unref0 (user);
			_json_object_unref0 (obj);
			return;
		}
		_tmp10_ = cb_tweet_new ();
		tweet = _tmp10_;
		_tmp11_ = tweet;
		_tmp12_ = root_node;
		_tmp13_ = self->account;
		_tmp14_ = _tmp13_->id;
		_tmp15_ = g_date_time_new_now_local ();
		_tmp16_ = _tmp15_;
		cb_tweet_load_from_json (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
		_g_date_time_unref0 (_tmp16_);
		_tmp17_ = self->priv->tweet_list;
		_tmp18_ = _tmp17_->model;
		_tmp19_ = tweet;
		tweet_model_add (_tmp18_, _tmp19_);
		_g_object_unref0 (tweet);
		_json_object_unref0 (user);
		_json_object_unref0 (obj);
	}
}


static void profile_page_tweets_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_ = NULL;
		TweetListBox* _tmp4_ = NULL;
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp3_ = self->priv->user_stack;
		_tmp4_ = self->priv->tweet_list;
		gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_tweets_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_followers_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Cursor* _tmp3_ = NULL;
		GtkStack* _tmp4_ = NULL;
		TweetListBox* _tmp5_ = NULL;
		_tmp3_ = self->priv->followers_cursor;
		if (_tmp3_ == NULL) {
			profile_page_load_followers (self, NULL, NULL);
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = self->priv->followers_list;
		gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_followers_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_following_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Cursor* _tmp3_ = NULL;
		GtkStack* _tmp4_ = NULL;
		TweetListBox* _tmp5_ = NULL;
		_tmp3_ = self->priv->following_cursor;
		if (_tmp3_ == NULL) {
			profile_page_load_following (self, NULL, NULL);
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp4_ = self->priv->user_stack;
		_tmp5_ = self->priv->following_list;
		gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_following_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_following_button_toggled_cb ((ProfilePage*) self, _sender);
}


static void profile_page_lists_button_toggled_cb (ProfilePage* self, GObject* source) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_PROFILE_PAGE (self));
	g_return_if_fail (G_IS_OBJECT (source));
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton), gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		GtkStack* _tmp6_ = NULL;
		UserListsWidget* _tmp7_ = NULL;
		_tmp3_ = self->priv->lists_page_inited;
		if (!_tmp3_) {
			UserListsWidget* _tmp4_ = NULL;
			gint64 _tmp5_ = 0LL;
			_tmp4_ = self->priv->user_lists;
			_tmp5_ = self->priv->user_id;
			user_lists_widget_load_lists (_tmp4_, _tmp5_, NULL, NULL);
			self->priv->lists_page_inited = TRUE;
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), BOTTOM);
		_tmp6_ = self->priv->user_stack;
		_tmp7_ = self->priv->user_lists;
		gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


static void _profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	profile_page_lists_button_toggled_cb ((ProfilePage*) self, _sender);
}


gint profile_page_get_unread_count (ProfilePage* self) {
	gint result;
	g_return_val_if_fail (IS_PROFILE_PAGE (self), 0);
	result = 0;
	return result;
}


static void profile_page_real_set_window (IPage* base, MainWindow* value) {
	ProfilePage* self;
	MainWindow* _tmp0_ = NULL;
	UserListsWidget* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	_tmp1_ = self->priv->user_lists;
	_tmp2_ = value;
	user_lists_widget_set_main_window (_tmp1_, _tmp2_);
	g_object_notify ((GObject *) self, "window");
}


static gint profile_page_real_get_id (IPage* base) {
	gint result;
	ProfilePage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void profile_page_real_set_id (IPage* base, gint value) {
	ProfilePage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROFILE_PAGE, ProfilePage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void profile_page_class_init (ProfilePageClass * klass) {
	gint ProfilePage_private_offset;
	profile_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ProfilePagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_profile_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_profile_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = profile_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROFILE_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ProfilePage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/profile-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "banner_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, banner_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "url_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, url_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweets_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "following_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, following_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "followers_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, followers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, location_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follow_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follow_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "followers_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, followers_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "following_list", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, following_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_spinner", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, progress_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "follows_you_label", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, follows_you_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_lists", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_lists));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, user_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "more_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, more_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_stack", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, loading_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_button", FALSE, ProfilePage_private_offset + G_STRUCT_OFFSET (ProfilePagePrivate, tweets_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "follow_button_clicked_cb", G_CALLBACK(_profile_page_follow_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "activate_link", G_CALLBACK(_profile_page_activate_link_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "tweets_button_toggled_cb", G_CALLBACK(_profile_page_tweets_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "followers_button_toggled_cb", G_CALLBACK(_profile_page_followers_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "following_button_toggled_cb", G_CALLBACK(_profile_page_following_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "lists_button_toggled_cb", G_CALLBACK(_profile_page_lists_button_toggled_cb_gtk_toggle_button_toggled));
}


static void profile_page_ipage_interface_init (IPageIface * iface) {
	profile_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) profile_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) profile_page_real_on_leave;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) profile_page_real_create_radio_button;
	iface->get_title = (gchar* (*)(IPage*)) profile_page_real_get_title;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) profile_page_real_get_radio_button;
	iface->set_window = profile_page_real_set_window;
	iface->get_id = profile_page_real_get_id;
	iface->set_id = profile_page_real_set_id;
}


static void profile_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	profile_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) profile_page_real_stream_message_received;
}


static void profile_page_instance_init (ProfilePage * self) {
	self->priv = PROFILE_PAGE_GET_PRIVATE (self);
	self->priv->follower_count = -1;
	self->priv->lists_page_inited = FALSE;
	self->priv->block_item_blocked = FALSE;
	self->priv->retweet_item_blocked = FALSE;
	self->priv->mute_item_blocked = FALSE;
	self->priv->tweets_loading = FALSE;
	self->priv->followers_loading = FALSE;
	self->priv->followers_cursor = NULL;
	self->priv->following_loading = FALSE;
	self->priv->following_cursor = NULL;
	g_type_ensure (TYPE_ASPECT_IMAGE);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_FOLLOW_BUTTON);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_USER_LISTS_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void profile_page_finalize (GObject* obj) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE_PAGE, ProfilePage);
	_g_object_unref0 (self->priv->banner_image);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->url_label);
	_g_object_unref0 (self->priv->tweets_label);
	_g_object_unref0 (self->priv->following_label);
	_g_object_unref0 (self->priv->followers_label);
	_g_object_unref0 (self->priv->location_label);
	_g_object_unref0 (self->priv->follow_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->followers_list);
	_g_object_unref0 (self->priv->following_list);
	_g_object_unref0 (self->priv->progress_spinner);
	_g_object_unref0 (self->priv->follows_you_label);
	_g_object_unref0 (self->priv->user_lists);
	_g_object_unref0 (self->priv->user_stack);
	_g_object_unref0 (self->priv->more_button);
	_g_object_unref0 (self->priv->loading_stack);
	_g_object_unref0 (self->priv->tweets_button);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->screen_name);
	_g_free0 (self->priv->avatar_url);
	_g_object_unref0 (self->priv->data_cancellable);
	_cursor_free0 (self->priv->followers_cursor);
	_cursor_free0 (self->priv->following_cursor);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (profile_page_parent_class)->finalize (obj);
}


GType profile_page_get_type (void) {
	static volatile gsize profile_page_type_id__volatile = 0;
	if (g_once_init_enter (&profile_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfilePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProfilePage), 0, (GInstanceInitFunc) profile_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) profile_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) profile_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType profile_page_type_id;
		profile_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ProfilePage", &g_define_type_info, 0);
		g_type_add_interface_static (profile_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (profile_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&profile_page_type_id__volatile, profile_page_type_id);
	}
	return profile_page_type_id__volatile;
}


static void _vala_profile_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_UNREAD_COUNT:
		g_value_set_int (value, profile_page_get_unread_count (self));
		break;
		case PROFILE_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_profile_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ProfilePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROFILE_PAGE, ProfilePage);
	switch (property_id) {
		case PROFILE_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case PROFILE_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



