/**
 * @file  NbioWorkaroundTbl.h
 * @brief This file contains the Nbio workaround configurations
 *
 */
/* Copyright 2022-2023 Advanced Micro Devices, Inc. All rights reserved.    */
// SPDX-License-Identifier: MIT

#pragma once

#define NBIO_TPH_TBL \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1337, \
    SIL_RESERVED2_1151 | \
    SIL_RESERVED2_1149, \
    (0x1 << SIL_RESERVED2_1153) | \
    (0x1 << SIL_RESERVED2_1150) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1389, \
    SIL_RESERVED2_1151 | \
    SIL_RESERVED2_1149, \
    (0x1 << SIL_RESERVED2_1153) | \
    (0x1 << SIL_RESERVED2_1150) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1432, \
    SIL_RESERVED2_1151 | \
    SIL_RESERVED2_1149, \
    (0x1 << SIL_RESERVED2_1153) | \
    (0x1 << SIL_RESERVED2_1150) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1343, \
    SIL_RESERVED2_1170 | \
    SIL_RESERVED2_1168, \
    (0x1 << SIL_RESERVED2_1171) | \
    (0x1 << SIL_RESERVED2_1169) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1395, \
    SIL_RESERVED2_1170 | \
    SIL_RESERVED2_1168, \
    (0x1 << SIL_RESERVED2_1171) | \
    (0x1 << SIL_RESERVED2_1169) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1436, \
    SIL_RESERVED2_1170 | \
    SIL_RESERVED2_1168, \
    (0x1 << SIL_RESERVED2_1171) | \
    (0x1 << SIL_RESERVED2_1169) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1346, \
    SIL_RESERVED2_1183 | \
    SIL_RESERVED2_1181, \
    (0x1 << SIL_RESERVED2_1184) | \
    (0x1 << SIL_RESERVED2_1182) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1399, \
    SIL_RESERVED2_1183 | \
    SIL_RESERVED2_1181, \
    (0x1 << SIL_RESERVED2_1184) | \
    (0x1 << SIL_RESERVED2_1182) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1438, \
    SIL_RESERVED2_1183 | \
    SIL_RESERVED2_1181, \
    (0x1 << SIL_RESERVED2_1184) | \
    (0x1 << SIL_RESERVED2_1182) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED3_1475, \
    SIL_RESERVED2_1189 | \
    SIL_RESERVED2_1187, \
    (0x1 << SIL_RESERVED2_1190) | \
    (0x1 << SIL_RESERVED2_1188) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1402, \
    SIL_RESERVED2_1189 | \
    SIL_RESERVED2_1187, \
    (0x1 << SIL_RESERVED2_1190) | \
    (0x1 << SIL_RESERVED2_1188) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1439, \
    SIL_RESERVED2_1189 | \
    SIL_RESERVED2_1187, \
    (0x1 << SIL_RESERVED2_1190) | \
    (0x1 << SIL_RESERVED2_1188) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1357, \
    SIL_RESERVED2_1232, \
    (0x1 << SIL_RESERVED3_1478) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1407, \
    SIL_RESERVED2_1232, \
    (0x1 << SIL_RESERVED3_1478) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1441, \
    SIL_RESERVED2_1232, \
    (0x1 << SIL_RESERVED3_1478) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED3_1481, \
    SIL_RESERVED3_1480 | \
    SIL_RESERVED2_1245, \
    (0x1 << SIL_RESERVED2_1246) | \
    (0x1 << SIL_RESERVED3_1479) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1410, \
    SIL_RESERVED3_1480 | \
    SIL_RESERVED2_1245, \
    (0x1 << SIL_RESERVED2_1246) | \
    (0x1 << SIL_RESERVED3_1479) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1443, \
    SIL_RESERVED3_1480 | \
    SIL_RESERVED2_1245, \
    (0x1 << SIL_RESERVED2_1246) | \
    (0x1 << SIL_RESERVED3_1479) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1359, \
    SIL_RESERVED2_1249, \
    (0x1 << SIL_RESERVED2_1250) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1412, \
    SIL_RESERVED2_1249, \
    (0x1 << SIL_RESERVED2_1250) \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_TPH_COMPLETER_ENABLED, \
    SIL_RESERVED2_1445, \
    SIL_RESERVED2_1249, \
    (0x1 << SIL_RESERVED2_1250) \
    ),

  #define NBIO_LCLK_DS_IDLE_TBL \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1320, \
    SIL_RESERVED2_1031, \
    0x1 << SIL_RESERVED2_1032 \
    ), \
  SMN_ENTRY_RMW (  \
    SIL_RESERVED2_1374, \
    SIL_RESERVED2_1031, \
    0x1 << SIL_RESERVED2_1032 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1421, \
    SIL_RESERVED2_1031, \
    0x1 << SIL_RESERVED2_1032 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1448, \
    SIL_RESERVED2_1087, \
    (0x1 << SIL_RESERVED2_1088) \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1448, \
    SIL_RESERVED2_1085, \
    (0x1 << SIL_RESERVED2_1086) \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1448, \
    SIL_RESERVED2_1090, \
    (0x1 << SIL_RESERVED2_1091) \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1448, \
    NTB_SMU_SDPPORTEN_SEC_CMPEN_MASK, \
    (0x1 << SIL_RESERVED2_1089) \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1423, \
    SIL_RESERVED2_1074, \
    (0x0 << SIL_RESERVED2_1075) \
    ),

#define NBIO_ENABLE_SOCCLK_SHUBCLK_DS_TBL \
   SMN_ENTRY_RMW ( \
     SIL_RESERVED2_1364, \
     SIL_RESERVED2_1454, \
     (0x1 << SIL_RESERVED2_1455) \
     ), \
   SMN_ENTRY_RMW ( \
     SIL_RESERVED2_1417, \
     SIL_RESERVED2_1454, \
     (0x1 << SIL_RESERVED2_1455) \
     ), \
 SMN_ENTRY_RMW ( \
   SIL_RESERVED2_1363, \
   SIL_RESERVED2_1453, \
   (0x1 << SYSHUB_DS_CTRL_SHUBCLK_SYSHUB_SHUBCLK_DS_EN_OFFSET) \
   ),

  #define NBIO_ENABLE_COMPLETION_TIMEOUT_TBL \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1355, \
      SIL_RESERVED3_1477, \
      (0x1 << SIL_RESERVED2_1215) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1405, \
      SIL_RESERVED3_1477, \
      (0x1 << SIL_RESERVED2_1215) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1440, \
      SIL_RESERVED3_1477, \
      (0x1 << SIL_RESERVED2_1215) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED3_1482, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1411, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1444, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1361, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1415, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1446, \
      SIL_RESERVED2_1247, \
      (0x1 << SIL_RESERVED2_1248) \
      ),

  #define NBIF_DEVICE_ID_DEV_TBL \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1327, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1380, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1425, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1367, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1419, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \
    SMN_ENTRY_RMW ( \
      SIL_RESERVED2_1447, \
      SIL_RESERVED2_1102, \
      (0x14DC << SIL_RESERVED2_1103) \
      ), \

