/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.system.UnixNativeUtils;

public class LinuxNativeUtils
extends UnixNativeUtils {
    public static final String LIBRARY_PREFIX_LINUX = "native/jnilib/linux/";
    public static final String LIBRARY_I386 = "linux.so";
    public static final String LIBRARY_AMD64 = "linux-amd64.so";
    private static final String PROC_MOUNTS_FILE = "/proc/mounts";
    public static final String[] POSSIBLE_BROWSER_LOCATIONS_LINUX = new String[]{"/usr/bin/firefox", "/usr/bin/mozilla-firefox", "/usr/local/firefox/firefox", "/opt/bin/firefox", "/usr/bin/mozilla", "/usr/local/mozilla/mozilla", "/opt/bin/mozilla"};
    public static final String[] FORBIDDEN_DELETING_FILES_LINUX = new String[0];

    LinuxNativeUtils() {
        String library;
        String arch = System.getProperty("os.arch");
        String string = arch.equals("amd64") ? LIBRARY_AMD64 : (library = arch.equals("i386") || arch.equals("x86") ? LIBRARY_I386 : null);
        if (library != null) {
            this.loadLibrary(LIBRARY_PREFIX_LINUX + library);
        }
        this.initializeForbiddenFiles(FORBIDDEN_DELETING_FILES_LINUX);
    }

    @Override
    public File getDefaultApplicationsLocation() {
        File usrlocal = new File("/usr/local");
        if (usrlocal.exists() && usrlocal.isDirectory() && FileUtils.canWrite(usrlocal)) {
            return usrlocal;
        }
        return SystemUtils.getUserHomeDirectory();
    }

    @Override
    public List<File> getFileSystemRoots(String ... files) throws IOException {
        List<File> roots = super.getFileSystemRoots(new String[0]);
        File mounts = new File(PROC_MOUNTS_FILE);
        try {
            if (FileUtils.exists(mounts) && FileUtils.canRead(mounts)) {
                List<String> strings = FileUtils.readStringList(mounts);
                for (int i = 0; i < strings.size(); ++i) {
                    File mountFile;
                    String mountPoint;
                    int nextSpaceIndex;
                    String line = strings.get(i).trim();
                    int firstSpaceIndex = line.indexOf(" ");
                    if (firstSpaceIndex == -1 || (nextSpaceIndex = (mountPoint = line.substring(firstSpaceIndex + 1).trim()).indexOf(" ")) == -1 || !(mountPoint = mountPoint.substring(0, nextSpaceIndex)).startsWith(File.separator) || roots.contains(mountFile = new File(mountPoint))) continue;
                    LogManager.log("... adding mount point from /proc/mounts: " + mountFile);
                    roots.add(mountFile);
                }
            }
        }
        catch (IOException e) {
            LogManager.log("... cannot read " + mounts, (Throwable)e);
        }
        return roots;
    }

    @Override
    protected Platform getPlatform() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("ppc")) {
            return SystemUtils.isCurrentJava64Bit() ? Platform.LINUX_PPC64 : Platform.LINUX_PPC;
        }
        if (osArch.contains("sparc")) {
            return Platform.LINUX_SPARC;
        }
        if (osArch.equals("ia64")) {
            return Platform.LINUX_IA64;
        }
        return SystemUtils.isCurrentJava64Bit() ? Platform.LINUX_X64 : Platform.LINUX_X86;
    }

    @Override
    protected String[] getPossibleBrowserLocations() {
        return POSSIBLE_BROWSER_LOCATIONS_LINUX;
    }
}

