/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.nodes;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.explorer.view.Visualizer;

public class Node {
    static final String linkSuffix = Bundle.getString("org.openide.loaders.Bundle", "FMT_shadowName", (Object[])new String[]{""});
    protected JTreeOperator treeOperator;
    protected TreePath treePath;
    protected String stringPath;
    private Operator.StringComparator comparator;

    public Node(JTreeOperator jTreeOperator, String string) {
        this(jTreeOperator, new NodesJTreeOperator(jTreeOperator).findPath(string, "|"));
    }

    public Node(JTreeOperator jTreeOperator, String string, String string2) {
        this(jTreeOperator, new NodesJTreeOperator(jTreeOperator).findPath(string, string2, "|"));
    }

    public Node(Node node, String string) {
        this(node.tree(), node.findSubPath(string, "|"));
    }

    public Node(Node node, int n) {
        this(node.tree(), node.tree().getChildPath(node.getTreePath(), n));
    }

    public Node(JTreeOperator jTreeOperator, TreePath treePath) {
        this.treeOperator = jTreeOperator.getClass().getName().endsWith("JTreeOperator") ? new NodesJTreeOperator(jTreeOperator) : jTreeOperator;
        this.treePath = treePath;
        this.stringPath = Node.convertPath(treePath);
    }

    public void setComparator(Operator.StringComparator stringComparator) {
        this.comparator = stringComparator;
        this.tree().setComparator(stringComparator);
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = this.tree().getComparator();
        }
        return this.comparator;
    }

    public JTreeOperator tree() {
        return this.treeOperator;
    }

    public TreePath getTreePath() {
        if (this.treePath.getLastPathComponent().toString().isEmpty() || this.tree().getRowForPath(this.treePath) < 0) {
            this.treePath = this.tree().findPath(this.stringPath);
        }
        return this.treePath;
    }

    public String getText() {
        return this.getTreePath().getLastPathComponent().toString();
    }

    private static String convertPath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        int n = treePath.getPathCount();
        if (n < 2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(treePath.getPathComponent(1).toString());
        for (int i = 2; i < n; ++i) {
            stringBuilder.append("|").append(treePath.getPathComponent(i).toString());
        }
        return stringBuilder.toString();
    }

    public String getPath() {
        return Node.convertPath(this.getTreePath());
    }

    public String getParentPath() {
        return Node.convertPath(this.getTreePath().getParentPath());
    }

    public Object getOpenideNode() {
        return Visualizer.findNode((Object)this.getTreePath().getLastPathComponent());
    }

    public JPopupMenuOperator callPopup() {
        return new JPopupMenuOperator(this.treeOperator.callPopupOnPath(this.getTreePath()));
    }

    public void performMenuAction(String string) {
        new Action(string, null).performMenu(this);
    }

    public void performPopupAction(String string) {
        new Action(null, string).performPopup(this);
    }

    public void performAPIAction(String string) {
        new Action(null, null, string).performAPI(this);
    }

    public void performMenuActionNoBlock(String string) {
        new ActionNoBlock(string, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String string) {
        new ActionNoBlock(null, string).performPopup(this);
    }

    public void performAPIActionNoBlock(String string) {
        new ActionNoBlock(null, null, string).performAPI(this);
    }

    public void select() {
        this.tree().selectPath(this.getTreePath());
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                throw new JemmyException("Sleeping interrupted", (Throwable)exception);
            }
            this.tree().clickOnPath(this.getTreePath());
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void addSelectionPath() {
        this.tree().addSelectionPath(this.getTreePath());
    }

    public boolean isLeaf() {
        return this.tree().getChildCount(this.getTreePath()) < 1;
    }

    public String[] getChildren() {
        this.tree().expandPath(this.getTreePath());
        Object[] objectArray = this.tree().getChildren(this.getTreePath().getLastPathComponent());
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public boolean isLink() {
        return this.getText().endsWith(linkSuffix);
    }

    public boolean isPresent() {
        this.tree().expandPath(this.treePath.getParentPath());
        int n = this.tree().getRowForPath(this.treePath);
        if (n < 0) {
            return false;
        }
        return this.treePath.equals(this.tree().getPathForRow(n));
    }

    public void verifyPopup(String string) {
        this.verifyPopup(new String[]{string});
    }

    public void verifyPopup(String[] stringArray) {
        final JPopupMenuOperator jPopupMenuOperator = this.callPopup();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                jPopupMenuOperator.showMenuItem(stringArray[i], "|");
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new JemmyException("Popup path [" + stringArray[i] + "] not found.");
            }
        }
        jPopupMenuOperator.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                jPopupMenuOperator.pushKey(27);
                return !jPopupMenuOperator.isVisible();
            }

            public String getDescription() {
                return "Popup menu closed";
            }
        });
    }

    TreePath findSubPath(String string, String string2) {
        return this.findSubPath(string, "", string2);
    }

    TreePath findSubPath(String string, String string2, String string3) {
        TreePath treePath;
        String[] stringArray = this.tree().parseString(string2, string3);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        try {
            treePath = this.tree().findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.getTreePath(), this.tree().parseString(string, string3), nArray, this.getComparator()));
        }
        catch (JTreeOperator.NoSuchPathException noSuchPathException) {
            treePath = this.tree().findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.getTreePath(), this.tree().parseString(string, string3), nArray, this.getComparator()));
        }
        return treePath;
    }

    public void expand() {
        this.treeOperator.expandPath(this.getTreePath());
        this.waitExpanded();
    }

    public void collapse() {
        this.treeOperator.collapsePath(this.getTreePath());
        this.waitCollapsed();
    }

    public void waitExpanded() {
        this.treeOperator.waitExpanded(this.getTreePath());
    }

    public void waitCollapsed() {
        this.treeOperator.waitCollapsed(this.getTreePath());
    }

    public boolean isExpanded() {
        return this.treeOperator.isExpanded(this.getTreePath());
    }

    public boolean isCollapsed() {
        return this.treeOperator.isCollapsed(this.getTreePath());
    }

    public void verifyPopup(Action[] actionArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < actionArray.length; ++i) {
            String string = actionArray[i].getPopupPath();
            if (string == null) continue;
            arrayList.add(string);
        }
        this.verifyPopup(arrayList.toArray(new String[0]));
    }

    public boolean isChildPresent(String string) {
        String[] stringArray = this.getChildren();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.getComparator().equals(stringArray[i], string)) continue;
            return true;
        }
        return false;
    }

    public void waitChildNotPresent(final String string) {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return Node.this.isChildPresent(string) ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Child \"" + string + "\" not present under parent \"" + Node.this.getPath() + "\"";
                }
            }).waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public void waitNotPresent() {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return Node.this.isPresent() ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Wait node " + Node.convertPath(Node.this.treePath) + " not present.";
                }
            }).waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    static {
        JellyVersion.checkJemmyVersion();
    }

    private static class NodesJTreeOperator
    extends JTreeOperator {
        public NodesJTreeOperator(JTreeOperator jTreeOperator) {
            super((JTree)jTreeOperator.getSource());
            this.copyEnvironment((Operator)jTreeOperator);
        }

        public void expandPath(final TreePath treePath) {
            super.expandPath(treePath);
            try {
                new Waiter(new Waitable(){

                    public Object actionProduced(Object object) {
                        try {
                            Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes(true);
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        return Boolean.TRUE;
                    }

                    public String getDescription() {
                        return "org.openide.nodes.Node.getChildren().getNodes(true)";
                    }
                }).waitAction(null);
            }
            catch (InterruptedException interruptedException) {
                throw new JemmyException("Interrupted.", (Throwable)interruptedException);
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                for (org.openide.nodes.Node node : Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes()) {
                    this.getOutput().printLine("    " + node.getDisplayName() + "  " + node);
                }
            }
        }
    }

    static class StringArraySubPathChooser
    implements JTreeOperator.TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;
        TreePath parentPath;
        int parentPathCount;

        StringArraySubPathChooser(TreePath treePath, String[] stringArray, int[] nArray, Operator.StringComparator stringComparator) {
            this.arr = stringArray;
            this.comparator = stringComparator;
            this.indices = nArray;
            this.parentPath = treePath;
            this.parentPathCount = treePath.getPathCount();
        }

        public boolean checkPath(TreePath treePath, int n) {
            return treePath.getPathCount() == this.arr.length + this.parentPathCount && this.hasAsParent(treePath, n);
        }

        public boolean hasAsParent(TreePath treePath, int n) {
            if (treePath.getPathCount() <= this.parentPathCount) {
                return treePath.isDescendant(this.parentPath);
            }
            if (this.arr.length + this.parentPathCount < treePath.getPathCount()) {
                return false;
            }
            if (this.indices.length >= treePath.getPathCount() - this.parentPathCount && this.indices[treePath.getPathCount() - this.parentPathCount - 1] != n) {
                return false;
            }
            Object[] objectArray = treePath.getPath();
            for (int i = this.parentPathCount; i < objectArray.length; ++i) {
                if (this.comparator.equals(objectArray[i].toString(), this.arr[i - this.parentPathCount])) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = this.parentPath.getPath();
            for (n = 0; n < objectArray.length; ++n) {
                stringBuilder.append(objectArray[n].toString()).append(", ");
            }
            for (n = 0; n < this.arr.length; ++n) {
                stringBuilder.append(this.arr[n]).append(", ");
            }
            String string = stringBuilder.toString();
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return "[ " + string + " ]";
        }
    }
}

