/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JsPkgCache {
    private final Map<String, Set<String>> props = new WeakHashMap<String, Set<String>>();
    private static final Map<ClassLoader, JsPkgCache> CACHE = new WeakHashMap<ClassLoader, JsPkgCache>();
    private static final Set<String> NONE = Collections.emptySet();
    private static final Logger LOG = Logger.getLogger(JsPkgCache.class.getName());

    JsPkgCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean process(ClassLoader l, String className) {
        Enumeration<URL> en;
        String pkgName;
        Set<String> p;
        JsPkgCache c;
        if (className.equals("org.netbeans.html.boot.impl.Test")) {
            return true;
        }
        Map<ClassLoader, JsPkgCache> map = CACHE;
        synchronized (map) {
            int lastDot;
            c = CACHE.get(l);
            if (c == null) {
                c = new JsPkgCache();
                CACHE.put(l, c);
            }
            if ((p = c.props.get(pkgName = className.substring(0, (lastDot = className.lastIndexOf(46)) + 1).replace('.', '/'))) == NONE) {
                return false;
            }
            if (p != null) {
                return p.contains(className);
            }
        }
        String res = pkgName + "net.java.html.js.classes";
        try {
            en = l.getResources(res);
        }
        catch (IOException ex) {
            en = null;
        }
        if (en == null || !en.hasMoreElements()) {
            Map<ClassLoader, JsPkgCache> ex = CACHE;
            synchronized (ex) {
                c.props.put(pkgName, NONE);
                return false;
            }
        }
        try {
            TreeSet<String> arr = new TreeSet<String>();
            while (en.hasMoreElements()) {
                String line;
                URL u = en.nextElement();
                BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    arr.add(line);
                }
                r.close();
            }
            p = arr;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Can't read " + res, ex);
            p = NONE;
        }
        Map<ClassLoader, JsPkgCache> map2 = CACHE;
        synchronized (map2) {
            c.props.put(pkgName, p);
            return p.contains(className);
        }
    }
}

