/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.Arrays;

public final class Graph {
    private int size;
    private boolean[][] adjacentMatrix;

    public Graph(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.adjacentMatrix = new boolean[size][size];
    }

    public int getSize() {
        return this.size;
    }

    public boolean[][] getData() {
        boolean[][] res = new boolean[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            System.arraycopy(this.adjacentMatrix[i], 0, res[i], 0, this.size);
        }
        return res;
    }

    public boolean[] getData(int i) {
        return Arrays.copyOf(this.adjacentMatrix[i], this.size);
    }

    public void addEdge(int source, int destination) {
        if (source < 0 || destination < 0) {
            throw new IllegalArgumentException();
        }
        if (source >= this.size || destination >= this.size) {
            int newSize = Math.max(source, destination) + 1;
            boolean[][] newAdjacentMatrix = new boolean[newSize][newSize];
            for (int i = 0; i < this.size; ++i) {
                System.arraycopy(this.adjacentMatrix[i], 0, newAdjacentMatrix[i], 0, this.size);
            }
            this.size = newSize;
            this.adjacentMatrix = newAdjacentMatrix;
        }
        this.adjacentMatrix[source][destination] = true;
    }

    public void removeEdge(int source, int destination) {
        if (source < 0 || destination < 0) {
            throw new IllegalArgumentException();
        }
        if (source < this.size && destination < this.size) {
            this.adjacentMatrix[source][destination] = false;
        }
    }

    public boolean isEdge(int source, int destination) {
        if (source < 0 || destination < 0) {
            throw new IllegalArgumentException();
        }
        if (destination < this.size && source < this.size) {
            return this.adjacentMatrix[source][destination];
        }
        return false;
    }
}

