
<p align="center">
    <a href="https://croct.com">
        <img src="https://cdn.croct.io/brand/logo/repo-icon-green.svg" alt="Croct" height="80"/>
    </a>
    <br />
    <strong>JSON</strong>
    <br />
    Strong JSON typing for TypeScript
</p>
<p align="center">
    <a href="https://www.npmjs.com/package/@croct/json"><img alt="Version" src="https://img.shields.io/npm/v/@croct/json"/></a>
    <a href="https://github.com/croct-tech/json-js/actions/workflows/validate-branch.yaml"><img alt="Build" src="https://github.com/croct-tech/json-js/actions/workflows/validate-branch.yaml/badge.svg" /></a>
    <a href="https://codeclimate.com/repos/6227dfa7885dee01b6001407/maintainability"><img src="https://api.codeclimate.com/v1/badges/dd55cccbb345907fe572/maintainability" /></a>
    <br />
    <br />
    <a href="https://github.com/croct-tech/json-js/releases">📦 Releases</a>
    ·
    <a href="https://github.com/croct-tech/json-js/issues/new?labels=bug&template=bug-report.md">🐞 Report Bug</a>
    ·
    <a href="https://github.com/croct-tech/json-js/issues/new?labels=enhancement&template=feature-request.md">✨ Request Feature</a>
</p>

## Introduction

This library provides types for representing arbitrary data types, both strictly and loosely (JSON-compatible).

## Installation

We recommend using [NPM](https://www.npmjs.com) to install the package:

```sh
npm install @croct/json
```

## Overview

The types in this library include:

- Types for representing valid JSON values
- Types for representing values that can be safely serialized to JSON using `JSON.stringify()`
- An interface for classes that can serialize to JSON

See the [source code](src/mutable.ts) for more information.

## Contributing

Contributions to the package are always welcome! 

- Report any bugs or issues on the [issue tracker](https://github.com/croct-tech/json-ts/issues).
- For major changes, please [open an issue](https://github.com/croct-tech/json-ts/issues) first to discuss what you would like to change.
- Please make sure to update tests as appropriate.

## Building

Before building the project, the dependencies must be installed:

```sh
npm install
```

The following command builds the library:

```
npm run build
```

## License

Copyright © 2015-2021 Croct Limited, All Rights Reserved.

All information contained herein is, and remains the property of Croct Limited. The intellectual, design and technical concepts contained herein are proprietary to Croct Limited s and may be covered by U.S. and Foreign Patents, patents in process, and are protected by trade secret or copyright law. Dissemination of this information or reproduction of this material is strictly forbidden unless prior written permission is obtained from Croct Limited.
