import { ax } from '../runtime';
/**
 * ## CX
 *
 * Use in conjunction with the {@link XCSSProp} to concatenate and conditionally apply
 * declared styles. Can only be used with the `cssMap()` and {@link XCSSProp} APIs.
 *
 * @example
 * ```
 * const styles = cssMap({
 *  text: { color: 'var(--ds-text)' },
 *  primary: { color: 'var(--ds-text-brand)' },
 * });
 *
 * <Component xcss={cx(isPrimary && styles.text, !isPrimary && styles.primary)} />
 * ```
 */
export const cx = (...styles) => {
    // At runtime TStyles is resolved down to strings, but not at compile time.
    // We circumvent the type system here because of that.
    const actualStyles = styles;
    // The output should be a union type of passed in styles. This ensures the call
    // site of xcss prop can raise violations when disallowed styles have been passed.
    return ax(actualStyles);
};
//# sourceMappingURL=index.js.map