/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type FC } from 'react';
import type { VisuallyHiddenProps } from './types';
/**
 * __Visually hidden__
 *
 * A composable element to apply a visually hidden effect to children.
 * Useful for accessibility compliance.
 *
 * @example
 * ```jsx
 * import VisuallyHidden from '@atlaskit/visually-hidden';
 *
 * export default () => (
 *   <div style={{ border: '1px solid black' }}>
 *      There is text hidden between the brackets [
 *      <VisuallyHidden>Can't see me!</VisuallyHidden>]
 *   </div>
 * );
 * ```
 */
declare const VisuallyHidden: FC<VisuallyHiddenProps>;
export default VisuallyHidden;
