## TFSA-2021-078: Heap OOB read in TFLite's implementation of `Minimum` or `Maximum`

### CVE Number
CVE-2021-29590

### Impact
The implementations of the `Minimum` and `Maximum` TFLite operators can be used
to read data outside of bounds of heap allocated objects, if any of the two
input tensor arguments are empty.

This is because [the broadcasting
implementation](https://github.com/tensorflow/tensorflow/blob/0d45ea1ca641b21b73bcf9c00e0179cda284e7e7/tensorflow/lite/kernels/internal/reference/maximum_minimum.h#L52-L56)
indexes in both tensors with the same index but does not validate that the index
is within bounds:

```cc
auto maxmin_func = [&](int indexes[N]) {
  output_data[SubscriptToIndex(output_desc, indexes)] =
    op(input1_data[SubscriptToIndex(desc1, indexes)],
        input2_data[SubscriptToIndex(desc2, indexes)]);
};
```

### Patches
We have patched the issue in GitHub commit
[953f28dca13c92839ba389c055587cfe6c723578](https://github.com/tensorflow/tensorflow/commit/953f28dca13c92839ba389c055587cfe6c723578).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
