/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2020 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#pragma once

// for GL on mac we need to define the functions we want to hook at compile time for dyld hooking to
// work, but this also means we can only hook functions that actually exist. Fortunately GL on mac
// is not a moving target, so we can define the list of functions in the latest version of macOS and
// as long as someone doesn't compile on an older version (old enough that some of these functions
// are missing) it will work.
//
// TL;DR: this is a *manually curated* list and must not be modified without understanding.

#define ForEachAppleSupported()                         \
  APPLE_FUNC(glActiveShaderProgram);                    \
  APPLE_FUNC(glActiveTexture);                          \
  APPLE_FUNC(glActiveTextureARB);                       \
  APPLE_FUNC(glAttachShader);                           \
  APPLE_FUNC(glBeginConditionalRender);                 \
  APPLE_FUNC(glBeginQuery);                             \
  APPLE_FUNC(glBeginQueryARB);                          \
  APPLE_FUNC(glBeginQueryIndexed);                      \
  APPLE_FUNC(glBeginTransformFeedback);                 \
  APPLE_FUNC(glBeginTransformFeedbackEXT);              \
  APPLE_FUNC(glBindAttribLocation);                     \
  APPLE_FUNC(glBindAttribLocationARB);                  \
  APPLE_FUNC(glBindBuffer);                             \
  APPLE_FUNC(glBindBufferARB);                          \
  APPLE_FUNC(glBindBufferBase);                         \
  APPLE_FUNC(glBindBufferBaseEXT);                      \
  APPLE_FUNC(glBindBufferRange);                        \
  APPLE_FUNC(glBindBufferRangeEXT);                     \
  APPLE_FUNC(glBindFragDataLocation);                   \
  APPLE_FUNC(glBindFragDataLocationEXT);                \
  APPLE_FUNC(glBindFragDataLocationIndexed);            \
  APPLE_FUNC(glBindFramebuffer);                        \
  APPLE_FUNC(glBindFramebufferEXT);                     \
  APPLE_FUNC(glBindProgramARB);                         \
  APPLE_FUNC(glBindProgramPipeline);                    \
  APPLE_FUNC(glBindRenderbuffer);                       \
  APPLE_FUNC(glBindRenderbufferEXT);                    \
  APPLE_FUNC(glBindSampler);                            \
  APPLE_FUNC(glBindTexture);                            \
  APPLE_FUNC(glBindTransformFeedback);                  \
  APPLE_FUNC(glBindVertexArray);                        \
  APPLE_FUNC(glBlendColor);                             \
  APPLE_FUNC(glBlendColorEXT);                          \
  APPLE_FUNC(glBlendEquation);                          \
  APPLE_FUNC(glBlendEquationEXT);                       \
  APPLE_FUNC(glBlendEquationi);                         \
  APPLE_FUNC(glBlendEquationiARB);                      \
  APPLE_FUNC(glBlendEquationSeparate);                  \
  APPLE_FUNC(glBlendEquationSeparateEXT);               \
  APPLE_FUNC(glBlendEquationSeparatei);                 \
  APPLE_FUNC(glBlendEquationSeparateiARB);              \
  APPLE_FUNC(glBlendFunc);                              \
  APPLE_FUNC(glBlendFunci);                             \
  APPLE_FUNC(glBlendFunciARB);                          \
  APPLE_FUNC(glBlendFuncSeparate);                      \
  APPLE_FUNC(glBlendFuncSeparateEXT);                   \
  APPLE_FUNC(glBlendFuncSeparatei);                     \
  APPLE_FUNC(glBlendFuncSeparateiARB);                  \
  APPLE_FUNC(glBlitFramebuffer);                        \
  APPLE_FUNC(glBlitFramebufferEXT);                     \
  APPLE_FUNC(glBufferData);                             \
  APPLE_FUNC(glBufferDataARB);                          \
  APPLE_FUNC(glBufferSubData);                          \
  APPLE_FUNC(glBufferSubDataARB);                       \
  APPLE_FUNC(glCheckFramebufferStatus);                 \
  APPLE_FUNC(glCheckFramebufferStatusEXT);              \
  APPLE_FUNC(glClampColor);                             \
  APPLE_FUNC(glClampColorARB);                          \
  APPLE_FUNC(glClear);                                  \
  APPLE_FUNC(glClearBufferfi);                          \
  APPLE_FUNC(glClearBufferfv);                          \
  APPLE_FUNC(glClearBufferiv);                          \
  APPLE_FUNC(glClearBufferuiv);                         \
  APPLE_FUNC(glClearColor);                             \
  APPLE_FUNC(glClearColorIiEXT);                        \
  APPLE_FUNC(glClearColorIuiEXT);                       \
  APPLE_FUNC(glClearDepth);                             \
  APPLE_FUNC(glClearDepthf);                            \
  APPLE_FUNC(glClearStencil);                           \
  APPLE_FUNC(glClientWaitSync);                         \
  APPLE_FUNC(glColorMask);                              \
  APPLE_FUNC(glColorMaski);                             \
  APPLE_FUNC(glColorMaskIndexedEXT);                    \
  APPLE_FUNC(glCompileShader);                          \
  APPLE_FUNC(glCompileShaderARB);                       \
  APPLE_FUNC(glCompileShaderIncludeARB);                \
  APPLE_FUNC(glCompressedTexImage1D);                   \
  APPLE_FUNC(glCompressedTexImage1DARB);                \
  APPLE_FUNC(glCompressedTexImage2D);                   \
  APPLE_FUNC(glCompressedTexImage2DARB);                \
  APPLE_FUNC(glCompressedTexImage3D);                   \
  APPLE_FUNC(glCompressedTexImage3DARB);                \
  APPLE_FUNC(glCompressedTexSubImage1D);                \
  APPLE_FUNC(glCompressedTexSubImage1DARB);             \
  APPLE_FUNC(glCompressedTexSubImage2D);                \
  APPLE_FUNC(glCompressedTexSubImage2DARB);             \
  APPLE_FUNC(glCompressedTexSubImage3D);                \
  APPLE_FUNC(glCompressedTexSubImage3DARB);             \
  APPLE_FUNC(glCopyBufferSubData);                      \
  APPLE_FUNC(glCopyTexImage1D);                         \
  APPLE_FUNC(glCopyTexImage2D);                         \
  APPLE_FUNC(glCopyTexSubImage1D);                      \
  APPLE_FUNC(glCopyTexSubImage2D);                      \
  APPLE_FUNC(glCopyTexSubImage3D);                      \
  APPLE_FUNC(glCreateProgram);                          \
  APPLE_FUNC(glCreateProgramObjectARB);                 \
  APPLE_FUNC(glCreateShader);                           \
  APPLE_FUNC(glCreateShaderObjectARB);                  \
  APPLE_FUNC(glCreateShaderProgramv);                   \
  APPLE_FUNC(glCullFace);                               \
  APPLE_FUNC(glDeleteBuffers);                          \
  APPLE_FUNC(glDeleteBuffersARB);                       \
  APPLE_FUNC(glDeleteFramebuffers);                     \
  APPLE_FUNC(glDeleteFramebuffersEXT);                  \
  APPLE_FUNC(glDeleteNamedStringARB);                   \
  APPLE_FUNC(glDeleteProgram);                          \
  APPLE_FUNC(glDeleteProgramPipelines);                 \
  APPLE_FUNC(glDeleteProgramsARB);                      \
  APPLE_FUNC(glDeleteQueries);                          \
  APPLE_FUNC(glDeleteQueriesARB);                       \
  APPLE_FUNC(glDeleteRenderbuffers);                    \
  APPLE_FUNC(glDeleteRenderbuffersEXT);                 \
  APPLE_FUNC(glDeleteSamplers);                         \
  APPLE_FUNC(glDeleteShader);                           \
  APPLE_FUNC(glDeleteTextures);                         \
  APPLE_FUNC(glDeleteTransformFeedbacks);               \
  APPLE_FUNC(glDeleteVertexArrays);                     \
  APPLE_FUNC(glDepthFunc);                              \
  APPLE_FUNC(glDepthMask);                              \
  APPLE_FUNC(glDepthRange);                             \
  APPLE_FUNC(glDepthRangeArrayv);                       \
  APPLE_FUNC(glDepthRangef);                            \
  APPLE_FUNC(glDeleteSync);                             \
  APPLE_FUNC(glDepthBoundsEXT);                         \
  APPLE_FUNC(glDepthRangeIndexed);                      \
  APPLE_FUNC(glDetachObjectARB);                        \
  APPLE_FUNC(glDetachShader);                           \
  APPLE_FUNC(glDisable);                                \
  APPLE_FUNC(glDisablei);                               \
  APPLE_FUNC(glDisableIndexedEXT);                      \
  APPLE_FUNC(glDisableVertexAttribArray);               \
  APPLE_FUNC(glDisableVertexAttribArrayARB);            \
  APPLE_FUNC(glDrawArrays);                             \
  APPLE_FUNC(glDrawArraysIndirect);                     \
  APPLE_FUNC(glDrawArraysInstanced);                    \
  APPLE_FUNC(glDrawArraysInstancedARB);                 \
  APPLE_FUNC(glDrawBuffer);                             \
  APPLE_FUNC(glDrawBuffers);                            \
  APPLE_FUNC(glDrawBuffersARB);                         \
  APPLE_FUNC(glDrawElements);                           \
  APPLE_FUNC(glDrawElementsBaseVertex);                 \
  APPLE_FUNC(glDrawElementsIndirect);                   \
  APPLE_FUNC(glDrawElementsInstanced);                  \
  APPLE_FUNC(glDrawElementsInstancedARB);               \
  APPLE_FUNC(glDrawElementsInstancedBaseVertex);        \
  APPLE_FUNC(glDrawRangeElements);                      \
  APPLE_FUNC(glDrawRangeElementsBaseVertex);            \
  APPLE_FUNC(glDrawRangeElementsEXT);                   \
  APPLE_FUNC(glDrawTransformFeedback);                  \
  APPLE_FUNC(glDrawTransformFeedbackStream);            \
  APPLE_FUNC(glEnable);                                 \
  APPLE_FUNC(glEnablei);                                \
  APPLE_FUNC(glEnableIndexedEXT);                       \
  APPLE_FUNC(glEnableVertexAttribArray);                \
  APPLE_FUNC(glEnableVertexAttribArrayARB);             \
  APPLE_FUNC(glEndConditionalRender);                   \
  APPLE_FUNC(glEndConditionalRenderNV);                 \
  APPLE_FUNC(glEndQuery);                               \
  APPLE_FUNC(glEndQueryARB);                            \
  APPLE_FUNC(glEndQueryIndexed);                        \
  APPLE_FUNC(glEndTransformFeedback);                   \
  APPLE_FUNC(glEndTransformFeedbackEXT);                \
  APPLE_FUNC(glFenceSync);                              \
  APPLE_FUNC(glFinish);                                 \
  APPLE_FUNC(glFlush);                                  \
  APPLE_FUNC(glFlushMappedBufferRange);                 \
  APPLE_FUNC(glFramebufferRenderbuffer);                \
  APPLE_FUNC(glFramebufferRenderbufferEXT);             \
  APPLE_FUNC(glFramebufferTexture);                     \
  APPLE_FUNC(glFramebufferTexture1D);                   \
  APPLE_FUNC(glFramebufferTexture1DEXT);                \
  APPLE_FUNC(glFramebufferTexture2D);                   \
  APPLE_FUNC(glFramebufferTexture2DEXT);                \
  APPLE_FUNC(glFramebufferTexture3D);                   \
  APPLE_FUNC(glFramebufferTexture3DEXT);                \
  APPLE_FUNC(glFramebufferTextureEXT);                  \
  APPLE_FUNC(glFramebufferTextureFaceEXT);              \
  APPLE_FUNC(glFramebufferTextureLayer);                \
  APPLE_FUNC(glFramebufferTextureLayerEXT);             \
  APPLE_FUNC(glFrontFace);                              \
  APPLE_FUNC(glGenBuffers);                             \
  APPLE_FUNC(glGenBuffersARB);                          \
  APPLE_FUNC(glGenerateMipmap);                         \
  APPLE_FUNC(glGenerateMipmapEXT);                      \
  APPLE_FUNC(glGenFramebuffers);                        \
  APPLE_FUNC(glGenFramebuffersEXT);                     \
  APPLE_FUNC(glGenProgramPipelines);                    \
  APPLE_FUNC(glGenProgramsARB);                         \
  APPLE_FUNC(glGenQueries);                             \
  APPLE_FUNC(glGenQueriesARB);                          \
  APPLE_FUNC(glGenRenderbuffers);                       \
  APPLE_FUNC(glGenRenderbuffersEXT);                    \
  APPLE_FUNC(glGenSamplers);                            \
  APPLE_FUNC(glGenTextures);                            \
  APPLE_FUNC(glGenTransformFeedbacks);                  \
  APPLE_FUNC(glGenVertexArrays);                        \
  APPLE_FUNC(glGetActiveAttrib);                        \
  APPLE_FUNC(glGetActiveAttribARB);                     \
  APPLE_FUNC(glGetActiveSubroutineName);                \
  APPLE_FUNC(glGetActiveSubroutineUniformiv);           \
  APPLE_FUNC(glGetActiveSubroutineUniformName);         \
  APPLE_FUNC(glGetActiveUniform);                       \
  APPLE_FUNC(glGetActiveUniformARB);                    \
  APPLE_FUNC(glGetActiveUniformBlockiv);                \
  APPLE_FUNC(glGetActiveUniformBlockName);              \
  APPLE_FUNC(glGetActiveUniformName);                   \
  APPLE_FUNC(glGetActiveUniformsiv);                    \
  APPLE_FUNC(glGetAttachedObjectsARB);                  \
  APPLE_FUNC(glGetAttachedShaders);                     \
  APPLE_FUNC(glGetAttribLocation);                      \
  APPLE_FUNC(glGetAttribLocationARB);                   \
  APPLE_FUNC(glGetBooleani_v);                          \
  APPLE_FUNC(glGetBooleanIndexedvEXT);                  \
  APPLE_FUNC(glGetBooleanv);                            \
  APPLE_FUNC(glGetBufferParameteri64v);                 \
  APPLE_FUNC(glGetBufferParameteriv);                   \
  APPLE_FUNC(glGetBufferParameterivARB);                \
  APPLE_FUNC(glGetBufferPointerv);                      \
  APPLE_FUNC(glGetBufferPointervARB);                   \
  APPLE_FUNC(glGetBufferSubData);                       \
  APPLE_FUNC(glGetBufferSubDataARB);                    \
  APPLE_FUNC(glGetCompressedTexImage);                  \
  APPLE_FUNC(glGetCompressedTexImageARB);               \
  APPLE_FUNC(glGetDoublei_v);                           \
  APPLE_FUNC(glGetDoublev);                             \
  APPLE_FUNC(glGetError);                               \
  APPLE_FUNC(glGetFloati_v);                            \
  APPLE_FUNC(glGetFloatv);                              \
  APPLE_FUNC(glGetFragDataIndex);                       \
  APPLE_FUNC(glGetFragDataLocation);                    \
  APPLE_FUNC(glGetFragDataLocationEXT);                 \
  APPLE_FUNC(glGetFramebufferAttachmentParameteriv);    \
  APPLE_FUNC(glGetFramebufferAttachmentParameterivEXT); \
  APPLE_FUNC(glGetInteger64i_v);                        \
  APPLE_FUNC(glGetInteger64v);                          \
  APPLE_FUNC(glGetIntegeri_v);                          \
  APPLE_FUNC(glGetIntegerIndexedvEXT);                  \
  APPLE_FUNC(glGetIntegerv);                            \
  APPLE_FUNC(glGetInternalformativ);                    \
  APPLE_FUNC(glGetMultisamplefv);                       \
  APPLE_FUNC(glGetNamedStringARB);                      \
  APPLE_FUNC(glGetNamedStringivARB);                    \
  APPLE_FUNC(glGetObjectLabelEXT);                      \
  APPLE_FUNC(glGetPointerv);                            \
  APPLE_FUNC(glGetProgramBinary);                       \
  APPLE_FUNC(glGetProgramInfoLog);                      \
  APPLE_FUNC(glGetProgramiv);                           \
  APPLE_FUNC(glGetProgramivARB);                        \
  APPLE_FUNC(glGetProgramPipelineInfoLog);              \
  APPLE_FUNC(glGetProgramPipelineiv);                   \
  APPLE_FUNC(glGetProgramStageiv);                      \
  APPLE_FUNC(glGetProgramStringARB);                    \
  APPLE_FUNC(glGetQueryIndexediv);                      \
  APPLE_FUNC(glGetQueryiv);                             \
  APPLE_FUNC(glGetQueryivARB);                          \
  APPLE_FUNC(glGetQueryObjecti64v);                     \
  APPLE_FUNC(glGetQueryObjecti64vEXT);                  \
  APPLE_FUNC(glGetQueryObjectiv);                       \
  APPLE_FUNC(glGetQueryObjectivARB);                    \
  APPLE_FUNC(glGetQueryObjectui64v);                    \
  APPLE_FUNC(glGetQueryObjectui64vEXT);                 \
  APPLE_FUNC(glGetQueryObjectuiv);                      \
  APPLE_FUNC(glGetQueryObjectuivARB);                   \
  APPLE_FUNC(glGetRenderbufferParameteriv);             \
  APPLE_FUNC(glGetRenderbufferParameterivEXT);          \
  APPLE_FUNC(glGetSamplerParameterfv);                  \
  APPLE_FUNC(glGetSamplerParameterIiv);                 \
  APPLE_FUNC(glGetSamplerParameterIuiv);                \
  APPLE_FUNC(glGetSamplerParameteriv);                  \
  APPLE_FUNC(glGetShaderInfoLog);                       \
  APPLE_FUNC(glGetShaderiv);                            \
  APPLE_FUNC(glGetShaderPrecisionFormat);               \
  APPLE_FUNC(glGetShaderSource);                        \
  APPLE_FUNC(glGetShaderSourceARB);                     \
  APPLE_FUNC(glGetString);                              \
  APPLE_FUNC(glGetStringi);                             \
  APPLE_FUNC(glGetSubroutineIndex);                     \
  APPLE_FUNC(glGetSubroutineUniformLocation);           \
  APPLE_FUNC(glGetSynciv);                              \
  APPLE_FUNC(glGetTexImage);                            \
  APPLE_FUNC(glGetTexLevelParameterfv);                 \
  APPLE_FUNC(glGetTexLevelParameteriv);                 \
  APPLE_FUNC(glGetTexParameterfv);                      \
  APPLE_FUNC(glGetTexParameterIiv);                     \
  APPLE_FUNC(glGetTexParameterIivEXT);                  \
  APPLE_FUNC(glGetTexParameterIuiv);                    \
  APPLE_FUNC(glGetTexParameterIuivEXT);                 \
  APPLE_FUNC(glGetTexParameteriv);                      \
  APPLE_FUNC(glGetTransformFeedbackVarying);            \
  APPLE_FUNC(glGetTransformFeedbackVaryingEXT);         \
  APPLE_FUNC(glGetUniformBlockIndex);                   \
  APPLE_FUNC(glGetUniformBufferSizeEXT);                \
  APPLE_FUNC(glGetUniformdv);                           \
  APPLE_FUNC(glGetUniformfv);                           \
  APPLE_FUNC(glGetUniformfvARB);                        \
  APPLE_FUNC(glGetUniformIndices);                      \
  APPLE_FUNC(glGetUniformiv);                           \
  APPLE_FUNC(glGetUniformivARB);                        \
  APPLE_FUNC(glGetUniformLocation);                     \
  APPLE_FUNC(glGetUniformLocationARB);                  \
  APPLE_FUNC(glGetUniformOffsetEXT);                    \
  APPLE_FUNC(glGetUniformSubroutineuiv);                \
  APPLE_FUNC(glGetUniformuiv);                          \
  APPLE_FUNC(glGetUniformuivEXT);                       \
  APPLE_FUNC(glGetVertexAttribdv);                      \
  APPLE_FUNC(glGetVertexAttribdvARB);                   \
  APPLE_FUNC(glGetVertexAttribfv);                      \
  APPLE_FUNC(glGetVertexAttribfvARB);                   \
  APPLE_FUNC(glGetVertexAttribIiv);                     \
  APPLE_FUNC(glGetVertexAttribIivEXT);                  \
  APPLE_FUNC(glGetVertexAttribIuiv);                    \
  APPLE_FUNC(glGetVertexAttribIuivEXT);                 \
  APPLE_FUNC(glGetVertexAttribiv);                      \
  APPLE_FUNC(glGetVertexAttribivARB);                   \
  APPLE_FUNC(glGetVertexAttribLdv);                     \
  APPLE_FUNC(glGetVertexAttribPointerv);                \
  APPLE_FUNC(glGetVertexAttribPointervARB);             \
  APPLE_FUNC(glHint);                                   \
  APPLE_FUNC(glInsertEventMarkerEXT);                   \
  APPLE_FUNC(glIsBuffer);                               \
  APPLE_FUNC(glIsBufferARB);                            \
  APPLE_FUNC(glIsEnabled);                              \
  APPLE_FUNC(glIsEnabledi);                             \
  APPLE_FUNC(glIsEnabledIndexedEXT);                    \
  APPLE_FUNC(glIsFramebuffer);                          \
  APPLE_FUNC(glIsFramebufferEXT);                       \
  APPLE_FUNC(glIsNamedStringARB);                       \
  APPLE_FUNC(glIsProgram);                              \
  APPLE_FUNC(glIsProgramARB);                           \
  APPLE_FUNC(glIsProgramPipeline);                      \
  APPLE_FUNC(glIsQuery);                                \
  APPLE_FUNC(glIsQueryARB);                             \
  APPLE_FUNC(glIsRenderbuffer);                         \
  APPLE_FUNC(glIsRenderbufferEXT);                      \
  APPLE_FUNC(glIsSampler);                              \
  APPLE_FUNC(glIsShader);                               \
  APPLE_FUNC(glIsSync);                                 \
  APPLE_FUNC(glIsTexture);                              \
  APPLE_FUNC(glIsTransformFeedback);                    \
  APPLE_FUNC(glIsVertexArray);                          \
  APPLE_FUNC(glLabelObjectEXT);                         \
  APPLE_FUNC(glLineWidth);                              \
  APPLE_FUNC(glLinkProgram);                            \
  APPLE_FUNC(glLinkProgramARB);                         \
  APPLE_FUNC(glLogicOp);                                \
  APPLE_FUNC(glMapBuffer);                              \
  APPLE_FUNC(glMapBufferARB);                           \
  APPLE_FUNC(glMapBufferRange);                         \
  APPLE_FUNC(glMinSampleShading);                       \
  APPLE_FUNC(glMinSampleShadingARB);                    \
  APPLE_FUNC(glMultiDrawArrays);                        \
  APPLE_FUNC(glMultiDrawArraysEXT);                     \
  APPLE_FUNC(glMultiDrawElements);                      \
  APPLE_FUNC(glMultiDrawElementsBaseVertex);            \
  APPLE_FUNC(glMultiDrawElementsEXT);                   \
  APPLE_FUNC(glNamedStringARB);                         \
  APPLE_FUNC(glPatchParameterfv);                       \
  APPLE_FUNC(glPatchParameteri);                        \
  APPLE_FUNC(glPauseTransformFeedback);                 \
  APPLE_FUNC(glPixelStoref);                            \
  APPLE_FUNC(glPixelStorei);                            \
  APPLE_FUNC(glPointParameterf);                        \
  APPLE_FUNC(glPointParameterfARB);                     \
  APPLE_FUNC(glPointParameterfv);                       \
  APPLE_FUNC(glPointParameterfvARB);                    \
  APPLE_FUNC(glPointParameteri);                        \
  APPLE_FUNC(glPointParameteriNV);                      \
  APPLE_FUNC(glPointParameteriv);                       \
  APPLE_FUNC(glPointParameterivNV);                     \
  APPLE_FUNC(glPointSize);                              \
  APPLE_FUNC(glPolygonMode);                            \
  APPLE_FUNC(glPolygonOffset);                          \
  APPLE_FUNC(glPopGroupMarkerEXT);                      \
  APPLE_FUNC(glPrimitiveRestartIndex);                  \
  APPLE_FUNC(glProgramBinary);                          \
  APPLE_FUNC(glProgramParameteri);                      \
  APPLE_FUNC(glProgramParameteriEXT);                   \
  APPLE_FUNC(glProgramStringARB);                       \
  APPLE_FUNC(glProgramUniform1d);                       \
  APPLE_FUNC(glProgramUniform1dv);                      \
  APPLE_FUNC(glProgramUniform1f);                       \
  APPLE_FUNC(glProgramUniform1fv);                      \
  APPLE_FUNC(glProgramUniform1i);                       \
  APPLE_FUNC(glProgramUniform1iv);                      \
  APPLE_FUNC(glProgramUniform1ui);                      \
  APPLE_FUNC(glProgramUniform1uiv);                     \
  APPLE_FUNC(glProgramUniform2d);                       \
  APPLE_FUNC(glProgramUniform2dv);                      \
  APPLE_FUNC(glProgramUniform2f);                       \
  APPLE_FUNC(glProgramUniform2fv);                      \
  APPLE_FUNC(glProgramUniform2i);                       \
  APPLE_FUNC(glProgramUniform2iv);                      \
  APPLE_FUNC(glProgramUniform2ui);                      \
  APPLE_FUNC(glProgramUniform2uiv);                     \
  APPLE_FUNC(glProgramUniform3d);                       \
  APPLE_FUNC(glProgramUniform3dv);                      \
  APPLE_FUNC(glProgramUniform3f);                       \
  APPLE_FUNC(glProgramUniform3fv);                      \
  APPLE_FUNC(glProgramUniform3i);                       \
  APPLE_FUNC(glProgramUniform3iv);                      \
  APPLE_FUNC(glProgramUniform3ui);                      \
  APPLE_FUNC(glProgramUniform3uiv);                     \
  APPLE_FUNC(glProgramUniform4d);                       \
  APPLE_FUNC(glProgramUniform4dv);                      \
  APPLE_FUNC(glProgramUniform4f);                       \
  APPLE_FUNC(glProgramUniform4fv);                      \
  APPLE_FUNC(glProgramUniform4i);                       \
  APPLE_FUNC(glProgramUniform4iv);                      \
  APPLE_FUNC(glProgramUniform4ui);                      \
  APPLE_FUNC(glProgramUniform4uiv);                     \
  APPLE_FUNC(glProgramUniformMatrix2dv);                \
  APPLE_FUNC(glProgramUniformMatrix2fv);                \
  APPLE_FUNC(glProgramUniformMatrix2x3dv);              \
  APPLE_FUNC(glProgramUniformMatrix2x3fv);              \
  APPLE_FUNC(glProgramUniformMatrix2x4dv);              \
  APPLE_FUNC(glProgramUniformMatrix2x4fv);              \
  APPLE_FUNC(glProgramUniformMatrix3dv);                \
  APPLE_FUNC(glProgramUniformMatrix3fv);                \
  APPLE_FUNC(glProgramUniformMatrix3x2dv);              \
  APPLE_FUNC(glProgramUniformMatrix3x2fv);              \
  APPLE_FUNC(glProgramUniformMatrix3x4dv);              \
  APPLE_FUNC(glProgramUniformMatrix3x4fv);              \
  APPLE_FUNC(glProgramUniformMatrix4dv);                \
  APPLE_FUNC(glProgramUniformMatrix4fv);                \
  APPLE_FUNC(glProgramUniformMatrix4x2dv);              \
  APPLE_FUNC(glProgramUniformMatrix4x2fv);              \
  APPLE_FUNC(glProgramUniformMatrix4x3dv);              \
  APPLE_FUNC(glProgramUniformMatrix4x3fv);              \
  APPLE_FUNC(glProvokingVertex);                        \
  APPLE_FUNC(glProvokingVertexEXT);                     \
  APPLE_FUNC(glPushGroupMarkerEXT);                     \
  APPLE_FUNC(glQueryCounter);                           \
  APPLE_FUNC(glReadBuffer);                             \
  APPLE_FUNC(glReadPixels);                             \
  APPLE_FUNC(glReleaseShaderCompiler);                  \
  APPLE_FUNC(glRenderbufferStorage);                    \
  APPLE_FUNC(glRenderbufferStorageEXT);                 \
  APPLE_FUNC(glRenderbufferStorageMultisample);         \
  APPLE_FUNC(glRenderbufferStorageMultisampleEXT);      \
  APPLE_FUNC(glResumeTransformFeedback);                \
  APPLE_FUNC(glSampleCoverage);                         \
  APPLE_FUNC(glSampleCoverageARB);                      \
  APPLE_FUNC(glSampleMaski);                            \
  APPLE_FUNC(glSamplerParameterf);                      \
  APPLE_FUNC(glSamplerParameterfv);                     \
  APPLE_FUNC(glSamplerParameteri);                      \
  APPLE_FUNC(glSamplerParameterIiv);                    \
  APPLE_FUNC(glSamplerParameterIuiv);                   \
  APPLE_FUNC(glSamplerParameteriv);                     \
  APPLE_FUNC(glScissor);                                \
  APPLE_FUNC(glScissorArrayv);                          \
  APPLE_FUNC(glScissorIndexed);                         \
  APPLE_FUNC(glScissorIndexedv);                        \
  APPLE_FUNC(glShaderBinary);                           \
  APPLE_FUNC(glShaderSource);                           \
  APPLE_FUNC(glShaderSourceARB);                        \
  APPLE_FUNC(glStencilFunc);                            \
  APPLE_FUNC(glStencilFuncSeparate);                    \
  APPLE_FUNC(glStencilFuncSeparateATI);                 \
  APPLE_FUNC(glStencilMask);                            \
  APPLE_FUNC(glStencilMaskSeparate);                    \
  APPLE_FUNC(glStencilOp);                              \
  APPLE_FUNC(glStencilOpSeparate);                      \
  APPLE_FUNC(glStencilOpSeparateATI);                   \
  APPLE_FUNC(glTexBuffer);                              \
  APPLE_FUNC(glTexImage1D);                             \
  APPLE_FUNC(glTexImage2D);                             \
  APPLE_FUNC(glTexImage2DMultisample);                  \
  APPLE_FUNC(glTexImage3D);                             \
  APPLE_FUNC(glTexImage3DMultisample);                  \
  APPLE_FUNC(glTexParameterf);                          \
  APPLE_FUNC(glTexParameterfv);                         \
  APPLE_FUNC(glTexParameteri);                          \
  APPLE_FUNC(glTexParameterIiv);                        \
  APPLE_FUNC(glTexParameterIivEXT);                     \
  APPLE_FUNC(glTexParameterIuiv);                       \
  APPLE_FUNC(glTexParameterIuivEXT);                    \
  APPLE_FUNC(glTexParameteriv);                         \
  APPLE_FUNC(glTexStorage1D);                           \
  APPLE_FUNC(glTexStorage2D);                           \
  APPLE_FUNC(glTexStorage3D);                           \
  APPLE_FUNC(glTexSubImage1D);                          \
  APPLE_FUNC(glTexSubImage2D);                          \
  APPLE_FUNC(glTexSubImage3D);                          \
  APPLE_FUNC(glTransformFeedbackVaryings);              \
  APPLE_FUNC(glTransformFeedbackVaryingsEXT);           \
  APPLE_FUNC(glUniform1d);                              \
  APPLE_FUNC(glUniform1dv);                             \
  APPLE_FUNC(glUniform1f);                              \
  APPLE_FUNC(glUniform1fARB);                           \
  APPLE_FUNC(glUniform1fv);                             \
  APPLE_FUNC(glUniform1fvARB);                          \
  APPLE_FUNC(glUniform1i);                              \
  APPLE_FUNC(glUniform1iARB);                           \
  APPLE_FUNC(glUniform1iv);                             \
  APPLE_FUNC(glUniform1ivARB);                          \
  APPLE_FUNC(glUniform1ui);                             \
  APPLE_FUNC(glUniform1uiEXT);                          \
  APPLE_FUNC(glUniform1uiv);                            \
  APPLE_FUNC(glUniform1uivEXT);                         \
  APPLE_FUNC(glUniform2d);                              \
  APPLE_FUNC(glUniform2dv);                             \
  APPLE_FUNC(glUniform2f);                              \
  APPLE_FUNC(glUniform2fARB);                           \
  APPLE_FUNC(glUniform2fv);                             \
  APPLE_FUNC(glUniform2fvARB);                          \
  APPLE_FUNC(glUniform2i);                              \
  APPLE_FUNC(glUniform2iARB);                           \
  APPLE_FUNC(glUniform2iv);                             \
  APPLE_FUNC(glUniform2ivARB);                          \
  APPLE_FUNC(glUniform2ui);                             \
  APPLE_FUNC(glUniform2uiEXT);                          \
  APPLE_FUNC(glUniform2uiv);                            \
  APPLE_FUNC(glUniform2uivEXT);                         \
  APPLE_FUNC(glUniform3d);                              \
  APPLE_FUNC(glUniform3dv);                             \
  APPLE_FUNC(glUniform3f);                              \
  APPLE_FUNC(glUniform3fARB);                           \
  APPLE_FUNC(glUniform3fv);                             \
  APPLE_FUNC(glUniform3fvARB);                          \
  APPLE_FUNC(glUniform3i);                              \
  APPLE_FUNC(glUniform3iARB);                           \
  APPLE_FUNC(glUniform3iv);                             \
  APPLE_FUNC(glUniform3ivARB);                          \
  APPLE_FUNC(glUniform3ui);                             \
  APPLE_FUNC(glUniform3uiEXT);                          \
  APPLE_FUNC(glUniform3uiv);                            \
  APPLE_FUNC(glUniform3uivEXT);                         \
  APPLE_FUNC(glUniform4d);                              \
  APPLE_FUNC(glUniform4dv);                             \
  APPLE_FUNC(glUniform4f);                              \
  APPLE_FUNC(glUniform4fARB);                           \
  APPLE_FUNC(glUniform4fv);                             \
  APPLE_FUNC(glUniform4fvARB);                          \
  APPLE_FUNC(glUniform4i);                              \
  APPLE_FUNC(glUniform4iARB);                           \
  APPLE_FUNC(glUniform4iv);                             \
  APPLE_FUNC(glUniform4ivARB);                          \
  APPLE_FUNC(glUniform4ui);                             \
  APPLE_FUNC(glUniform4uiEXT);                          \
  APPLE_FUNC(glUniform4uiv);                            \
  APPLE_FUNC(glUniform4uivEXT);                         \
  APPLE_FUNC(glUniformBlockBinding);                    \
  APPLE_FUNC(glUniformBufferEXT);                       \
  APPLE_FUNC(glUniformMatrix2dv);                       \
  APPLE_FUNC(glUniformMatrix2fv);                       \
  APPLE_FUNC(glUniformMatrix2fvARB);                    \
  APPLE_FUNC(glUniformMatrix2x3dv);                     \
  APPLE_FUNC(glUniformMatrix2x3fv);                     \
  APPLE_FUNC(glUniformMatrix2x4dv);                     \
  APPLE_FUNC(glUniformMatrix2x4fv);                     \
  APPLE_FUNC(glUniformMatrix3dv);                       \
  APPLE_FUNC(glUniformMatrix3fv);                       \
  APPLE_FUNC(glUniformMatrix3fvARB);                    \
  APPLE_FUNC(glUniformMatrix3x2dv);                     \
  APPLE_FUNC(glUniformMatrix3x2fv);                     \
  APPLE_FUNC(glUniformMatrix3x4dv);                     \
  APPLE_FUNC(glUniformMatrix3x4fv);                     \
  APPLE_FUNC(glUniformMatrix4dv);                       \
  APPLE_FUNC(glUniformMatrix4fv);                       \
  APPLE_FUNC(glUniformMatrix4fvARB);                    \
  APPLE_FUNC(glUniformMatrix4x2dv);                     \
  APPLE_FUNC(glUniformMatrix4x2fv);                     \
  APPLE_FUNC(glUniformMatrix4x3dv);                     \
  APPLE_FUNC(glUniformMatrix4x3fv);                     \
  APPLE_FUNC(glUniformSubroutinesuiv);                  \
  APPLE_FUNC(glUnmapBuffer);                            \
  APPLE_FUNC(glUnmapBufferARB);                         \
  APPLE_FUNC(glUseProgram);                             \
  APPLE_FUNC(glUseProgramObjectARB);                    \
  APPLE_FUNC(glUseProgramStages);                       \
  APPLE_FUNC(glValidateProgram);                        \
  APPLE_FUNC(glValidateProgramARB);                     \
  APPLE_FUNC(glValidateProgramPipeline);                \
  APPLE_FUNC(glVertexAttrib1d);                         \
  APPLE_FUNC(glVertexAttrib1dARB);                      \
  APPLE_FUNC(glVertexAttrib1dv);                        \
  APPLE_FUNC(glVertexAttrib1dvARB);                     \
  APPLE_FUNC(glVertexAttrib1f);                         \
  APPLE_FUNC(glVertexAttrib1fARB);                      \
  APPLE_FUNC(glVertexAttrib1fv);                        \
  APPLE_FUNC(glVertexAttrib1fvARB);                     \
  APPLE_FUNC(glVertexAttrib1s);                         \
  APPLE_FUNC(glVertexAttrib1sARB);                      \
  APPLE_FUNC(glVertexAttrib1sv);                        \
  APPLE_FUNC(glVertexAttrib1svARB);                     \
  APPLE_FUNC(glVertexAttrib2d);                         \
  APPLE_FUNC(glVertexAttrib2dARB);                      \
  APPLE_FUNC(glVertexAttrib2dv);                        \
  APPLE_FUNC(glVertexAttrib2dvARB);                     \
  APPLE_FUNC(glVertexAttrib2f);                         \
  APPLE_FUNC(glVertexAttrib2fARB);                      \
  APPLE_FUNC(glVertexAttrib2fv);                        \
  APPLE_FUNC(glVertexAttrib2fvARB);                     \
  APPLE_FUNC(glVertexAttrib2s);                         \
  APPLE_FUNC(glVertexAttrib2sARB);                      \
  APPLE_FUNC(glVertexAttrib2sv);                        \
  APPLE_FUNC(glVertexAttrib2svARB);                     \
  APPLE_FUNC(glVertexAttrib3d);                         \
  APPLE_FUNC(glVertexAttrib3dARB);                      \
  APPLE_FUNC(glVertexAttrib3dv);                        \
  APPLE_FUNC(glVertexAttrib3dvARB);                     \
  APPLE_FUNC(glVertexAttrib3f);                         \
  APPLE_FUNC(glVertexAttrib3fARB);                      \
  APPLE_FUNC(glVertexAttrib3fv);                        \
  APPLE_FUNC(glVertexAttrib3fvARB);                     \
  APPLE_FUNC(glVertexAttrib3s);                         \
  APPLE_FUNC(glVertexAttrib3sARB);                      \
  APPLE_FUNC(glVertexAttrib3sv);                        \
  APPLE_FUNC(glVertexAttrib3svARB);                     \
  APPLE_FUNC(glVertexAttrib4bv);                        \
  APPLE_FUNC(glVertexAttrib4bvARB);                     \
  APPLE_FUNC(glVertexAttrib4d);                         \
  APPLE_FUNC(glVertexAttrib4dARB);                      \
  APPLE_FUNC(glVertexAttrib4dv);                        \
  APPLE_FUNC(glVertexAttrib4dvARB);                     \
  APPLE_FUNC(glVertexAttrib4f);                         \
  APPLE_FUNC(glVertexAttrib4fARB);                      \
  APPLE_FUNC(glVertexAttrib4fv);                        \
  APPLE_FUNC(glVertexAttrib4fvARB);                     \
  APPLE_FUNC(glVertexAttrib4iv);                        \
  APPLE_FUNC(glVertexAttrib4ivARB);                     \
  APPLE_FUNC(glVertexAttrib4Nbv);                       \
  APPLE_FUNC(glVertexAttrib4NbvARB);                    \
  APPLE_FUNC(glVertexAttrib4Niv);                       \
  APPLE_FUNC(glVertexAttrib4NivARB);                    \
  APPLE_FUNC(glVertexAttrib4Nsv);                       \
  APPLE_FUNC(glVertexAttrib4NsvARB);                    \
  APPLE_FUNC(glVertexAttrib4Nub);                       \
  APPLE_FUNC(glVertexAttrib4NubARB);                    \
  APPLE_FUNC(glVertexAttrib4Nubv);                      \
  APPLE_FUNC(glVertexAttrib4NubvARB);                   \
  APPLE_FUNC(glVertexAttrib4Nuiv);                      \
  APPLE_FUNC(glVertexAttrib4NuivARB);                   \
  APPLE_FUNC(glVertexAttrib4Nusv);                      \
  APPLE_FUNC(glVertexAttrib4NusvARB);                   \
  APPLE_FUNC(glVertexAttrib4s);                         \
  APPLE_FUNC(glVertexAttrib4sARB);                      \
  APPLE_FUNC(glVertexAttrib4sv);                        \
  APPLE_FUNC(glVertexAttrib4svARB);                     \
  APPLE_FUNC(glVertexAttrib4ubv);                       \
  APPLE_FUNC(glVertexAttrib4ubvARB);                    \
  APPLE_FUNC(glVertexAttrib4uiv);                       \
  APPLE_FUNC(glVertexAttrib4uivARB);                    \
  APPLE_FUNC(glVertexAttrib4usv);                       \
  APPLE_FUNC(glVertexAttrib4usvARB);                    \
  APPLE_FUNC(glVertexAttribDivisor);                    \
  APPLE_FUNC(glVertexAttribDivisorARB);                 \
  APPLE_FUNC(glVertexAttribI1i);                        \
  APPLE_FUNC(glVertexAttribI1iEXT);                     \
  APPLE_FUNC(glVertexAttribI1iv);                       \
  APPLE_FUNC(glVertexAttribI1ivEXT);                    \
  APPLE_FUNC(glVertexAttribI1ui);                       \
  APPLE_FUNC(glVertexAttribI1uiEXT);                    \
  APPLE_FUNC(glVertexAttribI1uiv);                      \
  APPLE_FUNC(glVertexAttribI1uivEXT);                   \
  APPLE_FUNC(glVertexAttribI2i);                        \
  APPLE_FUNC(glVertexAttribI2iEXT);                     \
  APPLE_FUNC(glVertexAttribI2iv);                       \
  APPLE_FUNC(glVertexAttribI2ivEXT);                    \
  APPLE_FUNC(glVertexAttribI2ui);                       \
  APPLE_FUNC(glVertexAttribI2uiEXT);                    \
  APPLE_FUNC(glVertexAttribI2uiv);                      \
  APPLE_FUNC(glVertexAttribI2uivEXT);                   \
  APPLE_FUNC(glVertexAttribI3i);                        \
  APPLE_FUNC(glVertexAttribI3iEXT);                     \
  APPLE_FUNC(glVertexAttribI3iv);                       \
  APPLE_FUNC(glVertexAttribI3ivEXT);                    \
  APPLE_FUNC(glVertexAttribI3ui);                       \
  APPLE_FUNC(glVertexAttribI3uiEXT);                    \
  APPLE_FUNC(glVertexAttribI3uiv);                      \
  APPLE_FUNC(glVertexAttribI3uivEXT);                   \
  APPLE_FUNC(glVertexAttribI4bv);                       \
  APPLE_FUNC(glVertexAttribI4bvEXT);                    \
  APPLE_FUNC(glVertexAttribI4i);                        \
  APPLE_FUNC(glVertexAttribI4iEXT);                     \
  APPLE_FUNC(glVertexAttribI4iv);                       \
  APPLE_FUNC(glVertexAttribI4ivEXT);                    \
  APPLE_FUNC(glVertexAttribI4sv);                       \
  APPLE_FUNC(glVertexAttribI4svEXT);                    \
  APPLE_FUNC(glVertexAttribI4ubv);                      \
  APPLE_FUNC(glVertexAttribI4ubvEXT);                   \
  APPLE_FUNC(glVertexAttribI4ui);                       \
  APPLE_FUNC(glVertexAttribI4uiEXT);                    \
  APPLE_FUNC(glVertexAttribI4uiv);                      \
  APPLE_FUNC(glVertexAttribI4uivEXT);                   \
  APPLE_FUNC(glVertexAttribI4usv);                      \
  APPLE_FUNC(glVertexAttribI4usvEXT);                   \
  APPLE_FUNC(glVertexAttribIPointer);                   \
  APPLE_FUNC(glVertexAttribIPointerEXT);                \
  APPLE_FUNC(glVertexAttribL1d);                        \
  APPLE_FUNC(glVertexAttribL1dv);                       \
  APPLE_FUNC(glVertexAttribL2d);                        \
  APPLE_FUNC(glVertexAttribL2dv);                       \
  APPLE_FUNC(glVertexAttribL3d);                        \
  APPLE_FUNC(glVertexAttribL3dv);                       \
  APPLE_FUNC(glVertexAttribL4d);                        \
  APPLE_FUNC(glVertexAttribL4dv);                       \
  APPLE_FUNC(glVertexAttribLPointer);                   \
  APPLE_FUNC(glVertexAttribP1ui);                       \
  APPLE_FUNC(glVertexAttribP1uiv);                      \
  APPLE_FUNC(glVertexAttribP2ui);                       \
  APPLE_FUNC(glVertexAttribP2uiv);                      \
  APPLE_FUNC(glVertexAttribP3ui);                       \
  APPLE_FUNC(glVertexAttribP3uiv);                      \
  APPLE_FUNC(glVertexAttribP4ui);                       \
  APPLE_FUNC(glVertexAttribP4uiv);                      \
  APPLE_FUNC(glVertexAttribPointer);                    \
  APPLE_FUNC(glVertexAttribPointerARB);                 \
  APPLE_FUNC(glViewport);                               \
  APPLE_FUNC(glViewportArrayv);                         \
  APPLE_FUNC(glViewportIndexedf);                       \
  APPLE_FUNC(glViewportIndexedfv);                      \
  APPLE_FUNC(glWaitSync);

#define ForEachAppleUnsupported()                   \
  APPLE_FUNC(glAccum);                              \
  APPLE_FUNC(glActiveStencilFaceEXT);               \
  APPLE_FUNC(glAlphaFunc);                          \
  APPLE_FUNC(glAreTexturesResident);                \
  APPLE_FUNC(glArrayElement);                       \
  APPLE_FUNC(glAttachObjectARB);                    \
  APPLE_FUNC(glBegin);                              \
  APPLE_FUNC(glBeginConditionalRenderNV);           \
  APPLE_FUNC(glBindBufferOffsetEXT);                \
  APPLE_FUNC(glBindVertexArrayAPPLE);               \
  APPLE_FUNC(glBitmap);                             \
  APPLE_FUNC(glBufferParameteriAPPLE);              \
  APPLE_FUNC(glCallList);                           \
  APPLE_FUNC(glCallLists);                          \
  APPLE_FUNC(glClearAccum);                         \
  APPLE_FUNC(glClearIndex);                         \
  APPLE_FUNC(glClientActiveTexture);                \
  APPLE_FUNC(glClientActiveTextureARB);             \
  APPLE_FUNC(glClipPlane);                          \
  APPLE_FUNC(glColor3b);                            \
  APPLE_FUNC(glColor3bv);                           \
  APPLE_FUNC(glColor3d);                            \
  APPLE_FUNC(glColor3dv);                           \
  APPLE_FUNC(glColor3f);                            \
  APPLE_FUNC(glColor3fv);                           \
  APPLE_FUNC(glColor3i);                            \
  APPLE_FUNC(glColor3iv);                           \
  APPLE_FUNC(glColor3s);                            \
  APPLE_FUNC(glColor3sv);                           \
  APPLE_FUNC(glColor3ub);                           \
  APPLE_FUNC(glColor3ubv);                          \
  APPLE_FUNC(glColor3ui);                           \
  APPLE_FUNC(glColor3uiv);                          \
  APPLE_FUNC(glColor3us);                           \
  APPLE_FUNC(glColor3usv);                          \
  APPLE_FUNC(glColor4b);                            \
  APPLE_FUNC(glColor4bv);                           \
  APPLE_FUNC(glColor4d);                            \
  APPLE_FUNC(glColor4dv);                           \
  APPLE_FUNC(glColor4f);                            \
  APPLE_FUNC(glColor4fv);                           \
  APPLE_FUNC(glColor4i);                            \
  APPLE_FUNC(glColor4iv);                           \
  APPLE_FUNC(glColor4s);                            \
  APPLE_FUNC(glColor4sv);                           \
  APPLE_FUNC(glColor4ub);                           \
  APPLE_FUNC(glColor4ubv);                          \
  APPLE_FUNC(glColor4ui);                           \
  APPLE_FUNC(glColor4uiv);                          \
  APPLE_FUNC(glColor4us);                           \
  APPLE_FUNC(glColor4usv);                          \
  APPLE_FUNC(glColorMaterial);                      \
  APPLE_FUNC(glColorPointer);                       \
  APPLE_FUNC(glColorSubTable);                      \
  APPLE_FUNC(glColorSubTableEXT);                   \
  APPLE_FUNC(glColorTable);                         \
  APPLE_FUNC(glColorTableEXT);                      \
  APPLE_FUNC(glColorTableParameterfv);              \
  APPLE_FUNC(glColorTableParameteriv);              \
  APPLE_FUNC(glCombinerInputNV);                    \
  APPLE_FUNC(glCombinerOutputNV);                   \
  APPLE_FUNC(glCombinerParameterfNV);               \
  APPLE_FUNC(glCombinerParameterfvNV);              \
  APPLE_FUNC(glCombinerParameteriNV);               \
  APPLE_FUNC(glCombinerParameterivNV);              \
  APPLE_FUNC(glCombinerStageParameterfvNV);         \
  APPLE_FUNC(glCopyPixels);                         \
  APPLE_FUNC(glConvolutionFilter1D);                \
  APPLE_FUNC(glConvolutionFilter2D);                \
  APPLE_FUNC(glConvolutionParameterf);              \
  APPLE_FUNC(glConvolutionParameterfv);             \
  APPLE_FUNC(glConvolutionParameteri);              \
  APPLE_FUNC(glConvolutionParameteriv);             \
  APPLE_FUNC(glCopyColorSubTable);                  \
  APPLE_FUNC(glCopyColorTable);                     \
  APPLE_FUNC(glCopyConvolutionFilter1D);            \
  APPLE_FUNC(glCopyConvolutionFilter2D);            \
  APPLE_FUNC(glDeleteFencesAPPLE);                  \
  APPLE_FUNC(glDeleteLists);                        \
  APPLE_FUNC(glDeleteObjectARB);                    \
  APPLE_FUNC(glDeleteVertexArraysAPPLE);            \
  APPLE_FUNC(glDisableClientState);                 \
  APPLE_FUNC(glDisableVertexAttribAPPLE);           \
  APPLE_FUNC(glDrawElementArrayAPPLE);              \
  APPLE_FUNC(glDrawPixels);                         \
  APPLE_FUNC(glDrawRangeElementArrayAPPLE);         \
  APPLE_FUNC(glEdgeFlag);                           \
  APPLE_FUNC(glEdgeFlagPointer);                    \
  APPLE_FUNC(glEdgeFlagv);                          \
  APPLE_FUNC(glElementPointerAPPLE);                \
  APPLE_FUNC(glEnableClientState);                  \
  APPLE_FUNC(glEnableVertexAttribAPPLE);            \
  APPLE_FUNC(glEnd);                                \
  APPLE_FUNC(glEndList);                            \
  APPLE_FUNC(glEvalCoord1d);                        \
  APPLE_FUNC(glEvalCoord1dv);                       \
  APPLE_FUNC(glEvalCoord1f);                        \
  APPLE_FUNC(glEvalCoord1fv);                       \
  APPLE_FUNC(glEvalCoord2d);                        \
  APPLE_FUNC(glEvalCoord2dv);                       \
  APPLE_FUNC(glEvalCoord2f);                        \
  APPLE_FUNC(glEvalCoord2fv);                       \
  APPLE_FUNC(glEvalMesh1);                          \
  APPLE_FUNC(glEvalMesh2);                          \
  APPLE_FUNC(glEvalPoint1);                         \
  APPLE_FUNC(glEvalPoint2);                         \
  APPLE_FUNC(glFeedbackBuffer);                     \
  APPLE_FUNC(glFinalCombinerInputNV);               \
  APPLE_FUNC(glFinishFenceAPPLE);                   \
  APPLE_FUNC(glFinishObjectAPPLE);                  \
  APPLE_FUNC(glFlushMappedBufferRangeAPPLE);        \
  APPLE_FUNC(glFlushVertexArrayRangeAPPLE);         \
  APPLE_FUNC(glFogCoordd);                          \
  APPLE_FUNC(glFogCoorddEXT);                       \
  APPLE_FUNC(glFogCoorddv);                         \
  APPLE_FUNC(glFogCoorddvEXT);                      \
  APPLE_FUNC(glFogCoordf);                          \
  APPLE_FUNC(glFogCoordfEXT);                       \
  APPLE_FUNC(glFogCoordfv);                         \
  APPLE_FUNC(glFogCoordfvEXT);                      \
  APPLE_FUNC(glFogCoordPointer);                    \
  APPLE_FUNC(glFogCoordPointerEXT);                 \
  APPLE_FUNC(glFogf);                               \
  APPLE_FUNC(glFogfv);                              \
  APPLE_FUNC(glFogi);                               \
  APPLE_FUNC(glFogiv);                              \
  APPLE_FUNC(glFrustum);                            \
  APPLE_FUNC(glGenFencesAPPLE);                     \
  APPLE_FUNC(glGenVertexArraysAPPLE);               \
  APPLE_FUNC(glGenLists);                           \
  APPLE_FUNC(glGetClipPlane);                       \
  APPLE_FUNC(glGetColorTable);                      \
  APPLE_FUNC(glGetColorTableEXT);                   \
  APPLE_FUNC(glGetColorTableParameterfv);           \
  APPLE_FUNC(glGetColorTableParameterfvEXT);        \
  APPLE_FUNC(glGetColorTableParameteriv);           \
  APPLE_FUNC(glGetColorTableParameterivEXT);        \
  APPLE_FUNC(glGetCombinerInputParameterfvNV);      \
  APPLE_FUNC(glGetCombinerInputParameterivNV);      \
  APPLE_FUNC(glGetCombinerOutputParameterfvNV);     \
  APPLE_FUNC(glGetCombinerOutputParameterivNV);     \
  APPLE_FUNC(glGetCombinerStageParameterfvNV);      \
  APPLE_FUNC(glGetConvolutionFilter);               \
  APPLE_FUNC(glGetConvolutionParameterfv);          \
  APPLE_FUNC(glGetConvolutionParameteriv);          \
  APPLE_FUNC(glGetFinalCombinerInputParameterfvNV); \
  APPLE_FUNC(glGetFinalCombinerInputParameterivNV); \
  APPLE_FUNC(glGetHandleARB);                       \
  APPLE_FUNC(glGetHistogram);                       \
  APPLE_FUNC(glGetHistogramParameterfv);            \
  APPLE_FUNC(glGetHistogramParameteriv);            \
  APPLE_FUNC(glGetInfoLogARB);                      \
  APPLE_FUNC(glGetLightfv);                         \
  APPLE_FUNC(glGetLightiv);                         \
  APPLE_FUNC(glGetMapdv);                           \
  APPLE_FUNC(glGetMapfv);                           \
  APPLE_FUNC(glGetMapiv);                           \
  APPLE_FUNC(glGetMaterialfv);                      \
  APPLE_FUNC(glGetMaterialiv);                      \
  APPLE_FUNC(glGetMinmax);                          \
  APPLE_FUNC(glGetMinmaxParameterfv);               \
  APPLE_FUNC(glGetMinmaxParameteriv);               \
  APPLE_FUNC(glGetObjectParameterfvARB);            \
  APPLE_FUNC(glGetObjectParameterivAPPLE);          \
  APPLE_FUNC(glGetObjectParameterivARB);            \
  APPLE_FUNC(glGetPixelMapfv);                      \
  APPLE_FUNC(glGetPixelMapuiv);                     \
  APPLE_FUNC(glGetPixelMapusv);                     \
  APPLE_FUNC(glGetPolygonStipple);                  \
  APPLE_FUNC(glGetProgramEnvParameterdvARB);        \
  APPLE_FUNC(glGetProgramEnvParameterfvARB);        \
  APPLE_FUNC(glGetProgramLocalParameterdvARB);      \
  APPLE_FUNC(glGetProgramLocalParameterfvARB);      \
  APPLE_FUNC(glGetSeparableFilter);                 \
  APPLE_FUNC(glGetTexEnvfv);                        \
  APPLE_FUNC(glGetTexEnviv);                        \
  APPLE_FUNC(glGetTexGendv);                        \
  APPLE_FUNC(glGetTexGenfv);                        \
  APPLE_FUNC(glGetTexGeniv);                        \
  APPLE_FUNC(glGetTexParameterPointervAPPLE);       \
  APPLE_FUNC(glHistogram);                          \
  APPLE_FUNC(glIndexd);                             \
  APPLE_FUNC(glIndexdv);                            \
  APPLE_FUNC(glIndexf);                             \
  APPLE_FUNC(glIndexfv);                            \
  APPLE_FUNC(glIndexi);                             \
  APPLE_FUNC(glIndexiv);                            \
  APPLE_FUNC(glIndexMask);                          \
  APPLE_FUNC(glIndexPointer);                       \
  APPLE_FUNC(glIndexs);                             \
  APPLE_FUNC(glIndexsv);                            \
  APPLE_FUNC(glIndexub);                            \
  APPLE_FUNC(glIndexubv);                           \
  APPLE_FUNC(glInitNames);                          \
  APPLE_FUNC(glInterleavedArrays);                  \
  APPLE_FUNC(glIsFenceAPPLE);                       \
  APPLE_FUNC(glIsVertexArrayAPPLE);                 \
  APPLE_FUNC(glIsVertexAttribEnabledAPPLE);         \
  APPLE_FUNC(glIsList);                             \
  APPLE_FUNC(glLightf);                             \
  APPLE_FUNC(glLightfv);                            \
  APPLE_FUNC(glLighti);                             \
  APPLE_FUNC(glLightiv);                            \
  APPLE_FUNC(glLightModelf);                        \
  APPLE_FUNC(glLightModelfv);                       \
  APPLE_FUNC(glLightModeli);                        \
  APPLE_FUNC(glLightModeliv);                       \
  APPLE_FUNC(glLineStipple);                        \
  APPLE_FUNC(glListBase);                           \
  APPLE_FUNC(glLoadIdentity);                       \
  APPLE_FUNC(glLoadMatrixd);                        \
  APPLE_FUNC(glLoadMatrixf);                        \
  APPLE_FUNC(glLoadName);                           \
  APPLE_FUNC(glLoadTransposeMatrixd);               \
  APPLE_FUNC(glLoadTransposeMatrixdARB);            \
  APPLE_FUNC(glLoadTransposeMatrixf);               \
  APPLE_FUNC(glLoadTransposeMatrixfARB);            \
  APPLE_FUNC(glLockArraysEXT);                      \
  APPLE_FUNC(glMap1d);                              \
  APPLE_FUNC(glMap1f);                              \
  APPLE_FUNC(glMap2d);                              \
  APPLE_FUNC(glMap2f);                              \
  APPLE_FUNC(glMapGrid1d);                          \
  APPLE_FUNC(glMapGrid1f);                          \
  APPLE_FUNC(glMapGrid2d);                          \
  APPLE_FUNC(glMapGrid2f);                          \
  APPLE_FUNC(glMapVertexAttrib1dAPPLE);             \
  APPLE_FUNC(glMapVertexAttrib1fAPPLE);             \
  APPLE_FUNC(glMapVertexAttrib2dAPPLE);             \
  APPLE_FUNC(glMapVertexAttrib2fAPPLE);             \
  APPLE_FUNC(glMaterialf);                          \
  APPLE_FUNC(glMaterialfv);                         \
  APPLE_FUNC(glMateriali);                          \
  APPLE_FUNC(glMaterialiv);                         \
  APPLE_FUNC(glMatrixMode);                         \
  APPLE_FUNC(glMinmax);                             \
  APPLE_FUNC(glMultiDrawElementArrayAPPLE);         \
  APPLE_FUNC(glMultiDrawRangeElementArrayAPPLE);    \
  APPLE_FUNC(glMultiTexCoord1d);                    \
  APPLE_FUNC(glMultiTexCoord1dARB);                 \
  APPLE_FUNC(glMultiTexCoord1dv);                   \
  APPLE_FUNC(glMultiTexCoord1dvARB);                \
  APPLE_FUNC(glMultiTexCoord1f);                    \
  APPLE_FUNC(glMultiTexCoord1fARB);                 \
  APPLE_FUNC(glMultiTexCoord1fv);                   \
  APPLE_FUNC(glMultiTexCoord1fvARB);                \
  APPLE_FUNC(glMultiTexCoord1i);                    \
  APPLE_FUNC(glMultiTexCoord1iARB);                 \
  APPLE_FUNC(glMultiTexCoord1iv);                   \
  APPLE_FUNC(glMultiTexCoord1ivARB);                \
  APPLE_FUNC(glMultiTexCoord1s);                    \
  APPLE_FUNC(glMultiTexCoord1sARB);                 \
  APPLE_FUNC(glMultiTexCoord1sv);                   \
  APPLE_FUNC(glMultiTexCoord1svARB);                \
  APPLE_FUNC(glMultiTexCoord2d);                    \
  APPLE_FUNC(glMultiTexCoord2dARB);                 \
  APPLE_FUNC(glMultiTexCoord2dv);                   \
  APPLE_FUNC(glMultiTexCoord2dvARB);                \
  APPLE_FUNC(glMultiTexCoord2f);                    \
  APPLE_FUNC(glMultiTexCoord2fARB);                 \
  APPLE_FUNC(glMultiTexCoord2fv);                   \
  APPLE_FUNC(glMultiTexCoord2fvARB);                \
  APPLE_FUNC(glMultiTexCoord2i);                    \
  APPLE_FUNC(glMultiTexCoord2iARB);                 \
  APPLE_FUNC(glMultiTexCoord2iv);                   \
  APPLE_FUNC(glMultiTexCoord2ivARB);                \
  APPLE_FUNC(glMultiTexCoord2s);                    \
  APPLE_FUNC(glMultiTexCoord2sARB);                 \
  APPLE_FUNC(glMultiTexCoord2sv);                   \
  APPLE_FUNC(glMultiTexCoord2svARB);                \
  APPLE_FUNC(glMultiTexCoord3d);                    \
  APPLE_FUNC(glMultiTexCoord3dARB);                 \
  APPLE_FUNC(glMultiTexCoord3dv);                   \
  APPLE_FUNC(glMultiTexCoord3dvARB);                \
  APPLE_FUNC(glMultiTexCoord3f);                    \
  APPLE_FUNC(glMultiTexCoord3fARB);                 \
  APPLE_FUNC(glMultiTexCoord3fv);                   \
  APPLE_FUNC(glMultiTexCoord3fvARB);                \
  APPLE_FUNC(glMultiTexCoord3i);                    \
  APPLE_FUNC(glMultiTexCoord3iARB);                 \
  APPLE_FUNC(glMultiTexCoord3iv);                   \
  APPLE_FUNC(glMultiTexCoord3ivARB);                \
  APPLE_FUNC(glMultiTexCoord3s);                    \
  APPLE_FUNC(glMultiTexCoord3sARB);                 \
  APPLE_FUNC(glMultiTexCoord3sv);                   \
  APPLE_FUNC(glMultiTexCoord3svARB);                \
  APPLE_FUNC(glMultiTexCoord4d);                    \
  APPLE_FUNC(glMultiTexCoord4dARB);                 \
  APPLE_FUNC(glMultiTexCoord4dv);                   \
  APPLE_FUNC(glMultiTexCoord4dvARB);                \
  APPLE_FUNC(glMultiTexCoord4f);                    \
  APPLE_FUNC(glMultiTexCoord4fARB);                 \
  APPLE_FUNC(glMultiTexCoord4fv);                   \
  APPLE_FUNC(glMultiTexCoord4fvARB);                \
  APPLE_FUNC(glMultiTexCoord4i);                    \
  APPLE_FUNC(glMultiTexCoord4iARB);                 \
  APPLE_FUNC(glMultiTexCoord4iv);                   \
  APPLE_FUNC(glMultiTexCoord4ivARB);                \
  APPLE_FUNC(glMultiTexCoord4s);                    \
  APPLE_FUNC(glMultiTexCoord4sARB);                 \
  APPLE_FUNC(glMultiTexCoord4sv);                   \
  APPLE_FUNC(glMultiTexCoord4svARB);                \
  APPLE_FUNC(glMultMatrixd);                        \
  APPLE_FUNC(glMultMatrixf);                        \
  APPLE_FUNC(glMultTransposeMatrixd);               \
  APPLE_FUNC(glMultTransposeMatrixdARB);            \
  APPLE_FUNC(glMultTransposeMatrixf);               \
  APPLE_FUNC(glMultTransposeMatrixfARB);            \
  APPLE_FUNC(glNewList);                            \
  APPLE_FUNC(glNormal3b);                           \
  APPLE_FUNC(glNormal3bv);                          \
  APPLE_FUNC(glNormal3d);                           \
  APPLE_FUNC(glNormal3dv);                          \
  APPLE_FUNC(glNormal3f);                           \
  APPLE_FUNC(glNormal3fv);                          \
  APPLE_FUNC(glNormal3i);                           \
  APPLE_FUNC(glNormal3iv);                          \
  APPLE_FUNC(glNormal3s);                           \
  APPLE_FUNC(glNormal3sv);                          \
  APPLE_FUNC(glNormalPointer);                      \
  APPLE_FUNC(glObjectPurgeableAPPLE);               \
  APPLE_FUNC(glObjectUnpurgeableAPPLE);             \
  APPLE_FUNC(glOrtho);                              \
  APPLE_FUNC(glPassThrough);                        \
  APPLE_FUNC(glPixelMapfv);                         \
  APPLE_FUNC(glPixelMapuiv);                        \
  APPLE_FUNC(glPixelMapusv);                        \
  APPLE_FUNC(glPixelTransferf);                     \
  APPLE_FUNC(glPixelTransferi);                     \
  APPLE_FUNC(glPixelZoom);                          \
  APPLE_FUNC(glPNTrianglesfATI);                    \
  APPLE_FUNC(glPNTrianglesiATI);                    \
  APPLE_FUNC(glPolygonStipple);                     \
  APPLE_FUNC(glPopAttrib);                          \
  APPLE_FUNC(glPopClientAttrib);                    \
  APPLE_FUNC(glPopMatrix);                          \
  APPLE_FUNC(glPopName);                            \
  APPLE_FUNC(glPrioritizeTextures);                 \
  APPLE_FUNC(glProgramEnvParameter4dARB);           \
  APPLE_FUNC(glProgramEnvParameter4dvARB);          \
  APPLE_FUNC(glProgramEnvParameter4fARB);           \
  APPLE_FUNC(glProgramEnvParameter4fvARB);          \
  APPLE_FUNC(glProgramEnvParameters4fvEXT);         \
  APPLE_FUNC(glProgramLocalParameter4dARB);         \
  APPLE_FUNC(glProgramLocalParameter4dvARB);        \
  APPLE_FUNC(glProgramLocalParameter4fARB);         \
  APPLE_FUNC(glProgramLocalParameter4fvARB);        \
  APPLE_FUNC(glProgramLocalParameters4fvEXT);       \
  APPLE_FUNC(glPushAttrib);                         \
  APPLE_FUNC(glPushClientAttrib);                   \
  APPLE_FUNC(glPushMatrix);                         \
  APPLE_FUNC(glPushName);                           \
  APPLE_FUNC(glRasterPos2d);                        \
  APPLE_FUNC(glRasterPos2dv);                       \
  APPLE_FUNC(glRasterPos2f);                        \
  APPLE_FUNC(glRasterPos2fv);                       \
  APPLE_FUNC(glRasterPos2i);                        \
  APPLE_FUNC(glRasterPos2iv);                       \
  APPLE_FUNC(glRasterPos2s);                        \
  APPLE_FUNC(glRasterPos2sv);                       \
  APPLE_FUNC(glRasterPos3d);                        \
  APPLE_FUNC(glRasterPos3dv);                       \
  APPLE_FUNC(glRasterPos3f);                        \
  APPLE_FUNC(glRasterPos3fv);                       \
  APPLE_FUNC(glRasterPos3i);                        \
  APPLE_FUNC(glRasterPos3iv);                       \
  APPLE_FUNC(glRasterPos3s);                        \
  APPLE_FUNC(glRasterPos3sv);                       \
  APPLE_FUNC(glRasterPos4d);                        \
  APPLE_FUNC(glRasterPos4dv);                       \
  APPLE_FUNC(glRasterPos4f);                        \
  APPLE_FUNC(glRasterPos4fv);                       \
  APPLE_FUNC(glRasterPos4i);                        \
  APPLE_FUNC(glRasterPos4iv);                       \
  APPLE_FUNC(glRasterPos4s);                        \
  APPLE_FUNC(glRasterPos4sv);                       \
  APPLE_FUNC(glRectd);                              \
  APPLE_FUNC(glRectdv);                             \
  APPLE_FUNC(glRectf);                              \
  APPLE_FUNC(glRectfv);                             \
  APPLE_FUNC(glRecti);                              \
  APPLE_FUNC(glRectiv);                             \
  APPLE_FUNC(glRects);                              \
  APPLE_FUNC(glRectsv);                             \
  APPLE_FUNC(glRenderMode);                         \
  APPLE_FUNC(glResetHistogram);                     \
  APPLE_FUNC(glResetMinmax);                        \
  APPLE_FUNC(glRotated);                            \
  APPLE_FUNC(glRotatef);                            \
  APPLE_FUNC(glScaled);                             \
  APPLE_FUNC(glScalef);                             \
  APPLE_FUNC(glSecondaryColor3b);                   \
  APPLE_FUNC(glSecondaryColor3bEXT);                \
  APPLE_FUNC(glSecondaryColor3bv);                  \
  APPLE_FUNC(glSecondaryColor3bvEXT);               \
  APPLE_FUNC(glSecondaryColor3d);                   \
  APPLE_FUNC(glSecondaryColor3dEXT);                \
  APPLE_FUNC(glSecondaryColor3dv);                  \
  APPLE_FUNC(glSecondaryColor3dvEXT);               \
  APPLE_FUNC(glSecondaryColor3f);                   \
  APPLE_FUNC(glSecondaryColor3fEXT);                \
  APPLE_FUNC(glSecondaryColor3fv);                  \
  APPLE_FUNC(glSecondaryColor3fvEXT);               \
  APPLE_FUNC(glSecondaryColor3i);                   \
  APPLE_FUNC(glSecondaryColor3iEXT);                \
  APPLE_FUNC(glSecondaryColor3iv);                  \
  APPLE_FUNC(glSecondaryColor3ivEXT);               \
  APPLE_FUNC(glSecondaryColor3s);                   \
  APPLE_FUNC(glSecondaryColor3sEXT);                \
  APPLE_FUNC(glSecondaryColor3sv);                  \
  APPLE_FUNC(glSecondaryColor3svEXT);               \
  APPLE_FUNC(glSecondaryColor3ub);                  \
  APPLE_FUNC(glSecondaryColor3ubEXT);               \
  APPLE_FUNC(glSecondaryColor3ubv);                 \
  APPLE_FUNC(glSecondaryColor3ubvEXT);              \
  APPLE_FUNC(glSecondaryColor3ui);                  \
  APPLE_FUNC(glSecondaryColor3uiEXT);               \
  APPLE_FUNC(glSecondaryColor3uiv);                 \
  APPLE_FUNC(glSecondaryColor3uivEXT);              \
  APPLE_FUNC(glSecondaryColor3us);                  \
  APPLE_FUNC(glSecondaryColor3usEXT);               \
  APPLE_FUNC(glSecondaryColor3usv);                 \
  APPLE_FUNC(glSecondaryColor3usvEXT);              \
  APPLE_FUNC(glSecondaryColorPointer);              \
  APPLE_FUNC(glSecondaryColorPointerEXT);           \
  APPLE_FUNC(glSelectBuffer);                       \
  APPLE_FUNC(glSeparableFilter2D);                  \
  APPLE_FUNC(glSetFenceAPPLE);                      \
  APPLE_FUNC(glShadeModel);                         \
  APPLE_FUNC(glTestFenceAPPLE);                     \
  APPLE_FUNC(glTestObjectAPPLE);                    \
  APPLE_FUNC(glTexCoord1d);                         \
  APPLE_FUNC(glTexCoord1dv);                        \
  APPLE_FUNC(glTexCoord1f);                         \
  APPLE_FUNC(glTexCoord1fv);                        \
  APPLE_FUNC(glTexCoord1i);                         \
  APPLE_FUNC(glTexCoord1iv);                        \
  APPLE_FUNC(glTexCoord1s);                         \
  APPLE_FUNC(glTexCoord1sv);                        \
  APPLE_FUNC(glTexCoord2d);                         \
  APPLE_FUNC(glTexCoord2dv);                        \
  APPLE_FUNC(glTexCoord2f);                         \
  APPLE_FUNC(glTexCoord2fv);                        \
  APPLE_FUNC(glTexCoord2i);                         \
  APPLE_FUNC(glTexCoord2iv);                        \
  APPLE_FUNC(glTexCoord2s);                         \
  APPLE_FUNC(glTexCoord2sv);                        \
  APPLE_FUNC(glTexCoord3d);                         \
  APPLE_FUNC(glTexCoord3dv);                        \
  APPLE_FUNC(glTexCoord3f);                         \
  APPLE_FUNC(glTexCoord3fv);                        \
  APPLE_FUNC(glTexCoord3i);                         \
  APPLE_FUNC(glTexCoord3iv);                        \
  APPLE_FUNC(glTexCoord3s);                         \
  APPLE_FUNC(glTexCoord3sv);                        \
  APPLE_FUNC(glTexCoord4d);                         \
  APPLE_FUNC(glTexCoord4dv);                        \
  APPLE_FUNC(glTexCoord4f);                         \
  APPLE_FUNC(glTexCoord4fv);                        \
  APPLE_FUNC(glTexCoord4i);                         \
  APPLE_FUNC(glTexCoord4iv);                        \
  APPLE_FUNC(glTexCoord4s);                         \
  APPLE_FUNC(glTexCoord4sv);                        \
  APPLE_FUNC(glTexCoordPointer);                    \
  APPLE_FUNC(glTexEnvf);                            \
  APPLE_FUNC(glTexEnvfv);                           \
  APPLE_FUNC(glTexEnvi);                            \
  APPLE_FUNC(glTexEnviv);                           \
  APPLE_FUNC(glTexGend);                            \
  APPLE_FUNC(glTexGendv);                           \
  APPLE_FUNC(glTexGenf);                            \
  APPLE_FUNC(glTexGenfv);                           \
  APPLE_FUNC(glTexGeni);                            \
  APPLE_FUNC(glTexGeniv);                           \
  APPLE_FUNC(glTextureBarrierNV);                   \
  APPLE_FUNC(glTextureRangeAPPLE);                  \
  APPLE_FUNC(glTranslated);                         \
  APPLE_FUNC(glTranslatef);                         \
  APPLE_FUNC(glUnlockArraysEXT);                    \
  APPLE_FUNC(glVertex2d);                           \
  APPLE_FUNC(glVertex2dv);                          \
  APPLE_FUNC(glVertex2f);                           \
  APPLE_FUNC(glVertex2fv);                          \
  APPLE_FUNC(glVertex2i);                           \
  APPLE_FUNC(glVertex2iv);                          \
  APPLE_FUNC(glVertex2s);                           \
  APPLE_FUNC(glVertex2sv);                          \
  APPLE_FUNC(glVertex3d);                           \
  APPLE_FUNC(glVertex3dv);                          \
  APPLE_FUNC(glVertex3f);                           \
  APPLE_FUNC(glVertex3fv);                          \
  APPLE_FUNC(glVertex3i);                           \
  APPLE_FUNC(glVertex3iv);                          \
  APPLE_FUNC(glVertex3s);                           \
  APPLE_FUNC(glVertex3sv);                          \
  APPLE_FUNC(glVertex4d);                           \
  APPLE_FUNC(glVertex4dv);                          \
  APPLE_FUNC(glVertex4f);                           \
  APPLE_FUNC(glVertex4fv);                          \
  APPLE_FUNC(glVertex4i);                           \
  APPLE_FUNC(glVertex4iv);                          \
  APPLE_FUNC(glVertex4s);                           \
  APPLE_FUNC(glVertex4sv);                          \
  APPLE_FUNC(glVertexArrayParameteriAPPLE);         \
  APPLE_FUNC(glVertexArrayRangeAPPLE);              \
  APPLE_FUNC(glVertexBlendARB);                     \
  APPLE_FUNC(glVertexPointer);                      \
  APPLE_FUNC(glWeightbvARB);                        \
  APPLE_FUNC(glWeightdvARB);                        \
  APPLE_FUNC(glWeightfvARB);                        \
  APPLE_FUNC(glWeightivARB);                        \
  APPLE_FUNC(glWeightPointerARB);                   \
  APPLE_FUNC(glWeightsvARB);                        \
  APPLE_FUNC(glWeightubvARB);                       \
  APPLE_FUNC(glWeightuivARB);                       \
  APPLE_FUNC(glWeightusvARB);                       \
  APPLE_FUNC(glWindowPos2d);                        \
  APPLE_FUNC(glWindowPos2dARB);                     \
  APPLE_FUNC(glWindowPos2dv);                       \
  APPLE_FUNC(glWindowPos2dvARB);                    \
  APPLE_FUNC(glWindowPos2f);                        \
  APPLE_FUNC(glWindowPos2fARB);                     \
  APPLE_FUNC(glWindowPos2fv);                       \
  APPLE_FUNC(glWindowPos2fvARB);                    \
  APPLE_FUNC(glWindowPos2i);                        \
  APPLE_FUNC(glWindowPos2iARB);                     \
  APPLE_FUNC(glWindowPos2iv);                       \
  APPLE_FUNC(glWindowPos2ivARB);                    \
  APPLE_FUNC(glWindowPos2s);                        \
  APPLE_FUNC(glWindowPos2sARB);                     \
  APPLE_FUNC(glWindowPos2sv);                       \
  APPLE_FUNC(glWindowPos2svARB);                    \
  APPLE_FUNC(glWindowPos3d);                        \
  APPLE_FUNC(glWindowPos3dARB);                     \
  APPLE_FUNC(glWindowPos3dv);                       \
  APPLE_FUNC(glWindowPos3dvARB);                    \
  APPLE_FUNC(glWindowPos3f);                        \
  APPLE_FUNC(glWindowPos3fARB);                     \
  APPLE_FUNC(glWindowPos3fv);                       \
  APPLE_FUNC(glWindowPos3fvARB);                    \
  APPLE_FUNC(glWindowPos3i);                        \
  APPLE_FUNC(glWindowPos3iARB);                     \
  APPLE_FUNC(glWindowPos3iv);                       \
  APPLE_FUNC(glWindowPos3ivARB);                    \
  APPLE_FUNC(glWindowPos3s);                        \
  APPLE_FUNC(glWindowPos3sARB);                     \
  APPLE_FUNC(glWindowPos3sv);                       \
  APPLE_FUNC(glWindowPos3svARB);
