# This file is auto-generated by /codegen/x86_64_test_encoding.py
# Reference opcodes are generated by:
#     GNU assembler (GNU Binutils) 2.28.51.20170402

from peachpy.x86_64 import *
import unittest


class TestADD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x04, 0x02]), ADD(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xC3, 0x02]), ADD(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x00, 0xCB]), ADD(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x02, 0x5C, 0xBE, 0x85]), ADD(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x05, 0x00, 0x7D]), ADD(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xC6, 0x02]), ADD(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xC6, 0x00, 0x7D]), ADD(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x01, 0xE6]), ADD(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x03, 0x74, 0xED, 0x95]), ADD(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x05, 0x00, 0x00, 0x00, 0x10]), ADD(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xC5, 0x02]), ADD(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xC5, 0x00, 0x00, 0x00, 0x10]), ADD(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x01, 0xC5]), ADD(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x03, 0x6C, 0xCC, 0x9D]), ADD(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x05, 0x00, 0x00, 0x00, 0x10]), ADD(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xC1, 0x02]), ADD(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xC1, 0x00, 0x00, 0x00, 0x10]), ADD(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x01, 0xF9]), ADD(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x03, 0x4C, 0xD3, 0xA8]), ADD(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x44, 0xBE, 0x85, 0x02]), ADD(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x00, 0x4C, 0xBE, 0x85]), ADD(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x44, 0xED, 0x95, 0x02]), ADD(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x44, 0xED, 0x95, 0x00, 0x7D]), ADD(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x01, 0x64, 0xED, 0x95]), ADD(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x44, 0xCC, 0x9D, 0x02]), ADD(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x44, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), ADD(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x01, 0x44, 0xCC, 0x9D]), ADD(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x44, 0xD3, 0xA8, 0x02]), ADD(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x44, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), ADD(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x01, 0x7C, 0xD3, 0xA8]), ADD(qword[r11 + rdx*8 - 88], r15).encode())


class TestSUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x2C, 0x02]), SUB(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xEB, 0x02]), SUB(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x28, 0xCB]), SUB(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x2A, 0x5C, 0xBE, 0x85]), SUB(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x2D, 0x00, 0x7D]), SUB(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xEE, 0x02]), SUB(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xEE, 0x00, 0x7D]), SUB(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x29, 0xE6]), SUB(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x2B, 0x74, 0xED, 0x95]), SUB(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x2D, 0x00, 0x00, 0x00, 0x10]), SUB(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xED, 0x02]), SUB(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xED, 0x00, 0x00, 0x00, 0x10]), SUB(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x29, 0xC5]), SUB(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x2B, 0x6C, 0xCC, 0x9D]), SUB(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x2D, 0x00, 0x00, 0x00, 0x10]), SUB(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xE9, 0x02]), SUB(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xE9, 0x00, 0x00, 0x00, 0x10]), SUB(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x29, 0xF9]), SUB(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x2B, 0x4C, 0xD3, 0xA8]), SUB(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x6C, 0xBE, 0x85, 0x02]), SUB(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x28, 0x4C, 0xBE, 0x85]), SUB(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x6C, 0xED, 0x95, 0x02]), SUB(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x6C, 0xED, 0x95, 0x00, 0x7D]), SUB(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x29, 0x64, 0xED, 0x95]), SUB(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x6C, 0xCC, 0x9D, 0x02]), SUB(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x6C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), SUB(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x29, 0x44, 0xCC, 0x9D]), SUB(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x6C, 0xD3, 0xA8, 0x02]), SUB(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x6C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), SUB(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x29, 0x7C, 0xD3, 0xA8]), SUB(qword[r11 + rdx*8 - 88], r15).encode())


class TestADC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x14, 0x02]), ADC(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xD3, 0x02]), ADC(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x10, 0xCB]), ADC(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x12, 0x5C, 0xBE, 0x85]), ADC(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x15, 0x00, 0x7D]), ADC(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xD6, 0x02]), ADC(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xD6, 0x00, 0x7D]), ADC(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x11, 0xE6]), ADC(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x13, 0x74, 0xED, 0x95]), ADC(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x15, 0x00, 0x00, 0x00, 0x10]), ADC(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xD5, 0x02]), ADC(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xD5, 0x00, 0x00, 0x00, 0x10]), ADC(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x11, 0xC5]), ADC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x13, 0x6C, 0xCC, 0x9D]), ADC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x15, 0x00, 0x00, 0x00, 0x10]), ADC(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xD1, 0x02]), ADC(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xD1, 0x00, 0x00, 0x00, 0x10]), ADC(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x11, 0xF9]), ADC(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x13, 0x4C, 0xD3, 0xA8]), ADC(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x54, 0xBE, 0x85, 0x02]), ADC(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x10, 0x4C, 0xBE, 0x85]), ADC(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x54, 0xED, 0x95, 0x02]), ADC(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x54, 0xED, 0x95, 0x00, 0x7D]), ADC(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x11, 0x64, 0xED, 0x95]), ADC(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x54, 0xCC, 0x9D, 0x02]), ADC(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x54, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), ADC(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x11, 0x44, 0xCC, 0x9D]), ADC(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x54, 0xD3, 0xA8, 0x02]), ADC(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x54, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), ADC(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x11, 0x7C, 0xD3, 0xA8]), ADC(qword[r11 + rdx*8 - 88], r15).encode())


class TestSBB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x1C, 0x02]), SBB(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xDB, 0x02]), SBB(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x18, 0xCB]), SBB(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x1A, 0x5C, 0xBE, 0x85]), SBB(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x1D, 0x00, 0x7D]), SBB(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xDE, 0x02]), SBB(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xDE, 0x00, 0x7D]), SBB(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x19, 0xE6]), SBB(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x1B, 0x74, 0xED, 0x95]), SBB(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x1D, 0x00, 0x00, 0x00, 0x10]), SBB(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xDD, 0x02]), SBB(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xDD, 0x00, 0x00, 0x00, 0x10]), SBB(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x19, 0xC5]), SBB(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x1B, 0x6C, 0xCC, 0x9D]), SBB(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x1D, 0x00, 0x00, 0x00, 0x10]), SBB(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xD9, 0x02]), SBB(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xD9, 0x00, 0x00, 0x00, 0x10]), SBB(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x19, 0xF9]), SBB(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x1B, 0x4C, 0xD3, 0xA8]), SBB(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x5C, 0xBE, 0x85, 0x02]), SBB(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x18, 0x4C, 0xBE, 0x85]), SBB(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x5C, 0xED, 0x95, 0x02]), SBB(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x5C, 0xED, 0x95, 0x00, 0x7D]), SBB(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x19, 0x64, 0xED, 0x95]), SBB(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x5C, 0xCC, 0x9D, 0x02]), SBB(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x5C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), SBB(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x19, 0x44, 0xCC, 0x9D]), SBB(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x5C, 0xD3, 0xA8, 0x02]), SBB(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x5C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), SBB(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x19, 0x7C, 0xD3, 0xA8]), SBB(qword[r11 + rdx*8 - 88], r15).encode())


class TestADCX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0xF6, 0xE8]), ADCX(ebp, r8d).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0xF6, 0x6C, 0xCC, 0x9D]), ADCX(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x66, 0x49, 0x0F, 0x38, 0xF6, 0xCF]), ADCX(rcx, r15).encode())
        self.assertEqual(bytearray([0x66, 0x49, 0x0F, 0x38, 0xF6, 0x4C, 0xD3, 0xA8]), ADCX(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestADOX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x38, 0xF6, 0xE8]), ADOX(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x38, 0xF6, 0x6C, 0xCC, 0x9D]), ADOX(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x38, 0xF6, 0xCF]), ADOX(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x38, 0xF6, 0x4C, 0xD3, 0xA8]), ADOX(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestAND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x24, 0x02]), AND(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xE3, 0x02]), AND(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x20, 0xCB]), AND(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x22, 0x5C, 0xBE, 0x85]), AND(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x25, 0x00, 0x7D]), AND(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xE6, 0x02]), AND(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xE6, 0x00, 0x7D]), AND(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x21, 0xE6]), AND(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x23, 0x74, 0xED, 0x95]), AND(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x25, 0x00, 0x00, 0x00, 0x10]), AND(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xE5, 0x02]), AND(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xE5, 0x00, 0x00, 0x00, 0x10]), AND(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x21, 0xC5]), AND(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x23, 0x6C, 0xCC, 0x9D]), AND(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x25, 0x00, 0x00, 0x00, 0x10]), AND(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xE1, 0x02]), AND(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xE1, 0x00, 0x00, 0x00, 0x10]), AND(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x21, 0xF9]), AND(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x23, 0x4C, 0xD3, 0xA8]), AND(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x64, 0xBE, 0x85, 0x02]), AND(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x20, 0x4C, 0xBE, 0x85]), AND(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x64, 0xED, 0x95, 0x02]), AND(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x64, 0xED, 0x95, 0x00, 0x7D]), AND(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x21, 0x64, 0xED, 0x95]), AND(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x64, 0xCC, 0x9D, 0x02]), AND(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x64, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), AND(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x21, 0x44, 0xCC, 0x9D]), AND(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x64, 0xD3, 0xA8, 0x02]), AND(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x64, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), AND(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x21, 0x7C, 0xD3, 0xA8]), AND(qword[r11 + rdx*8 - 88], r15).encode())


class TestOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0C, 0x02]), OR(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xCB, 0x02]), OR(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x08, 0xCB]), OR(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x0A, 0x5C, 0xBE, 0x85]), OR(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x0D, 0x00, 0x7D]), OR(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xCE, 0x02]), OR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xCE, 0x00, 0x7D]), OR(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x09, 0xE6]), OR(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0B, 0x74, 0xED, 0x95]), OR(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x0D, 0x00, 0x00, 0x00, 0x10]), OR(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xCD, 0x02]), OR(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xCD, 0x00, 0x00, 0x00, 0x10]), OR(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x09, 0xC5]), OR(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0B, 0x6C, 0xCC, 0x9D]), OR(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x0D, 0x00, 0x00, 0x00, 0x10]), OR(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xC9, 0x02]), OR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xC9, 0x00, 0x00, 0x00, 0x10]), OR(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x09, 0xF9]), OR(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0B, 0x4C, 0xD3, 0xA8]), OR(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x4C, 0xBE, 0x85, 0x02]), OR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x08, 0x4C, 0xBE, 0x85]), OR(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x4C, 0xED, 0x95, 0x02]), OR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x4C, 0xED, 0x95, 0x00, 0x7D]), OR(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x09, 0x64, 0xED, 0x95]), OR(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x4C, 0xCC, 0x9D, 0x02]), OR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x4C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), OR(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x09, 0x44, 0xCC, 0x9D]), OR(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x4C, 0xD3, 0xA8, 0x02]), OR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x4C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), OR(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x09, 0x7C, 0xD3, 0xA8]), OR(qword[r11 + rdx*8 - 88], r15).encode())


class TestXOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x34, 0x02]), XOR(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xF3, 0x02]), XOR(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x30, 0xCB]), XOR(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x32, 0x5C, 0xBE, 0x85]), XOR(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x35, 0x00, 0x7D]), XOR(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xF6, 0x02]), XOR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xF6, 0x00, 0x7D]), XOR(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x31, 0xE6]), XOR(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x33, 0x74, 0xED, 0x95]), XOR(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x35, 0x00, 0x00, 0x00, 0x10]), XOR(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xF5, 0x02]), XOR(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xF5, 0x00, 0x00, 0x00, 0x10]), XOR(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x31, 0xC5]), XOR(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x33, 0x6C, 0xCC, 0x9D]), XOR(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x35, 0x00, 0x00, 0x00, 0x10]), XOR(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xF1, 0x02]), XOR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xF1, 0x00, 0x00, 0x00, 0x10]), XOR(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x31, 0xF9]), XOR(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x33, 0x4C, 0xD3, 0xA8]), XOR(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x74, 0xBE, 0x85, 0x02]), XOR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x30, 0x4C, 0xBE, 0x85]), XOR(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x74, 0xED, 0x95, 0x02]), XOR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x74, 0xED, 0x95, 0x00, 0x7D]), XOR(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x31, 0x64, 0xED, 0x95]), XOR(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x74, 0xCC, 0x9D, 0x02]), XOR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x74, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), XOR(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x31, 0x44, 0xCC, 0x9D]), XOR(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x74, 0xD3, 0xA8, 0x02]), XOR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x74, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), XOR(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x31, 0x7C, 0xD3, 0xA8]), XOR(qword[r11 + rdx*8 - 88], r15).encode())


class TestANDN(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x38, 0xF2, 0xE8]), ANDN(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x38, 0xF2, 0x6C, 0xCC, 0x9D]), ANDN(ebp, r8d, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x80, 0xF2, 0xC8]), ANDN(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x80, 0xF2, 0x4C, 0xD3, 0xA8]), ANDN(rcx, r15, qword[r11 + rdx*8 - 88]).encode())


class TestNOT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xD3]), NOT(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xD6]), NOT(si).encode())
        self.assertEqual(bytearray([0xF7, 0xD5]), NOT(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xD1]), NOT(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x54, 0xBE, 0x85]), NOT(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x54, 0xED, 0x95]), NOT(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x54, 0xCC, 0x9D]), NOT(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x54, 0xD3, 0xA8]), NOT(qword[r11 + rdx*8 - 88]).encode())


class TestNEG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xDB]), NEG(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xDE]), NEG(si).encode())
        self.assertEqual(bytearray([0xF7, 0xDD]), NEG(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xD9]), NEG(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x5C, 0xBE, 0x85]), NEG(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x5C, 0xED, 0x95]), NEG(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x5C, 0xCC, 0x9D]), NEG(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x5C, 0xD3, 0xA8]), NEG(qword[r11 + rdx*8 - 88]).encode())


class TestINC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFE, 0xC3]), INC(bl).encode())
        self.assertEqual(bytearray([0x66, 0xFF, 0xC6]), INC(si).encode())
        self.assertEqual(bytearray([0xFF, 0xC5]), INC(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xFF, 0xC1]), INC(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xFE, 0x44, 0xBE, 0x85]), INC(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xFF, 0x44, 0xED, 0x95]), INC(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xFF, 0x44, 0xCC, 0x9D]), INC(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xFF, 0x44, 0xD3, 0xA8]), INC(qword[r11 + rdx*8 - 88]).encode())


class TestDEC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFE, 0xCB]), DEC(bl).encode())
        self.assertEqual(bytearray([0x66, 0xFF, 0xCE]), DEC(si).encode())
        self.assertEqual(bytearray([0xFF, 0xCD]), DEC(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xFF, 0xC9]), DEC(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xFE, 0x4C, 0xBE, 0x85]), DEC(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xFF, 0x4C, 0xED, 0x95]), DEC(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xFF, 0x4C, 0xCC, 0x9D]), DEC(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xFF, 0x4C, 0xD3, 0xA8]), DEC(qword[r11 + rdx*8 - 88]).encode())


class TestTEST(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xA8, 0x02]), TEST(al, 2).encode())
        self.assertEqual(bytearray([0xF6, 0xC3, 0x02]), TEST(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x84, 0xCB]), TEST(bl, r9b).encode())
        self.assertEqual(bytearray([0x66, 0xA9, 0x00, 0x7D]), TEST(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xC6, 0x00, 0x7D]), TEST(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x85, 0xE6]), TEST(si, r12w).encode())
        self.assertEqual(bytearray([0xA9, 0x00, 0x00, 0x00, 0x10]), TEST(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0xF7, 0xC5, 0x00, 0x00, 0x00, 0x10]), TEST(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x85, 0xC5]), TEST(ebp, r8d).encode())
        self.assertEqual(bytearray([0x48, 0xA9, 0x00, 0x00, 0x00, 0x10]), TEST(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xC1, 0x00, 0x00, 0x00, 0x10]), TEST(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x85, 0xF9]), TEST(rcx, r15).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x44, 0xBE, 0x85, 0x02]), TEST(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x84, 0x4C, 0xBE, 0x85]), TEST(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x44, 0xED, 0x95, 0x00, 0x7D]), TEST(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x85, 0x64, 0xED, 0x95]), TEST(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x44, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), TEST(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x85, 0x44, 0xCC, 0x9D]), TEST(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x44, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), TEST(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x85, 0x7C, 0xD3, 0xA8]), TEST(qword[r11 + rdx*8 - 88], r15).encode())


class TestCMP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x3C, 0x02]), CMP(al, 2).encode())
        self.assertEqual(bytearray([0x80, 0xFB, 0x02]), CMP(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x38, 0xCB]), CMP(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x3A, 0x5C, 0xBE, 0x85]), CMP(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x3D, 0x00, 0x7D]), CMP(ax, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x83, 0xFE, 0x02]), CMP(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x81, 0xFE, 0x00, 0x7D]), CMP(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x39, 0xE6]), CMP(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x3B, 0x74, 0xED, 0x95]), CMP(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x3D, 0x00, 0x00, 0x00, 0x10]), CMP(eax, 0x10000000).encode())
        self.assertEqual(bytearray([0x83, 0xFD, 0x02]), CMP(ebp, 2).encode())
        self.assertEqual(bytearray([0x81, 0xFD, 0x00, 0x00, 0x00, 0x10]), CMP(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x39, 0xC5]), CMP(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x3B, 0x6C, 0xCC, 0x9D]), CMP(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0x3D, 0x00, 0x00, 0x00, 0x10]), CMP(rax, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0x83, 0xF9, 0x02]), CMP(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0x81, 0xF9, 0x00, 0x00, 0x00, 0x10]), CMP(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x4C, 0x39, 0xF9]), CMP(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x3B, 0x4C, 0xD3, 0xA8]), CMP(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x80, 0x7C, 0xBE, 0x85, 0x02]), CMP(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x38, 0x4C, 0xBE, 0x85]), CMP(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x83, 0x7C, 0xED, 0x95, 0x02]), CMP(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x81, 0x7C, 0xED, 0x95, 0x00, 0x7D]), CMP(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x39, 0x64, 0xED, 0x95]), CMP(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x83, 0x7C, 0xCC, 0x9D, 0x02]), CMP(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x81, 0x7C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), CMP(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x39, 0x44, 0xCC, 0x9D]), CMP(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x83, 0x7C, 0xD3, 0xA8, 0x02]), CMP(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x81, 0x7C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), CMP(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x39, 0x7C, 0xD3, 0xA8]), CMP(qword[r11 + rdx*8 - 88], r15).encode())


class TestMOV(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xB3, 0x02]), MOV(bl, 2).encode())
        self.assertEqual(bytearray([0x44, 0x88, 0xCB]), MOV(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x8A, 0x5C, 0xBE, 0x85]), MOV(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0xBE, 0x00, 0x7D]), MOV(si, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x89, 0xE6]), MOV(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x8B, 0x74, 0xED, 0x95]), MOV(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xBD, 0x00, 0x00, 0x00, 0x10]), MOV(ebp, 0x10000000).encode())
        self.assertEqual(bytearray([0x44, 0x89, 0xC5]), MOV(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x8B, 0x6C, 0xCC, 0x9D]), MOV(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x48, 0xC7, 0xC1, 0x00, 0x00, 0x00, 0x10]), MOV(rcx, 0x10000000).encode())
        self.assertEqual(bytearray([0x48, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00]), MOV(rcx, 0x100000000).encode())
        self.assertEqual(bytearray([0x4C, 0x89, 0xF9]), MOV(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x8B, 0x4C, 0xD3, 0xA8]), MOV(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0xC6, 0x44, 0xBE, 0x85, 0x02]), MOV(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x45, 0x88, 0x4C, 0xBE, 0x85]), MOV(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC7, 0x44, 0xED, 0x95, 0x00, 0x7D]), MOV(word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x89, 0x64, 0xED, 0x95]), MOV(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0xC7, 0x44, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), MOV(dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x45, 0x89, 0x44, 0xCC, 0x9D]), MOV(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0xC7, 0x44, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), MOV(qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0x4D, 0x89, 0x7C, 0xD3, 0xA8]), MOV(qword[r11 + rdx*8 - 88], r15).encode())


class TestMOVZX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xB6, 0xF1]), MOVZX(si, r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xB6, 0x74, 0xBE, 0x85]), MOVZX(si, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xB6, 0xE9]), MOVZX(ebp, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xB7, 0xEC]), MOVZX(ebp, r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xB6, 0x6C, 0xBE, 0x85]), MOVZX(ebp, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xB7, 0x6C, 0xED, 0x95]), MOVZX(ebp, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xB6, 0xC9]), MOVZX(rcx, r9b).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xB7, 0xCC]), MOVZX(rcx, r12w).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xB6, 0x4C, 0xBE, 0x85]), MOVZX(rcx, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xB7, 0x4C, 0xED, 0x95]), MOVZX(rcx, word[r13 + rbp*8 - 107]).encode())


class TestMOVSX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBE, 0xF1]), MOVSX(si, r9b).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBE, 0x74, 0xBE, 0x85]), MOVSX(si, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBE, 0xE9]), MOVSX(ebp, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBF, 0xEC]), MOVSX(ebp, r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBE, 0x6C, 0xBE, 0x85]), MOVSX(ebp, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBF, 0x6C, 0xED, 0x95]), MOVSX(ebp, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBE, 0xC9]), MOVSX(rcx, r9b).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBF, 0xCC]), MOVSX(rcx, r12w).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBE, 0x4C, 0xBE, 0x85]), MOVSX(rcx, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBF, 0x4C, 0xED, 0x95]), MOVSX(rcx, word[r13 + rbp*8 - 107]).encode())


class TestMOVSXD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x49, 0x63, 0xC8]), MOVSXD(rcx, r8d).encode())
        self.assertEqual(bytearray([0x49, 0x63, 0x4C, 0xCC, 0x9D]), MOVSXD(rcx, dword[r12 + rcx*8 - 99]).encode())


class TestMOVBE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0xF0, 0x74, 0xED, 0x95]), MOVBE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0xF0, 0x6C, 0xCC, 0x9D]), MOVBE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x38, 0xF0, 0x4C, 0xD3, 0xA8]), MOVBE(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x38, 0xF1, 0x64, 0xED, 0x95]), MOVBE(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0x38, 0xF1, 0x44, 0xCC, 0x9D]), MOVBE(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0x38, 0xF1, 0x7C, 0xD3, 0xA8]), MOVBE(qword[r11 + rdx*8 - 88], r15).encode())


class TestMOVNTI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x45, 0x0F, 0xC3, 0x44, 0xCC, 0x9D]), MOVNTI(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xC3, 0x7C, 0xD3, 0xA8]), MOVNTI(qword[r11 + rdx*8 - 88], r15).encode())


class TestBT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0xBA, 0xE6, 0x02]), BT(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xA3, 0xE6]), BT(si, r12w).encode())
        self.assertEqual(bytearray([0x0F, 0xBA, 0xE5, 0x02]), BT(ebp, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xA3, 0xC5]), BT(ebp, r8d).encode())
        self.assertEqual(bytearray([0x48, 0x0F, 0xBA, 0xE1, 0x02]), BT(rcx, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xA3, 0xF9]), BT(rcx, r15).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBA, 0x64, 0xED, 0x95, 0x02]), BT(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xA3, 0x64, 0xED, 0x95]), BT(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBA, 0x64, 0xCC, 0x9D, 0x02]), BT(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xA3, 0x44, 0xCC, 0x9D]), BT(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBA, 0x64, 0xD3, 0xA8, 0x02]), BT(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xA3, 0x7C, 0xD3, 0xA8]), BT(qword[r11 + rdx*8 - 88], r15).encode())


class TestBTS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0xBA, 0xEE, 0x02]), BTS(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xAB, 0xE6]), BTS(si, r12w).encode())
        self.assertEqual(bytearray([0x0F, 0xBA, 0xED, 0x02]), BTS(ebp, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xAB, 0xC5]), BTS(ebp, r8d).encode())
        self.assertEqual(bytearray([0x48, 0x0F, 0xBA, 0xE9, 0x02]), BTS(rcx, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xAB, 0xF9]), BTS(rcx, r15).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBA, 0x6C, 0xED, 0x95, 0x02]), BTS(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xAB, 0x64, 0xED, 0x95]), BTS(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBA, 0x6C, 0xCC, 0x9D, 0x02]), BTS(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xAB, 0x44, 0xCC, 0x9D]), BTS(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBA, 0x6C, 0xD3, 0xA8, 0x02]), BTS(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xAB, 0x7C, 0xD3, 0xA8]), BTS(qword[r11 + rdx*8 - 88], r15).encode())


class TestBTR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0xBA, 0xF6, 0x02]), BTR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xB3, 0xE6]), BTR(si, r12w).encode())
        self.assertEqual(bytearray([0x0F, 0xBA, 0xF5, 0x02]), BTR(ebp, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xB3, 0xC5]), BTR(ebp, r8d).encode())
        self.assertEqual(bytearray([0x48, 0x0F, 0xBA, 0xF1, 0x02]), BTR(rcx, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xB3, 0xF9]), BTR(rcx, r15).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBA, 0x74, 0xED, 0x95, 0x02]), BTR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xB3, 0x64, 0xED, 0x95]), BTR(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBA, 0x74, 0xCC, 0x9D, 0x02]), BTR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xB3, 0x44, 0xCC, 0x9D]), BTR(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBA, 0x74, 0xD3, 0xA8, 0x02]), BTR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xB3, 0x7C, 0xD3, 0xA8]), BTR(qword[r11 + rdx*8 - 88], r15).encode())


class TestBTC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0xBA, 0xFE, 0x02]), BTC(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xBB, 0xE6]), BTC(si, r12w).encode())
        self.assertEqual(bytearray([0x0F, 0xBA, 0xFD, 0x02]), BTC(ebp, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xBB, 0xC5]), BTC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x48, 0x0F, 0xBA, 0xF9, 0x02]), BTC(rcx, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xBB, 0xF9]), BTC(rcx, r15).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBA, 0x7C, 0xED, 0x95, 0x02]), BTC(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xBB, 0x64, 0xED, 0x95]), BTC(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBA, 0x7C, 0xCC, 0x9D, 0x02]), BTC(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xBB, 0x44, 0xCC, 0x9D]), BTC(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBA, 0x7C, 0xD3, 0xA8, 0x02]), BTC(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xBB, 0x7C, 0xD3, 0xA8]), BTC(qword[r11 + rdx*8 - 88], r15).encode())


class TestPOPCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xB8, 0xF4]), POPCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xB8, 0x74, 0xED, 0x95]), POPCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xB8, 0xE8]), POPCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xB8, 0x6C, 0xCC, 0x9D]), POPCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xB8, 0xCF]), POPCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xB8, 0x4C, 0xD3, 0xA8]), POPCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBSWAP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xCD]), BSWAP(ebp).encode())
        self.assertEqual(bytearray([0x48, 0x0F, 0xC9]), BSWAP(rcx).encode())


class TestBSF(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBC, 0xF4]), BSF(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBC, 0x74, 0xED, 0x95]), BSF(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBC, 0xE8]), BSF(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBC, 0x6C, 0xCC, 0x9D]), BSF(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBC, 0xCF]), BSF(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBC, 0x4C, 0xD3, 0xA8]), BSF(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBD, 0xF4]), BSR(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xBD, 0x74, 0xED, 0x95]), BSR(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBD, 0xE8]), BSR(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xBD, 0x6C, 0xCC, 0x9D]), BSR(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBD, 0xCF]), BSR(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xBD, 0x4C, 0xD3, 0xA8]), BSR(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestLZCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBD, 0xF4]), LZCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBD, 0x74, 0xED, 0x95]), LZCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBD, 0xE8]), LZCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBD, 0x6C, 0xCC, 0x9D]), LZCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBD, 0xCF]), LZCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBD, 0x4C, 0xD3, 0xA8]), LZCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestTZCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBC, 0xF4]), TZCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBC, 0x74, 0xED, 0x95]), TZCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBC, 0xE8]), TZCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBC, 0x6C, 0xCC, 0x9D]), TZCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBC, 0xCF]), TZCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBC, 0x4C, 0xD3, 0xA8]), TZCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestSHR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xEB]), SHR(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xEB, 0x02]), SHR(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xEB]), SHR(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xEE]), SHR(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xEE, 0x02]), SHR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xEE]), SHR(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xED]), SHR(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xED, 0x02]), SHR(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xED]), SHR(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xE9]), SHR(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xE9, 0x02]), SHR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xE9]), SHR(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x6C, 0xBE, 0x85]), SHR(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x6C, 0xBE, 0x85, 0x02]), SHR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x6C, 0xBE, 0x85]), SHR(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x6C, 0xED, 0x95]), SHR(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x6C, 0xED, 0x95, 0x02]), SHR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x6C, 0xED, 0x95]), SHR(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x6C, 0xCC, 0x9D]), SHR(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x6C, 0xCC, 0x9D, 0x02]), SHR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x6C, 0xCC, 0x9D]), SHR(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x6C, 0xD3, 0xA8]), SHR(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x6C, 0xD3, 0xA8, 0x02]), SHR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x6C, 0xD3, 0xA8]), SHR(qword[r11 + rdx*8 - 88], cl).encode())


class TestSAR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xFB]), SAR(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xFB, 0x02]), SAR(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xFB]), SAR(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xFE]), SAR(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xFE, 0x02]), SAR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xFE]), SAR(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xFD]), SAR(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xFD, 0x02]), SAR(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xFD]), SAR(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xF9]), SAR(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xF9, 0x02]), SAR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xF9]), SAR(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x7C, 0xBE, 0x85]), SAR(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x7C, 0xBE, 0x85, 0x02]), SAR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x7C, 0xBE, 0x85]), SAR(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x7C, 0xED, 0x95]), SAR(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x7C, 0xED, 0x95, 0x02]), SAR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x7C, 0xED, 0x95]), SAR(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x7C, 0xCC, 0x9D]), SAR(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x7C, 0xCC, 0x9D, 0x02]), SAR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x7C, 0xCC, 0x9D]), SAR(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x7C, 0xD3, 0xA8]), SAR(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x7C, 0xD3, 0xA8, 0x02]), SAR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x7C, 0xD3, 0xA8]), SAR(qword[r11 + rdx*8 - 88], cl).encode())


class TestSHL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xE3]), SHL(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xE3, 0x02]), SHL(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xE3]), SHL(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xE6]), SHL(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xE6, 0x02]), SHL(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xE6]), SHL(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xE5]), SHL(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xE5, 0x02]), SHL(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xE5]), SHL(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xE1]), SHL(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xE1, 0x02]), SHL(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xE1]), SHL(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x64, 0xBE, 0x85]), SHL(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x64, 0xBE, 0x85, 0x02]), SHL(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x64, 0xBE, 0x85]), SHL(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x64, 0xED, 0x95]), SHL(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x64, 0xED, 0x95, 0x02]), SHL(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x64, 0xED, 0x95]), SHL(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x64, 0xCC, 0x9D]), SHL(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x64, 0xCC, 0x9D, 0x02]), SHL(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x64, 0xCC, 0x9D]), SHL(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x64, 0xD3, 0xA8]), SHL(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x64, 0xD3, 0xA8, 0x02]), SHL(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x64, 0xD3, 0xA8]), SHL(qword[r11 + rdx*8 - 88], cl).encode())


class TestSAL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xE3]), SAL(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xE3, 0x02]), SAL(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xE3]), SAL(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xE6]), SAL(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xE6, 0x02]), SAL(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xE6]), SAL(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xE5]), SAL(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xE5, 0x02]), SAL(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xE5]), SAL(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xE1]), SAL(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xE1, 0x02]), SAL(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xE1]), SAL(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x64, 0xBE, 0x85]), SAL(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x64, 0xBE, 0x85, 0x02]), SAL(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x64, 0xBE, 0x85]), SAL(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x64, 0xED, 0x95]), SAL(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x64, 0xED, 0x95, 0x02]), SAL(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x64, 0xED, 0x95]), SAL(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x64, 0xCC, 0x9D]), SAL(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x64, 0xCC, 0x9D, 0x02]), SAL(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x64, 0xCC, 0x9D]), SAL(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x64, 0xD3, 0xA8]), SAL(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x64, 0xD3, 0xA8, 0x02]), SAL(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x64, 0xD3, 0xA8]), SAL(qword[r11 + rdx*8 - 88], cl).encode())


class TestSHRX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7B, 0xF7, 0xE8]), SHRX(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7B, 0xF7, 0x6C, 0xCC, 0x9D]), SHRX(ebp, dword[r12 + rcx*8 - 99], eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xFB, 0xF7, 0xCF]), SHRX(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xFB, 0xF7, 0x4C, 0xD3, 0xA8]), SHRX(rcx, qword[r11 + rdx*8 - 88], rax).encode())


class TestSARX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7A, 0xF7, 0xE8]), SARX(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7A, 0xF7, 0x6C, 0xCC, 0x9D]), SARX(ebp, dword[r12 + rcx*8 - 99], eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xFA, 0xF7, 0xCF]), SARX(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xFA, 0xF7, 0x4C, 0xD3, 0xA8]), SARX(rcx, qword[r11 + rdx*8 - 88], rax).encode())


class TestSHLX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0xF7, 0xE8]), SHLX(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0xF7, 0x6C, 0xCC, 0x9D]), SHLX(ebp, dword[r12 + rcx*8 - 99], eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF9, 0xF7, 0xCF]), SHLX(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF9, 0xF7, 0x4C, 0xD3, 0xA8]), SHLX(rcx, qword[r11 + rdx*8 - 88], rax).encode())


class TestSHRD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xAC, 0xE6, 0x02]), SHRD(si, r12w, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xAD, 0xE6]), SHRD(si, r12w, cl).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xAC, 0xC5, 0x02]), SHRD(ebp, r8d, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xAD, 0xC5]), SHRD(ebp, r8d, cl).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xAC, 0xF9, 0x02]), SHRD(rcx, r15, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xAD, 0xF9]), SHRD(rcx, r15, cl).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xAC, 0x64, 0xED, 0x95, 0x02]), SHRD(word[r13 + rbp*8 - 107], r12w, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xAD, 0x64, 0xED, 0x95]), SHRD(word[r13 + rbp*8 - 107], r12w, cl).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xAC, 0x44, 0xCC, 0x9D, 0x02]), SHRD(dword[r12 + rcx*8 - 99], r8d, 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xAD, 0x44, 0xCC, 0x9D]), SHRD(dword[r12 + rcx*8 - 99], r8d, cl).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xAC, 0x7C, 0xD3, 0xA8, 0x02]), SHRD(qword[r11 + rdx*8 - 88], r15, 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xAD, 0x7C, 0xD3, 0xA8]), SHRD(qword[r11 + rdx*8 - 88], r15, cl).encode())


class TestSHLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xA4, 0xE6, 0x02]), SHLD(si, r12w, 2).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xA5, 0xE6]), SHLD(si, r12w, cl).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xA4, 0xC5, 0x02]), SHLD(ebp, r8d, 2).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xA5, 0xC5]), SHLD(ebp, r8d, cl).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xA4, 0xF9, 0x02]), SHLD(rcx, r15, 2).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xA5, 0xF9]), SHLD(rcx, r15, cl).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xA4, 0x64, 0xED, 0x95, 0x02]), SHLD(word[r13 + rbp*8 - 107], r12w, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xA5, 0x64, 0xED, 0x95]), SHLD(word[r13 + rbp*8 - 107], r12w, cl).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xA4, 0x44, 0xCC, 0x9D, 0x02]), SHLD(dword[r12 + rcx*8 - 99], r8d, 2).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xA5, 0x44, 0xCC, 0x9D]), SHLD(dword[r12 + rcx*8 - 99], r8d, cl).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xA4, 0x7C, 0xD3, 0xA8, 0x02]), SHLD(qword[r11 + rdx*8 - 88], r15, 2).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xA5, 0x7C, 0xD3, 0xA8]), SHLD(qword[r11 + rdx*8 - 88], r15, cl).encode())


class TestROR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xCB]), ROR(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xCB, 0x02]), ROR(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xCB]), ROR(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xCE]), ROR(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xCE, 0x02]), ROR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xCE]), ROR(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xCD]), ROR(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xCD, 0x02]), ROR(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xCD]), ROR(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xC9]), ROR(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xC9, 0x02]), ROR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xC9]), ROR(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x4C, 0xBE, 0x85]), ROR(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x4C, 0xBE, 0x85, 0x02]), ROR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x4C, 0xBE, 0x85]), ROR(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x4C, 0xED, 0x95]), ROR(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x4C, 0xED, 0x95, 0x02]), ROR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x4C, 0xED, 0x95]), ROR(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x4C, 0xCC, 0x9D]), ROR(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x4C, 0xCC, 0x9D, 0x02]), ROR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x4C, 0xCC, 0x9D]), ROR(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x4C, 0xD3, 0xA8]), ROR(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x4C, 0xD3, 0xA8, 0x02]), ROR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x4C, 0xD3, 0xA8]), ROR(qword[r11 + rdx*8 - 88], cl).encode())


class TestROL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xC3]), ROL(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xC3, 0x02]), ROL(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xC3]), ROL(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xC6]), ROL(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xC6, 0x02]), ROL(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xC6]), ROL(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xC5]), ROL(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xC5, 0x02]), ROL(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xC5]), ROL(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xC1]), ROL(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xC1, 0x02]), ROL(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xC1]), ROL(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x44, 0xBE, 0x85]), ROL(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x44, 0xBE, 0x85, 0x02]), ROL(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x44, 0xBE, 0x85]), ROL(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x44, 0xED, 0x95]), ROL(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x44, 0xED, 0x95, 0x02]), ROL(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x44, 0xED, 0x95]), ROL(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x44, 0xCC, 0x9D]), ROL(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x44, 0xCC, 0x9D, 0x02]), ROL(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x44, 0xCC, 0x9D]), ROL(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x44, 0xD3, 0xA8]), ROL(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x44, 0xD3, 0xA8, 0x02]), ROL(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x44, 0xD3, 0xA8]), ROL(qword[r11 + rdx*8 - 88], cl).encode())


class TestRORX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7B, 0xF0, 0xE8, 0x02]), RORX(ebp, r8d, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7B, 0xF0, 0x6C, 0xCC, 0x9D, 0x02]), RORX(ebp, dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFB, 0xF0, 0xCF, 0x02]), RORX(rcx, r15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFB, 0xF0, 0x4C, 0xD3, 0xA8, 0x02]), RORX(rcx, qword[r11 + rdx*8 - 88], 2).encode())


class TestRCR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xDB]), RCR(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xDB, 0x02]), RCR(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xDB]), RCR(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xDE]), RCR(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xDE, 0x02]), RCR(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xDE]), RCR(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xDD]), RCR(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xDD, 0x02]), RCR(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xDD]), RCR(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xD9]), RCR(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xD9, 0x02]), RCR(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xD9]), RCR(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x5C, 0xBE, 0x85]), RCR(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x5C, 0xBE, 0x85, 0x02]), RCR(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x5C, 0xBE, 0x85]), RCR(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x5C, 0xED, 0x95]), RCR(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x5C, 0xED, 0x95, 0x02]), RCR(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x5C, 0xED, 0x95]), RCR(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x5C, 0xCC, 0x9D]), RCR(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x5C, 0xCC, 0x9D, 0x02]), RCR(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x5C, 0xCC, 0x9D]), RCR(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x5C, 0xD3, 0xA8]), RCR(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x5C, 0xD3, 0xA8, 0x02]), RCR(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x5C, 0xD3, 0xA8]), RCR(qword[r11 + rdx*8 - 88], cl).encode())


class TestRCL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xD0, 0xD3]), RCL(bl, 1).encode())
        self.assertEqual(bytearray([0xC0, 0xD3, 0x02]), RCL(bl, 2).encode())
        self.assertEqual(bytearray([0xD2, 0xD3]), RCL(bl, cl).encode())
        self.assertEqual(bytearray([0x66, 0xD1, 0xD6]), RCL(si, 1).encode())
        self.assertEqual(bytearray([0x66, 0xC1, 0xD6, 0x02]), RCL(si, 2).encode())
        self.assertEqual(bytearray([0x66, 0xD3, 0xD6]), RCL(si, cl).encode())
        self.assertEqual(bytearray([0xD1, 0xD5]), RCL(ebp, 1).encode())
        self.assertEqual(bytearray([0xC1, 0xD5, 0x02]), RCL(ebp, 2).encode())
        self.assertEqual(bytearray([0xD3, 0xD5]), RCL(ebp, cl).encode())
        self.assertEqual(bytearray([0x48, 0xD1, 0xD1]), RCL(rcx, 1).encode())
        self.assertEqual(bytearray([0x48, 0xC1, 0xD1, 0x02]), RCL(rcx, 2).encode())
        self.assertEqual(bytearray([0x48, 0xD3, 0xD1]), RCL(rcx, cl).encode())
        self.assertEqual(bytearray([0x41, 0xD0, 0x54, 0xBE, 0x85]), RCL(byte[r14 + rdi*4 - 123], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC0, 0x54, 0xBE, 0x85, 0x02]), RCL(byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD2, 0x54, 0xBE, 0x85]), RCL(byte[r14 + rdi*4 - 123], cl).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD1, 0x54, 0xED, 0x95]), RCL(word[r13 + rbp*8 - 107], 1).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xC1, 0x54, 0xED, 0x95, 0x02]), RCL(word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xD3, 0x54, 0xED, 0x95]), RCL(word[r13 + rbp*8 - 107], cl).encode())
        self.assertEqual(bytearray([0x41, 0xD1, 0x54, 0xCC, 0x9D]), RCL(dword[r12 + rcx*8 - 99], 1).encode())
        self.assertEqual(bytearray([0x41, 0xC1, 0x54, 0xCC, 0x9D, 0x02]), RCL(dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0xD3, 0x54, 0xCC, 0x9D]), RCL(dword[r12 + rcx*8 - 99], cl).encode())
        self.assertEqual(bytearray([0x49, 0xD1, 0x54, 0xD3, 0xA8]), RCL(qword[r11 + rdx*8 - 88], 1).encode())
        self.assertEqual(bytearray([0x49, 0xC1, 0x54, 0xD3, 0xA8, 0x02]), RCL(qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0xD3, 0x54, 0xD3, 0xA8]), RCL(qword[r11 + rdx*8 - 88], cl).encode())


class TestIMUL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xEB]), IMUL(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xEE]), IMUL(si).encode())
        self.assertEqual(bytearray([0xF7, 0xED]), IMUL(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xE9]), IMUL(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x6C, 0xBE, 0x85]), IMUL(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x6C, 0xED, 0x95]), IMUL(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x6C, 0xCC, 0x9D]), IMUL(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x6C, 0xD3, 0xA8]), IMUL(qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xAF, 0xF4]), IMUL(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xAF, 0x74, 0xED, 0x95]), IMUL(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xAF, 0xE8]), IMUL(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xAF, 0x6C, 0xCC, 0x9D]), IMUL(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xAF, 0xCF]), IMUL(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0xAF, 0x4C, 0xD3, 0xA8]), IMUL(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x6B, 0xF4, 0x02]), IMUL(si, r12w, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x69, 0xF4, 0x00, 0x7D]), IMUL(si, r12w, 32000).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x6B, 0x74, 0xED, 0x95, 0x02]), IMUL(si, word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x69, 0x74, 0xED, 0x95, 0x00, 0x7D]), IMUL(si, word[r13 + rbp*8 - 107], 32000).encode())
        self.assertEqual(bytearray([0x41, 0x6B, 0xE8, 0x02]), IMUL(ebp, r8d, 2).encode())
        self.assertEqual(bytearray([0x41, 0x69, 0xE8, 0x00, 0x00, 0x00, 0x10]), IMUL(ebp, r8d, 0x10000000).encode())
        self.assertEqual(bytearray([0x41, 0x6B, 0x6C, 0xCC, 0x9D, 0x02]), IMUL(ebp, dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x41, 0x69, 0x6C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), IMUL(ebp, dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0x49, 0x6B, 0xCF, 0x02]), IMUL(rcx, r15, 2).encode())
        self.assertEqual(bytearray([0x49, 0x69, 0xCF, 0x00, 0x00, 0x00, 0x10]), IMUL(rcx, r15, 0x10000000).encode())
        self.assertEqual(bytearray([0x49, 0x6B, 0x4C, 0xD3, 0xA8, 0x02]), IMUL(rcx, qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x49, 0x69, 0x4C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), IMUL(rcx, qword[r11 + rdx*8 - 88], 0x10000000).encode())


class TestMUL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xE3]), MUL(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xE6]), MUL(si).encode())
        self.assertEqual(bytearray([0xF7, 0xE5]), MUL(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xE1]), MUL(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x64, 0xBE, 0x85]), MUL(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x64, 0xED, 0x95]), MUL(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x64, 0xCC, 0x9D]), MUL(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x64, 0xD3, 0xA8]), MUL(qword[r11 + rdx*8 - 88]).encode())


class TestMULX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x3B, 0xF6, 0xE8]), MULX(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x3B, 0xF6, 0x6C, 0xCC, 0x9D]), MULX(ebp, r8d, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x83, 0xF6, 0xC8]), MULX(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x83, 0xF6, 0x4C, 0xD3, 0xA8]), MULX(rcx, r15, qword[r11 + rdx*8 - 88]).encode())


class TestIDIV(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xFB]), IDIV(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xFE]), IDIV(si).encode())
        self.assertEqual(bytearray([0xF7, 0xFD]), IDIV(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xF9]), IDIV(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x7C, 0xBE, 0x85]), IDIV(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x7C, 0xED, 0x95]), IDIV(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x7C, 0xCC, 0x9D]), IDIV(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x7C, 0xD3, 0xA8]), IDIV(qword[r11 + rdx*8 - 88]).encode())


class TestDIV(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF6, 0xF3]), DIV(bl).encode())
        self.assertEqual(bytearray([0x66, 0xF7, 0xF6]), DIV(si).encode())
        self.assertEqual(bytearray([0xF7, 0xF5]), DIV(ebp).encode())
        self.assertEqual(bytearray([0x48, 0xF7, 0xF1]), DIV(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xF6, 0x74, 0xBE, 0x85]), DIV(byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xF7, 0x74, 0xED, 0x95]), DIV(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xF7, 0x74, 0xCC, 0x9D]), DIV(dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0xF7, 0x74, 0xD3, 0xA8]), DIV(qword[r11 + rdx*8 - 88]).encode())


class TestLEA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x8D, 0x74, 0xF7, 0x80]), LEA(si, [r15 + rsi*8 - 128]).encode())
        self.assertEqual(bytearray([0x41, 0x8D, 0x6C, 0xF7, 0x80]), LEA(ebp, [r15 + rsi*8 - 128]).encode())
        self.assertEqual(bytearray([0x49, 0x8D, 0x4C, 0xF7, 0x80]), LEA(rcx, [r15 + rsi*8 - 128]).encode())


class TestPUSH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x6A, 0x02]), PUSH(2).encode())
        self.assertEqual(bytearray([0x68, 0x00, 0x00, 0x00, 0x10]), PUSH(0x10000000).encode())
        self.assertEqual(bytearray([0x66, 0x56]), PUSH(si).encode())
        self.assertEqual(bytearray([0x51]), PUSH(rcx).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0xFF, 0x74, 0xED, 0x95]), PUSH(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0xFF, 0x74, 0xD3, 0xA8]), PUSH(qword[r11 + rdx*8 - 88]).encode())


class TestPOP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x5E]), POP(si).encode())
        self.assertEqual(bytearray([0x59]), POP(rcx).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x8F, 0x44, 0xED, 0x95]), POP(word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x8F, 0x44, 0xD3, 0xA8]), POP(qword[r11 + rdx*8 - 88]).encode())


class TestPOPCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xB8, 0xF4]), POPCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xB8, 0x74, 0xED, 0x95]), POPCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xB8, 0xE8]), POPCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xB8, 0x6C, 0xCC, 0x9D]), POPCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xB8, 0xCF]), POPCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xB8, 0x4C, 0xD3, 0xA8]), POPCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestLZCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBD, 0xF4]), LZCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBD, 0x74, 0xED, 0x95]), LZCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBD, 0xE8]), LZCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBD, 0x6C, 0xCC, 0x9D]), LZCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBD, 0xCF]), LZCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBD, 0x4C, 0xD3, 0xA8]), LZCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestTZCNT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBC, 0xF4]), TZCNT(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0xF3, 0x41, 0x0F, 0xBC, 0x74, 0xED, 0x95]), TZCNT(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBC, 0xE8]), TZCNT(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xBC, 0x6C, 0xCC, 0x9D]), TZCNT(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBC, 0xCF]), TZCNT(rcx, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0xBC, 0x4C, 0xD3, 0xA8]), TZCNT(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBEXTR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xCA, 0x78, 0x10, 0xE8, 0x00, 0x00, 0x00, 0x10]), BEXTR(ebp, r8d, 0x10000000).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x78, 0xF7, 0xE8]), BEXTR(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0x8F, 0xCA, 0x78, 0x10, 0x6C, 0xCC, 0x9D, 0x00, 0x00, 0x00, 0x10]), BEXTR(ebp, dword[r12 + rcx*8 - 99], 0x10000000).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x78, 0xF7, 0x6C, 0xCC, 0x9D]), BEXTR(ebp, dword[r12 + rcx*8 - 99], eax).encode())
        self.assertEqual(bytearray([0x8F, 0xCA, 0xF8, 0x10, 0xCF, 0x00, 0x00, 0x00, 0x10]), BEXTR(rcx, r15, 0x10000000).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF8, 0xF7, 0xCF]), BEXTR(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0x8F, 0xCA, 0xF8, 0x10, 0x4C, 0xD3, 0xA8, 0x00, 0x00, 0x00, 0x10]), BEXTR(rcx, qword[r11 + rdx*8 - 88], 0x10000000).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF8, 0xF7, 0x4C, 0xD3, 0xA8]), BEXTR(rcx, qword[r11 + rdx*8 - 88], rax).encode())


class TestPDEP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x3B, 0xF5, 0xE8]), PDEP(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x3B, 0xF5, 0x6C, 0xCC, 0x9D]), PDEP(ebp, r8d, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x83, 0xF5, 0xC8]), PDEP(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x83, 0xF5, 0x4C, 0xD3, 0xA8]), PDEP(rcx, r15, qword[r11 + rdx*8 - 88]).encode())


class TestPEXT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x3A, 0xF5, 0xE8]), PEXT(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x3A, 0xF5, 0x6C, 0xCC, 0x9D]), PEXT(ebp, r8d, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x82, 0xF5, 0xC8]), PEXT(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x82, 0xF5, 0x4C, 0xD3, 0xA8]), PEXT(rcx, r15, qword[r11 + rdx*8 - 88]).encode())


class TestBZHI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x78, 0xF5, 0xE8]), BZHI(ebp, r8d, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x78, 0xF5, 0x6C, 0xCC, 0x9D]), BZHI(ebp, dword[r12 + rcx*8 - 99], eax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF8, 0xF5, 0xCF]), BZHI(rcx, r15, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF8, 0xF5, 0x4C, 0xD3, 0xA8]), BZHI(rcx, qword[r11 + rdx*8 - 88], rax).encode())


class TestBLCFILL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xC8]), BLCFILL(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x4C, 0xCC, 0x9D]), BLCFILL(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xCF]), BLCFILL(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x4C, 0xD3, 0xA8]), BLCFILL(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLCI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x02, 0xF0]), BLCI(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x02, 0x74, 0xCC, 0x9D]), BLCI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x02, 0xF7]), BLCI(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x02, 0x74, 0xD3, 0xA8]), BLCI(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLCIC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xE8]), BLCIC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x6C, 0xCC, 0x9D]), BLCIC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xEF]), BLCIC(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x6C, 0xD3, 0xA8]), BLCIC(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLCMSK(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x02, 0xC8]), BLCMSK(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x02, 0x4C, 0xCC, 0x9D]), BLCMSK(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x02, 0xCF]), BLCMSK(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x02, 0x4C, 0xD3, 0xA8]), BLCMSK(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLCS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xD8]), BLCS(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x5C, 0xCC, 0x9D]), BLCS(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xDF]), BLCS(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x5C, 0xD3, 0xA8]), BLCS(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLSFILL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xD0]), BLSFILL(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x54, 0xCC, 0x9D]), BLSFILL(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xD7]), BLSFILL(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x54, 0xD3, 0xA8]), BLSFILL(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLSI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0xD8]), BLSI(ebp, r8d).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0x5C, 0xCC, 0x9D]), BLSI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0xDF]), BLSI(rcx, r15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0x5C, 0xD3, 0xA8]), BLSI(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLSIC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xF0]), BLSIC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x74, 0xCC, 0x9D]), BLSIC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xF7]), BLSIC(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x74, 0xD3, 0xA8]), BLSIC(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLSMSK(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0xD0]), BLSMSK(ebp, r8d).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0x54, 0xCC, 0x9D]), BLSMSK(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0xD7]), BLSMSK(rcx, r15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0x54, 0xD3, 0xA8]), BLSMSK(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestBLSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0xC8]), BLSR(ebp, r8d).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x50, 0xF3, 0x4C, 0xCC, 0x9D]), BLSR(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0xCF]), BLSR(rcx, r15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0xF0, 0xF3, 0x4C, 0xD3, 0xA8]), BLSR(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestT1MSKC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xF8]), T1MSKC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x7C, 0xCC, 0x9D]), T1MSKC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xFF]), T1MSKC(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x7C, 0xD3, 0xA8]), T1MSKC(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestTZMSK(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0xE0]), TZMSK(ebp, r8d).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x50, 0x01, 0x64, 0xCC, 0x9D]), TZMSK(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0xE7]), TZMSK(rcx, r15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0xF0, 0x01, 0x64, 0xD3, 0xA8]), TZMSK(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCRC32(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x38, 0xF0, 0xE9]), CRC32(ebp, r9b).encode())
        self.assertEqual(bytearray([0x66, 0xF2, 0x41, 0x0F, 0x38, 0xF1, 0xEC]), CRC32(ebp, r12w).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x38, 0xF1, 0xE8]), CRC32(ebp, r8d).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x38, 0xF0, 0x6C, 0xBE, 0x85]), CRC32(ebp, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0xF2, 0x41, 0x0F, 0x38, 0xF1, 0x6C, 0xED, 0x95]), CRC32(ebp, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x38, 0xF1, 0x6C, 0xCC, 0x9D]), CRC32(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x38, 0xF0, 0xC9]), CRC32(rcx, r9b).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x38, 0xF1, 0xCF]), CRC32(rcx, r15).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x38, 0xF0, 0x4C, 0xBE, 0x85]), CRC32(rcx, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x38, 0xF1, 0x4C, 0xD3, 0xA8]), CRC32(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x98]), CBW().encode())


class TestCDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x99]), CDQ().encode())


class TestCQO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x48, 0x99]), CQO().encode())


class TestCWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x99]), CWD().encode())


class TestCWDE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x98]), CWDE().encode())


class TestCDQE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x48, 0x98]), CDQE().encode())


class TestCMOVA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x47, 0xF4]), CMOVA(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x47, 0x74, 0xED, 0x95]), CMOVA(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x47, 0xE8]), CMOVA(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x47, 0x6C, 0xCC, 0x9D]), CMOVA(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x47, 0xCF]), CMOVA(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x47, 0x4C, 0xD3, 0xA8]), CMOVA(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x46, 0xF4]), CMOVNA(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x46, 0x74, 0xED, 0x95]), CMOVNA(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x46, 0xE8]), CMOVNA(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x46, 0x6C, 0xCC, 0x9D]), CMOVNA(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x46, 0xCF]), CMOVNA(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x46, 0x4C, 0xD3, 0xA8]), CMOVNA(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVAE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0xF4]), CMOVAE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0x74, 0xED, 0x95]), CMOVAE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0xE8]), CMOVAE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0x6C, 0xCC, 0x9D]), CMOVAE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0xCF]), CMOVAE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0x4C, 0xD3, 0xA8]), CMOVAE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNAE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0xF4]), CMOVNAE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0x74, 0xED, 0x95]), CMOVNAE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0xE8]), CMOVNAE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0x6C, 0xCC, 0x9D]), CMOVNAE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0xCF]), CMOVNAE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0x4C, 0xD3, 0xA8]), CMOVNAE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0xF4]), CMOVB(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0x74, 0xED, 0x95]), CMOVB(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0xE8]), CMOVB(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0x6C, 0xCC, 0x9D]), CMOVB(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0xCF]), CMOVB(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0x4C, 0xD3, 0xA8]), CMOVB(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0xF4]), CMOVNB(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0x74, 0xED, 0x95]), CMOVNB(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0xE8]), CMOVNB(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0x6C, 0xCC, 0x9D]), CMOVNB(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0xCF]), CMOVNB(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0x4C, 0xD3, 0xA8]), CMOVNB(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVBE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x46, 0xF4]), CMOVBE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x46, 0x74, 0xED, 0x95]), CMOVBE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x46, 0xE8]), CMOVBE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x46, 0x6C, 0xCC, 0x9D]), CMOVBE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x46, 0xCF]), CMOVBE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x46, 0x4C, 0xD3, 0xA8]), CMOVBE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNBE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x47, 0xF4]), CMOVNBE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x47, 0x74, 0xED, 0x95]), CMOVNBE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x47, 0xE8]), CMOVNBE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x47, 0x6C, 0xCC, 0x9D]), CMOVNBE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x47, 0xCF]), CMOVNBE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x47, 0x4C, 0xD3, 0xA8]), CMOVNBE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0xF4]), CMOVC(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x42, 0x74, 0xED, 0x95]), CMOVC(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0xE8]), CMOVC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x42, 0x6C, 0xCC, 0x9D]), CMOVC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0xCF]), CMOVC(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x42, 0x4C, 0xD3, 0xA8]), CMOVC(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0xF4]), CMOVNC(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x43, 0x74, 0xED, 0x95]), CMOVNC(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0xE8]), CMOVNC(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x43, 0x6C, 0xCC, 0x9D]), CMOVNC(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0xCF]), CMOVNC(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x43, 0x4C, 0xD3, 0xA8]), CMOVNC(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x44, 0xF4]), CMOVE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x44, 0x74, 0xED, 0x95]), CMOVE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x44, 0xE8]), CMOVE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x44, 0x6C, 0xCC, 0x9D]), CMOVE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x44, 0xCF]), CMOVE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x44, 0x4C, 0xD3, 0xA8]), CMOVE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x45, 0xF4]), CMOVNE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x45, 0x74, 0xED, 0x95]), CMOVNE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x45, 0xE8]), CMOVNE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x45, 0x6C, 0xCC, 0x9D]), CMOVNE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x45, 0xCF]), CMOVNE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x45, 0x4C, 0xD3, 0xA8]), CMOVNE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4F, 0xF4]), CMOVG(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4F, 0x74, 0xED, 0x95]), CMOVG(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4F, 0xE8]), CMOVG(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4F, 0x6C, 0xCC, 0x9D]), CMOVG(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4F, 0xCF]), CMOVG(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4F, 0x4C, 0xD3, 0xA8]), CMOVG(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4E, 0xF4]), CMOVNG(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4E, 0x74, 0xED, 0x95]), CMOVNG(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4E, 0xE8]), CMOVNG(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4E, 0x6C, 0xCC, 0x9D]), CMOVNG(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4E, 0xCF]), CMOVNG(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4E, 0x4C, 0xD3, 0xA8]), CMOVNG(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVGE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4D, 0xF4]), CMOVGE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4D, 0x74, 0xED, 0x95]), CMOVGE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4D, 0xE8]), CMOVGE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4D, 0x6C, 0xCC, 0x9D]), CMOVGE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4D, 0xCF]), CMOVGE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4D, 0x4C, 0xD3, 0xA8]), CMOVGE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNGE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4C, 0xF4]), CMOVNGE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4C, 0x74, 0xED, 0x95]), CMOVNGE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4C, 0xE8]), CMOVNGE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4C, 0x6C, 0xCC, 0x9D]), CMOVNGE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4C, 0xCF]), CMOVNGE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4C, 0x4C, 0xD3, 0xA8]), CMOVNGE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4C, 0xF4]), CMOVL(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4C, 0x74, 0xED, 0x95]), CMOVL(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4C, 0xE8]), CMOVL(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4C, 0x6C, 0xCC, 0x9D]), CMOVL(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4C, 0xCF]), CMOVL(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4C, 0x4C, 0xD3, 0xA8]), CMOVL(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4D, 0xF4]), CMOVNL(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4D, 0x74, 0xED, 0x95]), CMOVNL(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4D, 0xE8]), CMOVNL(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4D, 0x6C, 0xCC, 0x9D]), CMOVNL(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4D, 0xCF]), CMOVNL(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4D, 0x4C, 0xD3, 0xA8]), CMOVNL(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVLE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4E, 0xF4]), CMOVLE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4E, 0x74, 0xED, 0x95]), CMOVLE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4E, 0xE8]), CMOVLE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4E, 0x6C, 0xCC, 0x9D]), CMOVLE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4E, 0xCF]), CMOVLE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4E, 0x4C, 0xD3, 0xA8]), CMOVLE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNLE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4F, 0xF4]), CMOVNLE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4F, 0x74, 0xED, 0x95]), CMOVNLE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4F, 0xE8]), CMOVNLE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4F, 0x6C, 0xCC, 0x9D]), CMOVNLE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4F, 0xCF]), CMOVNLE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4F, 0x4C, 0xD3, 0xA8]), CMOVNLE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x40, 0xF4]), CMOVO(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x40, 0x74, 0xED, 0x95]), CMOVO(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x40, 0xE8]), CMOVO(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x40, 0x6C, 0xCC, 0x9D]), CMOVO(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x40, 0xCF]), CMOVO(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x40, 0x4C, 0xD3, 0xA8]), CMOVO(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x41, 0xF4]), CMOVNO(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x41, 0x74, 0xED, 0x95]), CMOVNO(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x41, 0xE8]), CMOVNO(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x41, 0x6C, 0xCC, 0x9D]), CMOVNO(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x41, 0xCF]), CMOVNO(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x41, 0x4C, 0xD3, 0xA8]), CMOVNO(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4A, 0xF4]), CMOVP(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4A, 0x74, 0xED, 0x95]), CMOVP(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4A, 0xE8]), CMOVP(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4A, 0x6C, 0xCC, 0x9D]), CMOVP(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4A, 0xCF]), CMOVP(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4A, 0x4C, 0xD3, 0xA8]), CMOVP(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4B, 0xF4]), CMOVNP(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4B, 0x74, 0xED, 0x95]), CMOVNP(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4B, 0xE8]), CMOVNP(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4B, 0x6C, 0xCC, 0x9D]), CMOVNP(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4B, 0xCF]), CMOVNP(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4B, 0x4C, 0xD3, 0xA8]), CMOVNP(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x48, 0xF4]), CMOVS(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x48, 0x74, 0xED, 0x95]), CMOVS(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x48, 0xE8]), CMOVS(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x48, 0x6C, 0xCC, 0x9D]), CMOVS(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x48, 0xCF]), CMOVS(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x48, 0x4C, 0xD3, 0xA8]), CMOVS(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x49, 0xF4]), CMOVNS(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x49, 0x74, 0xED, 0x95]), CMOVNS(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x49, 0xE8]), CMOVNS(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x49, 0x6C, 0xCC, 0x9D]), CMOVNS(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x49, 0xCF]), CMOVNS(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x49, 0x4C, 0xD3, 0xA8]), CMOVNS(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVZ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x44, 0xF4]), CMOVZ(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x44, 0x74, 0xED, 0x95]), CMOVZ(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x44, 0xE8]), CMOVZ(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x44, 0x6C, 0xCC, 0x9D]), CMOVZ(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x44, 0xCF]), CMOVZ(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x44, 0x4C, 0xD3, 0xA8]), CMOVZ(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVNZ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x45, 0xF4]), CMOVNZ(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x45, 0x74, 0xED, 0x95]), CMOVNZ(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x45, 0xE8]), CMOVNZ(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x45, 0x6C, 0xCC, 0x9D]), CMOVNZ(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x45, 0xCF]), CMOVNZ(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x45, 0x4C, 0xD3, 0xA8]), CMOVNZ(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVPE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4A, 0xF4]), CMOVPE(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4A, 0x74, 0xED, 0x95]), CMOVPE(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4A, 0xE8]), CMOVPE(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4A, 0x6C, 0xCC, 0x9D]), CMOVPE(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4A, 0xCF]), CMOVPE(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4A, 0x4C, 0xD3, 0xA8]), CMOVPE(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCMOVPO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4B, 0xF4]), CMOVPO(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x4B, 0x74, 0xED, 0x95]), CMOVPO(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4B, 0xE8]), CMOVPO(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x4B, 0x6C, 0xCC, 0x9D]), CMOVPO(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4B, 0xCF]), CMOVPO(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x4B, 0x4C, 0xD3, 0xA8]), CMOVPO(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestSETA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x97, 0xC3]), SETA(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x97, 0x44, 0xBE, 0x85]), SETA(byte[r14 + rdi*4 - 123]).encode())


class TestSETNA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x96, 0xC3]), SETNA(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x96, 0x44, 0xBE, 0x85]), SETNA(byte[r14 + rdi*4 - 123]).encode())


class TestSETAE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x93, 0xC3]), SETAE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x93, 0x44, 0xBE, 0x85]), SETAE(byte[r14 + rdi*4 - 123]).encode())


class TestSETNAE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x92, 0xC3]), SETNAE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x92, 0x44, 0xBE, 0x85]), SETNAE(byte[r14 + rdi*4 - 123]).encode())


class TestSETB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x92, 0xC3]), SETB(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x92, 0x44, 0xBE, 0x85]), SETB(byte[r14 + rdi*4 - 123]).encode())


class TestSETNB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x93, 0xC3]), SETNB(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x93, 0x44, 0xBE, 0x85]), SETNB(byte[r14 + rdi*4 - 123]).encode())


class TestSETBE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x96, 0xC3]), SETBE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x96, 0x44, 0xBE, 0x85]), SETBE(byte[r14 + rdi*4 - 123]).encode())


class TestSETNBE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x97, 0xC3]), SETNBE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x97, 0x44, 0xBE, 0x85]), SETNBE(byte[r14 + rdi*4 - 123]).encode())


class TestSETC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x92, 0xC3]), SETC(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x92, 0x44, 0xBE, 0x85]), SETC(byte[r14 + rdi*4 - 123]).encode())


class TestSETNC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x93, 0xC3]), SETNC(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x93, 0x44, 0xBE, 0x85]), SETNC(byte[r14 + rdi*4 - 123]).encode())


class TestSETE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x94, 0xC3]), SETE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x94, 0x44, 0xBE, 0x85]), SETE(byte[r14 + rdi*4 - 123]).encode())


class TestSETNE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x95, 0xC3]), SETNE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x95, 0x44, 0xBE, 0x85]), SETNE(byte[r14 + rdi*4 - 123]).encode())


class TestSETG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9F, 0xC3]), SETG(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9F, 0x44, 0xBE, 0x85]), SETG(byte[r14 + rdi*4 - 123]).encode())


class TestSETNG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9E, 0xC3]), SETNG(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9E, 0x44, 0xBE, 0x85]), SETNG(byte[r14 + rdi*4 - 123]).encode())


class TestSETGE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9D, 0xC3]), SETGE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9D, 0x44, 0xBE, 0x85]), SETGE(byte[r14 + rdi*4 - 123]).encode())


class TestSETNGE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9C, 0xC3]), SETNGE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9C, 0x44, 0xBE, 0x85]), SETNGE(byte[r14 + rdi*4 - 123]).encode())


class TestSETL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9C, 0xC3]), SETL(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9C, 0x44, 0xBE, 0x85]), SETL(byte[r14 + rdi*4 - 123]).encode())


class TestSETNL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9D, 0xC3]), SETNL(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9D, 0x44, 0xBE, 0x85]), SETNL(byte[r14 + rdi*4 - 123]).encode())


class TestSETLE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9E, 0xC3]), SETLE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9E, 0x44, 0xBE, 0x85]), SETLE(byte[r14 + rdi*4 - 123]).encode())


class TestSETNLE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9F, 0xC3]), SETNLE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9F, 0x44, 0xBE, 0x85]), SETNLE(byte[r14 + rdi*4 - 123]).encode())


class TestSETO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x90, 0xC3]), SETO(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x90, 0x44, 0xBE, 0x85]), SETO(byte[r14 + rdi*4 - 123]).encode())


class TestSETNO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x91, 0xC3]), SETNO(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x91, 0x44, 0xBE, 0x85]), SETNO(byte[r14 + rdi*4 - 123]).encode())


class TestSETP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9A, 0xC3]), SETP(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9A, 0x44, 0xBE, 0x85]), SETP(byte[r14 + rdi*4 - 123]).encode())


class TestSETNP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9B, 0xC3]), SETNP(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9B, 0x44, 0xBE, 0x85]), SETNP(byte[r14 + rdi*4 - 123]).encode())


class TestSETS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x98, 0xC3]), SETS(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x98, 0x44, 0xBE, 0x85]), SETS(byte[r14 + rdi*4 - 123]).encode())


class TestSETNS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x99, 0xC3]), SETNS(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x99, 0x44, 0xBE, 0x85]), SETNS(byte[r14 + rdi*4 - 123]).encode())


class TestSETZ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x94, 0xC3]), SETZ(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x94, 0x44, 0xBE, 0x85]), SETZ(byte[r14 + rdi*4 - 123]).encode())


class TestSETNZ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x95, 0xC3]), SETNZ(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x95, 0x44, 0xBE, 0x85]), SETNZ(byte[r14 + rdi*4 - 123]).encode())


class TestSETPE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9A, 0xC3]), SETPE(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9A, 0x44, 0xBE, 0x85]), SETPE(byte[r14 + rdi*4 - 123]).encode())


class TestSETPO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x9B, 0xC3]), SETPO(bl).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x9B, 0x44, 0xBE, 0x85]), SETPO(byte[r14 + rdi*4 - 123]).encode())


class TestJA(unittest.TestCase):
    def runTest(self):
        pass


class TestJNA(unittest.TestCase):
    def runTest(self):
        pass


class TestJAE(unittest.TestCase):
    def runTest(self):
        pass


class TestJNAE(unittest.TestCase):
    def runTest(self):
        pass


class TestJB(unittest.TestCase):
    def runTest(self):
        pass


class TestJNB(unittest.TestCase):
    def runTest(self):
        pass


class TestJBE(unittest.TestCase):
    def runTest(self):
        pass


class TestJNBE(unittest.TestCase):
    def runTest(self):
        pass


class TestJC(unittest.TestCase):
    def runTest(self):
        pass


class TestJNC(unittest.TestCase):
    def runTest(self):
        pass


class TestJE(unittest.TestCase):
    def runTest(self):
        pass


class TestJNE(unittest.TestCase):
    def runTest(self):
        pass


class TestJG(unittest.TestCase):
    def runTest(self):
        pass


class TestJNG(unittest.TestCase):
    def runTest(self):
        pass


class TestJGE(unittest.TestCase):
    def runTest(self):
        pass


class TestJNGE(unittest.TestCase):
    def runTest(self):
        pass


class TestJL(unittest.TestCase):
    def runTest(self):
        pass


class TestJNL(unittest.TestCase):
    def runTest(self):
        pass


class TestJLE(unittest.TestCase):
    def runTest(self):
        pass


class TestJNLE(unittest.TestCase):
    def runTest(self):
        pass


class TestJO(unittest.TestCase):
    def runTest(self):
        pass


class TestJNO(unittest.TestCase):
    def runTest(self):
        pass


class TestJP(unittest.TestCase):
    def runTest(self):
        pass


class TestJNP(unittest.TestCase):
    def runTest(self):
        pass


class TestJS(unittest.TestCase):
    def runTest(self):
        pass


class TestJNS(unittest.TestCase):
    def runTest(self):
        pass


class TestJZ(unittest.TestCase):
    def runTest(self):
        pass


class TestJNZ(unittest.TestCase):
    def runTest(self):
        pass


class TestJPE(unittest.TestCase):
    def runTest(self):
        pass


class TestJPO(unittest.TestCase):
    def runTest(self):
        pass


class TestJMP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFF, 0xE1]), JMP(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xFF, 0x64, 0xD3, 0xA8]), JMP(qword[r11 + rdx*8 - 88]).encode())


class TestJRCXZ(unittest.TestCase):
    def runTest(self):
        pass


class TestJECXZ(unittest.TestCase):
    def runTest(self):
        pass


class TestRET(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC3]), RET().encode())
        self.assertEqual(bytearray([0xC2, 0x00, 0x7D]), RET(32000).encode())


class TestCALL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFF, 0xD1]), CALL(rcx).encode())
        self.assertEqual(bytearray([0x41, 0xFF, 0x54, 0xD3, 0xA8]), CALL(qword[r11 + rdx*8 - 88]).encode())


class TestPAUSE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x90]), PAUSE().encode())


class TestNOP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x90]), NOP().encode())


class TestINT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xCC]), INT(3).encode())
        self.assertEqual(bytearray([0xCD, 0x02]), INT(2).encode())


class TestUD2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0B]), UD2().encode())


class TestCPUID(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xA2]), CPUID().encode())


class TestRDTSC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x31]), RDTSC().encode())


class TestRDTSCP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x01, 0xF9]), RDTSCP().encode())


class TestXGETBV(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x01, 0xD0]), XGETBV().encode())


class TestSYSCALL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x05]), SYSCALL().encode())


class TestSTC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF9]), STC().encode())


class TestCLC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF8]), CLC().encode())


class TestCMC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF5]), CMC().encode())


class TestSTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFD]), STD().encode())


class TestCLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xFC]), CLD().encode())


class TestXADD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x44, 0x0F, 0xC0, 0xCB]), XADD(bl, r9b).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xC1, 0xE6]), XADD(si, r12w).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xC1, 0xC5]), XADD(ebp, r8d).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xC1, 0xF9]), XADD(rcx, r15).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xC0, 0x4C, 0xBE, 0x85]), XADD(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xC1, 0x64, 0xED, 0x95]), XADD(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xC1, 0x44, 0xCC, 0x9D]), XADD(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xC1, 0x7C, 0xD3, 0xA8]), XADD(qword[r11 + rdx*8 - 88], r15).encode())


class TestXCHG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x44, 0x86, 0xCB]), XCHG(bl, r9b).encode())
        self.assertEqual(bytearray([0x41, 0x86, 0x5C, 0xBE, 0x85]), XCHG(bl, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x94]), XCHG(ax, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x96]), XCHG(si, ax).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x87, 0xE6]), XCHG(si, r12w).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x87, 0x74, 0xED, 0x95]), XCHG(si, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0x41, 0x90]), XCHG(eax, r8d).encode())
        self.assertEqual(bytearray([0x95]), XCHG(ebp, eax).encode())
        self.assertEqual(bytearray([0x44, 0x87, 0xC5]), XCHG(ebp, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x87, 0x6C, 0xCC, 0x9D]), XCHG(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x49, 0x97]), XCHG(rax, r15).encode())
        self.assertEqual(bytearray([0x48, 0x91]), XCHG(rcx, rax).encode())
        self.assertEqual(bytearray([0x4C, 0x87, 0xF9]), XCHG(rcx, r15).encode())
        self.assertEqual(bytearray([0x49, 0x87, 0x4C, 0xD3, 0xA8]), XCHG(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x45, 0x86, 0x4C, 0xBE, 0x85]), XCHG(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x87, 0x64, 0xED, 0x95]), XCHG(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x45, 0x87, 0x44, 0xCC, 0x9D]), XCHG(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x4D, 0x87, 0x7C, 0xD3, 0xA8]), XCHG(qword[r11 + rdx*8 - 88], r15).encode())


class TestCMPXCHG(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x44, 0x0F, 0xB0, 0xCB]), CMPXCHG(bl, r9b).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0xB1, 0xE6]), CMPXCHG(si, r12w).encode())
        self.assertEqual(bytearray([0x44, 0x0F, 0xB1, 0xC5]), CMPXCHG(ebp, r8d).encode())
        self.assertEqual(bytearray([0x4C, 0x0F, 0xB1, 0xF9]), CMPXCHG(rcx, r15).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xB0, 0x4C, 0xBE, 0x85]), CMPXCHG(byte[r14 + rdi*4 - 123], r9b).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xB1, 0x64, 0xED, 0x95]), CMPXCHG(word[r13 + rbp*8 - 107], r12w).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0xB1, 0x44, 0xCC, 0x9D]), CMPXCHG(dword[r12 + rcx*8 - 99], r8d).encode())
        self.assertEqual(bytearray([0x4D, 0x0F, 0xB1, 0x7C, 0xD3, 0xA8]), CMPXCHG(qword[r11 + rdx*8 - 88], r15).encode())


class TestCMPXCHG8B(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xC7, 0x4C, 0xD3, 0xA8]), CMPXCHG8B(qword[r11 + rdx*8 - 88]).encode())


class TestCMPXCHG16B(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x49, 0x0F, 0xC7, 0x4C, 0xC2, 0xB3]), CMPXCHG16B(oword[r10 + rax*8 - 77]).encode())


class TestSFENCE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xAE, 0xF8]), SFENCE().encode())


class TestMFENCE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xAE, 0xF0]), MFENCE().encode())


class TestLFENCE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xAE, 0xE8]), LFENCE().encode())


class TestPREFETCHNTA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x18, 0x44, 0xBE, 0x85]), PREFETCHNTA(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCHT0(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x18, 0x4C, 0xBE, 0x85]), PREFETCHT0(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCHT1(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x18, 0x54, 0xBE, 0x85]), PREFETCHT1(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCHT2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x18, 0x5C, 0xBE, 0x85]), PREFETCHT2(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x0D, 0x44, 0xBE, 0x85]), PREFETCH(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCHW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x0D, 0x4C, 0xBE, 0x85]), PREFETCHW(byte[r14 + rdi*4 - 123]).encode())


class TestPREFETCHWT1(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x0D, 0x54, 0xBE, 0x85]), PREFETCHWT1(byte[r14 + rdi*4 - 123]).encode())


class TestCLFLUSH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xAE, 0x7C, 0xBE, 0x85]), CLFLUSH(byte[r14 + rdi*4 - 123]).encode())


class TestCLFLUSHOPT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xAE, 0x7C, 0xBE, 0x85]), CLFLUSHOPT(byte[r14 + rdi*4 - 123]).encode())


class TestCLWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xAE, 0x74, 0xBE, 0x85]), CLWB(byte[r14 + rdi*4 - 123]).encode())


class TestCLZERO(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x01, 0xFC]), CLZERO().encode())


