# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicableSchedule(Resource):
    """Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on
    lab level.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar lab_vms_shutdown: The auto-shutdown schedule, if one has been set at the lab or lab
     resource level.
    :vartype lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.Schedule
    :ivar lab_vms_startup: The auto-startup schedule, if one has been set at the lab or lab
     resource level.
    :vartype lab_vms_startup: ~azure.mgmt.devtestlabs.models.Schedule
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "lab_vms_shutdown": {"key": "properties.labVmsShutdown", "type": "Schedule"},
        "lab_vms_startup": {"key": "properties.labVmsStartup", "type": "Schedule"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        lab_vms_shutdown: Optional["_models.Schedule"] = None,
        lab_vms_startup: Optional["_models.Schedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword lab_vms_shutdown: The auto-shutdown schedule, if one has been set at the lab or lab
         resource level.
        :paramtype lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.Schedule
        :keyword lab_vms_startup: The auto-startup schedule, if one has been set at the lab or lab
         resource level.
        :paramtype lab_vms_startup: ~azure.mgmt.devtestlabs.models.Schedule
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.lab_vms_shutdown = lab_vms_shutdown
        self.lab_vms_startup = lab_vms_startup


class UpdateResource(_serialization.Model):
    """Represents an update resource.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ApplicableScheduleFragment(UpdateResource):
    """Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on
    lab level.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class ApplyArtifactsRequest(_serialization.Model):
    """Request body for applying artifacts to a virtual machine.

    :ivar artifacts: The list of artifacts to apply.
    :vartype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    """

    _attribute_map = {
        "artifacts": {"key": "artifacts", "type": "[ArtifactInstallProperties]"},
    }

    def __init__(self, *, artifacts: Optional[List["_models.ArtifactInstallProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword artifacts: The list of artifacts to apply.
        :paramtype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
        """
        super().__init__(**kwargs)
        self.artifacts = artifacts


class ArmTemplate(Resource):  # pylint: disable=too-many-instance-attributes
    """An Azure Resource Manager template.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar display_name: The display name of the ARM template.
    :vartype display_name: str
    :ivar description: The description of the ARM template.
    :vartype description: str
    :ivar publisher: The publisher of the ARM template.
    :vartype publisher: str
    :ivar icon: The URI to the icon of the ARM template.
    :vartype icon: str
    :ivar contents: The contents of the ARM template.
    :vartype contents: JSON
    :ivar created_date: The creation date of the armTemplate.
    :vartype created_date: ~datetime.datetime
    :ivar parameters_value_files_info: File name and parameter values information from all
     azuredeploy.*.parameters.json for the ARM template.
    :vartype parameters_value_files_info:
     list[~azure.mgmt.devtestlabs.models.ParametersValueFileInfo]
    :ivar enabled: Whether or not ARM template is enabled for use by lab user.
    :vartype enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "publisher": {"readonly": True},
        "icon": {"readonly": True},
        "contents": {"readonly": True},
        "created_date": {"readonly": True},
        "parameters_value_files_info": {"readonly": True},
        "enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "icon": {"key": "properties.icon", "type": "str"},
        "contents": {"key": "properties.contents", "type": "object"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "parameters_value_files_info": {
            "key": "properties.parametersValueFilesInfo",
            "type": "[ParametersValueFileInfo]",
        },
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.display_name = None
        self.description = None
        self.publisher = None
        self.icon = None
        self.contents = None
        self.created_date = None
        self.parameters_value_files_info = None
        self.enabled = None


class ArmTemplateInfo(_serialization.Model):
    """Information about a generated ARM template.

    :ivar template: The template's contents.
    :vartype template: JSON
    :ivar parameters: The parameters of the ARM template.
    :vartype parameters: JSON
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "parameters": {"key": "parameters", "type": "object"},
    }

    def __init__(self, *, template: Optional[JSON] = None, parameters: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword template: The template's contents.
        :paramtype template: JSON
        :keyword parameters: The parameters of the ARM template.
        :paramtype parameters: JSON
        """
        super().__init__(**kwargs)
        self.template = template
        self.parameters = parameters


class ArmTemplateList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.ArmTemplate]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ArmTemplate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ArmTemplate"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.ArmTemplate]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ArmTemplateParameterProperties(_serialization.Model):
    """Properties of an Azure Resource Manager template parameter.

    :ivar name: The name of the template parameter.
    :vartype name: str
    :ivar value: The value of the template parameter.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the template parameter.
        :paramtype name: str
        :keyword value: The value of the template parameter.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Artifact(Resource):  # pylint: disable=too-many-instance-attributes
    """An artifact.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar title: The artifact's title.
    :vartype title: str
    :ivar description: The artifact's description.
    :vartype description: str
    :ivar publisher: The artifact's publisher.
    :vartype publisher: str
    :ivar file_path: The file path to the artifact.
    :vartype file_path: str
    :ivar icon: The URI to the artifact icon.
    :vartype icon: str
    :ivar target_os_type: The artifact's target OS.
    :vartype target_os_type: str
    :ivar parameters: The artifact's parameters.
    :vartype parameters: JSON
    :ivar created_date: The artifact's creation date.
    :vartype created_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "title": {"readonly": True},
        "description": {"readonly": True},
        "publisher": {"readonly": True},
        "file_path": {"readonly": True},
        "icon": {"readonly": True},
        "target_os_type": {"readonly": True},
        "parameters": {"readonly": True},
        "created_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "title": {"key": "properties.title", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "file_path": {"key": "properties.filePath", "type": "str"},
        "icon": {"key": "properties.icon", "type": "str"},
        "target_os_type": {"key": "properties.targetOsType", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.title = None
        self.description = None
        self.publisher = None
        self.file_path = None
        self.icon = None
        self.target_os_type = None
        self.parameters = None
        self.created_date = None


class ArtifactDeploymentStatusProperties(_serialization.Model):
    """Properties of an artifact deployment.

    :ivar deployment_status: The deployment status of the artifact.
    :vartype deployment_status: str
    :ivar artifacts_applied: The total count of the artifacts that were successfully applied.
    :vartype artifacts_applied: int
    :ivar total_artifacts: The total count of the artifacts that were tentatively applied.
    :vartype total_artifacts: int
    """

    _attribute_map = {
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "artifacts_applied": {"key": "artifactsApplied", "type": "int"},
        "total_artifacts": {"key": "totalArtifacts", "type": "int"},
    }

    def __init__(
        self,
        *,
        deployment_status: Optional[str] = None,
        artifacts_applied: Optional[int] = None,
        total_artifacts: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment_status: The deployment status of the artifact.
        :paramtype deployment_status: str
        :keyword artifacts_applied: The total count of the artifacts that were successfully applied.
        :paramtype artifacts_applied: int
        :keyword total_artifacts: The total count of the artifacts that were tentatively applied.
        :paramtype total_artifacts: int
        """
        super().__init__(**kwargs)
        self.deployment_status = deployment_status
        self.artifacts_applied = artifacts_applied
        self.total_artifacts = total_artifacts


class ArtifactInstallProperties(_serialization.Model):
    """Properties of an artifact.

    :ivar artifact_id: The artifact's identifier.
    :vartype artifact_id: str
    :ivar artifact_title: The artifact's title.
    :vartype artifact_title: str
    :ivar parameters: The parameters of the artifact.
    :vartype parameters: list[~azure.mgmt.devtestlabs.models.ArtifactParameterProperties]
    :ivar status: The status of the artifact.
    :vartype status: str
    :ivar deployment_status_message: The status message from the deployment.
    :vartype deployment_status_message: str
    :ivar vm_extension_status_message: The status message from the virtual machine extension.
    :vartype vm_extension_status_message: str
    :ivar install_time: The time that the artifact starts to install on the virtual machine.
    :vartype install_time: ~datetime.datetime
    """

    _attribute_map = {
        "artifact_id": {"key": "artifactId", "type": "str"},
        "artifact_title": {"key": "artifactTitle", "type": "str"},
        "parameters": {"key": "parameters", "type": "[ArtifactParameterProperties]"},
        "status": {"key": "status", "type": "str"},
        "deployment_status_message": {"key": "deploymentStatusMessage", "type": "str"},
        "vm_extension_status_message": {"key": "vmExtensionStatusMessage", "type": "str"},
        "install_time": {"key": "installTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        artifact_id: Optional[str] = None,
        artifact_title: Optional[str] = None,
        parameters: Optional[List["_models.ArtifactParameterProperties"]] = None,
        status: Optional[str] = None,
        deployment_status_message: Optional[str] = None,
        vm_extension_status_message: Optional[str] = None,
        install_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword artifact_id: The artifact's identifier.
        :paramtype artifact_id: str
        :keyword artifact_title: The artifact's title.
        :paramtype artifact_title: str
        :keyword parameters: The parameters of the artifact.
        :paramtype parameters: list[~azure.mgmt.devtestlabs.models.ArtifactParameterProperties]
        :keyword status: The status of the artifact.
        :paramtype status: str
        :keyword deployment_status_message: The status message from the deployment.
        :paramtype deployment_status_message: str
        :keyword vm_extension_status_message: The status message from the virtual machine extension.
        :paramtype vm_extension_status_message: str
        :keyword install_time: The time that the artifact starts to install on the virtual machine.
        :paramtype install_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.artifact_id = artifact_id
        self.artifact_title = artifact_title
        self.parameters = parameters
        self.status = status
        self.deployment_status_message = deployment_status_message
        self.vm_extension_status_message = vm_extension_status_message
        self.install_time = install_time


class ArtifactList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Artifact]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Artifact]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Artifact"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Artifact]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ArtifactParameterProperties(_serialization.Model):
    """Properties of an artifact parameter.

    :ivar name: The name of the artifact parameter.
    :vartype name: str
    :ivar value: The value of the artifact parameter.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the artifact parameter.
        :paramtype name: str
        :keyword value: The value of the artifact parameter.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ArtifactSource(Resource):  # pylint: disable=too-many-instance-attributes
    """Properties of an artifact source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar display_name: The artifact source's display name.
    :vartype display_name: str
    :ivar uri: The artifact source's URI.
    :vartype uri: str
    :ivar source_type: The artifact source's type. Known values are: "VsoGit", "GitHub", and
     "StorageAccount".
    :vartype source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
    :ivar folder_path: The folder containing artifacts.
    :vartype folder_path: str
    :ivar arm_template_folder_path: The folder containing Azure Resource Manager templates.
    :vartype arm_template_folder_path: str
    :ivar branch_ref: The artifact source's branch reference.
    :vartype branch_ref: str
    :ivar security_token: The security token to authenticate to the artifact source.
    :vartype security_token: str
    :ivar status: Indicates if the artifact source is enabled (values: Enabled, Disabled). Known
     values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar created_date: The artifact source's creation date.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "source_type": {"key": "properties.sourceType", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "arm_template_folder_path": {"key": "properties.armTemplateFolderPath", "type": "str"},
        "branch_ref": {"key": "properties.branchRef", "type": "str"},
        "security_token": {"key": "properties.securityToken", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        uri: Optional[str] = None,
        source_type: Optional[Union[str, "_models.SourceControlType"]] = None,
        folder_path: Optional[str] = None,
        arm_template_folder_path: Optional[str] = None,
        branch_ref: Optional[str] = None,
        security_token: Optional[str] = None,
        status: Optional[Union[str, "_models.EnableStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword display_name: The artifact source's display name.
        :paramtype display_name: str
        :keyword uri: The artifact source's URI.
        :paramtype uri: str
        :keyword source_type: The artifact source's type. Known values are: "VsoGit", "GitHub", and
         "StorageAccount".
        :paramtype source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
        :keyword folder_path: The folder containing artifacts.
        :paramtype folder_path: str
        :keyword arm_template_folder_path: The folder containing Azure Resource Manager templates.
        :paramtype arm_template_folder_path: str
        :keyword branch_ref: The artifact source's branch reference.
        :paramtype branch_ref: str
        :keyword security_token: The security token to authenticate to the artifact source.
        :paramtype security_token: str
        :keyword status: Indicates if the artifact source is enabled (values: Enabled, Disabled). Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.display_name = display_name
        self.uri = uri
        self.source_type = source_type
        self.folder_path = folder_path
        self.arm_template_folder_path = arm_template_folder_path
        self.branch_ref = branch_ref
        self.security_token = security_token
        self.status = status
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class ArtifactSourceFragment(UpdateResource):
    """Properties of an artifact source.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class ArtifactSourceList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.ArtifactSource]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ArtifactSource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ArtifactSource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.ArtifactSource]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AttachDiskProperties(_serialization.Model):
    """Properties of the disk to attach.

    :ivar leased_by_lab_vm_id: The resource ID of the Lab virtual machine to which the disk is
     attached.
    :vartype leased_by_lab_vm_id: str
    """

    _attribute_map = {
        "leased_by_lab_vm_id": {"key": "leasedByLabVmId", "type": "str"},
    }

    def __init__(self, *, leased_by_lab_vm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword leased_by_lab_vm_id: The resource ID of the Lab virtual machine to which the disk is
         attached.
        :paramtype leased_by_lab_vm_id: str
        """
        super().__init__(**kwargs)
        self.leased_by_lab_vm_id = leased_by_lab_vm_id


class AttachNewDataDiskOptions(_serialization.Model):
    """Properties to attach new disk to the Virtual Machine.

    :ivar disk_size_gi_b: Size of the disk to be attached in Gibibytes.
    :vartype disk_size_gi_b: int
    :ivar disk_name: The name of the disk to be attached.
    :vartype disk_name: str
    :ivar disk_type: The storage type for the disk (i.e. Standard, Premium). Known values are:
     "Standard", "Premium", and "StandardSSD".
    :vartype disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        "disk_size_gi_b": {"key": "diskSizeGiB", "type": "int"},
        "disk_name": {"key": "diskName", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_size_gi_b: Optional[int] = None,
        disk_name: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.StorageType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_size_gi_b: Size of the disk to be attached in Gibibytes.
        :paramtype disk_size_gi_b: int
        :keyword disk_name: The name of the disk to be attached.
        :paramtype disk_name: str
        :keyword disk_type: The storage type for the disk (i.e. Standard, Premium). Known values are:
         "Standard", "Premium", and "StandardSSD".
        :paramtype disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
        """
        super().__init__(**kwargs)
        self.disk_size_gi_b = disk_size_gi_b
        self.disk_name = disk_name
        self.disk_type = disk_type


class BulkCreationParameters(_serialization.Model):
    """Parameters for creating multiple virtual machines as a single action.

    :ivar instance_count: The number of virtual machine instances to create.
    :vartype instance_count: int
    """

    _attribute_map = {
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, *, instance_count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword instance_count: The number of virtual machine instances to create.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.instance_count = instance_count


class CloudErrorBody(_serialization.Model):
    """Body of an error from a REST request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Inner errors.
    :vartype details: list[~azure.mgmt.devtestlabs.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        :keyword target: The error target.
        :paramtype target: str
        :keyword details: Inner errors.
        :paramtype details: list[~azure.mgmt.devtestlabs.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ComputeDataDisk(_serialization.Model):
    """A data disks attached to a virtual machine.

    :ivar name: Gets data disk name.
    :vartype name: str
    :ivar disk_uri: When backed by a blob, the URI of underlying blob.
    :vartype disk_uri: str
    :ivar managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :vartype managed_disk_id: str
    :ivar disk_size_gi_b: Gets data disk size in GiB.
    :vartype disk_size_gi_b: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disk_uri": {"key": "diskUri", "type": "str"},
        "managed_disk_id": {"key": "managedDiskId", "type": "str"},
        "disk_size_gi_b": {"key": "diskSizeGiB", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        disk_size_gi_b: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets data disk name.
        :paramtype name: str
        :keyword disk_uri: When backed by a blob, the URI of underlying blob.
        :paramtype disk_uri: str
        :keyword managed_disk_id: When backed by managed disk, this is the ID of the compute disk
         resource.
        :paramtype managed_disk_id: str
        :keyword disk_size_gi_b: Gets data disk size in GiB.
        :paramtype disk_size_gi_b: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.disk_uri = disk_uri
        self.managed_disk_id = managed_disk_id
        self.disk_size_gi_b = disk_size_gi_b


class ComputeVmInstanceViewStatus(_serialization.Model):
    """Status information about a virtual machine.

    :ivar code: Gets the status Code.
    :vartype code: str
    :ivar display_status: Gets the short localizable label for the status.
    :vartype display_status: str
    :ivar message: Gets the message associated with the status.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Gets the status Code.
        :paramtype code: str
        :keyword display_status: Gets the short localizable label for the status.
        :paramtype display_status: str
        :keyword message: Gets the message associated with the status.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.message = message


class ComputeVmProperties(_serialization.Model):
    """Properties of a virtual machine returned by the Microsoft.Compute API.

    :ivar statuses: Gets the statuses of the virtual machine.
    :vartype statuses: list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatus]
    :ivar os_type: Gets the OS type of the virtual machine.
    :vartype os_type: str
    :ivar vm_size: Gets the size of the virtual machine.
    :vartype vm_size: str
    :ivar network_interface_id: Gets the network interface ID of the virtual machine.
    :vartype network_interface_id: str
    :ivar os_disk_id: Gets OS disk blob uri for the virtual machine.
    :vartype os_disk_id: str
    :ivar data_disk_ids: Gets data disks blob uri for the virtual machine.
    :vartype data_disk_ids: list[str]
    :ivar data_disks: Gets all data disks attached to the virtual machine.
    :vartype data_disks: list[~azure.mgmt.devtestlabs.models.ComputeDataDisk]
    """

    _attribute_map = {
        "statuses": {"key": "statuses", "type": "[ComputeVmInstanceViewStatus]"},
        "os_type": {"key": "osType", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "network_interface_id": {"key": "networkInterfaceId", "type": "str"},
        "os_disk_id": {"key": "osDiskId", "type": "str"},
        "data_disk_ids": {"key": "dataDiskIds", "type": "[str]"},
        "data_disks": {"key": "dataDisks", "type": "[ComputeDataDisk]"},
    }

    def __init__(
        self,
        *,
        statuses: Optional[List["_models.ComputeVmInstanceViewStatus"]] = None,
        os_type: Optional[str] = None,
        vm_size: Optional[str] = None,
        network_interface_id: Optional[str] = None,
        os_disk_id: Optional[str] = None,
        data_disk_ids: Optional[List[str]] = None,
        data_disks: Optional[List["_models.ComputeDataDisk"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword statuses: Gets the statuses of the virtual machine.
        :paramtype statuses: list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatus]
        :keyword os_type: Gets the OS type of the virtual machine.
        :paramtype os_type: str
        :keyword vm_size: Gets the size of the virtual machine.
        :paramtype vm_size: str
        :keyword network_interface_id: Gets the network interface ID of the virtual machine.
        :paramtype network_interface_id: str
        :keyword os_disk_id: Gets OS disk blob uri for the virtual machine.
        :paramtype os_disk_id: str
        :keyword data_disk_ids: Gets data disks blob uri for the virtual machine.
        :paramtype data_disk_ids: list[str]
        :keyword data_disks: Gets all data disks attached to the virtual machine.
        :paramtype data_disks: list[~azure.mgmt.devtestlabs.models.ComputeDataDisk]
        """
        super().__init__(**kwargs)
        self.statuses = statuses
        self.os_type = os_type
        self.vm_size = vm_size
        self.network_interface_id = network_interface_id
        self.os_disk_id = os_disk_id
        self.data_disk_ids = data_disk_ids
        self.data_disks = data_disks


class CostThresholdProperties(_serialization.Model):
    """Properties of a cost threshold item.

    :ivar threshold_id: The ID of the cost threshold item.
    :vartype threshold_id: str
    :ivar percentage_threshold: The value of the percentage cost threshold.
    :vartype percentage_threshold: ~azure.mgmt.devtestlabs.models.PercentageCostThresholdProperties
    :ivar display_on_chart: Indicates whether this threshold will be displayed on cost charts.
     Known values are: "Enabled" and "Disabled".
    :vartype display_on_chart: str or ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :ivar send_notification_when_exceeded: Indicates whether notifications will be sent when this
     threshold is exceeded. Known values are: "Enabled" and "Disabled".
    :vartype send_notification_when_exceeded: str or
     ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :ivar notification_sent: Indicates the datetime when notifications were last sent for this
     threshold.
    :vartype notification_sent: str
    """

    _attribute_map = {
        "threshold_id": {"key": "thresholdId", "type": "str"},
        "percentage_threshold": {"key": "percentageThreshold", "type": "PercentageCostThresholdProperties"},
        "display_on_chart": {"key": "displayOnChart", "type": "str"},
        "send_notification_when_exceeded": {"key": "sendNotificationWhenExceeded", "type": "str"},
        "notification_sent": {"key": "notificationSent", "type": "str"},
    }

    def __init__(
        self,
        *,
        threshold_id: Optional[str] = None,
        percentage_threshold: Optional["_models.PercentageCostThresholdProperties"] = None,
        display_on_chart: Optional[Union[str, "_models.CostThresholdStatus"]] = None,
        send_notification_when_exceeded: Optional[Union[str, "_models.CostThresholdStatus"]] = None,
        notification_sent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold_id: The ID of the cost threshold item.
        :paramtype threshold_id: str
        :keyword percentage_threshold: The value of the percentage cost threshold.
        :paramtype percentage_threshold:
         ~azure.mgmt.devtestlabs.models.PercentageCostThresholdProperties
        :keyword display_on_chart: Indicates whether this threshold will be displayed on cost charts.
         Known values are: "Enabled" and "Disabled".
        :paramtype display_on_chart: str or ~azure.mgmt.devtestlabs.models.CostThresholdStatus
        :keyword send_notification_when_exceeded: Indicates whether notifications will be sent when
         this threshold is exceeded. Known values are: "Enabled" and "Disabled".
        :paramtype send_notification_when_exceeded: str or
         ~azure.mgmt.devtestlabs.models.CostThresholdStatus
        :keyword notification_sent: Indicates the datetime when notifications were last sent for this
         threshold.
        :paramtype notification_sent: str
        """
        super().__init__(**kwargs)
        self.threshold_id = threshold_id
        self.percentage_threshold = percentage_threshold
        self.display_on_chart = display_on_chart
        self.send_notification_when_exceeded = send_notification_when_exceeded
        self.notification_sent = notification_sent


class CustomImage(Resource):  # pylint: disable=too-many-instance-attributes
    """A custom image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar vm: The virtual machine from which the image is to be created.
    :vartype vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVm
    :ivar vhd: The VHD from which the image is to be created.
    :vartype vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustom
    :ivar description: The description of the custom image.
    :vartype description: str
    :ivar author: The author of the custom image.
    :vartype author: str
    :ivar creation_date: The creation date of the custom image.
    :vartype creation_date: ~datetime.datetime
    :ivar managed_image_id: The Managed Image Id backing the custom image.
    :vartype managed_image_id: str
    :ivar managed_snapshot_id: The Managed Snapshot Id backing the custom image.
    :vartype managed_snapshot_id: str
    :ivar data_disk_storage_info: Storage information about the data disks present in the custom
     image.
    :vartype data_disk_storage_info: list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfo]
    :ivar custom_image_plan: Storage information about the plan related to this custom image.
    :vartype custom_image_plan: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlan
    :ivar is_plan_authorized: Whether or not the custom images underlying offer/plan has been
     enabled for programmatic deployment.
    :vartype is_plan_authorized: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "vm": {"key": "properties.vm", "type": "CustomImagePropertiesFromVm"},
        "vhd": {"key": "properties.vhd", "type": "CustomImagePropertiesCustom"},
        "description": {"key": "properties.description", "type": "str"},
        "author": {"key": "properties.author", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "managed_image_id": {"key": "properties.managedImageId", "type": "str"},
        "managed_snapshot_id": {"key": "properties.managedSnapshotId", "type": "str"},
        "data_disk_storage_info": {"key": "properties.dataDiskStorageInfo", "type": "[DataDiskStorageTypeInfo]"},
        "custom_image_plan": {"key": "properties.customImagePlan", "type": "CustomImagePropertiesFromPlan"},
        "is_plan_authorized": {"key": "properties.isPlanAuthorized", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        vm: Optional["_models.CustomImagePropertiesFromVm"] = None,
        vhd: Optional["_models.CustomImagePropertiesCustom"] = None,
        description: Optional[str] = None,
        author: Optional[str] = None,
        managed_image_id: Optional[str] = None,
        managed_snapshot_id: Optional[str] = None,
        data_disk_storage_info: Optional[List["_models.DataDiskStorageTypeInfo"]] = None,
        custom_image_plan: Optional["_models.CustomImagePropertiesFromPlan"] = None,
        is_plan_authorized: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword vm: The virtual machine from which the image is to be created.
        :paramtype vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVm
        :keyword vhd: The VHD from which the image is to be created.
        :paramtype vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustom
        :keyword description: The description of the custom image.
        :paramtype description: str
        :keyword author: The author of the custom image.
        :paramtype author: str
        :keyword managed_image_id: The Managed Image Id backing the custom image.
        :paramtype managed_image_id: str
        :keyword managed_snapshot_id: The Managed Snapshot Id backing the custom image.
        :paramtype managed_snapshot_id: str
        :keyword data_disk_storage_info: Storage information about the data disks present in the custom
         image.
        :paramtype data_disk_storage_info: list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfo]
        :keyword custom_image_plan: Storage information about the plan related to this custom image.
        :paramtype custom_image_plan: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlan
        :keyword is_plan_authorized: Whether or not the custom images underlying offer/plan has been
         enabled for programmatic deployment.
        :paramtype is_plan_authorized: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.vm = vm
        self.vhd = vhd
        self.description = description
        self.author = author
        self.creation_date = None
        self.managed_image_id = managed_image_id
        self.managed_snapshot_id = managed_snapshot_id
        self.data_disk_storage_info = data_disk_storage_info
        self.custom_image_plan = custom_image_plan
        self.is_plan_authorized = is_plan_authorized
        self.provisioning_state = None
        self.unique_identifier = None


class CustomImageFragment(UpdateResource):
    """A custom image.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class CustomImageList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.CustomImage]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CustomImage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.CustomImage]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomImagePropertiesCustom(_serialization.Model):
    """Properties for creating a custom image from a VHD.

    All required parameters must be populated in order to send to server.

    :ivar image_name: The image name.
    :vartype image_name: str
    :ivar sys_prep: Indicates whether sysprep has been run on the VHD.
    :vartype sys_prep: bool
    :ivar os_type: The OS type of the custom image (i.e. Windows, Linux). Required. Known values
     are: "Windows", "Linux", and "None".
    :vartype os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
    """

    _validation = {
        "os_type": {"required": True},
    }

    _attribute_map = {
        "image_name": {"key": "imageName", "type": "str"},
        "sys_prep": {"key": "sysPrep", "type": "bool"},
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.CustomImageOsType"],
        image_name: Optional[str] = None,
        sys_prep: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_name: The image name.
        :paramtype image_name: str
        :keyword sys_prep: Indicates whether sysprep has been run on the VHD.
        :paramtype sys_prep: bool
        :keyword os_type: The OS type of the custom image (i.e. Windows, Linux). Required. Known values
         are: "Windows", "Linux", and "None".
        :paramtype os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
        """
        super().__init__(**kwargs)
        self.image_name = image_name
        self.sys_prep = sys_prep
        self.os_type = os_type


class CustomImagePropertiesFromPlan(_serialization.Model):
    """Properties for plan on a custom image.

    :ivar id: The id of the plan, equivalent to name of the plan.
    :vartype id: str
    :ivar publisher: The publisher for the plan from the marketplace image the custom image is
     derived from.
    :vartype publisher: str
    :ivar offer: The offer for the plan from the marketplace image the custom image is derived
     from.
    :vartype offer: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the plan, equivalent to name of the plan.
        :paramtype id: str
        :keyword publisher: The publisher for the plan from the marketplace image the custom image is
         derived from.
        :paramtype publisher: str
        :keyword offer: The offer for the plan from the marketplace image the custom image is derived
         from.
        :paramtype offer: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.publisher = publisher
        self.offer = offer


class CustomImagePropertiesFromVm(_serialization.Model):
    """Properties for creating a custom image from a virtual machine.

    :ivar source_vm_id: The source vm identifier.
    :vartype source_vm_id: str
    :ivar windows_os_info: The Windows OS information of the VM.
    :vartype windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfo
    :ivar linux_os_info: The Linux OS information of the VM.
    :vartype linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfo
    """

    _attribute_map = {
        "source_vm_id": {"key": "sourceVmId", "type": "str"},
        "windows_os_info": {"key": "windowsOsInfo", "type": "WindowsOsInfo"},
        "linux_os_info": {"key": "linuxOsInfo", "type": "LinuxOsInfo"},
    }

    def __init__(
        self,
        *,
        source_vm_id: Optional[str] = None,
        windows_os_info: Optional["_models.WindowsOsInfo"] = None,
        linux_os_info: Optional["_models.LinuxOsInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vm_id: The source vm identifier.
        :paramtype source_vm_id: str
        :keyword windows_os_info: The Windows OS information of the VM.
        :paramtype windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfo
        :keyword linux_os_info: The Linux OS information of the VM.
        :paramtype linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfo
        """
        super().__init__(**kwargs)
        self.source_vm_id = source_vm_id
        self.windows_os_info = windows_os_info
        self.linux_os_info = linux_os_info


class DataDiskProperties(_serialization.Model):
    """Request body for adding a new or existing data disk to a virtual machine.

    :ivar attach_new_data_disk_options: Specifies options to attach a new disk to the virtual
     machine.
    :vartype attach_new_data_disk_options: ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptions
    :ivar existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
    :vartype existing_lab_disk_id: str
    :ivar host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Known
     values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.devtestlabs.models.HostCachingOptions
    """

    _attribute_map = {
        "attach_new_data_disk_options": {"key": "attachNewDataDiskOptions", "type": "AttachNewDataDiskOptions"},
        "existing_lab_disk_id": {"key": "existingLabDiskId", "type": "str"},
        "host_caching": {"key": "hostCaching", "type": "str"},
    }

    def __init__(
        self,
        *,
        attach_new_data_disk_options: Optional["_models.AttachNewDataDiskOptions"] = None,
        existing_lab_disk_id: Optional[str] = None,
        host_caching: Optional[Union[str, "_models.HostCachingOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword attach_new_data_disk_options: Specifies options to attach a new disk to the virtual
         machine.
        :paramtype attach_new_data_disk_options:
         ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptions
        :keyword existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
        :paramtype existing_lab_disk_id: str
        :keyword host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Known
         values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.devtestlabs.models.HostCachingOptions
        """
        super().__init__(**kwargs)
        self.attach_new_data_disk_options = attach_new_data_disk_options
        self.existing_lab_disk_id = existing_lab_disk_id
        self.host_caching = host_caching


class DataDiskStorageTypeInfo(_serialization.Model):
    """Storage information about the data disks present in the custom image.

    :ivar lun: Disk Lun.
    :vartype lun: str
    :ivar storage_type: Disk Storage Type. Known values are: "Standard", "Premium", and
     "StandardSSD".
    :vartype storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        "lun": {"key": "lun", "type": "str"},
        "storage_type": {"key": "storageType", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: Optional[str] = None,
        storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Disk Lun.
        :paramtype lun: str
        :keyword storage_type: Disk Storage Type. Known values are: "Standard", "Premium", and
         "StandardSSD".
        :paramtype storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.storage_type = storage_type


class DayDetails(_serialization.Model):
    """Properties of a daily schedule.

    :ivar time: The time of day the schedule will occur.
    :vartype time: str
    """

    _attribute_map = {
        "time": {"key": "time", "type": "str"},
    }

    def __init__(self, *, time: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time: The time of day the schedule will occur.
        :paramtype time: str
        """
        super().__init__(**kwargs)
        self.time = time


class DetachDataDiskProperties(_serialization.Model):
    """Request body for detaching data disk from a virtual machine.

    :ivar existing_lab_disk_id: Specifies the disk resource ID to detach from virtual machine.
    :vartype existing_lab_disk_id: str
    """

    _attribute_map = {
        "existing_lab_disk_id": {"key": "existingLabDiskId", "type": "str"},
    }

    def __init__(self, *, existing_lab_disk_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword existing_lab_disk_id: Specifies the disk resource ID to detach from virtual machine.
        :paramtype existing_lab_disk_id: str
        """
        super().__init__(**kwargs)
        self.existing_lab_disk_id = existing_lab_disk_id


class DetachDiskProperties(_serialization.Model):
    """Properties of the disk to detach.

    :ivar leased_by_lab_vm_id: The resource ID of the Lab VM to which the disk is attached.
    :vartype leased_by_lab_vm_id: str
    """

    _attribute_map = {
        "leased_by_lab_vm_id": {"key": "leasedByLabVmId", "type": "str"},
    }

    def __init__(self, *, leased_by_lab_vm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword leased_by_lab_vm_id: The resource ID of the Lab VM to which the disk is attached.
        :paramtype leased_by_lab_vm_id: str
        """
        super().__init__(**kwargs)
        self.leased_by_lab_vm_id = leased_by_lab_vm_id


class Disk(Resource):  # pylint: disable=too-many-instance-attributes
    """A Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar disk_type: The storage type for the disk (i.e. Standard, Premium). Known values are:
     "Standard", "Premium", and "StandardSSD".
    :vartype disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :ivar disk_size_gi_b: The size of the disk in Gibibytes.
    :vartype disk_size_gi_b: int
    :ivar leased_by_lab_vm_id: The resource ID of the VM to which this disk is leased.
    :vartype leased_by_lab_vm_id: str
    :ivar disk_blob_name: When backed by a blob, the name of the VHD blob without extension.
    :vartype disk_blob_name: str
    :ivar disk_uri: When backed by a blob, the URI of underlying blob.
    :vartype disk_uri: str
    :ivar storage_account_id: When backed by a blob, the storage account where the blob is.
    :vartype storage_account_id: str
    :ivar created_date: The creation date of the disk.
    :vartype created_date: ~datetime.datetime
    :ivar host_caching: The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
    :vartype host_caching: str
    :ivar managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :vartype managed_disk_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "disk_type": {"key": "properties.diskType", "type": "str"},
        "disk_size_gi_b": {"key": "properties.diskSizeGiB", "type": "int"},
        "leased_by_lab_vm_id": {"key": "properties.leasedByLabVmId", "type": "str"},
        "disk_blob_name": {"key": "properties.diskBlobName", "type": "str"},
        "disk_uri": {"key": "properties.diskUri", "type": "str"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "host_caching": {"key": "properties.hostCaching", "type": "str"},
        "managed_disk_id": {"key": "properties.managedDiskId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        disk_type: Optional[Union[str, "_models.StorageType"]] = None,
        disk_size_gi_b: Optional[int] = None,
        leased_by_lab_vm_id: Optional[str] = None,
        disk_blob_name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        host_caching: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword disk_type: The storage type for the disk (i.e. Standard, Premium). Known values are:
         "Standard", "Premium", and "StandardSSD".
        :paramtype disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
        :keyword disk_size_gi_b: The size of the disk in Gibibytes.
        :paramtype disk_size_gi_b: int
        :keyword leased_by_lab_vm_id: The resource ID of the VM to which this disk is leased.
        :paramtype leased_by_lab_vm_id: str
        :keyword disk_blob_name: When backed by a blob, the name of the VHD blob without extension.
        :paramtype disk_blob_name: str
        :keyword disk_uri: When backed by a blob, the URI of underlying blob.
        :paramtype disk_uri: str
        :keyword storage_account_id: When backed by a blob, the storage account where the blob is.
        :paramtype storage_account_id: str
        :keyword host_caching: The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
        :paramtype host_caching: str
        :keyword managed_disk_id: When backed by managed disk, this is the ID of the compute disk
         resource.
        :paramtype managed_disk_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.disk_type = disk_type
        self.disk_size_gi_b = disk_size_gi_b
        self.leased_by_lab_vm_id = leased_by_lab_vm_id
        self.disk_blob_name = disk_blob_name
        self.disk_uri = disk_uri
        self.storage_account_id = storage_account_id
        self.created_date = None
        self.host_caching = host_caching
        self.managed_disk_id = managed_disk_id
        self.provisioning_state = None
        self.unique_identifier = None


class DiskFragment(UpdateResource):
    """A Disk.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class DiskList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Disk]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Disk]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Disk"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Disk]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DtlEnvironment(Resource):  # pylint: disable=too-many-instance-attributes
    """An environment, which is essentially an ARM template deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar deployment_properties: The deployment properties of the environment.
    :vartype deployment_properties: ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentProperties
    :ivar arm_template_display_name: The display name of the Azure Resource Manager template that
     produced the environment.
    :vartype arm_template_display_name: str
    :ivar resource_group_id: The identifier of the resource group containing the environment's
     resources.
    :vartype resource_group_id: str
    :ivar created_by_user: The creator of the environment.
    :vartype created_by_user: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource_group_id": {"readonly": True},
        "created_by_user": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "deployment_properties": {"key": "properties.deploymentProperties", "type": "EnvironmentDeploymentProperties"},
        "arm_template_display_name": {"key": "properties.armTemplateDisplayName", "type": "str"},
        "resource_group_id": {"key": "properties.resourceGroupId", "type": "str"},
        "created_by_user": {"key": "properties.createdByUser", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        deployment_properties: Optional["_models.EnvironmentDeploymentProperties"] = None,
        arm_template_display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword deployment_properties: The deployment properties of the environment.
        :paramtype deployment_properties:
         ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentProperties
        :keyword arm_template_display_name: The display name of the Azure Resource Manager template
         that produced the environment.
        :paramtype arm_template_display_name: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.deployment_properties = deployment_properties
        self.arm_template_display_name = arm_template_display_name
        self.resource_group_id = None
        self.created_by_user = None
        self.provisioning_state = None
        self.unique_identifier = None


class DtlEnvironmentFragment(UpdateResource):
    """An environment, which is essentially an ARM template deployment.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class DtlEnvironmentList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.DtlEnvironment]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DtlEnvironment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DtlEnvironment"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.DtlEnvironment]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EnvironmentDeploymentProperties(_serialization.Model):
    """Properties of an environment deployment.

    :ivar arm_template_id: The Azure Resource Manager template's identifier.
    :vartype arm_template_id: str
    :ivar parameters: The parameters of the Azure Resource Manager template.
    :vartype parameters: list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterProperties]
    """

    _attribute_map = {
        "arm_template_id": {"key": "armTemplateId", "type": "str"},
        "parameters": {"key": "parameters", "type": "[ArmTemplateParameterProperties]"},
    }

    def __init__(
        self,
        *,
        arm_template_id: Optional[str] = None,
        parameters: Optional[List["_models.ArmTemplateParameterProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword arm_template_id: The Azure Resource Manager template's identifier.
        :paramtype arm_template_id: str
        :keyword parameters: The parameters of the Azure Resource Manager template.
        :paramtype parameters: list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterProperties]
        """
        super().__init__(**kwargs)
        self.arm_template_id = arm_template_id
        self.parameters = parameters


class EvaluatePoliciesProperties(_serialization.Model):
    """Properties for evaluating a policy set.

    :ivar fact_name: The fact name.
    :vartype fact_name: str
    :ivar fact_data: The fact data.
    :vartype fact_data: str
    :ivar value_offset: The value offset.
    :vartype value_offset: str
    :ivar user_object_id: The user for which policies will be evaluated.
    :vartype user_object_id: str
    """

    _attribute_map = {
        "fact_name": {"key": "factName", "type": "str"},
        "fact_data": {"key": "factData", "type": "str"},
        "value_offset": {"key": "valueOffset", "type": "str"},
        "user_object_id": {"key": "userObjectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        fact_name: Optional[str] = None,
        fact_data: Optional[str] = None,
        value_offset: Optional[str] = None,
        user_object_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword fact_name: The fact name.
        :paramtype fact_name: str
        :keyword fact_data: The fact data.
        :paramtype fact_data: str
        :keyword value_offset: The value offset.
        :paramtype value_offset: str
        :keyword user_object_id: The user for which policies will be evaluated.
        :paramtype user_object_id: str
        """
        super().__init__(**kwargs)
        self.fact_name = fact_name
        self.fact_data = fact_data
        self.value_offset = value_offset
        self.user_object_id = user_object_id


class EvaluatePoliciesRequest(_serialization.Model):
    """Request body for evaluating a policy set.

    :ivar policies: Policies to evaluate.
    :vartype policies: list[~azure.mgmt.devtestlabs.models.EvaluatePoliciesProperties]
    """

    _attribute_map = {
        "policies": {"key": "policies", "type": "[EvaluatePoliciesProperties]"},
    }

    def __init__(self, *, policies: Optional[List["_models.EvaluatePoliciesProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword policies: Policies to evaluate.
        :paramtype policies: list[~azure.mgmt.devtestlabs.models.EvaluatePoliciesProperties]
        """
        super().__init__(**kwargs)
        self.policies = policies


class EvaluatePoliciesResponse(_serialization.Model):
    """Response body for evaluating a policy set.

    :ivar results: Results of evaluating a policy set.
    :vartype results: list[~azure.mgmt.devtestlabs.models.PolicySetResult]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[PolicySetResult]"},
    }

    def __init__(self, *, results: Optional[List["_models.PolicySetResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword results: Results of evaluating a policy set.
        :paramtype results: list[~azure.mgmt.devtestlabs.models.PolicySetResult]
        """
        super().__init__(**kwargs)
        self.results = results


class Event(_serialization.Model):
    """An event to be notified for.

    :ivar event_name: The event type for which this notification is enabled (i.e. AutoShutdown,
     Cost). Known values are: "AutoShutdown" and "Cost".
    :vartype event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    """

    _attribute_map = {
        "event_name": {"key": "eventName", "type": "str"},
    }

    def __init__(
        self, *, event_name: Optional[Union[str, "_models.NotificationChannelEventType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword event_name: The event type for which this notification is enabled (i.e. AutoShutdown,
         Cost). Known values are: "AutoShutdown" and "Cost".
        :paramtype event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
        """
        super().__init__(**kwargs)
        self.event_name = event_name


class ExportResourceUsageParameters(_serialization.Model):
    """The parameters of the export operation.

    :ivar blob_storage_absolute_sas_uri: The blob storage absolute sas uri with write permission to
     the container which the usage data needs to be uploaded to.
    :vartype blob_storage_absolute_sas_uri: str
    :ivar usage_start_date: The start time of the usage. If not provided, usage will be reported
     since the beginning of data collection.
    :vartype usage_start_date: ~datetime.datetime
    """

    _attribute_map = {
        "blob_storage_absolute_sas_uri": {"key": "blobStorageAbsoluteSasUri", "type": "str"},
        "usage_start_date": {"key": "usageStartDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        blob_storage_absolute_sas_uri: Optional[str] = None,
        usage_start_date: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_storage_absolute_sas_uri: The blob storage absolute sas uri with write permission
         to the container which the usage data needs to be uploaded to.
        :paramtype blob_storage_absolute_sas_uri: str
        :keyword usage_start_date: The start time of the usage. If not provided, usage will be reported
         since the beginning of data collection.
        :paramtype usage_start_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.blob_storage_absolute_sas_uri = blob_storage_absolute_sas_uri
        self.usage_start_date = usage_start_date


class ExternalSubnet(_serialization.Model):
    """Subnet information as returned by the Microsoft.Network API.

    :ivar id: Gets or sets the identifier.
    :vartype id: str
    :ivar name: Gets or sets the name.
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Gets or sets the identifier.
        :paramtype id: str
        :keyword name: Gets or sets the name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class Formula(Resource):  # pylint: disable=too-many-instance-attributes
    """A formula for creating a VM, specifying an image base and other parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar description: The description of the formula.
    :vartype description: str
    :ivar author: The author of the formula.
    :vartype author: str
    :ivar os_type: The OS type of the formula.
    :vartype os_type: str
    :ivar creation_date: The creation date of the formula.
    :vartype creation_date: ~datetime.datetime
    :ivar formula_content: The content of the formula.
    :vartype formula_content: ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameter
    :ivar vm: Information about a VM from which a formula is to be created.
    :vartype vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVm
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "author": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "author": {"key": "properties.author", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "formula_content": {"key": "properties.formulaContent", "type": "LabVirtualMachineCreationParameter"},
        "vm": {"key": "properties.vm", "type": "FormulaPropertiesFromVm"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        os_type: Optional[str] = None,
        formula_content: Optional["_models.LabVirtualMachineCreationParameter"] = None,
        vm: Optional["_models.FormulaPropertiesFromVm"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword description: The description of the formula.
        :paramtype description: str
        :keyword os_type: The OS type of the formula.
        :paramtype os_type: str
        :keyword formula_content: The content of the formula.
        :paramtype formula_content: ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameter
        :keyword vm: Information about a VM from which a formula is to be created.
        :paramtype vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVm
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.author = None
        self.os_type = os_type
        self.creation_date = None
        self.formula_content = formula_content
        self.vm = vm
        self.provisioning_state = None
        self.unique_identifier = None


class FormulaFragment(UpdateResource):
    """A formula for creating a VM, specifying an image base and other parameters.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class FormulaList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Formula]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Formula]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Formula"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Formula]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FormulaPropertiesFromVm(_serialization.Model):
    """Information about a VM from which a formula is to be created.

    :ivar lab_vm_id: The identifier of the VM from which a formula is to be created.
    :vartype lab_vm_id: str
    """

    _attribute_map = {
        "lab_vm_id": {"key": "labVmId", "type": "str"},
    }

    def __init__(self, *, lab_vm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword lab_vm_id: The identifier of the VM from which a formula is to be created.
        :paramtype lab_vm_id: str
        """
        super().__init__(**kwargs)
        self.lab_vm_id = lab_vm_id


class GalleryImage(Resource):  # pylint: disable=too-many-instance-attributes
    """A gallery image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar author: The author of the gallery image.
    :vartype author: str
    :ivar created_date: The creation date of the gallery image.
    :vartype created_date: ~datetime.datetime
    :ivar description: The description of the gallery image.
    :vartype description: str
    :ivar image_reference: The image reference of the gallery image.
    :vartype image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :ivar icon: The icon of the gallery image.
    :vartype icon: str
    :ivar enabled: Indicates whether this gallery image is enabled.
    :vartype enabled: bool
    :ivar plan_id: The third party plan that applies to this image.
    :vartype plan_id: str
    :ivar is_plan_authorized: Indicates if the plan has been authorized for programmatic
     deployment.
    :vartype is_plan_authorized: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "author": {"key": "properties.author", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "image_reference": {"key": "properties.imageReference", "type": "GalleryImageReference"},
        "icon": {"key": "properties.icon", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "plan_id": {"key": "properties.planId", "type": "str"},
        "is_plan_authorized": {"key": "properties.isPlanAuthorized", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        author: Optional[str] = None,
        description: Optional[str] = None,
        image_reference: Optional["_models.GalleryImageReference"] = None,
        icon: Optional[str] = None,
        enabled: Optional[bool] = None,
        plan_id: Optional[str] = None,
        is_plan_authorized: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword author: The author of the gallery image.
        :paramtype author: str
        :keyword description: The description of the gallery image.
        :paramtype description: str
        :keyword image_reference: The image reference of the gallery image.
        :paramtype image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
        :keyword icon: The icon of the gallery image.
        :paramtype icon: str
        :keyword enabled: Indicates whether this gallery image is enabled.
        :paramtype enabled: bool
        :keyword plan_id: The third party plan that applies to this image.
        :paramtype plan_id: str
        :keyword is_plan_authorized: Indicates if the plan has been authorized for programmatic
         deployment.
        :paramtype is_plan_authorized: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.author = author
        self.created_date = None
        self.description = description
        self.image_reference = image_reference
        self.icon = icon
        self.enabled = enabled
        self.plan_id = plan_id
        self.is_plan_authorized = is_plan_authorized


class GalleryImageList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.GalleryImage]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GalleryImage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.GalleryImage]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageReference(_serialization.Model):
    """The reference information for an Azure Marketplace image.

    :ivar offer: The offer of the gallery image.
    :vartype offer: str
    :ivar publisher: The publisher of the gallery image.
    :vartype publisher: str
    :ivar sku: The SKU of the gallery image.
    :vartype sku: str
    :ivar os_type: The OS type of the gallery image.
    :vartype os_type: str
    :ivar version: The version of the gallery image.
    :vartype version: str
    """

    _attribute_map = {
        "offer": {"key": "offer", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        offer: Optional[str] = None,
        publisher: Optional[str] = None,
        sku: Optional[str] = None,
        os_type: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword offer: The offer of the gallery image.
        :paramtype offer: str
        :keyword publisher: The publisher of the gallery image.
        :paramtype publisher: str
        :keyword sku: The SKU of the gallery image.
        :paramtype sku: str
        :keyword os_type: The OS type of the gallery image.
        :paramtype os_type: str
        :keyword version: The version of the gallery image.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.offer = offer
        self.publisher = publisher
        self.sku = sku
        self.os_type = os_type
        self.version = version


class GenerateArmTemplateRequest(_serialization.Model):
    """Parameters for generating an ARM template for deploying artifacts.

    :ivar virtual_machine_name: The resource name of the virtual machine.
    :vartype virtual_machine_name: str
    :ivar parameters: The parameters of the ARM template.
    :vartype parameters: list[~azure.mgmt.devtestlabs.models.ParameterInfo]
    :ivar location: The location of the virtual machine.
    :vartype location: str
    :ivar file_upload_options: Options for uploading the files for the artifact.
     UploadFilesAndGenerateSasTokens is the default value. Known values are:
     "UploadFilesAndGenerateSasTokens" and "None".
    :vartype file_upload_options: str or ~azure.mgmt.devtestlabs.models.FileUploadOptions
    """

    _attribute_map = {
        "virtual_machine_name": {"key": "virtualMachineName", "type": "str"},
        "parameters": {"key": "parameters", "type": "[ParameterInfo]"},
        "location": {"key": "location", "type": "str"},
        "file_upload_options": {"key": "fileUploadOptions", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machine_name: Optional[str] = None,
        parameters: Optional[List["_models.ParameterInfo"]] = None,
        location: Optional[str] = None,
        file_upload_options: Optional[Union[str, "_models.FileUploadOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machine_name: The resource name of the virtual machine.
        :paramtype virtual_machine_name: str
        :keyword parameters: The parameters of the ARM template.
        :paramtype parameters: list[~azure.mgmt.devtestlabs.models.ParameterInfo]
        :keyword location: The location of the virtual machine.
        :paramtype location: str
        :keyword file_upload_options: Options for uploading the files for the artifact.
         UploadFilesAndGenerateSasTokens is the default value. Known values are:
         "UploadFilesAndGenerateSasTokens" and "None".
        :paramtype file_upload_options: str or ~azure.mgmt.devtestlabs.models.FileUploadOptions
        """
        super().__init__(**kwargs)
        self.virtual_machine_name = virtual_machine_name
        self.parameters = parameters
        self.location = location
        self.file_upload_options = file_upload_options


class GenerateUploadUriParameter(_serialization.Model):
    """Properties for generating an upload URI.

    :ivar blob_name: The blob name of the upload URI.
    :vartype blob_name: str
    """

    _attribute_map = {
        "blob_name": {"key": "blobName", "type": "str"},
    }

    def __init__(self, *, blob_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword blob_name: The blob name of the upload URI.
        :paramtype blob_name: str
        """
        super().__init__(**kwargs)
        self.blob_name = blob_name


class GenerateUploadUriResponse(_serialization.Model):
    """Response body for generating an upload URI.

    :ivar upload_uri: The upload URI for the VHD.
    :vartype upload_uri: str
    """

    _attribute_map = {
        "upload_uri": {"key": "uploadUri", "type": "str"},
    }

    def __init__(self, *, upload_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword upload_uri: The upload URI for the VHD.
        :paramtype upload_uri: str
        """
        super().__init__(**kwargs)
        self.upload_uri = upload_uri


class HourDetails(_serialization.Model):
    """Properties of an hourly schedule.

    :ivar minute: Minutes of the hour the schedule will run.
    :vartype minute: int
    """

    _attribute_map = {
        "minute": {"key": "minute", "type": "int"},
    }

    def __init__(self, *, minute: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword minute: Minutes of the hour the schedule will run.
        :paramtype minute: int
        """
        super().__init__(**kwargs)
        self.minute = minute


class IdentityProperties(_serialization.Model):
    """Properties of a managed identity.

    :ivar type: Managed identity. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.devtestlabs.models.ManagedIdentityType
    :ivar principal_id: The principal id of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant identifier of resource.
    :vartype tenant_id: str
    :ivar client_secret_url: The client secret URL of the identity.
    :vartype client_secret_url: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_secret_url": {"key": "clientSecretUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        client_secret_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Managed identity. Known values are: "None", "SystemAssigned", "UserAssigned",
         and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.devtestlabs.models.ManagedIdentityType
        :keyword principal_id: The principal id of resource identity.
        :paramtype principal_id: str
        :keyword tenant_id: The tenant identifier of resource.
        :paramtype tenant_id: str
        :keyword client_secret_url: The client secret URL of the identity.
        :paramtype client_secret_url: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.client_secret_url = client_secret_url


class ImportLabVirtualMachineRequest(_serialization.Model):
    """This represents the payload required to import a virtual machine from a different lab into the
    current one.

    :ivar source_virtual_machine_resource_id: The full resource ID of the virtual machine to be
     imported.
    :vartype source_virtual_machine_resource_id: str
    :ivar destination_virtual_machine_name: The name of the virtual machine in the destination lab.
    :vartype destination_virtual_machine_name: str
    """

    _attribute_map = {
        "source_virtual_machine_resource_id": {"key": "sourceVirtualMachineResourceId", "type": "str"},
        "destination_virtual_machine_name": {"key": "destinationVirtualMachineName", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_virtual_machine_resource_id: Optional[str] = None,
        destination_virtual_machine_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_virtual_machine_resource_id: The full resource ID of the virtual machine to be
         imported.
        :paramtype source_virtual_machine_resource_id: str
        :keyword destination_virtual_machine_name: The name of the virtual machine in the destination
         lab.
        :paramtype destination_virtual_machine_name: str
        """
        super().__init__(**kwargs)
        self.source_virtual_machine_resource_id = source_virtual_machine_resource_id
        self.destination_virtual_machine_name = destination_virtual_machine_name


class InboundNatRule(_serialization.Model):
    """A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load
    balancer.

    :ivar transport_protocol: The transport protocol for the endpoint. Known values are: "Tcp" and
     "Udp".
    :vartype transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :ivar frontend_port: The external endpoint port of the inbound connection. Possible values
     range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
    :vartype frontend_port: int
    :ivar backend_port: The port to which the external traffic will be redirected.
    :vartype backend_port: int
    """

    _attribute_map = {
        "transport_protocol": {"key": "transportProtocol", "type": "str"},
        "frontend_port": {"key": "frontendPort", "type": "int"},
        "backend_port": {"key": "backendPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transport_protocol: The transport protocol for the endpoint. Known values are: "Tcp"
         and "Udp".
        :paramtype transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
        :keyword frontend_port: The external endpoint port of the inbound connection. Possible values
         range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
        :paramtype frontend_port: int
        :keyword backend_port: The port to which the external traffic will be redirected.
        :paramtype backend_port: int
        """
        super().__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port


class Lab(Resource):  # pylint: disable=too-many-instance-attributes
    """A lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar default_storage_account: The lab's default storage account.
    :vartype default_storage_account: str
    :ivar default_premium_storage_account: The lab's default premium storage account.
    :vartype default_premium_storage_account: str
    :ivar artifacts_storage_account: The lab's artifact storage account.
    :vartype artifacts_storage_account: str
    :ivar premium_data_disk_storage_account: The lab's premium data disk storage account.
    :vartype premium_data_disk_storage_account: str
    :ivar vault_name: The lab's Key vault.
    :vartype vault_name: str
    :ivar lab_storage_type: Type of storage used by the lab. It can be either Premium or Standard.
     Default is Premium. Known values are: "Standard", "Premium", and "StandardSSD".
    :vartype lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :ivar mandatory_artifacts_resource_ids_linux: The ordered list of artifact resource IDs that
     should be applied on all Linux VM creations by default, prior to the artifacts specified by the
     user.
    :vartype mandatory_artifacts_resource_ids_linux: list[str]
    :ivar mandatory_artifacts_resource_ids_windows: The ordered list of artifact resource IDs that
     should be applied on all Windows VM creations by default, prior to the artifacts specified by
     the user.
    :vartype mandatory_artifacts_resource_ids_windows: list[str]
    :ivar created_date: The creation date of the lab.
    :vartype created_date: ~datetime.datetime
    :ivar premium_data_disks: The setting to enable usage of premium data disks.
     When its value is 'Enabled', creation of standard or premium data disks is allowed.
     When its value is 'Disabled', only creation of standard data disks is allowed. Known values
     are: "Disabled" and "Enabled".
    :vartype premium_data_disks: str or ~azure.mgmt.devtestlabs.models.PremiumDataDisk
    :ivar environment_permission: The access rights to be granted to the user when provisioning an
     environment. Known values are: "Reader" and "Contributor".
    :vartype environment_permission: str or ~azure.mgmt.devtestlabs.models.EnvironmentPermission
    :ivar announcement: The properties of any lab announcement associated with this lab.
    :vartype announcement: ~azure.mgmt.devtestlabs.models.LabAnnouncementProperties
    :ivar support: The properties of any lab support message associated with this lab.
    :vartype support: ~azure.mgmt.devtestlabs.models.LabSupportProperties
    :ivar vm_creation_resource_group: The resource group in which all new lab virtual machines will
     be created. To let DevTest Labs manage resource group creation, set this value to null.
    :vartype vm_creation_resource_group: str
    :ivar public_ip_id: The public IP address for the lab's load balancer.
    :vartype public_ip_id: str
    :ivar load_balancer_id: The load balancer used to for lab VMs that use shared IP address.
    :vartype load_balancer_id: str
    :ivar network_security_group_id: The Network Security Group attached to the lab VMs Network
     interfaces to restrict open ports.
    :vartype network_security_group_id: str
    :ivar extended_properties: Extended properties of the lab used for experimental features.
    :vartype extended_properties: dict[str, str]
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "default_storage_account": {"readonly": True},
        "default_premium_storage_account": {"readonly": True},
        "artifacts_storage_account": {"readonly": True},
        "premium_data_disk_storage_account": {"readonly": True},
        "vault_name": {"readonly": True},
        "created_date": {"readonly": True},
        "vm_creation_resource_group": {"readonly": True},
        "public_ip_id": {"readonly": True},
        "load_balancer_id": {"readonly": True},
        "network_security_group_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "default_storage_account": {"key": "properties.defaultStorageAccount", "type": "str"},
        "default_premium_storage_account": {"key": "properties.defaultPremiumStorageAccount", "type": "str"},
        "artifacts_storage_account": {"key": "properties.artifactsStorageAccount", "type": "str"},
        "premium_data_disk_storage_account": {"key": "properties.premiumDataDiskStorageAccount", "type": "str"},
        "vault_name": {"key": "properties.vaultName", "type": "str"},
        "lab_storage_type": {"key": "properties.labStorageType", "type": "str"},
        "mandatory_artifacts_resource_ids_linux": {
            "key": "properties.mandatoryArtifactsResourceIdsLinux",
            "type": "[str]",
        },
        "mandatory_artifacts_resource_ids_windows": {
            "key": "properties.mandatoryArtifactsResourceIdsWindows",
            "type": "[str]",
        },
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "premium_data_disks": {"key": "properties.premiumDataDisks", "type": "str"},
        "environment_permission": {"key": "properties.environmentPermission", "type": "str"},
        "announcement": {"key": "properties.announcement", "type": "LabAnnouncementProperties"},
        "support": {"key": "properties.support", "type": "LabSupportProperties"},
        "vm_creation_resource_group": {"key": "properties.vmCreationResourceGroup", "type": "str"},
        "public_ip_id": {"key": "properties.publicIpId", "type": "str"},
        "load_balancer_id": {"key": "properties.loadBalancerId", "type": "str"},
        "network_security_group_id": {"key": "properties.networkSecurityGroupId", "type": "str"},
        "extended_properties": {"key": "properties.extendedProperties", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        lab_storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        mandatory_artifacts_resource_ids_linux: Optional[List[str]] = None,
        mandatory_artifacts_resource_ids_windows: Optional[List[str]] = None,
        premium_data_disks: Optional[Union[str, "_models.PremiumDataDisk"]] = None,
        environment_permission: Optional[Union[str, "_models.EnvironmentPermission"]] = None,
        announcement: Optional["_models.LabAnnouncementProperties"] = None,
        support: Optional["_models.LabSupportProperties"] = None,
        extended_properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword lab_storage_type: Type of storage used by the lab. It can be either Premium or
         Standard. Default is Premium. Known values are: "Standard", "Premium", and "StandardSSD".
        :paramtype lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
        :keyword mandatory_artifacts_resource_ids_linux: The ordered list of artifact resource IDs that
         should be applied on all Linux VM creations by default, prior to the artifacts specified by the
         user.
        :paramtype mandatory_artifacts_resource_ids_linux: list[str]
        :keyword mandatory_artifacts_resource_ids_windows: The ordered list of artifact resource IDs
         that should be applied on all Windows VM creations by default, prior to the artifacts specified
         by the user.
        :paramtype mandatory_artifacts_resource_ids_windows: list[str]
        :keyword premium_data_disks: The setting to enable usage of premium data disks.
         When its value is 'Enabled', creation of standard or premium data disks is allowed.
         When its value is 'Disabled', only creation of standard data disks is allowed. Known values
         are: "Disabled" and "Enabled".
        :paramtype premium_data_disks: str or ~azure.mgmt.devtestlabs.models.PremiumDataDisk
        :keyword environment_permission: The access rights to be granted to the user when provisioning
         an environment. Known values are: "Reader" and "Contributor".
        :paramtype environment_permission: str or ~azure.mgmt.devtestlabs.models.EnvironmentPermission
        :keyword announcement: The properties of any lab announcement associated with this lab.
        :paramtype announcement: ~azure.mgmt.devtestlabs.models.LabAnnouncementProperties
        :keyword support: The properties of any lab support message associated with this lab.
        :paramtype support: ~azure.mgmt.devtestlabs.models.LabSupportProperties
        :keyword extended_properties: Extended properties of the lab used for experimental features.
        :paramtype extended_properties: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.default_storage_account = None
        self.default_premium_storage_account = None
        self.artifacts_storage_account = None
        self.premium_data_disk_storage_account = None
        self.vault_name = None
        self.lab_storage_type = lab_storage_type
        self.mandatory_artifacts_resource_ids_linux = mandatory_artifacts_resource_ids_linux
        self.mandatory_artifacts_resource_ids_windows = mandatory_artifacts_resource_ids_windows
        self.created_date = None
        self.premium_data_disks = premium_data_disks
        self.environment_permission = environment_permission
        self.announcement = announcement
        self.support = support
        self.vm_creation_resource_group = None
        self.public_ip_id = None
        self.load_balancer_id = None
        self.network_security_group_id = None
        self.extended_properties = extended_properties
        self.provisioning_state = None
        self.unique_identifier = None


class LabAnnouncementProperties(_serialization.Model):
    """Properties of a lab's announcement banner.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar title: The plain text title for the lab announcement.
    :vartype title: str
    :ivar markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :vartype markdown: str
    :ivar enabled: Is the lab announcement active/enabled at this time?. Known values are:
     "Enabled" and "Disabled".
    :vartype enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar expiration_date: The time at which the announcement expires (null for never).
    :vartype expiration_date: ~datetime.datetime
    :ivar expired: Has this announcement expired?.
    :vartype expired: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "markdown": {"key": "markdown", "type": "str"},
        "enabled": {"key": "enabled", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "iso-8601"},
        "expired": {"key": "expired", "type": "bool"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "unique_identifier": {"key": "uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        markdown: Optional[str] = None,
        enabled: Optional[Union[str, "_models.EnableStatus"]] = None,
        expiration_date: Optional[datetime.datetime] = None,
        expired: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: The plain text title for the lab announcement.
        :paramtype title: str
        :keyword markdown: The markdown text (if any) that this lab displays in the UI. If left
         empty/null, nothing will be shown.
        :paramtype markdown: str
        :keyword enabled: Is the lab announcement active/enabled at this time?. Known values are:
         "Enabled" and "Disabled".
        :paramtype enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        :keyword expiration_date: The time at which the announcement expires (null for never).
        :paramtype expiration_date: ~datetime.datetime
        :keyword expired: Has this announcement expired?.
        :paramtype expired: bool
        """
        super().__init__(**kwargs)
        self.title = title
        self.markdown = markdown
        self.enabled = enabled
        self.expiration_date = expiration_date
        self.expired = expired
        self.provisioning_state = None
        self.unique_identifier = None


class LabCost(Resource):  # pylint: disable=too-many-instance-attributes
    """A cost item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar target_cost: The target cost properties.
    :vartype target_cost: ~azure.mgmt.devtestlabs.models.TargetCostProperties
    :ivar lab_cost_summary: The lab cost summary component of the cost data.
    :vartype lab_cost_summary: ~azure.mgmt.devtestlabs.models.LabCostSummaryProperties
    :ivar lab_cost_details: The lab cost details component of the cost data.
    :vartype lab_cost_details: list[~azure.mgmt.devtestlabs.models.LabCostDetailsProperties]
    :ivar resource_costs: The resource cost component of the cost data.
    :vartype resource_costs: list[~azure.mgmt.devtestlabs.models.LabResourceCostProperties]
    :ivar currency_code: The currency code of the cost.
    :vartype currency_code: str
    :ivar start_date_time: The start time of the cost data.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The end time of the cost data.
    :vartype end_date_time: ~datetime.datetime
    :ivar created_date: The creation date of the cost.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "lab_cost_summary": {"readonly": True},
        "lab_cost_details": {"readonly": True},
        "resource_costs": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "target_cost": {"key": "properties.targetCost", "type": "TargetCostProperties"},
        "lab_cost_summary": {"key": "properties.labCostSummary", "type": "LabCostSummaryProperties"},
        "lab_cost_details": {"key": "properties.labCostDetails", "type": "[LabCostDetailsProperties]"},
        "resource_costs": {"key": "properties.resourceCosts", "type": "[LabResourceCostProperties]"},
        "currency_code": {"key": "properties.currencyCode", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        target_cost: Optional["_models.TargetCostProperties"] = None,
        currency_code: Optional[str] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        created_date: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword target_cost: The target cost properties.
        :paramtype target_cost: ~azure.mgmt.devtestlabs.models.TargetCostProperties
        :keyword currency_code: The currency code of the cost.
        :paramtype currency_code: str
        :keyword start_date_time: The start time of the cost data.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: The end time of the cost data.
        :paramtype end_date_time: ~datetime.datetime
        :keyword created_date: The creation date of the cost.
        :paramtype created_date: ~datetime.datetime
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.target_cost = target_cost
        self.lab_cost_summary = None
        self.lab_cost_details = None
        self.resource_costs = None
        self.currency_code = currency_code
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.created_date = created_date
        self.provisioning_state = None
        self.unique_identifier = None


class LabCostDetailsProperties(_serialization.Model):
    """The properties of a lab cost item.

    :ivar date: The date of the cost item.
    :vartype date: ~datetime.datetime
    :ivar cost: The cost component of the cost item.
    :vartype cost: float
    :ivar cost_type: The type of the cost. Known values are: "Unavailable", "Reported", and
     "Projected".
    :vartype cost_type: str or ~azure.mgmt.devtestlabs.models.CostType
    """

    _attribute_map = {
        "date": {"key": "date", "type": "iso-8601"},
        "cost": {"key": "cost", "type": "float"},
        "cost_type": {"key": "costType", "type": "str"},
    }

    def __init__(
        self,
        *,
        date: Optional[datetime.datetime] = None,
        cost: Optional[float] = None,
        cost_type: Optional[Union[str, "_models.CostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword date: The date of the cost item.
        :paramtype date: ~datetime.datetime
        :keyword cost: The cost component of the cost item.
        :paramtype cost: float
        :keyword cost_type: The type of the cost. Known values are: "Unavailable", "Reported", and
         "Projected".
        :paramtype cost_type: str or ~azure.mgmt.devtestlabs.models.CostType
        """
        super().__init__(**kwargs)
        self.date = date
        self.cost = cost
        self.cost_type = cost_type


class LabCostSummaryProperties(_serialization.Model):
    """The properties of the cost summary.

    :ivar estimated_lab_cost: The cost component of the cost item.
    :vartype estimated_lab_cost: float
    """

    _attribute_map = {
        "estimated_lab_cost": {"key": "estimatedLabCost", "type": "float"},
    }

    def __init__(self, *, estimated_lab_cost: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword estimated_lab_cost: The cost component of the cost item.
        :paramtype estimated_lab_cost: float
        """
        super().__init__(**kwargs)
        self.estimated_lab_cost = estimated_lab_cost


class LabFragment(UpdateResource):
    """A lab.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class LabList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Lab]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Lab]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Lab"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Lab]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LabResourceCostProperties(_serialization.Model):
    """The properties of a resource cost item.

    :ivar resourcename: The name of the resource.
    :vartype resourcename: str
    :ivar resource_u_id: The unique identifier of the resource.
    :vartype resource_u_id: str
    :ivar resource_cost: The cost component of the resource cost item.
    :vartype resource_cost: float
    :ivar resource_type: The logical resource type (ex. virtualmachine, storageaccount).
    :vartype resource_type: str
    :ivar resource_owner: The owner of the resource (ex. janedoe@microsoft.com).
    :vartype resource_owner: str
    :ivar resource_pricing_tier: The category of the resource (ex. Premium_LRS, Standard_DS1).
    :vartype resource_pricing_tier: str
    :ivar resource_status: The status of the resource (ex. Active).
    :vartype resource_status: str
    :ivar resource_id: The ID of the resource.
    :vartype resource_id: str
    :ivar external_resource_id: The ID of the external resource.
    :vartype external_resource_id: str
    """

    _attribute_map = {
        "resourcename": {"key": "resourcename", "type": "str"},
        "resource_u_id": {"key": "resourceUId", "type": "str"},
        "resource_cost": {"key": "resourceCost", "type": "float"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_owner": {"key": "resourceOwner", "type": "str"},
        "resource_pricing_tier": {"key": "resourcePricingTier", "type": "str"},
        "resource_status": {"key": "resourceStatus", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "external_resource_id": {"key": "externalResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resourcename: Optional[str] = None,
        resource_u_id: Optional[str] = None,
        resource_cost: Optional[float] = None,
        resource_type: Optional[str] = None,
        resource_owner: Optional[str] = None,
        resource_pricing_tier: Optional[str] = None,
        resource_status: Optional[str] = None,
        resource_id: Optional[str] = None,
        external_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resourcename: The name of the resource.
        :paramtype resourcename: str
        :keyword resource_u_id: The unique identifier of the resource.
        :paramtype resource_u_id: str
        :keyword resource_cost: The cost component of the resource cost item.
        :paramtype resource_cost: float
        :keyword resource_type: The logical resource type (ex. virtualmachine, storageaccount).
        :paramtype resource_type: str
        :keyword resource_owner: The owner of the resource (ex. janedoe@microsoft.com).
        :paramtype resource_owner: str
        :keyword resource_pricing_tier: The category of the resource (ex. Premium_LRS, Standard_DS1).
        :paramtype resource_pricing_tier: str
        :keyword resource_status: The status of the resource (ex. Active).
        :paramtype resource_status: str
        :keyword resource_id: The ID of the resource.
        :paramtype resource_id: str
        :keyword external_resource_id: The ID of the external resource.
        :paramtype external_resource_id: str
        """
        super().__init__(**kwargs)
        self.resourcename = resourcename
        self.resource_u_id = resource_u_id
        self.resource_cost = resource_cost
        self.resource_type = resource_type
        self.resource_owner = resource_owner
        self.resource_pricing_tier = resource_pricing_tier
        self.resource_status = resource_status
        self.resource_id = resource_id
        self.external_resource_id = external_resource_id


class LabSupportProperties(_serialization.Model):
    """Properties of a lab's support banner.

    :ivar enabled: Is the lab support banner active/enabled at this time?. Known values are:
     "Enabled" and "Disabled".
    :vartype enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :vartype markdown: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "str"},
        "markdown": {"key": "markdown", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[Union[str, "_models.EnableStatus"]] = None,
        markdown: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is the lab support banner active/enabled at this time?. Known values are:
         "Enabled" and "Disabled".
        :paramtype enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        :keyword markdown: The markdown text (if any) that this lab displays in the UI. If left
         empty/null, nothing will be shown.
        :paramtype markdown: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.markdown = markdown


class LabVhd(_serialization.Model):
    """Properties of a VHD in the lab.

    :ivar id: The URI to the VHD.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The URI to the VHD.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class LabVhdList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.LabVhd]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LabVhd]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LabVhd"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.LabVhd]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LabVirtualMachine(Resource):  # pylint: disable=too-many-instance-attributes
    """A virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar notes: The notes of the virtual machine.
    :vartype notes: str
    :ivar owner_object_id: The object identifier of the owner of the virtual machine.
    :vartype owner_object_id: str
    :ivar owner_user_principal_name: The user principal name of the virtual machine owner.
    :vartype owner_user_principal_name: str
    :ivar created_by_user_id: The object identifier of the creator of the virtual machine.
    :vartype created_by_user_id: str
    :ivar created_by_user: The email address of creator of the virtual machine.
    :vartype created_by_user: str
    :ivar created_date: The creation date of the virtual machine.
    :vartype created_date: ~datetime.datetime
    :ivar compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
    :vartype compute_id: str
    :ivar custom_image_id: The custom image identifier of the virtual machine.
    :vartype custom_image_id: str
    :ivar os_type: The OS type of the virtual machine.
    :vartype os_type: str
    :ivar size: The size of the virtual machine.
    :vartype size: str
    :ivar user_name: The user name of the virtual machine.
    :vartype user_name: str
    :ivar password: The password of the virtual machine administrator.
    :vartype password: str
    :ivar ssh_key: The SSH key of the virtual machine administrator.
    :vartype ssh_key: str
    :ivar is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :vartype is_authentication_with_ssh_key: bool
    :ivar fqdn: The fully-qualified domain name of the virtual machine.
    :vartype fqdn: str
    :ivar lab_subnet_name: The lab subnet name of the virtual machine.
    :vartype lab_subnet_name: str
    :ivar lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :vartype lab_virtual_network_id: str
    :ivar disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :vartype disallow_public_ip_address: bool
    :ivar artifacts: The artifacts to be installed on the virtual machine.
    :vartype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :ivar artifact_deployment_status: The artifact deployment status for the virtual machine.
    :vartype artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties
    :ivar gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :vartype gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :ivar plan_id: The id of the plan associated with the virtual machine image.
    :vartype plan_id: str
    :ivar compute_vm: The compute virtual machine properties.
    :vartype compute_vm: ~azure.mgmt.devtestlabs.models.ComputeVmProperties
    :ivar network_interface: The network interface properties.
    :vartype network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :ivar applicable_schedule: The applicable schedule for the virtual machine.
    :vartype applicable_schedule: ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :ivar expiration_date: The expiration date for VM.
    :vartype expiration_date: ~datetime.datetime
    :ivar allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :vartype allow_claim: bool
    :ivar storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :vartype storage_type: str
    :ivar virtual_machine_creation_source: Tells source of creation of lab virtual machine. Output
     property only. Known values are: "FromCustomImage", "FromGalleryImage", and
     "FromSharedGalleryImage".
    :vartype virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :ivar environment_id: The resource ID of the environment that contains this virtual machine, if
     any.
    :vartype environment_id: str
    :ivar data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :vartype data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :ivar schedule_parameters: Virtual Machine schedules to be created.
    :vartype schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    :ivar last_known_power_state: Last known compute power state captured in DTL.
    :vartype last_known_power_state: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_by_user_id": {"readonly": True},
        "created_by_user": {"readonly": True},
        "compute_id": {"readonly": True},
        "os_type": {"readonly": True},
        "fqdn": {"readonly": True},
        "artifact_deployment_status": {"readonly": True},
        "compute_vm": {"readonly": True},
        "applicable_schedule": {"readonly": True},
        "virtual_machine_creation_source": {"readonly": True},
        "last_known_power_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "notes": {"key": "properties.notes", "type": "str"},
        "owner_object_id": {"key": "properties.ownerObjectId", "type": "str"},
        "owner_user_principal_name": {"key": "properties.ownerUserPrincipalName", "type": "str"},
        "created_by_user_id": {"key": "properties.createdByUserId", "type": "str"},
        "created_by_user": {"key": "properties.createdByUser", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "compute_id": {"key": "properties.computeId", "type": "str"},
        "custom_image_id": {"key": "properties.customImageId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "size": {"key": "properties.size", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "ssh_key": {"key": "properties.sshKey", "type": "str"},
        "is_authentication_with_ssh_key": {"key": "properties.isAuthenticationWithSshKey", "type": "bool"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "lab_subnet_name": {"key": "properties.labSubnetName", "type": "str"},
        "lab_virtual_network_id": {"key": "properties.labVirtualNetworkId", "type": "str"},
        "disallow_public_ip_address": {"key": "properties.disallowPublicIpAddress", "type": "bool"},
        "artifacts": {"key": "properties.artifacts", "type": "[ArtifactInstallProperties]"},
        "artifact_deployment_status": {
            "key": "properties.artifactDeploymentStatus",
            "type": "ArtifactDeploymentStatusProperties",
        },
        "gallery_image_reference": {"key": "properties.galleryImageReference", "type": "GalleryImageReference"},
        "plan_id": {"key": "properties.planId", "type": "str"},
        "compute_vm": {"key": "properties.computeVm", "type": "ComputeVmProperties"},
        "network_interface": {"key": "properties.networkInterface", "type": "NetworkInterfaceProperties"},
        "applicable_schedule": {"key": "properties.applicableSchedule", "type": "ApplicableSchedule"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "allow_claim": {"key": "properties.allowClaim", "type": "bool"},
        "storage_type": {"key": "properties.storageType", "type": "str"},
        "virtual_machine_creation_source": {"key": "properties.virtualMachineCreationSource", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "data_disk_parameters": {"key": "properties.dataDiskParameters", "type": "[DataDiskProperties]"},
        "schedule_parameters": {"key": "properties.scheduleParameters", "type": "[ScheduleCreationParameter]"},
        "last_known_power_state": {"key": "properties.lastKnownPowerState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        notes: Optional[str] = None,
        owner_object_id: str = "dynamicValue",
        owner_user_principal_name: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        custom_image_id: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: bool = False,
        artifacts: Optional[List["_models.ArtifactInstallProperties"]] = None,
        gallery_image_reference: Optional["_models.GalleryImageReference"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["_models.NetworkInterfaceProperties"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: bool = False,
        storage_type: str = "labStorageType",
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["_models.DataDiskProperties"]] = None,
        schedule_parameters: Optional[List["_models.ScheduleCreationParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword notes: The notes of the virtual machine.
        :paramtype notes: str
        :keyword owner_object_id: The object identifier of the owner of the virtual machine.
        :paramtype owner_object_id: str
        :keyword owner_user_principal_name: The user principal name of the virtual machine owner.
        :paramtype owner_user_principal_name: str
        :keyword created_date: The creation date of the virtual machine.
        :paramtype created_date: ~datetime.datetime
        :keyword custom_image_id: The custom image identifier of the virtual machine.
        :paramtype custom_image_id: str
        :keyword size: The size of the virtual machine.
        :paramtype size: str
        :keyword user_name: The user name of the virtual machine.
        :paramtype user_name: str
        :keyword password: The password of the virtual machine administrator.
        :paramtype password: str
        :keyword ssh_key: The SSH key of the virtual machine administrator.
        :paramtype ssh_key: str
        :keyword is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
         for authentication.
        :paramtype is_authentication_with_ssh_key: bool
        :keyword lab_subnet_name: The lab subnet name of the virtual machine.
        :paramtype lab_subnet_name: str
        :keyword lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :paramtype lab_virtual_network_id: str
        :keyword disallow_public_ip_address: Indicates whether the virtual machine is to be created
         without a public IP address.
        :paramtype disallow_public_ip_address: bool
        :keyword artifacts: The artifacts to be installed on the virtual machine.
        :paramtype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
        :keyword gallery_image_reference: The Microsoft Azure Marketplace image reference of the
         virtual machine.
        :paramtype gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
        :keyword plan_id: The id of the plan associated with the virtual machine image.
        :paramtype plan_id: str
        :keyword network_interface: The network interface properties.
        :paramtype network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
        :keyword expiration_date: The expiration date for VM.
        :paramtype expiration_date: ~datetime.datetime
        :keyword allow_claim: Indicates whether another user can take ownership of the virtual machine.
        :paramtype allow_claim: bool
        :keyword storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :paramtype storage_type: str
        :keyword environment_id: The resource ID of the environment that contains this virtual machine,
         if any.
        :paramtype environment_id: str
        :keyword data_disk_parameters: New or existing data disks to attach to the virtual machine
         after creation.
        :paramtype data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
        :keyword schedule_parameters: Virtual Machine schedules to be created.
        :paramtype schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_by_user_id = None
        self.created_by_user = None
        self.created_date = created_date
        self.compute_id = None
        self.custom_image_id = custom_image_id
        self.os_type = None
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = None
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = None
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.compute_vm = None
        self.network_interface = network_interface
        self.applicable_schedule = None
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.virtual_machine_creation_source = None
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters
        self.last_known_power_state = None
        self.provisioning_state = None
        self.unique_identifier = None


class LabVirtualMachineCreationParameter(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties for creating a virtual machine.

    :ivar name: The name of the virtual machine or environment.
    :vartype name: str
    :ivar location: The location of the new virtual machine or environment.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar bulk_creation_parameters: The number of virtual machine instances to create.
    :vartype bulk_creation_parameters: ~azure.mgmt.devtestlabs.models.BulkCreationParameters
    :ivar notes: The notes of the virtual machine.
    :vartype notes: str
    :ivar owner_object_id: The object identifier of the owner of the virtual machine.
    :vartype owner_object_id: str
    :ivar owner_user_principal_name: The user principal name of the virtual machine owner.
    :vartype owner_user_principal_name: str
    :ivar created_date: The creation date of the virtual machine.
    :vartype created_date: ~datetime.datetime
    :ivar custom_image_id: The custom image identifier of the virtual machine.
    :vartype custom_image_id: str
    :ivar size: The size of the virtual machine.
    :vartype size: str
    :ivar user_name: The user name of the virtual machine.
    :vartype user_name: str
    :ivar password: The password of the virtual machine administrator.
    :vartype password: str
    :ivar ssh_key: The SSH key of the virtual machine administrator.
    :vartype ssh_key: str
    :ivar is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :vartype is_authentication_with_ssh_key: bool
    :ivar lab_subnet_name: The lab subnet name of the virtual machine.
    :vartype lab_subnet_name: str
    :ivar lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :vartype lab_virtual_network_id: str
    :ivar disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :vartype disallow_public_ip_address: bool
    :ivar artifacts: The artifacts to be installed on the virtual machine.
    :vartype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :ivar gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :vartype gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :ivar plan_id: The id of the plan associated with the virtual machine image.
    :vartype plan_id: str
    :ivar network_interface: The network interface properties.
    :vartype network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :ivar expiration_date: The expiration date for VM.
    :vartype expiration_date: ~datetime.datetime
    :ivar allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :vartype allow_claim: bool
    :ivar storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :vartype storage_type: str
    :ivar environment_id: The resource ID of the environment that contains this virtual machine, if
     any.
    :vartype environment_id: str
    :ivar data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :vartype data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :ivar schedule_parameters: Virtual Machine schedules to be created.
    :vartype schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "bulk_creation_parameters": {"key": "properties.bulkCreationParameters", "type": "BulkCreationParameters"},
        "notes": {"key": "properties.notes", "type": "str"},
        "owner_object_id": {"key": "properties.ownerObjectId", "type": "str"},
        "owner_user_principal_name": {"key": "properties.ownerUserPrincipalName", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "custom_image_id": {"key": "properties.customImageId", "type": "str"},
        "size": {"key": "properties.size", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "ssh_key": {"key": "properties.sshKey", "type": "str"},
        "is_authentication_with_ssh_key": {"key": "properties.isAuthenticationWithSshKey", "type": "bool"},
        "lab_subnet_name": {"key": "properties.labSubnetName", "type": "str"},
        "lab_virtual_network_id": {"key": "properties.labVirtualNetworkId", "type": "str"},
        "disallow_public_ip_address": {"key": "properties.disallowPublicIpAddress", "type": "bool"},
        "artifacts": {"key": "properties.artifacts", "type": "[ArtifactInstallProperties]"},
        "gallery_image_reference": {"key": "properties.galleryImageReference", "type": "GalleryImageReference"},
        "plan_id": {"key": "properties.planId", "type": "str"},
        "network_interface": {"key": "properties.networkInterface", "type": "NetworkInterfaceProperties"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "allow_claim": {"key": "properties.allowClaim", "type": "bool"},
        "storage_type": {"key": "properties.storageType", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "data_disk_parameters": {"key": "properties.dataDiskParameters", "type": "[DataDiskProperties]"},
        "schedule_parameters": {"key": "properties.scheduleParameters", "type": "[ScheduleCreationParameter]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        bulk_creation_parameters: Optional["_models.BulkCreationParameters"] = None,
        notes: Optional[str] = None,
        owner_object_id: str = "dynamicValue",
        owner_user_principal_name: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        custom_image_id: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: bool = False,
        artifacts: Optional[List["_models.ArtifactInstallProperties"]] = None,
        gallery_image_reference: Optional["_models.GalleryImageReference"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["_models.NetworkInterfaceProperties"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: bool = False,
        storage_type: str = "labStorageType",
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["_models.DataDiskProperties"]] = None,
        schedule_parameters: Optional[List["_models.ScheduleCreationParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the virtual machine or environment.
        :paramtype name: str
        :keyword location: The location of the new virtual machine or environment.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword bulk_creation_parameters: The number of virtual machine instances to create.
        :paramtype bulk_creation_parameters: ~azure.mgmt.devtestlabs.models.BulkCreationParameters
        :keyword notes: The notes of the virtual machine.
        :paramtype notes: str
        :keyword owner_object_id: The object identifier of the owner of the virtual machine.
        :paramtype owner_object_id: str
        :keyword owner_user_principal_name: The user principal name of the virtual machine owner.
        :paramtype owner_user_principal_name: str
        :keyword created_date: The creation date of the virtual machine.
        :paramtype created_date: ~datetime.datetime
        :keyword custom_image_id: The custom image identifier of the virtual machine.
        :paramtype custom_image_id: str
        :keyword size: The size of the virtual machine.
        :paramtype size: str
        :keyword user_name: The user name of the virtual machine.
        :paramtype user_name: str
        :keyword password: The password of the virtual machine administrator.
        :paramtype password: str
        :keyword ssh_key: The SSH key of the virtual machine administrator.
        :paramtype ssh_key: str
        :keyword is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
         for authentication.
        :paramtype is_authentication_with_ssh_key: bool
        :keyword lab_subnet_name: The lab subnet name of the virtual machine.
        :paramtype lab_subnet_name: str
        :keyword lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :paramtype lab_virtual_network_id: str
        :keyword disallow_public_ip_address: Indicates whether the virtual machine is to be created
         without a public IP address.
        :paramtype disallow_public_ip_address: bool
        :keyword artifacts: The artifacts to be installed on the virtual machine.
        :paramtype artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
        :keyword gallery_image_reference: The Microsoft Azure Marketplace image reference of the
         virtual machine.
        :paramtype gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
        :keyword plan_id: The id of the plan associated with the virtual machine image.
        :paramtype plan_id: str
        :keyword network_interface: The network interface properties.
        :paramtype network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
        :keyword expiration_date: The expiration date for VM.
        :paramtype expiration_date: ~datetime.datetime
        :keyword allow_claim: Indicates whether another user can take ownership of the virtual machine.
        :paramtype allow_claim: bool
        :keyword storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :paramtype storage_type: str
        :keyword environment_id: The resource ID of the environment that contains this virtual machine,
         if any.
        :paramtype environment_id: str
        :keyword data_disk_parameters: New or existing data disks to attach to the virtual machine
         after creation.
        :paramtype data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
        :keyword schedule_parameters: Virtual Machine schedules to be created.
        :paramtype schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.bulk_creation_parameters = bulk_creation_parameters
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_date = created_date
        self.custom_image_id = custom_image_id
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.network_interface = network_interface
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters


class LabVirtualMachineFragment(UpdateResource):
    """A virtual machine.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class LabVirtualMachineList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.LabVirtualMachine]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LabVirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LabVirtualMachine"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.LabVirtualMachine]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LinuxOsInfo(_serialization.Model):
    """Information about a Linux OS.

    :ivar linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested,
     DeprovisionApplied). Known values are: "NonDeprovisioned", "DeprovisionRequested", and
     "DeprovisionApplied".
    :vartype linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
    """

    _attribute_map = {
        "linux_os_state": {"key": "linuxOsState", "type": "str"},
    }

    def __init__(self, *, linux_os_state: Optional[Union[str, "_models.LinuxOsState"]] = None, **kwargs: Any) -> None:
        """
        :keyword linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned,
         DeprovisionRequested, DeprovisionApplied). Known values are: "NonDeprovisioned",
         "DeprovisionRequested", and "DeprovisionApplied".
        :paramtype linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
        """
        super().__init__(**kwargs)
        self.linux_os_state = linux_os_state


class NetworkInterfaceProperties(_serialization.Model):
    """Properties of a network interface.

    :ivar virtual_network_id: The resource ID of the virtual network.
    :vartype virtual_network_id: str
    :ivar subnet_id: The resource ID of the sub net.
    :vartype subnet_id: str
    :ivar public_ip_address_id: The resource ID of the public IP address.
    :vartype public_ip_address_id: str
    :ivar public_ip_address: The public IP address.
    :vartype public_ip_address: str
    :ivar private_ip_address: The private IP address.
    :vartype private_ip_address: str
    :ivar dns_name: The DNS name.
    :vartype dns_name: str
    :ivar rdp_authority: The RdpAuthority property is a server DNS host name or IP address followed
     by the service port number for RDP (Remote Desktop Protocol).
    :vartype rdp_authority: str
    :ivar ssh_authority: The SshAuthority property is a server DNS host name or IP address followed
     by the service port number for SSH.
    :vartype ssh_authority: str
    :ivar shared_public_ip_address_configuration: The configuration for sharing a public IP address
     across multiple virtual machines.
    :vartype shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfiguration
    """

    _attribute_map = {
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "public_ip_address_id": {"key": "publicIpAddressId", "type": "str"},
        "public_ip_address": {"key": "publicIpAddress", "type": "str"},
        "private_ip_address": {"key": "privateIpAddress", "type": "str"},
        "dns_name": {"key": "dnsName", "type": "str"},
        "rdp_authority": {"key": "rdpAuthority", "type": "str"},
        "ssh_authority": {"key": "sshAuthority", "type": "str"},
        "shared_public_ip_address_configuration": {
            "key": "sharedPublicIpAddressConfiguration",
            "type": "SharedPublicIpAddressConfiguration",
        },
    }

    def __init__(
        self,
        *,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        public_ip_address_id: Optional[str] = None,
        public_ip_address: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        dns_name: Optional[str] = None,
        rdp_authority: Optional[str] = None,
        ssh_authority: Optional[str] = None,
        shared_public_ip_address_configuration: Optional["_models.SharedPublicIpAddressConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network_id: The resource ID of the virtual network.
        :paramtype virtual_network_id: str
        :keyword subnet_id: The resource ID of the sub net.
        :paramtype subnet_id: str
        :keyword public_ip_address_id: The resource ID of the public IP address.
        :paramtype public_ip_address_id: str
        :keyword public_ip_address: The public IP address.
        :paramtype public_ip_address: str
        :keyword private_ip_address: The private IP address.
        :paramtype private_ip_address: str
        :keyword dns_name: The DNS name.
        :paramtype dns_name: str
        :keyword rdp_authority: The RdpAuthority property is a server DNS host name or IP address
         followed by the service port number for RDP (Remote Desktop Protocol).
        :paramtype rdp_authority: str
        :keyword ssh_authority: The SshAuthority property is a server DNS host name or IP address
         followed by the service port number for SSH.
        :paramtype ssh_authority: str
        :keyword shared_public_ip_address_configuration: The configuration for sharing a public IP
         address across multiple virtual machines.
        :paramtype shared_public_ip_address_configuration:
         ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfiguration
        """
        super().__init__(**kwargs)
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.public_ip_address_id = public_ip_address_id
        self.public_ip_address = public_ip_address
        self.private_ip_address = private_ip_address
        self.dns_name = dns_name
        self.rdp_authority = rdp_authority
        self.ssh_authority = ssh_authority
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration


class NotificationChannel(Resource):  # pylint: disable=too-many-instance-attributes
    """A notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar web_hook_url: The webhook URL to send notifications to.
    :vartype web_hook_url: str
    :ivar email_recipient: The email recipient to send notifications to (can be a list of
     semi-colon separated email addresses).
    :vartype email_recipient: str
    :ivar notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :vartype notification_locale: str
    :ivar description: Description of notification.
    :vartype description: str
    :ivar events: The list of event for which this notification is enabled.
    :vartype events: list[~azure.mgmt.devtestlabs.models.Event]
    :ivar created_date: The creation date of the notification channel.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "web_hook_url": {"key": "properties.webHookUrl", "type": "str"},
        "email_recipient": {"key": "properties.emailRecipient", "type": "str"},
        "notification_locale": {"key": "properties.notificationLocale", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "events": {"key": "properties.events", "type": "[Event]"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        web_hook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        description: Optional[str] = None,
        events: Optional[List["_models.Event"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword web_hook_url: The webhook URL to send notifications to.
        :paramtype web_hook_url: str
        :keyword email_recipient: The email recipient to send notifications to (can be a list of
         semi-colon separated email addresses).
        :paramtype email_recipient: str
        :keyword notification_locale: The locale to use when sending a notification (fallback for
         unsupported languages is EN).
        :paramtype notification_locale: str
        :keyword description: Description of notification.
        :paramtype description: str
        :keyword events: The list of event for which this notification is enabled.
        :paramtype events: list[~azure.mgmt.devtestlabs.models.Event]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.web_hook_url = web_hook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale
        self.description = description
        self.events = events
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class NotificationChannelFragment(UpdateResource):
    """A notification.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class NotificationChannelList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.NotificationChannel]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NotificationChannel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NotificationChannel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.NotificationChannel]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NotificationSettings(_serialization.Model):
    """Notification settings for a schedule.

    :ivar status: If notifications are enabled for this schedule (i.e. Enabled, Disabled). Known
     values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar time_in_minutes: Time in minutes before event at which notification will be sent.
    :vartype time_in_minutes: int
    :ivar webhook_url: The webhook URL to which the notification will be sent.
    :vartype webhook_url: str
    :ivar email_recipient: The email recipient to send notifications to (can be a list of
     semi-colon separated email addresses).
    :vartype email_recipient: str
    :ivar notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :vartype notification_locale: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "time_in_minutes": {"key": "timeInMinutes", "type": "int"},
        "webhook_url": {"key": "webhookUrl", "type": "str"},
        "email_recipient": {"key": "emailRecipient", "type": "str"},
        "notification_locale": {"key": "notificationLocale", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.EnableStatus"]] = None,
        time_in_minutes: Optional[int] = None,
        webhook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: If notifications are enabled for this schedule (i.e. Enabled, Disabled). Known
         values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        :keyword time_in_minutes: Time in minutes before event at which notification will be sent.
        :paramtype time_in_minutes: int
        :keyword webhook_url: The webhook URL to which the notification will be sent.
        :paramtype webhook_url: str
        :keyword email_recipient: The email recipient to send notifications to (can be a list of
         semi-colon separated email addresses).
        :paramtype email_recipient: str
        :keyword notification_locale: The locale to use when sending a notification (fallback for
         unsupported languages is EN).
        :paramtype notification_locale: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.time_in_minutes = time_in_minutes
        self.webhook_url = webhook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale


class NotifyParameters(_serialization.Model):
    """Properties for generating a Notification.

    :ivar event_name: The type of event (i.e. AutoShutdown, Cost). Known values are: "AutoShutdown"
     and "Cost".
    :vartype event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    :ivar json_payload: Properties for the notification in json format.
    :vartype json_payload: str
    """

    _attribute_map = {
        "event_name": {"key": "eventName", "type": "str"},
        "json_payload": {"key": "jsonPayload", "type": "str"},
    }

    def __init__(
        self,
        *,
        event_name: Optional[Union[str, "_models.NotificationChannelEventType"]] = None,
        json_payload: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_name: The type of event (i.e. AutoShutdown, Cost). Known values are:
         "AutoShutdown" and "Cost".
        :paramtype event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
        :keyword json_payload: Properties for the notification in json format.
        :paramtype json_payload: str
        """
        super().__init__(**kwargs)
        self.event_name = event_name
        self.json_payload = json_payload


class OperationError(_serialization.Model):
    """Error details for the operation in case of a failure.

    :ivar code: The error code of the operation error.
    :vartype code: str
    :ivar message: The error message of the operation error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The error code of the operation error.
        :paramtype code: str
        :keyword message: The error message of the operation error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class OperationMetadata(_serialization.Model):
    """The REST API operation supported by DevTestLab ResourceProvider.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that describes the operations.
    :vartype display: ~azure.mgmt.devtestlabs.models.OperationMetadataDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationMetadataDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationMetadataDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that describes the operations.
        :paramtype display: ~azure.mgmt.devtestlabs.models.OperationMetadataDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationMetadataDisplay(_serialization.Model):
    """The object that describes the operations.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation type: read, write, delete, listKeys/action, etc.
    :vartype operation: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword resource: Resource type on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation type: read, write, delete, listKeys/action, etc.
        :paramtype operation: str
        :keyword description: Friendly name of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationResult(_serialization.Model):
    """An Operation Result.

    :ivar status: The operation status.
    :vartype status: str
    :ivar status_code: The status code for the operation. Known values are: "Continue",
     "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
     "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
     "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
     "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
     "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
     "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
     "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
     "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
     "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
     "HttpVersionNotSupported", and "Continue".
    :vartype status_code: str or ~azure.mgmt.devtestlabs.models.HttpStatusCode
    :ivar error: Error details for the operation in case of a failure.
    :vartype error: ~azure.mgmt.devtestlabs.models.OperationError
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "error": {"key": "error", "type": "OperationError"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        status_code: Optional[Union[str, "_models.HttpStatusCode"]] = None,
        error: Optional["_models.OperationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The operation status.
        :paramtype status: str
        :keyword status_code: The status code for the operation. Known values are: "Continue",
         "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
         "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
         "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
         "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
         "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
         "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
         "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
         "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
         "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
         "HttpVersionNotSupported", and "Continue".
        :paramtype status_code: str or ~azure.mgmt.devtestlabs.models.HttpStatusCode
        :keyword error: Error details for the operation in case of a failure.
        :paramtype error: ~azure.mgmt.devtestlabs.models.OperationError
        """
        super().__init__(**kwargs)
        self.status = status
        self.status_code = status_code
        self.error = error


class ParameterInfo(_serialization.Model):
    """Information about an artifact's parameter.

    :ivar name: The name of the artifact parameter.
    :vartype name: str
    :ivar value: The value of the artifact parameter.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the artifact parameter.
        :paramtype name: str
        :keyword value: The value of the artifact parameter.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ParametersValueFileInfo(_serialization.Model):
    """A file containing a set of parameter values for an ARM template.

    :ivar file_name: File name.
    :vartype file_name: str
    :ivar parameters_value_info: Contents of the file.
    :vartype parameters_value_info: JSON
    """

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "parameters_value_info": {"key": "parametersValueInfo", "type": "object"},
    }

    def __init__(
        self, *, file_name: Optional[str] = None, parameters_value_info: Optional[JSON] = None, **kwargs: Any
    ) -> None:
        """
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword parameters_value_info: Contents of the file.
        :paramtype parameters_value_info: JSON
        """
        super().__init__(**kwargs)
        self.file_name = file_name
        self.parameters_value_info = parameters_value_info


class PercentageCostThresholdProperties(_serialization.Model):
    """Properties of a percentage cost threshold.

    :ivar threshold_value: The cost threshold value.
    :vartype threshold_value: float
    """

    _attribute_map = {
        "threshold_value": {"key": "thresholdValue", "type": "float"},
    }

    def __init__(self, *, threshold_value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword threshold_value: The cost threshold value.
        :paramtype threshold_value: float
        """
        super().__init__(**kwargs)
        self.threshold_value = threshold_value


class Policy(Resource):  # pylint: disable=too-many-instance-attributes
    """A Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar description: The description of the policy.
    :vartype description: str
    :ivar status: The status of the policy. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
    :ivar fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab,
     etc. Known values are: "UserOwnedLabVmCount", "UserOwnedLabPremiumVmCount", "LabVmCount",
     "LabPremiumVmCount", "LabVmSize", "GalleryImage", "UserOwnedLabVmCountInSubnet",
     "LabTargetCost", "EnvironmentTemplate", and "ScheduleEditPermission".
    :vartype fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
    :ivar fact_data: The fact data of the policy.
    :vartype fact_data: str
    :ivar threshold: The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON
     array of values for AllowedValuesPolicy).
    :vartype threshold: str
    :ivar evaluator_type: The evaluator type of the policy (i.e. AllowedValuesPolicy,
     MaxValuePolicy). Known values are: "AllowedValuesPolicy" and "MaxValuePolicy".
    :vartype evaluator_type: str or ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
    :ivar created_date: The creation date of the policy.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "fact_name": {"key": "properties.factName", "type": "str"},
        "fact_data": {"key": "properties.factData", "type": "str"},
        "threshold": {"key": "properties.threshold", "type": "str"},
        "evaluator_type": {"key": "properties.evaluatorType", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        status: Optional[Union[str, "_models.PolicyStatus"]] = None,
        fact_name: Optional[Union[str, "_models.PolicyFactName"]] = None,
        fact_data: Optional[str] = None,
        threshold: Optional[str] = None,
        evaluator_type: Optional[Union[str, "_models.PolicyEvaluatorType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword description: The description of the policy.
        :paramtype description: str
        :keyword status: The status of the policy. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
        :keyword fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize,
         MaxVmsAllowedPerLab, etc. Known values are: "UserOwnedLabVmCount",
         "UserOwnedLabPremiumVmCount", "LabVmCount", "LabPremiumVmCount", "LabVmSize", "GalleryImage",
         "UserOwnedLabVmCountInSubnet", "LabTargetCost", "EnvironmentTemplate", and
         "ScheduleEditPermission".
        :paramtype fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
        :keyword fact_data: The fact data of the policy.
        :paramtype fact_data: str
        :keyword threshold: The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON
         array of values for AllowedValuesPolicy).
        :paramtype threshold: str
        :keyword evaluator_type: The evaluator type of the policy (i.e. AllowedValuesPolicy,
         MaxValuePolicy). Known values are: "AllowedValuesPolicy" and "MaxValuePolicy".
        :paramtype evaluator_type: str or ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.status = status
        self.fact_name = fact_name
        self.fact_data = fact_data
        self.threshold = threshold
        self.evaluator_type = evaluator_type
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class PolicyFragment(UpdateResource):
    """A Policy.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class PolicyList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Policy]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Policy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Policy"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Policy]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySetResult(_serialization.Model):
    """Result of a policy set evaluation.

    :ivar has_error: A value indicating whether this policy set evaluation has discovered
     violations.
    :vartype has_error: bool
    :ivar policy_violations: The list of policy violations.
    :vartype policy_violations: list[~azure.mgmt.devtestlabs.models.PolicyViolation]
    """

    _attribute_map = {
        "has_error": {"key": "hasError", "type": "bool"},
        "policy_violations": {"key": "policyViolations", "type": "[PolicyViolation]"},
    }

    def __init__(
        self,
        *,
        has_error: Optional[bool] = None,
        policy_violations: Optional[List["_models.PolicyViolation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword has_error: A value indicating whether this policy set evaluation has discovered
         violations.
        :paramtype has_error: bool
        :keyword policy_violations: The list of policy violations.
        :paramtype policy_violations: list[~azure.mgmt.devtestlabs.models.PolicyViolation]
        """
        super().__init__(**kwargs)
        self.has_error = has_error
        self.policy_violations = policy_violations


class PolicyViolation(_serialization.Model):
    """Policy violation.

    :ivar code: The code of the policy violation.
    :vartype code: str
    :ivar message: The message of the policy violation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The code of the policy violation.
        :paramtype code: str
        :keyword message: The message of the policy violation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class Port(_serialization.Model):
    """Properties of a network port.

    :ivar transport_protocol: Protocol type of the port. Known values are: "Tcp" and "Udp".
    :vartype transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :ivar backend_port: Backend port of the target virtual machine.
    :vartype backend_port: int
    """

    _attribute_map = {
        "transport_protocol": {"key": "transportProtocol", "type": "str"},
        "backend_port": {"key": "backendPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        backend_port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transport_protocol: Protocol type of the port. Known values are: "Tcp" and "Udp".
        :paramtype transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
        :keyword backend_port: Backend port of the target virtual machine.
        :paramtype backend_port: int
        """
        super().__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.backend_port = backend_port


class ProviderOperationResult(_serialization.Model):
    """Result of the request to list REST API operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.devtestlabs.models.OperationMetadata]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.OperationMetadata"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.OperationMetadata]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RdpConnection(_serialization.Model):
    """Represents a .rdp file.

    :ivar contents: The contents of the .rdp file.
    :vartype contents: str
    """

    _attribute_map = {
        "contents": {"key": "contents", "type": "str"},
    }

    def __init__(self, *, contents: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword contents: The contents of the .rdp file.
        :paramtype contents: str
        """
        super().__init__(**kwargs)
        self.contents = contents


class ResizeLabVirtualMachineProperties(_serialization.Model):
    """Request body for resizing a virtual machine.

    :ivar size: Specifies the size of the virtual machine.
    :vartype size: str
    """

    _attribute_map = {
        "size": {"key": "size", "type": "str"},
    }

    def __init__(self, *, size: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword size: Specifies the size of the virtual machine.
        :paramtype size: str
        """
        super().__init__(**kwargs)
        self.size = size


class RetargetScheduleProperties(_serialization.Model):
    """Properties for retargeting a virtual machine schedule.

    :ivar current_resource_id: The resource Id of the virtual machine on which the schedule
     operates.
    :vartype current_resource_id: str
    :ivar target_resource_id: The resource Id of the virtual machine that the schedule should be
     retargeted to.
    :vartype target_resource_id: str
    """

    _attribute_map = {
        "current_resource_id": {"key": "currentResourceId", "type": "str"},
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(
        self, *, current_resource_id: Optional[str] = None, target_resource_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword current_resource_id: The resource Id of the virtual machine on which the schedule
         operates.
        :paramtype current_resource_id: str
        :keyword target_resource_id: The resource Id of the virtual machine that the schedule should be
         retargeted to.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.current_resource_id = current_resource_id
        self.target_resource_id = target_resource_id


class Schedule(Resource):  # pylint: disable=too-many-instance-attributes
    """A schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar status: The status of the schedule (i.e. Enabled, Disabled). Known values are: "Enabled"
     and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :vartype task_type: str
    :ivar weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :vartype weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :ivar daily_recurrence: If the schedule will occur once each day of the week, specify the daily
     recurrence.
    :vartype daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :ivar hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :vartype hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :ivar time_zone_id: The time zone ID (e.g. China Standard Time, Greenland Standard Time,
     Pacific Standard time, etc.). The possible values for this property can be found in
     ``IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds``
     (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md).
    :vartype time_zone_id: str
    :ivar notification_settings: Notification settings.
    :vartype notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
    :ivar created_date: The creation date of the schedule.
    :vartype created_date: ~datetime.datetime
    :ivar target_resource_id: The resource ID to which the schedule belongs.
    :vartype target_resource_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "task_type": {"key": "properties.taskType", "type": "str"},
        "weekly_recurrence": {"key": "properties.weeklyRecurrence", "type": "WeekDetails"},
        "daily_recurrence": {"key": "properties.dailyRecurrence", "type": "DayDetails"},
        "hourly_recurrence": {"key": "properties.hourlyRecurrence", "type": "HourDetails"},
        "time_zone_id": {"key": "properties.timeZoneId", "type": "str"},
        "notification_settings": {"key": "properties.notificationSettings", "type": "NotificationSettings"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["_models.WeekDetails"] = None,
        daily_recurrence: Optional["_models.DayDetails"] = None,
        hourly_recurrence: Optional["_models.HourDetails"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["_models.NotificationSettings"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword status: The status of the schedule (i.e. Enabled, Disabled). Known values are:
         "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        :keyword task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        :paramtype task_type: str
        :keyword weekly_recurrence: If the schedule will occur only some days of the week, specify the
         weekly recurrence.
        :paramtype weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
        :keyword daily_recurrence: If the schedule will occur once each day of the week, specify the
         daily recurrence.
        :paramtype daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
        :keyword hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
         recurrence.
        :paramtype hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
        :keyword time_zone_id: The time zone ID (e.g. China Standard Time, Greenland Standard Time,
         Pacific Standard time, etc.). The possible values for this property can be found in
         ``IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds``
         (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md).
        :paramtype time_zone_id: str
        :keyword notification_settings: Notification settings.
        :paramtype notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
        :keyword target_resource_id: The resource ID to which the schedule belongs.
        :paramtype target_resource_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.created_date = None
        self.target_resource_id = target_resource_id
        self.provisioning_state = None
        self.unique_identifier = None


class ScheduleCreationParameter(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties for creating a schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the virtual machine or environment.
    :vartype name: str
    :ivar location: The location of the new virtual machine or environment.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar status: The status of the schedule (i.e. Enabled, Disabled). Known values are: "Enabled"
     and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :vartype task_type: str
    :ivar weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :vartype weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :ivar daily_recurrence: If the schedule will occur once each day of the week, specify the daily
     recurrence.
    :vartype daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :ivar hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :vartype hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :ivar time_zone_id: The time zone ID (e.g. China Standard Time, Greenland Standard Time,
     Pacific Standard time, etc.). The possible values for this property can be found in
     ``IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds``
     (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md).
    :vartype time_zone_id: str
    :ivar notification_settings: Notification settings.
    :vartype notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
    :ivar target_resource_id: The resource ID to which the schedule belongs.
    :vartype target_resource_id: str
    """

    _validation = {
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "task_type": {"key": "properties.taskType", "type": "str"},
        "weekly_recurrence": {"key": "properties.weeklyRecurrence", "type": "WeekDetails"},
        "daily_recurrence": {"key": "properties.dailyRecurrence", "type": "DayDetails"},
        "hourly_recurrence": {"key": "properties.hourlyRecurrence", "type": "HourDetails"},
        "time_zone_id": {"key": "properties.timeZoneId", "type": "str"},
        "notification_settings": {"key": "properties.notificationSettings", "type": "NotificationSettings"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["_models.WeekDetails"] = None,
        daily_recurrence: Optional["_models.DayDetails"] = None,
        hourly_recurrence: Optional["_models.HourDetails"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["_models.NotificationSettings"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the virtual machine or environment.
        :paramtype name: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword status: The status of the schedule (i.e. Enabled, Disabled). Known values are:
         "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
        :keyword task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        :paramtype task_type: str
        :keyword weekly_recurrence: If the schedule will occur only some days of the week, specify the
         weekly recurrence.
        :paramtype weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
        :keyword daily_recurrence: If the schedule will occur once each day of the week, specify the
         daily recurrence.
        :paramtype daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
        :keyword hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
         recurrence.
        :paramtype hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
        :keyword time_zone_id: The time zone ID (e.g. China Standard Time, Greenland Standard Time,
         Pacific Standard time, etc.). The possible values for this property can be found in
         ``IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds``
         (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md).
        :paramtype time_zone_id: str
        :keyword notification_settings: Notification settings.
        :paramtype notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
        :keyword target_resource_id: The resource ID to which the schedule belongs.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = None
        self.tags = tags
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.target_resource_id = target_resource_id


class ScheduleFragment(UpdateResource):
    """A schedule.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class ScheduleList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Schedule]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Schedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Schedule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Schedule]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Secret(Resource):
    """A secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar value: The value of the secret for secret creation.
    :vartype value: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "value": {"key": "properties.value", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword value: The value of the secret for secret creation.
        :paramtype value: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.value = value
        self.provisioning_state = None
        self.unique_identifier = None


class SecretFragment(UpdateResource):
    """A secret.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class SecretList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.Secret]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Secret]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Secret"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.Secret]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceFabric(Resource):
    """A Service Fabric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar external_service_fabric_id: The backing service fabric resource's id.
    :vartype external_service_fabric_id: str
    :ivar environment_id: The resource id of the environment under which the service fabric
     resource is present.
    :vartype environment_id: str
    :ivar applicable_schedule: The applicable schedule for the virtual machine.
    :vartype applicable_schedule: ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "applicable_schedule": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "external_service_fabric_id": {"key": "properties.externalServiceFabricId", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "applicable_schedule": {"key": "properties.applicableSchedule", "type": "ApplicableSchedule"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        external_service_fabric_id: Optional[str] = None,
        environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword external_service_fabric_id: The backing service fabric resource's id.
        :paramtype external_service_fabric_id: str
        :keyword environment_id: The resource id of the environment under which the service fabric
         resource is present.
        :paramtype environment_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.external_service_fabric_id = external_service_fabric_id
        self.environment_id = environment_id
        self.applicable_schedule = None
        self.provisioning_state = None
        self.unique_identifier = None


class ServiceFabricFragment(UpdateResource):
    """A Service Fabric.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class ServiceFabricList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.ServiceFabric]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceFabric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServiceFabric"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.ServiceFabric]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceRunner(Resource):
    """A container for a managed identity to execute DevTest lab services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.devtestlabs.models.IdentityProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.devtestlabs.models.IdentityProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity


class ServiceRunnerList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.ServiceRunner]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceRunner]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServiceRunner"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.ServiceRunner]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedPublicIpAddressConfiguration(_serialization.Model):
    """Properties of a virtual machine that determine how it is connected to a load balancer.

    :ivar inbound_nat_rules: The incoming NAT rules.
    :vartype inbound_nat_rules: list[~azure.mgmt.devtestlabs.models.InboundNatRule]
    """

    _attribute_map = {
        "inbound_nat_rules": {"key": "inboundNatRules", "type": "[InboundNatRule]"},
    }

    def __init__(self, *, inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword inbound_nat_rules: The incoming NAT rules.
        :paramtype inbound_nat_rules: list[~azure.mgmt.devtestlabs.models.InboundNatRule]
        """
        super().__init__(**kwargs)
        self.inbound_nat_rules = inbound_nat_rules


class ShutdownNotificationContent(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The contents of a shutdown notification. Webhooks can use this type to deserialize the request
    body when they get notified of an imminent shutdown.

    :ivar skip_url: The URL to skip auto-shutdown.
    :vartype skip_url: str
    :ivar delay_url60: The URL to delay shutdown by 60 minutes.
    :vartype delay_url60: str
    :ivar delay_url120: The URL to delay shutdown by 2 hours.
    :vartype delay_url120: str
    :ivar vm_name: The virtual machine to be shut down.
    :vartype vm_name: str
    :ivar guid: The GUID for the virtual machine to be shut down.
    :vartype guid: str
    :ivar owner: The owner of the virtual machine.
    :vartype owner: str
    :ivar vm_url: The URL of the virtual machine.
    :vartype vm_url: str
    :ivar minutes_until_shutdown: Minutes remaining until shutdown.
    :vartype minutes_until_shutdown: str
    :ivar event_type: The event for which a notification will be sent.
    :vartype event_type: str
    :ivar text: The text for the notification.
    :vartype text: str
    :ivar subscription_id: The subscription ID for the schedule.
    :vartype subscription_id: str
    :ivar resource_group_name: The resource group name for the schedule.
    :vartype resource_group_name: str
    :ivar lab_name: The lab for the schedule.
    :vartype lab_name: str
    """

    _attribute_map = {
        "skip_url": {"key": "skipUrl", "type": "str"},
        "delay_url60": {"key": "delayUrl60", "type": "str"},
        "delay_url120": {"key": "delayUrl120", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "guid": {"key": "guid", "type": "str"},
        "owner": {"key": "owner", "type": "str"},
        "vm_url": {"key": "vmUrl", "type": "str"},
        "minutes_until_shutdown": {"key": "minutesUntilShutdown", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "lab_name": {"key": "labName", "type": "str"},
    }

    def __init__(
        self,
        *,
        skip_url: Optional[str] = None,
        delay_url60: Optional[str] = None,
        delay_url120: Optional[str] = None,
        vm_name: Optional[str] = None,
        guid: Optional[str] = None,
        owner: Optional[str] = None,
        vm_url: Optional[str] = None,
        minutes_until_shutdown: Optional[str] = None,
        event_type: Optional[str] = None,
        text: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        lab_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword skip_url: The URL to skip auto-shutdown.
        :paramtype skip_url: str
        :keyword delay_url60: The URL to delay shutdown by 60 minutes.
        :paramtype delay_url60: str
        :keyword delay_url120: The URL to delay shutdown by 2 hours.
        :paramtype delay_url120: str
        :keyword vm_name: The virtual machine to be shut down.
        :paramtype vm_name: str
        :keyword guid: The GUID for the virtual machine to be shut down.
        :paramtype guid: str
        :keyword owner: The owner of the virtual machine.
        :paramtype owner: str
        :keyword vm_url: The URL of the virtual machine.
        :paramtype vm_url: str
        :keyword minutes_until_shutdown: Minutes remaining until shutdown.
        :paramtype minutes_until_shutdown: str
        :keyword event_type: The event for which a notification will be sent.
        :paramtype event_type: str
        :keyword text: The text for the notification.
        :paramtype text: str
        :keyword subscription_id: The subscription ID for the schedule.
        :paramtype subscription_id: str
        :keyword resource_group_name: The resource group name for the schedule.
        :paramtype resource_group_name: str
        :keyword lab_name: The lab for the schedule.
        :paramtype lab_name: str
        """
        super().__init__(**kwargs)
        self.skip_url = skip_url
        self.delay_url60 = delay_url60
        self.delay_url120 = delay_url120
        self.vm_name = vm_name
        self.guid = guid
        self.owner = owner
        self.vm_url = vm_url
        self.minutes_until_shutdown = minutes_until_shutdown
        self.event_type = event_type
        self.text = text
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.lab_name = lab_name


class Subnet(_serialization.Model):
    """Subnet information.

    :ivar resource_id: The resource ID of the subnet.
    :vartype resource_id: str
    :ivar lab_subnet_name: The name of the subnet as seen in the lab.
    :vartype lab_subnet_name: str
    :ivar allow_public_ip: The permission policy of the subnet for allowing public IP addresses
     (i.e. Allow, Deny)). Known values are: "Default", "Deny", and "Allow".
    :vartype allow_public_ip: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "lab_subnet_name": {"key": "labSubnetName", "type": "str"},
        "allow_public_ip": {"key": "allowPublicIp", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        allow_public_ip: Optional[Union[str, "_models.UsagePermissionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource ID of the subnet.
        :paramtype resource_id: str
        :keyword lab_subnet_name: The name of the subnet as seen in the lab.
        :paramtype lab_subnet_name: str
        :keyword allow_public_ip: The permission policy of the subnet for allowing public IP addresses
         (i.e. Allow, Deny)). Known values are: "Default", "Deny", and "Allow".
        :paramtype allow_public_ip: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.allow_public_ip = allow_public_ip


class SubnetOverride(_serialization.Model):
    """Property overrides on a subnet of a virtual network.

    :ivar resource_id: The resource ID of the subnet.
    :vartype resource_id: str
    :ivar lab_subnet_name: The name given to the subnet within the lab.
    :vartype lab_subnet_name: str
    :ivar use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual
     machine creation (i.e. Allow, Deny). Known values are: "Default", "Deny", and "Allow".
    :vartype use_in_vm_creation_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :ivar use_public_ip_address_permission: Indicates whether public IP addresses can be assigned
     to virtual machines on this subnet (i.e. Allow, Deny). Known values are: "Default", "Deny", and
     "Allow".
    :vartype use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :ivar shared_public_ip_address_configuration: Properties that virtual machines on this subnet
     will share.
    :vartype shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfiguration
    :ivar virtual_network_pool_name: The virtual network pool associated with this subnet.
    :vartype virtual_network_pool_name: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "lab_subnet_name": {"key": "labSubnetName", "type": "str"},
        "use_in_vm_creation_permission": {"key": "useInVmCreationPermission", "type": "str"},
        "use_public_ip_address_permission": {"key": "usePublicIpAddressPermission", "type": "str"},
        "shared_public_ip_address_configuration": {
            "key": "sharedPublicIpAddressConfiguration",
            "type": "SubnetSharedPublicIpAddressConfiguration",
        },
        "virtual_network_pool_name": {"key": "virtualNetworkPoolName", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        use_in_vm_creation_permission: Optional[Union[str, "_models.UsagePermissionType"]] = None,
        use_public_ip_address_permission: Optional[Union[str, "_models.UsagePermissionType"]] = None,
        shared_public_ip_address_configuration: Optional["_models.SubnetSharedPublicIpAddressConfiguration"] = None,
        virtual_network_pool_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource ID of the subnet.
        :paramtype resource_id: str
        :keyword lab_subnet_name: The name given to the subnet within the lab.
        :paramtype lab_subnet_name: str
        :keyword use_in_vm_creation_permission: Indicates whether this subnet can be used during
         virtual machine creation (i.e. Allow, Deny). Known values are: "Default", "Deny", and "Allow".
        :paramtype use_in_vm_creation_permission: str or
         ~azure.mgmt.devtestlabs.models.UsagePermissionType
        :keyword use_public_ip_address_permission: Indicates whether public IP addresses can be
         assigned to virtual machines on this subnet (i.e. Allow, Deny). Known values are: "Default",
         "Deny", and "Allow".
        :paramtype use_public_ip_address_permission: str or
         ~azure.mgmt.devtestlabs.models.UsagePermissionType
        :keyword shared_public_ip_address_configuration: Properties that virtual machines on this
         subnet will share.
        :paramtype shared_public_ip_address_configuration:
         ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfiguration
        :keyword virtual_network_pool_name: The virtual network pool associated with this subnet.
        :paramtype virtual_network_pool_name: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.use_in_vm_creation_permission = use_in_vm_creation_permission
        self.use_public_ip_address_permission = use_public_ip_address_permission
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration
        self.virtual_network_pool_name = virtual_network_pool_name


class SubnetSharedPublicIpAddressConfiguration(_serialization.Model):
    """Configuration for public IP address sharing.

    :ivar allowed_ports: Backend ports that virtual machines on this subnet are allowed to expose.
    :vartype allowed_ports: list[~azure.mgmt.devtestlabs.models.Port]
    """

    _attribute_map = {
        "allowed_ports": {"key": "allowedPorts", "type": "[Port]"},
    }

    def __init__(self, *, allowed_ports: Optional[List["_models.Port"]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_ports: Backend ports that virtual machines on this subnet are allowed to
         expose.
        :paramtype allowed_ports: list[~azure.mgmt.devtestlabs.models.Port]
        """
        super().__init__(**kwargs)
        self.allowed_ports = allowed_ports


class TargetCostProperties(_serialization.Model):
    """Properties of a cost target.

    :ivar status: Target cost status. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.devtestlabs.models.TargetCostStatus
    :ivar target: Lab target cost.
    :vartype target: int
    :ivar cost_thresholds: Cost thresholds.
    :vartype cost_thresholds: list[~azure.mgmt.devtestlabs.models.CostThresholdProperties]
    :ivar cycle_start_date_time: Reporting cycle start date.
    :vartype cycle_start_date_time: ~datetime.datetime
    :ivar cycle_end_date_time: Reporting cycle end date.
    :vartype cycle_end_date_time: ~datetime.datetime
    :ivar cycle_type: Reporting cycle type. Known values are: "CalendarMonth" and "Custom".
    :vartype cycle_type: str or ~azure.mgmt.devtestlabs.models.ReportingCycleType
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "target": {"key": "target", "type": "int"},
        "cost_thresholds": {"key": "costThresholds", "type": "[CostThresholdProperties]"},
        "cycle_start_date_time": {"key": "cycleStartDateTime", "type": "iso-8601"},
        "cycle_end_date_time": {"key": "cycleEndDateTime", "type": "iso-8601"},
        "cycle_type": {"key": "cycleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.TargetCostStatus"]] = None,
        target: Optional[int] = None,
        cost_thresholds: Optional[List["_models.CostThresholdProperties"]] = None,
        cycle_start_date_time: Optional[datetime.datetime] = None,
        cycle_end_date_time: Optional[datetime.datetime] = None,
        cycle_type: Optional[Union[str, "_models.ReportingCycleType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Target cost status. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.devtestlabs.models.TargetCostStatus
        :keyword target: Lab target cost.
        :paramtype target: int
        :keyword cost_thresholds: Cost thresholds.
        :paramtype cost_thresholds: list[~azure.mgmt.devtestlabs.models.CostThresholdProperties]
        :keyword cycle_start_date_time: Reporting cycle start date.
        :paramtype cycle_start_date_time: ~datetime.datetime
        :keyword cycle_end_date_time: Reporting cycle end date.
        :paramtype cycle_end_date_time: ~datetime.datetime
        :keyword cycle_type: Reporting cycle type. Known values are: "CalendarMonth" and "Custom".
        :paramtype cycle_type: str or ~azure.mgmt.devtestlabs.models.ReportingCycleType
        """
        super().__init__(**kwargs)
        self.status = status
        self.target = target
        self.cost_thresholds = cost_thresholds
        self.cycle_start_date_time = cycle_start_date_time
        self.cycle_end_date_time = cycle_end_date_time
        self.cycle_type = cycle_type


class User(Resource):
    """Profile of a lab user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the user.
    :vartype identity: ~azure.mgmt.devtestlabs.models.UserIdentity
    :ivar secret_store: The secret store of the user.
    :vartype secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStore
    :ivar created_date: The creation date of the user profile.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "properties.identity", "type": "UserIdentity"},
        "secret_store": {"key": "properties.secretStore", "type": "UserSecretStore"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.UserIdentity"] = None,
        secret_store: Optional["_models.UserSecretStore"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the user.
        :paramtype identity: ~azure.mgmt.devtestlabs.models.UserIdentity
        :keyword secret_store: The secret store of the user.
        :paramtype secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStore
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.secret_store = secret_store
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class UserFragment(UpdateResource):
    """Profile of a lab user.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class UserIdentity(_serialization.Model):
    """Identity attributes of a lab user.

    :ivar principal_name: Set to the principal name / UPN of the client JWT making the request.
    :vartype principal_name: str
    :ivar principal_id: Set to the principal Id of the client JWT making the request. Service
     principal will not have the principal Id.
    :vartype principal_id: str
    :ivar tenant_id: Set to the tenant ID of the client JWT making the request.
    :vartype tenant_id: str
    :ivar object_id: Set to the object Id of the client JWT making the request. Not all users have
     object Id. For CSP (reseller) scenarios for example, object Id is not available.
    :vartype object_id: str
    :ivar app_id: Set to the app Id of the client JWT making the request.
    :vartype app_id: str
    """

    _attribute_map = {
        "principal_name": {"key": "principalName", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "app_id": {"key": "appId", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_name: Optional[str] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        object_id: Optional[str] = None,
        app_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_name: Set to the principal name / UPN of the client JWT making the request.
        :paramtype principal_name: str
        :keyword principal_id: Set to the principal Id of the client JWT making the request. Service
         principal will not have the principal Id.
        :paramtype principal_id: str
        :keyword tenant_id: Set to the tenant ID of the client JWT making the request.
        :paramtype tenant_id: str
        :keyword object_id: Set to the object Id of the client JWT making the request. Not all users
         have object Id. For CSP (reseller) scenarios for example, object Id is not available.
        :paramtype object_id: str
        :keyword app_id: Set to the app Id of the client JWT making the request.
        :paramtype app_id: str
        """
        super().__init__(**kwargs)
        self.principal_name = principal_name
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.app_id = app_id


class UserList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.User]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[User]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.User"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.User]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserSecretStore(_serialization.Model):
    """Properties of a user's secret store.

    :ivar key_vault_uri: The URI of the user's Key vault.
    :vartype key_vault_uri: str
    :ivar key_vault_id: The ID of the user's Key vault.
    :vartype key_vault_id: str
    """

    _attribute_map = {
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
    }

    def __init__(
        self, *, key_vault_uri: Optional[str] = None, key_vault_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_uri: The URI of the user's Key vault.
        :paramtype key_vault_uri: str
        :keyword key_vault_id: The ID of the user's Key vault.
        :paramtype key_vault_id: str
        """
        super().__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_vault_id = key_vault_id


class VirtualNetwork(Resource):  # pylint: disable=too-many-instance-attributes
    """A virtual network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar allowed_subnets: The allowed subnets of the virtual network.
    :vartype allowed_subnets: list[~azure.mgmt.devtestlabs.models.Subnet]
    :ivar description: The description of the virtual network.
    :vartype description: str
    :ivar external_provider_resource_id: The Microsoft.Network resource identifier of the virtual
     network.
    :vartype external_provider_resource_id: str
    :ivar external_subnets: The external subnet properties.
    :vartype external_subnets: list[~azure.mgmt.devtestlabs.models.ExternalSubnet]
    :ivar subnet_overrides: The subnet overrides of the virtual network.
    :vartype subnet_overrides: list[~azure.mgmt.devtestlabs.models.SubnetOverride]
    :ivar created_date: The creation date of the virtual network.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "external_subnets": {"readonly": True},
        "created_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "unique_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "allowed_subnets": {"key": "properties.allowedSubnets", "type": "[Subnet]"},
        "description": {"key": "properties.description", "type": "str"},
        "external_provider_resource_id": {"key": "properties.externalProviderResourceId", "type": "str"},
        "external_subnets": {"key": "properties.externalSubnets", "type": "[ExternalSubnet]"},
        "subnet_overrides": {"key": "properties.subnetOverrides", "type": "[SubnetOverride]"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "unique_identifier": {"key": "properties.uniqueIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        allowed_subnets: Optional[List["_models.Subnet"]] = None,
        description: Optional[str] = None,
        external_provider_resource_id: Optional[str] = None,
        subnet_overrides: Optional[List["_models.SubnetOverride"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword allowed_subnets: The allowed subnets of the virtual network.
        :paramtype allowed_subnets: list[~azure.mgmt.devtestlabs.models.Subnet]
        :keyword description: The description of the virtual network.
        :paramtype description: str
        :keyword external_provider_resource_id: The Microsoft.Network resource identifier of the
         virtual network.
        :paramtype external_provider_resource_id: str
        :keyword subnet_overrides: The subnet overrides of the virtual network.
        :paramtype subnet_overrides: list[~azure.mgmt.devtestlabs.models.SubnetOverride]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.allowed_subnets = allowed_subnets
        self.description = description
        self.external_provider_resource_id = external_provider_resource_id
        self.external_subnets = None
        self.subnet_overrides = subnet_overrides
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class VirtualNetworkFragment(UpdateResource):
    """A virtual network.

    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """


class VirtualNetworkList(_serialization.Model):
    """The response of a list operation.

    :ivar value: Results of the list operation.
    :vartype value: list[~azure.mgmt.devtestlabs.models.VirtualNetwork]
    :ivar next_link: Link for next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list operation.
        :paramtype value: list[~azure.mgmt.devtestlabs.models.VirtualNetwork]
        :keyword next_link: Link for next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WeekDetails(_serialization.Model):
    """Properties of a weekly schedule.

    :ivar weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday,
     Tuesday, etc.).
    :vartype weekdays: list[str]
    :ivar time: The time of the day the schedule will occur.
    :vartype time: str
    """

    _attribute_map = {
        "weekdays": {"key": "weekdays", "type": "[str]"},
        "time": {"key": "time", "type": "str"},
    }

    def __init__(self, *, weekdays: Optional[List[str]] = None, time: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday,
         Tuesday, etc.).
        :paramtype weekdays: list[str]
        :keyword time: The time of the day the schedule will occur.
        :paramtype time: str
        """
        super().__init__(**kwargs)
        self.weekdays = weekdays
        self.time = time


class WindowsOsInfo(_serialization.Model):
    """Information about a Windows OS.

    :ivar windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested,
     SysprepApplied). Known values are: "NonSysprepped", "SysprepRequested", and "SysprepApplied".
    :vartype windows_os_state: str or ~azure.mgmt.devtestlabs.models.WindowsOsState
    """

    _attribute_map = {
        "windows_os_state": {"key": "windowsOsState", "type": "str"},
    }

    def __init__(
        self, *, windows_os_state: Optional[Union[str, "_models.WindowsOsState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested,
         SysprepApplied). Known values are: "NonSysprepped", "SysprepRequested", and "SysprepApplied".
        :paramtype windows_os_state: str or ~azure.mgmt.devtestlabs.models.WindowsOsState
        """
        super().__init__(**kwargs)
        self.windows_os_state = windows_os_state
