# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.planetarycomputer import PlanetaryComputerProClient
from devtools_testutils import AzureRecordedTestCase, EnvironmentVariableLoader
import functools


class PlanetaryComputerProClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint):
        credential = self.get_credential(PlanetaryComputerProClient)
        return self.create_client_from_credential(
            PlanetaryComputerProClient,
            credential=credential,
            endpoint=endpoint,
        )


PlanetaryComputerPreparer = functools.partial(
    EnvironmentVariableLoader,
    "planetarycomputer",
    planetarycomputer_endpoint="https://Sanitized.sanitized_label.sanitized_location.geocatalog.spatio.azure.com",
    planetarycomputer_collection_id="naip-atl",
    planetarycomputer_item_id="ga_m_3308421_se_16_060_20211114",
)
