# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import ManagedServicesClientConfiguration
from .operations import RegistrationDefinitionsOperations
from .operations import RegistrationAssignmentsOperations
from .operations import MarketplaceRegistrationDefinitionsOperations
from .operations import Operations
from . import models


class ManagedServicesClient(object):
    """Specification for ManagedServices.

    :ivar registration_definitions: RegistrationDefinitionsOperations operations
    :vartype registration_definitions: azure.mgmt.managedservices.operations.RegistrationDefinitionsOperations
    :ivar registration_assignments: RegistrationAssignmentsOperations operations
    :vartype registration_assignments: azure.mgmt.managedservices.operations.RegistrationAssignmentsOperations
    :ivar marketplace_registration_definitions: MarketplaceRegistrationDefinitionsOperations operations
    :vartype marketplace_registration_definitions: azure.mgmt.managedservices.operations.MarketplaceRegistrationDefinitionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.managedservices.operations.Operations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ManagedServicesClientConfiguration(credential, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.registration_definitions = RegistrationDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registration_assignments = RegistrationAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.marketplace_registration_definitions = MarketplaceRegistrationDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> ManagedServicesClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
