/*
 * Copyright (C) 2022-2024 by Cornelis Networks.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "rdma/opx/fi_opx_cq_ops_table.h"

/* HDRQ_MASK = runtime value (not 2047 or 8191, won't be optimal) */

/* WFR 9B headers */
/* CAPS =  FI_OPX_COMMS_NONE (runtime) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_WFR)

/* CAPS = FI_OPX_COMMS_LOCAL (only local) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR)

/* CAPS = FI_OPX_COMMS_REMOTE (only remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR)

/* CAPS = FI_OPX_COMMS_LOCAL_REMOTE (local and remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR)

/* JKR 9B */
/* CAPS =  FI_OPX_COMMS_NONE (runtime) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B)

/* CAPS = FI_OPX_COMMS_LOCAL (only local) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B)

/* CAPS = FI_OPX_COMMS_REMOTE (only remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B)

/* CAPS = FI_OPX_COMMS_LOCAL_REMOTE (local and remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B)

/* JKR 16B */
/* CAPS =  FI_OPX_COMMS_NONE (runtime) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_NONE, OPX_HFI1_JKR)

/* CAPS = FI_OPX_COMMS_LOCAL (only local) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR)

/* CAPS = FI_OPX_COMMS_REMOTE (only remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR)

/* CAPS = FI_OPX_COMMS_LOCAL_REMOTE (local and remote) */
/* ----- OFI_RELIABILITY_KIND_ONLOAD */
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_UNSPEC, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_CONTEXT, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_MSG, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_DATA, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR)
FI_OPX_CQ_SPECIALIZED_FUNC_NON_LOCKING(FI_CQ_FORMAT_TAGGED, OFI_RELIABILITY_KIND_ONLOAD, FI_OPX_HDRQ_MASK_RUNTIME,
				       FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR)

static struct fi_ops_cq fi_opx_cq_non_locking_runtime_ops_table[] = {
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_UNSPEC, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_CONTEXT, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_MSG, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_DATA, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_NONE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_REMOTE, OPX_HFI1_JKR),

	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_WFR),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR_9B),
	FI_OPX_CQ_OPS_STRUCT_INIT(FI_CQ_FORMAT_TAGGED, FI_OPX_LOCK_NOT_REQUIRED, OFI_RELIABILITY_KIND_ONLOAD,
				  FI_OPX_HDRQ_MASK_RUNTIME, FI_OPX_COMMS_LOCAL_REMOTE, OPX_HFI1_JKR),

};

ssize_t fi_opx_cq_read_FABRIC_DIRECT(struct fid_cq *cq, void *buf, size_t count)
{
	/* Non-inlined functions should just use the runtime HFI1 type check, no optimizations */
	if (OPX_HFI1_TYPE & OPX_HFI1_WFR) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_read, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_WFR)(cq, buf, count);
	} else if (OPX_HFI1_TYPE & OPX_HFI1_JKR_9B) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_read, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_JKR_9B)(cq, buf, count);
	} else if (OPX_HFI1_TYPE & OPX_HFI1_JKR) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_read, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_JKR)(cq, buf, count);
	} else {
		/* should never get here */
		FI_WARN(fi_opx_global.prov, FI_LOG_EP_DATA, "Fatal -FI_EPERM\n");
		abort();
	}
	return (ssize_t) -FI_EPERM;
}

ssize_t fi_opx_cq_readfrom_FABRIC_DIRECT(struct fid_cq *cq, void *buf, size_t count, fi_addr_t *src_addr)
{
	/* Non-inlined functions should just use the runtime HFI1 type check, no optimizations */
	if (OPX_HFI1_TYPE & OPX_HFI1_WFR) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_readfrom, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_WFR)(cq, buf, count, src_addr);
	} else if (OPX_HFI1_TYPE & OPX_HFI1_JKR_9B) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_readfrom, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_JKR_9B)(cq, buf, count, src_addr);
	} else if (OPX_HFI1_TYPE & OPX_HFI1_JKR) {
		return FI_OPX_CQ_SPECIALIZED_FUNC_NAME(cq_readfrom, OPX_CQ_FORMAT, OPX_LOCK, OPX_RELIABILITY, OPX_MASK,
						       OPX_CQ_CAPS, OPX_HFI1_JKR)(cq, buf, count, src_addr);
	} else {
		/* should never get here */
		FI_WARN(fi_opx_global.prov, FI_LOG_EP_DATA, "Fatal -FI_EPERM\n");
		abort();
	}
	return (ssize_t) -FI_EPERM;
}

static op_matrix_t *fi_opx_cq_non_locking_runtime_ops = (op_matrix_t *) &fi_opx_cq_non_locking_runtime_ops_table;

struct fi_ops_cq *fi_opx_cq_select_non_locking_runtime_ops(const enum fi_cq_format	   format,
							   const enum ofi_reliability_kind reliability,
							   const uint64_t comm_caps, const uint32_t hfi1_type)
{
	return &(*fi_opx_cq_non_locking_runtime_ops)[format][0][comm_caps][hfi1_type];
}
