/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.catalina.ha.deploy.FileMessage;
import org.apache.catalina.ha.deploy.FileMessageFactory;
import org.apache.catalina.ha.deploy.UndeployMessage;
import org.apache.catalina.ha.deploy.WarWatcher;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.util.ContextName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class FarmWarDeployer
extends ClusterListener
implements ClusterDeployer,
FileChangeListener {
    private static final Log log = LogFactory.getLog(FarmWarDeployer.class);
    private static final StringManager sm = StringManager.getManager(FarmWarDeployer.class);
    protected boolean started = false;
    protected final HashMap<String, FileMessageFactory> fileFactories = new HashMap();
    protected String deployDir;
    private File deployDirFile = null;
    protected String tempDir;
    private File tempDirFile = null;
    protected String watchDir;
    private File watchDirFile = null;
    protected boolean watchEnabled = false;
    protected WarWatcher watcher = null;
    private int count = 0;
    protected int processDeployFrequency = 2;
    protected File configBase = null;
    protected Host host = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected int maxValidTime = 300;

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        Container container = this.getCluster().getContainer();
        if (!(container instanceof Host)) {
            log.error((Object)sm.getString("farmWarDeployer.hostOnly"));
            return;
        }
        this.host = (Host)container;
        Container container2 = this.host.getParent();
        if (!(container2 instanceof Engine)) {
            log.error((Object)sm.getString("farmWarDeployer.hostParentEngine", new Object[]{this.host.getName()}));
            return;
        }
        Engine engine = (Engine)container2;
        String string = this.host.getName();
        try {
            this.oname = new ObjectName(engine.getName() + ":type=Deployer,host=" + string);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("farmWarDeployer.mbeanNameFail", new Object[]{engine.getName(), string}), (Throwable)exception);
            return;
        }
        if (this.watchEnabled) {
            this.watcher = new WarWatcher(this, this.getWatchDirFile());
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.watchDir", new Object[]{this.getWatchDir()}));
            }
        }
        this.configBase = this.host.getConfigBaseFile();
        this.mBeanServer = Registry.getRegistry(null).getMBeanServer();
        this.started = true;
        this.count = 0;
        this.getCluster().addClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("farmWarDeployer.started"));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        this.count = 0;
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher = null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("farmWarDeployer.stopped"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ClusterMessage clusterMessage) {
        block24: {
            try {
                if (clusterMessage instanceof FileMessage) {
                    FileMessageFactory fileMessageFactory;
                    FileMessage fileMessage = (FileMessage)clusterMessage;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("farmWarDeployer.msgRxDeploy", new Object[]{fileMessage.getContextName(), fileMessage.getFileName()}));
                    }
                    if (!(fileMessageFactory = this.getFactory(fileMessage)).writeMessage(fileMessage)) break block24;
                    String string = fileMessageFactory.getFile().getName();
                    if (!string.endsWith(".war")) {
                        string = string + ".war";
                    }
                    File file = new File(this.getDeployDirFile(), string);
                    try {
                        String string2 = fileMessage.getContextName();
                        if (this.tryAddServiced(string2)) {
                            try {
                                this.remove(string2);
                                if (!fileMessageFactory.getFile().renameTo(file)) {
                                    log.error((Object)sm.getString("farmWarDeployer.renameFail", new Object[]{fileMessageFactory.getFile(), file}));
                                }
                            }
                            finally {
                                this.removeServiced(string2);
                            }
                            this.check(string2);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)sm.getString("farmWarDeployer.deployEnd", new Object[]{string2}));
                            }
                            break block24;
                        }
                        log.error((Object)sm.getString("farmWarDeployer.servicingDeploy", new Object[]{string2, string}));
                        break block24;
                    }
                    catch (Exception exception) {
                        log.error((Object)sm.getString("farmWarDeployer.fileMessageError"), (Throwable)exception);
                        break block24;
                    }
                    finally {
                        this.removeFactory(fileMessage);
                    }
                }
                if (!(clusterMessage instanceof UndeployMessage)) break block24;
                try {
                    UndeployMessage undeployMessage = (UndeployMessage)clusterMessage;
                    String string = undeployMessage.getContextName();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("farmWarDeployer.msgRxUndeploy", new Object[]{string}));
                    }
                    if (this.tryAddServiced(string)) {
                        try {
                            this.remove(string);
                        }
                        finally {
                            this.removeServiced(string);
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)sm.getString("farmWarDeployer.undeployEnd", new Object[]{string}));
                        }
                        break block24;
                    }
                    log.error((Object)sm.getString("farmWarDeployer.servicingUndeploy", new Object[]{string}));
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("farmWarDeployer.undeployMessageError"), (Throwable)exception);
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("farmWarDeployer.msgIoe"), (Throwable)iOException);
            }
        }
    }

    public synchronized FileMessageFactory getFactory(FileMessage fileMessage) throws FileNotFoundException, IOException {
        File file = new File(this.getTempDirFile(), fileMessage.getFileName());
        FileMessageFactory fileMessageFactory = this.fileFactories.get(fileMessage.getFileName());
        if (fileMessageFactory == null) {
            fileMessageFactory = FileMessageFactory.getInstance(file, true);
            fileMessageFactory.setMaxValidTime(this.maxValidTime);
            this.fileFactories.put(fileMessage.getFileName(), fileMessageFactory);
        }
        return fileMessageFactory;
    }

    public void removeFactory(FileMessage fileMessage) {
        this.fileFactories.remove(fileMessage.getFileName());
    }

    @Override
    public boolean accept(ClusterMessage clusterMessage) {
        return clusterMessage instanceof FileMessage || clusterMessage instanceof UndeployMessage;
    }

    @Override
    public void install(String string, File file) throws IOException {
        Member[] memberArray = this.getCluster().getMembers();
        if (memberArray.length == 0) {
            return;
        }
        Member member = this.getCluster().getLocalMember();
        FileMessageFactory fileMessageFactory = FileMessageFactory.getInstance(file, false);
        FileMessage fileMessage = new FileMessage(member, file.getName(), string);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("farmWarDeployer.sendStart", new Object[]{string, file}));
        }
        fileMessage = fileMessageFactory.readMessage(fileMessage);
        while (fileMessage != null) {
            for (Member member2 : memberArray) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("farmWarDeployer.sendFragment", new Object[]{string, file, member2}));
                }
                this.getCluster().send(fileMessage, member2);
            }
            fileMessage = fileMessageFactory.readMessage(fileMessage);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("farmWarDeployer.sendEnd", new Object[]{string, file}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string, boolean bl) throws IOException {
        block11: {
            if (this.getCluster().getMembers().length > 0) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("farmWarDeployer.removeStart", new Object[]{string}));
                }
                Member member = this.getCluster().getLocalMember();
                UndeployMessage undeployMessage = new UndeployMessage(member, System.currentTimeMillis(), "Undeploy:" + string + ":" + System.currentTimeMillis(), string);
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("farmWarDeployer.removeTxMsg", new Object[]{string}));
                }
                this.cluster.send(undeployMessage);
            }
            if (bl) {
                try {
                    if (this.tryAddServiced(string)) {
                        try {
                            this.remove(string);
                        }
                        finally {
                            this.removeServiced(string);
                        }
                        this.check(string);
                        break block11;
                    }
                    log.error((Object)sm.getString("farmWarDeployer.removeFailRemote", new Object[]{string}));
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("farmWarDeployer.removeFailLocal", new Object[]{string}), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileModified(File file) {
        try {
            File file2 = new File(this.getDeployDirFile(), file.getName());
            ContextName contextName = new ContextName(file2.getName(), true);
            if (file2.exists() && file2.lastModified() > file.lastModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("farmWarDeployer.alreadyDeployed", new Object[]{contextName.getName()}));
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.modInstall", new Object[]{contextName.getName(), file2.getAbsolutePath()}));
            }
            if (this.tryAddServiced(contextName.getName())) {
                try {
                    this.copy(file, file2);
                }
                finally {
                    this.removeServiced(contextName.getName());
                }
                this.check(contextName.getName());
            } else {
                log.error((Object)sm.getString("farmWarDeployer.servicingDeploy", new Object[]{contextName.getName(), file2.getName()}));
            }
            this.install(contextName.getName(), file2);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("farmWarDeployer.modInstallFail"), (Throwable)exception);
        }
    }

    @Override
    public void fileRemoved(File file) {
        try {
            ContextName contextName = new ContextName(file.getName(), true);
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("farmWarDeployer.removeLocal", new Object[]{contextName.getName()}));
            }
            this.remove(contextName.getName(), true);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("farmWarDeployer.removeLocalFail"), (Throwable)exception);
        }
    }

    protected void remove(String string) throws Exception {
        Context context = (Context)this.host.findChild(string);
        if (context != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("farmWarDeployer.undeployLocal", new Object[]{string}));
            }
            context.stop();
            String string2 = context.getBaseName();
            File file = new File(this.host.getAppBaseFile(), string2 + ".war");
            File file2 = new File(this.host.getAppBaseFile(), string2);
            File file3 = new File(this.configBase, string2 + ".xml");
            if (file.exists()) {
                if (!file.delete()) {
                    log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{file}));
                }
            } else if (file2.exists()) {
                this.undeployDir(file2);
            } else if (!file3.delete()) {
                log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{file3}));
            }
        }
    }

    protected void undeployDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                this.undeployDir(file2);
                continue;
            }
            if (file2.delete()) continue;
            log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{file2}));
        }
        if (!file.delete()) {
            log.error((Object)sm.getString("farmWarDeployer.deleteFail", new Object[]{file}));
        }
    }

    @Override
    public void backgroundProcess() {
        if (this.started) {
            if (this.watchEnabled) {
                this.count = (this.count + 1) % this.processDeployFrequency;
                if (this.count == 0) {
                    this.watcher.check();
                }
            }
            this.removeInvalidFileFactories();
        }
    }

    protected void check(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", objectArray, stringArray);
    }

    @Deprecated
    protected boolean isServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", objectArray, stringArray);
        return bl;
    }

    @Deprecated
    protected void addServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", objectArray, stringArray);
    }

    protected boolean tryAddServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "tryAddServiced", objectArray, stringArray);
        return bl;
    }

    protected void removeServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", objectArray, stringArray);
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public File getDeployDirFile() {
        File file;
        if (this.deployDirFile != null) {
            return this.deployDirFile;
        }
        this.deployDirFile = file = this.getAbsolutePath(this.getDeployDir());
        return file;
    }

    public void setDeployDir(String string) {
        this.deployDir = string;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public File getTempDirFile() {
        File file;
        if (this.tempDirFile != null) {
            return this.tempDirFile;
        }
        this.tempDirFile = file = this.getAbsolutePath(this.getTempDir());
        return file;
    }

    public void setTempDir(String string) {
        this.tempDir = string;
    }

    public String getWatchDir() {
        return this.watchDir;
    }

    public File getWatchDirFile() {
        File file;
        if (this.watchDirFile != null) {
            return this.watchDirFile;
        }
        this.watchDirFile = file = this.getAbsolutePath(this.getWatchDir());
        return file;
    }

    public void setWatchDir(String string) {
        this.watchDir = string;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public boolean getWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean bl) {
        this.watchEnabled = bl;
    }

    public int getProcessDeployFrequency() {
        return this.processDeployFrequency;
    }

    public void setProcessDeployFrequency(int n) {
        if (n <= 0) {
            return;
        }
        this.processDeployFrequency = n;
    }

    public int getMaxValidTime() {
        return this.maxValidTime;
    }

    public void setMaxValidTime(int n) {
        this.maxValidTime = n;
    }

    protected boolean copy(File file, File file2) {
        try {
            if (!file2.exists() && !file2.createNewFile()) {
                log.error((Object)sm.getString("fileNewFail", new Object[]{file2}));
                return false;
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("farmWarDeployer.fileCopyFail", new Object[]{file, file2}), (Throwable)iOException);
            return false;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2, false);){
            int n;
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("farmWarDeployer.fileCopyFail", new Object[]{file, file2}), (Throwable)iOException);
            return false;
        }
        return true;
    }

    protected void removeInvalidFileFactories() {
        String[] stringArray;
        for (String string : stringArray = this.fileFactories.keySet().toArray(new String[0])) {
            FileMessageFactory fileMessageFactory = this.fileFactories.get(string);
            if (fileMessageFactory.isValid()) continue;
            this.fileFactories.remove(string);
        }
    }

    private File getAbsolutePath(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getCluster().getContainer().getCatalinaBase(), file.getPath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }
}

