from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

WELSH_LANG_MODEL = {
    23: {  # 'A'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.POSITIVE,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.POSITIVE,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    26: {  # 'B'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.POSITIVE,  # 'B'
        21: SequenceLikelihood.POSITIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    21: {  # 'C'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.POSITIVE,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    24: {  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.POSITIVE,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.POSITIVE,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.UNLIKELY,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    31: {  # 'E'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.POSITIVE,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.POSITIVE,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    37: {  # 'F'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    25: {  # 'G'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.UNLIKELY,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    39: {  # 'H'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.UNLIKELY,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    36: {  # 'I'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.POSITIVE,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    45: {  # 'J'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    48: {  # 'K'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    32: {  # 'L'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.POSITIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.UNLIKELY,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    22: {  # 'M'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.UNLIKELY,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    34: {  # 'N'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.UNLIKELY,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    38: {  # 'O'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    28: {  # 'P'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    57: {  # 'Q'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    29: {  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.UNLIKELY,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    27: {  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    33: {  # 'T'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.POSITIVE,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        47: SequenceLikelihood.LIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.LIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.LIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.UNLIKELY,  # 'Ŷ'
        55: SequenceLikelihood.LIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    42: {  # 'U'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    47: {  # 'V'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    40: {  # 'W'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.POSITIVE,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    58: {  # 'X'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    30: {  # 'Y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.POSITIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.LIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        22: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.LIKELY,  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.LIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    60: {  # 'Z'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    1: {  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.POSITIVE,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    19: {  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.LIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    17: {  # 'c'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    2: {  # 'd'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.LIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.POSITIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.LIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    5: {  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.POSITIVE,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.POSITIVE,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    13: {  # 'f'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.UNLIKELY,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    12: {  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.LIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.LIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    11: {  # 'h'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.LIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.LIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    6: {  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        28: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.POSITIVE,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.UNLIKELY,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    51: {  # 'j'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    44: {  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    9: {  # 'l'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.UNLIKELY,  # 'Ŷ'
        55: SequenceLikelihood.LIKELY,  # 'ŷ'
        93: SequenceLikelihood.UNLIKELY,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.UNLIKELY,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    18: {  # 'm'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.UNLIKELY,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    4: {  # 'n'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.UNLIKELY,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.POSITIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    8: {  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.POSITIVE,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    20: {  # 'p'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.LIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    59: {  # 'q'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    7: {  # 'r'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.UNLIKELY,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.LIKELY,  # 'ê'
        62: SequenceLikelihood.LIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ŵ'
        46: SequenceLikelihood.POSITIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.UNLIKELY,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    15: {  # 's'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.UNLIKELY,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.LIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.LIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.LIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.UNLIKELY,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    14: {  # 't'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.LIKELY,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.POSITIVE,  # 'á'
        35: SequenceLikelihood.POSITIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.POSITIVE,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.LIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.LIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.UNLIKELY,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    16: {  # 'u'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.UNLIKELY,  # 'ỳ'
    },
    41: {  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.LIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    10: {  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.LIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.UNLIKELY,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.LIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.UNLIKELY,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.UNLIKELY,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    49: {  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    3: {  # 'y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        2: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        13: SequenceLikelihood.POSITIVE,  # 'f'
        12: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.POSITIVE,  # 's'
        14: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.UNLIKELY,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.UNLIKELY,  # 'Ú'
        89: SequenceLikelihood.UNLIKELY,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.UNLIKELY,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    50: {  # 'z'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.UNLIKELY,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.UNLIKELY,  # 'ó'
        43: SequenceLikelihood.UNLIKELY,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    82: {  # 'Á'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    72: {  # 'Â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.UNLIKELY,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    87: {  # 'Ä'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    75: {  # 'É'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.UNLIKELY,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    80: {  # 'Ê'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    90: {  # 'Ë'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    83: {  # 'Í'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    81: {  # 'Î'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    78: {  # 'Ï'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    77: {  # 'Ó'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    65: {  # 'Ô'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    79: {  # 'Ö'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.UNLIKELY,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    86: {  # 'Ú'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    89: {  # 'Û'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    76: {  # 'Ü'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.UNLIKELY,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    91: {  # 'Ý'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    56: {  # 'á'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    35: {  # 'â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.LIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.UNLIKELY,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    70: {  # 'ä'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.UNLIKELY,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.UNLIKELY,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    61: {  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.UNLIKELY,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    53: {  # 'ê'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    62: {  # 'ë'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    63: {  # 'í'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.UNLIKELY,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.UNLIKELY,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    54: {  # 'î'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        18: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    52: {  # 'ï'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    67: {  # 'ó'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    43: {  # 'ô'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    64: {  # 'ö'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.UNLIKELY,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.UNLIKELY,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    73: {  # 'ú'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    68: {  # 'û'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.UNLIKELY,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    69: {  # 'ü'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.UNLIKELY,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.UNLIKELY,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.UNLIKELY,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    74: {  # 'ý'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.UNLIKELY,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    71: {  # 'ÿ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    66: {  # 'Ŵ'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.UNLIKELY,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    46: {  # 'ŵ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.POSITIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.UNLIKELY,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    85: {  # 'Ŷ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    55: {  # 'ŷ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.UNLIKELY,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    93: {  # 'Ÿ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    94: {  # 'ẁ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    88: {  # 'ẃ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.UNLIKELY,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    92: {  # 'ẅ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    95: {  # 'Ỳ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.NEGATIVE,  # 'f'
        12: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        18: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        15: SequenceLikelihood.NEGATIVE,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
    84: {  # 'ỳ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        21: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        37: SequenceLikelihood.NEGATIVE,  # 'F'
        25: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        48: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        22: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        28: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        29: SequenceLikelihood.NEGATIVE,  # 'R'
        27: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        47: SequenceLikelihood.NEGATIVE,  # 'V'
        40: SequenceLikelihood.NEGATIVE,  # 'W'
        58: SequenceLikelihood.NEGATIVE,  # 'X'
        30: SequenceLikelihood.NEGATIVE,  # 'Y'
        60: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        2: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        13: SequenceLikelihood.UNLIKELY,  # 'f'
        12: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        51: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        18: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        20: SequenceLikelihood.NEGATIVE,  # 'p'
        59: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        15: SequenceLikelihood.UNLIKELY,  # 's'
        14: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        41: SequenceLikelihood.NEGATIVE,  # 'v'
        10: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        3: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        82: SequenceLikelihood.NEGATIVE,  # 'Á'
        72: SequenceLikelihood.NEGATIVE,  # 'Â'
        87: SequenceLikelihood.NEGATIVE,  # 'Ä'
        75: SequenceLikelihood.NEGATIVE,  # 'É'
        80: SequenceLikelihood.NEGATIVE,  # 'Ê'
        90: SequenceLikelihood.NEGATIVE,  # 'Ë'
        83: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Î'
        78: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ó'
        65: SequenceLikelihood.NEGATIVE,  # 'Ô'
        79: SequenceLikelihood.NEGATIVE,  # 'Ö'
        86: SequenceLikelihood.NEGATIVE,  # 'Ú'
        89: SequenceLikelihood.NEGATIVE,  # 'Û'
        76: SequenceLikelihood.NEGATIVE,  # 'Ü'
        91: SequenceLikelihood.NEGATIVE,  # 'Ý'
        56: SequenceLikelihood.NEGATIVE,  # 'á'
        35: SequenceLikelihood.NEGATIVE,  # 'â'
        70: SequenceLikelihood.NEGATIVE,  # 'ä'
        61: SequenceLikelihood.NEGATIVE,  # 'é'
        53: SequenceLikelihood.NEGATIVE,  # 'ê'
        62: SequenceLikelihood.NEGATIVE,  # 'ë'
        63: SequenceLikelihood.NEGATIVE,  # 'í'
        54: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        67: SequenceLikelihood.NEGATIVE,  # 'ó'
        43: SequenceLikelihood.NEGATIVE,  # 'ô'
        64: SequenceLikelihood.NEGATIVE,  # 'ö'
        73: SequenceLikelihood.NEGATIVE,  # 'ú'
        68: SequenceLikelihood.NEGATIVE,  # 'û'
        69: SequenceLikelihood.NEGATIVE,  # 'ü'
        74: SequenceLikelihood.NEGATIVE,  # 'ý'
        71: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ŵ'
        46: SequenceLikelihood.NEGATIVE,  # 'ŵ'
        85: SequenceLikelihood.NEGATIVE,  # 'Ŷ'
        55: SequenceLikelihood.NEGATIVE,  # 'ŷ'
        93: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
        94: SequenceLikelihood.NEGATIVE,  # 'ẁ'
        88: SequenceLikelihood.NEGATIVE,  # 'ẃ'
        92: SequenceLikelihood.NEGATIVE,  # 'ẅ'
        95: SequenceLikelihood.NEGATIVE,  # 'Ỳ'
        84: SequenceLikelihood.NEGATIVE,  # 'ỳ'
    },
}

# Character Mapping Table(s):
CP037_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 35,  # 'â'
    67: 70,  # 'ä'
    68: 0,  # 'à'
    69: 56,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 61,  # 'é'
    82: 53,  # 'ê'
    83: 62,  # 'ë'
    84: 0,  # 'è'
    85: 63,  # 'í'
    86: 54,  # 'î'
    87: 52,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 72,  # 'Â'
    99: 87,  # 'Ä'
    100: 0,  # 'À'
    101: 82,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 75,  # 'É'
    114: 80,  # 'Ê'
    115: 90,  # 'Ë'
    116: 0,  # 'È'
    117: 83,  # 'Í'
    118: 81,  # 'Î'
    119: 78,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 19,  # 'b'
    131: 17,  # 'c'
    132: 2,  # 'd'
    133: 5,  # 'e'
    134: 13,  # 'f'
    135: 12,  # 'g'
    136: 11,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 74,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 51,  # 'j'
    146: 44,  # 'k'
    147: 9,  # 'l'
    148: 18,  # 'm'
    149: 4,  # 'n'
    150: 8,  # 'o'
    151: 20,  # 'p'
    152: 59,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 15,  # 's'
    163: 14,  # 't'
    164: 16,  # 'u'
    165: 41,  # 'v'
    166: 10,  # 'w'
    167: 49,  # 'x'
    168: 3,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 91,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 26,  # 'B'
    195: 21,  # 'C'
    196: 24,  # 'D'
    197: 31,  # 'E'
    198: 37,  # 'F'
    199: 25,  # 'G'
    200: 39,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 43,  # 'ô'
    204: 64,  # 'ö'
    205: 0,  # 'ò'
    206: 67,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 45,  # 'J'
    210: 48,  # 'K'
    211: 32,  # 'L'
    212: 22,  # 'M'
    213: 34,  # 'N'
    214: 38,  # 'O'
    215: 28,  # 'P'
    216: 57,  # 'Q'
    217: 29,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 68,  # 'û'
    220: 69,  # 'ü'
    221: 0,  # 'ù'
    222: 73,  # 'ú'
    223: 71,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 27,  # 'S'
    227: 33,  # 'T'
    228: 42,  # 'U'
    229: 47,  # 'V'
    230: 40,  # 'W'
    231: 58,  # 'X'
    232: 30,  # 'Y'
    233: 60,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 65,  # 'Ô'
    236: 79,  # 'Ö'
    237: 0,  # 'Ò'
    238: 77,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 89,  # 'Û'
    252: 76,  # 'Ü'
    253: 0,  # 'Ù'
    254: 86,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Welsh",
    char_to_order_map=CP037_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729802322201,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

CP437_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 69,  # 'ü'
    130: 61,  # 'é'
    131: 35,  # 'â'
    132: 70,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 53,  # 'ê'
    137: 62,  # 'ë'
    138: 0,  # 'è'
    139: 52,  # 'ï'
    140: 54,  # 'î'
    141: 0,  # 'ì'
    142: 87,  # 'Ä'
    143: 0,  # 'Å'
    144: 75,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 43,  # 'ô'
    148: 64,  # 'ö'
    149: 0,  # 'ò'
    150: 68,  # 'û'
    151: 0,  # 'ù'
    152: 71,  # 'ÿ'
    153: 79,  # 'Ö'
    154: 76,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 56,  # 'á'
    161: 63,  # 'í'
    162: 67,  # 'ó'
    163: 73,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Welsh",
    char_to_order_map=CP437_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828942596661385,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

CP500_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 35,  # 'â'
    67: 70,  # 'ä'
    68: 0,  # 'à'
    69: 56,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 61,  # 'é'
    82: 53,  # 'ê'
    83: 62,  # 'ë'
    84: 0,  # 'è'
    85: 63,  # 'í'
    86: 54,  # 'î'
    87: 52,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 72,  # 'Â'
    99: 87,  # 'Ä'
    100: 0,  # 'À'
    101: 82,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 75,  # 'É'
    114: 80,  # 'Ê'
    115: 90,  # 'Ë'
    116: 0,  # 'È'
    117: 83,  # 'Í'
    118: 81,  # 'Î'
    119: 78,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 19,  # 'b'
    131: 17,  # 'c'
    132: 2,  # 'd'
    133: 5,  # 'e'
    134: 13,  # 'f'
    135: 12,  # 'g'
    136: 11,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 74,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 51,  # 'j'
    146: 44,  # 'k'
    147: 9,  # 'l'
    148: 18,  # 'm'
    149: 4,  # 'n'
    150: 8,  # 'o'
    151: 20,  # 'p'
    152: 59,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 15,  # 's'
    163: 14,  # 't'
    164: 16,  # 'u'
    165: 41,  # 'v'
    166: 10,  # 'w'
    167: 49,  # 'x'
    168: 3,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 91,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 26,  # 'B'
    195: 21,  # 'C'
    196: 24,  # 'D'
    197: 31,  # 'E'
    198: 37,  # 'F'
    199: 25,  # 'G'
    200: 39,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 43,  # 'ô'
    204: 64,  # 'ö'
    205: 0,  # 'ò'
    206: 67,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 45,  # 'J'
    210: 48,  # 'K'
    211: 32,  # 'L'
    212: 22,  # 'M'
    213: 34,  # 'N'
    214: 38,  # 'O'
    215: 28,  # 'P'
    216: 57,  # 'Q'
    217: 29,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 68,  # 'û'
    220: 69,  # 'ü'
    221: 0,  # 'ù'
    222: 73,  # 'ú'
    223: 71,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 27,  # 'S'
    227: 33,  # 'T'
    228: 42,  # 'U'
    229: 47,  # 'V'
    230: 40,  # 'W'
    231: 58,  # 'X'
    232: 30,  # 'Y'
    233: 60,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 65,  # 'Ô'
    236: 79,  # 'Ö'
    237: 0,  # 'Ò'
    238: 77,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 89,  # 'Û'
    252: 76,  # 'Ü'
    253: 0,  # 'Ù'
    254: 86,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Welsh",
    char_to_order_map=CP500_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729802322201,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

CP850_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 69,  # 'ü'
    130: 61,  # 'é'
    131: 35,  # 'â'
    132: 70,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 53,  # 'ê'
    137: 62,  # 'ë'
    138: 0,  # 'è'
    139: 52,  # 'ï'
    140: 54,  # 'î'
    141: 0,  # 'ì'
    142: 87,  # 'Ä'
    143: 0,  # 'Å'
    144: 75,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 43,  # 'ô'
    148: 64,  # 'ö'
    149: 0,  # 'ò'
    150: 68,  # 'û'
    151: 0,  # 'ù'
    152: 71,  # 'ÿ'
    153: 79,  # 'Ö'
    154: 76,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 56,  # 'á'
    161: 63,  # 'í'
    162: 67,  # 'ó'
    163: 73,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 82,  # 'Á'
    182: 72,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 80,  # 'Ê'
    211: 90,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 83,  # 'Í'
    215: 81,  # 'Î'
    216: 78,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 77,  # 'Ó'
    225: 0,  # 'ß'
    226: 65,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 86,  # 'Ú'
    234: 89,  # 'Û'
    235: 0,  # 'Ù'
    236: 74,  # 'ý'
    237: 91,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Welsh",
    char_to_order_map=CP850_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729802322201,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

CP858_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 69,  # 'ü'
    130: 61,  # 'é'
    131: 35,  # 'â'
    132: 70,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 53,  # 'ê'
    137: 62,  # 'ë'
    138: 0,  # 'è'
    139: 52,  # 'ï'
    140: 54,  # 'î'
    141: 0,  # 'ì'
    142: 87,  # 'Ä'
    143: 0,  # 'Å'
    144: 75,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 43,  # 'ô'
    148: 64,  # 'ö'
    149: 0,  # 'ò'
    150: 68,  # 'û'
    151: 0,  # 'ù'
    152: 71,  # 'ÿ'
    153: 79,  # 'Ö'
    154: 76,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 56,  # 'á'
    161: 63,  # 'í'
    162: 67,  # 'ó'
    163: 73,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 82,  # 'Á'
    182: 72,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 80,  # 'Ê'
    211: 90,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 83,  # 'Í'
    215: 81,  # 'Î'
    216: 78,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 77,  # 'Ó'
    225: 0,  # 'ß'
    226: 65,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 86,  # 'Ú'
    234: 89,  # 'Û'
    235: 0,  # 'Ù'
    236: 74,  # 'ý'
    237: 91,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Welsh",
    char_to_order_map=CP858_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729802322201,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

ISO_8859_1_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 82,  # 'Á'
    194: 72,  # 'Â'
    195: 0,  # 'Ã'
    196: 87,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 75,  # 'É'
    202: 80,  # 'Ê'
    203: 90,  # 'Ë'
    204: 0,  # 'Ì'
    205: 83,  # 'Í'
    206: 81,  # 'Î'
    207: 78,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 77,  # 'Ó'
    212: 65,  # 'Ô'
    213: 0,  # 'Õ'
    214: 79,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 86,  # 'Ú'
    219: 89,  # 'Û'
    220: 76,  # 'Ü'
    221: 91,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 56,  # 'á'
    226: 35,  # 'â'
    227: 0,  # 'ã'
    228: 70,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 61,  # 'é'
    234: 53,  # 'ê'
    235: 62,  # 'ë'
    236: 0,  # 'ì'
    237: 63,  # 'í'
    238: 54,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 67,  # 'ó'
    244: 43,  # 'ô'
    245: 0,  # 'õ'
    246: 64,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 73,  # 'ú'
    251: 68,  # 'û'
    252: 69,  # 'ü'
    253: 74,  # 'ý'
    254: 0,  # 'þ'
    255: 71,  # 'ÿ'
}

ISO_8859_1_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Welsh",
    char_to_order_map=ISO_8859_1_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729802322201,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

ISO_8859_14_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ḃ'
    162: 0,  # 'ḃ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: 0,  # 'Ċ'
    165: 0,  # 'ċ'
    166: 0,  # 'Ḋ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ẁ'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ẃ'
    171: 0,  # 'ḋ'
    172: 95,  # 'Ỳ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 93,  # 'Ÿ'
    176: 0,  # 'Ḟ'
    177: 0,  # 'ḟ'
    178: 0,  # 'Ġ'
    179: 0,  # 'ġ'
    180: 0,  # 'Ṁ'
    181: 0,  # 'ṁ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: 0,  # 'Ṗ'
    184: 94,  # 'ẁ'
    185: 0,  # 'ṗ'
    186: 88,  # 'ẃ'
    187: 0,  # 'Ṡ'
    188: 84,  # 'ỳ'
    189: 0,  # 'Ẅ'
    190: 92,  # 'ẅ'
    191: 0,  # 'ṡ'
    192: 0,  # 'À'
    193: 82,  # 'Á'
    194: 72,  # 'Â'
    195: 0,  # 'Ã'
    196: 87,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 75,  # 'É'
    202: 80,  # 'Ê'
    203: 90,  # 'Ë'
    204: 0,  # 'Ì'
    205: 83,  # 'Í'
    206: 81,  # 'Î'
    207: 78,  # 'Ï'
    208: 66,  # 'Ŵ'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 77,  # 'Ó'
    212: 65,  # 'Ô'
    213: 0,  # 'Õ'
    214: 79,  # 'Ö'
    215: 0,  # 'Ṫ'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 86,  # 'Ú'
    219: 89,  # 'Û'
    220: 76,  # 'Ü'
    221: 91,  # 'Ý'
    222: 85,  # 'Ŷ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 56,  # 'á'
    226: 35,  # 'â'
    227: 0,  # 'ã'
    228: 70,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 61,  # 'é'
    234: 53,  # 'ê'
    235: 62,  # 'ë'
    236: 0,  # 'ì'
    237: 63,  # 'í'
    238: 54,  # 'î'
    239: 52,  # 'ï'
    240: 46,  # 'ŵ'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 67,  # 'ó'
    244: 43,  # 'ô'
    245: 0,  # 'õ'
    246: 64,  # 'ö'
    247: 0,  # 'ṫ'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 73,  # 'ú'
    251: 68,  # 'û'
    252: 69,  # 'ü'
    253: 74,  # 'ý'
    254: 55,  # 'ŷ'
    255: 71,  # 'ÿ'
}

ISO_8859_14_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-14",
    language="Welsh",
    char_to_order_map=ISO_8859_14_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9823474676057814,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

ISO_8859_15_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 93,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 82,  # 'Á'
    194: 72,  # 'Â'
    195: 0,  # 'Ã'
    196: 87,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 75,  # 'É'
    202: 80,  # 'Ê'
    203: 90,  # 'Ë'
    204: 0,  # 'Ì'
    205: 83,  # 'Í'
    206: 81,  # 'Î'
    207: 78,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 77,  # 'Ó'
    212: 65,  # 'Ô'
    213: 0,  # 'Õ'
    214: 79,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 86,  # 'Ú'
    219: 89,  # 'Û'
    220: 76,  # 'Ü'
    221: 91,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 56,  # 'á'
    226: 35,  # 'â'
    227: 0,  # 'ã'
    228: 70,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 61,  # 'é'
    234: 53,  # 'ê'
    235: 62,  # 'ë'
    236: 0,  # 'ì'
    237: 63,  # 'í'
    238: 54,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 67,  # 'ó'
    244: 43,  # 'ô'
    245: 0,  # 'õ'
    246: 64,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 73,  # 'ú'
    251: 68,  # 'û'
    252: 69,  # 'ü'
    253: 74,  # 'ý'
    254: 0,  # 'þ'
    255: 71,  # 'ÿ'
}

ISO_8859_15_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Welsh",
    char_to_order_map=ISO_8859_15_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729320776439,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

MACROMAN_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 87,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 75,  # 'É'
    132: 0,  # 'Ñ'
    133: 79,  # 'Ö'
    134: 76,  # 'Ü'
    135: 56,  # 'á'
    136: 0,  # 'à'
    137: 35,  # 'â'
    138: 70,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 61,  # 'é'
    143: 0,  # 'è'
    144: 53,  # 'ê'
    145: 62,  # 'ë'
    146: 63,  # 'í'
    147: 0,  # 'ì'
    148: 54,  # 'î'
    149: 52,  # 'ï'
    150: 0,  # 'ñ'
    151: 67,  # 'ó'
    152: 0,  # 'ò'
    153: 43,  # 'ô'
    154: 64,  # 'ö'
    155: 0,  # 'õ'
    156: 73,  # 'ú'
    157: 0,  # 'ù'
    158: 68,  # 'û'
    159: 69,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 71,  # 'ÿ'
    217: 93,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 72,  # 'Â'
    230: 80,  # 'Ê'
    231: 82,  # 'Á'
    232: 90,  # 'Ë'
    233: 0,  # 'È'
    234: 83,  # 'Í'
    235: 81,  # 'Î'
    236: 78,  # 'Ï'
    237: 0,  # 'Ì'
    238: 77,  # 'Ó'
    239: 65,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 86,  # 'Ú'
    243: 89,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Welsh",
    char_to_order_map=MACROMAN_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828749064191381,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)

WINDOWS_1252_WELSH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 21,  # 'C'
    68: 24,  # 'D'
    69: 31,  # 'E'
    70: 37,  # 'F'
    71: 25,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 48,  # 'K'
    76: 32,  # 'L'
    77: 22,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 28,  # 'P'
    81: 57,  # 'Q'
    82: 29,  # 'R'
    83: 27,  # 'S'
    84: 33,  # 'T'
    85: 42,  # 'U'
    86: 47,  # 'V'
    87: 40,  # 'W'
    88: 58,  # 'X'
    89: 30,  # 'Y'
    90: 60,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 19,  # 'b'
    99: 17,  # 'c'
    100: 2,  # 'd'
    101: 5,  # 'e'
    102: 13,  # 'f'
    103: 12,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 51,  # 'j'
    107: 44,  # 'k'
    108: 9,  # 'l'
    109: 18,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 20,  # 'p'
    113: 59,  # 'q'
    114: 7,  # 'r'
    115: 15,  # 's'
    116: 14,  # 't'
    117: 16,  # 'u'
    118: 41,  # 'v'
    119: 10,  # 'w'
    120: 49,  # 'x'
    121: 3,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 93,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 82,  # 'Á'
    194: 72,  # 'Â'
    195: 0,  # 'Ã'
    196: 87,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 75,  # 'É'
    202: 80,  # 'Ê'
    203: 90,  # 'Ë'
    204: 0,  # 'Ì'
    205: 83,  # 'Í'
    206: 81,  # 'Î'
    207: 78,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 77,  # 'Ó'
    212: 65,  # 'Ô'
    213: 0,  # 'Õ'
    214: 79,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 86,  # 'Ú'
    219: 89,  # 'Û'
    220: 76,  # 'Ü'
    221: 91,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 56,  # 'á'
    226: 35,  # 'â'
    227: 0,  # 'ã'
    228: 70,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 61,  # 'é'
    234: 53,  # 'ê'
    235: 62,  # 'ë'
    236: 0,  # 'ì'
    237: 63,  # 'í'
    238: 54,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 67,  # 'ó'
    244: 43,  # 'ô'
    245: 0,  # 'õ'
    246: 64,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 73,  # 'ú'
    251: 68,  # 'û'
    252: 69,  # 'ü'
    253: 74,  # 'ý'
    254: 0,  # 'þ'
    255: 71,  # 'ÿ'
}

WINDOWS_1252_WELSH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Welsh",
    char_to_order_map=WINDOWS_1252_WELSH_CHAR_TO_ORDER,
    language_model=WELSH_LANG_MODEL,
    typical_positive_ratio=0.9828729320776439,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÂÄÉÊËÍÎÏÓÔÖÚÛÜÝáâäéêëíîïóôöúûüýÿŴŵŶŷŸẁẃẅỲỳ",
)
