from chardet.sbcharsetprober import SingleByteCharSetModel

# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

ARABIC_LANG_MODEL = {
    34: {  # 'ء'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 2,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 0,  # 'ج'
        19: 0,  # 'ح'
        26: 0,  # 'خ'
        12: 0,  # 'د'
        30: 0,  # 'ذ'
        7: 0,  # 'ر'
        27: 0,  # 'ز'
        13: 0,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 0,  # 'ف'
        16: 0,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    40: {  # 'آ'
        34: 1,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 2,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 1,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 1,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 0,  # 'ِ'
        37: 0,  # 'ّ'
    },
    18: {  # 'أ'
        34: 1,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 3,  # 'ب'
        10: 2,  # 'ة'
        8: 2,  # 'ت'
        28: 2,  # 'ث'
        20: 2,  # 'ج'
        19: 3,  # 'ح'
        26: 3,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 3,  # 'س'
        21: 2,  # 'ش'
        23: 3,  # 'ص'
        29: 1,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    41: {  # 'ؤ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 1,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 0,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    24: {  # 'إ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 2,  # 'ب'
        10: 0,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 2,  # 'ح'
        26: 2,  # 'خ'
        12: 2,  # 'د'
        30: 2,  # 'ذ'
        7: 2,  # 'ر'
        27: 1,  # 'ز'
        13: 3,  # 'س'
        21: 2,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 2,  # 'م'
        6: 3,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 2,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 0,  # 'َ'
        36: 0,  # 'ُ'
        39: 1,  # 'ِ'
        37: 0,  # 'ّ'
    },
    32: {  # 'ئ'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 2,  # 'ا'
        9: 2,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 2,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 2,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 0,  # 'ّ'
    },
    1: {  # 'ا'
        34: 3,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 3,  # 'ئ'
        1: 1,  # 'ا'
        9: 3,  # 'ب'
        10: 2,  # 'ة'
        8: 3,  # 'ت'
        28: 3,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 3,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 3,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 3,  # 'ص'
        29: 3,  # 'ض'
        22: 3,  # 'ط'
        38: 2,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 3,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    9: {  # 'ب'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 2,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 3,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 2,  # 'ش'
        23: 2,  # 'ص'
        29: 1,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 3,  # 'ق'
        17: 2,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 2,  # 'ِ'
        37: 1,  # 'ّ'
    },
    10: {  # 'ة'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 1,  # 'إ'
        32: 0,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 0,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 0,  # 'خ'
        12: 1,  # 'د'
        30: 0,  # 'ذ'
        7: 1,  # 'ر'
        27: 0,  # 'ز'
        13: 1,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 0,  # 'ى'
        3: 1,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    8: {  # 'ت'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 2,  # 'ة'
        8: 3,  # 'ت'
        28: 2,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 3,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 3,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 2,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    28: {  # 'ث'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 3,  # 'ا'
        9: 1,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 0,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 2,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    20: {  # 'ج'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 2,  # 'ة'
        8: 2,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 3,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    19: {  # 'ح'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 2,  # 'ث'
        20: 2,  # 'ج'
        19: 1,  # 'ح'
        26: 0,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 2,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 2,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    26: {  # 'خ'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 1,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 0,  # 'ح'
        26: 1,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    12: {  # 'د'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 3,  # 'ة'
        8: 2,  # 'ت'
        28: 2,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 2,  # 'ّ'
    },
    30: {  # 'ذ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 0,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 0,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 2,  # 'ك'
        2: 3,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 3,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    7: {  # 'ر'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 3,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 2,  # 'ث'
        20: 3,  # 'ج'
        19: 2,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 2,  # 'ز'
        13: 3,  # 'س'
        21: 2,  # 'ش'
        23: 2,  # 'ص'
        29: 3,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 2,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 2,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 3,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    27: {  # 'ز'
        34: 2,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 2,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    13: {  # 'س'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 2,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 2,  # 'ح'
        26: 2,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 3,  # 'ط'
        38: 0,  # 'ظ'
        11: 3,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    21: {  # 'ش'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 1,  # 'ة'
        8: 2,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 1,  # 'ح'
        26: 2,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 3,  # 'ك'
        2: 2,  # 'ل'
        4: 3,  # 'م'
        6: 2,  # 'ن'
        15: 2,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    23: {  # 'ص'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 2,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 0,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 0,  # 'س'
        21: 0,  # 'ش'
        23: 2,  # 'ص'
        29: 0,  # 'ض'
        22: 2,  # 'ط'
        38: 0,  # 'ظ'
        11: 2,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    29: {  # 'ض'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 2,  # 'ة'
        8: 2,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 2,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 0,  # 'ز'
        13: 0,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 2,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    22: {  # 'ط'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 0,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 0,  # 'ض'
        22: 1,  # 'ط'
        38: 0,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 3,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 1,  # 'م'
        6: 3,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    38: {  # 'ظ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 2,  # 'ا'
        9: 1,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 0,  # 'ج'
        19: 1,  # 'ح'
        26: 0,  # 'خ'
        12: 0,  # 'د'
        30: 0,  # 'ذ'
        7: 2,  # 'ر'
        27: 0,  # 'ز'
        13: 0,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 2,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 2,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    11: {  # 'ع'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 2,  # 'ث'
        20: 2,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 2,  # 'س'
        21: 2,  # 'ش'
        23: 2,  # 'ص'
        29: 3,  # 'ض'
        22: 2,  # 'ط'
        38: 2,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 2,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    31: {  # 'غ'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 1,  # 'ب'
        10: 2,  # 'ة'
        8: 2,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 0,  # 'ح'
        26: 0,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    42: {  # 'ـ'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 1,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    14: {  # 'ف'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 2,  # 'أ'
        41: 1,  # 'ؤ'
        24: 2,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 2,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 2,  # 'ظ'
        11: 3,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 3,  # 'ق'
        17: 2,  # 'ك'
        2: 3,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    16: {  # 'ق'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 0,  # 'خ'
        12: 3,  # 'د'
        30: 1,  # 'ذ'
        7: 3,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 3,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    17: {  # 'ك'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 3,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 2,  # 'س'
        21: 2,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 2,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    2: {  # 'ل'
        34: 1,  # 'ء'
        40: 2,  # 'آ'
        18: 3,  # 'أ'
        41: 1,  # 'ؤ'
        24: 3,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 3,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 3,  # 'خ'
        12: 3,  # 'د'
        30: 3,  # 'ذ'
        7: 3,  # 'ر'
        27: 3,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 3,  # 'ص'
        29: 2,  # 'ض'
        22: 3,  # 'ط'
        38: 2,  # 'ظ'
        11: 3,  # 'ع'
        31: 3,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 3,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 2,  # 'ِ'
        37: 2,  # 'ّ'
    },
    4: {  # 'م'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 3,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 3,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 3,  # 'ص'
        29: 2,  # 'ض'
        22: 2,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 2,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 2,  # 'ِ'
        37: 2,  # 'ّ'
    },
    6: {  # 'ن'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 1,  # 'ث'
        20: 3,  # 'ج'
        19: 2,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 2,  # 'ر'
        27: 2,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 2,  # 'ص'
        29: 2,  # 'ض'
        22: 3,  # 'ط'
        38: 3,  # 'ظ'
        11: 2,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 2,  # 'ك'
        2: 1,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 2,  # 'ّ'
    },
    15: {  # 'ه'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 2,  # 'ب'
        10: 2,  # 'ة'
        8: 2,  # 'ت'
        28: 1,  # 'ث'
        20: 2,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 3,  # 'د'
        30: 3,  # 'ذ'
        7: 3,  # 'ر'
        27: 2,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 2,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 1,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 1,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    5: {  # 'و'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 3,  # 'أ'
        41: 1,  # 'ؤ'
        24: 2,  # 'إ'
        32: 1,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 2,  # 'ة'
        8: 3,  # 'ت'
        28: 2,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 2,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 3,  # 'ز'
        13: 3,  # 'س'
        21: 2,  # 'ش'
        23: 3,  # 'ص'
        29: 2,  # 'ض'
        22: 3,  # 'ط'
        38: 2,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 2,  # 'و'
        25: 2,  # 'ى'
        3: 3,  # 'ي'
        33: 1,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    25: {  # 'ى'
        34: 1,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 0,  # 'ة'
        8: 0,  # 'ت'
        28: 0,  # 'ث'
        20: 0,  # 'ج'
        19: 0,  # 'ح'
        26: 0,  # 'خ'
        12: 0,  # 'د'
        30: 0,  # 'ذ'
        7: 0,  # 'ر'
        27: 0,  # 'ز'
        13: 0,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 0,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 0,  # 'ف'
        16: 0,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 0,  # 'م'
        6: 0,  # 'ن'
        15: 0,  # 'ه'
        5: 0,  # 'و'
        25: 0,  # 'ى'
        3: 1,  # 'ي'
        33: 1,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    3: {  # 'ي'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 2,  # 'ئ'
        1: 3,  # 'ا'
        9: 3,  # 'ب'
        10: 3,  # 'ة'
        8: 3,  # 'ت'
        28: 3,  # 'ث'
        20: 3,  # 'ج'
        19: 3,  # 'ح'
        26: 3,  # 'خ'
        12: 3,  # 'د'
        30: 2,  # 'ذ'
        7: 3,  # 'ر'
        27: 3,  # 'ز'
        13: 3,  # 'س'
        21: 3,  # 'ش'
        23: 2,  # 'ص'
        29: 3,  # 'ض'
        22: 3,  # 'ط'
        38: 1,  # 'ظ'
        11: 3,  # 'ع'
        31: 2,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 3,  # 'ف'
        16: 3,  # 'ق'
        17: 3,  # 'ك'
        2: 3,  # 'ل'
        4: 3,  # 'م'
        6: 3,  # 'ن'
        15: 3,  # 'ه'
        5: 3,  # 'و'
        25: 1,  # 'ى'
        3: 3,  # 'ي'
        33: 2,  # 'ً'
        44: 1,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 2,  # 'َ'
        36: 2,  # 'ُ'
        39: 1,  # 'ِ'
        37: 2,  # 'ّ'
    },
    33: {  # 'ً'
        34: 1,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 3,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 0,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 0,  # 'ذ'
        7: 1,  # 'ر'
        27: 0,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 1,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 0,  # 'ِ'
        37: 1,  # 'ّ'
    },
    44: {  # 'ٌ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 0,  # 'إ'
        32: 0,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 0,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 0,  # 'ذ'
        7: 1,  # 'ر'
        27: 0,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 0,  # 'ِ'
        37: 1,  # 'ّ'
    },
    43: {  # 'ٍ'
        34: 0,  # 'ء'
        40: 0,  # 'آ'
        18: 0,  # 'أ'
        41: 0,  # 'ؤ'
        24: 1,  # 'إ'
        32: 0,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 0,  # 'ث'
        20: 1,  # 'ج'
        19: 0,  # 'ح'
        26: 0,  # 'خ'
        12: 1,  # 'د'
        30: 0,  # 'ذ'
        7: 1,  # 'ر'
        27: 0,  # 'ز'
        13: 1,  # 'س'
        21: 0,  # 'ش'
        23: 0,  # 'ص'
        29: 0,  # 'ض'
        22: 0,  # 'ط'
        38: 0,  # 'ظ'
        11: 1,  # 'ع'
        31: 0,  # 'غ'
        45: 0,  # 'ؿ'
        42: 0,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 1,  # 'ل'
        4: 1,  # 'م'
        6: 1,  # 'ن'
        15: 0,  # 'ه'
        5: 1,  # 'و'
        25: 0,  # 'ى'
        3: 1,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 1,  # 'ٍ'
        35: 0,  # 'َ'
        36: 0,  # 'ُ'
        39: 1,  # 'ِ'
        37: 1,  # 'ّ'
    },
    35: {  # 'َ'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 2,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 2,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 1,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 3,  # 'ّ'
    },
    36: {  # 'ُ'
        34: 1,  # 'ء'
        40: 0,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 2,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 1,  # 'ز'
        13: 2,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 2,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 2,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 2,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 0,  # 'َ'
        36: 1,  # 'ُ'
        39: 1,  # 'ِ'
        37: 2,  # 'ّ'
    },
    39: {  # 'ِ'
        34: 0,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 1,  # 'إ'
        32: 1,  # 'ئ'
        1: 1,  # 'ا'
        9: 1,  # 'ب'
        10: 1,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 1,  # 'د'
        30: 1,  # 'ذ'
        7: 1,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 1,  # 'م'
        6: 2,  # 'ن'
        15: 1,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 2,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 0,  # 'َ'
        36: 0,  # 'ُ'
        39: 1,  # 'ِ'
        37: 2,  # 'ّ'
    },
    37: {  # 'ّ'
        34: 1,  # 'ء'
        40: 1,  # 'آ'
        18: 1,  # 'أ'
        41: 1,  # 'ؤ'
        24: 0,  # 'إ'
        32: 1,  # 'ئ'
        1: 2,  # 'ا'
        9: 1,  # 'ب'
        10: 2,  # 'ة'
        8: 1,  # 'ت'
        28: 1,  # 'ث'
        20: 1,  # 'ج'
        19: 1,  # 'ح'
        26: 1,  # 'خ'
        12: 2,  # 'د'
        30: 1,  # 'ذ'
        7: 2,  # 'ر'
        27: 1,  # 'ز'
        13: 1,  # 'س'
        21: 1,  # 'ش'
        23: 1,  # 'ص'
        29: 1,  # 'ض'
        22: 1,  # 'ط'
        38: 1,  # 'ظ'
        11: 1,  # 'ع'
        31: 1,  # 'غ'
        45: 0,  # 'ؿ'
        42: 1,  # 'ـ'
        14: 1,  # 'ف'
        16: 1,  # 'ق'
        17: 1,  # 'ك'
        2: 2,  # 'ل'
        4: 2,  # 'م'
        6: 1,  # 'ن'
        15: 2,  # 'ه'
        5: 1,  # 'و'
        25: 1,  # 'ى'
        3: 1,  # 'ي'
        33: 0,  # 'ً'
        44: 0,  # 'ٌ'
        43: 0,  # 'ٍ'
        35: 0,  # 'َ'
        36: 0,  # 'ُ'
        39: 0,  # 'ِ'
        37: 1,  # 'ّ'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
ISO_8859_6_ARABIC_CHAR_TO_ORDER = {
    0: 251,  # '\x00'
    1: 251,  # '\x01'
    2: 251,  # '\x02'
    3: 251,  # '\x03'
    4: 251,  # '\x04'
    5: 251,  # '\x05'
    6: 251,  # '\x06'
    7: 251,  # '\x07'
    8: 251,  # '\x08'
    9: 251,  # '\t'
    10: 254,  # '\n'
    11: 251,  # '\x0b'
    12: 251,  # '\x0c'
    13: 254,  # '\r'
    14: 251,  # '\x0e'
    15: 251,  # '\x0f'
    16: 251,  # '\x10'
    17: 251,  # '\x11'
    18: 251,  # '\x12'
    19: 251,  # '\x13'
    20: 251,  # '\x14'
    21: 251,  # '\x15'
    22: 251,  # '\x16'
    23: 251,  # '\x17'
    24: 251,  # '\x18'
    25: 251,  # '\x19'
    26: 251,  # '\x1a'
    27: 251,  # '\x1b'
    28: 251,  # '\x1c'
    29: 251,  # '\x1d'
    30: 251,  # '\x1e'
    31: 251,  # '\x1f'
    32: 251,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 255,  # 'A'
    66: 255,  # 'B'
    67: 255,  # 'C'
    68: 255,  # 'D'
    69: 255,  # 'E'
    70: 255,  # 'F'
    71: 255,  # 'G'
    72: 255,  # 'H'
    73: 255,  # 'I'
    74: 255,  # 'J'
    75: 255,  # 'K'
    76: 255,  # 'L'
    77: 255,  # 'M'
    78: 255,  # 'N'
    79: 255,  # 'O'
    80: 255,  # 'P'
    81: 255,  # 'Q'
    82: 255,  # 'R'
    83: 255,  # 'S'
    84: 255,  # 'T'
    85: 255,  # 'U'
    86: 255,  # 'V'
    87: 255,  # 'W'
    88: 255,  # 'X'
    89: 255,  # 'Y'
    90: 255,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 255,  # 'a'
    98: 255,  # 'b'
    99: 255,  # 'c'
    100: 255,  # 'd'
    101: 255,  # 'e'
    102: 255,  # 'f'
    103: 255,  # 'g'
    104: 255,  # 'h'
    105: 255,  # 'i'
    106: 255,  # 'j'
    107: 255,  # 'k'
    108: 255,  # 'l'
    109: 255,  # 'm'
    110: 255,  # 'n'
    111: 255,  # 'o'
    112: 255,  # 'p'
    113: 255,  # 'q'
    114: 255,  # 'r'
    115: 255,  # 's'
    116: 255,  # 't'
    117: 255,  # 'u'
    118: 255,  # 'v'
    119: 255,  # 'w'
    120: 255,  # 'x'
    121: 255,  # 'y'
    122: 255,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 251,  # '\x7f'
    128: 251,  # '\x80'
    129: 251,  # '\x81'
    130: 251,  # '\x82'
    131: 251,  # '\x83'
    132: 251,  # '\x84'
    133: 251,  # '\x85'
    134: 251,  # '\x86'
    135: 251,  # '\x87'
    136: 251,  # '\x88'
    137: 251,  # '\x89'
    138: 251,  # '\x8a'
    139: 251,  # '\x8b'
    140: 251,  # '\x8c'
    141: 251,  # '\x8d'
    142: 251,  # '\x8e'
    143: 251,  # '\x8f'
    144: 251,  # '\x90'
    145: 251,  # '\x91'
    146: 251,  # '\x92'
    147: 251,  # '\x93'
    148: 251,  # '\x94'
    149: 251,  # '\x95'
    150: 251,  # '\x96'
    151: 251,  # '\x97'
    152: 251,  # '\x98'
    153: 251,  # '\x99'
    154: 251,  # '\x9a'
    155: 251,  # '\x9b'
    156: 251,  # '\x9c'
    157: 251,  # '\x9d'
    158: 251,  # '\x9e'
    159: 251,  # '\x9f'
    160: 251,  # '\xa0'
    161: 255,  # None
    162: 255,  # None
    163: 255,  # None
    164: 253,  # '¤'
    165: 255,  # None
    166: 255,  # None
    167: 255,  # None
    168: 255,  # None
    169: 255,  # None
    170: 255,  # None
    171: 255,  # None
    172: 253,  # '،'
    173: 251,  # '\xad'
    174: 255,  # None
    175: 255,  # None
    176: 255,  # None
    177: 255,  # None
    178: 255,  # None
    179: 255,  # None
    180: 255,  # None
    181: 255,  # None
    182: 255,  # None
    183: 255,  # None
    184: 255,  # None
    185: 255,  # None
    186: 255,  # None
    187: 253,  # '؛'
    188: 255,  # None
    189: 255,  # None
    190: 255,  # None
    191: 253,  # '؟'
    192: 255,  # None
    193: 34,  # 'ء'
    194: 40,  # 'آ'
    195: 18,  # 'أ'
    196: 41,  # 'ؤ'
    197: 24,  # 'إ'
    198: 32,  # 'ئ'
    199: 1,  # 'ا'
    200: 9,  # 'ب'
    201: 10,  # 'ة'
    202: 8,  # 'ت'
    203: 28,  # 'ث'
    204: 20,  # 'ج'
    205: 19,  # 'ح'
    206: 26,  # 'خ'
    207: 12,  # 'د'
    208: 30,  # 'ذ'
    209: 7,  # 'ر'
    210: 27,  # 'ز'
    211: 13,  # 'س'
    212: 21,  # 'ش'
    213: 23,  # 'ص'
    214: 29,  # 'ض'
    215: 22,  # 'ط'
    216: 38,  # 'ظ'
    217: 11,  # 'ع'
    218: 31,  # 'غ'
    219: 255,  # None
    220: 255,  # None
    221: 255,  # None
    222: 255,  # None
    223: 255,  # None
    224: 42,  # 'ـ'
    225: 14,  # 'ف'
    226: 16,  # 'ق'
    227: 17,  # 'ك'
    228: 2,  # 'ل'
    229: 4,  # 'م'
    230: 6,  # 'ن'
    231: 15,  # 'ه'
    232: 5,  # 'و'
    233: 25,  # 'ى'
    234: 3,  # 'ي'
    235: 253,  # 'ً'
    236: 253,  # 'ٌ'
    237: 253,  # 'ٍ'
    238: 253,  # 'َ'
    239: 253,  # 'ُ'
    240: 253,  # 'ِ'
    241: 253,  # 'ّ'
    242: 253,  # 'ْ'
    243: 255,  # None
    244: 255,  # None
    245: 255,  # None
    246: 255,  # None
    247: 255,  # None
    248: 255,  # None
    249: 255,  # None
    250: 255,  # None
    251: 255,  # None
    252: 255,  # None
    253: 255,  # None
    254: 255,  # None
    255: 255,  # None
}

ISO_8859_6_ARABIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-6",
    language="Arabic",
    char_to_order_map=ISO_8859_6_ARABIC_CHAR_TO_ORDER,
    language_model=ARABIC_LANG_MODEL,
    typical_positive_ratio=1.0,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابةتثجحخدذرزسشصضطظعغػؼؽؾؿـفقكلمنهوىيًٌٍَُِّ",
)

WINDOWS_1256_ARABIC_CHAR_TO_ORDER = {
    0: 251,  # '\x00'
    1: 251,  # '\x01'
    2: 251,  # '\x02'
    3: 251,  # '\x03'
    4: 251,  # '\x04'
    5: 251,  # '\x05'
    6: 251,  # '\x06'
    7: 251,  # '\x07'
    8: 251,  # '\x08'
    9: 251,  # '\t'
    10: 254,  # '\n'
    11: 251,  # '\x0b'
    12: 251,  # '\x0c'
    13: 254,  # '\r'
    14: 251,  # '\x0e'
    15: 251,  # '\x0f'
    16: 251,  # '\x10'
    17: 251,  # '\x11'
    18: 251,  # '\x12'
    19: 251,  # '\x13'
    20: 251,  # '\x14'
    21: 251,  # '\x15'
    22: 251,  # '\x16'
    23: 251,  # '\x17'
    24: 251,  # '\x18'
    25: 251,  # '\x19'
    26: 251,  # '\x1a'
    27: 251,  # '\x1b'
    28: 251,  # '\x1c'
    29: 251,  # '\x1d'
    30: 251,  # '\x1e'
    31: 251,  # '\x1f'
    32: 251,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 255,  # 'A'
    66: 255,  # 'B'
    67: 255,  # 'C'
    68: 255,  # 'D'
    69: 255,  # 'E'
    70: 255,  # 'F'
    71: 255,  # 'G'
    72: 255,  # 'H'
    73: 255,  # 'I'
    74: 255,  # 'J'
    75: 255,  # 'K'
    76: 255,  # 'L'
    77: 255,  # 'M'
    78: 255,  # 'N'
    79: 255,  # 'O'
    80: 255,  # 'P'
    81: 255,  # 'Q'
    82: 255,  # 'R'
    83: 255,  # 'S'
    84: 255,  # 'T'
    85: 255,  # 'U'
    86: 255,  # 'V'
    87: 255,  # 'W'
    88: 255,  # 'X'
    89: 255,  # 'Y'
    90: 255,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 255,  # 'a'
    98: 255,  # 'b'
    99: 255,  # 'c'
    100: 255,  # 'd'
    101: 255,  # 'e'
    102: 255,  # 'f'
    103: 255,  # 'g'
    104: 255,  # 'h'
    105: 255,  # 'i'
    106: 255,  # 'j'
    107: 255,  # 'k'
    108: 255,  # 'l'
    109: 255,  # 'm'
    110: 255,  # 'n'
    111: 255,  # 'o'
    112: 255,  # 'p'
    113: 255,  # 'q'
    114: 255,  # 'r'
    115: 255,  # 's'
    116: 255,  # 't'
    117: 255,  # 'u'
    118: 255,  # 'v'
    119: 255,  # 'w'
    120: 255,  # 'x'
    121: 255,  # 'y'
    122: 255,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 251,  # '\x7f'
    128: 253,  # '€'
    129: 255,  # 'پ'
    130: 253,  # '‚'
    131: 255,  # 'ƒ'
    132: 253,  # '„'
    133: 253,  # '…'
    134: 253,  # '†'
    135: 253,  # '‡'
    136: 255,  # 'ˆ'
    137: 253,  # '‰'
    138: 255,  # 'ٹ'
    139: 253,  # '‹'
    140: 255,  # 'Œ'
    141: 255,  # 'چ'
    142: 255,  # 'ژ'
    143: 255,  # 'ڈ'
    144: 255,  # 'گ'
    145: 253,  # '‘'
    146: 253,  # '’'
    147: 253,  # '“'
    148: 253,  # '”'
    149: 253,  # '•'
    150: 253,  # '–'
    151: 253,  # '—'
    152: 255,  # 'ک'
    153: 253,  # '™'
    154: 255,  # 'ڑ'
    155: 253,  # '›'
    156: 255,  # 'œ'
    157: 251,  # '\u200c'
    158: 251,  # '\u200d'
    159: 255,  # 'ں'
    160: 251,  # '\xa0'
    161: 253,  # '،'
    162: 253,  # '¢'
    163: 253,  # '£'
    164: 253,  # '¤'
    165: 253,  # '¥'
    166: 253,  # '¦'
    167: 253,  # '§'
    168: 253,  # '¨'
    169: 253,  # '©'
    170: 255,  # 'ھ'
    171: 253,  # '«'
    172: 253,  # '¬'
    173: 251,  # '\xad'
    174: 253,  # '®'
    175: 253,  # '¯'
    176: 253,  # '°'
    177: 253,  # '±'
    178: 252,  # '²'
    179: 252,  # '³'
    180: 253,  # '´'
    181: 255,  # 'µ'
    182: 253,  # '¶'
    183: 253,  # '·'
    184: 253,  # '¸'
    185: 252,  # '¹'
    186: 253,  # '؛'
    187: 253,  # '»'
    188: 252,  # '¼'
    189: 252,  # '½'
    190: 252,  # '¾'
    191: 253,  # '؟'
    192: 255,  # 'ہ'
    193: 34,  # 'ء'
    194: 40,  # 'آ'
    195: 18,  # 'أ'
    196: 41,  # 'ؤ'
    197: 24,  # 'إ'
    198: 32,  # 'ئ'
    199: 1,  # 'ا'
    200: 9,  # 'ب'
    201: 10,  # 'ة'
    202: 8,  # 'ت'
    203: 28,  # 'ث'
    204: 20,  # 'ج'
    205: 19,  # 'ح'
    206: 26,  # 'خ'
    207: 12,  # 'د'
    208: 30,  # 'ذ'
    209: 7,  # 'ر'
    210: 27,  # 'ز'
    211: 13,  # 'س'
    212: 21,  # 'ش'
    213: 23,  # 'ص'
    214: 29,  # 'ض'
    215: 253,  # '×'
    216: 22,  # 'ط'
    217: 38,  # 'ظ'
    218: 11,  # 'ع'
    219: 31,  # 'غ'
    220: 42,  # 'ـ'
    221: 14,  # 'ف'
    222: 16,  # 'ق'
    223: 17,  # 'ك'
    224: 255,  # 'à'
    225: 2,  # 'ل'
    226: 255,  # 'â'
    227: 4,  # 'م'
    228: 6,  # 'ن'
    229: 15,  # 'ه'
    230: 5,  # 'و'
    231: 255,  # 'ç'
    232: 255,  # 'è'
    233: 255,  # 'é'
    234: 255,  # 'ê'
    235: 255,  # 'ë'
    236: 25,  # 'ى'
    237: 3,  # 'ي'
    238: 255,  # 'î'
    239: 255,  # 'ï'
    240: 253,  # 'ً'
    241: 253,  # 'ٌ'
    242: 253,  # 'ٍ'
    243: 253,  # 'َ'
    244: 255,  # 'ô'
    245: 253,  # 'ُ'
    246: 253,  # 'ِ'
    247: 253,  # '÷'
    248: 253,  # 'ّ'
    249: 255,  # 'ù'
    250: 253,  # 'ْ'
    251: 255,  # 'û'
    252: 255,  # 'ü'
    253: 251,  # '\u200e'
    254: 251,  # '\u200f'
    255: 255,  # 'ے'
}

WINDOWS_1256_ARABIC_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1256",
    language="Arabic",
    char_to_order_map=WINDOWS_1256_ARABIC_CHAR_TO_ORDER,
    language_model=ARABIC_LANG_MODEL,
    typical_positive_ratio=1.0,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابةتثجحخدذرزسشصضطظعغػؼؽؾؿـفقكلمنهوىيًٌٍَُِّ",
)

CP720_ARABIC_CHAR_TO_ORDER = {
    0: 251,  # '\x00'
    1: 251,  # '\x01'
    2: 251,  # '\x02'
    3: 251,  # '\x03'
    4: 251,  # '\x04'
    5: 251,  # '\x05'
    6: 251,  # '\x06'
    7: 251,  # '\x07'
    8: 251,  # '\x08'
    9: 251,  # '\t'
    10: 254,  # '\n'
    11: 251,  # '\x0b'
    12: 251,  # '\x0c'
    13: 254,  # '\r'
    14: 251,  # '\x0e'
    15: 251,  # '\x0f'
    16: 251,  # '\x10'
    17: 251,  # '\x11'
    18: 251,  # '\x12'
    19: 251,  # '\x13'
    20: 251,  # '\x14'
    21: 251,  # '\x15'
    22: 251,  # '\x16'
    23: 251,  # '\x17'
    24: 251,  # '\x18'
    25: 251,  # '\x19'
    26: 251,  # '\x1a'
    27: 251,  # '\x1b'
    28: 251,  # '\x1c'
    29: 251,  # '\x1d'
    30: 251,  # '\x1e'
    31: 251,  # '\x1f'
    32: 251,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 255,  # 'A'
    66: 255,  # 'B'
    67: 255,  # 'C'
    68: 255,  # 'D'
    69: 255,  # 'E'
    70: 255,  # 'F'
    71: 255,  # 'G'
    72: 255,  # 'H'
    73: 255,  # 'I'
    74: 255,  # 'J'
    75: 255,  # 'K'
    76: 255,  # 'L'
    77: 255,  # 'M'
    78: 255,  # 'N'
    79: 255,  # 'O'
    80: 255,  # 'P'
    81: 255,  # 'Q'
    82: 255,  # 'R'
    83: 255,  # 'S'
    84: 255,  # 'T'
    85: 255,  # 'U'
    86: 255,  # 'V'
    87: 255,  # 'W'
    88: 255,  # 'X'
    89: 255,  # 'Y'
    90: 255,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 255,  # 'a'
    98: 255,  # 'b'
    99: 255,  # 'c'
    100: 255,  # 'd'
    101: 255,  # 'e'
    102: 255,  # 'f'
    103: 255,  # 'g'
    104: 255,  # 'h'
    105: 255,  # 'i'
    106: 255,  # 'j'
    107: 255,  # 'k'
    108: 255,  # 'l'
    109: 255,  # 'm'
    110: 255,  # 'n'
    111: 255,  # 'o'
    112: 255,  # 'p'
    113: 255,  # 'q'
    114: 255,  # 'r'
    115: 255,  # 's'
    116: 255,  # 't'
    117: 255,  # 'u'
    118: 255,  # 'v'
    119: 255,  # 'w'
    120: 255,  # 'x'
    121: 255,  # 'y'
    122: 255,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 251,  # '\x7f'
    128: 251,  # '\x80'
    129: 251,  # '\x81'
    130: 255,  # 'é'
    131: 255,  # 'â'
    132: 251,  # '\x84'
    133: 255,  # 'à'
    134: 251,  # '\x86'
    135: 255,  # 'ç'
    136: 255,  # 'ê'
    137: 255,  # 'ë'
    138: 255,  # 'è'
    139: 255,  # 'ï'
    140: 255,  # 'î'
    141: 251,  # '\x8d'
    142: 251,  # '\x8e'
    143: 251,  # '\x8f'
    144: 251,  # '\x90'
    145: 253,  # 'ّ'
    146: 253,  # 'ْ'
    147: 255,  # 'ô'
    148: 253,  # '¤'
    149: 42,  # 'ـ'
    150: 255,  # 'û'
    151: 255,  # 'ù'
    152: 34,  # 'ء'
    153: 40,  # 'آ'
    154: 18,  # 'أ'
    155: 41,  # 'ؤ'
    156: 253,  # '£'
    157: 24,  # 'إ'
    158: 32,  # 'ئ'
    159: 1,  # 'ا'
    160: 9,  # 'ب'
    161: 10,  # 'ة'
    162: 8,  # 'ت'
    163: 28,  # 'ث'
    164: 20,  # 'ج'
    165: 19,  # 'ح'
    166: 26,  # 'خ'
    167: 12,  # 'د'
    168: 30,  # 'ذ'
    169: 7,  # 'ر'
    170: 27,  # 'ز'
    171: 13,  # 'س'
    172: 21,  # 'ش'
    173: 23,  # 'ص'
    174: 253,  # '«'
    175: 253,  # '»'
    176: 253,  # '░'
    177: 253,  # '▒'
    178: 253,  # '▓'
    179: 253,  # '│'
    180: 253,  # '┤'
    181: 253,  # '╡'
    182: 253,  # '╢'
    183: 253,  # '╖'
    184: 253,  # '╕'
    185: 253,  # '╣'
    186: 253,  # '║'
    187: 253,  # '╗'
    188: 253,  # '╝'
    189: 253,  # '╜'
    190: 253,  # '╛'
    191: 253,  # '┐'
    192: 253,  # '└'
    193: 253,  # '┴'
    194: 253,  # '┬'
    195: 253,  # '├'
    196: 253,  # '─'
    197: 253,  # '┼'
    198: 253,  # '╞'
    199: 253,  # '╟'
    200: 253,  # '╚'
    201: 253,  # '╔'
    202: 253,  # '╩'
    203: 253,  # '╦'
    204: 253,  # '╠'
    205: 253,  # '═'
    206: 253,  # '╬'
    207: 253,  # '╧'
    208: 253,  # '╨'
    209: 253,  # '╤'
    210: 253,  # '╥'
    211: 253,  # '╙'
    212: 253,  # '╘'
    213: 253,  # '╒'
    214: 253,  # '╓'
    215: 253,  # '╫'
    216: 253,  # '╪'
    217: 253,  # '┘'
    218: 253,  # '┌'
    219: 253,  # '█'
    220: 253,  # '▄'
    221: 253,  # '▌'
    222: 253,  # '▐'
    223: 253,  # '▀'
    224: 29,  # 'ض'
    225: 22,  # 'ط'
    226: 38,  # 'ظ'
    227: 11,  # 'ع'
    228: 31,  # 'غ'
    229: 14,  # 'ف'
    230: 255,  # 'µ'
    231: 16,  # 'ق'
    232: 17,  # 'ك'
    233: 2,  # 'ل'
    234: 4,  # 'م'
    235: 6,  # 'ن'
    236: 15,  # 'ه'
    237: 5,  # 'و'
    238: 25,  # 'ى'
    239: 3,  # 'ي'
    240: 253,  # '≡'
    241: 253,  # 'ً'
    242: 253,  # 'ٌ'
    243: 253,  # 'ٍ'
    244: 253,  # 'َ'
    245: 253,  # 'ُ'
    246: 253,  # 'ِ'
    247: 253,  # '≈'
    248: 253,  # '°'
    249: 253,  # '∙'
    250: 253,  # '·'
    251: 253,  # '√'
    252: 255,  # 'ⁿ'
    253: 252,  # '²'
    254: 253,  # '■'
    255: 251,  # '\xa0'
}

CP720_ARABIC_MODEL = SingleByteCharSetModel(
    charset_name="CP720",
    language="Arabic",
    char_to_order_map=CP720_ARABIC_CHAR_TO_ORDER,
    language_model=ARABIC_LANG_MODEL,
    typical_positive_ratio=1.0,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابةتثجحخدذرزسشصضطظعغػؼؽؾؿـفقكلمنهوىيًٌٍَُِّ",
)

CP864_ARABIC_CHAR_TO_ORDER = {
    0: 251,  # '\x00'
    1: 251,  # '\x01'
    2: 251,  # '\x02'
    3: 251,  # '\x03'
    4: 251,  # '\x04'
    5: 251,  # '\x05'
    6: 251,  # '\x06'
    7: 251,  # '\x07'
    8: 251,  # '\x08'
    9: 251,  # '\t'
    10: 254,  # '\n'
    11: 251,  # '\x0b'
    12: 251,  # '\x0c'
    13: 254,  # '\r'
    14: 251,  # '\x0e'
    15: 251,  # '\x0f'
    16: 251,  # '\x10'
    17: 251,  # '\x11'
    18: 251,  # '\x12'
    19: 251,  # '\x13'
    20: 251,  # '\x14'
    21: 251,  # '\x15'
    22: 251,  # '\x16'
    23: 251,  # '\x17'
    24: 251,  # '\x18'
    25: 251,  # '\x19'
    26: 251,  # '\x1a'
    27: 251,  # '\x1b'
    28: 251,  # '\x1c'
    29: 251,  # '\x1d'
    30: 251,  # '\x1e'
    31: 251,  # '\x1f'
    32: 251,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '٪'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 255,  # 'A'
    66: 255,  # 'B'
    67: 255,  # 'C'
    68: 255,  # 'D'
    69: 255,  # 'E'
    70: 255,  # 'F'
    71: 255,  # 'G'
    72: 255,  # 'H'
    73: 255,  # 'I'
    74: 255,  # 'J'
    75: 255,  # 'K'
    76: 255,  # 'L'
    77: 255,  # 'M'
    78: 255,  # 'N'
    79: 255,  # 'O'
    80: 255,  # 'P'
    81: 255,  # 'Q'
    82: 255,  # 'R'
    83: 255,  # 'S'
    84: 255,  # 'T'
    85: 255,  # 'U'
    86: 255,  # 'V'
    87: 255,  # 'W'
    88: 255,  # 'X'
    89: 255,  # 'Y'
    90: 255,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 255,  # 'a'
    98: 255,  # 'b'
    99: 255,  # 'c'
    100: 255,  # 'd'
    101: 255,  # 'e'
    102: 255,  # 'f'
    103: 255,  # 'g'
    104: 255,  # 'h'
    105: 255,  # 'i'
    106: 255,  # 'j'
    107: 255,  # 'k'
    108: 255,  # 'l'
    109: 255,  # 'm'
    110: 255,  # 'n'
    111: 255,  # 'o'
    112: 255,  # 'p'
    113: 255,  # 'q'
    114: 255,  # 'r'
    115: 255,  # 's'
    116: 255,  # 't'
    117: 255,  # 'u'
    118: 255,  # 'v'
    119: 255,  # 'w'
    120: 255,  # 'x'
    121: 255,  # 'y'
    122: 255,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 251,  # '\x7f'
    128: 253,  # '°'
    129: 253,  # '·'
    130: 253,  # '∙'
    131: 253,  # '√'
    132: 253,  # '▒'
    133: 253,  # '─'
    134: 253,  # '│'
    135: 253,  # '┼'
    136: 253,  # '┤'
    137: 253,  # '┬'
    138: 253,  # '├'
    139: 253,  # '┴'
    140: 253,  # '┐'
    141: 253,  # '┌'
    142: 253,  # '└'
    143: 253,  # '┘'
    144: 255,  # 'β'
    145: 253,  # '∞'
    146: 255,  # 'φ'
    147: 253,  # '±'
    148: 252,  # '½'
    149: 252,  # '¼'
    150: 253,  # '≈'
    151: 253,  # '«'
    152: 253,  # '»'
    153: 255,  # 'ﻷ'
    154: 255,  # 'ﻸ'
    155: 255,  # None
    156: 255,  # None
    157: 255,  # 'ﻻ'
    158: 255,  # 'ﻼ'
    159: 255,  # None
    160: 251,  # '\xa0'
    161: 251,  # '\xad'
    162: 255,  # 'ﺂ'
    163: 253,  # '£'
    164: 253,  # '¤'
    165: 255,  # 'ﺄ'
    166: 255,  # None
    167: 255,  # None
    168: 255,  # 'ﺎ'
    169: 255,  # 'ﺏ'
    170: 255,  # 'ﺕ'
    171: 255,  # 'ﺙ'
    172: 253,  # '،'
    173: 255,  # 'ﺝ'
    174: 255,  # 'ﺡ'
    175: 255,  # 'ﺥ'
    176: 252,  # '٠'
    177: 252,  # '١'
    178: 252,  # '٢'
    179: 252,  # '٣'
    180: 252,  # '٤'
    181: 252,  # '٥'
    182: 252,  # '٦'
    183: 252,  # '٧'
    184: 252,  # '٨'
    185: 252,  # '٩'
    186: 255,  # 'ﻑ'
    187: 253,  # '؛'
    188: 255,  # 'ﺱ'
    189: 255,  # 'ﺵ'
    190: 255,  # 'ﺹ'
    191: 253,  # '؟'
    192: 253,  # '¢'
    193: 255,  # 'ﺀ'
    194: 255,  # 'ﺁ'
    195: 255,  # 'ﺃ'
    196: 255,  # 'ﺅ'
    197: 255,  # 'ﻊ'
    198: 255,  # 'ﺋ'
    199: 255,  # 'ﺍ'
    200: 255,  # 'ﺑ'
    201: 255,  # 'ﺓ'
    202: 255,  # 'ﺗ'
    203: 255,  # 'ﺛ'
    204: 255,  # 'ﺟ'
    205: 255,  # 'ﺣ'
    206: 255,  # 'ﺧ'
    207: 255,  # 'ﺩ'
    208: 255,  # 'ﺫ'
    209: 255,  # 'ﺭ'
    210: 255,  # 'ﺯ'
    211: 255,  # 'ﺳ'
    212: 255,  # 'ﺷ'
    213: 255,  # 'ﺻ'
    214: 255,  # 'ﺿ'
    215: 255,  # 'ﻁ'
    216: 255,  # 'ﻅ'
    217: 255,  # 'ﻋ'
    218: 255,  # 'ﻏ'
    219: 253,  # '¦'
    220: 253,  # '¬'
    221: 253,  # '÷'
    222: 253,  # '×'
    223: 255,  # 'ﻉ'
    224: 42,  # 'ـ'
    225: 255,  # 'ﻓ'
    226: 255,  # 'ﻗ'
    227: 255,  # 'ﻛ'
    228: 255,  # 'ﻟ'
    229: 255,  # 'ﻣ'
    230: 255,  # 'ﻧ'
    231: 255,  # 'ﻫ'
    232: 255,  # 'ﻭ'
    233: 255,  # 'ﻯ'
    234: 255,  # 'ﻳ'
    235: 255,  # 'ﺽ'
    236: 255,  # 'ﻌ'
    237: 255,  # 'ﻎ'
    238: 255,  # 'ﻍ'
    239: 255,  # 'ﻡ'
    240: 255,  # 'ﹽ'
    241: 253,  # 'ّ'
    242: 255,  # 'ﻥ'
    243: 255,  # 'ﻩ'
    244: 255,  # 'ﻬ'
    245: 255,  # 'ﻰ'
    246: 255,  # 'ﻲ'
    247: 255,  # 'ﻐ'
    248: 255,  # 'ﻕ'
    249: 255,  # 'ﻵ'
    250: 255,  # 'ﻶ'
    251: 255,  # 'ﻝ'
    252: 255,  # 'ﻙ'
    253: 255,  # 'ﻱ'
    254: 253,  # '■'
    255: 255,  # None
}

CP864_ARABIC_MODEL = SingleByteCharSetModel(
    charset_name="CP864",
    language="Arabic",
    char_to_order_map=CP864_ARABIC_CHAR_TO_ORDER,
    language_model=ARABIC_LANG_MODEL,
    typical_positive_ratio=1.0,
    keep_ascii_letters=False,
    alphabet="ءآأؤإئابةتثجحخدذرزسشصضطظعغػؼؽؾؿـفقكلمنهوىيًٌٍَُِّ",
)
