/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlExtractFunction
extends SqlFunction {
    private static final ImmutableSet<SqlTypeName> MONTH_AND_ABOVE_TYPES = new ImmutableSet.Builder().add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).addAll(SqlTypeName.YEAR_INTERVAL_TYPES).build();
    private static final ImmutableSet<SqlTypeName> DAY_TO_WEEK_TYPES = new ImmutableSet.Builder().add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build();
    private static final ImmutableSet<SqlTypeName> EPOCH_TYPES = new ImmutableSet.Builder().add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).addAll(SqlTypeName.YEAR_INTERVAL_TYPES).addAll(SqlTypeName.DAY_INTERVAL_TYPES).build();
    private static final ImmutableSet<SqlTypeName> DAY_TYPES = new ImmutableSet.Builder().add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.INTERVAL_DAY).add((Object)SqlTypeName.INTERVAL_DAY_HOUR).add((Object)SqlTypeName.INTERVAL_DAY_MINUTE).add((Object)SqlTypeName.INTERVAL_DAY_SECOND).addAll(SqlTypeName.YEAR_INTERVAL_TYPES).build();
    private static final ImmutableSet<SqlTypeName> HOUR_TO_NANOSECOND_TYPES = new ImmutableSet.Builder().add((Object)SqlTypeName.DATE).add((Object)SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIME).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).addAll(SqlTypeName.YEAR_INTERVAL_TYPES).addAll(SqlTypeName.DAY_INTERVAL_TYPES).build();

    public SqlExtractFunction(String name, boolean allowString) {
        super(name, SqlKind.EXTRACT, ReturnTypes.BIGINT_NULLABLE, null, allowString ? OperandTypes.INTERVALINTERVAL_INTERVALDATETIME.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME)) : OperandTypes.INTERVALINTERVAL_INTERVALDATETIME, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{0}({1} FROM {2})";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        SqlIntervalQualifier.asIdentifier(call.operand(0)).unparse(writer, 0, 0);
        writer.sep("FROM");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        boolean legal;
        SqlIntervalQualifier qualifier;
        super.validateCall(call, validator, scope, operandScope);
        if (call.operand(0) instanceof SqlCharStringLiteral) {
            SqlCharStringLiteral stringLiteral = (SqlCharStringLiteral)call.operand(0);
            qualifier = new SqlIntervalQualifier(Objects.requireNonNull(stringLiteral.toValue()), ((SqlNode)call.operand(0)).getParserPosition());
        } else {
            qualifier = (SqlIntervalQualifier)call.operand(0);
        }
        validator.validateTimeFrame(qualifier);
        TimeUnitRange range = qualifier.timeUnitRange;
        RelDataType type = validator.getValidatedNodeTypeIfKnown((SqlNode)call.operand(1));
        if (type == null) {
            return;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        switch (range) {
            case YEAR: 
            case MONTH: 
            case ISOYEAR: 
            case QUARTER: 
            case DECADE: 
            case CENTURY: 
            case MILLENNIUM: {
                legal = MONTH_AND_ABOVE_TYPES.contains((Object)typeName);
                break;
            }
            case WEEK: 
            case DOW: 
            case ISODOW: 
            case DOY: {
                legal = DAY_TO_WEEK_TYPES.contains((Object)typeName);
                break;
            }
            case EPOCH: {
                legal = EPOCH_TYPES.contains((Object)typeName);
                break;
            }
            case DAY: {
                legal = DAY_TYPES.contains((Object)typeName);
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: 
            case MICROSECOND: 
            case NANOSECOND: {
                legal = HOUR_TO_NANOSECOND_TYPES.contains((Object)typeName);
                break;
            }
            default: {
                legal = false;
            }
        }
        if (!legal) {
            throw validator.newValidationError(call, Static.RESOURCE.canNotApplyOp2Type(call.getOperator().getName(), call.getCallSignature(validator, scope), call.getOperator().getAllowedSignatures()));
        }
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        TimeUnitRange value = SqlTypeName.CHAR_TYPES.contains((Object)call.getOperandType(0).getSqlTypeName()) ? TimeUnitRange.of((TimeUnit)SqlIntervalQualifier.stringToDatePartTimeUnit(Objects.requireNonNull(call.getOperandLiteralValue(0, String.class))), null) : SqlNonNullableAccessors.getOperandLiteralValueOrThrow(call, 0, TimeUnitRange.class);
        switch (value) {
            case YEAR: {
                return call.getOperandMonotonicity(1).unstrict();
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }
}

