/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;

class T4CTTIkscn
extends T4CTTIMsg {
    long kscnbas;
    int kscnwrp;

    T4CTTIkscn(T4CConnection _conn) {
        super(_conn, (byte)0);
    }

    T4CTTIkscn(T4CConnection _conn, byte _ttccode) {
        super(_conn, _ttccode);
    }

    public void unmarshal() throws SQLException, IOException {
        this.kscnbas = this.meg.unmarshalUB4();
        this.kscnwrp = this.meg.unmarshalUB2();
    }

    public void marshal() throws SQLException, IOException {
        this.meg.marshalUB4(this.kscnbas);
        this.meg.marshalUB2(this.kscnwrp);
    }

    public long getSCN() {
        long scn = this.kscnbas & 0xFFFFFFFFL | ((long)this.kscnwrp & 0xFFFFFFFFL) << 32;
        return scn;
    }

    public void setSCN(long scn) {
        this.kscnbas = scn & 0xFFFFFFFFL;
        this.kscnwrp = (int)(scn >> 32);
    }

    static boolean isLessThanUnsigned(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }
}

