/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.gui;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.runtime.tree.CommonTree;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.debug.AddAttributeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeScopeStackModel
implements TreeModel {
    CommonTree root = new StringTree("Scope stack:");

    public JTreeScopeStackModel(InstanceScope scope) {
        HashSet<String> names = new HashSet<String>();
        List<InstanceScope> stack = Interpreter.getScopeStack(scope, false);
        for (InstanceScope s15 : stack) {
            StringTree templateNode = new StringTree(s15.st.getName());
            this.root.insertChild(0, templateNode);
            this.addAttributeDescriptions(s15.st, templateNode, names);
        }
    }

    public void addAttributeDescriptions(ST st4, StringTree node, Set<String> names) {
        Map<String, Object> attrs = st4.getAttributes();
        if (attrs == null) {
            return;
        }
        for (String a15 : attrs.keySet()) {
            String descr = null;
            if (st4.debugState != null && st4.debugState.addAttrEvents != null) {
                List events = (List)st4.debugState.addAttrEvents.get(a15);
                StringBuilder locations = new StringBuilder();
                int i15 = 0;
                if (events != null) {
                    for (AddAttributeEvent ae5 : events) {
                        if (i15 > 0) {
                            locations.append(", ");
                        }
                        locations.append(ae5.getFileName() + ":" + ae5.getLine());
                        ++i15;
                    }
                }
                descr = locations.length() > 0 ? a15 + " = " + attrs.get(a15) + " @ " + locations.toString() : a15 + " = " + attrs.get(a15);
            } else {
                descr = a15 + " = " + attrs.get(a15);
            }
            if (!names.add(a15)) {
                StringBuilder builder = new StringBuilder();
                builder.append("<html><font color=\"gray\">");
                builder.append(StringRenderer.escapeHTML(descr));
                builder.append("</font></html>");
                descr = builder.toString();
            }
            node.addChild(new StringTree(descr));
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int i15) {
        StringTree t15 = (StringTree)parent;
        return t15.getChild(i15);
    }

    @Override
    public int getChildCount(Object parent) {
        StringTree t15 = (StringTree)parent;
        return t15.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        StringTree c15 = (StringTree)child;
        return c15.getChildIndex();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object o15) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public static class StringTree
    extends CommonTree {
        String text;

        public StringTree(String text) {
            this.text = text;
        }

        public boolean isNil() {
            return this.text == null;
        }

        public String toString() {
            if (!this.isNil()) {
                return this.text.toString();
            }
            return "nil";
        }
    }
}

