/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import org.drjekyll.fontchooser.FontFamilies;
import org.drjekyll.fontchooser.FontFamily;
import org.drjekyll.fontchooser.model.FontSelectionModel;
import org.drjekyll.fontchooser.panes.StyleCellRenderer;

public class StylePane
extends JScrollPane
implements ChangeListener {
    private static final long serialVersionUID = -176731082795772255L;
    private final JList<Font> styleList = new JList();
    private final DefaultListModel<Font> styleListModel = new DefaultListModel();
    private String family;

    public StylePane() {
        this.styleList.setModel(this.styleListModel);
        this.styleList.getSelectionModel().setSelectionMode(0);
        this.styleList.setCellRenderer(new StyleCellRenderer());
        this.setMinimumSize(new Dimension(140, 50));
        this.setPreferredSize(new Dimension(160, 100));
        this.setViewportView(this.styleList);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.styleList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.styleList.removeListSelectionListener(listener);
    }

    public void setSelectedStyle(Font font) {
        this.styleList.setSelectedValue(font, true);
    }

    public Font getSelectedStyle() {
        return this.styleList.getSelectedValue();
    }

    @Override
    public void stateChanged(ChangeEvent e15) {
        FontSelectionModel fontSelectionModel = (FontSelectionModel)e15.getSource();
        Font selectedFont = fontSelectionModel.getSelectedFont();
        this.loadFamily(selectedFont.getFamily());
    }

    public void loadFamily(String family) {
        if (Objects.equals(this.family, family)) {
            return;
        }
        this.family = family;
        FontFamilies fontFamilies = FontFamilies.getInstance();
        FontFamily fontFamily = fontFamilies.get(family);
        if (fontFamily != null) {
            ListSelectionListener[] selectionListeners = this.styleList.getListSelectionListeners();
            this.removeSelectionListeners(selectionListeners);
            this.updateListModel(fontFamily.getStyles());
            this.addSelectionListeners(selectionListeners);
        }
    }

    private void updateListModel(Iterable<Font> fonts) {
        this.styleListModel.clear();
        for (Font font : fonts) {
            this.styleListModel.addElement(font);
        }
    }

    private void addSelectionListeners(ListSelectionListener[] selectionListeners) {
        for (ListSelectionListener listener : selectionListeners) {
            this.styleList.addListSelectionListener(listener);
        }
    }

    private void removeSelectionListeners(ListSelectionListener[] selectionListeners) {
        for (ListSelectionListener listener : selectionListeners) {
            this.styleList.removeListSelectionListener(listener);
        }
    }
}

