/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.List;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.tool.Attribute;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class NameSpaceChecker {
    protected Grammar grammar;

    public NameSpaceChecker(Grammar grammar) {
        this.grammar = grammar;
    }

    public void checkConflicts() {
        for (int i15 = 1; i15 < this.grammar.composite.ruleIndexToRuleList.size(); ++i15) {
            Rule r15 = this.grammar.composite.ruleIndexToRuleList.elementAt(i15);
            if (r15 == null) continue;
            if (r15.labelNameSpace != null) {
                for (Grammar.LabelElementPair pair : r15.labelNameSpace.values()) {
                    this.checkForLabelConflict(r15, pair.label);
                }
            }
            if (r15.ruleScope != null) {
                List<Attribute> attributes = r15.ruleScope.getAttributes();
                for (int j15 = 0; j15 < attributes.size(); ++j15) {
                    Attribute attribute = attributes.get(j15);
                    this.checkForRuleScopeAttributeConflict(r15, attribute);
                }
            }
            this.checkForRuleDefinitionProblems(r15);
            this.checkForRuleArgumentAndReturnValueConflicts(r15);
        }
        for (AttributeScope scope : this.grammar.getGlobalScopes().values()) {
            this.checkForGlobalScopeTokenConflict(scope);
        }
        this.lookForReferencesToUndefinedSymbols();
    }

    protected void checkForRuleArgumentAndReturnValueConflicts(Rule r15) {
        Set<String> conflictingKeys;
        if (r15.returnScope != null && (conflictingKeys = r15.returnScope.intersection(r15.parameterScope)) != null) {
            for (String key : conflictingKeys) {
                ErrorManager.grammarError(126, this.grammar, r15.tree.getToken(), key, r15.name);
            }
        }
    }

    protected void checkForRuleDefinitionProblems(Rule r15) {
        String ruleName = r15.name;
        Token ruleToken = r15.tree.getToken();
        int msgID = 0;
        if ((this.grammar.type == 2 || this.grammar.type == 3) && Character.isUpperCase(ruleName.charAt(0))) {
            msgID = 102;
        } else if (this.grammar.type == 1 && Character.isLowerCase(ruleName.charAt(0)) && !r15.isSynPred) {
            msgID = 103;
        } else if (this.grammar.getGlobalScope(ruleName) != null) {
            msgID = 118;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, ruleToken, ruleName);
        }
    }

    protected void lookForReferencesToUndefinedSymbols() {
        Rule rule;
        for (GrammarAST refAST : this.grammar.ruleRefs) {
            Token tok = refAST.token;
            String ruleName = tok.getText();
            Rule localRule = this.grammar.getLocallyDefinedRule(ruleName);
            rule = this.grammar.getRule(ruleName);
            if (localRule == null && rule != null) {
                this.grammar.delegatedRuleReferences.add(rule);
                rule.imported = true;
            }
            if (rule != null || this.grammar.getTokenType(ruleName) == -1) continue;
            ErrorManager.grammarError(106, this.grammar, tok, ruleName);
        }
        if (this.grammar.type == 4) {
            for (Token tok : this.grammar.tokenIDRefs) {
                String tokenID = tok.getText();
                if (this.grammar.composite.lexerRules.contains(tokenID) || this.grammar.getTokenType(tokenID) == -1) continue;
                ErrorManager.grammarWarning(105, this.grammar, tok, tokenID);
            }
        }
        for (GrammarAST scopeAST : this.grammar.scopedRuleRefs) {
            Grammar scopeG = this.grammar.composite.getGrammar(scopeAST.getText());
            GrammarAST refAST = (GrammarAST)scopeAST.getChild(1);
            String ruleName = refAST.getText();
            if (scopeG == null) {
                ErrorManager.grammarError(156, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
                continue;
            }
            rule = this.grammar.getRule(scopeG.name, ruleName);
            if (rule != null) continue;
            ErrorManager.grammarError(157, this.grammar, scopeAST.getToken(), scopeAST.getText(), ruleName);
        }
    }

    protected void checkForGlobalScopeTokenConflict(AttributeScope scope) {
        if (this.grammar.getTokenType(scope.getName()) != -7) {
            ErrorManager.grammarError(118, this.grammar, null, scope.getName());
        }
    }

    public void checkForRuleScopeAttributeConflict(Rule r15, Attribute attribute) {
        int msgID = 0;
        String arg2 = null;
        String attrName = attribute.name;
        if (r15.name.equals(attrName)) {
            msgID = 123;
            arg2 = r15.name;
        } else if (r15.returnScope != null && r15.returnScope.getAttribute(attrName) != null || r15.parameterScope != null && r15.parameterScope.getAttribute(attrName) != null) {
            msgID = 124;
            arg2 = r15.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, r15.tree.getToken(), attrName, arg2);
        }
    }

    protected void checkForLabelConflict(Rule r15, Token label) {
        int msgID = 0;
        String arg2 = null;
        if (this.grammar.getGlobalScope(label.getText()) != null) {
            msgID = 118;
        } else if (this.grammar.getRule(label.getText()) != null) {
            msgID = 119;
        } else if (this.grammar.getTokenType(label.getText()) != -7) {
            msgID = 120;
        } else if (r15.ruleScope != null && r15.ruleScope.getAttribute(label.getText()) != null) {
            msgID = 121;
            arg2 = r15.name;
        } else if (r15.returnScope != null && r15.returnScope.getAttribute(label.getText()) != null || r15.parameterScope != null && r15.parameterScope.getAttribute(label.getText()) != null) {
            msgID = 122;
            arg2 = r15.name;
        }
        if (msgID != 0) {
            ErrorManager.grammarError(msgID, this.grammar, label, label.getText(), arg2);
        }
    }

    public boolean checkForLabelTypeMismatch(Rule r15, Token label, int type) {
        Grammar.LabelElementPair prevLabelPair = r15.labelNameSpace.get(label.getText());
        if (prevLabelPair != null && prevLabelPair.type != type) {
            String typeMismatchExpr = Grammar.LabelTypeToString[type] + "!=" + Grammar.LabelTypeToString[prevLabelPair.type];
            ErrorManager.grammarError(125, this.grammar, label, label.getText(), typeMismatchExpr);
            return true;
        }
        return false;
    }
}

