/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings;

import jadx.api.plugins.options.OptionFlag;
import jadx.api.plugins.options.impl.BasePluginOptionsBuilder;
import jadx.core.utils.ListUtils;
import java.util.Locale;
import net.fabricmc.mappingio.format.MappingFormat;
import org.jetbrains.annotations.Nullable;

public class RenameMappingsOptions
extends BasePluginOptionsBuilder {
    public static final String INVERT_OPT = "rename-mappings.invert";
    public static final String FORMAT_OPT = "rename-mappings.format";
    private boolean invert = false;
    @Nullable
    private MappingFormat format = null;

    @Override
    public void registerOptions() {
        this.option(FORMAT_OPT, MappingFormat.class).description("mapping format").parser(RenameMappingsOptions::parseMappingFormat).formatter(v15 -> v15 == null ? "AUTO" : v15.name()).values(ListUtils.concat(null, MappingFormat.values())).defaultValue(null).flags(OptionFlag.PER_PROJECT, OptionFlag.DISABLE_IN_GUI).setter(v15 -> {
            this.format = v15;
        });
        this.boolOption(INVERT_OPT).description("invert mapping on load").defaultValue(false).flags(OptionFlag.PER_PROJECT).setter(v15 -> {
            this.invert = v15;
        });
    }

    private static MappingFormat parseMappingFormat(String name) {
        String upName = name.toUpperCase(Locale.ROOT);
        if (upName.equals("AUTO")) {
            return null;
        }
        return MappingFormat.valueOf(upName);
    }

    @Nullable
    public MappingFormat getFormat() {
        return this.format;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public String getOptionsHashString() {
        return String.valueOf((Object)this.format) + ":" + this.invert;
    }
}

