/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.ISeqConsumer;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.data.ClassOffsets;
import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaFieldData;
import jadx.plugins.input.java.data.JavaMethodData;
import jadx.plugins.input.java.data.JavaMethodRef;
import jadx.plugins.input.java.data.attributes.AttributesReader;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import jadx.plugins.input.java.utils.DisasmUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaClassData
implements IClassData {
    private final JavaClassReader clsReader;
    private final DataReader data;
    private final ClassOffsets offsets;
    private final ConstPoolReader constPoolReader;
    private final AttributesReader attributesReader;

    public JavaClassData(JavaClassReader clsReader) {
        this.clsReader = clsReader;
        this.data = new DataReader(clsReader.getData());
        this.offsets = new ClassOffsets(this.data);
        this.constPoolReader = new ConstPoolReader(clsReader, this, this.data.copy(), this.offsets);
        this.attributesReader = new AttributesReader(this, this.constPoolReader);
    }

    @Override
    public IClassData copy() {
        return this;
    }

    @Override
    public int getAccessFlags() {
        return this.data.absPos(this.offsets.getAccessFlagsOffset()).readU2();
    }

    @Override
    public String getType() {
        int idx = this.data.absPos(this.offsets.getClsTypeOffset()).readU2();
        return this.constPoolReader.getClass(idx);
    }

    @Override
    @Nullable
    public String getSuperType() {
        int idx = this.data.absPos(this.offsets.getSuperTypeOffset()).readU2();
        if (idx == 0) {
            return null;
        }
        return this.constPoolReader.getClass(idx);
    }

    @Override
    public List<String> getInterfacesTypes() {
        this.data.absPos(this.offsets.getInterfacesOffset());
        return this.data.readClassesList(this.constPoolReader);
    }

    @Override
    public String getInputFileName() {
        return this.clsReader.getFileName();
    }

    @Override
    public void visitFieldsAndMethods(ISeqConsumer<IFieldData> fieldsConsumer, ISeqConsumer<IMethodData> mthConsumer) {
        int clsIdx = this.data.absPos(this.offsets.getClsTypeOffset()).readU2();
        String classType = this.constPoolReader.getClass(clsIdx);
        DataReader reader = this.data.absPos(this.offsets.getFieldsOffset()).copy();
        int fieldsCount = reader.readU2();
        fieldsConsumer.init(fieldsCount);
        if (fieldsCount != 0) {
            JavaFieldData field = new JavaFieldData();
            field.setParentClassType(classType);
            for (int i15 = 0; i15 < fieldsCount; ++i15) {
                this.parseField(reader, field);
                fieldsConsumer.accept(field);
            }
        }
        int methodsCount = reader.readU2();
        mthConsumer.init(methodsCount);
        if (methodsCount != 0) {
            JavaMethodRef methodRef = new JavaMethodRef();
            methodRef.setParentClassType(classType);
            JavaMethodData method = new JavaMethodData(this, methodRef);
            for (int i16 = 0; i16 < methodsCount; ++i16) {
                this.parseMethod(reader, method, i16);
                mthConsumer.accept(method);
            }
        }
    }

    private void parseField(DataReader reader, JavaFieldData field) {
        int accessFlags = reader.readU2();
        int nameIdx = reader.readU2();
        int typeIdx = reader.readU2();
        JavaAttrStorage attributes = this.attributesReader.loadAll(reader);
        field.setAccessFlags(accessFlags);
        field.setName(this.constPoolReader.getUtf8(nameIdx));
        field.setType(this.constPoolReader.getUtf8(typeIdx));
        field.setAttributes(attributes);
    }

    private void parseMethod(DataReader reader, JavaMethodData method, int id5) {
        int accessFlags = reader.readU2();
        int nameIdx = reader.readU2();
        int descriptorIdx = reader.readU2();
        JavaAttrStorage attributes = this.attributesReader.loadAll(reader);
        JavaMethodRef methodRef = method.getMethodRef();
        methodRef.reset();
        methodRef.initUniqId(this.clsReader, id5, false);
        methodRef.setName(this.constPoolReader.getUtf8(nameIdx));
        methodRef.setDescr(this.constPoolReader.getUtf8(descriptorIdx));
        if (methodRef.getName().equals("<init>")) {
            accessFlags |= 0x10000;
        }
        method.setData(accessFlags, attributes);
    }

    public DataReader getData() {
        return this.data;
    }

    @Override
    public List<IJadxAttribute> getAttributes() {
        this.data.absPos(this.offsets.getAttributesOffset());
        JavaAttrStorage attributes = this.attributesReader.loadAll(this.data);
        int size = attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<IJadxAttribute> list2 = new ArrayList<IJadxAttribute>(size);
        Utils.addToList(list2, JavaAnnotationsAttr.merge(attributes));
        Utils.addToList(list2, (IJadxAttribute)attributes.get(JavaAttrType.INNER_CLASSES));
        Utils.addToList(list2, (IJadxAttribute)attributes.get(JavaAttrType.SOURCE_FILE));
        Utils.addToList(list2, (IJadxAttribute)attributes.get(JavaAttrType.SIGNATURE));
        return list2;
    }

    public <T extends IJavaAttribute> T loadClassAttribute(DataReader reader, JavaAttrType<T> type) {
        reader.absPos(this.offsets.getAttributesOffset());
        return this.attributesReader.loadOne(reader, type);
    }

    @Override
    public String getDisassembledCode() {
        return DisasmUtils.get(this.data.getBytes());
    }

    public JavaClassReader getClsReader() {
        return this.clsReader;
    }

    public ClassOffsets getOffsets() {
        return this.offsets;
    }

    public ConstPoolReader getConstPoolReader() {
        return this.constPoolReader;
    }

    public AttributesReader getAttributesReader() {
        return this.attributesReader;
    }

    public String toString() {
        return this.getInputFileName();
    }
}

