/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.core.utils.StringUtils;
import jadx.gui.device.debugger.DebugController;
import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.ui.dialog.ADBDialog;
import jadx.gui.ui.panel.IDebugController;
import jadx.gui.ui.panel.LogcatPanel;
import jadx.gui.ui.popupmenu.VarTreePopupMenu;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDebuggerPanel
extends JPanel {
    private static final long serialVersionUID = -1111111202102181631L;
    private static final Logger LOG = LoggerFactory.getLogger(LogcatPanel.class);
    private static final ImageIcon ICON_RUN = UiUtils.openSvgIcon("debugger/execute");
    private static final ImageIcon ICON_RERUN = UiUtils.openSvgIcon("debugger/rerun");
    private static final ImageIcon ICON_PAUSE = UiUtils.openSvgIcon("debugger/threadFrozen");
    private static final ImageIcon ICON_STOP = UiUtils.openSvgIcon("debugger/suspend");
    private static final ImageIcon ICON_STOP_GRAY = UiUtils.openSvgIcon("debugger/suspendGray");
    private static final ImageIcon ICON_STEP_INTO = UiUtils.openSvgIcon("debugger/traceInto");
    private static final ImageIcon ICON_STEP_OVER = UiUtils.openSvgIcon("debugger/traceOver");
    private static final ImageIcon ICON_STEP_OUT = UiUtils.openSvgIcon("debugger/stepOut");
    private final transient MainWindow mainWindow;
    private final transient JList<IListElement> stackFrameList;
    private final transient JComboBox<IListElement> threadBox;
    private final transient JTextArea logger;
    private final transient JTree variableTree;
    private final transient DefaultTreeModel variableTreeModel;
    private final transient DefaultMutableTreeNode rootTreeNode;
    private final transient DefaultMutableTreeNode thisTreeNode;
    private final transient DefaultMutableTreeNode regTreeNode;
    private final transient JSplitPane rightSplitter;
    private final transient JSplitPane leftSplitter;
    private final transient IDebugController controller;
    private final LogcatPanel logcatPanel;
    private final transient VarTreePopupMenu varTreeMenu;
    private transient KeyEventDispatcher controllerShortCutDispatcher;

    public JDebuggerPanel(final MainWindow mainWindow) {
        UiUtils.uiThreadGuard();
        this.mainWindow = mainWindow;
        this.controller = new DebugController();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 150));
        this.leftSplitter = new JSplitPane();
        this.rightSplitter = new JSplitPane();
        this.leftSplitter.setDividerLocation(mainWindow.getSettings().getDebuggerStackFrameSplitterLoc());
        this.rightSplitter.setDividerLocation(mainWindow.getSettings().getDebuggerVarTreeSplitterLoc());
        JPanel stackFramePanel = new JPanel(new BorderLayout());
        this.threadBox = new JComboBox();
        this.stackFrameList = new JList();
        this.threadBox.setModel(new DefaultComboBoxModel());
        this.stackFrameList.setModel(new DefaultListModel());
        stackFramePanel.add(this.threadBox, "North");
        stackFramePanel.add((Component)new JScrollPane(this.stackFrameList), "Center");
        JPanel variablePanel = new JPanel(new CardLayout());
        this.variableTree = new JTree();
        variablePanel.add(new JScrollPane(this.variableTree));
        this.rootTreeNode = new DefaultMutableTreeNode();
        this.thisTreeNode = new DefaultMutableTreeNode("this");
        this.regTreeNode = new DefaultMutableTreeNode("var");
        this.rootTreeNode.add(this.thisTreeNode);
        this.rootTreeNode.add(this.regTreeNode);
        this.variableTreeModel = new DefaultTreeModel(this.rootTreeNode);
        this.variableTree.setModel(this.variableTreeModel);
        this.variableTree.expandPath(new TreePath(this.rootTreeNode.getPath()));
        this.variableTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -1111111202103170725L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c15 = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof ValueTreeNode && ((ValueTreeNode)value).isUpdated()) {
                    this.setForeground(Color.RED);
                }
                return c15;
            }
        });
        this.varTreeMenu = new VarTreePopupMenu(mainWindow);
        JTabbedPane loggerPanel = new JTabbedPane();
        this.logger = new JTextArea();
        this.logger.setEditable(false);
        this.logger.setLineWrap(true);
        JScrollPane loggerScroll = new JScrollPane(this.logger);
        loggerPanel.addTab("Debugger Log", null, loggerScroll, null);
        this.logcatPanel = new LogcatPanel(this);
        loggerPanel.addTab(NLS.str("logcat.logcat"), null, this.logcatPanel, null);
        this.leftSplitter.setLeftComponent(stackFramePanel);
        this.leftSplitter.setRightComponent(this.rightSplitter);
        this.leftSplitter.setResizeWeight(0.15);
        this.rightSplitter.setLeftComponent(variablePanel);
        this.rightSplitter.setRightComponent(loggerPanel);
        this.rightSplitter.setResizeWeight(0.15);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)new Label(), "West");
        headerPanel.add((Component)this.initToolBar(), "Center");
        JButton closeBtn = new JButton(UiUtils.openSvgIcon("ui/close"));
        closeBtn.addMouseListener(new MouseAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void mouseClicked(MouseEvent e15) {
                if (JDebuggerPanel.this.controller.isDebugging()) {
                    int what = JOptionPane.showConfirmDialog(mainWindow, NLS.str("debugger.cfm_dialog_msg"), NLS.str("debugger.cfm_dialog_title"), 2);
                    if (what != 0) return;
                    JDebuggerPanel.this.controller.exit();
                    JDebuggerPanel.this.logcatPanel.exit();
                } else {
                    mainWindow.destroyDebuggerPanel();
                }
                JDebuggerPanel.this.unregShortcuts();
            }
        });
        headerPanel.add((Component)closeBtn, "East");
        this.add((Component)headerPanel, "North");
        this.add((Component)this.leftSplitter, "Center");
        this.listenUIEvents();
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    private void listenUIEvents() {
        this.stackFrameList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e15) {
                if (e15.getClickCount() % 2 == 0) {
                    JDebuggerPanel.this.stackFrameSelected(e15.getPoint());
                }
            }
        });
        this.variableTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e15) {
                if (SwingUtilities.isRightMouseButton(e15)) {
                    JDebuggerPanel.this.treeNodeRightClicked(e15);
                }
            }
        });
    }

    private JToolBar initToolBar() {
        AbstractAction stepOver = new AbstractAction(NLS.str("debugger.step_over"), ICON_STEP_OVER){
            private static final long serialVersionUID = -1111111202103170726L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                JDebuggerPanel.this.controller.stepOver();
            }
        };
        stepOver.putValue("ShortDescription", NLS.str("debugger.step_over"));
        AbstractAction stepInto = new AbstractAction(NLS.str("debugger.step_into"), ICON_STEP_INTO){
            private static final long serialVersionUID = -1111111202103170727L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                JDebuggerPanel.this.controller.stepInto();
            }
        };
        stepInto.putValue("ShortDescription", NLS.str("debugger.step_into"));
        AbstractAction stepOut = new AbstractAction(NLS.str("debugger.step_out"), ICON_STEP_OUT){
            private static final long serialVersionUID = -1111111202103170728L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                JDebuggerPanel.this.controller.stepOut();
            }
        };
        stepOut.putValue("ShortDescription", NLS.str("debugger.step_out"));
        final AbstractAction stop = new AbstractAction(NLS.str("debugger.stop"), ICON_STOP_GRAY){
            private static final long serialVersionUID = -1111111202103170728L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                JDebuggerPanel.this.controller.stop();
            }
        };
        stop.putValue("ShortDescription", NLS.str("debugger.stop"));
        final AbstractAction run = new AbstractAction(NLS.str("debugger.run"), ICON_RUN){
            private static final long serialVersionUID = -1111111202103170728L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                if (JDebuggerPanel.this.controller.isDebugging()) {
                    if (JDebuggerPanel.this.controller.isSuspended()) {
                        JDebuggerPanel.this.controller.run();
                    } else {
                        JDebuggerPanel.this.controller.pause();
                    }
                }
            }
        };
        run.putValue("ShortDescription", NLS.str("debugger.run"));
        AbstractAction rerun = new AbstractAction(NLS.str("debugger.rerun"), ICON_RERUN){
            private static final long serialVersionUID = -1111111202103210433L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                String pkgName;
                if (JDebuggerPanel.this.controller.isDebugging()) {
                    JDebuggerPanel.this.controller.stop();
                }
                if ((pkgName = JDebuggerPanel.this.controller.getProcessName()).isEmpty() || !ADBDialog.launchForDebugging(JDebuggerPanel.this.mainWindow, pkgName, true)) {
                    new ADBDialog(JDebuggerPanel.this.mainWindow).setVisible(true);
                }
            }
        };
        rerun.putValue("ShortDescription", NLS.str("debugger.rerun"));
        this.controller.setStateListener(new IDebugController.StateListener(){
            boolean isGray = true;

            @Override
            public void onStateChanged(boolean suspended, boolean stopped) {
                UiUtils.uiRun(() -> {
                    if (!stopped) {
                        if (this.isGray) {
                            stop.putValue("SmallIcon", ICON_STOP);
                        }
                    } else {
                        stop.putValue("SmallIcon", ICON_STOP_GRAY);
                        run.putValue("SmallIcon", ICON_RUN);
                        run.putValue("ShortDescription", NLS.str("debugger.run"));
                        this.isGray = true;
                        return;
                    }
                    if (suspended) {
                        run.putValue("SmallIcon", ICON_RUN);
                        run.putValue("ShortDescription", NLS.str("debugger.run"));
                    } else {
                        run.putValue("SmallIcon", ICON_PAUSE);
                        run.putValue("ShortDescription", NLS.str("debugger.pause"));
                    }
                });
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.add(new Label());
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(rerun);
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(stop);
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(run);
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(stepOver);
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(stepInto);
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(stepOut);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(new Label());
        this.regShortcuts();
        return toolBar;
    }

    private void unregShortcuts() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.controllerShortCutDispatcher);
    }

    private void regShortcuts() {
        this.controllerShortCutDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e15) {
                if (e15.getID() == 401 && JDebuggerPanel.this.mainWindow.getTabbedPane().getFocusedComp() instanceof SmaliArea) {
                    if (e15.getModifiersEx() == 64 && e15.getKeyCode() == 119) {
                        JDebuggerPanel.this.controller.stepOut();
                        return true;
                    }
                    switch (e15.getKeyCode()) {
                        case 118: {
                            JDebuggerPanel.this.controller.stepInto();
                            return true;
                        }
                        case 119: {
                            JDebuggerPanel.this.controller.stepOver();
                            return true;
                        }
                        case 120: {
                            JDebuggerPanel.this.controller.run();
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.controllerShortCutDispatcher);
    }

    private void treeNodeRightClicked(MouseEvent e15) {
        Object node;
        TreePath path = this.variableTree.getPathForLocation(e15.getX(), e15.getY());
        if (path != null && (node = path.getLastPathComponent()) instanceof ValueTreeNode) {
            this.varTreeMenu.show((ValueTreeNode)node, e15.getComponent(), e15.getX(), e15.getY());
        }
    }

    private void stackFrameSelected(Point p15) {
        IListElement ele;
        int loc = this.stackFrameList.locationToIndex(p15);
        if (loc > -1 && (ele = this.stackFrameList.getModel().getElementAt(loc)) != null) {
            ele.onSelected();
        }
    }

    public boolean showDebugger(String procName, String host, int port, int androidVer, ADBDevice device, String pid) {
        boolean ok4 = this.controller.startDebugger(this, host, port, androidVer);
        if (ok4) {
            UiUtils.uiRun(() -> {
                this.log(String.format("Attached %s %s:%d", procName, host, port));
                try {
                    this.logcatPanel.init(device, pid);
                }
                catch (Exception e15) {
                    this.log(NLS.str("logcat.error_fail_start"));
                    LOG.error("Logcat failed to start", e15);
                }
                this.leftSplitter.setDividerLocation(this.mainWindow.getSettings().getDebuggerStackFrameSplitterLoc());
                this.rightSplitter.setDividerLocation(this.mainWindow.getSettings().getDebuggerVarTreeSplitterLoc());
                this.mainWindow.showDebuggerPanel();
            });
        }
        return ok4;
    }

    public IDebugController getDbgController() {
        return this.controller;
    }

    public int getLeftSplitterLocation() {
        return this.leftSplitter.getDividerLocation();
    }

    public int getRightSplitterLocation() {
        return this.rightSplitter.getDividerLocation();
    }

    public void loadSettings() {
        UiUtils.uiThreadGuard();
        Font font = this.mainWindow.getSettings().getCodeFont();
        this.variableTree.setFont(font.deriveFont((float)font.getSize() + 1.0f));
        this.variableTree.setRowHeight(-1);
        this.stackFrameList.setFont(font);
        this.threadBox.setFont(font);
        this.logger.setFont(font);
    }

    public void resetUI() {
        UiUtils.uiThreadGuard();
        this.thisTreeNode.removeAllChildren();
        this.regTreeNode.removeAllChildren();
        this.clearFrameAndThreadList();
        this.threadBox.updateUI();
        this.stackFrameList.updateUI();
        this.variableTreeModel.reload(this.rootTreeNode);
        this.variableTree.expandPath(new TreePath(this.rootTreeNode.getPath()));
        this.logger.setText("");
    }

    public void scrollToSmaliLine(JClass cls, int pos, boolean debugMode) {
        SwingUtilities.invokeLater(() -> this.getMainWindow().getTabsController().smaliJump(cls, pos, debugMode));
    }

    public void resetAllDebuggingInfo() {
        this.clearFrameAndThreadList();
        this.resetRegTreeNodes();
        this.resetThisTreeNodes();
    }

    public void resetThisTreeNodes() {
        this.thisTreeNode.removeAllChildren();
        SwingUtilities.invokeLater(() -> this.variableTreeModel.reload(this.thisTreeNode));
    }

    public void resetRegTreeNodes() {
        this.regTreeNode.removeAllChildren();
        SwingUtilities.invokeLater(() -> this.variableTreeModel.reload(this.regTreeNode));
    }

    public void updateRegTreeNodes(List<? extends ValueTreeNode> nodes) {
        nodes.forEach(this.regTreeNode::add);
    }

    public void updateThisFieldNodes(List<? extends ValueTreeNode> nodes) {
        nodes.forEach(this.thisTreeNode::add);
    }

    public void refreshThreadBox(List<? extends IListElement> elements) {
        UiUtils.uiRun(() -> {
            if (!elements.isEmpty()) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.threadBox.getModel();
                elements.forEach(model::addElement);
            }
            this.threadBox.updateUI();
            this.stackFrameList.setFont(this.mainWindow.getSettings().getCodeFont());
        });
    }

    public void refreshStackFrameList(List<? extends IListElement> elements) {
        if (elements.size() > 0) {
            DefaultListModel model = (DefaultListModel)this.stackFrameList.getModel();
            elements.forEach(model::addElement);
            this.stackFrameList.setFont(this.mainWindow.getSettings().getCodeFont());
        }
        SwingUtilities.invokeLater(this.stackFrameList::repaint);
    }

    public void refreshRegisterTree() {
        SwingUtilities.invokeLater(() -> {
            this.variableTreeModel.reload(this.regTreeNode);
            this.variableTree.expandPath(new TreePath(this.regTreeNode.getPath()));
        });
    }

    public void refreshThisFieldTree() {
        SwingUtilities.invokeLater(() -> {
            boolean expanded = this.variableTree.isExpanded(new TreePath(this.thisTreeNode.getPath()));
            this.variableTreeModel.reload(this.thisTreeNode);
            if (expanded) {
                this.variableTree.expandPath(new TreePath(this.regTreeNode.getPath()));
            }
        });
    }

    public void clearFrameAndThreadList() {
        ((DefaultListModel)this.stackFrameList.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.threadBox.getModel()).removeAllElements();
    }

    public void log(String msg) {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(" > ").append(StringUtils.getDateText()).append(" ").append(msg).append("\n");
        SwingUtilities.invokeLater(() -> this.logger.append(sb5.toString()));
    }

    public void updateRegTree(ValueTreeNode node) {
        SwingUtilities.invokeLater(() -> {
            this.variableTreeModel.reload(this.regTreeNode);
            this.scrollToUpdatedNode(node);
        });
    }

    public void updateThisTree(ValueTreeNode node) {
        SwingUtilities.invokeLater(() -> {
            this.variableTreeModel.reload(this.thisTreeNode);
            this.scrollToUpdatedNode(node);
        });
    }

    public void scrollToUpdatedNode(ValueTreeNode node) {
        SwingUtilities.invokeLater(() -> {
            Object[] path = node.getPath();
            this.variableTree.scrollPathToVisible(new TreePath(path));
        });
    }

    public static abstract class ValueTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1111111202103122236L;
        private boolean updated;

        public void setUpdated(boolean updated) {
            this.updated = updated;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public abstract String getName();

        @Nullable
        public abstract String getValue();

        @Nullable
        public abstract String getType();

        public abstract long getTypeID();

        public abstract ValueTreeNode updateValue(String var1);

        public abstract ValueTreeNode updateType(String var1);

        public abstract ValueTreeNode updateTypeID(long var1);

        @Override
        public String toString() {
            String type;
            StringBuilder sb5 = new StringBuilder();
            sb5.append(this.getName());
            String val = this.getValue();
            if (val != null) {
                sb5.append(" val: ").append(val).append(",");
            }
            if ((type = this.getType()) != null) {
                sb5.append(" type: ").append(this.getType());
                long id5 = this.getTypeID();
                if (id5 > 0L) {
                    sb5.append("@").append(id5);
                }
            }
            if (val == null && type == null) {
                sb5.append(" undefined");
            }
            return sb5.toString();
        }
    }

    public static interface IListElement {
        public void onSelected();
    }
}

