/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.tab.TabsController;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPanel.class);
    private static final long serialVersionUID = 3237031760631677822L;
    protected TabbedPane tabbedPane;
    protected JNode node;

    protected ContentPanel(TabbedPane panel, JNode node) {
        this.tabbedPane = panel;
        this.node = node;
    }

    public abstract void loadSettings();

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public TabsController getTabsController() {
        return this.tabbedPane.getTabsController();
    }

    public MainWindow getMainWindow() {
        return this.tabbedPane.getMainWindow();
    }

    public JNode getNode() {
        return this.node;
    }

    public void scrollToPos(int pos) {
        LOG.warn("ContentPanel.scrollToPos method not implemented, class: {}", (Object)this.getClass().getSimpleName());
    }

    public JadxSettings getSettings() {
        return this.tabbedPane.getMainWindow().getSettings();
    }

    public boolean supportsQuickTabs() {
        return this.getNode().supportsQuickTabs();
    }

    public void dispose() {
        this.tabbedPane = null;
        this.node = null;
    }
}

