/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.cache;

import jadx.api.plugins.gui.ISettingsGroup;
import jadx.gui.cache.code.CodeCacheMode;
import jadx.gui.cache.usage.UsageCacheMode;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.ui.JadxSettingsWindow;
import jadx.gui.settings.ui.SettingsGroup;
import jadx.gui.settings.ui.cache.CachesTable;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.files.JadxFiles;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class CacheSettingsGroup
implements ISettingsGroup {
    private final String title = NLS.str("preferences.cache");
    private final JadxSettingsWindow settingsWindow;
    private JTextField customDirField;
    private JButton selectDirBtn;

    public CacheSettingsGroup(JadxSettingsWindow settingsWindow) {
        this.settingsWindow = settingsWindow;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JComponent buildComponent() {
        JPanel options = new JPanel();
        options.setLayout(new BoxLayout(options, 3));
        options.add(this.buildBaseOptions());
        options.add(this.buildLocationSelector());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)options, "First");
        mainPanel.add((Component)this.buildCachesView(), "Center");
        return mainPanel;
    }

    private JPanel buildCachesView() {
        CachesTable cachesTable = new CachesTable(this.settingsWindow.getMainWindow());
        JScrollPane scrollPane = new JScrollPane(cachesTable);
        cachesTable.setFillsViewportHeight(true);
        cachesTable.updateData();
        JButton calcUsage = new JButton(NLS.str("preferences.cache.btn.usage"));
        calcUsage.addActionListener(ev4 -> cachesTable.updateSizes());
        JButton deleteSelected = new JButton(NLS.str("preferences.cache.btn.delete_selected"));
        deleteSelected.addActionListener(ev4 -> cachesTable.deleteSelected());
        JButton deleteAll = new JButton(NLS.str("preferences.cache.btn.delete_all"));
        deleteAll.addActionListener(ev4 -> cachesTable.deleteAll());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttons.add(calcUsage);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(deleteSelected);
        buttons.add(deleteAll);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(NLS.str("preferences.cache.table.title")));
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)buttons, "Last");
        return panel;
    }

    private JComponent buildLocationSelector() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(NLS.str("preferences.cache.location")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.customDirField = new JTextField();
        this.customDirField.setColumns(10);
        this.customDirField.getDocument().addDocumentListener(new DocumentUpdateListener(ev4 -> this.settingsWindow.getMainWindow().getSettings().setCacheDir(this.customDirField.getText())));
        this.selectDirBtn = new JButton();
        this.selectDirBtn.setIcon(UIManager.getIcon("Tree.closedIcon"));
        this.selectDirBtn.addActionListener(e15 -> {
            FileDialogWrapper fd5 = new FileDialogWrapper(this.settingsWindow.getMainWindow(), FileOpenMode.CUSTOM_OPEN);
            fd5.setFileExtList(Collections.emptyList());
            fd5.setSelectionMode(1);
            List<Path> paths = fd5.show();
            if (!paths.isEmpty()) {
                String dir = paths.get(0).toAbsolutePath().toString();
                this.customDirField.setText(dir);
                this.settingsWindow.getMainWindow().getSettings().setCacheDir(dir);
            }
        });
        JRadioButton defOpt = new JRadioButton(NLS.str("preferences.cache.location_default"));
        defOpt.setToolTipText(JadxFiles.CACHE_DIR.toString());
        defOpt.addActionListener(e15 -> this.changeCacheLocation(null));
        JRadioButton localOpt = new JRadioButton(NLS.str("preferences.cache.location_local"));
        localOpt.addActionListener(e15 -> this.changeCacheLocation("."));
        JRadioButton customOpt = new JRadioButton(NLS.str("preferences.cache.location_custom"));
        customOpt.addActionListener(e15 -> this.changeCacheLocation(""));
        ButtonGroup group = new ButtonGroup();
        group.add(defOpt);
        group.add(localOpt);
        group.add(customOpt);
        panel.add(defOpt);
        panel.add(localOpt);
        JPanel custom = new JPanel();
        custom.setLayout(new BoxLayout(custom, 2));
        custom.add(customOpt);
        custom.add(Box.createHorizontalStrut(15));
        custom.add(this.customDirField);
        custom.add(this.selectDirBtn);
        panel.add(custom);
        String cacheDir = this.settingsWindow.getMainWindow().getSettings().getCacheDir();
        if (cacheDir == null) {
            defOpt.setSelected(true);
            this.changeCacheLocation(null);
        } else if (cacheDir.equals(".")) {
            localOpt.setSelected(true);
            this.changeCacheLocation(cacheDir);
        } else {
            customOpt.setSelected(true);
            this.customDirField.setText(cacheDir);
            this.changeCacheLocation("");
        }
        JLabel notice = new JLabel(NLS.str("preferences.cache.change_notice"));
        notice.setEnabled(false);
        panel.add(notice);
        return panel;
    }

    private void changeCacheLocation(@Nullable String locValue) {
        boolean custom = Objects.equals(locValue, "");
        this.customDirField.setEnabled(custom);
        this.selectDirBtn.setEnabled(custom);
        if (!custom) {
            this.settingsWindow.getMainWindow().getSettings().setCacheDir(locValue);
        }
    }

    private JComponent buildBaseOptions() {
        JadxSettings settings = this.settingsWindow.getMainWindow().getSettings();
        JComboBox<CodeCacheMode> codeCacheModeComboBox = new JComboBox<CodeCacheMode>(CodeCacheMode.values());
        codeCacheModeComboBox.setSelectedItem((Object)settings.getCodeCacheMode());
        codeCacheModeComboBox.addActionListener(e15 -> {
            settings.setCodeCacheMode((CodeCacheMode)((Object)((Object)codeCacheModeComboBox.getSelectedItem())));
            this.settingsWindow.needReload();
        });
        JComboBox<UsageCacheMode> usageCacheModeComboBox = new JComboBox<UsageCacheMode>(UsageCacheMode.values());
        usageCacheModeComboBox.setSelectedItem((Object)settings.getUsageCacheMode());
        usageCacheModeComboBox.addActionListener(e15 -> {
            settings.setUsageCacheMode((UsageCacheMode)((Object)((Object)usageCacheModeComboBox.getSelectedItem())));
            this.settingsWindow.needReload();
        });
        SettingsGroup group = new SettingsGroup(this.title);
        group.addRow(NLS.str("preferences.codeCacheMode"), CodeCacheMode.buildToolTip(), codeCacheModeComboBox);
        group.addRow(NLS.str("preferences.usageCacheMode"), usageCacheModeComboBox);
        return group.buildComponent();
    }
}

