/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.utils.tasks.ITaskExecutor;
import jadx.core.utils.tasks.TaskExecutor;
import jadx.gui.jobs.CancelableBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.utils.NLS;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LoadTask<T>
extends CancelableBackgroundTask {
    private final String title;
    private final AtomicReference<T> taskData;
    private final Runnable bgTask;
    private final Runnable uiTask;

    public LoadTask(Supplier<T> loadBgTask, Consumer<T> uiTask) {
        this(NLS.str("progress.load"), loadBgTask, uiTask);
    }

    public LoadTask(String title, Supplier<T> loadBgTask, Consumer<T> uiTask) {
        this.title = title;
        this.taskData = new AtomicReference();
        this.bgTask = () -> this.taskData.set(loadBgTask.get());
        this.uiTask = () -> uiTask.accept(this.taskData.get());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ITaskExecutor scheduleTasks() {
        TaskExecutor executor = new TaskExecutor();
        executor.addSequentialTask(this.bgTask);
        return executor;
    }

    @Override
    public void onFinish(ITaskInfo taskInfo) {
        this.uiTask.run();
    }
}

