/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.ICodeWriter;
import jadx.api.impl.SimpleCodeWriter;
import jadx.core.codegen.MethodGen;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.SaveCode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;

public class DotGraphVisitor
extends AbstractVisitor {
    private static final String NL = "\\l";
    private static final String NLQR = Matcher.quoteReplacement("\\l");
    private static final boolean PRINT_DOMINATORS = false;
    private static final boolean PRINT_DOMINATORS_INFO = false;
    private final boolean useRegions;
    private final boolean rawInsn;

    public static DotGraphVisitor dump() {
        return new DotGraphVisitor(false, false);
    }

    public static DotGraphVisitor dumpRaw() {
        return new DotGraphVisitor(false, true);
    }

    public static DotGraphVisitor dumpRegions() {
        return new DotGraphVisitor(true, false);
    }

    public static DotGraphVisitor dumpRawRegions() {
        return new DotGraphVisitor(true, true);
    }

    private DotGraphVisitor(boolean useRegions, boolean rawInsn) {
        this.useRegions = useRegions;
        this.rawInsn = rawInsn;
    }

    @Override
    public String getName() {
        return "DotGraphVisitor";
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        File outRootDir = mth.root().getArgs().getOutDir();
        new DumpDotGraph(outRootDir).process(mth);
    }

    public void save(File dir, MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        new DumpDotGraph(dir).process(mth);
    }

    private class DumpDotGraph {
        private final ICodeWriter dot = new SimpleCodeWriter();
        private final ICodeWriter conn = new SimpleCodeWriter();
        private final File dir;

        public DumpDotGraph(File dir) {
            this.dir = dir;
        }

        public void process(MethodNode mth) {
            this.dot.startLine("digraph \"CFG for");
            this.dot.add(this.escape(mth.getMethodInfo().getFullId()));
            this.dot.add("\" {");
            BlockNode enterBlock = mth.getEnterBlock();
            if (DotGraphVisitor.this.useRegions) {
                if (mth.getRegion() == null) {
                    return;
                }
                this.processMethodRegion(mth);
            } else {
                List<BlockNode> blocks = mth.getBasicBlocks();
                if (blocks == null) {
                    InsnNode[] insnArr = mth.getInstructions();
                    if (insnArr == null) {
                        return;
                    }
                    BlockNode block = new BlockNode(0, 0, 0);
                    List<InsnNode> insnList = block.getInstructions();
                    for (Object object : insnArr) {
                        if (object == null) continue;
                        insnList.add((InsnNode)object);
                    }
                    enterBlock = block;
                    blocks = Collections.singletonList(block);
                }
                for (BlockNode block : blocks) {
                    this.processBlock(mth, block, false);
                }
            }
            this.dot.startLine("MethodNode[shape=record,label=\"{");
            this.dot.add(this.escape(mth.getAccessFlags().makeString(true)));
            this.dot.add(this.escape(String.valueOf(mth.getReturnType()) + " " + String.valueOf(mth.getParentClass()) + "." + mth.getName() + "(" + Utils.listToString(mth.getAllArgRegs()) + ") "));
            String attrs = this.attributesString(mth);
            if (!attrs.isEmpty()) {
                this.dot.add(" | ").add(attrs);
            }
            this.dot.add("}\"];");
            this.dot.startLine("MethodNode -> ").add(this.makeName(enterBlock)).add(';');
            this.dot.add(this.conn.toString());
            this.dot.startLine('}');
            this.dot.startLine();
            String fileName = StringUtils.escape(mth.getMethodInfo().getShortId()) + (DotGraphVisitor.this.useRegions ? ".regions" : "") + (DotGraphVisitor.this.rawInsn ? ".raw" : "") + ".dot";
            File file2 = this.dir.toPath().resolve(mth.getParentClass().getClassInfo().getAliasFullPath() + "_graphs").resolve(fileName).toFile();
            SaveCode.save(this.dot.finish(), file2);
        }

        private void processMethodRegion(MethodNode mth) {
            this.processRegion(mth, mth.getRegion());
            for (ExceptionHandler h15 : mth.getExceptionHandlers()) {
                if (h15.getHandlerRegion() == null) continue;
                this.processRegion(mth, h15.getHandlerRegion());
            }
            HashSet<IBlock> regionsBlocks = new HashSet<IBlock>(mth.getBasicBlocks().size());
            RegionUtils.getAllRegionBlocks(mth.getRegion(), regionsBlocks);
            for (ExceptionHandler handler : mth.getExceptionHandlers()) {
                IContainer handlerRegion = handler.getHandlerRegion();
                if (handlerRegion == null) continue;
                RegionUtils.getAllRegionBlocks(handlerRegion, regionsBlocks);
            }
            for (BlockNode block : mth.getBasicBlocks()) {
                if (regionsBlocks.contains(block)) continue;
                this.processBlock(mth, block, true);
            }
        }

        private void processRegion(MethodNode mth, IContainer region) {
            if (region instanceof IRegion) {
                IRegion r15 = (IRegion)region;
                this.dot.startLine("subgraph " + this.makeName(region) + " {");
                this.dot.startLine("label = \"").add(r15.toString());
                String attrs = this.attributesString(r15);
                if (!attrs.isEmpty()) {
                    this.dot.add(" | ").add(attrs);
                }
                this.dot.add("\";");
                this.dot.startLine("node [shape=record,color=blue];");
                for (IContainer c15 : r15.getSubBlocks()) {
                    this.processRegion(mth, c15);
                }
                this.dot.startLine('}');
            } else if (region instanceof BlockNode) {
                this.processBlock(mth, (BlockNode)region, false);
            } else if (region instanceof IBlock) {
                this.processIBlock(mth, (IBlock)region, false);
            }
        }

        private void processBlock(MethodNode mth, BlockNode block, boolean error) {
            String insns;
            String attrs = this.attributesString(block);
            this.dot.startLine(this.makeName(block));
            this.dot.add(" [shape=record,");
            if (error) {
                this.dot.add("color=red,");
            }
            this.dot.add("label=\"{");
            this.dot.add(String.valueOf(block.getCId())).add("\\:\\ ");
            this.dot.add(InsnUtils.formatOffset(block.getStartOffset()));
            if (!attrs.isEmpty()) {
                this.dot.add('|').add(attrs);
            }
            if (!(insns = this.insertInsns(mth, block)).isEmpty()) {
                this.dot.add('|').add(insns);
            }
            this.dot.add("}\"];");
            BlockNode falsePath = null;
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn != null && lastInsn.getType() == InsnType.IF) {
                falsePath = ((IfNode)lastInsn).getElseBlock();
            }
            for (BlockNode next : block.getSuccessors()) {
                String style = next == falsePath ? "[style=dashed]" : "";
                this.addEdge(block, next, style);
            }
        }

        private void processIBlock(MethodNode mth, IBlock block, boolean error) {
            String insns;
            String attrs = this.attributesString(block);
            this.dot.startLine(this.makeName(block));
            this.dot.add(" [shape=record,");
            if (error) {
                this.dot.add("color=red,");
            }
            this.dot.add("label=\"{");
            if (!attrs.isEmpty()) {
                this.dot.add(attrs);
            }
            if (!(insns = this.insertInsns(mth, block)).isEmpty()) {
                this.dot.add('|').add(insns);
            }
            this.dot.add("}\"];");
        }

        private void addEdge(BlockNode from, BlockNode to4, String style) {
            this.conn.startLine(this.makeName(from)).add(" -> ").add(this.makeName(to4));
            this.conn.add(style);
            this.conn.add(';');
        }

        private String attributesString(IAttributeNode block) {
            StringBuilder attrs = new StringBuilder();
            for (String attr : block.getAttributesStringsList()) {
                attrs.append(this.escape(attr)).append(DotGraphVisitor.NL);
            }
            return attrs.toString();
        }

        private String makeName(IContainer c15) {
            String name = c15 instanceof BlockNode ? "Node_" + ((BlockNode)c15).getCId() : (c15 instanceof IBlock ? "Node_" + c15.getClass().getSimpleName() + "_" + c15.hashCode() : "cluster_" + c15.getClass().getSimpleName() + "_" + c15.hashCode());
            return name;
        }

        private String insertInsns(MethodNode mth, IBlock block) {
            if (DotGraphVisitor.this.rawInsn) {
                StringBuilder sb5 = new StringBuilder();
                for (InsnNode insn : block.getInstructions()) {
                    sb5.append(this.escape(insn)).append(DotGraphVisitor.NL);
                }
                return sb5.toString();
            }
            SimpleCodeWriter code = new SimpleCodeWriter();
            List<InsnNode> instructions = block.getInstructions();
            MethodGen.addFallbackInsns(code, mth, instructions.toArray(new InsnNode[0]), MethodGen.FallbackOption.BLOCK_DUMP);
            String str = this.escape(code.newLine().toString());
            if (str.startsWith(DotGraphVisitor.NL)) {
                str = str.substring(DotGraphVisitor.NL.length());
            }
            return str;
        }

        private String escape(Object obj) {
            if (obj == null) {
                return "null";
            }
            return this.escape(obj.toString());
        }

        private String escape(String string) {
            return string.replace("\\", "").replace("/", "\\/").replace(">", "\\>").replace("<", "\\<").replace("{", "\\{").replace("}", "\\}").replace("\"", "\\\"").replace("-", "\\-").replace("|", "\\|").replaceAll("\\R", NLQR);
        }
    }
}

