/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.schedulers.InstantPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import io.reactivex.rxjava3.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewThreadWorker
extends Scheduler.Worker {
    private final ScheduledExecutorService executor;
    volatile boolean disposed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable run) {
        return this.schedule(run, 0L, null);
    }

    @Override
    @NonNull
    public Disposable schedule(@NonNull Runnable action, long delayTime, @NonNull TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.scheduleActual(action, delayTime, unit, null);
    }

    public Disposable scheduleDirect(Runnable run, long delayTime, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(RxJavaPlugins.onSchedule(run), true);
        try {
            Future<Void> f15 = delayTime <= 0L ? this.executor.submit(task) : this.executor.schedule(task, delayTime, unit);
            task.setFuture(f15);
            return task;
        }
        catch (RejectedExecutionException ex4) {
            RxJavaPlugins.onError(ex4);
            return EmptyDisposable.INSTANCE;
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (period <= 0L) {
            InstantPeriodicTask periodicWrapper = new InstantPeriodicTask(decoratedRun, this.executor);
            try {
                Future<Void> f15 = initialDelay <= 0L ? this.executor.submit(periodicWrapper) : this.executor.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.setFirst(f15);
            }
            catch (RejectedExecutionException ex4) {
                RxJavaPlugins.onError(ex4);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, true);
        try {
            ScheduledFuture<?> f16 = this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f16);
            return task;
        }
        catch (RejectedExecutionException ex5) {
            RxJavaPlugins.onError(ex5);
            return EmptyDisposable.INSTANCE;
        }
    }

    @NonNull
    public ScheduledRunnable scheduleActual(Runnable run, long delayTime, @NonNull TimeUnit unit, @Nullable DisposableContainer parent) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr4 = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.add(sr4)) {
            return sr4;
        }
        try {
            Future<Object> f15 = delayTime <= 0L ? this.executor.submit(sr4) : this.executor.schedule(sr4, delayTime, unit);
            sr4.setFuture(f15);
        }
        catch (RejectedExecutionException ex4) {
            if (parent != null) {
                parent.remove(sr4);
            }
            RxJavaPlugins.onError(ex4);
        }
        return sr4;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdownNow();
        }
    }

    public void shutdown() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdown();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

