/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleCreate<T>
extends Single<T> {
    final SingleOnSubscribe<T> source;

    public SingleCreate(SingleOnSubscribe<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        Emitter<T> parent = new Emitter<T>(observer);
        observer.onSubscribe(parent);
        try {
            this.source.subscribe(parent);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            parent.onError(ex4);
        }
    }

    static final class Emitter<T>
    extends AtomicReference<Disposable>
    implements SingleEmitter<T>,
    Disposable {
        private static final long serialVersionUID = -2467358622224974244L;
        final SingleObserver<? super T> downstream;

        Emitter(SingleObserver<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSuccess(T value) {
            Disposable d15;
            if (this.get() != DisposableHelper.DISPOSED && (d15 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    if (value == null) {
                        this.downstream.onError(ExceptionHelper.createNullPointerException("onSuccess called with a null value."));
                    } else {
                        this.downstream.onSuccess(value);
                    }
                }
                finally {
                    if (d15 != null) {
                        d15.dispose();
                    }
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.tryOnError(t15)) {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public boolean tryOnError(Throwable t15) {
            Disposable d15;
            if (t15 == null) {
                t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (this.get() != DisposableHelper.DISPOSED && (d15 = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.downstream.onError(t15);
                }
                finally {
                    if (d15 != null) {
                        d15.dispose();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void setDisposable(Disposable d15) {
            DisposableHelper.set(this, d15);
        }

        @Override
        public void setCancellable(Cancellable c15) {
            this.setDisposable(new CancellableDisposable(c15));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }
}

