/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelJoin<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final int prefetch;
    final boolean delayErrors;

    public ParallelJoin(ParallelFlowable<? extends T> source, int prefetch, boolean delayErrors) {
        this.source = source;
        this.prefetch = prefetch;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        JoinSubscriptionBase parent = this.delayErrors ? new JoinSubscriptionDelayError<T>(s15, this.source.parallelism(), this.prefetch) : new JoinSubscription<T>(s15, this.source.parallelism(), this.prefetch);
        s15.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class JoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 8410034718427740355L;
        final JoinSubscriptionBase<T> parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile SimplePlainQueue<T> queue;

        JoinInnerSubscriber(JoinSubscriptionBase<T> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, this.prefetch);
        }

        @Override
        public void onNext(T t15) {
            this.parent.onNext(this, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.onError(t15);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }

        public void requestOne() {
            long p15 = this.produced + 1L;
            if (p15 == (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p15);
            } else {
                this.produced = p15;
            }
        }

        public void request(long n15) {
            long p15 = this.produced + n15;
            if (p15 >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p15);
            } else {
                this.produced = p15;
            }
        }

        public boolean cancel() {
            return SubscriptionHelper.cancel(this);
        }

        SimplePlainQueue<T> getQueue() {
            SimplePlainQueue<T> q15 = this.queue;
            if (q15 == null) {
                this.queue = q15 = new SpscArrayQueue<T>(this.prefetch);
            }
            return q15;
        }
    }

    static final class JoinSubscriptionDelayError<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = -5737965195918321883L;

        JoinSubscriptionDelayError(Subscriber<? super T> actual, int n15, int prefetch) {
            super(actual, n15, prefetch);
        }

        @Override
        void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    SimplePlainQueue<T> q15 = inner.getQueue();
                    if (!q15.offer(value)) {
                        inner.cancel();
                        this.errors.tryAddThrowableOrReport(new QueueOverflowException());
                        this.done.decrementAndGet();
                        this.drainLoop();
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q16 = inner.getQueue();
                if (!q16.offer(value)) {
                    inner.cancel();
                    this.errors.tryAddThrowableOrReport(new QueueOverflowException());
                    this.done.decrementAndGet();
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        void onError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done.decrementAndGet();
                this.drain();
            }
        }

        @Override
        void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s15 = this.subscribers;
            int n15 = s15.length;
            Subscriber a15 = this.downstream;
            do {
                SimplePlainQueue q15;
                JoinInnerSubscriber inner;
                int i15;
                boolean empty;
                boolean d15;
                long r15 = this.requested.get();
                long e15 = 0L;
                block1: while (e15 != r15) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d15 = this.done.get() == 0;
                    empty = true;
                    for (i15 = 0; i15 < n15; ++i15) {
                        Object v15;
                        inner = s15[i15];
                        q15 = inner.queue;
                        if (q15 == null || (v15 = q15.poll()) == null) continue;
                        empty = false;
                        a15.onNext(v15);
                        inner.requestOne();
                        if (++e15 == r15) break block1;
                    }
                    if (d15 && empty) {
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e15 == r15) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d15 = this.done.get() == 0;
                    empty = true;
                    for (i15 = 0; i15 < n15; ++i15) {
                        inner = s15[i15];
                        q15 = inner.queue;
                        if (q15 == null || q15.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d15 && empty) {
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class JoinSubscription<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = 6312374661811000451L;

        JoinSubscription(Subscriber<? super T> actual, int n15, int prefetch) {
            super(actual, n15, prefetch);
        }

        @Override
        public void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    SimplePlainQueue<T> q15 = inner.getQueue();
                    if (!q15.offer(value)) {
                        this.cancelAll();
                        QueueOverflowException mbe = new QueueOverflowException();
                        if (this.errors.compareAndSet(null, mbe)) {
                            this.downstream.onError(mbe);
                        } else {
                            RxJavaPlugins.onError(mbe);
                        }
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q16 = inner.getQueue();
                if (!q16.offer(value)) {
                    this.cancelAll();
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable e15) {
            if (this.errors.compareAndSet(null, e15)) {
                this.cancelAll();
                this.drain();
            } else if (e15 != this.errors.get()) {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s15 = this.subscribers;
            int n15 = s15.length;
            Subscriber a15 = this.downstream;
            do {
                SimplePlainQueue q15;
                JoinInnerSubscriber inner;
                int i15;
                boolean empty;
                boolean d15;
                Throwable ex4;
                long r15 = this.requested.get();
                long e15 = 0L;
                block1: while (e15 != r15) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex4 = (Throwable)this.errors.get();
                    if (ex4 != null) {
                        this.cleanup();
                        a15.onError(ex4);
                        return;
                    }
                    d15 = this.done.get() == 0;
                    empty = true;
                    for (i15 = 0; i15 < s15.length; ++i15) {
                        Object v15;
                        inner = s15[i15];
                        q15 = inner.queue;
                        if (q15 == null || (v15 = q15.poll()) == null) continue;
                        empty = false;
                        a15.onNext(v15);
                        inner.requestOne();
                        if (++e15 == r15) break block1;
                    }
                    if (d15 && empty) {
                        a15.onComplete();
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e15 == r15) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex4 = (Throwable)this.errors.get();
                    if (ex4 != null) {
                        this.cleanup();
                        a15.onError(ex4);
                        return;
                    }
                    d15 = this.done.get() == 0;
                    empty = true;
                    for (i15 = 0; i15 < n15; ++i15) {
                        inner = s15[i15];
                        q15 = inner.queue;
                        if (q15 == null || q15.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d15 && empty) {
                        a15.onComplete();
                        return;
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static abstract class JoinSubscriptionBase<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3100232009247827843L;
        final Subscriber<? super T> downstream;
        final JoinInnerSubscriber<T>[] subscribers;
        final AtomicThrowable errors = new AtomicThrowable();
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger done = new AtomicInteger();

        JoinSubscriptionBase(Subscriber<? super T> actual, int n15, int prefetch) {
            this.downstream = actual;
            JoinInnerSubscriber[] a15 = new JoinInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                a15[i15] = new JoinInnerSubscriber(this, prefetch);
            }
            this.subscribers = a15;
            this.done.lazySet(n15);
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.cleanup();
                }
            }
        }

        void cancelAll() {
            for (JoinInnerSubscriber<T> s15 : this.subscribers) {
                s15.cancel();
            }
        }

        void cleanup() {
            for (JoinInnerSubscriber<T> s15 : this.subscribers) {
                s15.queue = null;
            }
        }

        abstract void onNext(JoinInnerSubscriber<T> var1, T var2);

        abstract void onError(Throwable var1);

        abstract void onComplete();

        abstract void drain();
    }
}

