/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFromPublisher<T>
extends ParallelFlowable<T> {
    final Publisher<? extends T> source;
    final int parallelism;
    final int prefetch;

    public ParallelFromPublisher(Publisher<? extends T> source, int parallelism, int prefetch) {
        this.source = source;
        this.parallelism = parallelism;
        this.prefetch = prefetch;
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        this.source.subscribe(new ParallelDispatcher<T>(subscribers, this.prefetch));
    }

    static final class ParallelDispatcher<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -4470634016609963609L;
        final Subscriber<? super T>[] subscribers;
        final AtomicLongArray requests;
        final long[] emissions;
        final int prefetch;
        final int limit;
        Subscription upstream;
        SimpleQueue<T> queue;
        Throwable error;
        volatile boolean done;
        int index;
        volatile boolean cancelled;
        final AtomicInteger subscriberCount = new AtomicInteger();
        int produced;
        int sourceMode;

        ParallelDispatcher(Subscriber<? super T>[] subscribers, int prefetch) {
            this.subscribers = subscribers;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            int m15 = subscribers.length;
            this.requests = new AtomicLongArray(m15 + m15 + 1);
            this.requests.lazySet(m15 + m15, m15);
            this.emissions = new long[m15];
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.setupSubscribers();
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.setupSubscribers();
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.setupSubscribers();
                s15.request(this.prefetch);
            }
        }

        void setupSubscribers() {
            Subscriber<? super T>[] subs = this.subscribers;
            int m15 = subs.length;
            for (int i15 = 0; i15 < m15; ++i15) {
                this.subscriberCount.lazySet(i15 + 1);
                subs[i15].onSubscribe(new RailSubscription(i15, m15));
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.sourceMode == 0 && !this.queue.offer(t15)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void cancel(int m15) {
            if (this.requests.decrementAndGet(m15) == 0L) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainAsync() {
            int missed = 1;
            SimpleQueue<T> q15 = this.queue;
            Subscriber<? super T>[] a15 = this.subscribers;
            AtomicLongArray r15 = this.requests;
            long[] e15 = this.emissions;
            int n15 = e15.length;
            int idx = this.index;
            int consumed = this.produced;
            while (true) {
                int w15;
                int notReady = 0;
                do {
                    long emissionAtIndex;
                    Throwable ex4;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && (ex4 = this.error) != null) {
                        q15.clear();
                        for (Subscriber<T> subscriber : a15) {
                            subscriber.onError(ex4);
                        }
                        return;
                    }
                    boolean empty = q15.isEmpty();
                    if (d15 && empty) {
                        for (Subscriber<T> subscriber : a15) {
                            subscriber.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    long requestAtIndex = r15.get(idx);
                    if (requestAtIndex != (emissionAtIndex = e15[idx]) && r15.get(n15 + idx) == 0L) {
                        void v15;
                        try {
                            T v152 = q15.poll();
                        }
                        catch (Throwable ex5) {
                            Exceptions.throwIfFatal(ex5);
                            this.upstream.cancel();
                            for (Subscriber<T> subscriber : a15) {
                                subscriber.onError(ex5);
                            }
                            return;
                        }
                        if (v15 == null) break;
                        a15[idx].onNext(v15);
                        e15[idx] = emissionAtIndex + 1L;
                        int c15 = ++consumed;
                        if (c15 == this.limit) {
                            consumed = 0;
                            this.upstream.request(c15);
                        }
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n15) continue;
                    idx = 0;
                } while (notReady != n15);
                if ((w15 = this.get()) == missed) {
                    this.index = idx;
                    this.produced = consumed;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w15;
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainSync() {
            int missed = 1;
            SimpleQueue<T> q15 = this.queue;
            Subscriber<? super T>[] a15 = this.subscribers;
            AtomicLongArray r15 = this.requests;
            long[] e15 = this.emissions;
            int n15 = e15.length;
            int idx = this.index;
            while (true) {
                int notReady = 0;
                do {
                    long emissionAtIndex;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean empty = q15.isEmpty();
                    if (empty) {
                        for (Subscriber<T> subscriber : a15) {
                            subscriber.onComplete();
                        }
                        return;
                    }
                    long requestAtIndex = r15.get(idx);
                    if (requestAtIndex != (emissionAtIndex = e15[idx]) && r15.get(n15 + idx) == 0L) {
                        void v15;
                        try {
                            T v152 = q15.poll();
                        }
                        catch (Throwable ex4) {
                            void var18_24;
                            Exceptions.throwIfFatal(ex4);
                            this.upstream.cancel();
                            Subscriber<? super T>[] subscriberArray = a15;
                            int n16 = subscriberArray.length;
                            boolean bl4 = false;
                            while (var18_24 < n16) {
                                Subscriber<T> subscriber = subscriberArray[var18_24];
                                subscriber.onError(ex4);
                                ++var18_24;
                            }
                            return;
                        }
                        if (v15 == null) {
                            for (Subscriber<T> subscriber : a15) {
                                subscriber.onComplete();
                            }
                            return;
                        }
                        a15[idx].onNext(v15);
                        e15[idx] = emissionAtIndex + 1L;
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n15) continue;
                    idx = 0;
                } while (notReady != n15);
                int w15 = this.get();
                if (w15 == missed) {
                    this.index = idx;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w15;
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        final class RailSubscription
        implements Subscription {
            final int j;
            final int m;

            RailSubscription(int j15, int m15) {
                this.j = j15;
                this.m = m15;
            }

            @Override
            public void request(long n15) {
                if (SubscriptionHelper.validate(n15)) {
                    long u15;
                    long r15;
                    AtomicLongArray ra5 = ParallelDispatcher.this.requests;
                    do {
                        if ((r15 = ra5.get(this.j)) != Long.MAX_VALUE) continue;
                        return;
                    } while (!ra5.compareAndSet(this.j, r15, u15 = BackpressureHelper.addCap(r15, n15)));
                    if (ParallelDispatcher.this.subscriberCount.get() == this.m) {
                        ParallelDispatcher.this.drain();
                    }
                }
            }

            @Override
            public void cancel() {
                if (ParallelDispatcher.this.requests.compareAndSet(this.m + this.j, 0L, 1L)) {
                    ParallelDispatcher.this.cancel(this.m + this.m);
                }
            }
        }
    }
}

