/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.QueueDrainObserver;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferTimed<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Supplier<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public ObservableBufferTimed(ObservableSource<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Supplier<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t15) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new BufferExactUnboundedObserver(new SerializedObserver<U>(t15), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler.Worker w15 = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new BufferExactBoundedObserver(new SerializedObserver<U>(t15), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w15));
            return;
        }
        this.source.subscribe(new BufferSkipBoundedObserver(new SerializedObserver<U>(t15), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w15));
    }

    static final class BufferExactBoundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final int maxSize;
        final boolean restartTimerOnMaxSize;
        final Scheduler.Worker w;
        U buffer;
        Disposable timer;
        Disposable upstream;
        long producerIndex;
        long consumerIndex;

        BufferExactBoundedObserver(Observer<? super U> actual, Supplier<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler.Worker w15) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartOnMaxSize;
            this.w = w15;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                Collection b15;
                this.upstream = d15;
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    d15.dispose();
                    EmptyDisposable.error(e15, this.downstream);
                    this.w.dispose();
                    return;
                }
                this.buffer = b15;
                this.downstream.onSubscribe(this);
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            Object b15;
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                b15.add(t15);
                if (b15.size() < this.maxSize) {
                    return;
                }
                this.buffer = null;
                ++this.producerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer.dispose();
            }
            this.fastPathOrderedEmit(b15, false, this);
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                this.dispose();
                return;
            }
            bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                this.buffer = b15;
                ++this.consumerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                this.buffer = null;
            }
            this.downstream.onError(t15);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            this.w.dispose();
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                b15 = this.buffer;
                this.buffer = null;
            }
            if (b15 != null) {
                this.queue.offer(b15);
                this.done = true;
                if (this.enter()) {
                    QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this, this);
                }
            }
        }

        @Override
        public void accept(Observer<? super U> a15, U v15) {
            a15.onNext(v15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                this.w.dispose();
                BufferExactBoundedObserver bufferExactBoundedObserver = this;
                synchronized (bufferExactBoundedObserver) {
                    this.buffer = null;
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.dispose();
                this.downstream.onError(e15);
                return;
            }
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                current = this.buffer;
                if (current == null || this.producerIndex != this.consumerIndex) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathOrderedEmit(current, false, this);
        }
    }

    static final class BufferSkipBoundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final List<U> buffers;
        Disposable upstream;

        BufferSkipBoundedObserver(Observer<? super U> actual, Supplier<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker w15) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.w = w15;
            this.buffers = new LinkedList<U>();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                Collection b15;
                this.upstream = d15;
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    d15.dispose();
                    EmptyDisposable.error(e15, this.downstream);
                    this.w.dispose();
                    return;
                }
                this.buffers.add(b15);
                this.downstream.onSubscribe(this);
                this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
                this.w.schedule(new RemoveFromBufferEmit(this, b15), this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                for (Collection b15 : this.buffers) {
                    b15.add(t15);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.done = true;
            this.clear();
            this.downstream.onError(t15);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            ArrayList<U> bs4;
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                bs4 = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            for (Collection b15 : bs4) {
                this.queue.offer(b15);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this.w, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.clear();
                this.upstream.dispose();
                this.w.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                this.buffers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection b15;
            if (this.cancelled) {
                return;
            }
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                this.dispose();
                return;
            }
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b15);
            }
            this.w.schedule(new RemoveFromBuffer(this, b15), this.timespan, this.unit);
        }

        @Override
        public void accept(Observer<? super U> a15, U v15) {
            a15.onNext(v15);
        }

        static final class RemoveFromBufferEmit
        implements Runnable {
            private final U buffer;
            final /* synthetic */ BufferSkipBoundedObserver this$0;

            RemoveFromBufferEmit(U buffer) {
                this.this$0 = this$0;
                this.buffer = buffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedObserver bufferSkipBoundedObserver = this.this$0;
                synchronized (bufferSkipBoundedObserver) {
                    this.this$0.buffers.remove(this.buffer);
                }
                this.this$0.fastPathOrderedEmit(this.buffer, false, this.this$0.w);
            }
        }

        static final class RemoveFromBuffer
        implements Runnable {
            private final U b;
            final /* synthetic */ BufferSkipBoundedObserver this$0;

            RemoveFromBuffer(U b15) {
                this.this$0 = this$0;
                this.b = b15;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedObserver bufferSkipBoundedObserver = this.this$0;
                synchronized (bufferSkipBoundedObserver) {
                    this.this$0.buffers.remove(this.b);
                }
                this.this$0.fastPathOrderedEmit(this.b, false, this.this$0.w);
            }
        }
    }

    static final class BufferExactUnboundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        Disposable upstream;
        U buffer;
        final AtomicReference<Disposable> timer = new AtomicReference();

        BufferExactUnboundedObserver(Observer<? super U> actual, Supplier<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                Collection b15;
                this.upstream = d15;
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.dispose();
                    EmptyDisposable.error(e15, this.downstream);
                    return;
                }
                this.buffer = b15;
                this.downstream.onSubscribe(this);
                if (!DisposableHelper.isDisposed(this.timer.get())) {
                    Disposable task = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                    DisposableHelper.set(this.timer, task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                U b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                b15.add(t15);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                this.buffer = null;
            }
            this.downstream.onError(t15);
            DisposableHelper.dispose(this.timer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                b15 = this.buffer;
                this.buffer = null;
            }
            if (b15 != null) {
                this.queue.offer(b15);
                this.done = true;
                if (this.enter()) {
                    QueueDrainHelper.drainLoop(this.queue, this.downstream, false, null, this);
                }
            }
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.timer);
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.timer.get() == DisposableHelper.DISPOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                this.dispose();
                return;
            }
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                current = this.buffer;
                if (current != null) {
                    this.buffer = next;
                }
            }
            if (current == null) {
                DisposableHelper.dispose(this.timer);
                return;
            }
            this.fastPathEmit(current, false, this);
        }

        @Override
        public void accept(Observer<? super U> a15, U v15) {
            this.downstream.onNext(v15);
        }
    }
}

