/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class MaybeDoOnLifecycle<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Consumer<? super Disposable> onSubscribe;
    final Action onDispose;

    public MaybeDoOnLifecycle(Maybe<T> upstream, Consumer<? super Disposable> onSubscribe, Action onDispose) {
        super(upstream);
        this.onSubscribe = onSubscribe;
        this.onDispose = onDispose;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new MaybeLifecycleObserver<T>(observer, this.onSubscribe, this.onDispose));
    }

    static final class MaybeLifecycleObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final Consumer<? super Disposable> onSubscribe;
        final Action onDispose;
        Disposable upstream;

        MaybeLifecycleObserver(MaybeObserver<? super T> downstream, Consumer<? super Disposable> onSubscribe, Action onDispose) {
            this.downstream = downstream;
            this.onSubscribe = onSubscribe;
            this.onDispose = onDispose;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d15) {
            try {
                this.onSubscribe.accept(d15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                d15.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                EmptyDisposable.error(e15, this.downstream);
                return;
            }
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t15) {
            if (this.upstream != DisposableHelper.DISPOSED) {
                this.upstream = DisposableHelper.DISPOSED;
                this.downstream.onSuccess(t15);
            }
        }

        @Override
        public void onError(@NonNull Throwable e15) {
            if (this.upstream != DisposableHelper.DISPOSED) {
                this.upstream = DisposableHelper.DISPOSED;
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != DisposableHelper.DISPOSED) {
                this.upstream = DisposableHelper.DISPOSED;
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            try {
                this.onDispose.run();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(e15);
            }
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

