/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchIfEmpty<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<? extends T> other;

    public FlowableSwitchIfEmpty(Flowable<T> source, Publisher<? extends T> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        SwitchIfEmptySubscriber<? extends T> parent = new SwitchIfEmptySubscriber<T>(s15, this.other);
        s15.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class SwitchIfEmptySubscriber<T>
    implements FlowableSubscriber<T> {
        final Subscriber<? super T> downstream;
        final Publisher<? extends T> other;
        final SubscriptionArbiter arbiter;
        boolean empty;

        SwitchIfEmptySubscriber(Subscriber<? super T> actual, Publisher<? extends T> other) {
            this.downstream = actual;
            this.other = other;
            this.empty = true;
            this.arbiter = new SubscriptionArbiter(false);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            this.arbiter.setSubscription(s15);
        }

        @Override
        public void onNext(T t15) {
            if (this.empty) {
                this.empty = false;
            }
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.empty) {
                this.empty = false;
                this.other.subscribe(this);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

