/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractBackpressureThrottlingSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableOnBackpressureReduce<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> reducer;

    public FlowableOnBackpressureReduce(@NonNull Flowable<T> source, @NonNull BiFunction<T, T, T> reducer) {
        super(source);
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> s15) {
        this.source.subscribe(new BackpressureReduceSubscriber<T>(s15, this.reducer));
    }

    static final class BackpressureReduceSubscriber<T>
    extends AbstractBackpressureThrottlingSubscriber<T, T> {
        private static final long serialVersionUID = 821363947659780367L;
        final BiFunction<T, T, T> reducer;

        BackpressureReduceSubscriber(@NonNull Subscriber<? super T> downstream, @NonNull BiFunction<T, T, T> reducer) {
            super(downstream);
            this.reducer = reducer;
        }

        @Override
        public void onNext(T t15) {
            Object v15 = this.current.get();
            if (v15 != null) {
                v15 = this.current.getAndSet(null);
            }
            if (v15 == null) {
                this.current.lazySet(t15);
            } else {
                try {
                    this.current.lazySet(Objects.requireNonNull(this.reducer.apply(v15, t15), "The reducer returned a null value"));
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.onError(ex4);
                    return;
                }
            }
            this.drain();
        }
    }
}

