/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.disposables;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class SerialDisposable
implements Disposable {
    final AtomicReference<Disposable> resource;

    public SerialDisposable() {
        this.resource = new AtomicReference();
    }

    public SerialDisposable(@Nullable Disposable initialDisposable) {
        this.resource = new AtomicReference<Disposable>(initialDisposable);
    }

    public boolean set(@Nullable Disposable next) {
        return DisposableHelper.set(this.resource, next);
    }

    public boolean replace(@Nullable Disposable next) {
        return DisposableHelper.replace(this.resource, next);
    }

    @Nullable
    public Disposable get() {
        Disposable d15 = this.resource.get();
        if (d15 == DisposableHelper.DISPOSED) {
            return Disposable.disposed();
        }
        return d15;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed(this.resource.get());
    }
}

