/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.DecodeException;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class PackBitsDecoder
implements Decoder {
    private final boolean disableNoOp;
    private final byte[] sample;
    private boolean reachedEOF;

    public PackBitsDecoder() {
        this(1, false);
    }

    public PackBitsDecoder(boolean bl4) {
        this(1, bl4);
    }

    public PackBitsDecoder(int n15, boolean bl4) {
        this.sample = new byte[n15];
        this.disableNoOp = bl4;
    }

    @Override
    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        int n15 = inputStream.read();
        if (n15 < 0) {
            this.reachedEOF = true;
            return 0;
        }
        byte by = (byte)n15;
        try {
            if (by >= 0) {
                PackBitsDecoder.readFully(inputStream, byteBuffer, this.sample.length * (by + 1));
            } else if (this.disableNoOp || by != -128) {
                int n16;
                for (n16 = 0; n16 < this.sample.length; ++n16) {
                    this.sample[n16] = PackBitsDecoder.readByte(inputStream);
                }
                for (n16 = -by + 1; n16 > 0; --n16) {
                    byteBuffer.put(this.sample);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DecodeException("Error in PackBits decompression, data seems corrupt", indexOutOfBoundsException);
        }
        return byteBuffer.position();
    }

    static byte readByte(InputStream inputStream) throws IOException {
        int n15 = inputStream.read();
        if (n15 < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)n15;
    }

    static void readFully(InputStream inputStream, ByteBuffer byteBuffer, int n15) throws IOException {
        int n16;
        int n17;
        if (n15 < 0) {
            throw new IndexOutOfBoundsException(String.format("Negative length: %d", n15));
        }
        for (n16 = 0; n16 < n15; n16 += n17) {
            n17 = inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n16, n15 - n16);
            if (n17 >= 0) continue;
            throw new EOFException("Unexpected end of PackBits stream");
        }
        byteBuffer.position(byteBuffer.position() + n16);
    }
}

