/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int bytesWritten;

    public LittleEndianDataOutputStream(OutputStream outputStream) {
        super(Validate.notNull(outputStream, "stream"));
    }

    @Override
    public synchronized void write(int n15) throws IOException {
        this.out.write(n15);
        ++this.bytesWritten;
    }

    @Override
    public synchronized void write(byte[] byArray, int n15, int n16) throws IOException {
        this.out.write(byArray, n15, n16);
        this.bytesWritten += n16;
    }

    @Override
    public void writeBoolean(boolean bl4) throws IOException {
        if (bl4) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int n15) throws IOException {
        this.out.write(n15);
        ++this.bytesWritten;
    }

    @Override
    public void writeShort(int n15) throws IOException {
        this.out.write(n15 & 0xFF);
        this.out.write(n15 >>> 8 & 0xFF);
        this.bytesWritten += 2;
    }

    @Override
    public void writeChar(int n15) throws IOException {
        this.out.write(n15 & 0xFF);
        this.out.write(n15 >>> 8 & 0xFF);
        this.bytesWritten += 2;
    }

    @Override
    public void writeInt(int n15) throws IOException {
        this.out.write(n15 & 0xFF);
        this.out.write(n15 >>> 8 & 0xFF);
        this.out.write(n15 >>> 16 & 0xFF);
        this.out.write(n15 >>> 24 & 0xFF);
        this.bytesWritten += 4;
    }

    @Override
    public void writeLong(long l15) throws IOException {
        this.out.write((int)l15 & 0xFF);
        this.out.write((int)(l15 >>> 8) & 0xFF);
        this.out.write((int)(l15 >>> 16) & 0xFF);
        this.out.write((int)(l15 >>> 24) & 0xFF);
        this.out.write((int)(l15 >>> 32) & 0xFF);
        this.out.write((int)(l15 >>> 40) & 0xFF);
        this.out.write((int)(l15 >>> 48) & 0xFF);
        this.out.write((int)(l15 >>> 56) & 0xFF);
        this.bytesWritten += 8;
    }

    @Override
    public final void writeFloat(float f15) throws IOException {
        this.writeInt(Float.floatToIntBits(f15));
    }

    @Override
    public final void writeDouble(double d15) throws IOException {
        this.writeLong(Double.doubleToLongBits(d15));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n15 = string.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            this.out.write((byte)string.charAt(i15));
        }
        this.bytesWritten += n15;
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n15 = string.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            char c15 = string.charAt(i15);
            this.out.write(c15 & 0xFF);
            this.out.write(c15 >>> 8 & 0xFF);
        }
        this.bytesWritten += n15 * 2;
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c15;
        int n15;
        int n16 = string.length();
        int n17 = 0;
        for (n15 = 0; n15 < n16; ++n15) {
            c15 = string.charAt(n15);
            if (c15 >= '\u0001' && c15 <= '\u007f') {
                ++n17;
                continue;
            }
            if (c15 > '\u07ff') {
                n17 += 3;
                continue;
            }
            n17 += 2;
        }
        if (n17 > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(n17 >>> 8 & 0xFF);
        this.out.write(n17 & 0xFF);
        for (n15 = 0; n15 < n16; ++n15) {
            c15 = string.charAt(n15);
            if (c15 >= '\u0001' && c15 <= '\u007f') {
                this.out.write(c15);
                continue;
            }
            if (c15 > '\u07ff') {
                this.out.write(0xE0 | c15 >> 12 & 0xF);
                this.out.write(0x80 | c15 >> 6 & 0x3F);
                this.out.write(0x80 | c15 & 0x3F);
                this.bytesWritten += 2;
                continue;
            }
            this.out.write(0xC0 | c15 >> 6 & 0x1F);
            this.out.write(0x80 | c15 & 0x3F);
            ++this.bytesWritten;
        }
        this.bytesWritten += n16 + 2;
    }

    public int size() {
        return this.bytesWritten;
    }
}

